<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_delete = new receipt_delete();

// Run the page
$receipt_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var freceiptdelete = currentForm = new ew.Form("freceiptdelete", "delete");

// Form_CustomValidate event
freceiptdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceiptdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceiptdelete.lists["x_location"] = <?php echo $receipt_delete->location->Lookup->toClientList() ?>;
freceiptdelete.lists["x_location"].options = <?php echo JsonEncode($receipt_delete->location->lookupOptions()) ?>;
freceiptdelete.lists["x_from_account"] = <?php echo $receipt_delete->from_account->Lookup->toClientList() ?>;
freceiptdelete.lists["x_from_account"].options = <?php echo JsonEncode($receipt_delete->from_account->lookupOptions()) ?>;
freceiptdelete.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceiptdelete.lists["x_reference"] = <?php echo $receipt_delete->reference->Lookup->toClientList() ?>;
freceiptdelete.lists["x_reference"].options = <?php echo JsonEncode($receipt_delete->reference->lookupOptions()) ?>;
freceiptdelete.lists["x_to_account"] = <?php echo $receipt_delete->to_account->Lookup->toClientList() ?>;
freceiptdelete.lists["x_to_account"].options = <?php echo JsonEncode($receipt_delete->to_account->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $receipt_delete->showPageHeader(); ?>
<?php
$receipt_delete->showMessage();
?>
<form name="freceiptdelete" id="freceiptdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($receipt_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($receipt->id->Visible) { // id ?>
		<th class="<?php echo $receipt->id->headerCellClass() ?>"><span id="elh_receipt_id" class="receipt_id"><?php echo $receipt->id->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->location->Visible) { // location ?>
		<th class="<?php echo $receipt->location->headerCellClass() ?>"><span id="elh_receipt_location" class="receipt_location"><?php echo $receipt->location->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->dated->Visible) { // dated ?>
		<th class="<?php echo $receipt->dated->headerCellClass() ?>"><span id="elh_receipt_dated" class="receipt_dated"><?php echo $receipt->dated->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->from_account->Visible) { // from_account ?>
		<th class="<?php echo $receipt->from_account->headerCellClass() ?>"><span id="elh_receipt_from_account" class="receipt_from_account"><?php echo $receipt->from_account->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->reference->Visible) { // reference ?>
		<th class="<?php echo $receipt->reference->headerCellClass() ?>"><span id="elh_receipt_reference" class="receipt_reference"><?php echo $receipt->reference->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->total_amount->Visible) { // total_amount ?>
		<th class="<?php echo $receipt->total_amount->headerCellClass() ?>"><span id="elh_receipt_total_amount" class="receipt_total_amount"><?php echo $receipt->total_amount->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
		<th class="<?php echo $receipt->panel_amount->headerCellClass() ?>"><span id="elh_receipt_panel_amount" class="receipt_panel_amount"><?php echo $receipt->panel_amount->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->amount->Visible) { // amount ?>
		<th class="<?php echo $receipt->amount->headerCellClass() ?>"><span id="elh_receipt_amount" class="receipt_amount"><?php echo $receipt->amount->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->balance->Visible) { // balance ?>
		<th class="<?php echo $receipt->balance->headerCellClass() ?>"><span id="elh_receipt_balance" class="receipt_balance"><?php echo $receipt->balance->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->to_account->Visible) { // to_account ?>
		<th class="<?php echo $receipt->to_account->headerCellClass() ?>"><span id="elh_receipt_to_account" class="receipt_to_account"><?php echo $receipt->to_account->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->remarks->Visible) { // remarks ?>
		<th class="<?php echo $receipt->remarks->headerCellClass() ?>"><span id="elh_receipt_remarks" class="receipt_remarks"><?php echo $receipt->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->operator->Visible) { // operator ?>
		<th class="<?php echo $receipt->operator->headerCellClass() ?>"><span id="elh_receipt_operator" class="receipt_operator"><?php echo $receipt->operator->caption() ?></span></th>
<?php } ?>
<?php if ($receipt->datetime->Visible) { // datetime ?>
		<th class="<?php echo $receipt->datetime->headerCellClass() ?>"><span id="elh_receipt_datetime" class="receipt_datetime"><?php echo $receipt->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$receipt_delete->RecCnt = 0;
$i = 0;
while (!$receipt_delete->Recordset->EOF) {
	$receipt_delete->RecCnt++;
	$receipt_delete->RowCnt++;

	// Set row properties
	$receipt->resetAttributes();
	$receipt->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$receipt_delete->loadRowValues($receipt_delete->Recordset);

	// Render row
	$receipt_delete->renderRow();
?>
	<tr<?php echo $receipt->rowAttributes() ?>>
<?php if ($receipt->id->Visible) { // id ?>
		<td<?php echo $receipt->id->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_id" class="receipt_id">
<span<?php echo $receipt->id->viewAttributes() ?>>
<?php echo $receipt->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->location->Visible) { // location ?>
		<td<?php echo $receipt->location->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_location" class="receipt_location">
<span<?php echo $receipt->location->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->location->getViewValue())) && $receipt->location->linkAttributes() <> "") { ?>
<a<?php echo $receipt->location->linkAttributes() ?>><?php echo $receipt->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($receipt->dated->Visible) { // dated ?>
		<td<?php echo $receipt->dated->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_dated" class="receipt_dated">
<span<?php echo $receipt->dated->viewAttributes() ?>>
<?php echo $receipt->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->from_account->Visible) { // from_account ?>
		<td<?php echo $receipt->from_account->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_from_account" class="receipt_from_account">
<span<?php echo $receipt->from_account->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->from_account->getViewValue())) && $receipt->from_account->linkAttributes() <> "") { ?>
<a<?php echo $receipt->from_account->linkAttributes() ?>><?php echo $receipt->from_account->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->from_account->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($receipt->reference->Visible) { // reference ?>
		<td<?php echo $receipt->reference->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_reference" class="receipt_reference">
<span<?php echo $receipt->reference->viewAttributes() ?>>
<?php echo $receipt->reference->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->total_amount->Visible) { // total_amount ?>
		<td<?php echo $receipt->total_amount->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_total_amount" class="receipt_total_amount">
<span<?php echo $receipt->total_amount->viewAttributes() ?>>
<?php echo $receipt->total_amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
		<td<?php echo $receipt->panel_amount->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_panel_amount" class="receipt_panel_amount">
<span<?php echo $receipt->panel_amount->viewAttributes() ?>>
<?php echo $receipt->panel_amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->amount->Visible) { // amount ?>
		<td<?php echo $receipt->amount->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_amount" class="receipt_amount">
<span<?php echo $receipt->amount->viewAttributes() ?>>
<?php echo $receipt->amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->balance->Visible) { // balance ?>
		<td<?php echo $receipt->balance->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_balance" class="receipt_balance">
<span<?php echo $receipt->balance->viewAttributes() ?>>
<?php echo $receipt->balance->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->to_account->Visible) { // to_account ?>
		<td<?php echo $receipt->to_account->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_to_account" class="receipt_to_account">
<span<?php echo $receipt->to_account->viewAttributes() ?>>
<?php echo $receipt->to_account->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->remarks->Visible) { // remarks ?>
		<td<?php echo $receipt->remarks->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_remarks" class="receipt_remarks">
<span<?php echo $receipt->remarks->viewAttributes() ?>>
<?php echo $receipt->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt->operator->Visible) { // operator ?>
		<td<?php echo $receipt->operator->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_operator" class="receipt_operator">
<span<?php echo $receipt->operator->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->operator->getViewValue())) && $receipt->operator->linkAttributes() <> "") { ?>
<a<?php echo $receipt->operator->linkAttributes() ?>><?php echo $receipt->operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($receipt->datetime->Visible) { // datetime ?>
		<td<?php echo $receipt->datetime->cellAttributes() ?>>
<span id="el<?php echo $receipt_delete->RowCnt ?>_receipt_datetime" class="receipt_datetime">
<span<?php echo $receipt->datetime->viewAttributes() ?>>
<?php echo $receipt->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$receipt_delete->Recordset->moveNext();
}
$receipt_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $receipt_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$receipt_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$receipt_delete->terminate();
?>