<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_edit = new receipt_edit();

// Run the page
$receipt_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var freceiptedit = currentForm = new ew.Form("freceiptedit", "edit");

// Validate form
freceiptedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($receipt_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->id->caption(), $receipt->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->location->caption(), $receipt->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->dated->caption(), $receipt->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->from_account->Required) { ?>
			elm = this.getElements("x" + infix + "_from_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->from_account->caption(), $receipt->from_account->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->reference->Required) { ?>
			elm = this.getElements("x" + infix + "_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->reference->caption(), $receipt->reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->total_amount->caption(), $receipt->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->panel_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_panel_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->panel_amount->caption(), $receipt->panel_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_panel_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt->panel_amount->errorMessage()) ?>");
		<?php if ($receipt_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->amount->caption(), $receipt->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->balance->Required) { ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->balance->caption(), $receipt->balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt->balance->errorMessage()) ?>");
		<?php if ($receipt_edit->to_account->Required) { ?>
			elm = this.getElements("x" + infix + "_to_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->to_account->caption(), $receipt->to_account->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->remarks->caption(), $receipt->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->operator->caption(), $receipt->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->datetime->caption(), $receipt->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
freceiptedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceiptedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceiptedit.lists["x_location"] = <?php echo $receipt_edit->location->Lookup->toClientList() ?>;
freceiptedit.lists["x_location"].options = <?php echo JsonEncode($receipt_edit->location->lookupOptions()) ?>;
freceiptedit.lists["x_from_account"] = <?php echo $receipt_edit->from_account->Lookup->toClientList() ?>;
freceiptedit.lists["x_from_account"].options = <?php echo JsonEncode($receipt_edit->from_account->lookupOptions()) ?>;
freceiptedit.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceiptedit.lists["x_reference"] = <?php echo $receipt_edit->reference->Lookup->toClientList() ?>;
freceiptedit.lists["x_reference"].options = <?php echo JsonEncode($receipt_edit->reference->lookupOptions()) ?>;
freceiptedit.lists["x_to_account"] = <?php echo $receipt_edit->to_account->Lookup->toClientList() ?>;
freceiptedit.lists["x_to_account"].options = <?php echo JsonEncode($receipt_edit->to_account->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $receipt_edit->showPageHeader(); ?>
<?php
$receipt_edit->showMessage();
?>
<form name="freceiptedit" id="freceiptedit" class="<?php echo $receipt_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$receipt_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($receipt->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_receipt_id" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->id->caption() ?><?php echo ($receipt->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->id->cellAttributes() ?>>
<span id="el_receipt_id">
<span<?php echo $receipt->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="receipt" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($receipt->id->CurrentValue) ?>">
<?php echo $receipt->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_receipt_location" for="x_location" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->location->caption() ?><?php echo ($receipt->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->location->cellAttributes() ?>>
<span id="el_receipt_location">
<span<?php echo $receipt->location->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->location->EditValue)) && $receipt->location->linkAttributes() <> "") { ?>
<a<?php echo $receipt->location->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->location->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->location->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="receipt" data-field="x_location" name="x_location" id="x_location" value="<?php echo HtmlEncode($receipt->location->CurrentValue) ?>">
<?php echo $receipt->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_receipt_dated" for="x_dated" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->dated->caption() ?><?php echo ($receipt->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->dated->cellAttributes() ?>>
<span id="el_receipt_dated">
<span<?php echo $receipt->dated->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->dated->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="receipt" data-field="x_dated" name="x_dated" id="x_dated" value="<?php echo HtmlEncode($receipt->dated->CurrentValue) ?>">
<?php echo $receipt->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label id="elh_receipt_from_account" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->from_account->caption() ?><?php echo ($receipt->from_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->from_account->cellAttributes() ?>>
<span id="el_receipt_from_account">
<span<?php echo $receipt->from_account->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->from_account->EditValue)) && $receipt->from_account->linkAttributes() <> "") { ?>
<a<?php echo $receipt->from_account->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->from_account->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->from_account->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="receipt" data-field="x_from_account" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($receipt->from_account->CurrentValue) ?>">
<?php echo $receipt->from_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_receipt_reference" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->reference->caption() ?><?php echo ($receipt->reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->reference->cellAttributes() ?>>
<span id="el_receipt_reference">
<span<?php echo $receipt->reference->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->reference->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="receipt" data-field="x_reference" name="x_reference" id="x_reference" value="<?php echo HtmlEncode($receipt->reference->CurrentValue) ?>">
<?php echo $receipt->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label id="elh_receipt_total_amount" for="x_total_amount" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->total_amount->caption() ?><?php echo ($receipt->total_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->total_amount->cellAttributes() ?>>
<span id="el_receipt_total_amount">
<span<?php echo $receipt->total_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->total_amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="receipt" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" value="<?php echo HtmlEncode($receipt->total_amount->CurrentValue) ?>">
<?php echo $receipt->total_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
	<div id="r_panel_amount" class="form-group row">
		<label id="elh_receipt_panel_amount" for="x_panel_amount" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->panel_amount->caption() ?><?php echo ($receipt->panel_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->panel_amount->cellAttributes() ?>>
<span id="el_receipt_panel_amount">
<input type="text" data-table="receipt" data-field="x_panel_amount" name="x_panel_amount" id="x_panel_amount" size="30" placeholder="<?php echo HtmlEncode($receipt->panel_amount->getPlaceHolder()) ?>" value="<?php echo $receipt->panel_amount->EditValue ?>"<?php echo $receipt->panel_amount->editAttributes() ?>>
</span>
<?php echo $receipt->panel_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_receipt_amount" for="x_amount" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->amount->caption() ?><?php echo ($receipt->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->amount->cellAttributes() ?>>
<span id="el_receipt_amount">
<span<?php echo $receipt->amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="receipt" data-field="x_amount" name="x_amount" id="x_amount" value="<?php echo HtmlEncode($receipt->amount->CurrentValue) ?>">
<?php echo $receipt->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label id="elh_receipt_balance" for="x_balance" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->balance->caption() ?><?php echo ($receipt->balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->balance->cellAttributes() ?>>
<span id="el_receipt_balance">
<input type="text" data-table="receipt" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($receipt->balance->getPlaceHolder()) ?>" value="<?php echo $receipt->balance->EditValue ?>"<?php echo $receipt->balance->editAttributes() ?>>
</span>
<?php echo $receipt->balance->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label id="elh_receipt_to_account" for="x_to_account" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->to_account->caption() ?><?php echo ($receipt->to_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->to_account->cellAttributes() ?>>
<span id="el_receipt_to_account">
<span<?php echo $receipt->to_account->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($receipt->to_account->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="receipt" data-field="x_to_account" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($receipt->to_account->CurrentValue) ?>">
<?php echo $receipt->to_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_receipt_remarks" for="x_remarks" class="<?php echo $receipt_edit->LeftColumnClass ?>"><?php echo $receipt->remarks->caption() ?><?php echo ($receipt->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_edit->RightColumnClass ?>"><div<?php echo $receipt->remarks->cellAttributes() ?>>
<span id="el_receipt_remarks">
<input type="text" data-table="receipt" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($receipt->remarks->getPlaceHolder()) ?>" value="<?php echo $receipt->remarks->EditValue ?>"<?php echo $receipt->remarks->editAttributes() ?>>
</span>
<?php echo $receipt->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$receipt_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $receipt_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $receipt_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$receipt_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var type = $("#x_payment_type").val();
		if(type == 1)
		{
			$("#r_i_no").hide();
			$("#r_i_date").hide();
			$("#r_ref").hide();
		}
		else if(type == 2)
		{
			$("#r_i_no").show();
			$("#r_i_date").show();
			$("#r_ref").hide();
		}
		else if(type == 3)
		{
			$("#r_i_no").hide();
			$("#r_i_date").hide();
			$("#r_ref").show();
		}
		else if(type == 4)
		{
			$("#r_i_no").hide();
			$("#r_i_date").hide();
			$("#r_ref").show();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$receipt_edit->terminate();
?>