<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_list = new receipt_list();

// Run the page
$receipt_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$receipt->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var freceiptlist = currentForm = new ew.Form("freceiptlist", "list");
freceiptlist.formKeyCountName = '<?php echo $receipt_list->FormKeyCountName ?>';

// Form_CustomValidate event
freceiptlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceiptlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceiptlist.lists["x_location"] = <?php echo $receipt_list->location->Lookup->toClientList() ?>;
freceiptlist.lists["x_location"].options = <?php echo JsonEncode($receipt_list->location->lookupOptions()) ?>;
freceiptlist.lists["x_from_account"] = <?php echo $receipt_list->from_account->Lookup->toClientList() ?>;
freceiptlist.lists["x_from_account"].options = <?php echo JsonEncode($receipt_list->from_account->lookupOptions()) ?>;
freceiptlist.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceiptlist.lists["x_reference"] = <?php echo $receipt_list->reference->Lookup->toClientList() ?>;
freceiptlist.lists["x_reference"].options = <?php echo JsonEncode($receipt_list->reference->lookupOptions()) ?>;
freceiptlist.lists["x_to_account"] = <?php echo $receipt_list->to_account->Lookup->toClientList() ?>;
freceiptlist.lists["x_to_account"].options = <?php echo JsonEncode($receipt_list->to_account->lookupOptions()) ?>;

// Form object for search
var freceiptlistsrch = currentSearchForm = new ew.Form("freceiptlistsrch");

// Validate function for search
freceiptlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->from_account->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
freceiptlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceiptlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceiptlistsrch.lists["x_from_account"] = <?php echo $receipt_list->from_account->Lookup->toClientList() ?>;
freceiptlistsrch.lists["x_from_account"].options = <?php echo JsonEncode($receipt_list->from_account->lookupOptions()) ?>;
freceiptlistsrch.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceiptlistsrch.lists["x_to_account"] = <?php echo $receipt_list->to_account->Lookup->toClientList() ?>;
freceiptlistsrch.lists["x_to_account"].options = <?php echo JsonEncode($receipt_list->to_account->lookupOptions()) ?>;

// Filters
freceiptlistsrch.filterList = <?php echo $receipt_list->getFilterList() ?>;

// Init search panel as collapsed
freceiptlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$receipt->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($receipt_list->TotalRecs > 0 && $receipt_list->ExportOptions->visible()) { ?>
<?php $receipt_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($receipt_list->ImportOptions->visible()) { ?>
<?php $receipt_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($receipt_list->SearchOptions->visible()) { ?>
<?php $receipt_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($receipt_list->FilterOptions->visible()) { ?>
<?php $receipt_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$receipt_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$receipt->isExport() && !$receipt->CurrentAction) { ?>
<form name="freceiptlistsrch" id="freceiptlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($receipt_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="freceiptlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="receipt">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$receipt_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$receipt->RowType = ROWTYPE_SEARCH;

// Render row
$receipt->resetAttributes();
$receipt_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($receipt->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $receipt->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="receipt" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($receipt->dated->getPlaceHolder()) ?>" value="<?php echo $receipt->dated->EditValue ?>"<?php echo $receipt->dated->editAttributes() ?>>
<?php if (!$receipt->dated->ReadOnly && !$receipt->dated->Disabled && !isset($receipt->dated->EditAttrs["readonly"]) && !isset($receipt->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceiptlistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="receipt" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($receipt->dated->getPlaceHolder()) ?>" value="<?php echo $receipt->dated->EditValue2 ?>"<?php echo $receipt->dated->editAttributes() ?>>
<?php if (!$receipt->dated->ReadOnly && !$receipt->dated->Disabled && !isset($receipt->dated->EditAttrs["readonly"]) && !isset($receipt->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceiptlistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($receipt->from_account->Visible) { // from_account ?>
	<div id="xsc_from_account" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $receipt->from_account->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_account" id="z_from_account" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$receipt->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($receipt->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt->from_account->getPlaceHolder()) ?>"<?php echo $receipt->from_account->editAttributes() ?>>
</span>
<input type="hidden" data-table="receipt" data-field="x_from_account" data-value-separator="<?php echo $receipt->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($receipt->from_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceiptlistsrch.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $receipt->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($receipt->to_account->Visible) { // to_account ?>
	<div id="xsc_to_account" class="ew-cell form-group">
		<label for="x_to_account" class="ew-search-caption ew-label"><?php echo $receipt->to_account->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_account" id="z_to_account" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="receipt" data-field="x_to_account" data-value-separator="<?php echo $receipt->to_account->displayValueSeparatorAttribute() ?>" id="x_to_account" name="x_to_account"<?php echo $receipt->to_account->editAttributes() ?>>
		<?php echo $receipt->to_account->selectOptionListHtml("x_to_account") ?>
	</select>
</div>
<?php echo $receipt->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($receipt_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($receipt_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $receipt_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($receipt_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($receipt_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($receipt_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($receipt_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $receipt_list->showPageHeader(); ?>
<?php
$receipt_list->showMessage();
?>
<?php if ($receipt_list->TotalRecs > 0 || $receipt->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($receipt_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> receipt">
<?php if (!$receipt->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$receipt->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($receipt_list->Pager)) $receipt_list->Pager = new PrevNextPager($receipt_list->StartRec, $receipt_list->DisplayRecs, $receipt_list->TotalRecs, $receipt_list->AutoHidePager) ?>
<?php if ($receipt_list->Pager->RecordCount > 0 && $receipt_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($receipt_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $receipt_list->pageUrl() ?>start=<?php echo $receipt_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($receipt_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $receipt_list->pageUrl() ?>start=<?php echo $receipt_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $receipt_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($receipt_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $receipt_list->pageUrl() ?>start=<?php echo $receipt_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($receipt_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $receipt_list->pageUrl() ?>start=<?php echo $receipt_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $receipt_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($receipt_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $receipt_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $receipt_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $receipt_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($receipt_list->TotalRecs > 0 && (!$receipt_list->AutoHidePageSizeSelector || $receipt_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="receipt">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($receipt_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($receipt_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($receipt_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($receipt_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($receipt_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($receipt->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $receipt_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="freceiptlist" id="freceiptlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt">
<div id="gmp_receipt" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($receipt_list->TotalRecs > 0 || $receipt->isGridEdit()) { ?>
<table id="tbl_receiptlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$receipt_list->RowType = ROWTYPE_HEADER;

// Render list options
$receipt_list->renderListOptions();

// Render list options (header, left)
$receipt_list->ListOptions->render("header", "left");
?>
<?php if ($receipt->id->Visible) { // id ?>
	<?php if ($receipt->sortUrl($receipt->id) == "") { ?>
		<th data-name="id" class="<?php echo $receipt->id->headerCellClass() ?>"><div id="elh_receipt_id" class="receipt_id"><div class="ew-table-header-caption"><?php echo $receipt->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $receipt->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->id) ?>',2);"><div id="elh_receipt_id" class="receipt_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->location->Visible) { // location ?>
	<?php if ($receipt->sortUrl($receipt->location) == "") { ?>
		<th data-name="location" class="<?php echo $receipt->location->headerCellClass() ?>"><div id="elh_receipt_location" class="receipt_location"><div class="ew-table-header-caption"><?php echo $receipt->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $receipt->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->location) ?>',2);"><div id="elh_receipt_location" class="receipt_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($receipt->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->dated->Visible) { // dated ?>
	<?php if ($receipt->sortUrl($receipt->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $receipt->dated->headerCellClass() ?>"><div id="elh_receipt_dated" class="receipt_dated"><div class="ew-table-header-caption"><?php echo $receipt->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $receipt->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->dated) ?>',2);"><div id="elh_receipt_dated" class="receipt_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->from_account->Visible) { // from_account ?>
	<?php if ($receipt->sortUrl($receipt->from_account) == "") { ?>
		<th data-name="from_account" class="<?php echo $receipt->from_account->headerCellClass() ?>"><div id="elh_receipt_from_account" class="receipt_from_account"><div class="ew-table-header-caption"><?php echo $receipt->from_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from_account" class="<?php echo $receipt->from_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->from_account) ?>',2);"><div id="elh_receipt_from_account" class="receipt_from_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->from_account->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->from_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->from_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->reference->Visible) { // reference ?>
	<?php if ($receipt->sortUrl($receipt->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $receipt->reference->headerCellClass() ?>"><div id="elh_receipt_reference" class="receipt_reference"><div class="ew-table-header-caption"><?php echo $receipt->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $receipt->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->reference) ?>',2);"><div id="elh_receipt_reference" class="receipt_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->reference->caption() ?></span><span class="ew-table-header-sort"><?php if ($receipt->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->total_amount->Visible) { // total_amount ?>
	<?php if ($receipt->sortUrl($receipt->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $receipt->total_amount->headerCellClass() ?>"><div id="elh_receipt_total_amount" class="receipt_total_amount"><div class="ew-table-header-caption"><?php echo $receipt->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $receipt->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->total_amount) ?>',2);"><div id="elh_receipt_total_amount" class="receipt_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->total_amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
	<?php if ($receipt->sortUrl($receipt->panel_amount) == "") { ?>
		<th data-name="panel_amount" class="<?php echo $receipt->panel_amount->headerCellClass() ?>"><div id="elh_receipt_panel_amount" class="receipt_panel_amount"><div class="ew-table-header-caption"><?php echo $receipt->panel_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="panel_amount" class="<?php echo $receipt->panel_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->panel_amount) ?>',2);"><div id="elh_receipt_panel_amount" class="receipt_panel_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->panel_amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->panel_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->panel_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->amount->Visible) { // amount ?>
	<?php if ($receipt->sortUrl($receipt->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $receipt->amount->headerCellClass() ?>"><div id="elh_receipt_amount" class="receipt_amount"><div class="ew-table-header-caption"><?php echo $receipt->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $receipt->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->amount) ?>',2);"><div id="elh_receipt_amount" class="receipt_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->balance->Visible) { // balance ?>
	<?php if ($receipt->sortUrl($receipt->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $receipt->balance->headerCellClass() ?>"><div id="elh_receipt_balance" class="receipt_balance"><div class="ew-table-header-caption"><?php echo $receipt->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $receipt->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->balance) ?>',2);"><div id="elh_receipt_balance" class="receipt_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->to_account->Visible) { // to_account ?>
	<?php if ($receipt->sortUrl($receipt->to_account) == "") { ?>
		<th data-name="to_account" class="<?php echo $receipt->to_account->headerCellClass() ?>"><div id="elh_receipt_to_account" class="receipt_to_account"><div class="ew-table-header-caption"><?php echo $receipt->to_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_account" class="<?php echo $receipt->to_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->to_account) ?>',2);"><div id="elh_receipt_to_account" class="receipt_to_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->to_account->caption() ?></span><span class="ew-table-header-sort"><?php if ($receipt->to_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->to_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->remarks->Visible) { // remarks ?>
	<?php if ($receipt->sortUrl($receipt->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $receipt->remarks->headerCellClass() ?>"><div id="elh_receipt_remarks" class="receipt_remarks"><div class="ew-table-header-caption"><?php echo $receipt->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $receipt->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->remarks) ?>',2);"><div id="elh_receipt_remarks" class="receipt_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->operator->Visible) { // operator ?>
	<?php if ($receipt->sortUrl($receipt->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $receipt->operator->headerCellClass() ?>"><div id="elh_receipt_operator" class="receipt_operator"><div class="ew-table-header-caption"><?php echo $receipt->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $receipt->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->operator) ?>',2);"><div id="elh_receipt_operator" class="receipt_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt->datetime->Visible) { // datetime ?>
	<?php if ($receipt->sortUrl($receipt->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $receipt->datetime->headerCellClass() ?>"><div id="elh_receipt_datetime" class="receipt_datetime"><div class="ew-table-header-caption"><?php echo $receipt->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $receipt->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt->SortUrl($receipt->datetime) ?>',2);"><div id="elh_receipt_datetime" class="receipt_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$receipt_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($receipt->ExportAll && $receipt->isExport()) {
	$receipt_list->StopRec = $receipt_list->TotalRecs;
} else {

	// Set the last record to display
	if ($receipt_list->TotalRecs > $receipt_list->StartRec + $receipt_list->DisplayRecs - 1)
		$receipt_list->StopRec = $receipt_list->StartRec + $receipt_list->DisplayRecs - 1;
	else
		$receipt_list->StopRec = $receipt_list->TotalRecs;
}
$receipt_list->RecCnt = $receipt_list->StartRec - 1;
if ($receipt_list->Recordset && !$receipt_list->Recordset->EOF) {
	$receipt_list->Recordset->moveFirst();
	$selectLimit = $receipt_list->UseSelectLimit;
	if (!$selectLimit && $receipt_list->StartRec > 1)
		$receipt_list->Recordset->move($receipt_list->StartRec - 1);
} elseif (!$receipt->AllowAddDeleteRow && $receipt_list->StopRec == 0) {
	$receipt_list->StopRec = $receipt->GridAddRowCount;
}

// Initialize aggregate
$receipt->RowType = ROWTYPE_AGGREGATEINIT;
$receipt->resetAttributes();
$receipt_list->renderRow();
while ($receipt_list->RecCnt < $receipt_list->StopRec) {
	$receipt_list->RecCnt++;
	if ($receipt_list->RecCnt >= $receipt_list->StartRec) {
		$receipt_list->RowCnt++;

		// Set up key count
		$receipt_list->KeyCount = $receipt_list->RowIndex;

		// Init row class and style
		$receipt->resetAttributes();
		$receipt->CssClass = "";
		if ($receipt->isGridAdd()) {
		} else {
			$receipt_list->loadRowValues($receipt_list->Recordset); // Load row values
		}
		$receipt->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$receipt->RowAttrs = array_merge($receipt->RowAttrs, array('data-rowindex'=>$receipt_list->RowCnt, 'id'=>'r' . $receipt_list->RowCnt . '_receipt', 'data-rowtype'=>$receipt->RowType));

		// Render row
		$receipt_list->renderRow();

		// Render list options
		$receipt_list->renderListOptions();
?>
	<tr<?php echo $receipt->rowAttributes() ?>>
<?php

// Render list options (body, left)
$receipt_list->ListOptions->render("body", "left", $receipt_list->RowCnt);
?>
	<?php if ($receipt->id->Visible) { // id ?>
		<td data-name="id"<?php echo $receipt->id->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_id" class="receipt_id">
<span<?php echo $receipt->id->viewAttributes() ?>>
<?php echo $receipt->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->location->Visible) { // location ?>
		<td data-name="location"<?php echo $receipt->location->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_location" class="receipt_location">
<span<?php echo $receipt->location->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->location->getViewValue())) && $receipt->location->linkAttributes() <> "") { ?>
<a<?php echo $receipt->location->linkAttributes() ?>><?php echo $receipt->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $receipt->dated->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_dated" class="receipt_dated">
<span<?php echo $receipt->dated->viewAttributes() ?>>
<?php echo $receipt->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->from_account->Visible) { // from_account ?>
		<td data-name="from_account"<?php echo $receipt->from_account->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_from_account" class="receipt_from_account">
<span<?php echo $receipt->from_account->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->from_account->getViewValue())) && $receipt->from_account->linkAttributes() <> "") { ?>
<a<?php echo $receipt->from_account->linkAttributes() ?>><?php echo $receipt->from_account->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->from_account->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $receipt->reference->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_reference" class="receipt_reference">
<span<?php echo $receipt->reference->viewAttributes() ?>>
<?php echo $receipt->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $receipt->total_amount->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_total_amount" class="receipt_total_amount">
<span<?php echo $receipt->total_amount->viewAttributes() ?>>
<?php echo $receipt->total_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount"<?php echo $receipt->panel_amount->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_panel_amount" class="receipt_panel_amount">
<span<?php echo $receipt->panel_amount->viewAttributes() ?>>
<?php echo $receipt->panel_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $receipt->amount->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_amount" class="receipt_amount">
<span<?php echo $receipt->amount->viewAttributes() ?>>
<?php echo $receipt->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $receipt->balance->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_balance" class="receipt_balance">
<span<?php echo $receipt->balance->viewAttributes() ?>>
<?php echo $receipt->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->to_account->Visible) { // to_account ?>
		<td data-name="to_account"<?php echo $receipt->to_account->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_to_account" class="receipt_to_account">
<span<?php echo $receipt->to_account->viewAttributes() ?>>
<?php echo $receipt->to_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $receipt->remarks->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_remarks" class="receipt_remarks">
<span<?php echo $receipt->remarks->viewAttributes() ?>>
<?php echo $receipt->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $receipt->operator->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_operator" class="receipt_operator">
<span<?php echo $receipt->operator->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->operator->getViewValue())) && $receipt->operator->linkAttributes() <> "") { ?>
<a<?php echo $receipt->operator->linkAttributes() ?>><?php echo $receipt->operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $receipt->datetime->cellAttributes() ?>>
<span id="el<?php echo $receipt_list->RowCnt ?>_receipt_datetime" class="receipt_datetime">
<span<?php echo $receipt->datetime->viewAttributes() ?>>
<?php echo $receipt->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$receipt_list->ListOptions->render("body", "right", $receipt_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$receipt->isGridAdd())
		$receipt_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$receipt->RowType = ROWTYPE_AGGREGATE;
$receipt->resetAttributes();
$receipt_list->renderRow();
?>
<?php if ($receipt_list->TotalRecs > 0 && !$receipt->isGridAdd() && !$receipt->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$receipt_list->renderListOptions();

// Render list options (footer, left)
$receipt_list->ListOptions->render("footer", "left");
?>
	<?php if ($receipt->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $receipt->id->footerCellClass() ?>"><span id="elf_receipt_id" class="receipt_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $receipt->location->footerCellClass() ?>"><span id="elf_receipt_location" class="receipt_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $receipt->dated->footerCellClass() ?>"><span id="elf_receipt_dated" class="receipt_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt->from_account->Visible) { // from_account ?>
		<td data-name="from_account" class="<?php echo $receipt->from_account->footerCellClass() ?>"><span id="elf_receipt_from_account" class="receipt_from_account">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt->reference->Visible) { // reference ?>
		<td data-name="reference" class="<?php echo $receipt->reference->footerCellClass() ?>"><span id="elf_receipt_reference" class="receipt_reference">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount" class="<?php echo $receipt->total_amount->footerCellClass() ?>"><span id="elf_receipt_total_amount" class="receipt_total_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $receipt->total_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
		<td data-name="panel_amount" class="<?php echo $receipt->panel_amount->footerCellClass() ?>"><span id="elf_receipt_panel_amount" class="receipt_panel_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $receipt->panel_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($receipt->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $receipt->amount->footerCellClass() ?>"><span id="elf_receipt_amount" class="receipt_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $receipt->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($receipt->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $receipt->balance->footerCellClass() ?>"><span id="elf_receipt_balance" class="receipt_balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $receipt->balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($receipt->to_account->Visible) { // to_account ?>
		<td data-name="to_account" class="<?php echo $receipt->to_account->footerCellClass() ?>"><span id="elf_receipt_to_account" class="receipt_to_account">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $receipt->remarks->footerCellClass() ?>"><span id="elf_receipt_remarks" class="receipt_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $receipt->operator->footerCellClass() ?>"><span id="elf_receipt_operator" class="receipt_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $receipt->datetime->footerCellClass() ?>"><span id="elf_receipt_datetime" class="receipt_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$receipt_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$receipt->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($receipt_list->Recordset)
	$receipt_list->Recordset->Close();
?>
<?php if (!$receipt->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$receipt->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($receipt_list->Pager)) $receipt_list->Pager = new PrevNextPager($receipt_list->StartRec, $receipt_list->DisplayRecs, $receipt_list->TotalRecs, $receipt_list->AutoHidePager) ?>
<?php if ($receipt_list->Pager->RecordCount > 0 && $receipt_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($receipt_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $receipt_list->pageUrl() ?>start=<?php echo $receipt_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($receipt_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $receipt_list->pageUrl() ?>start=<?php echo $receipt_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $receipt_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($receipt_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $receipt_list->pageUrl() ?>start=<?php echo $receipt_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($receipt_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $receipt_list->pageUrl() ?>start=<?php echo $receipt_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $receipt_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($receipt_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $receipt_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $receipt_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $receipt_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($receipt_list->TotalRecs > 0 && (!$receipt_list->AutoHidePageSizeSelector || $receipt_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="receipt">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($receipt_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($receipt_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($receipt_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($receipt_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($receipt_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($receipt->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $receipt_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($receipt_list->TotalRecs == 0 && !$receipt->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $receipt_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$receipt_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$receipt->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$receipt->isExport()) { ?>
<script>
ew.scrollableTable("gmp_receipt", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$receipt_list->terminate();
?>