<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_search = new receipt_search();

// Run the page
$receipt_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($receipt_search->IsModal) { ?>
var freceiptsearch = currentAdvancedSearchForm = new ew.Form("freceiptsearch", "search");
<?php } else { ?>
var freceiptsearch = currentForm = new ew.Form("freceiptsearch", "search");
<?php } ?>

// Form_CustomValidate event
freceiptsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceiptsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceiptsearch.lists["x_location"] = <?php echo $receipt_search->location->Lookup->toClientList() ?>;
freceiptsearch.lists["x_location"].options = <?php echo JsonEncode($receipt_search->location->lookupOptions()) ?>;
freceiptsearch.lists["x_from_account"] = <?php echo $receipt_search->from_account->Lookup->toClientList() ?>;
freceiptsearch.lists["x_from_account"].options = <?php echo JsonEncode($receipt_search->from_account->lookupOptions()) ?>;
freceiptsearch.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceiptsearch.lists["x_reference"] = <?php echo $receipt_search->reference->Lookup->toClientList() ?>;
freceiptsearch.lists["x_reference"].options = <?php echo JsonEncode($receipt_search->reference->lookupOptions()) ?>;
freceiptsearch.lists["x_to_account"] = <?php echo $receipt_search->to_account->Lookup->toClientList() ?>;
freceiptsearch.lists["x_to_account"].options = <?php echo JsonEncode($receipt_search->to_account->lookupOptions()) ?>;

// Form object for search
// Validate function for search

freceiptsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->from_account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->total_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_panel_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->panel_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $receipt_search->showPageHeader(); ?>
<?php
$receipt_search->showMessage();
?>
<form name="freceiptsearch" id="freceiptsearch" class="<?php echo $receipt_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$receipt_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($receipt->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_id"><?php echo $receipt->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->id->cellAttributes() ?>>
			<span id="el_receipt_id">
<input type="text" data-table="receipt" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($receipt->id->getPlaceHolder()) ?>" value="<?php echo $receipt->id->EditValue ?>"<?php echo $receipt->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_location"><?php echo $receipt->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->location->cellAttributes() ?>>
			<span id="el_receipt_location">
<?php $receipt->location->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$receipt->location->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="receipt" data-field="x_location" data-value-separator="<?php echo $receipt->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $receipt->location->editAttributes() ?>>
		<?php echo $receipt->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $receipt->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_dated"><?php echo $receipt->dated->caption() ?></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($receipt->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_receipt_dated">
<input type="text" data-table="receipt" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($receipt->dated->getPlaceHolder()) ?>" value="<?php echo $receipt->dated->EditValue ?>"<?php echo $receipt->dated->editAttributes() ?>>
<?php if (!$receipt->dated->ReadOnly && !$receipt->dated->Disabled && !isset($receipt->dated->EditAttrs["readonly"]) && !isset($receipt->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceiptsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_receipt_dated" class="btw1_dated d-none">
<input type="text" data-table="receipt" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($receipt->dated->getPlaceHolder()) ?>" value="<?php echo $receipt->dated->EditValue2 ?>"<?php echo $receipt->dated->editAttributes() ?>>
<?php if (!$receipt->dated->ReadOnly && !$receipt->dated->Disabled && !isset($receipt->dated->EditAttrs["readonly"]) && !isset($receipt->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceiptsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_from_account"><?php echo $receipt->from_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_account" id="z_from_account" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->from_account->cellAttributes() ?>>
			<span id="el_receipt_from_account">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$receipt->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($receipt->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt->from_account->getPlaceHolder()) ?>"<?php echo $receipt->from_account->editAttributes() ?>>
</span>
<input type="hidden" data-table="receipt" data-field="x_from_account" data-value-separator="<?php echo $receipt->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($receipt->from_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceiptsearch.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $receipt->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_reference"><?php echo $receipt->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reference" id="z_reference" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->reference->cellAttributes() ?>>
			<span id="el_receipt_reference">
<div id="tp_x_reference" class="ew-template"><input type="radio" class="form-check-input" data-table="receipt" data-field="x_reference" data-value-separator="<?php echo $receipt->reference->displayValueSeparatorAttribute() ?>" name="x_reference" id="x_reference" value="{value}"<?php echo $receipt->reference->editAttributes() ?>></div>
<div id="dsl_x_reference" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $receipt->reference->radioButtonListHtml(FALSE, "x_reference") ?>
</div></div>
<?php echo $receipt->reference->Lookup->getParamTag("p_x_reference") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_total_amount"><?php echo $receipt->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->total_amount->cellAttributes() ?>>
			<span id="el_receipt_total_amount">
<input type="text" data-table="receipt" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($receipt->total_amount->getPlaceHolder()) ?>" value="<?php echo $receipt->total_amount->EditValue ?>"<?php echo $receipt->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
	<div id="r_panel_amount" class="form-group row">
		<label for="x_panel_amount" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_panel_amount"><?php echo $receipt->panel_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_panel_amount" id="z_panel_amount" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->panel_amount->cellAttributes() ?>>
			<span id="el_receipt_panel_amount">
<input type="text" data-table="receipt" data-field="x_panel_amount" name="x_panel_amount" id="x_panel_amount" size="30" placeholder="<?php echo HtmlEncode($receipt->panel_amount->getPlaceHolder()) ?>" value="<?php echo $receipt->panel_amount->EditValue ?>"<?php echo $receipt->panel_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_amount"><?php echo $receipt->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->amount->cellAttributes() ?>>
			<span id="el_receipt_amount">
<input type="text" data-table="receipt" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($receipt->amount->getPlaceHolder()) ?>" value="<?php echo $receipt->amount->EditValue ?>"<?php echo $receipt->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_balance"><?php echo $receipt->balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance" id="z_balance" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->balance->cellAttributes() ?>>
			<span id="el_receipt_balance">
<input type="text" data-table="receipt" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($receipt->balance->getPlaceHolder()) ?>" value="<?php echo $receipt->balance->EditValue ?>"<?php echo $receipt->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label for="x_to_account" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_to_account"><?php echo $receipt->to_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_account" id="z_to_account" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->to_account->cellAttributes() ?>>
			<span id="el_receipt_to_account">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="receipt" data-field="x_to_account" data-value-separator="<?php echo $receipt->to_account->displayValueSeparatorAttribute() ?>" id="x_to_account" name="x_to_account"<?php echo $receipt->to_account->editAttributes() ?>>
		<?php echo $receipt->to_account->selectOptionListHtml("x_to_account") ?>
	</select>
</div>
<?php echo $receipt->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_remarks"><?php echo $receipt->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->remarks->cellAttributes() ?>>
			<span id="el_receipt_remarks">
<input type="text" data-table="receipt" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($receipt->remarks->getPlaceHolder()) ?>" value="<?php echo $receipt->remarks->EditValue ?>"<?php echo $receipt->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_operator"><?php echo $receipt->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->operator->cellAttributes() ?>>
			<span id="el_receipt_operator">
<input type="text" data-table="receipt" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($receipt->operator->getPlaceHolder()) ?>" value="<?php echo $receipt->operator->EditValue ?>"<?php echo $receipt->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $receipt_search->LeftColumnClass ?>"><span id="elh_receipt_datetime"><?php echo $receipt->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $receipt_search->RightColumnClass ?>"><div<?php echo $receipt->datetime->cellAttributes() ?>>
			<span id="el_receipt_datetime">
<input type="text" data-table="receipt" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($receipt->datetime->getPlaceHolder()) ?>" value="<?php echo $receipt->datetime->EditValue ?>"<?php echo $receipt->datetime->editAttributes() ?>>
<?php if (!$receipt->datetime->ReadOnly && !$receipt->datetime->Disabled && !isset($receipt->datetime->EditAttrs["readonly"]) && !isset($receipt->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceiptsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$receipt_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $receipt_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$receipt_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$receipt_search->terminate();
?>