<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_view = new receipt_view();

// Run the page
$receipt_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$receipt->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var freceiptview = currentForm = new ew.Form("freceiptview", "view");

// Form_CustomValidate event
freceiptview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceiptview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceiptview.lists["x_location"] = <?php echo $receipt_view->location->Lookup->toClientList() ?>;
freceiptview.lists["x_location"].options = <?php echo JsonEncode($receipt_view->location->lookupOptions()) ?>;
freceiptview.lists["x_from_account"] = <?php echo $receipt_view->from_account->Lookup->toClientList() ?>;
freceiptview.lists["x_from_account"].options = <?php echo JsonEncode($receipt_view->from_account->lookupOptions()) ?>;
freceiptview.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceiptview.lists["x_reference"] = <?php echo $receipt_view->reference->Lookup->toClientList() ?>;
freceiptview.lists["x_reference"].options = <?php echo JsonEncode($receipt_view->reference->lookupOptions()) ?>;
freceiptview.lists["x_to_account"] = <?php echo $receipt_view->to_account->Lookup->toClientList() ?>;
freceiptview.lists["x_to_account"].options = <?php echo JsonEncode($receipt_view->to_account->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$receipt->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $receipt_view->ExportOptions->render("body") ?>
<?php $receipt_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $receipt_view->showPageHeader(); ?>
<?php
$receipt_view->showMessage();
?>
<form name="freceiptview" id="freceiptview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt">
<input type="hidden" name="modal" value="<?php echo (int)$receipt_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($receipt->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_id"><?php echo $receipt->id->caption() ?></span></td>
		<td data-name="id"<?php echo $receipt->id->cellAttributes() ?>>
<span id="el_receipt_id">
<span<?php echo $receipt->id->viewAttributes() ?>>
<?php echo $receipt->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_location"><?php echo $receipt->location->caption() ?></span></td>
		<td data-name="location"<?php echo $receipt->location->cellAttributes() ?>>
<span id="el_receipt_location">
<span<?php echo $receipt->location->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->location->getViewValue())) && $receipt->location->linkAttributes() <> "") { ?>
<a<?php echo $receipt->location->linkAttributes() ?>><?php echo $receipt->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_dated"><?php echo $receipt->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $receipt->dated->cellAttributes() ?>>
<span id="el_receipt_dated">
<span<?php echo $receipt->dated->viewAttributes() ?>>
<?php echo $receipt->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->from_account->Visible) { // from_account ?>
	<tr id="r_from_account">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_from_account"><?php echo $receipt->from_account->caption() ?></span></td>
		<td data-name="from_account"<?php echo $receipt->from_account->cellAttributes() ?>>
<span id="el_receipt_from_account">
<span<?php echo $receipt->from_account->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->from_account->getViewValue())) && $receipt->from_account->linkAttributes() <> "") { ?>
<a<?php echo $receipt->from_account->linkAttributes() ?>><?php echo $receipt->from_account->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->from_account->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->reference->Visible) { // reference ?>
	<tr id="r_reference">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_reference"><?php echo $receipt->reference->caption() ?></span></td>
		<td data-name="reference"<?php echo $receipt->reference->cellAttributes() ?>>
<span id="el_receipt_reference">
<span<?php echo $receipt->reference->viewAttributes() ?>>
<?php echo $receipt->reference->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->total_amount->Visible) { // total_amount ?>
	<tr id="r_total_amount">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_total_amount"><?php echo $receipt->total_amount->caption() ?></span></td>
		<td data-name="total_amount"<?php echo $receipt->total_amount->cellAttributes() ?>>
<span id="el_receipt_total_amount">
<span<?php echo $receipt->total_amount->viewAttributes() ?>>
<?php echo $receipt->total_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->panel_pending->Visible) { // panel_pending ?>
	<tr id="r_panel_pending">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_panel_pending"><?php echo $receipt->panel_pending->caption() ?></span></td>
		<td data-name="panel_pending"<?php echo $receipt->panel_pending->cellAttributes() ?>>
<span id="el_receipt_panel_pending">
<span<?php echo $receipt->panel_pending->viewAttributes() ?>>
<?php echo $receipt->panel_pending->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
	<tr id="r_panel_amount">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_panel_amount"><?php echo $receipt->panel_amount->caption() ?></span></td>
		<td data-name="panel_amount"<?php echo $receipt->panel_amount->cellAttributes() ?>>
<span id="el_receipt_panel_amount">
<span<?php echo $receipt->panel_amount->viewAttributes() ?>>
<?php echo $receipt->panel_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_amount"><?php echo $receipt->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $receipt->amount->cellAttributes() ?>>
<span id="el_receipt_amount">
<span<?php echo $receipt->amount->viewAttributes() ?>>
<?php echo $receipt->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->balance->Visible) { // balance ?>
	<tr id="r_balance">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_balance"><?php echo $receipt->balance->caption() ?></span></td>
		<td data-name="balance"<?php echo $receipt->balance->cellAttributes() ?>>
<span id="el_receipt_balance">
<span<?php echo $receipt->balance->viewAttributes() ?>>
<?php echo $receipt->balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->to_account->Visible) { // to_account ?>
	<tr id="r_to_account">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_to_account"><?php echo $receipt->to_account->caption() ?></span></td>
		<td data-name="to_account"<?php echo $receipt->to_account->cellAttributes() ?>>
<span id="el_receipt_to_account">
<span<?php echo $receipt->to_account->viewAttributes() ?>>
<?php echo $receipt->to_account->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_remarks"><?php echo $receipt->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $receipt->remarks->cellAttributes() ?>>
<span id="el_receipt_remarks">
<span<?php echo $receipt->remarks->viewAttributes() ?>>
<?php echo $receipt->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_operator"><?php echo $receipt->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $receipt->operator->cellAttributes() ?>>
<span id="el_receipt_operator">
<span<?php echo $receipt->operator->viewAttributes() ?>>
<?php if ((!EmptyString($receipt->operator->getViewValue())) && $receipt->operator->linkAttributes() <> "") { ?>
<a<?php echo $receipt->operator->linkAttributes() ?>><?php echo $receipt->operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $receipt->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($receipt->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $receipt_view->TableLeftColumnClass ?>"><span id="elh_receipt_datetime"><?php echo $receipt->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $receipt->datetime->cellAttributes() ?>>
<span id="el_receipt_datetime">
<span<?php echo $receipt->datetime->viewAttributes() ?>>
<?php echo $receipt->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$receipt_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$receipt->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$receipt_view->terminate();
?>