<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_f_add = new ref_f_add();

// Run the page
$ref_f_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_f_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fref_fadd = currentForm = new ew.Form("fref_fadd", "add");

// Validate form
fref_fadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ref_f_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_f->grp->caption(), $ref_f->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_f_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_f->s_grp->caption(), $ref_f->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_f_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_f->product->caption(), $ref_f->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_f_add->last_price->Required) { ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_f->last_price->caption(), $ref_f->last_price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref_f->last_price->errorMessage()) ?>");
		<?php if ($ref_f_add->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_f->image->caption(), $ref_f->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_f_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_f->operator->caption(), $ref_f->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_f_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_f->datetime->caption(), $ref_f->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fref_fadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_fadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_fadd.lists["x_grp"] = <?php echo $ref_f_add->grp->Lookup->toClientList() ?>;
fref_fadd.lists["x_grp"].options = <?php echo JsonEncode($ref_f_add->grp->options(FALSE, TRUE)) ?>;
fref_fadd.lists["x_s_grp"] = <?php echo $ref_f_add->s_grp->Lookup->toClientList() ?>;
fref_fadd.lists["x_s_grp"].options = <?php echo JsonEncode($ref_f_add->s_grp->lookupOptions()) ?>;
fref_fadd.lists["x_product"] = <?php echo $ref_f_add->product->Lookup->toClientList() ?>;
fref_fadd.lists["x_product"].options = <?php echo JsonEncode($ref_f_add->product->lookupOptions()) ?>;
fref_fadd.lists["x_operator"] = <?php echo $ref_f_add->operator->Lookup->toClientList() ?>;
fref_fadd.lists["x_operator"].options = <?php echo JsonEncode($ref_f_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_f_add->showPageHeader(); ?>
<?php
$ref_f_add->showMessage();
?>
<form name="fref_fadd" id="fref_fadd" class="<?php echo $ref_f_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_f_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_f_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_f">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$ref_f_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($ref_f->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_ref_f_grp" for="x_grp" class="<?php echo $ref_f_add->LeftColumnClass ?>"><?php echo $ref_f->grp->caption() ?><?php echo ($ref_f->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_f_add->RightColumnClass ?>"><div<?php echo $ref_f->grp->cellAttributes() ?>>
<span id="el_ref_f_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_f" data-field="x_grp" data-value-separator="<?php echo $ref_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref_f->grp->editAttributes() ?>>
		<?php echo $ref_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $ref_f->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_f->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_ref_f_s_grp" for="x_s_grp" class="<?php echo $ref_f_add->LeftColumnClass ?>"><?php echo $ref_f->s_grp->caption() ?><?php echo ($ref_f->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_f_add->RightColumnClass ?>"><div<?php echo $ref_f->s_grp->cellAttributes() ?>>
<span id="el_ref_f_s_grp">
<?php $ref_f->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_f->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_f" data-field="x_s_grp" data-value-separator="<?php echo $ref_f->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref_f->s_grp->editAttributes() ?>>
		<?php echo $ref_f->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $ref_f->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_ref_f_product" for="x_product" class="<?php echo $ref_f_add->LeftColumnClass ?>"><?php echo $ref_f->product->caption() ?><?php echo ($ref_f->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_f_add->RightColumnClass ?>"><div<?php echo $ref_f->product->cellAttributes() ?>>
<span id="el_ref_f_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_f" data-field="x_product" data-value-separator="<?php echo $ref_f->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref_f->product->editAttributes() ?>>
		<?php echo $ref_f->product->selectOptionListHtml("x_product") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "product_f") && !$ref_f->product->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $ref_f->product->caption() ?>" data-title="<?php echo $ref_f->product->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_product',url:'product_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $ref_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $ref_f->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_f->last_price->Visible) { // last_price ?>
	<div id="r_last_price" class="form-group row">
		<label id="elh_ref_f_last_price" for="x_last_price" class="<?php echo $ref_f_add->LeftColumnClass ?>"><?php echo $ref_f->last_price->caption() ?><?php echo ($ref_f->last_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_f_add->RightColumnClass ?>"><div<?php echo $ref_f->last_price->cellAttributes() ?>>
<span id="el_ref_f_last_price">
<input type="text" data-table="ref_f" data-field="x_last_price" name="x_last_price" id="x_last_price" size="30" placeholder="<?php echo HtmlEncode($ref_f->last_price->getPlaceHolder()) ?>" value="<?php echo $ref_f->last_price->EditValue ?>"<?php echo $ref_f->last_price->editAttributes() ?>>
</span>
<?php echo $ref_f->last_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_f->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_ref_f_image" class="<?php echo $ref_f_add->LeftColumnClass ?>"><?php echo $ref_f->image->caption() ?><?php echo ($ref_f->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_f_add->RightColumnClass ?>"><div<?php echo $ref_f->image->cellAttributes() ?>>
<span id="el_ref_f_image">
<div id="fd_x_image">
<span title="<?php echo $ref_f->image->title() ? $ref_f->image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_f->image->ReadOnly || $ref_f->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_f" data-field="x_image" name="x_image" id="x_image" multiple="multiple"<?php echo $ref_f->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $ref_f->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="255">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $ref_f->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $ref_f->image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_image" id= "fc_x_image" value="<?php echo $ref_f->image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_f->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ref_f_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ref_f_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ref_f_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ref_f_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ref_f_add->terminate();
?>