<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_f_list = new ref_f_list();

// Run the page
$ref_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ref_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fref_flist = currentForm = new ew.Form("fref_flist", "list");
fref_flist.formKeyCountName = '<?php echo $ref_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fref_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_flist.lists["x_s_grp"] = <?php echo $ref_f_list->s_grp->Lookup->toClientList() ?>;
fref_flist.lists["x_s_grp"].options = <?php echo JsonEncode($ref_f_list->s_grp->lookupOptions()) ?>;
fref_flist.lists["x_product"] = <?php echo $ref_f_list->product->Lookup->toClientList() ?>;
fref_flist.lists["x_product"].options = <?php echo JsonEncode($ref_f_list->product->lookupOptions()) ?>;
fref_flist.lists["x_operator"] = <?php echo $ref_f_list->operator->Lookup->toClientList() ?>;
fref_flist.lists["x_operator"].options = <?php echo JsonEncode($ref_f_list->operator->lookupOptions()) ?>;

// Form object for search
var fref_flistsrch = currentSearchForm = new ew.Form("fref_flistsrch");

// Filters
fref_flistsrch.filterList = <?php echo $ref_f_list->getFilterList() ?>;

// Init search panel as collapsed
fref_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ref_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ref_f_list->TotalRecs > 0 && $ref_f_list->ExportOptions->visible()) { ?>
<?php $ref_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ref_f_list->ImportOptions->visible()) { ?>
<?php $ref_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ref_f_list->SearchOptions->visible()) { ?>
<?php $ref_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ref_f_list->FilterOptions->visible()) { ?>
<?php $ref_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ref_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ref_f->isExport() && !$ref_f->CurrentAction) { ?>
<form name="fref_flistsrch" id="fref_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($ref_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fref_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ref_f">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($ref_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($ref_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ref_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ref_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ref_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ref_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ref_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $ref_f_list->showPageHeader(); ?>
<?php
$ref_f_list->showMessage();
?>
<?php if ($ref_f_list->TotalRecs > 0 || $ref_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ref_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ref_f">
<?php if (!$ref_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$ref_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ref_f_list->Pager)) $ref_f_list->Pager = new PrevNextPager($ref_f_list->StartRec, $ref_f_list->DisplayRecs, $ref_f_list->TotalRecs, $ref_f_list->AutoHidePager) ?>
<?php if ($ref_f_list->Pager->RecordCount > 0 && $ref_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ref_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ref_f_list->pageUrl() ?>start=<?php echo $ref_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ref_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ref_f_list->pageUrl() ?>start=<?php echo $ref_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ref_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ref_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ref_f_list->pageUrl() ?>start=<?php echo $ref_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ref_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ref_f_list->pageUrl() ?>start=<?php echo $ref_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ref_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ref_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ref_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ref_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ref_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ref_f_list->TotalRecs > 0 && (!$ref_f_list->AutoHidePageSizeSelector || $ref_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ref_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ref_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ref_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ref_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ref_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ref_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ref_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ref_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fref_flist" id="fref_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_f">
<div id="gmp_ref_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($ref_f_list->TotalRecs > 0 || $ref_f->isGridEdit()) { ?>
<table id="tbl_ref_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ref_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$ref_f_list->renderListOptions();

// Render list options (header, left)
$ref_f_list->ListOptions->render("header", "left");
?>
<?php if ($ref_f->id->Visible) { // id ?>
	<?php if ($ref_f->sortUrl($ref_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $ref_f->id->headerCellClass() ?>"><div id="elh_ref_f_id" class="ref_f_id"><div class="ew-table-header-caption"><?php echo $ref_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $ref_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_f->SortUrl($ref_f->id) ?>',2);"><div id="elh_ref_f_id" class="ref_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_f->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_f->s_grp->Visible) { // s_grp ?>
	<?php if ($ref_f->sortUrl($ref_f->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $ref_f->s_grp->headerCellClass() ?>"><div id="elh_ref_f_s_grp" class="ref_f_s_grp"><div class="ew-table-header-caption"><?php echo $ref_f->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $ref_f->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_f->SortUrl($ref_f->s_grp) ?>',2);"><div id="elh_ref_f_s_grp" class="ref_f_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_f->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_f->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_f->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_f->product->Visible) { // product ?>
	<?php if ($ref_f->sortUrl($ref_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $ref_f->product->headerCellClass() ?>"><div id="elh_ref_f_product" class="ref_f_product"><div class="ew-table-header-caption"><?php echo $ref_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $ref_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_f->SortUrl($ref_f->product) ?>',2);"><div id="elh_ref_f_product" class="ref_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_f->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_f->product_code->Visible) { // product_code ?>
	<?php if ($ref_f->sortUrl($ref_f->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $ref_f->product_code->headerCellClass() ?>"><div id="elh_ref_f_product_code" class="ref_f_product_code"><div class="ew-table-header-caption"><?php echo $ref_f->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $ref_f->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_f->SortUrl($ref_f->product_code) ?>',2);"><div id="elh_ref_f_product_code" class="ref_f_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_f->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_f->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_f->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_f->last_price->Visible) { // last_price ?>
	<?php if ($ref_f->sortUrl($ref_f->last_price) == "") { ?>
		<th data-name="last_price" class="<?php echo $ref_f->last_price->headerCellClass() ?>"><div id="elh_ref_f_last_price" class="ref_f_last_price"><div class="ew-table-header-caption"><?php echo $ref_f->last_price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="last_price" class="<?php echo $ref_f->last_price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_f->SortUrl($ref_f->last_price) ?>',2);"><div id="elh_ref_f_last_price" class="ref_f_last_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_f->last_price->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_f->last_price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_f->last_price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_f->image->Visible) { // image ?>
	<?php if ($ref_f->sortUrl($ref_f->image) == "") { ?>
		<th data-name="image" class="<?php echo $ref_f->image->headerCellClass() ?>"><div id="elh_ref_f_image" class="ref_f_image"><div class="ew-table-header-caption"><?php echo $ref_f->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $ref_f->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_f->SortUrl($ref_f->image) ?>',2);"><div id="elh_ref_f_image" class="ref_f_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_f->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_f->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_f->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_f->operator->Visible) { // operator ?>
	<?php if ($ref_f->sortUrl($ref_f->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $ref_f->operator->headerCellClass() ?>"><div id="elh_ref_f_operator" class="ref_f_operator"><div class="ew-table-header-caption"><?php echo $ref_f->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $ref_f->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_f->SortUrl($ref_f->operator) ?>',2);"><div id="elh_ref_f_operator" class="ref_f_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_f->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_f->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_f->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_f->datetime->Visible) { // datetime ?>
	<?php if ($ref_f->sortUrl($ref_f->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $ref_f->datetime->headerCellClass() ?>"><div id="elh_ref_f_datetime" class="ref_f_datetime"><div class="ew-table-header-caption"><?php echo $ref_f->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $ref_f->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_f->SortUrl($ref_f->datetime) ?>',2);"><div id="elh_ref_f_datetime" class="ref_f_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_f->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_f->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_f->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ref_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ref_f->ExportAll && $ref_f->isExport()) {
	$ref_f_list->StopRec = $ref_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($ref_f_list->TotalRecs > $ref_f_list->StartRec + $ref_f_list->DisplayRecs - 1)
		$ref_f_list->StopRec = $ref_f_list->StartRec + $ref_f_list->DisplayRecs - 1;
	else
		$ref_f_list->StopRec = $ref_f_list->TotalRecs;
}
$ref_f_list->RecCnt = $ref_f_list->StartRec - 1;
if ($ref_f_list->Recordset && !$ref_f_list->Recordset->EOF) {
	$ref_f_list->Recordset->moveFirst();
	$selectLimit = $ref_f_list->UseSelectLimit;
	if (!$selectLimit && $ref_f_list->StartRec > 1)
		$ref_f_list->Recordset->move($ref_f_list->StartRec - 1);
} elseif (!$ref_f->AllowAddDeleteRow && $ref_f_list->StopRec == 0) {
	$ref_f_list->StopRec = $ref_f->GridAddRowCount;
}

// Initialize aggregate
$ref_f->RowType = ROWTYPE_AGGREGATEINIT;
$ref_f->resetAttributes();
$ref_f_list->renderRow();
while ($ref_f_list->RecCnt < $ref_f_list->StopRec) {
	$ref_f_list->RecCnt++;
	if ($ref_f_list->RecCnt >= $ref_f_list->StartRec) {
		$ref_f_list->RowCnt++;

		// Set up key count
		$ref_f_list->KeyCount = $ref_f_list->RowIndex;

		// Init row class and style
		$ref_f->resetAttributes();
		$ref_f->CssClass = "";
		if ($ref_f->isGridAdd()) {
		} else {
			$ref_f_list->loadRowValues($ref_f_list->Recordset); // Load row values
		}
		$ref_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ref_f->RowAttrs = array_merge($ref_f->RowAttrs, array('data-rowindex'=>$ref_f_list->RowCnt, 'id'=>'r' . $ref_f_list->RowCnt . '_ref_f', 'data-rowtype'=>$ref_f->RowType));

		// Render row
		$ref_f_list->renderRow();

		// Render list options
		$ref_f_list->renderListOptions();
?>
	<tr<?php echo $ref_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ref_f_list->ListOptions->render("body", "left", $ref_f_list->RowCnt);
?>
	<?php if ($ref_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $ref_f->id->cellAttributes() ?>>
<span id="el<?php echo $ref_f_list->RowCnt ?>_ref_f_id" class="ref_f_id">
<span<?php echo $ref_f->id->viewAttributes() ?>>
<?php echo $ref_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $ref_f->s_grp->cellAttributes() ?>>
<span id="el<?php echo $ref_f_list->RowCnt ?>_ref_f_s_grp" class="ref_f_s_grp">
<span<?php echo $ref_f->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_f->s_grp->getViewValue())) && $ref_f->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_f->s_grp->linkAttributes() ?>><?php echo $ref_f->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_f->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $ref_f->product->cellAttributes() ?>>
<span id="el<?php echo $ref_f_list->RowCnt ?>_ref_f_product" class="ref_f_product">
<span<?php echo $ref_f->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref_f->product->getViewValue())) && $ref_f->product->linkAttributes() <> "") { ?>
<a<?php echo $ref_f->product->linkAttributes() ?>><?php echo $ref_f->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_f->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_f->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $ref_f->product_code->cellAttributes() ?>>
<span id="el<?php echo $ref_f_list->RowCnt ?>_ref_f_product_code" class="ref_f_product_code">
<span<?php echo $ref_f->product_code->viewAttributes() ?>>
<?php echo $ref_f->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_f->last_price->Visible) { // last_price ?>
		<td data-name="last_price"<?php echo $ref_f->last_price->cellAttributes() ?>>
<span id="el<?php echo $ref_f_list->RowCnt ?>_ref_f_last_price" class="ref_f_last_price">
<span<?php echo $ref_f->last_price->viewAttributes() ?>>
<?php echo $ref_f->last_price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_f->image->Visible) { // image ?>
		<td data-name="image"<?php echo $ref_f->image->cellAttributes() ?>>
<span id="el<?php echo $ref_f_list->RowCnt ?>_ref_f_image" class="ref_f_image">
<span>
<?php echo GetFileViewTag($ref_f->image, $ref_f->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_f->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $ref_f->operator->cellAttributes() ?>>
<span id="el<?php echo $ref_f_list->RowCnt ?>_ref_f_operator" class="ref_f_operator">
<span<?php echo $ref_f->operator->viewAttributes() ?>>
<?php echo $ref_f->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_f->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $ref_f->datetime->cellAttributes() ?>>
<span id="el<?php echo $ref_f_list->RowCnt ?>_ref_f_datetime" class="ref_f_datetime">
<span<?php echo $ref_f->datetime->viewAttributes() ?>>
<?php echo $ref_f->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ref_f_list->ListOptions->render("body", "right", $ref_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$ref_f->isGridAdd())
		$ref_f_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$ref_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ref_f_list->Recordset)
	$ref_f_list->Recordset->Close();
?>
<?php if (!$ref_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ref_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ref_f_list->Pager)) $ref_f_list->Pager = new PrevNextPager($ref_f_list->StartRec, $ref_f_list->DisplayRecs, $ref_f_list->TotalRecs, $ref_f_list->AutoHidePager) ?>
<?php if ($ref_f_list->Pager->RecordCount > 0 && $ref_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ref_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ref_f_list->pageUrl() ?>start=<?php echo $ref_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ref_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ref_f_list->pageUrl() ?>start=<?php echo $ref_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ref_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ref_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ref_f_list->pageUrl() ?>start=<?php echo $ref_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ref_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ref_f_list->pageUrl() ?>start=<?php echo $ref_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ref_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ref_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ref_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ref_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ref_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ref_f_list->TotalRecs > 0 && (!$ref_f_list->AutoHidePageSizeSelector || $ref_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ref_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ref_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ref_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ref_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ref_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ref_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ref_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ref_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ref_f_list->TotalRecs == 0 && !$ref_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ref_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ref_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ref_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$ref_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_ref_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ref_f_list->terminate();
?>