<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_fp_edit = new ref_fp_edit();

// Run the page
$ref_fp_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_fp_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fref_fpedit = currentForm = new ew.Form("fref_fpedit", "edit");

// Validate form
fref_fpedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ref_fp_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_fp->s_grp->caption(), $ref_fp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_fp_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_fp->product->caption(), $ref_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_fp_edit->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_fp->product_code->caption(), $ref_fp->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_fp_edit->last_price->Required) { ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_fp->last_price->caption(), $ref_fp->last_price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref_fp->last_price->errorMessage()) ?>");
		<?php if ($ref_fp_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_fp->image->caption(), $ref_fp->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_fp_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_fp->operator->caption(), $ref_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_fp_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_fp->datetime->caption(), $ref_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fref_fpedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_fpedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_fpedit.lists["x_s_grp"] = <?php echo $ref_fp_edit->s_grp->Lookup->toClientList() ?>;
fref_fpedit.lists["x_s_grp"].options = <?php echo JsonEncode($ref_fp_edit->s_grp->lookupOptions()) ?>;
fref_fpedit.lists["x_product"] = <?php echo $ref_fp_edit->product->Lookup->toClientList() ?>;
fref_fpedit.lists["x_product"].options = <?php echo JsonEncode($ref_fp_edit->product->lookupOptions()) ?>;
fref_fpedit.lists["x_operator"] = <?php echo $ref_fp_edit->operator->Lookup->toClientList() ?>;
fref_fpedit.lists["x_operator"].options = <?php echo JsonEncode($ref_fp_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_fp_edit->showPageHeader(); ?>
<?php
$ref_fp_edit->showMessage();
?>
<form name="fref_fpedit" id="fref_fpedit" class="<?php echo $ref_fp_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_fp_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_fp_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_fp">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$ref_fp_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($ref_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_ref_fp_s_grp" for="x_s_grp" class="<?php echo $ref_fp_edit->LeftColumnClass ?>"><?php echo $ref_fp->s_grp->caption() ?><?php echo ($ref_fp->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_fp_edit->RightColumnClass ?>"><div<?php echo $ref_fp->s_grp->cellAttributes() ?>>
<span id="el_ref_fp_s_grp">
<?php $ref_fp->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_fp->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_fp" data-field="x_s_grp" data-value-separator="<?php echo $ref_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref_fp->s_grp->editAttributes() ?>>
		<?php echo $ref_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $ref_fp->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_ref_fp_product" for="x_product" class="<?php echo $ref_fp_edit->LeftColumnClass ?>"><?php echo $ref_fp->product->caption() ?><?php echo ($ref_fp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_fp_edit->RightColumnClass ?>"><div<?php echo $ref_fp->product->cellAttributes() ?>>
<span id="el_ref_fp_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_fp" data-field="x_product" data-value-separator="<?php echo $ref_fp->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref_fp->product->editAttributes() ?>>
		<?php echo $ref_fp->product->selectOptionListHtml("x_product") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "product_fp") && !$ref_fp->product->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $ref_fp->product->caption() ?>" data-title="<?php echo $ref_fp->product->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_product',url:'product_fpaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $ref_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $ref_fp->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_fp->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label id="elh_ref_fp_product_code" for="x_product_code" class="<?php echo $ref_fp_edit->LeftColumnClass ?>"><?php echo $ref_fp->product_code->caption() ?><?php echo ($ref_fp->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_fp_edit->RightColumnClass ?>"><div<?php echo $ref_fp->product_code->cellAttributes() ?>>
<span id="el_ref_fp_product_code">
<input type="text" data-table="ref_fp" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_fp->product_code->getPlaceHolder()) ?>" value="<?php echo $ref_fp->product_code->EditValue ?>"<?php echo $ref_fp->product_code->editAttributes() ?>>
</span>
<?php echo $ref_fp->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_fp->last_price->Visible) { // last_price ?>
	<div id="r_last_price" class="form-group row">
		<label id="elh_ref_fp_last_price" for="x_last_price" class="<?php echo $ref_fp_edit->LeftColumnClass ?>"><?php echo $ref_fp->last_price->caption() ?><?php echo ($ref_fp->last_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_fp_edit->RightColumnClass ?>"><div<?php echo $ref_fp->last_price->cellAttributes() ?>>
<span id="el_ref_fp_last_price">
<input type="text" data-table="ref_fp" data-field="x_last_price" name="x_last_price" id="x_last_price" size="30" placeholder="<?php echo HtmlEncode($ref_fp->last_price->getPlaceHolder()) ?>" value="<?php echo $ref_fp->last_price->EditValue ?>"<?php echo $ref_fp->last_price->editAttributes() ?>>
</span>
<?php echo $ref_fp->last_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_fp->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_ref_fp_image" class="<?php echo $ref_fp_edit->LeftColumnClass ?>"><?php echo $ref_fp->image->caption() ?><?php echo ($ref_fp->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_fp_edit->RightColumnClass ?>"><div<?php echo $ref_fp->image->cellAttributes() ?>>
<span id="el_ref_fp_image">
<div id="fd_x_image">
<span title="<?php echo $ref_fp->image->title() ? $ref_fp->image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_fp->image->ReadOnly || $ref_fp->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_fp" data-field="x_image" name="x_image" id="x_image" multiple="multiple"<?php echo $ref_fp->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $ref_fp->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="255">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $ref_fp->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $ref_fp->image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_image" id= "fc_x_image" value="<?php echo $ref_fp->image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_fp->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
	<input type="hidden" data-table="ref_fp" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($ref_fp->id->CurrentValue) ?>">
<?php if (!$ref_fp_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ref_fp_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ref_fp_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ref_fp_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

var SGrp = $("#x_s_grp").val();
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
			 $("#elh_ref_fp_country").html(data.v_01);
			 $("#elh_ref_fp_supplier").html(data.v_02);
			 $("#elh_ref_fp_wool_type").html(data.v_03);
			 $("#elh_ref_fp_quality").html(data.v_04);
			 $("#elh_ref_fp_grade").html(data.v_05);
		});
</script>
<?php include_once "footer.php" ?>
<?php
$ref_fp_edit->terminate();
?>