<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_fp_view = new ref_fp_view();

// Run the page
$ref_fp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_fp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ref_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fref_fpview = currentForm = new ew.Form("fref_fpview", "view");

// Form_CustomValidate event
fref_fpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_fpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_fpview.lists["x_s_grp"] = <?php echo $ref_fp_view->s_grp->Lookup->toClientList() ?>;
fref_fpview.lists["x_s_grp"].options = <?php echo JsonEncode($ref_fp_view->s_grp->lookupOptions()) ?>;
fref_fpview.lists["x_product"] = <?php echo $ref_fp_view->product->Lookup->toClientList() ?>;
fref_fpview.lists["x_product"].options = <?php echo JsonEncode($ref_fp_view->product->lookupOptions()) ?>;
fref_fpview.lists["x_operator"] = <?php echo $ref_fp_view->operator->Lookup->toClientList() ?>;
fref_fpview.lists["x_operator"].options = <?php echo JsonEncode($ref_fp_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
			console.log(data);
			 $("#elh_ref_fp_country").html(data.v_01);
			 $("#elh_ref_fp_supplier").html(data.v_02);
			 $("#elh_ref_fp_wool_type").html(data.v_03);
			 $("#elh_ref_fp_quality").html(data.v_04);
			 $("#elh_ref_fp_grade").html(data.v_05);
		});
</script>
<?php } ?>
<?php if (!$ref_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ref_fp_view->ExportOptions->render("body") ?>
<?php $ref_fp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ref_fp_view->showPageHeader(); ?>
<?php
$ref_fp_view->showMessage();
?>
<form name="fref_fpview" id="fref_fpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_fp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_fp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_fp">
<input type="hidden" name="modal" value="<?php echo (int)$ref_fp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref_fp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_id"><?php echo $ref_fp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ref_fp->id->cellAttributes() ?>>
<span id="el_ref_fp_id">
<span<?php echo $ref_fp->id->viewAttributes() ?>>
<?php echo $ref_fp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_fp->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_s_grp"><?php echo $ref_fp->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $ref_fp->s_grp->cellAttributes() ?>>
<span id="el_ref_fp_s_grp">
<span<?php echo $ref_fp->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_fp->s_grp->getViewValue())) && $ref_fp->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_fp->s_grp->linkAttributes() ?>><?php echo $ref_fp->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_fp->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_fp->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_product"><?php echo $ref_fp->product->caption() ?></span></td>
		<td data-name="product"<?php echo $ref_fp->product->cellAttributes() ?>>
<span id="el_ref_fp_product">
<span<?php echo $ref_fp->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref_fp->product->getViewValue())) && $ref_fp->product->linkAttributes() <> "") { ?>
<a<?php echo $ref_fp->product->linkAttributes() ?>><?php echo $ref_fp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_fp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_fp->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_product_code"><?php echo $ref_fp->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $ref_fp->product_code->cellAttributes() ?>>
<span id="el_ref_fp_product_code">
<span<?php echo $ref_fp->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($ref_fp->product_code->getViewValue())) && $ref_fp->product_code->linkAttributes() <> "") { ?>
<a<?php echo $ref_fp->product_code->linkAttributes() ?>><?php echo $ref_fp->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_fp->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_fp->gcode->Visible) { // gcode ?>
	<tr id="r_gcode">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_gcode"><?php echo $ref_fp->gcode->caption() ?></span></td>
		<td data-name="gcode"<?php echo $ref_fp->gcode->cellAttributes() ?>>
<span id="el_ref_fp_gcode">
<span<?php echo $ref_fp->gcode->viewAttributes() ?>>
<?php echo $ref_fp->gcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_fp->last_price->Visible) { // last_price ?>
	<tr id="r_last_price">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_last_price"><?php echo $ref_fp->last_price->caption() ?></span></td>
		<td data-name="last_price"<?php echo $ref_fp->last_price->cellAttributes() ?>>
<span id="el_ref_fp_last_price">
<span<?php echo $ref_fp->last_price->viewAttributes() ?>>
<?php echo $ref_fp->last_price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_fp->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_image"><?php echo $ref_fp->image->caption() ?></span></td>
		<td data-name="image"<?php echo $ref_fp->image->cellAttributes() ?>>
<span id="el_ref_fp_image">
<span>
<?php echo GetFileViewTag($ref_fp->image, $ref_fp->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_fp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_operator"><?php echo $ref_fp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $ref_fp->operator->cellAttributes() ?>>
<span id="el_ref_fp_operator">
<span<?php echo $ref_fp->operator->viewAttributes() ?>>
<?php echo $ref_fp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_fp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $ref_fp_view->TableLeftColumnClass ?>"><span id="elh_ref_fp_datetime"><?php echo $ref_fp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $ref_fp->datetime->cellAttributes() ?>>
<span id="el_ref_fp_datetime">
<span<?php echo $ref_fp->datetime->viewAttributes() ?>>
<?php echo $ref_fp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$ref_fp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ref_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ref_fp_view->terminate();
?>