<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_f_search = new ref_f_search();

// Run the page
$ref_f_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_f_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($ref_f_search->IsModal) { ?>
var fref_fsearch = currentAdvancedSearchForm = new ew.Form("fref_fsearch", "search");
<?php } else { ?>
var fref_fsearch = currentForm = new ew.Form("fref_fsearch", "search");
<?php } ?>

// Form_CustomValidate event
fref_fsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_fsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_fsearch.lists["x_s_grp"] = <?php echo $ref_f_search->s_grp->Lookup->toClientList() ?>;
fref_fsearch.lists["x_s_grp"].options = <?php echo JsonEncode($ref_f_search->s_grp->lookupOptions()) ?>;
fref_fsearch.lists["x_product"] = <?php echo $ref_f_search->product->Lookup->toClientList() ?>;
fref_fsearch.lists["x_product"].options = <?php echo JsonEncode($ref_f_search->product->lookupOptions()) ?>;
fref_fsearch.lists["x_operator"] = <?php echo $ref_f_search->operator->Lookup->toClientList() ?>;
fref_fsearch.lists["x_operator"].options = <?php echo JsonEncode($ref_f_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fref_fsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref_f->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_last_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref_f->last_price->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_f_search->showPageHeader(); ?>
<?php
$ref_f_search->showMessage();
?>
<form name="fref_fsearch" id="fref_fsearch" class="<?php echo $ref_f_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_f_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_f_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_f">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$ref_f_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($ref_f->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $ref_f_search->LeftColumnClass ?>"><span id="elh_ref_f_id"><?php echo $ref_f->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $ref_f_search->RightColumnClass ?>"><div<?php echo $ref_f->id->cellAttributes() ?>>
			<span id="el_ref_f_id">
<input type="text" data-table="ref_f" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($ref_f->id->getPlaceHolder()) ?>" value="<?php echo $ref_f->id->EditValue ?>"<?php echo $ref_f->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_f->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $ref_f_search->LeftColumnClass ?>"><span id="elh_ref_f_s_grp"><?php echo $ref_f->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $ref_f_search->RightColumnClass ?>"><div<?php echo $ref_f->s_grp->cellAttributes() ?>>
			<span id="el_ref_f_s_grp">
<?php $ref_f->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_f->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_f" data-field="x_s_grp" data-value-separator="<?php echo $ref_f->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref_f->s_grp->editAttributes() ?>>
		<?php echo $ref_f->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $ref_f_search->LeftColumnClass ?>"><span id="elh_ref_f_product"><?php echo $ref_f->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $ref_f_search->RightColumnClass ?>"><div<?php echo $ref_f->product->cellAttributes() ?>>
			<span id="el_ref_f_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_f" data-field="x_product" data-value-separator="<?php echo $ref_f->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref_f->product->editAttributes() ?>>
		<?php echo $ref_f->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $ref_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_f->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $ref_f_search->LeftColumnClass ?>"><span id="elh_ref_f_product_code"><?php echo $ref_f->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_f_search->RightColumnClass ?>"><div<?php echo $ref_f->product_code->cellAttributes() ?>>
			<span id="el_ref_f_product_code">
<input type="text" data-table="ref_f" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_f->product_code->getPlaceHolder()) ?>" value="<?php echo $ref_f->product_code->EditValue ?>"<?php echo $ref_f->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_f->last_price->Visible) { // last_price ?>
	<div id="r_last_price" class="form-group row">
		<label for="x_last_price" class="<?php echo $ref_f_search->LeftColumnClass ?>"><span id="elh_ref_f_last_price"><?php echo $ref_f->last_price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_last_price" id="z_last_price" value="="></span>
		</label>
		<div class="<?php echo $ref_f_search->RightColumnClass ?>"><div<?php echo $ref_f->last_price->cellAttributes() ?>>
			<span id="el_ref_f_last_price">
<input type="text" data-table="ref_f" data-field="x_last_price" name="x_last_price" id="x_last_price" size="30" placeholder="<?php echo HtmlEncode($ref_f->last_price->getPlaceHolder()) ?>" value="<?php echo $ref_f->last_price->EditValue ?>"<?php echo $ref_f->last_price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_f->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $ref_f_search->LeftColumnClass ?>"><span id="elh_ref_f_image"><?php echo $ref_f->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_f_search->RightColumnClass ?>"><div<?php echo $ref_f->image->cellAttributes() ?>>
			<span id="el_ref_f_image">
<input type="text" data-table="ref_f" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_f->image->getPlaceHolder()) ?>" value="<?php echo $ref_f->image->EditValue ?>"<?php echo $ref_f->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_f->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $ref_f_search->LeftColumnClass ?>"><span id="elh_ref_f_operator"><?php echo $ref_f->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $ref_f_search->RightColumnClass ?>"><div<?php echo $ref_f->operator->cellAttributes() ?>>
			<span id="el_ref_f_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_f" data-field="x_operator" data-value-separator="<?php echo $ref_f->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $ref_f->operator->editAttributes() ?>>
		<?php echo $ref_f->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $ref_f->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_f->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $ref_f_search->LeftColumnClass ?>"><span id="elh_ref_f_datetime"><?php echo $ref_f->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $ref_f_search->RightColumnClass ?>"><div<?php echo $ref_f->datetime->cellAttributes() ?>>
			<span id="el_ref_f_datetime">
<input type="text" data-table="ref_f" data-field="x_datetime" data-format="7" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($ref_f->datetime->getPlaceHolder()) ?>" value="<?php echo $ref_f->datetime->EditValue ?>"<?php echo $ref_f->datetime->editAttributes() ?>>
<?php if (!$ref_f->datetime->ReadOnly && !$ref_f->datetime->Disabled && !isset($ref_f->datetime->EditAttrs["readonly"]) && !isset($ref_f->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fref_fsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ref_f_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ref_f_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ref_f_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ref_f_search->terminate();
?>