<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_f_view = new ref_f_view();

// Run the page
$ref_f_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_f_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ref_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fref_fview = currentForm = new ew.Form("fref_fview", "view");

// Form_CustomValidate event
fref_fview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_fview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_fview.lists["x_s_grp"] = <?php echo $ref_f_view->s_grp->Lookup->toClientList() ?>;
fref_fview.lists["x_s_grp"].options = <?php echo JsonEncode($ref_f_view->s_grp->lookupOptions()) ?>;
fref_fview.lists["x_product"] = <?php echo $ref_f_view->product->Lookup->toClientList() ?>;
fref_fview.lists["x_product"].options = <?php echo JsonEncode($ref_f_view->product->lookupOptions()) ?>;
fref_fview.lists["x_operator"] = <?php echo $ref_f_view->operator->Lookup->toClientList() ?>;
fref_fview.lists["x_operator"].options = <?php echo JsonEncode($ref_f_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ref_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ref_f_view->ExportOptions->render("body") ?>
<?php $ref_f_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ref_f_view->showPageHeader(); ?>
<?php
$ref_f_view->showMessage();
?>
<form name="fref_fview" id="fref_fview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_f_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_f_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_f">
<input type="hidden" name="modal" value="<?php echo (int)$ref_f_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref_f->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ref_f_view->TableLeftColumnClass ?>"><span id="elh_ref_f_id"><?php echo $ref_f->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ref_f->id->cellAttributes() ?>>
<span id="el_ref_f_id">
<span<?php echo $ref_f->id->viewAttributes() ?>>
<?php echo $ref_f->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_f->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $ref_f_view->TableLeftColumnClass ?>"><span id="elh_ref_f_s_grp"><?php echo $ref_f->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $ref_f->s_grp->cellAttributes() ?>>
<span id="el_ref_f_s_grp">
<span<?php echo $ref_f->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_f->s_grp->getViewValue())) && $ref_f->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_f->s_grp->linkAttributes() ?>><?php echo $ref_f->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_f->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_f->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $ref_f_view->TableLeftColumnClass ?>"><span id="elh_ref_f_product"><?php echo $ref_f->product->caption() ?></span></td>
		<td data-name="product"<?php echo $ref_f->product->cellAttributes() ?>>
<span id="el_ref_f_product">
<span<?php echo $ref_f->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref_f->product->getViewValue())) && $ref_f->product->linkAttributes() <> "") { ?>
<a<?php echo $ref_f->product->linkAttributes() ?>><?php echo $ref_f->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_f->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_f->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $ref_f_view->TableLeftColumnClass ?>"><span id="elh_ref_f_product_code"><?php echo $ref_f->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $ref_f->product_code->cellAttributes() ?>>
<span id="el_ref_f_product_code">
<span<?php echo $ref_f->product_code->viewAttributes() ?>>
<?php echo $ref_f->product_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_f->last_price->Visible) { // last_price ?>
	<tr id="r_last_price">
		<td class="<?php echo $ref_f_view->TableLeftColumnClass ?>"><span id="elh_ref_f_last_price"><?php echo $ref_f->last_price->caption() ?></span></td>
		<td data-name="last_price"<?php echo $ref_f->last_price->cellAttributes() ?>>
<span id="el_ref_f_last_price">
<span<?php echo $ref_f->last_price->viewAttributes() ?>>
<?php echo $ref_f->last_price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_f->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $ref_f_view->TableLeftColumnClass ?>"><span id="elh_ref_f_image"><?php echo $ref_f->image->caption() ?></span></td>
		<td data-name="image"<?php echo $ref_f->image->cellAttributes() ?>>
<span id="el_ref_f_image">
<span>
<?php echo GetFileViewTag($ref_f->image, $ref_f->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_f->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $ref_f_view->TableLeftColumnClass ?>"><span id="elh_ref_f_operator"><?php echo $ref_f->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $ref_f->operator->cellAttributes() ?>>
<span id="el_ref_f_operator">
<span<?php echo $ref_f->operator->viewAttributes() ?>>
<?php echo $ref_f->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_f->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $ref_f_view->TableLeftColumnClass ?>"><span id="elh_ref_f_datetime"><?php echo $ref_f->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $ref_f->datetime->cellAttributes() ?>>
<span id="el_ref_f_datetime">
<span<?php echo $ref_f->datetime->viewAttributes() ?>>
<?php echo $ref_f->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$ref_f_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ref_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ref_f_view->terminate();
?>