<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_image_edit = new ref_image_edit();

// Run the page
$ref_image_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_image_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fref_imageedit = currentForm = new ew.Form("fref_imageedit", "edit");

// Validate form
fref_imageedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ref_image_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->id->caption(), $ref_image->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->grp->caption(), $ref_image->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->s_grp->caption(), $ref_image->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->product->caption(), $ref_image->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->product_code->caption(), $ref_image->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->main_image->Required) { ?>
			felm = this.getElements("x" + infix + "_main_image");
			elm = this.getElements("fn_x" + infix + "_main_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_image->main_image->caption(), $ref_image->main_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->top_view->Required) { ?>
			felm = this.getElements("x" + infix + "_top_view");
			elm = this.getElements("fn_x" + infix + "_top_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_image->top_view->caption(), $ref_image->top_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->front_view->Required) { ?>
			felm = this.getElements("x" + infix + "_front_view");
			elm = this.getElements("fn_x" + infix + "_front_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_image->front_view->caption(), $ref_image->front_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->corner_view->Required) { ?>
			felm = this.getElements("x" + infix + "_corner_view");
			elm = this.getElements("fn_x" + infix + "_corner_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_image->corner_view->caption(), $ref_image->corner_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->back_view->Required) { ?>
			felm = this.getElements("x" + infix + "_back_view");
			elm = this.getElements("fn_x" + infix + "_back_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_image->back_view->caption(), $ref_image->back_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->color_options->Required) { ?>
			felm = this.getElements("x" + infix + "_color_options");
			elm = this.getElements("fn_x" + infix + "_color_options");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_image->color_options->caption(), $ref_image->color_options->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->other_options->Required) { ?>
			felm = this.getElements("x" + infix + "_other_options");
			elm = this.getElements("fn_x" + infix + "_other_options");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_image->other_options->caption(), $ref_image->other_options->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->video_url->Required) { ?>
			elm = this.getElements("x" + infix + "_video_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->video_url->caption(), $ref_image->video_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->group_image->Required) { ?>
			felm = this.getElements("x" + infix + "_group_image");
			elm = this.getElements("fn_x" + infix + "_group_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_image->group_image->caption(), $ref_image->group_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->status->caption(), $ref_image->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->company_id->caption(), $ref_image->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->product_type->caption(), $ref_image->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->operator->caption(), $ref_image->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_image_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_image->datetime->caption(), $ref_image->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fref_imageedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_imageedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_imageedit.lists["x_grp"] = <?php echo $ref_image_edit->grp->Lookup->toClientList() ?>;
fref_imageedit.lists["x_grp"].options = <?php echo JsonEncode($ref_image_edit->grp->lookupOptions()) ?>;
fref_imageedit.lists["x_s_grp"] = <?php echo $ref_image_edit->s_grp->Lookup->toClientList() ?>;
fref_imageedit.lists["x_s_grp"].options = <?php echo JsonEncode($ref_image_edit->s_grp->lookupOptions()) ?>;
fref_imageedit.lists["x_product"] = <?php echo $ref_image_edit->product->Lookup->toClientList() ?>;
fref_imageedit.lists["x_product"].options = <?php echo JsonEncode($ref_image_edit->product->lookupOptions()) ?>;
fref_imageedit.lists["x_status"] = <?php echo $ref_image_edit->status->Lookup->toClientList() ?>;
fref_imageedit.lists["x_status"].options = <?php echo JsonEncode($ref_image_edit->status->options(FALSE, TRUE)) ?>;
fref_imageedit.lists["x_company_id"] = <?php echo $ref_image_edit->company_id->Lookup->toClientList() ?>;
fref_imageedit.lists["x_company_id"].options = <?php echo JsonEncode($ref_image_edit->company_id->lookupOptions()) ?>;
fref_imageedit.lists["x_product_type"] = <?php echo $ref_image_edit->product_type->Lookup->toClientList() ?>;
fref_imageedit.lists["x_product_type"].options = <?php echo JsonEncode($ref_image_edit->product_type->lookupOptions()) ?>;
fref_imageedit.lists["x_operator"] = <?php echo $ref_image_edit->operator->Lookup->toClientList() ?>;
fref_imageedit.lists["x_operator"].options = <?php echo JsonEncode($ref_image_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_image_edit->showPageHeader(); ?>
<?php
$ref_image_edit->showMessage();
?>
<form name="fref_imageedit" id="fref_imageedit" class="<?php echo $ref_image_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_image_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_image_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_image">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$ref_image_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($ref_image->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_ref_image_id" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->id->caption() ?><?php echo ($ref_image->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->id->cellAttributes() ?>>
<span id="el_ref_image_id">
<span<?php echo $ref_image->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="ref_image" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($ref_image->id->CurrentValue) ?>">
<?php echo $ref_image->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_ref_image_grp" for="x_grp" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->grp->caption() ?><?php echo ($ref_image->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->grp->cellAttributes() ?>>
<span id="el_ref_image_grp">
<span<?php echo $ref_image->grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->grp->EditValue)) && $ref_image->grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->grp->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->grp->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="ref_image" data-field="x_grp" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($ref_image->grp->CurrentValue) ?>">
<?php echo $ref_image->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_ref_image_s_grp" for="x_s_grp" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->s_grp->caption() ?><?php echo ($ref_image->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->s_grp->cellAttributes() ?>>
<span id="el_ref_image_s_grp">
<span<?php echo $ref_image->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->s_grp->EditValue)) && $ref_image->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->s_grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->s_grp->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->s_grp->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="ref_image" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($ref_image->s_grp->CurrentValue) ?>">
<?php echo $ref_image->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_ref_image_product" for="x_product" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->product->caption() ?><?php echo ($ref_image->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->product->cellAttributes() ?>>
<span id="el_ref_image_product">
<span<?php echo $ref_image->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->product->EditValue)) && $ref_image->product->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->product->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->product->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->product->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="ref_image" data-field="x_product" name="x_product" id="x_product" value="<?php echo HtmlEncode($ref_image->product->CurrentValue) ?>">
<?php echo $ref_image->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label id="elh_ref_image_product_code" for="x_product_code" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->product_code->caption() ?><?php echo ($ref_image->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->product_code->cellAttributes() ?>>
<span id="el_ref_image_product_code">
<span<?php echo $ref_image->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->product_code->EditValue)) && $ref_image->product_code->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->product_code->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->product_code->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->product_code->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="ref_image" data-field="x_product_code" name="x_product_code" id="x_product_code" value="<?php echo HtmlEncode($ref_image->product_code->CurrentValue) ?>">
<?php echo $ref_image->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->main_image->Visible) { // main_image ?>
	<div id="r_main_image" class="form-group row">
		<label id="elh_ref_image_main_image" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->main_image->caption() ?><?php echo ($ref_image->main_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->main_image->cellAttributes() ?>>
<span id="el_ref_image_main_image">
<div id="fd_x_main_image">
<span title="<?php echo $ref_image->main_image->title() ? $ref_image->main_image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_image->main_image->ReadOnly || $ref_image->main_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_image" data-field="x_main_image" name="x_main_image" id="x_main_image"<?php echo $ref_image->main_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_main_image" id= "fn_x_main_image" value="<?php echo $ref_image->main_image->Upload->FileName ?>">
<?php if (Post("fa_x_main_image") == "0") { ?>
<input type="hidden" name="fa_x_main_image" id= "fa_x_main_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_main_image" id= "fa_x_main_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_main_image" id= "fs_x_main_image" value="255">
<input type="hidden" name="fx_x_main_image" id= "fx_x_main_image" value="<?php echo $ref_image->main_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_main_image" id= "fm_x_main_image" value="<?php echo $ref_image->main_image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_main_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_image->main_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->top_view->Visible) { // top_view ?>
	<div id="r_top_view" class="form-group row">
		<label id="elh_ref_image_top_view" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->top_view->caption() ?><?php echo ($ref_image->top_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->top_view->cellAttributes() ?>>
<span id="el_ref_image_top_view">
<div id="fd_x_top_view">
<span title="<?php echo $ref_image->top_view->title() ? $ref_image->top_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_image->top_view->ReadOnly || $ref_image->top_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_image" data-field="x_top_view" name="x_top_view" id="x_top_view" multiple="multiple"<?php echo $ref_image->top_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_top_view" id= "fn_x_top_view" value="<?php echo $ref_image->top_view->Upload->FileName ?>">
<?php if (Post("fa_x_top_view") == "0") { ?>
<input type="hidden" name="fa_x_top_view" id= "fa_x_top_view" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_top_view" id= "fa_x_top_view" value="1">
<?php } ?>
<input type="hidden" name="fs_x_top_view" id= "fs_x_top_view" value="255">
<input type="hidden" name="fx_x_top_view" id= "fx_x_top_view" value="<?php echo $ref_image->top_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_top_view" id= "fm_x_top_view" value="<?php echo $ref_image->top_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_top_view" id= "fc_x_top_view" value="<?php echo $ref_image->top_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_top_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_image->top_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->front_view->Visible) { // front_view ?>
	<div id="r_front_view" class="form-group row">
		<label id="elh_ref_image_front_view" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->front_view->caption() ?><?php echo ($ref_image->front_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->front_view->cellAttributes() ?>>
<span id="el_ref_image_front_view">
<div id="fd_x_front_view">
<span title="<?php echo $ref_image->front_view->title() ? $ref_image->front_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_image->front_view->ReadOnly || $ref_image->front_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_image" data-field="x_front_view" name="x_front_view" id="x_front_view" multiple="multiple"<?php echo $ref_image->front_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_front_view" id= "fn_x_front_view" value="<?php echo $ref_image->front_view->Upload->FileName ?>">
<?php if (Post("fa_x_front_view") == "0") { ?>
<input type="hidden" name="fa_x_front_view" id= "fa_x_front_view" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_front_view" id= "fa_x_front_view" value="1">
<?php } ?>
<input type="hidden" name="fs_x_front_view" id= "fs_x_front_view" value="255">
<input type="hidden" name="fx_x_front_view" id= "fx_x_front_view" value="<?php echo $ref_image->front_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_front_view" id= "fm_x_front_view" value="<?php echo $ref_image->front_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_front_view" id= "fc_x_front_view" value="<?php echo $ref_image->front_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_front_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_image->front_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->corner_view->Visible) { // corner_view ?>
	<div id="r_corner_view" class="form-group row">
		<label id="elh_ref_image_corner_view" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->corner_view->caption() ?><?php echo ($ref_image->corner_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->corner_view->cellAttributes() ?>>
<span id="el_ref_image_corner_view">
<div id="fd_x_corner_view">
<span title="<?php echo $ref_image->corner_view->title() ? $ref_image->corner_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_image->corner_view->ReadOnly || $ref_image->corner_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_image" data-field="x_corner_view" name="x_corner_view" id="x_corner_view" multiple="multiple"<?php echo $ref_image->corner_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_corner_view" id= "fn_x_corner_view" value="<?php echo $ref_image->corner_view->Upload->FileName ?>">
<?php if (Post("fa_x_corner_view") == "0") { ?>
<input type="hidden" name="fa_x_corner_view" id= "fa_x_corner_view" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_corner_view" id= "fa_x_corner_view" value="1">
<?php } ?>
<input type="hidden" name="fs_x_corner_view" id= "fs_x_corner_view" value="255">
<input type="hidden" name="fx_x_corner_view" id= "fx_x_corner_view" value="<?php echo $ref_image->corner_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_corner_view" id= "fm_x_corner_view" value="<?php echo $ref_image->corner_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_corner_view" id= "fc_x_corner_view" value="<?php echo $ref_image->corner_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_corner_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_image->corner_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->back_view->Visible) { // back_view ?>
	<div id="r_back_view" class="form-group row">
		<label id="elh_ref_image_back_view" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->back_view->caption() ?><?php echo ($ref_image->back_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->back_view->cellAttributes() ?>>
<span id="el_ref_image_back_view">
<div id="fd_x_back_view">
<span title="<?php echo $ref_image->back_view->title() ? $ref_image->back_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_image->back_view->ReadOnly || $ref_image->back_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_image" data-field="x_back_view" name="x_back_view" id="x_back_view" multiple="multiple"<?php echo $ref_image->back_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_back_view" id= "fn_x_back_view" value="<?php echo $ref_image->back_view->Upload->FileName ?>">
<?php if (Post("fa_x_back_view") == "0") { ?>
<input type="hidden" name="fa_x_back_view" id= "fa_x_back_view" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_back_view" id= "fa_x_back_view" value="1">
<?php } ?>
<input type="hidden" name="fs_x_back_view" id= "fs_x_back_view" value="255">
<input type="hidden" name="fx_x_back_view" id= "fx_x_back_view" value="<?php echo $ref_image->back_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_back_view" id= "fm_x_back_view" value="<?php echo $ref_image->back_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_back_view" id= "fc_x_back_view" value="<?php echo $ref_image->back_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_back_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_image->back_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->color_options->Visible) { // color_options ?>
	<div id="r_color_options" class="form-group row">
		<label id="elh_ref_image_color_options" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->color_options->caption() ?><?php echo ($ref_image->color_options->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->color_options->cellAttributes() ?>>
<span id="el_ref_image_color_options">
<div id="fd_x_color_options">
<span title="<?php echo $ref_image->color_options->title() ? $ref_image->color_options->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_image->color_options->ReadOnly || $ref_image->color_options->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_image" data-field="x_color_options" name="x_color_options" id="x_color_options" multiple="multiple"<?php echo $ref_image->color_options->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_color_options" id= "fn_x_color_options" value="<?php echo $ref_image->color_options->Upload->FileName ?>">
<?php if (Post("fa_x_color_options") == "0") { ?>
<input type="hidden" name="fa_x_color_options" id= "fa_x_color_options" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_color_options" id= "fa_x_color_options" value="1">
<?php } ?>
<input type="hidden" name="fs_x_color_options" id= "fs_x_color_options" value="255">
<input type="hidden" name="fx_x_color_options" id= "fx_x_color_options" value="<?php echo $ref_image->color_options->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_color_options" id= "fm_x_color_options" value="<?php echo $ref_image->color_options->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_color_options" id= "fc_x_color_options" value="<?php echo $ref_image->color_options->UploadMaxFileCount ?>">
</div>
<table id="ft_x_color_options" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_image->color_options->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->other_options->Visible) { // other_options ?>
	<div id="r_other_options" class="form-group row">
		<label id="elh_ref_image_other_options" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->other_options->caption() ?><?php echo ($ref_image->other_options->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->other_options->cellAttributes() ?>>
<span id="el_ref_image_other_options">
<div id="fd_x_other_options">
<span title="<?php echo $ref_image->other_options->title() ? $ref_image->other_options->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_image->other_options->ReadOnly || $ref_image->other_options->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_image" data-field="x_other_options" name="x_other_options" id="x_other_options" multiple="multiple"<?php echo $ref_image->other_options->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_other_options" id= "fn_x_other_options" value="<?php echo $ref_image->other_options->Upload->FileName ?>">
<?php if (Post("fa_x_other_options") == "0") { ?>
<input type="hidden" name="fa_x_other_options" id= "fa_x_other_options" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_other_options" id= "fa_x_other_options" value="1">
<?php } ?>
<input type="hidden" name="fs_x_other_options" id= "fs_x_other_options" value="255">
<input type="hidden" name="fx_x_other_options" id= "fx_x_other_options" value="<?php echo $ref_image->other_options->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_other_options" id= "fm_x_other_options" value="<?php echo $ref_image->other_options->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_other_options" id= "fc_x_other_options" value="<?php echo $ref_image->other_options->UploadMaxFileCount ?>">
</div>
<table id="ft_x_other_options" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_image->other_options->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->video_url->Visible) { // video_url ?>
	<div id="r_video_url" class="form-group row">
		<label id="elh_ref_image_video_url" for="x_video_url" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->video_url->caption() ?><?php echo ($ref_image->video_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->video_url->cellAttributes() ?>>
<span id="el_ref_image_video_url">
<input type="text" data-table="ref_image" data-field="x_video_url" name="x_video_url" id="x_video_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($ref_image->video_url->getPlaceHolder()) ?>" value="<?php echo $ref_image->video_url->EditValue ?>"<?php echo $ref_image->video_url->editAttributes() ?>>
</span>
<?php echo $ref_image->video_url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->group_image->Visible) { // group_image ?>
	<div id="r_group_image" class="form-group row">
		<label id="elh_ref_image_group_image" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->group_image->caption() ?><?php echo ($ref_image->group_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->group_image->cellAttributes() ?>>
<span id="el_ref_image_group_image">
<div id="fd_x_group_image">
<span title="<?php echo $ref_image->group_image->title() ? $ref_image->group_image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_image->group_image->ReadOnly || $ref_image->group_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_image" data-field="x_group_image" name="x_group_image" id="x_group_image"<?php echo $ref_image->group_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_group_image" id= "fn_x_group_image" value="<?php echo $ref_image->group_image->Upload->FileName ?>">
<?php if (Post("fa_x_group_image") == "0") { ?>
<input type="hidden" name="fa_x_group_image" id= "fa_x_group_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_group_image" id= "fa_x_group_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_group_image" id= "fs_x_group_image" value="196">
<input type="hidden" name="fx_x_group_image" id= "fx_x_group_image" value="<?php echo $ref_image->group_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_group_image" id= "fm_x_group_image" value="<?php echo $ref_image->group_image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_group_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_image->group_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_ref_image_status" for="x_status" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->status->caption() ?><?php echo ($ref_image->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->status->cellAttributes() ?>>
<span id="el_ref_image_status">
<span<?php echo $ref_image->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->status->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="ref_image" data-field="x_status" name="x_status" id="x_status" value="<?php echo HtmlEncode($ref_image->status->CurrentValue) ?>">
<?php echo $ref_image->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_ref_image_company_id" for="x_company_id" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->company_id->caption() ?><?php echo ($ref_image->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->company_id->cellAttributes() ?>>
<span id="el_ref_image_company_id">
<span<?php echo $ref_image->company_id->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->company_id->EditValue)) && $ref_image->company_id->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->company_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->company_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->company_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="ref_image" data-field="x_company_id" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($ref_image->company_id->CurrentValue) ?>">
<?php echo $ref_image->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_image->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_ref_image_product_type" for="x_product_type" class="<?php echo $ref_image_edit->LeftColumnClass ?>"><?php echo $ref_image->product_type->caption() ?><?php echo ($ref_image->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_image_edit->RightColumnClass ?>"><div<?php echo $ref_image->product_type->cellAttributes() ?>>
<span id="el_ref_image_product_type">
<span<?php echo $ref_image->product_type->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref_image->product_type->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="ref_image" data-field="x_product_type" name="x_product_type" id="x_product_type" value="<?php echo HtmlEncode($ref_image->product_type->CurrentValue) ?>">
<?php echo $ref_image->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ref_image_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ref_image_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ref_image_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ref_image_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ref_image_edit->terminate();
?>