<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_image_list = new ref_image_list();

// Run the page
$ref_image_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_image_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ref_image->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fref_imagelist = currentForm = new ew.Form("fref_imagelist", "list");
fref_imagelist.formKeyCountName = '<?php echo $ref_image_list->FormKeyCountName ?>';

// Form_CustomValidate event
fref_imagelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_imagelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_imagelist.lists["x_grp"] = <?php echo $ref_image_list->grp->Lookup->toClientList() ?>;
fref_imagelist.lists["x_grp"].options = <?php echo JsonEncode($ref_image_list->grp->lookupOptions()) ?>;
fref_imagelist.lists["x_s_grp"] = <?php echo $ref_image_list->s_grp->Lookup->toClientList() ?>;
fref_imagelist.lists["x_s_grp"].options = <?php echo JsonEncode($ref_image_list->s_grp->lookupOptions()) ?>;
fref_imagelist.lists["x_product"] = <?php echo $ref_image_list->product->Lookup->toClientList() ?>;
fref_imagelist.lists["x_product"].options = <?php echo JsonEncode($ref_image_list->product->lookupOptions()) ?>;
fref_imagelist.lists["x_status"] = <?php echo $ref_image_list->status->Lookup->toClientList() ?>;
fref_imagelist.lists["x_status"].options = <?php echo JsonEncode($ref_image_list->status->options(FALSE, TRUE)) ?>;
fref_imagelist.lists["x_company_id"] = <?php echo $ref_image_list->company_id->Lookup->toClientList() ?>;
fref_imagelist.lists["x_company_id"].options = <?php echo JsonEncode($ref_image_list->company_id->lookupOptions()) ?>;
fref_imagelist.lists["x_product_type"] = <?php echo $ref_image_list->product_type->Lookup->toClientList() ?>;
fref_imagelist.lists["x_product_type"].options = <?php echo JsonEncode($ref_image_list->product_type->lookupOptions()) ?>;
fref_imagelist.lists["x_operator"] = <?php echo $ref_image_list->operator->Lookup->toClientList() ?>;
fref_imagelist.lists["x_operator"].options = <?php echo JsonEncode($ref_image_list->operator->lookupOptions()) ?>;

// Form object for search
var fref_imagelistsrch = currentSearchForm = new ew.Form("fref_imagelistsrch");

// Validate function for search
fref_imagelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fref_imagelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_imagelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_imagelistsrch.lists["x_grp"] = <?php echo $ref_image_list->grp->Lookup->toClientList() ?>;
fref_imagelistsrch.lists["x_grp"].options = <?php echo JsonEncode($ref_image_list->grp->lookupOptions()) ?>;
fref_imagelistsrch.lists["x_s_grp"] = <?php echo $ref_image_list->s_grp->Lookup->toClientList() ?>;
fref_imagelistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($ref_image_list->s_grp->lookupOptions()) ?>;
fref_imagelistsrch.lists["x_product"] = <?php echo $ref_image_list->product->Lookup->toClientList() ?>;
fref_imagelistsrch.lists["x_product"].options = <?php echo JsonEncode($ref_image_list->product->lookupOptions()) ?>;

// Filters
fref_imagelistsrch.filterList = <?php echo $ref_image_list->getFilterList() ?>;

// Init search panel as collapsed
fref_imagelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ref_image->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ref_image_list->TotalRecs > 0 && $ref_image_list->ExportOptions->visible()) { ?>
<?php $ref_image_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ref_image_list->ImportOptions->visible()) { ?>
<?php $ref_image_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ref_image_list->SearchOptions->visible()) { ?>
<?php $ref_image_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ref_image_list->FilterOptions->visible()) { ?>
<?php $ref_image_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ref_image_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ref_image->isExport() && !$ref_image->CurrentAction) { ?>
<form name="fref_imagelistsrch" id="fref_imagelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($ref_image_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fref_imagelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ref_image">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$ref_image_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$ref_image->RowType = ROWTYPE_SEARCH;

// Render row
$ref_image->resetAttributes();
$ref_image_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($ref_image->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $ref_image->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $ref_image->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_image->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_grp" data-value-separator="<?php echo $ref_image->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref_image->grp->editAttributes() ?>>
		<?php echo $ref_image->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $ref_image->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($ref_image->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $ref_image->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<?php $ref_image->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_image->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_s_grp" data-value-separator="<?php echo $ref_image->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref_image->s_grp->editAttributes() ?>>
		<?php echo $ref_image->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref_image->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($ref_image->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $ref_image->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_product" data-value-separator="<?php echo $ref_image->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref_image->product->editAttributes() ?>>
		<?php echo $ref_image->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $ref_image->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($ref_image_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($ref_image_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ref_image_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ref_image_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ref_image_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ref_image_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ref_image_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $ref_image_list->showPageHeader(); ?>
<?php
$ref_image_list->showMessage();
?>
<?php if ($ref_image_list->TotalRecs > 0 || $ref_image->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ref_image_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ref_image">
<?php if (!$ref_image->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$ref_image->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ref_image_list->Pager)) $ref_image_list->Pager = new PrevNextPager($ref_image_list->StartRec, $ref_image_list->DisplayRecs, $ref_image_list->TotalRecs, $ref_image_list->AutoHidePager) ?>
<?php if ($ref_image_list->Pager->RecordCount > 0 && $ref_image_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ref_image_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ref_image_list->pageUrl() ?>start=<?php echo $ref_image_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ref_image_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ref_image_list->pageUrl() ?>start=<?php echo $ref_image_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ref_image_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ref_image_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ref_image_list->pageUrl() ?>start=<?php echo $ref_image_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ref_image_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ref_image_list->pageUrl() ?>start=<?php echo $ref_image_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ref_image_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ref_image_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ref_image_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ref_image_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ref_image_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ref_image_list->TotalRecs > 0 && (!$ref_image_list->AutoHidePageSizeSelector || $ref_image_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ref_image">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ref_image_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ref_image_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ref_image_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ref_image_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ref_image_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ref_image->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ref_image_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fref_imagelist" id="fref_imagelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_image_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_image_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_image">
<div id="gmp_ref_image" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($ref_image_list->TotalRecs > 0 || $ref_image->isGridEdit()) { ?>
<table id="tbl_ref_imagelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ref_image_list->RowType = ROWTYPE_HEADER;

// Render list options
$ref_image_list->renderListOptions();

// Render list options (header, left)
$ref_image_list->ListOptions->render("header", "left");
?>
<?php if ($ref_image->id->Visible) { // id ?>
	<?php if ($ref_image->sortUrl($ref_image->id) == "") { ?>
		<th data-name="id" class="<?php echo $ref_image->id->headerCellClass() ?>"><div id="elh_ref_image_id" class="ref_image_id"><div class="ew-table-header-caption"><?php echo $ref_image->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $ref_image->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->id) ?>',2);"><div id="elh_ref_image_id" class="ref_image_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->grp->Visible) { // grp ?>
	<?php if ($ref_image->sortUrl($ref_image->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $ref_image->grp->headerCellClass() ?>"><div id="elh_ref_image_grp" class="ref_image_grp"><div class="ew-table-header-caption"><?php echo $ref_image->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $ref_image->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->grp) ?>',2);"><div id="elh_ref_image_grp" class="ref_image_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_image->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->s_grp->Visible) { // s_grp ?>
	<?php if ($ref_image->sortUrl($ref_image->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $ref_image->s_grp->headerCellClass() ?>"><div id="elh_ref_image_s_grp" class="ref_image_s_grp"><div class="ew-table-header-caption"><?php echo $ref_image->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $ref_image->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->s_grp) ?>',2);"><div id="elh_ref_image_s_grp" class="ref_image_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_image->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->product->Visible) { // product ?>
	<?php if ($ref_image->sortUrl($ref_image->product) == "") { ?>
		<th data-name="product" class="<?php echo $ref_image->product->headerCellClass() ?>"><div id="elh_ref_image_product" class="ref_image_product"><div class="ew-table-header-caption"><?php echo $ref_image->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $ref_image->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->product) ?>',2);"><div id="elh_ref_image_product" class="ref_image_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_image->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->product_code->Visible) { // product_code ?>
	<?php if ($ref_image->sortUrl($ref_image->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $ref_image->product_code->headerCellClass() ?>"><div id="elh_ref_image_product_code" class="ref_image_product_code"><div class="ew-table-header-caption"><?php echo $ref_image->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $ref_image->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->product_code) ?>',2);"><div id="elh_ref_image_product_code" class="ref_image_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->main_image->Visible) { // main_image ?>
	<?php if ($ref_image->sortUrl($ref_image->main_image) == "") { ?>
		<th data-name="main_image" class="<?php echo $ref_image->main_image->headerCellClass() ?>"><div id="elh_ref_image_main_image" class="ref_image_main_image"><div class="ew-table-header-caption"><?php echo $ref_image->main_image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="main_image" class="<?php echo $ref_image->main_image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->main_image) ?>',2);"><div id="elh_ref_image_main_image" class="ref_image_main_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->main_image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->main_image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->main_image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->top_view->Visible) { // top_view ?>
	<?php if ($ref_image->sortUrl($ref_image->top_view) == "") { ?>
		<th data-name="top_view" class="<?php echo $ref_image->top_view->headerCellClass() ?>"><div id="elh_ref_image_top_view" class="ref_image_top_view"><div class="ew-table-header-caption"><?php echo $ref_image->top_view->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="top_view" class="<?php echo $ref_image->top_view->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->top_view) ?>',2);"><div id="elh_ref_image_top_view" class="ref_image_top_view">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->top_view->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->top_view->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->top_view->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->front_view->Visible) { // front_view ?>
	<?php if ($ref_image->sortUrl($ref_image->front_view) == "") { ?>
		<th data-name="front_view" class="<?php echo $ref_image->front_view->headerCellClass() ?>"><div id="elh_ref_image_front_view" class="ref_image_front_view"><div class="ew-table-header-caption"><?php echo $ref_image->front_view->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="front_view" class="<?php echo $ref_image->front_view->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->front_view) ?>',2);"><div id="elh_ref_image_front_view" class="ref_image_front_view">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->front_view->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->front_view->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->front_view->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->corner_view->Visible) { // corner_view ?>
	<?php if ($ref_image->sortUrl($ref_image->corner_view) == "") { ?>
		<th data-name="corner_view" class="<?php echo $ref_image->corner_view->headerCellClass() ?>"><div id="elh_ref_image_corner_view" class="ref_image_corner_view"><div class="ew-table-header-caption"><?php echo $ref_image->corner_view->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="corner_view" class="<?php echo $ref_image->corner_view->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->corner_view) ?>',2);"><div id="elh_ref_image_corner_view" class="ref_image_corner_view">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->corner_view->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->corner_view->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->corner_view->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->back_view->Visible) { // back_view ?>
	<?php if ($ref_image->sortUrl($ref_image->back_view) == "") { ?>
		<th data-name="back_view" class="<?php echo $ref_image->back_view->headerCellClass() ?>"><div id="elh_ref_image_back_view" class="ref_image_back_view"><div class="ew-table-header-caption"><?php echo $ref_image->back_view->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="back_view" class="<?php echo $ref_image->back_view->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->back_view) ?>',2);"><div id="elh_ref_image_back_view" class="ref_image_back_view">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->back_view->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->back_view->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->back_view->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->color_options->Visible) { // color_options ?>
	<?php if ($ref_image->sortUrl($ref_image->color_options) == "") { ?>
		<th data-name="color_options" class="<?php echo $ref_image->color_options->headerCellClass() ?>"><div id="elh_ref_image_color_options" class="ref_image_color_options"><div class="ew-table-header-caption"><?php echo $ref_image->color_options->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color_options" class="<?php echo $ref_image->color_options->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->color_options) ?>',2);"><div id="elh_ref_image_color_options" class="ref_image_color_options">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->color_options->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->color_options->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->color_options->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->other_options->Visible) { // other_options ?>
	<?php if ($ref_image->sortUrl($ref_image->other_options) == "") { ?>
		<th data-name="other_options" class="<?php echo $ref_image->other_options->headerCellClass() ?>"><div id="elh_ref_image_other_options" class="ref_image_other_options"><div class="ew-table-header-caption"><?php echo $ref_image->other_options->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other_options" class="<?php echo $ref_image->other_options->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->other_options) ?>',2);"><div id="elh_ref_image_other_options" class="ref_image_other_options">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->other_options->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->other_options->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->other_options->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->video_url->Visible) { // video_url ?>
	<?php if ($ref_image->sortUrl($ref_image->video_url) == "") { ?>
		<th data-name="video_url" class="<?php echo $ref_image->video_url->headerCellClass() ?>"><div id="elh_ref_image_video_url" class="ref_image_video_url"><div class="ew-table-header-caption"><?php echo $ref_image->video_url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="video_url" class="<?php echo $ref_image->video_url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->video_url) ?>',2);"><div id="elh_ref_image_video_url" class="ref_image_video_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->video_url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->video_url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->video_url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->group_image->Visible) { // group_image ?>
	<?php if ($ref_image->sortUrl($ref_image->group_image) == "") { ?>
		<th data-name="group_image" class="<?php echo $ref_image->group_image->headerCellClass() ?>"><div id="elh_ref_image_group_image" class="ref_image_group_image"><div class="ew-table-header-caption"><?php echo $ref_image->group_image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="group_image" class="<?php echo $ref_image->group_image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->group_image) ?>',2);"><div id="elh_ref_image_group_image" class="ref_image_group_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->group_image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->group_image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->group_image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->status->Visible) { // status ?>
	<?php if ($ref_image->sortUrl($ref_image->status) == "") { ?>
		<th data-name="status" class="<?php echo $ref_image->status->headerCellClass() ?>"><div id="elh_ref_image_status" class="ref_image_status"><div class="ew-table-header-caption"><?php echo $ref_image->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $ref_image->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->status) ?>',2);"><div id="elh_ref_image_status" class="ref_image_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_image->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->company_id->Visible) { // company_id ?>
	<?php if ($ref_image->sortUrl($ref_image->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $ref_image->company_id->headerCellClass() ?>"><div id="elh_ref_image_company_id" class="ref_image_company_id"><div class="ew-table-header-caption"><?php echo $ref_image->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $ref_image->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->company_id) ?>',2);"><div id="elh_ref_image_company_id" class="ref_image_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_image->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->product_type->Visible) { // product_type ?>
	<?php if ($ref_image->sortUrl($ref_image->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $ref_image->product_type->headerCellClass() ?>"><div id="elh_ref_image_product_type" class="ref_image_product_type"><div class="ew-table-header-caption"><?php echo $ref_image->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $ref_image->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->product_type) ?>',2);"><div id="elh_ref_image_product_type" class="ref_image_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_image->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->operator->Visible) { // operator ?>
	<?php if ($ref_image->sortUrl($ref_image->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $ref_image->operator->headerCellClass() ?>"><div id="elh_ref_image_operator" class="ref_image_operator"><div class="ew-table-header-caption"><?php echo $ref_image->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $ref_image->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->operator) ?>',2);"><div id="elh_ref_image_operator" class="ref_image_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_image->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_image->datetime->Visible) { // datetime ?>
	<?php if ($ref_image->sortUrl($ref_image->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $ref_image->datetime->headerCellClass() ?>"><div id="elh_ref_image_datetime" class="ref_image_datetime"><div class="ew-table-header-caption"><?php echo $ref_image->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $ref_image->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_image->SortUrl($ref_image->datetime) ?>',2);"><div id="elh_ref_image_datetime" class="ref_image_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_image->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_image->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_image->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ref_image_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ref_image->ExportAll && $ref_image->isExport()) {
	$ref_image_list->StopRec = $ref_image_list->TotalRecs;
} else {

	// Set the last record to display
	if ($ref_image_list->TotalRecs > $ref_image_list->StartRec + $ref_image_list->DisplayRecs - 1)
		$ref_image_list->StopRec = $ref_image_list->StartRec + $ref_image_list->DisplayRecs - 1;
	else
		$ref_image_list->StopRec = $ref_image_list->TotalRecs;
}
$ref_image_list->RecCnt = $ref_image_list->StartRec - 1;
if ($ref_image_list->Recordset && !$ref_image_list->Recordset->EOF) {
	$ref_image_list->Recordset->moveFirst();
	$selectLimit = $ref_image_list->UseSelectLimit;
	if (!$selectLimit && $ref_image_list->StartRec > 1)
		$ref_image_list->Recordset->move($ref_image_list->StartRec - 1);
} elseif (!$ref_image->AllowAddDeleteRow && $ref_image_list->StopRec == 0) {
	$ref_image_list->StopRec = $ref_image->GridAddRowCount;
}

// Initialize aggregate
$ref_image->RowType = ROWTYPE_AGGREGATEINIT;
$ref_image->resetAttributes();
$ref_image_list->renderRow();
while ($ref_image_list->RecCnt < $ref_image_list->StopRec) {
	$ref_image_list->RecCnt++;
	if ($ref_image_list->RecCnt >= $ref_image_list->StartRec) {
		$ref_image_list->RowCnt++;

		// Set up key count
		$ref_image_list->KeyCount = $ref_image_list->RowIndex;

		// Init row class and style
		$ref_image->resetAttributes();
		$ref_image->CssClass = "";
		if ($ref_image->isGridAdd()) {
		} else {
			$ref_image_list->loadRowValues($ref_image_list->Recordset); // Load row values
		}
		$ref_image->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ref_image->RowAttrs = array_merge($ref_image->RowAttrs, array('data-rowindex'=>$ref_image_list->RowCnt, 'id'=>'r' . $ref_image_list->RowCnt . '_ref_image', 'data-rowtype'=>$ref_image->RowType));

		// Render row
		$ref_image_list->renderRow();

		// Render list options
		$ref_image_list->renderListOptions();
?>
	<tr<?php echo $ref_image->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ref_image_list->ListOptions->render("body", "left", $ref_image_list->RowCnt);
?>
	<?php if ($ref_image->id->Visible) { // id ?>
		<td data-name="id"<?php echo $ref_image->id->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_id" class="ref_image_id">
<span<?php echo $ref_image->id->viewAttributes() ?>>
<?php echo $ref_image->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $ref_image->grp->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_grp" class="ref_image_grp">
<span<?php echo $ref_image->grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->grp->getViewValue())) && $ref_image->grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->grp->linkAttributes() ?>><?php echo $ref_image->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $ref_image->s_grp->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_s_grp" class="ref_image_s_grp">
<span<?php echo $ref_image->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->s_grp->getViewValue())) && $ref_image->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->s_grp->linkAttributes() ?>><?php echo $ref_image->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->product->Visible) { // product ?>
		<td data-name="product"<?php echo $ref_image->product->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_product" class="ref_image_product">
<span<?php echo $ref_image->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->product->getViewValue())) && $ref_image->product->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->product->linkAttributes() ?>><?php echo $ref_image->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $ref_image->product_code->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_product_code" class="ref_image_product_code">
<span<?php echo $ref_image->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->product_code->getViewValue())) && $ref_image->product_code->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->product_code->linkAttributes() ?>><?php echo $ref_image->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->main_image->Visible) { // main_image ?>
		<td data-name="main_image"<?php echo $ref_image->main_image->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_main_image" class="ref_image_main_image">
<span>
<?php echo GetFileViewTag($ref_image->main_image, $ref_image->main_image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->top_view->Visible) { // top_view ?>
		<td data-name="top_view"<?php echo $ref_image->top_view->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_top_view" class="ref_image_top_view">
<span>
<?php echo GetFileViewTag($ref_image->top_view, $ref_image->top_view->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->front_view->Visible) { // front_view ?>
		<td data-name="front_view"<?php echo $ref_image->front_view->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_front_view" class="ref_image_front_view">
<span>
<?php echo GetFileViewTag($ref_image->front_view, $ref_image->front_view->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->corner_view->Visible) { // corner_view ?>
		<td data-name="corner_view"<?php echo $ref_image->corner_view->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_corner_view" class="ref_image_corner_view">
<span>
<?php echo GetFileViewTag($ref_image->corner_view, $ref_image->corner_view->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->back_view->Visible) { // back_view ?>
		<td data-name="back_view"<?php echo $ref_image->back_view->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_back_view" class="ref_image_back_view">
<span>
<?php echo GetFileViewTag($ref_image->back_view, $ref_image->back_view->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->color_options->Visible) { // color_options ?>
		<td data-name="color_options"<?php echo $ref_image->color_options->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_color_options" class="ref_image_color_options">
<span>
<?php echo GetFileViewTag($ref_image->color_options, $ref_image->color_options->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->other_options->Visible) { // other_options ?>
		<td data-name="other_options"<?php echo $ref_image->other_options->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_other_options" class="ref_image_other_options">
<span>
<?php echo GetFileViewTag($ref_image->other_options, $ref_image->other_options->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->video_url->Visible) { // video_url ?>
		<td data-name="video_url"<?php echo $ref_image->video_url->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_video_url" class="ref_image_video_url">
<span<?php echo $ref_image->video_url->viewAttributes() ?>>
<?php echo $ref_image->video_url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->group_image->Visible) { // group_image ?>
		<td data-name="group_image"<?php echo $ref_image->group_image->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_group_image" class="ref_image_group_image">
<span<?php echo $ref_image->group_image->viewAttributes() ?>>
<?php echo GetFileViewTag($ref_image->group_image, $ref_image->group_image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->status->Visible) { // status ?>
		<td data-name="status"<?php echo $ref_image->status->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_status" class="ref_image_status">
<span<?php echo $ref_image->status->viewAttributes() ?>>
<?php echo $ref_image->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $ref_image->company_id->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_company_id" class="ref_image_company_id">
<span<?php echo $ref_image->company_id->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->company_id->getViewValue())) && $ref_image->company_id->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->company_id->linkAttributes() ?>><?php echo $ref_image->company_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->company_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $ref_image->product_type->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_product_type" class="ref_image_product_type">
<span<?php echo $ref_image->product_type->viewAttributes() ?>>
<?php echo $ref_image->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $ref_image->operator->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_operator" class="ref_image_operator">
<span<?php echo $ref_image->operator->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->operator->getViewValue())) && $ref_image->operator->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->operator->linkAttributes() ?>><?php echo $ref_image->operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_image->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $ref_image->datetime->cellAttributes() ?>>
<span id="el<?php echo $ref_image_list->RowCnt ?>_ref_image_datetime" class="ref_image_datetime">
<span<?php echo $ref_image->datetime->viewAttributes() ?>>
<?php echo $ref_image->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ref_image_list->ListOptions->render("body", "right", $ref_image_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$ref_image->isGridAdd())
		$ref_image_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$ref_image->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ref_image_list->Recordset)
	$ref_image_list->Recordset->Close();
?>
<?php if (!$ref_image->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ref_image->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ref_image_list->Pager)) $ref_image_list->Pager = new PrevNextPager($ref_image_list->StartRec, $ref_image_list->DisplayRecs, $ref_image_list->TotalRecs, $ref_image_list->AutoHidePager) ?>
<?php if ($ref_image_list->Pager->RecordCount > 0 && $ref_image_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ref_image_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ref_image_list->pageUrl() ?>start=<?php echo $ref_image_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ref_image_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ref_image_list->pageUrl() ?>start=<?php echo $ref_image_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ref_image_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ref_image_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ref_image_list->pageUrl() ?>start=<?php echo $ref_image_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ref_image_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ref_image_list->pageUrl() ?>start=<?php echo $ref_image_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ref_image_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ref_image_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ref_image_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ref_image_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ref_image_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ref_image_list->TotalRecs > 0 && (!$ref_image_list->AutoHidePageSizeSelector || $ref_image_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ref_image">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ref_image_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ref_image_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ref_image_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ref_image_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ref_image_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ref_image->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ref_image_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ref_image_list->TotalRecs == 0 && !$ref_image->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ref_image_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ref_image_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ref_image->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$ref_image->isExport()) { ?>
<script>
ew.scrollableTable("gmp_ref_image", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ref_image_list->terminate();
?>