<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_image_search = new ref_image_search();

// Run the page
$ref_image_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_image_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($ref_image_search->IsModal) { ?>
var fref_imagesearch = currentAdvancedSearchForm = new ew.Form("fref_imagesearch", "search");
<?php } else { ?>
var fref_imagesearch = currentForm = new ew.Form("fref_imagesearch", "search");
<?php } ?>

// Form_CustomValidate event
fref_imagesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_imagesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_imagesearch.lists["x_grp"] = <?php echo $ref_image_search->grp->Lookup->toClientList() ?>;
fref_imagesearch.lists["x_grp"].options = <?php echo JsonEncode($ref_image_search->grp->lookupOptions()) ?>;
fref_imagesearch.lists["x_s_grp"] = <?php echo $ref_image_search->s_grp->Lookup->toClientList() ?>;
fref_imagesearch.lists["x_s_grp"].options = <?php echo JsonEncode($ref_image_search->s_grp->lookupOptions()) ?>;
fref_imagesearch.lists["x_product"] = <?php echo $ref_image_search->product->Lookup->toClientList() ?>;
fref_imagesearch.lists["x_product"].options = <?php echo JsonEncode($ref_image_search->product->lookupOptions()) ?>;
fref_imagesearch.lists["x_status"] = <?php echo $ref_image_search->status->Lookup->toClientList() ?>;
fref_imagesearch.lists["x_status"].options = <?php echo JsonEncode($ref_image_search->status->options(FALSE, TRUE)) ?>;
fref_imagesearch.lists["x_company_id"] = <?php echo $ref_image_search->company_id->Lookup->toClientList() ?>;
fref_imagesearch.lists["x_company_id"].options = <?php echo JsonEncode($ref_image_search->company_id->lookupOptions()) ?>;
fref_imagesearch.lists["x_product_type"] = <?php echo $ref_image_search->product_type->Lookup->toClientList() ?>;
fref_imagesearch.lists["x_product_type"].options = <?php echo JsonEncode($ref_image_search->product_type->lookupOptions()) ?>;
fref_imagesearch.lists["x_operator"] = <?php echo $ref_image_search->operator->Lookup->toClientList() ?>;
fref_imagesearch.lists["x_operator"].options = <?php echo JsonEncode($ref_image_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fref_imagesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref_image->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_image_search->showPageHeader(); ?>
<?php
$ref_image_search->showMessage();
?>
<form name="fref_imagesearch" id="fref_imagesearch" class="<?php echo $ref_image_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_image_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_image_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_image">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$ref_image_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($ref_image->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_id"><?php echo $ref_image->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->id->cellAttributes() ?>>
			<span id="el_ref_image_id">
<input type="text" data-table="ref_image" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($ref_image->id->getPlaceHolder()) ?>" value="<?php echo $ref_image->id->EditValue ?>"<?php echo $ref_image->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_grp"><?php echo $ref_image->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->grp->cellAttributes() ?>>
			<span id="el_ref_image_grp">
<?php $ref_image->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_image->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_grp" data-value-separator="<?php echo $ref_image->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref_image->grp->editAttributes() ?>>
		<?php echo $ref_image->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $ref_image->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_s_grp"><?php echo $ref_image->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->s_grp->cellAttributes() ?>>
			<span id="el_ref_image_s_grp">
<?php $ref_image->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_image->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_s_grp" data-value-separator="<?php echo $ref_image->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref_image->s_grp->editAttributes() ?>>
		<?php echo $ref_image->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref_image->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_product"><?php echo $ref_image->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->product->cellAttributes() ?>>
			<span id="el_ref_image_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_product" data-value-separator="<?php echo $ref_image->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref_image->product->editAttributes() ?>>
		<?php echo $ref_image->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $ref_image->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_product_code"><?php echo $ref_image->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->product_code->cellAttributes() ?>>
			<span id="el_ref_image_product_code">
<input type="text" data-table="ref_image" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_image->product_code->getPlaceHolder()) ?>" value="<?php echo $ref_image->product_code->EditValue ?>"<?php echo $ref_image->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->main_image->Visible) { // main_image ?>
	<div id="r_main_image" class="form-group row">
		<label class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_main_image"><?php echo $ref_image->main_image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_main_image" id="z_main_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->main_image->cellAttributes() ?>>
			<span id="el_ref_image_main_image">
<input type="text" data-table="ref_image" data-field="x_main_image" name="x_main_image" id="x_main_image" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_image->main_image->getPlaceHolder()) ?>" value="<?php echo $ref_image->main_image->EditValue ?>"<?php echo $ref_image->main_image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->top_view->Visible) { // top_view ?>
	<div id="r_top_view" class="form-group row">
		<label class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_top_view"><?php echo $ref_image->top_view->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_top_view" id="z_top_view" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->top_view->cellAttributes() ?>>
			<span id="el_ref_image_top_view">
<input type="text" data-table="ref_image" data-field="x_top_view" name="x_top_view" id="x_top_view" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_image->top_view->getPlaceHolder()) ?>" value="<?php echo $ref_image->top_view->EditValue ?>"<?php echo $ref_image->top_view->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->front_view->Visible) { // front_view ?>
	<div id="r_front_view" class="form-group row">
		<label class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_front_view"><?php echo $ref_image->front_view->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_front_view" id="z_front_view" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->front_view->cellAttributes() ?>>
			<span id="el_ref_image_front_view">
<input type="text" data-table="ref_image" data-field="x_front_view" name="x_front_view" id="x_front_view" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_image->front_view->getPlaceHolder()) ?>" value="<?php echo $ref_image->front_view->EditValue ?>"<?php echo $ref_image->front_view->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->corner_view->Visible) { // corner_view ?>
	<div id="r_corner_view" class="form-group row">
		<label class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_corner_view"><?php echo $ref_image->corner_view->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_corner_view" id="z_corner_view" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->corner_view->cellAttributes() ?>>
			<span id="el_ref_image_corner_view">
<input type="text" data-table="ref_image" data-field="x_corner_view" name="x_corner_view" id="x_corner_view" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_image->corner_view->getPlaceHolder()) ?>" value="<?php echo $ref_image->corner_view->EditValue ?>"<?php echo $ref_image->corner_view->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->back_view->Visible) { // back_view ?>
	<div id="r_back_view" class="form-group row">
		<label class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_back_view"><?php echo $ref_image->back_view->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_back_view" id="z_back_view" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->back_view->cellAttributes() ?>>
			<span id="el_ref_image_back_view">
<input type="text" data-table="ref_image" data-field="x_back_view" name="x_back_view" id="x_back_view" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_image->back_view->getPlaceHolder()) ?>" value="<?php echo $ref_image->back_view->EditValue ?>"<?php echo $ref_image->back_view->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->color_options->Visible) { // color_options ?>
	<div id="r_color_options" class="form-group row">
		<label class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_color_options"><?php echo $ref_image->color_options->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_color_options" id="z_color_options" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->color_options->cellAttributes() ?>>
			<span id="el_ref_image_color_options">
<input type="text" data-table="ref_image" data-field="x_color_options" name="x_color_options" id="x_color_options" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_image->color_options->getPlaceHolder()) ?>" value="<?php echo $ref_image->color_options->EditValue ?>"<?php echo $ref_image->color_options->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->other_options->Visible) { // other_options ?>
	<div id="r_other_options" class="form-group row">
		<label class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_other_options"><?php echo $ref_image->other_options->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other_options" id="z_other_options" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->other_options->cellAttributes() ?>>
			<span id="el_ref_image_other_options">
<input type="text" data-table="ref_image" data-field="x_other_options" name="x_other_options" id="x_other_options" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_image->other_options->getPlaceHolder()) ?>" value="<?php echo $ref_image->other_options->EditValue ?>"<?php echo $ref_image->other_options->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->video_url->Visible) { // video_url ?>
	<div id="r_video_url" class="form-group row">
		<label for="x_video_url" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_video_url"><?php echo $ref_image->video_url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_video_url" id="z_video_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->video_url->cellAttributes() ?>>
			<span id="el_ref_image_video_url">
<input type="text" data-table="ref_image" data-field="x_video_url" name="x_video_url" id="x_video_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($ref_image->video_url->getPlaceHolder()) ?>" value="<?php echo $ref_image->video_url->EditValue ?>"<?php echo $ref_image->video_url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->group_image->Visible) { // group_image ?>
	<div id="r_group_image" class="form-group row">
		<label class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_group_image"><?php echo $ref_image->group_image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_group_image" id="z_group_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->group_image->cellAttributes() ?>>
			<span id="el_ref_image_group_image">
<input type="text" data-table="ref_image" data-field="x_group_image" name="x_group_image" id="x_group_image" size="30" maxlength="196" placeholder="<?php echo HtmlEncode($ref_image->group_image->getPlaceHolder()) ?>" value="<?php echo $ref_image->group_image->EditValue ?>"<?php echo $ref_image->group_image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_status"><?php echo $ref_image->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->status->cellAttributes() ?>>
			<span id="el_ref_image_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_status" data-value-separator="<?php echo $ref_image->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ref_image->status->editAttributes() ?>>
		<?php echo $ref_image->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_company_id"><?php echo $ref_image->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->company_id->cellAttributes() ?>>
			<span id="el_ref_image_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_company_id" data-value-separator="<?php echo $ref_image->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $ref_image->company_id->editAttributes() ?>>
		<?php echo $ref_image->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $ref_image->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_product_type"><?php echo $ref_image->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_type" id="z_product_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->product_type->cellAttributes() ?>>
			<span id="el_ref_image_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_product_type" data-value-separator="<?php echo $ref_image->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $ref_image->product_type->editAttributes() ?>>
		<?php echo $ref_image->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $ref_image->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_operator"><?php echo $ref_image->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->operator->cellAttributes() ?>>
			<span id="el_ref_image_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_image" data-field="x_operator" data-value-separator="<?php echo $ref_image->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $ref_image->operator->editAttributes() ?>>
		<?php echo $ref_image->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $ref_image->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref_image->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $ref_image_search->LeftColumnClass ?>"><span id="elh_ref_image_datetime"><?php echo $ref_image->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $ref_image_search->RightColumnClass ?>"><div<?php echo $ref_image->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($ref_image->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($ref_image->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($ref_image->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($ref_image->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($ref_image->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($ref_image->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($ref_image->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_ref_image_datetime">
<input type="text" data-table="ref_image" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($ref_image->datetime->getPlaceHolder()) ?>" value="<?php echo $ref_image->datetime->EditValue ?>"<?php echo $ref_image->datetime->editAttributes() ?>>
<?php if (!$ref_image->datetime->ReadOnly && !$ref_image->datetime->Disabled && !isset($ref_image->datetime->EditAttrs["readonly"]) && !isset($ref_image->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fref_imagesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_ref_image_datetime" class="btw1_datetime d-none">
<input type="text" data-table="ref_image" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($ref_image->datetime->getPlaceHolder()) ?>" value="<?php echo $ref_image->datetime->EditValue2 ?>"<?php echo $ref_image->datetime->editAttributes() ?>>
<?php if (!$ref_image->datetime->ReadOnly && !$ref_image->datetime->Disabled && !isset($ref_image->datetime->EditAttrs["readonly"]) && !isset($ref_image->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fref_imagesearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ref_image_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ref_image_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ref_image_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ref_image_search->terminate();
?>