<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_image_view = new ref_image_view();

// Run the page
$ref_image_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_image_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ref_image->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fref_imageview = currentForm = new ew.Form("fref_imageview", "view");

// Form_CustomValidate event
fref_imageview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_imageview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_imageview.lists["x_grp"] = <?php echo $ref_image_view->grp->Lookup->toClientList() ?>;
fref_imageview.lists["x_grp"].options = <?php echo JsonEncode($ref_image_view->grp->lookupOptions()) ?>;
fref_imageview.lists["x_s_grp"] = <?php echo $ref_image_view->s_grp->Lookup->toClientList() ?>;
fref_imageview.lists["x_s_grp"].options = <?php echo JsonEncode($ref_image_view->s_grp->lookupOptions()) ?>;
fref_imageview.lists["x_product"] = <?php echo $ref_image_view->product->Lookup->toClientList() ?>;
fref_imageview.lists["x_product"].options = <?php echo JsonEncode($ref_image_view->product->lookupOptions()) ?>;
fref_imageview.lists["x_status"] = <?php echo $ref_image_view->status->Lookup->toClientList() ?>;
fref_imageview.lists["x_status"].options = <?php echo JsonEncode($ref_image_view->status->options(FALSE, TRUE)) ?>;
fref_imageview.lists["x_company_id"] = <?php echo $ref_image_view->company_id->Lookup->toClientList() ?>;
fref_imageview.lists["x_company_id"].options = <?php echo JsonEncode($ref_image_view->company_id->lookupOptions()) ?>;
fref_imageview.lists["x_product_type"] = <?php echo $ref_image_view->product_type->Lookup->toClientList() ?>;
fref_imageview.lists["x_product_type"].options = <?php echo JsonEncode($ref_image_view->product_type->lookupOptions()) ?>;
fref_imageview.lists["x_operator"] = <?php echo $ref_image_view->operator->Lookup->toClientList() ?>;
fref_imageview.lists["x_operator"].options = <?php echo JsonEncode($ref_image_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ref_image->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ref_image_view->ExportOptions->render("body") ?>
<?php $ref_image_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ref_image_view->showPageHeader(); ?>
<?php
$ref_image_view->showMessage();
?>
<form name="fref_imageview" id="fref_imageview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_image_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_image_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_image">
<input type="hidden" name="modal" value="<?php echo (int)$ref_image_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref_image->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_id"><?php echo $ref_image->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ref_image->id->cellAttributes() ?>>
<span id="el_ref_image_id">
<span<?php echo $ref_image->id->viewAttributes() ?>>
<?php echo $ref_image->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_grp"><?php echo $ref_image->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $ref_image->grp->cellAttributes() ?>>
<span id="el_ref_image_grp">
<span<?php echo $ref_image->grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->grp->getViewValue())) && $ref_image->grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->grp->linkAttributes() ?>><?php echo $ref_image->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_s_grp"><?php echo $ref_image->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $ref_image->s_grp->cellAttributes() ?>>
<span id="el_ref_image_s_grp">
<span<?php echo $ref_image->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->s_grp->getViewValue())) && $ref_image->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->s_grp->linkAttributes() ?>><?php echo $ref_image->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_product"><?php echo $ref_image->product->caption() ?></span></td>
		<td data-name="product"<?php echo $ref_image->product->cellAttributes() ?>>
<span id="el_ref_image_product">
<span<?php echo $ref_image->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->product->getViewValue())) && $ref_image->product->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->product->linkAttributes() ?>><?php echo $ref_image->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_product_code"><?php echo $ref_image->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $ref_image->product_code->cellAttributes() ?>>
<span id="el_ref_image_product_code">
<span<?php echo $ref_image->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->product_code->getViewValue())) && $ref_image->product_code->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->product_code->linkAttributes() ?>><?php echo $ref_image->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->main_image->Visible) { // main_image ?>
	<tr id="r_main_image">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_main_image"><?php echo $ref_image->main_image->caption() ?></span></td>
		<td data-name="main_image"<?php echo $ref_image->main_image->cellAttributes() ?>>
<span id="el_ref_image_main_image">
<span>
<?php echo GetFileViewTag($ref_image->main_image, $ref_image->main_image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->top_view->Visible) { // top_view ?>
	<tr id="r_top_view">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_top_view"><?php echo $ref_image->top_view->caption() ?></span></td>
		<td data-name="top_view"<?php echo $ref_image->top_view->cellAttributes() ?>>
<span id="el_ref_image_top_view">
<span>
<?php echo GetFileViewTag($ref_image->top_view, $ref_image->top_view->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->front_view->Visible) { // front_view ?>
	<tr id="r_front_view">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_front_view"><?php echo $ref_image->front_view->caption() ?></span></td>
		<td data-name="front_view"<?php echo $ref_image->front_view->cellAttributes() ?>>
<span id="el_ref_image_front_view">
<span>
<?php echo GetFileViewTag($ref_image->front_view, $ref_image->front_view->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->corner_view->Visible) { // corner_view ?>
	<tr id="r_corner_view">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_corner_view"><?php echo $ref_image->corner_view->caption() ?></span></td>
		<td data-name="corner_view"<?php echo $ref_image->corner_view->cellAttributes() ?>>
<span id="el_ref_image_corner_view">
<span>
<?php echo GetFileViewTag($ref_image->corner_view, $ref_image->corner_view->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->back_view->Visible) { // back_view ?>
	<tr id="r_back_view">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_back_view"><?php echo $ref_image->back_view->caption() ?></span></td>
		<td data-name="back_view"<?php echo $ref_image->back_view->cellAttributes() ?>>
<span id="el_ref_image_back_view">
<span>
<?php echo GetFileViewTag($ref_image->back_view, $ref_image->back_view->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->color_options->Visible) { // color_options ?>
	<tr id="r_color_options">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_color_options"><?php echo $ref_image->color_options->caption() ?></span></td>
		<td data-name="color_options"<?php echo $ref_image->color_options->cellAttributes() ?>>
<span id="el_ref_image_color_options">
<span>
<?php echo GetFileViewTag($ref_image->color_options, $ref_image->color_options->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->other_options->Visible) { // other_options ?>
	<tr id="r_other_options">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_other_options"><?php echo $ref_image->other_options->caption() ?></span></td>
		<td data-name="other_options"<?php echo $ref_image->other_options->cellAttributes() ?>>
<span id="el_ref_image_other_options">
<span>
<?php echo GetFileViewTag($ref_image->other_options, $ref_image->other_options->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->video_url->Visible) { // video_url ?>
	<tr id="r_video_url">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_video_url"><?php echo $ref_image->video_url->caption() ?></span></td>
		<td data-name="video_url"<?php echo $ref_image->video_url->cellAttributes() ?>>
<span id="el_ref_image_video_url">
<span<?php echo $ref_image->video_url->viewAttributes() ?>>
<?php echo $ref_image->video_url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->group_image->Visible) { // group_image ?>
	<tr id="r_group_image">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_group_image"><?php echo $ref_image->group_image->caption() ?></span></td>
		<td data-name="group_image"<?php echo $ref_image->group_image->cellAttributes() ?>>
<span id="el_ref_image_group_image">
<span<?php echo $ref_image->group_image->viewAttributes() ?>>
<?php echo GetFileViewTag($ref_image->group_image, $ref_image->group_image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_status"><?php echo $ref_image->status->caption() ?></span></td>
		<td data-name="status"<?php echo $ref_image->status->cellAttributes() ?>>
<span id="el_ref_image_status">
<span<?php echo $ref_image->status->viewAttributes() ?>>
<?php echo $ref_image->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_company_id"><?php echo $ref_image->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $ref_image->company_id->cellAttributes() ?>>
<span id="el_ref_image_company_id">
<span<?php echo $ref_image->company_id->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->company_id->getViewValue())) && $ref_image->company_id->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->company_id->linkAttributes() ?>><?php echo $ref_image->company_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->company_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->product_type->Visible) { // product_type ?>
	<tr id="r_product_type">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_product_type"><?php echo $ref_image->product_type->caption() ?></span></td>
		<td data-name="product_type"<?php echo $ref_image->product_type->cellAttributes() ?>>
<span id="el_ref_image_product_type">
<span<?php echo $ref_image->product_type->viewAttributes() ?>>
<?php echo $ref_image->product_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_operator"><?php echo $ref_image->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $ref_image->operator->cellAttributes() ?>>
<span id="el_ref_image_operator">
<span<?php echo $ref_image->operator->viewAttributes() ?>>
<?php if ((!EmptyString($ref_image->operator->getViewValue())) && $ref_image->operator->linkAttributes() <> "") { ?>
<a<?php echo $ref_image->operator->linkAttributes() ?>><?php echo $ref_image->operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref_image->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref_image->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $ref_image_view->TableLeftColumnClass ?>"><span id="elh_ref_image_datetime"><?php echo $ref_image->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $ref_image->datetime->cellAttributes() ?>>
<span id="el_ref_image_datetime">
<span<?php echo $ref_image->datetime->viewAttributes() ?>>
<?php echo $ref_image->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$ref_image_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ref_image->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ref_image_view->terminate();
?>