<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_multi_add = new ref_multi_add();

// Run the page
$ref_multi_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_multi_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fref_multiadd = currentForm = new ew.Form("fref_multiadd", "add");

// Validate form
fref_multiadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ref_multi_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->company_id->caption(), $ref_multi->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->grp->caption(), $ref_multi->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->s_grp->caption(), $ref_multi->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->product->caption(), $ref_multi->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->product_n->Required) { ?>
			elm = this.getElements("x" + infix + "_product_n");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->product_n->caption(), $ref_multi->product_n->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->product_type->caption(), $ref_multi->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->last_price->Required) { ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->last_price->caption(), $ref_multi->last_price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref_multi->last_price->errorMessage()) ?>");
		<?php if ($ref_multi_add->v_01->Required) { ?>
			elm = this.getElements("x" + infix + "_v_01[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_01->caption(), $ref_multi->v_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_02->Required) { ?>
			elm = this.getElements("x" + infix + "_v_02[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_02->caption(), $ref_multi->v_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_03->Required) { ?>
			elm = this.getElements("x" + infix + "_v_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_03->caption(), $ref_multi->v_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_04->Required) { ?>
			elm = this.getElements("x" + infix + "_v_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_04->caption(), $ref_multi->v_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_05->Required) { ?>
			elm = this.getElements("x" + infix + "_v_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_05->caption(), $ref_multi->v_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_06->Required) { ?>
			elm = this.getElements("x" + infix + "_v_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_06->caption(), $ref_multi->v_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_07->Required) { ?>
			elm = this.getElements("x" + infix + "_v_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_07->caption(), $ref_multi->v_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_08->Required) { ?>
			elm = this.getElements("x" + infix + "_v_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_08->caption(), $ref_multi->v_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_09->Required) { ?>
			elm = this.getElements("x" + infix + "_v_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_09->caption(), $ref_multi->v_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->v_10->Required) { ?>
			elm = this.getElements("x" + infix + "_v_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->v_10->caption(), $ref_multi->v_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->cbm->caption(), $ref_multi->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->sqm->caption(), $ref_multi->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->shape->caption(), $ref_multi->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_01->Required) { ?>
			elm = this.getElements("x" + infix + "_b_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_01->caption(), $ref_multi->b_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_02->Required) { ?>
			elm = this.getElements("x" + infix + "_b_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_02->caption(), $ref_multi->b_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_03->Required) { ?>
			elm = this.getElements("x" + infix + "_b_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_03->caption(), $ref_multi->b_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_04->Required) { ?>
			elm = this.getElements("x" + infix + "_b_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_04->caption(), $ref_multi->b_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_05->Required) { ?>
			elm = this.getElements("x" + infix + "_b_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_05->caption(), $ref_multi->b_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_06->Required) { ?>
			elm = this.getElements("x" + infix + "_b_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_06->caption(), $ref_multi->b_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_07->Required) { ?>
			elm = this.getElements("x" + infix + "_b_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_07->caption(), $ref_multi->b_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_08->Required) { ?>
			elm = this.getElements("x" + infix + "_b_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_08->caption(), $ref_multi->b_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_09->Required) { ?>
			elm = this.getElements("x" + infix + "_b_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_09->caption(), $ref_multi->b_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_10->Required) { ?>
			elm = this.getElements("x" + infix + "_b_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_10->caption(), $ref_multi->b_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_11->Required) { ?>
			elm = this.getElements("x" + infix + "_b_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_11->caption(), $ref_multi->b_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_12->Required) { ?>
			elm = this.getElements("x" + infix + "_b_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_12->caption(), $ref_multi->b_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_13->Required) { ?>
			elm = this.getElements("x" + infix + "_b_13");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_13->caption(), $ref_multi->b_13->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_14->Required) { ?>
			elm = this.getElements("x" + infix + "_b_14");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_14->caption(), $ref_multi->b_14->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->b_15->Required) { ?>
			elm = this.getElements("x" + infix + "_b_15");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->b_15->caption(), $ref_multi->b_15->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_01->Required) { ?>
			elm = this.getElements("x" + infix + "_t_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_01->caption(), $ref_multi->t_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_02->Required) { ?>
			elm = this.getElements("x" + infix + "_t_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_02->caption(), $ref_multi->t_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_03->Required) { ?>
			elm = this.getElements("x" + infix + "_t_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_03->caption(), $ref_multi->t_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_04->Required) { ?>
			elm = this.getElements("x" + infix + "_t_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_04->caption(), $ref_multi->t_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_05->Required) { ?>
			elm = this.getElements("x" + infix + "_t_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_05->caption(), $ref_multi->t_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_06->Required) { ?>
			elm = this.getElements("x" + infix + "_t_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_06->caption(), $ref_multi->t_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_07->Required) { ?>
			elm = this.getElements("x" + infix + "_t_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_07->caption(), $ref_multi->t_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_08->Required) { ?>
			elm = this.getElements("x" + infix + "_t_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_08->caption(), $ref_multi->t_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_09->Required) { ?>
			elm = this.getElements("x" + infix + "_t_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_09->caption(), $ref_multi->t_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_10->Required) { ?>
			elm = this.getElements("x" + infix + "_t_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_10->caption(), $ref_multi->t_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_11->Required) { ?>
			elm = this.getElements("x" + infix + "_t_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_11->caption(), $ref_multi->t_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_12->Required) { ?>
			elm = this.getElements("x" + infix + "_t_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_12->caption(), $ref_multi->t_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_13->Required) { ?>
			elm = this.getElements("x" + infix + "_t_13");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_13->caption(), $ref_multi->t_13->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_14->Required) { ?>
			elm = this.getElements("x" + infix + "_t_14");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_14->caption(), $ref_multi->t_14->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->t_15->Required) { ?>
			elm = this.getElements("x" + infix + "_t_15");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->t_15->caption(), $ref_multi->t_15->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->d_head_01->Required) { ?>
			elm = this.getElements("x" + infix + "_d_head_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->d_head_01->caption(), $ref_multi->d_head_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->d_description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_d_description_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->d_description_01->caption(), $ref_multi->d_description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->d_head_02->Required) { ?>
			elm = this.getElements("x" + infix + "_d_head_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->d_head_02->caption(), $ref_multi->d_head_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->d_description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_d_description_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->d_description_02->caption(), $ref_multi->d_description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->main_image->Required) { ?>
			felm = this.getElements("x" + infix + "_main_image");
			elm = this.getElements("fn_x" + infix + "_main_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_multi->main_image->caption(), $ref_multi->main_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->top_view->Required) { ?>
			felm = this.getElements("x" + infix + "_top_view");
			elm = this.getElements("fn_x" + infix + "_top_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_multi->top_view->caption(), $ref_multi->top_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->front_view->Required) { ?>
			felm = this.getElements("x" + infix + "_front_view");
			elm = this.getElements("fn_x" + infix + "_front_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_multi->front_view->caption(), $ref_multi->front_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->corner_view->Required) { ?>
			felm = this.getElements("x" + infix + "_corner_view");
			elm = this.getElements("fn_x" + infix + "_corner_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_multi->corner_view->caption(), $ref_multi->corner_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->back_view->Required) { ?>
			felm = this.getElements("x" + infix + "_back_view");
			elm = this.getElements("fn_x" + infix + "_back_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_multi->back_view->caption(), $ref_multi->back_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->color_options->Required) { ?>
			felm = this.getElements("x" + infix + "_color_options");
			elm = this.getElements("fn_x" + infix + "_color_options");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_multi->color_options->caption(), $ref_multi->color_options->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->other_options->Required) { ?>
			felm = this.getElements("x" + infix + "_other_options");
			elm = this.getElements("fn_x" + infix + "_other_options");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_multi->other_options->caption(), $ref_multi->other_options->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref_multi->image->caption(), $ref_multi->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->video_url->Required) { ?>
			elm = this.getElements("x" + infix + "_video_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->video_url->caption(), $ref_multi->video_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->currency->caption(), $ref_multi->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->hsn->Required) { ?>
			elm = this.getElements("x" + infix + "_hsn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->hsn->caption(), $ref_multi->hsn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->status->caption(), $ref_multi->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->publish->Required) { ?>
			elm = this.getElements("x" + infix + "_publish");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->publish->caption(), $ref_multi->publish->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->operator->caption(), $ref_multi->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_multi_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref_multi->datetime->caption(), $ref_multi->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fref_multiadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_multiadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fref_multiadd.multiPage = new ew.MultiPage("fref_multiadd");

// Dynamic selection lists
fref_multiadd.lists["x_company_id"] = <?php echo $ref_multi_add->company_id->Lookup->toClientList() ?>;
fref_multiadd.lists["x_company_id"].options = <?php echo JsonEncode($ref_multi_add->company_id->lookupOptions()) ?>;
fref_multiadd.lists["x_grp"] = <?php echo $ref_multi_add->grp->Lookup->toClientList() ?>;
fref_multiadd.lists["x_grp"].options = <?php echo JsonEncode($ref_multi_add->grp->lookupOptions()) ?>;
fref_multiadd.lists["x_s_grp"] = <?php echo $ref_multi_add->s_grp->Lookup->toClientList() ?>;
fref_multiadd.lists["x_s_grp"].options = <?php echo JsonEncode($ref_multi_add->s_grp->lookupOptions()) ?>;
fref_multiadd.lists["x_product"] = <?php echo $ref_multi_add->product->Lookup->toClientList() ?>;
fref_multiadd.lists["x_product"].options = <?php echo JsonEncode($ref_multi_add->product->lookupOptions()) ?>;
fref_multiadd.lists["x_product_type"] = <?php echo $ref_multi_add->product_type->Lookup->toClientList() ?>;
fref_multiadd.lists["x_product_type"].options = <?php echo JsonEncode($ref_multi_add->product_type->lookupOptions()) ?>;
fref_multiadd.autoSuggests["x_product_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fref_multiadd.lists["x_v_01[]"] = <?php echo $ref_multi_add->v_01->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_01[]"].options = <?php echo JsonEncode($ref_multi_add->v_01->lookupOptions()) ?>;
fref_multiadd.lists["x_v_02[]"] = <?php echo $ref_multi_add->v_02->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_02[]"].options = <?php echo JsonEncode($ref_multi_add->v_02->lookupOptions()) ?>;
fref_multiadd.lists["x_v_03[]"] = <?php echo $ref_multi_add->v_03->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_03[]"].options = <?php echo JsonEncode($ref_multi_add->v_03->lookupOptions()) ?>;
fref_multiadd.lists["x_v_04[]"] = <?php echo $ref_multi_add->v_04->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_04[]"].options = <?php echo JsonEncode($ref_multi_add->v_04->lookupOptions()) ?>;
fref_multiadd.lists["x_v_05[]"] = <?php echo $ref_multi_add->v_05->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_05[]"].options = <?php echo JsonEncode($ref_multi_add->v_05->lookupOptions()) ?>;
fref_multiadd.lists["x_v_06[]"] = <?php echo $ref_multi_add->v_06->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_06[]"].options = <?php echo JsonEncode($ref_multi_add->v_06->lookupOptions()) ?>;
fref_multiadd.lists["x_v_07[]"] = <?php echo $ref_multi_add->v_07->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_07[]"].options = <?php echo JsonEncode($ref_multi_add->v_07->lookupOptions()) ?>;
fref_multiadd.lists["x_v_08[]"] = <?php echo $ref_multi_add->v_08->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_08[]"].options = <?php echo JsonEncode($ref_multi_add->v_08->lookupOptions()) ?>;
fref_multiadd.lists["x_v_09[]"] = <?php echo $ref_multi_add->v_09->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_09[]"].options = <?php echo JsonEncode($ref_multi_add->v_09->lookupOptions()) ?>;
fref_multiadd.lists["x_v_10[]"] = <?php echo $ref_multi_add->v_10->Lookup->toClientList() ?>;
fref_multiadd.lists["x_v_10[]"].options = <?php echo JsonEncode($ref_multi_add->v_10->lookupOptions()) ?>;
fref_multiadd.lists["x_shape[]"] = <?php echo $ref_multi_add->shape->Lookup->toClientList() ?>;
fref_multiadd.lists["x_shape[]"].options = <?php echo JsonEncode($ref_multi_add->shape->lookupOptions()) ?>;
fref_multiadd.lists["x_b_03[]"] = <?php echo $ref_multi_add->b_03->Lookup->toClientList() ?>;
fref_multiadd.lists["x_b_03[]"].options = <?php echo JsonEncode($ref_multi_add->b_03->lookupOptions()) ?>;
fref_multiadd.lists["x_b_04[]"] = <?php echo $ref_multi_add->b_04->Lookup->toClientList() ?>;
fref_multiadd.lists["x_b_04[]"].options = <?php echo JsonEncode($ref_multi_add->b_04->lookupOptions()) ?>;
fref_multiadd.lists["x_b_05[]"] = <?php echo $ref_multi_add->b_05->Lookup->toClientList() ?>;
fref_multiadd.lists["x_b_05[]"].options = <?php echo JsonEncode($ref_multi_add->b_05->lookupOptions()) ?>;
fref_multiadd.lists["x_b_06[]"] = <?php echo $ref_multi_add->b_06->Lookup->toClientList() ?>;
fref_multiadd.lists["x_b_06[]"].options = <?php echo JsonEncode($ref_multi_add->b_06->lookupOptions()) ?>;
fref_multiadd.lists["x_b_07[]"] = <?php echo $ref_multi_add->b_07->Lookup->toClientList() ?>;
fref_multiadd.lists["x_b_07[]"].options = <?php echo JsonEncode($ref_multi_add->b_07->lookupOptions()) ?>;
fref_multiadd.lists["x_b_08[]"] = <?php echo $ref_multi_add->b_08->Lookup->toClientList() ?>;
fref_multiadd.lists["x_b_08[]"].options = <?php echo JsonEncode($ref_multi_add->b_08->lookupOptions()) ?>;
fref_multiadd.lists["x_b_09[]"] = <?php echo $ref_multi_add->b_09->Lookup->toClientList() ?>;
fref_multiadd.lists["x_b_09[]"].options = <?php echo JsonEncode($ref_multi_add->b_09->lookupOptions()) ?>;
fref_multiadd.lists["x_b_10[]"] = <?php echo $ref_multi_add->b_10->Lookup->toClientList() ?>;
fref_multiadd.lists["x_b_10[]"].options = <?php echo JsonEncode($ref_multi_add->b_10->lookupOptions()) ?>;
fref_multiadd.lists["x_t_03[]"] = <?php echo $ref_multi_add->t_03->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_03[]"].options = <?php echo JsonEncode($ref_multi_add->t_03->lookupOptions()) ?>;
fref_multiadd.lists["x_t_04[]"] = <?php echo $ref_multi_add->t_04->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_04[]"].options = <?php echo JsonEncode($ref_multi_add->t_04->lookupOptions()) ?>;
fref_multiadd.lists["x_t_05[]"] = <?php echo $ref_multi_add->t_05->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_05[]"].options = <?php echo JsonEncode($ref_multi_add->t_05->lookupOptions()) ?>;
fref_multiadd.lists["x_t_06[]"] = <?php echo $ref_multi_add->t_06->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_06[]"].options = <?php echo JsonEncode($ref_multi_add->t_06->lookupOptions()) ?>;
fref_multiadd.lists["x_t_07[]"] = <?php echo $ref_multi_add->t_07->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_07[]"].options = <?php echo JsonEncode($ref_multi_add->t_07->lookupOptions()) ?>;
fref_multiadd.lists["x_t_08[]"] = <?php echo $ref_multi_add->t_08->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_08[]"].options = <?php echo JsonEncode($ref_multi_add->t_08->lookupOptions()) ?>;
fref_multiadd.lists["x_t_09[]"] = <?php echo $ref_multi_add->t_09->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_09[]"].options = <?php echo JsonEncode($ref_multi_add->t_09->lookupOptions()) ?>;
fref_multiadd.lists["x_t_10[]"] = <?php echo $ref_multi_add->t_10->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_10[]"].options = <?php echo JsonEncode($ref_multi_add->t_10->lookupOptions()) ?>;
fref_multiadd.lists["x_t_11"] = <?php echo $ref_multi_add->t_11->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_11"].options = <?php echo JsonEncode($ref_multi_add->t_11->lookupOptions()) ?>;
fref_multiadd.autoSuggests["x_t_11"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fref_multiadd.lists["x_t_12"] = <?php echo $ref_multi_add->t_12->Lookup->toClientList() ?>;
fref_multiadd.lists["x_t_12"].options = <?php echo JsonEncode($ref_multi_add->t_12->lookupOptions()) ?>;
fref_multiadd.autoSuggests["x_t_12"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fref_multiadd.lists["x_currency"] = <?php echo $ref_multi_add->currency->Lookup->toClientList() ?>;
fref_multiadd.lists["x_currency"].options = <?php echo JsonEncode($ref_multi_add->currency->lookupOptions()) ?>;
fref_multiadd.lists["x_hsn"] = <?php echo $ref_multi_add->hsn->Lookup->toClientList() ?>;
fref_multiadd.lists["x_hsn"].options = <?php echo JsonEncode($ref_multi_add->hsn->lookupOptions()) ?>;
fref_multiadd.lists["x_status"] = <?php echo $ref_multi_add->status->Lookup->toClientList() ?>;
fref_multiadd.lists["x_status"].options = <?php echo JsonEncode($ref_multi_add->status->options(FALSE, TRUE)) ?>;
fref_multiadd.lists["x_publish"] = <?php echo $ref_multi_add->publish->Lookup->toClientList() ?>;
fref_multiadd.lists["x_publish"].options = <?php echo JsonEncode($ref_multi_add->publish->options(FALSE, TRUE)) ?>;
fref_multiadd.lists["x_operator"] = <?php echo $ref_multi_add->operator->Lookup->toClientList() ?>;
fref_multiadd.lists["x_operator"].options = <?php echo JsonEncode($ref_multi_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_multi_add->showPageHeader(); ?>
<?php
$ref_multi_add->showMessage();
?>
<form name="fref_multiadd" id="fref_multiadd" class="<?php echo $ref_multi_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_multi_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_multi_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_multi">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$ref_multi_add->IsModal ?>">
<?php if ($ref_multi_add->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($ref_multi->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_ref_multi_company_id" for="x_company_id" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->company_id->caption() ?><?php echo ($ref_multi->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->company_id->cellAttributes() ?>>
<span id="el_ref_multi_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_company_id" data-page="0" data-value-separator="<?php echo $ref_multi->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $ref_multi->company_id->editAttributes() ?>>
		<?php echo $ref_multi->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $ref_multi->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $ref_multi->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_ref_multi_grp" for="x_grp" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->grp->caption() ?><?php echo ($ref_multi->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->grp->cellAttributes() ?>>
<span id="el_ref_multi_grp">
<?php $ref_multi->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_multi->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_grp" data-page="0" data-value-separator="<?php echo $ref_multi->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref_multi->grp->editAttributes() ?>>
		<?php echo $ref_multi->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $ref_multi->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $ref_multi->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_ref_multi_s_grp" for="x_s_grp" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->s_grp->caption() ?><?php echo ($ref_multi->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->s_grp->cellAttributes() ?>>
<span id="el_ref_multi_s_grp">
<?php $ref_multi->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_multi->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_s_grp" data-page="0" data-value-separator="<?php echo $ref_multi->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref_multi->s_grp->editAttributes() ?>>
		<?php echo $ref_multi->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref_multi->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $ref_multi->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_ref_multi_product" for="x_product" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->product->caption() ?><?php echo ($ref_multi->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->product->cellAttributes() ?>>
<span id="el_ref_multi_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_product" data-page="0" data-value-separator="<?php echo $ref_multi->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref_multi->product->editAttributes() ?>>
		<?php echo $ref_multi->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $ref_multi->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $ref_multi->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->product_n->Visible) { // product_n ?>
	<div id="r_product_n" class="form-group row">
		<label id="elh_ref_multi_product_n" for="x_product_n" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->product_n->caption() ?><?php echo ($ref_multi->product_n->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->product_n->cellAttributes() ?>>
<span id="el_ref_multi_product_n">
<input type="text" data-table="ref_multi" data-field="x_product_n" data-page="0" name="x_product_n" id="x_product_n" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->product_n->getPlaceHolder()) ?>" value="<?php echo $ref_multi->product_n->EditValue ?>"<?php echo $ref_multi->product_n->editAttributes() ?>>
</span>
<?php echo $ref_multi->product_n->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_ref_multi_product_type" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->product_type->caption() ?><?php echo ($ref_multi->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->product_type->cellAttributes() ?>>
<span id="el_ref_multi_product_type">
<?php
$wrkonchange = "" . trim(@$ref_multi->product_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref_multi->product_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_product_type" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x_product_type" id="sv_x_product_type" value="<?php echo RemoveHtml($ref_multi->product_type->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->product_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref_multi->product_type->getPlaceHolder()) ?>"<?php echo $ref_multi->product_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref_multi" data-field="x_product_type" data-page="0" data-value-separator="<?php echo $ref_multi->product_type->displayValueSeparatorAttribute() ?>" name="x_product_type" id="x_product_type" value="<?php echo HtmlEncode($ref_multi->product_type->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fref_multiadd.createAutoSuggest({"id":"x_product_type","forceSelect":false});
</script>
<?php echo $ref_multi->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
<?php echo $ref_multi->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->last_price->Visible) { // last_price ?>
	<div id="r_last_price" class="form-group row">
		<label id="elh_ref_multi_last_price" for="x_last_price" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->last_price->caption() ?><?php echo ($ref_multi->last_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->last_price->cellAttributes() ?>>
<span id="el_ref_multi_last_price">
<input type="text" data-table="ref_multi" data-field="x_last_price" data-page="0" name="x_last_price" id="x_last_price" size="30" placeholder="<?php echo HtmlEncode($ref_multi->last_price->getPlaceHolder()) ?>" value="<?php echo $ref_multi->last_price->EditValue ?>"<?php echo $ref_multi->last_price->editAttributes() ?>>
</span>
<?php echo $ref_multi->last_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="ref_multi_add"><!-- multi-page accordion -->
<div class="card ew-accordion-card<?php echo $ref_multi_add->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_multi_add->MultiPages->isActive("1")) ?>" href="#tab_ref_multi1"><?php echo $ref_multi->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_multi_add->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $ref_multi_add->MultiPages->Parent ?>" id="tab_ref_multi1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($ref_multi->v_01->Visible) { // v_01 ?>
	<div id="r_v_01" class="form-group row">
		<label id="elh_ref_multi_v_01" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_01->caption() ?><?php echo ($ref_multi->v_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_01->cellAttributes() ?>>
<span id="el_ref_multi_v_01">
<div id="tp_x_v_01" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_01" data-page="1" data-value-separator="<?php echo $ref_multi->v_01->displayValueSeparatorAttribute() ?>" name="x_v_01[]" id="x_v_01[]" value="{value}"<?php echo $ref_multi->v_01->editAttributes() ?>></div>
<div id="dsl_x_v_01" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_01->checkBoxListHtml(FALSE, "x_v_01[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_01->Lookup->getParamTag("p_x_v_01") ?>
</span>
<?php echo $ref_multi->v_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_02->Visible) { // v_02 ?>
	<div id="r_v_02" class="form-group row">
		<label id="elh_ref_multi_v_02" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_02->caption() ?><?php echo ($ref_multi->v_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_02->cellAttributes() ?>>
<span id="el_ref_multi_v_02">
<div id="tp_x_v_02" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_02" data-page="1" data-value-separator="<?php echo $ref_multi->v_02->displayValueSeparatorAttribute() ?>" name="x_v_02[]" id="x_v_02[]" value="{value}"<?php echo $ref_multi->v_02->editAttributes() ?>></div>
<div id="dsl_x_v_02" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_02->checkBoxListHtml(FALSE, "x_v_02[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_02->Lookup->getParamTag("p_x_v_02") ?>
</span>
<?php echo $ref_multi->v_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_03->Visible) { // v_03 ?>
	<div id="r_v_03" class="form-group row">
		<label id="elh_ref_multi_v_03" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_03->caption() ?><?php echo ($ref_multi->v_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_03->cellAttributes() ?>>
<span id="el_ref_multi_v_03">
<div id="tp_x_v_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_03" data-page="1" data-value-separator="<?php echo $ref_multi->v_03->displayValueSeparatorAttribute() ?>" name="x_v_03[]" id="x_v_03[]" value="{value}"<?php echo $ref_multi->v_03->editAttributes() ?>></div>
<div id="dsl_x_v_03" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_03->checkBoxListHtml(FALSE, "x_v_03[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_03->Lookup->getParamTag("p_x_v_03") ?>
</span>
<?php echo $ref_multi->v_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_04->Visible) { // v_04 ?>
	<div id="r_v_04" class="form-group row">
		<label id="elh_ref_multi_v_04" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_04->caption() ?><?php echo ($ref_multi->v_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_04->cellAttributes() ?>>
<span id="el_ref_multi_v_04">
<div id="tp_x_v_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_04" data-page="1" data-value-separator="<?php echo $ref_multi->v_04->displayValueSeparatorAttribute() ?>" name="x_v_04[]" id="x_v_04[]" value="{value}"<?php echo $ref_multi->v_04->editAttributes() ?>></div>
<div id="dsl_x_v_04" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_04->checkBoxListHtml(FALSE, "x_v_04[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_04->Lookup->getParamTag("p_x_v_04") ?>
</span>
<?php echo $ref_multi->v_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_05->Visible) { // v_05 ?>
	<div id="r_v_05" class="form-group row">
		<label id="elh_ref_multi_v_05" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_05->caption() ?><?php echo ($ref_multi->v_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_05->cellAttributes() ?>>
<span id="el_ref_multi_v_05">
<div id="tp_x_v_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_05" data-page="1" data-value-separator="<?php echo $ref_multi->v_05->displayValueSeparatorAttribute() ?>" name="x_v_05[]" id="x_v_05[]" value="{value}"<?php echo $ref_multi->v_05->editAttributes() ?>></div>
<div id="dsl_x_v_05" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_05->checkBoxListHtml(FALSE, "x_v_05[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_05->Lookup->getParamTag("p_x_v_05") ?>
</span>
<?php echo $ref_multi->v_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_06->Visible) { // v_06 ?>
	<div id="r_v_06" class="form-group row">
		<label id="elh_ref_multi_v_06" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_06->caption() ?><?php echo ($ref_multi->v_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_06->cellAttributes() ?>>
<span id="el_ref_multi_v_06">
<div id="tp_x_v_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_06" data-page="1" data-value-separator="<?php echo $ref_multi->v_06->displayValueSeparatorAttribute() ?>" name="x_v_06[]" id="x_v_06[]" value="{value}"<?php echo $ref_multi->v_06->editAttributes() ?>></div>
<div id="dsl_x_v_06" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_06->checkBoxListHtml(FALSE, "x_v_06[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_06->Lookup->getParamTag("p_x_v_06") ?>
</span>
<?php echo $ref_multi->v_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_07->Visible) { // v_07 ?>
	<div id="r_v_07" class="form-group row">
		<label id="elh_ref_multi_v_07" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_07->caption() ?><?php echo ($ref_multi->v_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_07->cellAttributes() ?>>
<span id="el_ref_multi_v_07">
<div id="tp_x_v_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_07" data-page="1" data-value-separator="<?php echo $ref_multi->v_07->displayValueSeparatorAttribute() ?>" name="x_v_07[]" id="x_v_07[]" value="{value}"<?php echo $ref_multi->v_07->editAttributes() ?>></div>
<div id="dsl_x_v_07" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_07->checkBoxListHtml(FALSE, "x_v_07[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_07->Lookup->getParamTag("p_x_v_07") ?>
</span>
<?php echo $ref_multi->v_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_08->Visible) { // v_08 ?>
	<div id="r_v_08" class="form-group row">
		<label id="elh_ref_multi_v_08" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_08->caption() ?><?php echo ($ref_multi->v_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_08->cellAttributes() ?>>
<span id="el_ref_multi_v_08">
<div id="tp_x_v_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_08" data-page="1" data-value-separator="<?php echo $ref_multi->v_08->displayValueSeparatorAttribute() ?>" name="x_v_08[]" id="x_v_08[]" value="{value}"<?php echo $ref_multi->v_08->editAttributes() ?>></div>
<div id="dsl_x_v_08" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_08->checkBoxListHtml(FALSE, "x_v_08[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_08->Lookup->getParamTag("p_x_v_08") ?>
</span>
<?php echo $ref_multi->v_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_09->Visible) { // v_09 ?>
	<div id="r_v_09" class="form-group row">
		<label id="elh_ref_multi_v_09" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_09->caption() ?><?php echo ($ref_multi->v_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_09->cellAttributes() ?>>
<span id="el_ref_multi_v_09">
<div id="tp_x_v_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_09" data-page="1" data-value-separator="<?php echo $ref_multi->v_09->displayValueSeparatorAttribute() ?>" name="x_v_09[]" id="x_v_09[]" value="{value}"<?php echo $ref_multi->v_09->editAttributes() ?>></div>
<div id="dsl_x_v_09" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_09->checkBoxListHtml(FALSE, "x_v_09[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_09->Lookup->getParamTag("p_x_v_09") ?>
</span>
<?php echo $ref_multi->v_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->v_10->Visible) { // v_10 ?>
	<div id="r_v_10" class="form-group row">
		<label id="elh_ref_multi_v_10" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->v_10->caption() ?><?php echo ($ref_multi->v_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->v_10->cellAttributes() ?>>
<span id="el_ref_multi_v_10">
<div id="tp_x_v_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_v_10" data-page="1" data-value-separator="<?php echo $ref_multi->v_10->displayValueSeparatorAttribute() ?>" name="x_v_10[]" id="x_v_10[]" value="{value}"<?php echo $ref_multi->v_10->editAttributes() ?>></div>
<div id="dsl_x_v_10" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->v_10->checkBoxListHtml(FALSE, "x_v_10[]", 1) ?>
</div></div>
<?php echo $ref_multi->v_10->Lookup->getParamTag("p_x_v_10") ?>
</span>
<?php echo $ref_multi->v_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $ref_multi_add->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_multi_add->MultiPages->isActive("2")) ?>" href="#tab_ref_multi2"><?php echo $ref_multi->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_multi_add->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $ref_multi_add->MultiPages->Parent ?>" id="tab_ref_multi2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($ref_multi->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label id="elh_ref_multi_cbm" for="x_cbm" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->cbm->caption() ?><?php echo ($ref_multi->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->cbm->cellAttributes() ?>>
<span id="el_ref_multi_cbm">
<input type="text" data-table="ref_multi" data-field="x_cbm" data-page="2" name="x_cbm" id="x_cbm" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->cbm->getPlaceHolder()) ?>" value="<?php echo $ref_multi->cbm->EditValue ?>"<?php echo $ref_multi->cbm->editAttributes() ?>>
</span>
<?php echo $ref_multi->cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_ref_multi_sqm" for="x_sqm" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->sqm->caption() ?><?php echo ($ref_multi->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->sqm->cellAttributes() ?>>
<span id="el_ref_multi_sqm">
<input type="text" data-table="ref_multi" data-field="x_sqm" data-page="2" name="x_sqm" id="x_sqm" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->sqm->getPlaceHolder()) ?>" value="<?php echo $ref_multi->sqm->EditValue ?>"<?php echo $ref_multi->sqm->editAttributes() ?>>
</span>
<?php echo $ref_multi->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_ref_multi_shape" for="x_shape" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->shape->caption() ?><?php echo ($ref_multi->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->shape->cellAttributes() ?>>
<span id="el_ref_multi_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_shape" data-page="2" data-value-separator="<?php echo $ref_multi->shape->displayValueSeparatorAttribute() ?>" id="x_shape[]" name="x_shape[]" multiple="multiple"<?php echo $ref_multi->shape->editAttributes() ?>>
		<?php echo $ref_multi->shape->selectOptionListHtml("x_shape[]") ?>
	</select>
</div>
<?php echo $ref_multi->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
<?php echo $ref_multi->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_01->Visible) { // b_01 ?>
	<div id="r_b_01" class="form-group row">
		<label id="elh_ref_multi_b_01" for="x_b_01" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_01->caption() ?><?php echo ($ref_multi->b_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_01->cellAttributes() ?>>
<span id="el_ref_multi_b_01">
<input type="text" data-table="ref_multi" data-field="x_b_01" data-page="2" name="x_b_01" id="x_b_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->b_01->getPlaceHolder()) ?>" value="<?php echo $ref_multi->b_01->EditValue ?>"<?php echo $ref_multi->b_01->editAttributes() ?>>
</span>
<?php echo $ref_multi->b_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_02->Visible) { // b_02 ?>
	<div id="r_b_02" class="form-group row">
		<label id="elh_ref_multi_b_02" for="x_b_02" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_02->caption() ?><?php echo ($ref_multi->b_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_02->cellAttributes() ?>>
<span id="el_ref_multi_b_02">
<input type="text" data-table="ref_multi" data-field="x_b_02" data-page="2" name="x_b_02" id="x_b_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->b_02->getPlaceHolder()) ?>" value="<?php echo $ref_multi->b_02->EditValue ?>"<?php echo $ref_multi->b_02->editAttributes() ?>>
</span>
<?php echo $ref_multi->b_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_03->Visible) { // b_03 ?>
	<div id="r_b_03" class="form-group row">
		<label id="elh_ref_multi_b_03" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_03->caption() ?><?php echo ($ref_multi->b_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_03->cellAttributes() ?>>
<span id="el_ref_multi_b_03">
<div id="tp_x_b_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_b_03" data-page="2" data-value-separator="<?php echo $ref_multi->b_03->displayValueSeparatorAttribute() ?>" name="x_b_03[]" id="x_b_03[]" value="{value}"<?php echo $ref_multi->b_03->editAttributes() ?>></div>
<div id="dsl_x_b_03" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->b_03->checkBoxListHtml(FALSE, "x_b_03[]", 2) ?>
</div></div>
<?php echo $ref_multi->b_03->Lookup->getParamTag("p_x_b_03") ?>
</span>
<?php echo $ref_multi->b_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_04->Visible) { // b_04 ?>
	<div id="r_b_04" class="form-group row">
		<label id="elh_ref_multi_b_04" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_04->caption() ?><?php echo ($ref_multi->b_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_04->cellAttributes() ?>>
<span id="el_ref_multi_b_04">
<div id="tp_x_b_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_b_04" data-page="2" data-value-separator="<?php echo $ref_multi->b_04->displayValueSeparatorAttribute() ?>" name="x_b_04[]" id="x_b_04[]" value="{value}"<?php echo $ref_multi->b_04->editAttributes() ?>></div>
<div id="dsl_x_b_04" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref_multi->b_04->checkBoxListHtml(FALSE, "x_b_04[]", 2) ?>
</div></div>
<?php echo $ref_multi->b_04->Lookup->getParamTag("p_x_b_04") ?>
</span>
<?php echo $ref_multi->b_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_05->Visible) { // b_05 ?>
	<div id="r_b_05" class="form-group row">
		<label id="elh_ref_multi_b_05" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_05->caption() ?><?php echo ($ref_multi->b_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_05->cellAttributes() ?>>
<span id="el_ref_multi_b_05">
<div id="tp_x_b_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_b_05" data-page="2" data-value-separator="<?php echo $ref_multi->b_05->displayValueSeparatorAttribute() ?>" name="x_b_05[]" id="x_b_05[]" value="{value}"<?php echo $ref_multi->b_05->editAttributes() ?>></div>
<div id="dsl_x_b_05" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->b_05->checkBoxListHtml(FALSE, "x_b_05[]", 2) ?>
</div></div>
<?php echo $ref_multi->b_05->Lookup->getParamTag("p_x_b_05") ?>
</span>
<?php echo $ref_multi->b_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_06->Visible) { // b_06 ?>
	<div id="r_b_06" class="form-group row">
		<label id="elh_ref_multi_b_06" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_06->caption() ?><?php echo ($ref_multi->b_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_06->cellAttributes() ?>>
<span id="el_ref_multi_b_06">
<div id="tp_x_b_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_b_06" data-page="2" data-value-separator="<?php echo $ref_multi->b_06->displayValueSeparatorAttribute() ?>" name="x_b_06[]" id="x_b_06[]" value="{value}"<?php echo $ref_multi->b_06->editAttributes() ?>></div>
<div id="dsl_x_b_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->b_06->checkBoxListHtml(FALSE, "x_b_06[]", 2) ?>
</div></div>
<?php echo $ref_multi->b_06->Lookup->getParamTag("p_x_b_06") ?>
</span>
<?php echo $ref_multi->b_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_07->Visible) { // b_07 ?>
	<div id="r_b_07" class="form-group row">
		<label id="elh_ref_multi_b_07" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_07->caption() ?><?php echo ($ref_multi->b_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_07->cellAttributes() ?>>
<span id="el_ref_multi_b_07">
<div id="tp_x_b_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_b_07" data-page="2" data-value-separator="<?php echo $ref_multi->b_07->displayValueSeparatorAttribute() ?>" name="x_b_07[]" id="x_b_07[]" value="{value}"<?php echo $ref_multi->b_07->editAttributes() ?>></div>
<div id="dsl_x_b_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->b_07->checkBoxListHtml(FALSE, "x_b_07[]", 2) ?>
</div></div>
<?php echo $ref_multi->b_07->Lookup->getParamTag("p_x_b_07") ?>
</span>
<?php echo $ref_multi->b_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_08->Visible) { // b_08 ?>
	<div id="r_b_08" class="form-group row">
		<label id="elh_ref_multi_b_08" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_08->caption() ?><?php echo ($ref_multi->b_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_08->cellAttributes() ?>>
<span id="el_ref_multi_b_08">
<div id="tp_x_b_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_b_08" data-page="2" data-value-separator="<?php echo $ref_multi->b_08->displayValueSeparatorAttribute() ?>" name="x_b_08[]" id="x_b_08[]" value="{value}"<?php echo $ref_multi->b_08->editAttributes() ?>></div>
<div id="dsl_x_b_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->b_08->checkBoxListHtml(FALSE, "x_b_08[]", 2) ?>
</div></div>
<?php echo $ref_multi->b_08->Lookup->getParamTag("p_x_b_08") ?>
</span>
<?php echo $ref_multi->b_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_09->Visible) { // b_09 ?>
	<div id="r_b_09" class="form-group row">
		<label id="elh_ref_multi_b_09" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_09->caption() ?><?php echo ($ref_multi->b_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_09->cellAttributes() ?>>
<span id="el_ref_multi_b_09">
<div id="tp_x_b_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_b_09" data-page="2" data-value-separator="<?php echo $ref_multi->b_09->displayValueSeparatorAttribute() ?>" name="x_b_09[]" id="x_b_09[]" value="{value}"<?php echo $ref_multi->b_09->editAttributes() ?>></div>
<div id="dsl_x_b_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->b_09->checkBoxListHtml(FALSE, "x_b_09[]", 2) ?>
</div></div>
<?php echo $ref_multi->b_09->Lookup->getParamTag("p_x_b_09") ?>
</span>
<?php echo $ref_multi->b_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_10->Visible) { // b_10 ?>
	<div id="r_b_10" class="form-group row">
		<label id="elh_ref_multi_b_10" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_10->caption() ?><?php echo ($ref_multi->b_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_10->cellAttributes() ?>>
<span id="el_ref_multi_b_10">
<div id="tp_x_b_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_b_10" data-page="2" data-value-separator="<?php echo $ref_multi->b_10->displayValueSeparatorAttribute() ?>" name="x_b_10[]" id="x_b_10[]" value="{value}"<?php echo $ref_multi->b_10->editAttributes() ?>></div>
<div id="dsl_x_b_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->b_10->checkBoxListHtml(FALSE, "x_b_10[]", 2) ?>
</div></div>
<?php echo $ref_multi->b_10->Lookup->getParamTag("p_x_b_10") ?>
</span>
<?php echo $ref_multi->b_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_11->Visible) { // b_11 ?>
	<div id="r_b_11" class="form-group row">
		<label id="elh_ref_multi_b_11" for="x_b_11" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_11->caption() ?><?php echo ($ref_multi->b_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_11->cellAttributes() ?>>
<span id="el_ref_multi_b_11">
<input type="text" data-table="ref_multi" data-field="x_b_11" data-page="2" name="x_b_11" id="x_b_11" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->b_11->getPlaceHolder()) ?>" value="<?php echo $ref_multi->b_11->EditValue ?>"<?php echo $ref_multi->b_11->editAttributes() ?>>
</span>
<?php echo $ref_multi->b_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_12->Visible) { // b_12 ?>
	<div id="r_b_12" class="form-group row">
		<label id="elh_ref_multi_b_12" for="x_b_12" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_12->caption() ?><?php echo ($ref_multi->b_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_12->cellAttributes() ?>>
<span id="el_ref_multi_b_12">
<input type="text" data-table="ref_multi" data-field="x_b_12" data-page="2" name="x_b_12" id="x_b_12" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->b_12->getPlaceHolder()) ?>" value="<?php echo $ref_multi->b_12->EditValue ?>"<?php echo $ref_multi->b_12->editAttributes() ?>>
</span>
<?php echo $ref_multi->b_12->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_13->Visible) { // b_13 ?>
	<div id="r_b_13" class="form-group row">
		<label id="elh_ref_multi_b_13" for="x_b_13" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_13->caption() ?><?php echo ($ref_multi->b_13->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_13->cellAttributes() ?>>
<span id="el_ref_multi_b_13">
<input type="text" data-table="ref_multi" data-field="x_b_13" data-page="2" name="x_b_13" id="x_b_13" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->b_13->getPlaceHolder()) ?>" value="<?php echo $ref_multi->b_13->EditValue ?>"<?php echo $ref_multi->b_13->editAttributes() ?>>
</span>
<?php echo $ref_multi->b_13->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_14->Visible) { // b_14 ?>
	<div id="r_b_14" class="form-group row">
		<label id="elh_ref_multi_b_14" for="x_b_14" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_14->caption() ?><?php echo ($ref_multi->b_14->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_14->cellAttributes() ?>>
<span id="el_ref_multi_b_14">
<input type="text" data-table="ref_multi" data-field="x_b_14" data-page="2" name="x_b_14" id="x_b_14" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->b_14->getPlaceHolder()) ?>" value="<?php echo $ref_multi->b_14->EditValue ?>"<?php echo $ref_multi->b_14->editAttributes() ?>>
</span>
<?php echo $ref_multi->b_14->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->b_15->Visible) { // b_15 ?>
	<div id="r_b_15" class="form-group row">
		<label id="elh_ref_multi_b_15" for="x_b_15" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->b_15->caption() ?><?php echo ($ref_multi->b_15->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->b_15->cellAttributes() ?>>
<span id="el_ref_multi_b_15">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_b_15" data-page="2" data-value-separator="<?php echo $ref_multi->b_15->displayValueSeparatorAttribute() ?>" id="x_b_15" name="x_b_15"<?php echo $ref_multi->b_15->editAttributes() ?>>
		<?php echo $ref_multi->b_15->selectOptionListHtml("x_b_15") ?>
	</select>
</div>
</span>
<?php echo $ref_multi->b_15->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $ref_multi_add->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_multi_add->MultiPages->isActive("3")) ?>" href="#tab_ref_multi3"><?php echo $ref_multi->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_multi_add->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $ref_multi_add->MultiPages->Parent ?>" id="tab_ref_multi3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($ref_multi->t_01->Visible) { // t_01 ?>
	<div id="r_t_01" class="form-group row">
		<label id="elh_ref_multi_t_01" for="x_t_01" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_01->caption() ?><?php echo ($ref_multi->t_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_01->cellAttributes() ?>>
<span id="el_ref_multi_t_01">
<input type="text" data-table="ref_multi" data-field="x_t_01" data-page="3" name="x_t_01" id="x_t_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->t_01->getPlaceHolder()) ?>" value="<?php echo $ref_multi->t_01->EditValue ?>"<?php echo $ref_multi->t_01->editAttributes() ?>>
</span>
<?php echo $ref_multi->t_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_02->Visible) { // t_02 ?>
	<div id="r_t_02" class="form-group row">
		<label id="elh_ref_multi_t_02" for="x_t_02" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_02->caption() ?><?php echo ($ref_multi->t_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_02->cellAttributes() ?>>
<span id="el_ref_multi_t_02">
<input type="text" data-table="ref_multi" data-field="x_t_02" data-page="3" name="x_t_02" id="x_t_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->t_02->getPlaceHolder()) ?>" value="<?php echo $ref_multi->t_02->EditValue ?>"<?php echo $ref_multi->t_02->editAttributes() ?>>
</span>
<?php echo $ref_multi->t_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_03->Visible) { // t_03 ?>
	<div id="r_t_03" class="form-group row">
		<label id="elh_ref_multi_t_03" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_03->caption() ?><?php echo ($ref_multi->t_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_03->cellAttributes() ?>>
<span id="el_ref_multi_t_03">
<div id="tp_x_t_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_t_03" data-page="3" data-value-separator="<?php echo $ref_multi->t_03->displayValueSeparatorAttribute() ?>" name="x_t_03[]" id="x_t_03[]" value="{value}"<?php echo $ref_multi->t_03->editAttributes() ?>></div>
<div id="dsl_x_t_03" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->t_03->checkBoxListHtml(FALSE, "x_t_03[]", 3) ?>
</div></div>
<?php echo $ref_multi->t_03->Lookup->getParamTag("p_x_t_03") ?>
</span>
<?php echo $ref_multi->t_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_04->Visible) { // t_04 ?>
	<div id="r_t_04" class="form-group row">
		<label id="elh_ref_multi_t_04" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_04->caption() ?><?php echo ($ref_multi->t_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_04->cellAttributes() ?>>
<span id="el_ref_multi_t_04">
<div id="tp_x_t_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_t_04" data-page="3" data-value-separator="<?php echo $ref_multi->t_04->displayValueSeparatorAttribute() ?>" name="x_t_04[]" id="x_t_04[]" value="{value}"<?php echo $ref_multi->t_04->editAttributes() ?>></div>
<div id="dsl_x_t_04" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->t_04->checkBoxListHtml(FALSE, "x_t_04[]", 3) ?>
</div></div>
<?php echo $ref_multi->t_04->Lookup->getParamTag("p_x_t_04") ?>
</span>
<?php echo $ref_multi->t_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_05->Visible) { // t_05 ?>
	<div id="r_t_05" class="form-group row">
		<label id="elh_ref_multi_t_05" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_05->caption() ?><?php echo ($ref_multi->t_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_05->cellAttributes() ?>>
<span id="el_ref_multi_t_05">
<div id="tp_x_t_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_t_05" data-page="3" data-value-separator="<?php echo $ref_multi->t_05->displayValueSeparatorAttribute() ?>" name="x_t_05[]" id="x_t_05[]" value="{value}"<?php echo $ref_multi->t_05->editAttributes() ?>></div>
<div id="dsl_x_t_05" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->t_05->checkBoxListHtml(FALSE, "x_t_05[]", 3) ?>
</div></div>
<?php echo $ref_multi->t_05->Lookup->getParamTag("p_x_t_05") ?>
</span>
<?php echo $ref_multi->t_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_06->Visible) { // t_06 ?>
	<div id="r_t_06" class="form-group row">
		<label id="elh_ref_multi_t_06" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_06->caption() ?><?php echo ($ref_multi->t_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_06->cellAttributes() ?>>
<span id="el_ref_multi_t_06">
<div id="tp_x_t_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_t_06" data-page="3" data-value-separator="<?php echo $ref_multi->t_06->displayValueSeparatorAttribute() ?>" name="x_t_06[]" id="x_t_06[]" value="{value}"<?php echo $ref_multi->t_06->editAttributes() ?>></div>
<div id="dsl_x_t_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->t_06->checkBoxListHtml(FALSE, "x_t_06[]", 3) ?>
</div></div>
<?php echo $ref_multi->t_06->Lookup->getParamTag("p_x_t_06") ?>
</span>
<?php echo $ref_multi->t_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_07->Visible) { // t_07 ?>
	<div id="r_t_07" class="form-group row">
		<label id="elh_ref_multi_t_07" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_07->caption() ?><?php echo ($ref_multi->t_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_07->cellAttributes() ?>>
<span id="el_ref_multi_t_07">
<div id="tp_x_t_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_t_07" data-page="3" data-value-separator="<?php echo $ref_multi->t_07->displayValueSeparatorAttribute() ?>" name="x_t_07[]" id="x_t_07[]" value="{value}"<?php echo $ref_multi->t_07->editAttributes() ?>></div>
<div id="dsl_x_t_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->t_07->checkBoxListHtml(FALSE, "x_t_07[]", 3) ?>
</div></div>
<?php echo $ref_multi->t_07->Lookup->getParamTag("p_x_t_07") ?>
</span>
<?php echo $ref_multi->t_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_08->Visible) { // t_08 ?>
	<div id="r_t_08" class="form-group row">
		<label id="elh_ref_multi_t_08" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_08->caption() ?><?php echo ($ref_multi->t_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_08->cellAttributes() ?>>
<span id="el_ref_multi_t_08">
<div id="tp_x_t_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_t_08" data-page="3" data-value-separator="<?php echo $ref_multi->t_08->displayValueSeparatorAttribute() ?>" name="x_t_08[]" id="x_t_08[]" value="{value}"<?php echo $ref_multi->t_08->editAttributes() ?>></div>
<div id="dsl_x_t_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->t_08->checkBoxListHtml(FALSE, "x_t_08[]", 3) ?>
</div></div>
<?php echo $ref_multi->t_08->Lookup->getParamTag("p_x_t_08") ?>
</span>
<?php echo $ref_multi->t_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_09->Visible) { // t_09 ?>
	<div id="r_t_09" class="form-group row">
		<label id="elh_ref_multi_t_09" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_09->caption() ?><?php echo ($ref_multi->t_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_09->cellAttributes() ?>>
<span id="el_ref_multi_t_09">
<div id="tp_x_t_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_t_09" data-page="3" data-value-separator="<?php echo $ref_multi->t_09->displayValueSeparatorAttribute() ?>" name="x_t_09[]" id="x_t_09[]" value="{value}"<?php echo $ref_multi->t_09->editAttributes() ?>></div>
<div id="dsl_x_t_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->t_09->checkBoxListHtml(FALSE, "x_t_09[]", 3) ?>
</div></div>
<?php echo $ref_multi->t_09->Lookup->getParamTag("p_x_t_09") ?>
</span>
<?php echo $ref_multi->t_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_10->Visible) { // t_10 ?>
	<div id="r_t_10" class="form-group row">
		<label id="elh_ref_multi_t_10" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_10->caption() ?><?php echo ($ref_multi->t_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_10->cellAttributes() ?>>
<span id="el_ref_multi_t_10">
<div id="tp_x_t_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref_multi" data-field="x_t_10" data-page="3" data-value-separator="<?php echo $ref_multi->t_10->displayValueSeparatorAttribute() ?>" name="x_t_10[]" id="x_t_10[]" value="{value}"<?php echo $ref_multi->t_10->editAttributes() ?>></div>
<div id="dsl_x_t_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref_multi->t_10->checkBoxListHtml(FALSE, "x_t_10[]", 3) ?>
</div></div>
<?php echo $ref_multi->t_10->Lookup->getParamTag("p_x_t_10") ?>
</span>
<?php echo $ref_multi->t_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_11->Visible) { // t_11 ?>
	<div id="r_t_11" class="form-group row">
		<label id="elh_ref_multi_t_11" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_11->caption() ?><?php echo ($ref_multi->t_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_11->cellAttributes() ?>>
<span id="el_ref_multi_t_11">
<?php
$wrkonchange = "" . trim(@$ref_multi->t_11->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref_multi->t_11->EditAttrs["onchange"] = "";
?>
<span id="as_x_t_11" class="text-nowrap" style="z-index: 8450">
	<input type="text" class="form-control" name="sv_x_t_11" id="sv_x_t_11" value="<?php echo RemoveHtml($ref_multi->t_11->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->t_11->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref_multi->t_11->getPlaceHolder()) ?>"<?php echo $ref_multi->t_11->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref_multi" data-field="x_t_11" data-page="3" data-value-separator="<?php echo $ref_multi->t_11->displayValueSeparatorAttribute() ?>" name="x_t_11" id="x_t_11" value="<?php echo HtmlEncode($ref_multi->t_11->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fref_multiadd.createAutoSuggest({"id":"x_t_11","forceSelect":false});
</script>
<?php echo $ref_multi->t_11->Lookup->getParamTag("p_x_t_11") ?>
</span>
<?php echo $ref_multi->t_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_12->Visible) { // t_12 ?>
	<div id="r_t_12" class="form-group row">
		<label id="elh_ref_multi_t_12" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_12->caption() ?><?php echo ($ref_multi->t_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_12->cellAttributes() ?>>
<span id="el_ref_multi_t_12">
<?php
$wrkonchange = "" . trim(@$ref_multi->t_12->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref_multi->t_12->EditAttrs["onchange"] = "";
?>
<span id="as_x_t_12" class="text-nowrap" style="z-index: 8440">
	<input type="text" class="form-control" name="sv_x_t_12" id="sv_x_t_12" value="<?php echo RemoveHtml($ref_multi->t_12->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->t_12->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref_multi->t_12->getPlaceHolder()) ?>"<?php echo $ref_multi->t_12->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref_multi" data-field="x_t_12" data-page="3" data-value-separator="<?php echo $ref_multi->t_12->displayValueSeparatorAttribute() ?>" name="x_t_12" id="x_t_12" value="<?php echo HtmlEncode($ref_multi->t_12->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fref_multiadd.createAutoSuggest({"id":"x_t_12","forceSelect":false});
</script>
<?php echo $ref_multi->t_12->Lookup->getParamTag("p_x_t_12") ?>
</span>
<?php echo $ref_multi->t_12->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_13->Visible) { // t_13 ?>
	<div id="r_t_13" class="form-group row">
		<label id="elh_ref_multi_t_13" for="x_t_13" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_13->caption() ?><?php echo ($ref_multi->t_13->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_13->cellAttributes() ?>>
<span id="el_ref_multi_t_13">
<input type="text" data-table="ref_multi" data-field="x_t_13" data-page="3" name="x_t_13" id="x_t_13" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->t_13->getPlaceHolder()) ?>" value="<?php echo $ref_multi->t_13->EditValue ?>"<?php echo $ref_multi->t_13->editAttributes() ?>>
</span>
<?php echo $ref_multi->t_13->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_14->Visible) { // t_14 ?>
	<div id="r_t_14" class="form-group row">
		<label id="elh_ref_multi_t_14" for="x_t_14" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_14->caption() ?><?php echo ($ref_multi->t_14->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_14->cellAttributes() ?>>
<span id="el_ref_multi_t_14">
<input type="text" data-table="ref_multi" data-field="x_t_14" data-page="3" name="x_t_14" id="x_t_14" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->t_14->getPlaceHolder()) ?>" value="<?php echo $ref_multi->t_14->EditValue ?>"<?php echo $ref_multi->t_14->editAttributes() ?>>
</span>
<?php echo $ref_multi->t_14->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->t_15->Visible) { // t_15 ?>
	<div id="r_t_15" class="form-group row">
		<label id="elh_ref_multi_t_15" for="x_t_15" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->t_15->caption() ?><?php echo ($ref_multi->t_15->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->t_15->cellAttributes() ?>>
<span id="el_ref_multi_t_15">
<input type="text" data-table="ref_multi" data-field="x_t_15" data-page="3" name="x_t_15" id="x_t_15" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->t_15->getPlaceHolder()) ?>" value="<?php echo $ref_multi->t_15->EditValue ?>"<?php echo $ref_multi->t_15->editAttributes() ?>>
</span>
<?php echo $ref_multi->t_15->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $ref_multi_add->MultiPages->pageStyle("4") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_multi_add->MultiPages->isActive("4")) ?>" href="#tab_ref_multi4"><?php echo $ref_multi->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_multi_add->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $ref_multi_add->MultiPages->Parent ?>" id="tab_ref_multi4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($ref_multi->d_head_01->Visible) { // d_head_01 ?>
	<div id="r_d_head_01" class="form-group row">
		<label id="elh_ref_multi_d_head_01" for="x_d_head_01" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->d_head_01->caption() ?><?php echo ($ref_multi->d_head_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->d_head_01->cellAttributes() ?>>
<span id="el_ref_multi_d_head_01">
<input type="text" data-table="ref_multi" data-field="x_d_head_01" data-page="4" name="x_d_head_01" id="x_d_head_01" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_multi->d_head_01->getPlaceHolder()) ?>" value="<?php echo $ref_multi->d_head_01->EditValue ?>"<?php echo $ref_multi->d_head_01->editAttributes() ?>>
</span>
<?php echo $ref_multi->d_head_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->d_description_01->Visible) { // d_description_01 ?>
	<div id="r_d_description_01" class="form-group row">
		<label id="elh_ref_multi_d_description_01" for="x_d_description_01" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->d_description_01->caption() ?><?php echo ($ref_multi->d_description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->d_description_01->cellAttributes() ?>>
<span id="el_ref_multi_d_description_01">
<textarea data-table="ref_multi" data-field="x_d_description_01" data-page="4" name="x_d_description_01" id="x_d_description_01" cols="35" rows="4" placeholder="<?php echo HtmlEncode($ref_multi->d_description_01->getPlaceHolder()) ?>"<?php echo $ref_multi->d_description_01->editAttributes() ?>><?php echo $ref_multi->d_description_01->EditValue ?></textarea>
</span>
<?php echo $ref_multi->d_description_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->d_head_02->Visible) { // d_head_02 ?>
	<div id="r_d_head_02" class="form-group row">
		<label id="elh_ref_multi_d_head_02" for="x_d_head_02" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->d_head_02->caption() ?><?php echo ($ref_multi->d_head_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->d_head_02->cellAttributes() ?>>
<span id="el_ref_multi_d_head_02">
<input type="text" data-table="ref_multi" data-field="x_d_head_02" data-page="4" name="x_d_head_02" id="x_d_head_02" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref_multi->d_head_02->getPlaceHolder()) ?>" value="<?php echo $ref_multi->d_head_02->EditValue ?>"<?php echo $ref_multi->d_head_02->editAttributes() ?>>
</span>
<?php echo $ref_multi->d_head_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->d_description_02->Visible) { // d_description_02 ?>
	<div id="r_d_description_02" class="form-group row">
		<label id="elh_ref_multi_d_description_02" for="x_d_description_02" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->d_description_02->caption() ?><?php echo ($ref_multi->d_description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->d_description_02->cellAttributes() ?>>
<span id="el_ref_multi_d_description_02">
<textarea data-table="ref_multi" data-field="x_d_description_02" data-page="4" name="x_d_description_02" id="x_d_description_02" cols="35" rows="4" placeholder="<?php echo HtmlEncode($ref_multi->d_description_02->getPlaceHolder()) ?>"<?php echo $ref_multi->d_description_02->editAttributes() ?>><?php echo $ref_multi->d_description_02->EditValue ?></textarea>
</span>
<?php echo $ref_multi->d_description_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $ref_multi_add->MultiPages->pageStyle("5") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_multi_add->MultiPages->isActive("5")) ?>" href="#tab_ref_multi5"><?php echo $ref_multi->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_multi_add->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $ref_multi_add->MultiPages->Parent ?>" id="tab_ref_multi5"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($ref_multi->main_image->Visible) { // main_image ?>
	<div id="r_main_image" class="form-group row">
		<label id="elh_ref_multi_main_image" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->main_image->caption() ?><?php echo ($ref_multi->main_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->main_image->cellAttributes() ?>>
<span id="el_ref_multi_main_image">
<div id="fd_x_main_image">
<span title="<?php echo $ref_multi->main_image->title() ? $ref_multi->main_image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_multi->main_image->ReadOnly || $ref_multi->main_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_multi" data-field="x_main_image" data-page="5" name="x_main_image" id="x_main_image" multiple="multiple"<?php echo $ref_multi->main_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_main_image" id= "fn_x_main_image" value="<?php echo $ref_multi->main_image->Upload->FileName ?>">
<input type="hidden" name="fa_x_main_image" id= "fa_x_main_image" value="0">
<input type="hidden" name="fs_x_main_image" id= "fs_x_main_image" value="255">
<input type="hidden" name="fx_x_main_image" id= "fx_x_main_image" value="<?php echo $ref_multi->main_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_main_image" id= "fm_x_main_image" value="<?php echo $ref_multi->main_image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_main_image" id= "fc_x_main_image" value="<?php echo $ref_multi->main_image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_main_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_multi->main_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->top_view->Visible) { // top_view ?>
	<div id="r_top_view" class="form-group row">
		<label id="elh_ref_multi_top_view" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->top_view->caption() ?><?php echo ($ref_multi->top_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->top_view->cellAttributes() ?>>
<span id="el_ref_multi_top_view">
<div id="fd_x_top_view">
<span title="<?php echo $ref_multi->top_view->title() ? $ref_multi->top_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_multi->top_view->ReadOnly || $ref_multi->top_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_multi" data-field="x_top_view" data-page="5" name="x_top_view" id="x_top_view" multiple="multiple"<?php echo $ref_multi->top_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_top_view" id= "fn_x_top_view" value="<?php echo $ref_multi->top_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_top_view" id= "fa_x_top_view" value="0">
<input type="hidden" name="fs_x_top_view" id= "fs_x_top_view" value="255">
<input type="hidden" name="fx_x_top_view" id= "fx_x_top_view" value="<?php echo $ref_multi->top_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_top_view" id= "fm_x_top_view" value="<?php echo $ref_multi->top_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_top_view" id= "fc_x_top_view" value="<?php echo $ref_multi->top_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_top_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_multi->top_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->front_view->Visible) { // front_view ?>
	<div id="r_front_view" class="form-group row">
		<label id="elh_ref_multi_front_view" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->front_view->caption() ?><?php echo ($ref_multi->front_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->front_view->cellAttributes() ?>>
<span id="el_ref_multi_front_view">
<div id="fd_x_front_view">
<span title="<?php echo $ref_multi->front_view->title() ? $ref_multi->front_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_multi->front_view->ReadOnly || $ref_multi->front_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_multi" data-field="x_front_view" data-page="5" name="x_front_view" id="x_front_view" multiple="multiple"<?php echo $ref_multi->front_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_front_view" id= "fn_x_front_view" value="<?php echo $ref_multi->front_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_front_view" id= "fa_x_front_view" value="0">
<input type="hidden" name="fs_x_front_view" id= "fs_x_front_view" value="255">
<input type="hidden" name="fx_x_front_view" id= "fx_x_front_view" value="<?php echo $ref_multi->front_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_front_view" id= "fm_x_front_view" value="<?php echo $ref_multi->front_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_front_view" id= "fc_x_front_view" value="<?php echo $ref_multi->front_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_front_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_multi->front_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->corner_view->Visible) { // corner_view ?>
	<div id="r_corner_view" class="form-group row">
		<label id="elh_ref_multi_corner_view" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->corner_view->caption() ?><?php echo ($ref_multi->corner_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->corner_view->cellAttributes() ?>>
<span id="el_ref_multi_corner_view">
<div id="fd_x_corner_view">
<span title="<?php echo $ref_multi->corner_view->title() ? $ref_multi->corner_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_multi->corner_view->ReadOnly || $ref_multi->corner_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_multi" data-field="x_corner_view" data-page="5" name="x_corner_view" id="x_corner_view" multiple="multiple"<?php echo $ref_multi->corner_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_corner_view" id= "fn_x_corner_view" value="<?php echo $ref_multi->corner_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_corner_view" id= "fa_x_corner_view" value="0">
<input type="hidden" name="fs_x_corner_view" id= "fs_x_corner_view" value="255">
<input type="hidden" name="fx_x_corner_view" id= "fx_x_corner_view" value="<?php echo $ref_multi->corner_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_corner_view" id= "fm_x_corner_view" value="<?php echo $ref_multi->corner_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_corner_view" id= "fc_x_corner_view" value="<?php echo $ref_multi->corner_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_corner_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_multi->corner_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->back_view->Visible) { // back_view ?>
	<div id="r_back_view" class="form-group row">
		<label id="elh_ref_multi_back_view" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->back_view->caption() ?><?php echo ($ref_multi->back_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->back_view->cellAttributes() ?>>
<span id="el_ref_multi_back_view">
<div id="fd_x_back_view">
<span title="<?php echo $ref_multi->back_view->title() ? $ref_multi->back_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_multi->back_view->ReadOnly || $ref_multi->back_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_multi" data-field="x_back_view" data-page="5" name="x_back_view" id="x_back_view" multiple="multiple"<?php echo $ref_multi->back_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_back_view" id= "fn_x_back_view" value="<?php echo $ref_multi->back_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_back_view" id= "fa_x_back_view" value="0">
<input type="hidden" name="fs_x_back_view" id= "fs_x_back_view" value="255">
<input type="hidden" name="fx_x_back_view" id= "fx_x_back_view" value="<?php echo $ref_multi->back_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_back_view" id= "fm_x_back_view" value="<?php echo $ref_multi->back_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_back_view" id= "fc_x_back_view" value="<?php echo $ref_multi->back_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_back_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_multi->back_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->color_options->Visible) { // color_options ?>
	<div id="r_color_options" class="form-group row">
		<label id="elh_ref_multi_color_options" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->color_options->caption() ?><?php echo ($ref_multi->color_options->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->color_options->cellAttributes() ?>>
<span id="el_ref_multi_color_options">
<div id="fd_x_color_options">
<span title="<?php echo $ref_multi->color_options->title() ? $ref_multi->color_options->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_multi->color_options->ReadOnly || $ref_multi->color_options->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_multi" data-field="x_color_options" data-page="5" name="x_color_options" id="x_color_options" multiple="multiple"<?php echo $ref_multi->color_options->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_color_options" id= "fn_x_color_options" value="<?php echo $ref_multi->color_options->Upload->FileName ?>">
<input type="hidden" name="fa_x_color_options" id= "fa_x_color_options" value="0">
<input type="hidden" name="fs_x_color_options" id= "fs_x_color_options" value="255">
<input type="hidden" name="fx_x_color_options" id= "fx_x_color_options" value="<?php echo $ref_multi->color_options->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_color_options" id= "fm_x_color_options" value="<?php echo $ref_multi->color_options->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_color_options" id= "fc_x_color_options" value="<?php echo $ref_multi->color_options->UploadMaxFileCount ?>">
</div>
<table id="ft_x_color_options" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_multi->color_options->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->other_options->Visible) { // other_options ?>
	<div id="r_other_options" class="form-group row">
		<label id="elh_ref_multi_other_options" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->other_options->caption() ?><?php echo ($ref_multi->other_options->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->other_options->cellAttributes() ?>>
<span id="el_ref_multi_other_options">
<div id="fd_x_other_options">
<span title="<?php echo $ref_multi->other_options->title() ? $ref_multi->other_options->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_multi->other_options->ReadOnly || $ref_multi->other_options->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_multi" data-field="x_other_options" data-page="5" name="x_other_options" id="x_other_options" multiple="multiple"<?php echo $ref_multi->other_options->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_other_options" id= "fn_x_other_options" value="<?php echo $ref_multi->other_options->Upload->FileName ?>">
<input type="hidden" name="fa_x_other_options" id= "fa_x_other_options" value="0">
<input type="hidden" name="fs_x_other_options" id= "fs_x_other_options" value="255">
<input type="hidden" name="fx_x_other_options" id= "fx_x_other_options" value="<?php echo $ref_multi->other_options->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_other_options" id= "fm_x_other_options" value="<?php echo $ref_multi->other_options->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_other_options" id= "fc_x_other_options" value="<?php echo $ref_multi->other_options->UploadMaxFileCount ?>">
</div>
<table id="ft_x_other_options" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_multi->other_options->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_ref_multi_image" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->image->caption() ?><?php echo ($ref_multi->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->image->cellAttributes() ?>>
<span id="el_ref_multi_image">
<div id="fd_x_image">
<span title="<?php echo $ref_multi->image->title() ? $ref_multi->image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref_multi->image->ReadOnly || $ref_multi->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref_multi" data-field="x_image" data-page="5" name="x_image" id="x_image" multiple="multiple"<?php echo $ref_multi->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $ref_multi->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="255">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $ref_multi->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $ref_multi->image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_image" id= "fc_x_image" value="<?php echo $ref_multi->image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref_multi->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->video_url->Visible) { // video_url ?>
	<div id="r_video_url" class="form-group row">
		<label id="elh_ref_multi_video_url" for="x_video_url" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->video_url->caption() ?><?php echo ($ref_multi->video_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->video_url->cellAttributes() ?>>
<span id="el_ref_multi_video_url">
<input type="text" data-table="ref_multi" data-field="x_video_url" data-page="5" name="x_video_url" id="x_video_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($ref_multi->video_url->getPlaceHolder()) ?>" value="<?php echo $ref_multi->video_url->EditValue ?>"<?php echo $ref_multi->video_url->editAttributes() ?>>
</span>
<?php echo $ref_multi->video_url->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $ref_multi_add->MultiPages->pageStyle("6") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_multi_add->MultiPages->isActive("6")) ?>" href="#tab_ref_multi6"><?php echo $ref_multi->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_multi_add->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $ref_multi_add->MultiPages->Parent ?>" id="tab_ref_multi6"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($ref_multi->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_ref_multi_currency" for="x_currency" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->currency->caption() ?><?php echo ($ref_multi->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->currency->cellAttributes() ?>>
<span id="el_ref_multi_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_currency" data-page="6" data-value-separator="<?php echo $ref_multi->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $ref_multi->currency->editAttributes() ?>>
		<?php echo $ref_multi->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $ref_multi->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
<?php echo $ref_multi->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->hsn->Visible) { // hsn ?>
	<div id="r_hsn" class="form-group row">
		<label id="elh_ref_multi_hsn" for="x_hsn" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->hsn->caption() ?><?php echo ($ref_multi->hsn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->hsn->cellAttributes() ?>>
<span id="el_ref_multi_hsn">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_hsn" data-page="6" data-value-separator="<?php echo $ref_multi->hsn->displayValueSeparatorAttribute() ?>" id="x_hsn" name="x_hsn"<?php echo $ref_multi->hsn->editAttributes() ?>>
		<?php echo $ref_multi->hsn->selectOptionListHtml("x_hsn") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "tax_category") && !$ref_multi->hsn->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_hsn" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $ref_multi->hsn->caption() ?>" data-title="<?php echo $ref_multi->hsn->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_hsn',url:'tax_categoryaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $ref_multi->hsn->Lookup->getParamTag("p_x_hsn") ?>
</span>
<?php echo $ref_multi->hsn->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $ref_multi_add->MultiPages->pageStyle("7") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_multi_add->MultiPages->isActive("7")) ?>" href="#tab_ref_multi7"><?php echo $ref_multi->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_multi_add->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $ref_multi_add->MultiPages->Parent ?>" id="tab_ref_multi7"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($ref_multi->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_ref_multi_status" for="x_status" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->status->caption() ?><?php echo ($ref_multi->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->status->cellAttributes() ?>>
<span id="el_ref_multi_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_status" data-page="7" data-value-separator="<?php echo $ref_multi->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ref_multi->status->editAttributes() ?>>
		<?php echo $ref_multi->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $ref_multi->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref_multi->publish->Visible) { // publish ?>
	<div id="r_publish" class="form-group row">
		<label id="elh_ref_multi_publish" for="x_publish" class="<?php echo $ref_multi_add->LeftColumnClass ?>"><?php echo $ref_multi->publish->caption() ?><?php echo ($ref_multi->publish->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_multi_add->RightColumnClass ?>"><div<?php echo $ref_multi->publish->cellAttributes() ?>>
<span id="el_ref_multi_publish">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_publish" data-page="7" data-value-separator="<?php echo $ref_multi->publish->displayValueSeparatorAttribute() ?>" id="x_publish" name="x_publish"<?php echo $ref_multi->publish->editAttributes() ?>>
		<?php echo $ref_multi->publish->selectOptionListHtml("x_publish") ?>
	</select>
</div>
</span>
<?php echo $ref_multi->publish->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php
	if (in_array("_ref_view", explode(",", $ref_multi->getCurrentDetailTable())) && $_ref_view->DetailAdd) {
?>
<?php if ($ref_multi->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("_ref_view", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "_ref_viewgrid.php" ?>
<?php } ?>
<?php if (!$ref_multi_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ref_multi_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ref_multi_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ref_multi_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var SGrp = $("#x_s_grp").val();
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
			 		if (data.cbm == '--NA--') {
					$("#r_cbm").hide(); } else {
					$("#r_cbm").show();						
					$("#elh_ref_multi_cbm").html(data.cbm);}
					if (data.sqm == '--NA--') {
					$("#r_sqm").hide(); } else {
					$("#r_sqm").show()					
					$("#elh_ref_multi_sqm").html(data.sqm);}
					if (data.shape == '--NA--') {
					$("#r_shape").hide(); } else {
					$("#r_shape").show()					
					$("#elh_ref_multi_shape").html(data.shape);}
					if (data.v_01 == '--NA--') {
					$("#r_v_01").hide(); } else {
					$("#r_v_01").show();					
					$("#elh_ref_multi_v_01").html(data.v_01);}
					if (data.v_02 == '--NA--') {
					$("#r_v_02").hide(); } else {
					$("#r_v_02").show()					
					$("#elh_ref_multi_v_02").html(data.v_02);}
					if (data.v_03 == '--NA--') {
					$("#r_v_03").hide(); } else {
					$("#r_v_03").show()					
					$("#elh_ref_multi_v_03").html(data.v_03);}
					if (data.v_04 == '--NA--') {
					$("#r_v_04").hide(); } else {
					$("#r_v_04").show()		
					$("#elh_ref_multi_v_04").html(data.v_04);}
					if (data.v_05 == '--NA--') {
					$("#r_v_05").hide(); } else {
					$("#r_v_05").show();					
					$("#elh_ref_multi_v_05").html(data.v_05);}
					if (data.v_06 == '--NA--') {
					$("#r_v_06").hide(); } else {
					$("#r_v_06").show()		
					$("#elh_ref_multi_v_06").html(data.v_06);}
					if (data.v_07 == '--NA--') {
					$("#r_v_07").hide(); } else {						
					$("#r_v_07").show();
					$("#elh_ref_multi_v_07").html(data.v_07);}
					if (data.v_08 == '--NA--') {
					$("#r_v_08").hide(); } else {						
					$("#r_v_08").show();
					$("#elh_ref_multi_v_08").html(data.v_08);}
					if (data.v_09 == '--NA--') {
					$("#r_v_09").hide(); } else {						
					$("#r_v_09").show();
					$("#elh_ref_multi_v_09").html(data.v_09);}
					if (data.v_10 == '--NA--') {
					$("#r_v_10").hide(); } else {						
					$("#r_v_10").show();
					$("#elh_ref_multi_v_10").html(data.v_10);}
					if (data.b_01_head == '--NA--') {
					$("#r_b_01").hide(); } else {
					$("#r_b_01").show();
					$("#elh_ref_multi_b_01").html(data.b_01_head);}
					if (data.b_02_head == '--NA--') {
					$("#r_b_02").hide(); } else {
					$("#r_b_02").show();
					$("#elh_ref_multi_b_02").html(data.b_02_head);}
					if (data.b_03_head == '--NA--') {
					$("#r_b_03").hide(); } else {
					$("#r_b_03").show();
					$("#elh_ref_multi_b_03").html(data.b_03_head);}
					if (data.b_04_head == '--NA--') {
					$("#r_b_04").hide(); } else {
					$("#r_b_04").show();
					$("#elh_ref_multi_b_04").html(data.b_04_head);}
					if (data.b_05_head == '--NA--') {
					$("#r_b_05").hide(); } else {
					$("#r_b_05").show();
					$("#elh_ref_multi_b_05").html(data.b_05_head);}
					if (data.b_06_head == '--NA--') {
					$("#r_b_06").hide(); } else {
					$("#r_b_06").show();
					$("#elh_ref_multi_b_06").html(data.b_06_head);}
					if (data.b_07_head == '--NA--') {
					$("#r_b_07").hide(); } else {
					$("#r_b_07").show();
					$("#elh_ref_multi_b_07").html(data.b_07_head);}
					if (data.b_08_head == '--NA--') {
					$("#r_b_08").hide(); } else {
					$("#r_b_08").show();
					$("#elh_ref_multi_b_08").html(data.b_08_head);}
					if (data.b_09_head == '--NA--') {
					$("#r_b_09").hide(); } else {
					$("#r_b_09").show();
					$("#elh_ref_multi_b_09").html(data.b_09_head);}
					if (data.b_10_head == '--NA--') {
					$("#r_b_10").hide(); } else {
					$("#r_b_10").show();
					$("#elh_ref_multi_b_10").html(data.b_10_head);}
					if (data.b_11_head == '--NA--') {
					$("#r_b_11").hide(); } else {
					$("#r_b_11").show();
					$("#elh_ref_multi_b_11").html(data.b_11_head);}
					if (data.b_12_head == '--NA--') {
					$("#r_b_12").hide(); } else {
					$("#r_b_12").show();
					$("#elh_ref_multi_b_12").html(data.b_12_head);}
					if (data.b_13_head == '--NA--') {
					$("#r_b_13").hide(); } else {
					$("#r_b_13").show();
					$("#elh_ref_multi_b_13").html(data.b_13_head);}
					if (data.b_14_head == '--NA--') {
					$("#r_b_14").hide(); } else {
					$("#r_b_14").show();	
					$("#elh_ref_multi_b_14").html(data.b_14_head);}
					if (data.b_15_head == '--NA--') {
					$("#r_b_15").hide(); } else {
					$("#r_b_15").show();
					$("#elh_ref_multi_b_15").html(data.b_15_head);}
					if (data.t_01_head == '--NA--') {
					$("#r_t_01").hide(); } else {
					$("#r_t_01").show();
					$("#elh_ref_multi_t_01").html(data.t_01_head);}
					if (data.t_02_head == '--NA--') {
					$("#r_t_02").hide(); } else {
					$("#r_t_02").show();
					$("#elh_ref_multi_t_02").html(data.t_02_head);}
					if (data.t_03_head == '--NA--') {
					$("#r_t_03").hide(); } else {
					$("#r_t_03").show();
					$("#elh_ref_multi_t_03").html(data.t_03_head);}
					if (data.t_04_head == '--NA--') {
					$("#r_t_04").hide(); } else {
					$("#r_t_04").show();
					$("#elh_ref_multi_t_04").html(data.t_04_head);}
					if (data.t_05_head == '--NA--') {
					$("#r_t_05").hide(); } else {
					$("#r_t_05").show();
					$("#elh_ref_multi_t_05").html(data.t_05_head);}
					if (data.t_06_head == '--NA--') {
					$("#r_t_06").hide(); } else {
					$("#r_t_06").show();
					$("#elh_ref_multi_t_06").html(data.t_06_head);}
					if (data.t_07_head == '--NA--') {
					$("#r_t_07").hide(); } else {
					$("#r_t_07").show();
					$("#elh_ref_multi_t_07").html(data.t_07_head);}
					if (data.t_08_head == '--NA--') {
					$("#r_t_08").hide(); } else {
					$("#r_t_08").show();
					$("#elh_ref_multi_t_08").html(data.t_08_head);}
					if (data.t_09_head == '--NA--') {
					$("#r_t_09").hide(); } else {
					$("#r_t_09").show();
					$("#elh_ref_multi_t_09").html(data.t_09_head);}
					if (data.t_10_head == '--NA--') {
					$("#r_t_10").hide(); } else {
					$("#r_t_10").show();
					$("#elh_ref_multi_t_10").html(data.t_10_head);}
					if (data.t_11_head == '--NA--') {
					$("#r_t_11").hide(); } else {
					$("#r_t_11").show();
					$("#elh_ref_multi_t_11").html(data.t_11_head);}
					if (data.t_12_head == '--NA--') {
					$("#r_t_12").hide(); } else {
					$("#r_t_12").show();
					$("#elh_ref_multi_t_12").html(data.t_12_head);}
					if (data.t_13_head == '--NA--') {
					$("#r_t_13").hide(); } else {
					$("#r_t_13").show();
					$("#elh_ref_multi_t_13").html(data.t_13_head);}
					if (data.t_14_head == '--NA--') {
					$("#r_t_14").hide(); } else {
					$("#r_t_14").show();
					$("#elh_ref_multi_t_14").html(data.t_14_head);}
					if (data.t_15_head == '--NA--') {
					$("#r_t_15").hide(); } else {
					$("#r_t_15").show();
					$("#elh_ref_multi_t_15").html(data.t_15_head);}
					if (data.calculation_method == 1) {
					$lastprice = 'Current Price / SQM';
					} else if (data.calculation_method == 11) {
					$lastprice = 'Current Price / SKU';
					} else if (data.calculation_method == 21) {
					$lastprice = 'Current Price / KG';
					}
					$("#elh_ref_multi_last_price").html($lastprice);
		});
		} else {
					$("#r_cbm").hide();
					$("#r_sqm").hide(); 
					$("#r_shape").hide()
					$("#r_v_01").hide();
					$("#r_v_02").hide(); 
					$("#r_v_03").hide();
					$("#r_v_04").hide();
					$("#r_v_05").hide();
					$("#r_v_06").hide(); 
					$("#r_v_07").hide();
					$("#r_v_08").hide();
					$("#r_v_09").hide();
					$("#r_v_10").hide();
					$("#r_b_01").hide();
					$("#r_b_02").hide();
					$("#r_b_03").hide();
					$("#r_b_04").hide();
					$("#r_b_05").hide();
					$("#r_b_06").hide();
					$("#r_b_07").hide();
					$("#r_b_08").hide();
					$("#r_b_09").hide();
					$("#r_b_10").hide();
					$("#r_b_11").hide();
					$("#r_b_12").hide();
					$("#r_b_13").hide();
					$("#r_b_14").hide();
					$("#r_b_15").hide();
					$("#r_t_01").hide();
					$("#r_t_02").hide();
					$("#r_t_03").hide();
					$("#r_t_04").hide();
					$("#r_t_05").hide();
					$("#r_t_06").hide();
					$("#r_t_07").hide();
					$("#r_t_08").hide();
					$("#r_t_09").hide();
					$("#r_t_10").hide();
					$("#r_t_11").hide();
					$("#r_t_12").hide();
					$("#r_t_13").hide();
					$("#r_t_14").hide();
					$("#r_t_15").hide();
				}
</script>
<?php include_once "footer.php" ?>
<?php
$ref_multi_add->terminate();
?>