<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_multi_delete = new ref_multi_delete();

// Run the page
$ref_multi_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_multi_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fref_multidelete = currentForm = new ew.Form("fref_multidelete", "delete");

// Form_CustomValidate event
fref_multidelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_multidelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_multidelete.lists["x_company_id"] = <?php echo $ref_multi_delete->company_id->Lookup->toClientList() ?>;
fref_multidelete.lists["x_company_id"].options = <?php echo JsonEncode($ref_multi_delete->company_id->lookupOptions()) ?>;
fref_multidelete.lists["x_grp"] = <?php echo $ref_multi_delete->grp->Lookup->toClientList() ?>;
fref_multidelete.lists["x_grp"].options = <?php echo JsonEncode($ref_multi_delete->grp->lookupOptions()) ?>;
fref_multidelete.lists["x_s_grp"] = <?php echo $ref_multi_delete->s_grp->Lookup->toClientList() ?>;
fref_multidelete.lists["x_s_grp"].options = <?php echo JsonEncode($ref_multi_delete->s_grp->lookupOptions()) ?>;
fref_multidelete.lists["x_product_type"] = <?php echo $ref_multi_delete->product_type->Lookup->toClientList() ?>;
fref_multidelete.lists["x_product_type"].options = <?php echo JsonEncode($ref_multi_delete->product_type->lookupOptions()) ?>;
fref_multidelete.autoSuggests["x_product_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fref_multidelete.lists["x_status"] = <?php echo $ref_multi_delete->status->Lookup->toClientList() ?>;
fref_multidelete.lists["x_status"].options = <?php echo JsonEncode($ref_multi_delete->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_multi_delete->showPageHeader(); ?>
<?php
$ref_multi_delete->showMessage();
?>
<form name="fref_multidelete" id="fref_multidelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_multi_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_multi_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_multi">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($ref_multi_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($ref_multi->id->Visible) { // id ?>
		<th class="<?php echo $ref_multi->id->headerCellClass() ?>"><span id="elh_ref_multi_id" class="ref_multi_id"><?php echo $ref_multi->id->caption() ?></span></th>
<?php } ?>
<?php if ($ref_multi->company_id->Visible) { // company_id ?>
		<th class="<?php echo $ref_multi->company_id->headerCellClass() ?>"><span id="elh_ref_multi_company_id" class="ref_multi_company_id"><?php echo $ref_multi->company_id->caption() ?></span></th>
<?php } ?>
<?php if ($ref_multi->grp->Visible) { // grp ?>
		<th class="<?php echo $ref_multi->grp->headerCellClass() ?>"><span id="elh_ref_multi_grp" class="ref_multi_grp"><?php echo $ref_multi->grp->caption() ?></span></th>
<?php } ?>
<?php if ($ref_multi->s_grp->Visible) { // s_grp ?>
		<th class="<?php echo $ref_multi->s_grp->headerCellClass() ?>"><span id="elh_ref_multi_s_grp" class="ref_multi_s_grp"><?php echo $ref_multi->s_grp->caption() ?></span></th>
<?php } ?>
<?php if ($ref_multi->product_type->Visible) { // product_type ?>
		<th class="<?php echo $ref_multi->product_type->headerCellClass() ?>"><span id="elh_ref_multi_product_type" class="ref_multi_product_type"><?php echo $ref_multi->product_type->caption() ?></span></th>
<?php } ?>
<?php if ($ref_multi->status->Visible) { // status ?>
		<th class="<?php echo $ref_multi->status->headerCellClass() ?>"><span id="elh_ref_multi_status" class="ref_multi_status"><?php echo $ref_multi->status->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$ref_multi_delete->RecCnt = 0;
$i = 0;
while (!$ref_multi_delete->Recordset->EOF) {
	$ref_multi_delete->RecCnt++;
	$ref_multi_delete->RowCnt++;

	// Set row properties
	$ref_multi->resetAttributes();
	$ref_multi->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$ref_multi_delete->loadRowValues($ref_multi_delete->Recordset);

	// Render row
	$ref_multi_delete->renderRow();
?>
	<tr<?php echo $ref_multi->rowAttributes() ?>>
<?php if ($ref_multi->id->Visible) { // id ?>
		<td<?php echo $ref_multi->id->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_delete->RowCnt ?>_ref_multi_id" class="ref_multi_id">
<span<?php echo $ref_multi->id->viewAttributes() ?>>
<?php echo $ref_multi->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref_multi->company_id->Visible) { // company_id ?>
		<td<?php echo $ref_multi->company_id->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_delete->RowCnt ?>_ref_multi_company_id" class="ref_multi_company_id">
<span<?php echo $ref_multi->company_id->viewAttributes() ?>>
<?php echo $ref_multi->company_id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref_multi->grp->Visible) { // grp ?>
		<td<?php echo $ref_multi->grp->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_delete->RowCnt ?>_ref_multi_grp" class="ref_multi_grp">
<span<?php echo $ref_multi->grp->viewAttributes() ?>>
<?php echo $ref_multi->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref_multi->s_grp->Visible) { // s_grp ?>
		<td<?php echo $ref_multi->s_grp->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_delete->RowCnt ?>_ref_multi_s_grp" class="ref_multi_s_grp">
<span<?php echo $ref_multi->s_grp->viewAttributes() ?>>
<?php echo $ref_multi->s_grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref_multi->product_type->Visible) { // product_type ?>
		<td<?php echo $ref_multi->product_type->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_delete->RowCnt ?>_ref_multi_product_type" class="ref_multi_product_type">
<span<?php echo $ref_multi->product_type->viewAttributes() ?>>
<?php echo $ref_multi->product_type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref_multi->status->Visible) { // status ?>
		<td<?php echo $ref_multi->status->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_delete->RowCnt ?>_ref_multi_status" class="ref_multi_status">
<span<?php echo $ref_multi->status->viewAttributes() ?>>
<?php echo $ref_multi->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$ref_multi_delete->Recordset->moveNext();
}
$ref_multi_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ref_multi_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$ref_multi_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ref_multi_delete->terminate();
?>