<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_multi_list = new ref_multi_list();

// Run the page
$ref_multi_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_multi_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ref_multi->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fref_multilist = currentForm = new ew.Form("fref_multilist", "list");
fref_multilist.formKeyCountName = '<?php echo $ref_multi_list->FormKeyCountName ?>';

// Form_CustomValidate event
fref_multilist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_multilist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_multilist.lists["x_company_id"] = <?php echo $ref_multi_list->company_id->Lookup->toClientList() ?>;
fref_multilist.lists["x_company_id"].options = <?php echo JsonEncode($ref_multi_list->company_id->lookupOptions()) ?>;
fref_multilist.lists["x_grp"] = <?php echo $ref_multi_list->grp->Lookup->toClientList() ?>;
fref_multilist.lists["x_grp"].options = <?php echo JsonEncode($ref_multi_list->grp->lookupOptions()) ?>;
fref_multilist.lists["x_s_grp"] = <?php echo $ref_multi_list->s_grp->Lookup->toClientList() ?>;
fref_multilist.lists["x_s_grp"].options = <?php echo JsonEncode($ref_multi_list->s_grp->lookupOptions()) ?>;
fref_multilist.lists["x_product_type"] = <?php echo $ref_multi_list->product_type->Lookup->toClientList() ?>;
fref_multilist.lists["x_product_type"].options = <?php echo JsonEncode($ref_multi_list->product_type->lookupOptions()) ?>;
fref_multilist.autoSuggests["x_product_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fref_multilist.lists["x_status"] = <?php echo $ref_multi_list->status->Lookup->toClientList() ?>;
fref_multilist.lists["x_status"].options = <?php echo JsonEncode($ref_multi_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fref_multilistsrch = currentSearchForm = new ew.Form("fref_multilistsrch");

// Validate function for search
fref_multilistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref_multi->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fref_multilistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fref_multilistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fref_multilistsrch.lists["x_company_id"] = <?php echo $ref_multi_list->company_id->Lookup->toClientList() ?>;
fref_multilistsrch.lists["x_company_id"].options = <?php echo JsonEncode($ref_multi_list->company_id->lookupOptions()) ?>;
fref_multilistsrch.lists["x_grp"] = <?php echo $ref_multi_list->grp->Lookup->toClientList() ?>;
fref_multilistsrch.lists["x_grp"].options = <?php echo JsonEncode($ref_multi_list->grp->lookupOptions()) ?>;
fref_multilistsrch.lists["x_s_grp"] = <?php echo $ref_multi_list->s_grp->Lookup->toClientList() ?>;
fref_multilistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($ref_multi_list->s_grp->lookupOptions()) ?>;
fref_multilistsrch.lists["x_product_type"] = <?php echo $ref_multi_list->product_type->Lookup->toClientList() ?>;
fref_multilistsrch.lists["x_product_type"].options = <?php echo JsonEncode($ref_multi_list->product_type->lookupOptions()) ?>;
fref_multilistsrch.autoSuggests["x_product_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fref_multilistsrch.lists["x_status"] = <?php echo $ref_multi_list->status->Lookup->toClientList() ?>;
fref_multilistsrch.lists["x_status"].options = <?php echo JsonEncode($ref_multi_list->status->options(FALSE, TRUE)) ?>;

// Filters
fref_multilistsrch.filterList = <?php echo $ref_multi_list->getFilterList() ?>;

// Init search panel as collapsed
fref_multilistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ref_multi->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ref_multi_list->TotalRecs > 0 && $ref_multi_list->ExportOptions->visible()) { ?>
<?php $ref_multi_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ref_multi_list->ImportOptions->visible()) { ?>
<?php $ref_multi_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ref_multi_list->SearchOptions->visible()) { ?>
<?php $ref_multi_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ref_multi_list->FilterOptions->visible()) { ?>
<?php $ref_multi_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ref_multi_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ref_multi->isExport() && !$ref_multi->CurrentAction) { ?>
<form name="fref_multilistsrch" id="fref_multilistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($ref_multi_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fref_multilistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ref_multi">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$ref_multi_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$ref_multi->RowType = ROWTYPE_SEARCH;

// Render row
$ref_multi->resetAttributes();
$ref_multi_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($ref_multi->id->Visible) { // id ?>
	<div id="xsc_id" class="ew-cell form-group">
		<label for="x_id" class="ew-search-caption ew-label"><?php echo $ref_multi->id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="ref_multi" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($ref_multi->id->getPlaceHolder()) ?>" value="<?php echo $ref_multi->id->EditValue ?>"<?php echo $ref_multi->id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($ref_multi->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label for="x_company_id" class="ew-search-caption ew-label"><?php echo $ref_multi->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_company_id" data-value-separator="<?php echo $ref_multi->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $ref_multi->company_id->editAttributes() ?>>
		<?php echo $ref_multi->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $ref_multi->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($ref_multi->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $ref_multi->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $ref_multi->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_multi->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_grp" data-value-separator="<?php echo $ref_multi->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref_multi->grp->editAttributes() ?>>
		<?php echo $ref_multi->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $ref_multi->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($ref_multi->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $ref_multi->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<?php $ref_multi->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref_multi->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_s_grp" data-value-separator="<?php echo $ref_multi->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref_multi->s_grp->editAttributes() ?>>
		<?php echo $ref_multi->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref_multi->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($ref_multi->product_type->Visible) { // product_type ?>
	<div id="xsc_product_type" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $ref_multi->product_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_type" id="z_product_type" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$ref_multi->product_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref_multi->product_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_product_type" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x_product_type" id="sv_x_product_type" value="<?php echo RemoveHtml($ref_multi->product_type->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref_multi->product_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref_multi->product_type->getPlaceHolder()) ?>"<?php echo $ref_multi->product_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref_multi" data-field="x_product_type" data-value-separator="<?php echo $ref_multi->product_type->displayValueSeparatorAttribute() ?>" name="x_product_type" id="x_product_type" value="<?php echo HtmlEncode($ref_multi->product_type->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fref_multilistsrch.createAutoSuggest({"id":"x_product_type","forceSelect":false});
</script>
<?php echo $ref_multi->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
	</div>
<?php } ?>
<?php if ($ref_multi->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $ref_multi->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref_multi" data-field="x_status" data-value-separator="<?php echo $ref_multi->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ref_multi->status->editAttributes() ?>>
		<?php echo $ref_multi->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($ref_multi_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($ref_multi_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ref_multi_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ref_multi_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ref_multi_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ref_multi_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ref_multi_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $ref_multi_list->showPageHeader(); ?>
<?php
$ref_multi_list->showMessage();
?>
<?php if ($ref_multi_list->TotalRecs > 0 || $ref_multi->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ref_multi_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ref_multi">
<?php if (!$ref_multi->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$ref_multi->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ref_multi_list->Pager)) $ref_multi_list->Pager = new PrevNextPager($ref_multi_list->StartRec, $ref_multi_list->DisplayRecs, $ref_multi_list->TotalRecs, $ref_multi_list->AutoHidePager) ?>
<?php if ($ref_multi_list->Pager->RecordCount > 0 && $ref_multi_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ref_multi_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ref_multi_list->pageUrl() ?>start=<?php echo $ref_multi_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ref_multi_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ref_multi_list->pageUrl() ?>start=<?php echo $ref_multi_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ref_multi_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ref_multi_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ref_multi_list->pageUrl() ?>start=<?php echo $ref_multi_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ref_multi_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ref_multi_list->pageUrl() ?>start=<?php echo $ref_multi_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ref_multi_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ref_multi_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ref_multi_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ref_multi_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ref_multi_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ref_multi_list->TotalRecs > 0 && (!$ref_multi_list->AutoHidePageSizeSelector || $ref_multi_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ref_multi">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ref_multi_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ref_multi_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ref_multi_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ref_multi_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ref_multi_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ref_multi->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ref_multi_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fref_multilist" id="fref_multilist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_multi_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_multi_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref_multi">
<div id="gmp_ref_multi" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($ref_multi_list->TotalRecs > 0 || $ref_multi->isGridEdit()) { ?>
<table id="tbl_ref_multilist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ref_multi_list->RowType = ROWTYPE_HEADER;

// Render list options
$ref_multi_list->renderListOptions();

// Render list options (header, left)
$ref_multi_list->ListOptions->render("header", "left");
?>
<?php if ($ref_multi->id->Visible) { // id ?>
	<?php if ($ref_multi->sortUrl($ref_multi->id) == "") { ?>
		<th data-name="id" class="<?php echo $ref_multi->id->headerCellClass() ?>"><div id="elh_ref_multi_id" class="ref_multi_id"><div class="ew-table-header-caption"><?php echo $ref_multi->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $ref_multi->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_multi->SortUrl($ref_multi->id) ?>',2);"><div id="elh_ref_multi_id" class="ref_multi_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_multi->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_multi->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_multi->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_multi->company_id->Visible) { // company_id ?>
	<?php if ($ref_multi->sortUrl($ref_multi->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $ref_multi->company_id->headerCellClass() ?>"><div id="elh_ref_multi_company_id" class="ref_multi_company_id"><div class="ew-table-header-caption"><?php echo $ref_multi->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $ref_multi->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_multi->SortUrl($ref_multi->company_id) ?>',2);"><div id="elh_ref_multi_company_id" class="ref_multi_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_multi->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_multi->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_multi->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_multi->grp->Visible) { // grp ?>
	<?php if ($ref_multi->sortUrl($ref_multi->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $ref_multi->grp->headerCellClass() ?>"><div id="elh_ref_multi_grp" class="ref_multi_grp"><div class="ew-table-header-caption"><?php echo $ref_multi->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $ref_multi->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_multi->SortUrl($ref_multi->grp) ?>',2);"><div id="elh_ref_multi_grp" class="ref_multi_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_multi->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_multi->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_multi->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_multi->s_grp->Visible) { // s_grp ?>
	<?php if ($ref_multi->sortUrl($ref_multi->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $ref_multi->s_grp->headerCellClass() ?>"><div id="elh_ref_multi_s_grp" class="ref_multi_s_grp"><div class="ew-table-header-caption"><?php echo $ref_multi->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $ref_multi->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_multi->SortUrl($ref_multi->s_grp) ?>',2);"><div id="elh_ref_multi_s_grp" class="ref_multi_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_multi->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_multi->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_multi->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_multi->product_type->Visible) { // product_type ?>
	<?php if ($ref_multi->sortUrl($ref_multi->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $ref_multi->product_type->headerCellClass() ?>"><div id="elh_ref_multi_product_type" class="ref_multi_product_type"><div class="ew-table-header-caption"><?php echo $ref_multi->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $ref_multi->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_multi->SortUrl($ref_multi->product_type) ?>',2);"><div id="elh_ref_multi_product_type" class="ref_multi_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_multi->product_type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref_multi->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_multi->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref_multi->status->Visible) { // status ?>
	<?php if ($ref_multi->sortUrl($ref_multi->status) == "") { ?>
		<th data-name="status" class="<?php echo $ref_multi->status->headerCellClass() ?>"><div id="elh_ref_multi_status" class="ref_multi_status"><div class="ew-table-header-caption"><?php echo $ref_multi->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $ref_multi->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref_multi->SortUrl($ref_multi->status) ?>',2);"><div id="elh_ref_multi_status" class="ref_multi_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref_multi->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref_multi->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref_multi->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ref_multi_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ref_multi->ExportAll && $ref_multi->isExport()) {
	$ref_multi_list->StopRec = $ref_multi_list->TotalRecs;
} else {

	// Set the last record to display
	if ($ref_multi_list->TotalRecs > $ref_multi_list->StartRec + $ref_multi_list->DisplayRecs - 1)
		$ref_multi_list->StopRec = $ref_multi_list->StartRec + $ref_multi_list->DisplayRecs - 1;
	else
		$ref_multi_list->StopRec = $ref_multi_list->TotalRecs;
}
$ref_multi_list->RecCnt = $ref_multi_list->StartRec - 1;
if ($ref_multi_list->Recordset && !$ref_multi_list->Recordset->EOF) {
	$ref_multi_list->Recordset->moveFirst();
	$selectLimit = $ref_multi_list->UseSelectLimit;
	if (!$selectLimit && $ref_multi_list->StartRec > 1)
		$ref_multi_list->Recordset->move($ref_multi_list->StartRec - 1);
} elseif (!$ref_multi->AllowAddDeleteRow && $ref_multi_list->StopRec == 0) {
	$ref_multi_list->StopRec = $ref_multi->GridAddRowCount;
}

// Initialize aggregate
$ref_multi->RowType = ROWTYPE_AGGREGATEINIT;
$ref_multi->resetAttributes();
$ref_multi_list->renderRow();
while ($ref_multi_list->RecCnt < $ref_multi_list->StopRec) {
	$ref_multi_list->RecCnt++;
	if ($ref_multi_list->RecCnt >= $ref_multi_list->StartRec) {
		$ref_multi_list->RowCnt++;

		// Set up key count
		$ref_multi_list->KeyCount = $ref_multi_list->RowIndex;

		// Init row class and style
		$ref_multi->resetAttributes();
		$ref_multi->CssClass = "";
		if ($ref_multi->isGridAdd()) {
		} else {
			$ref_multi_list->loadRowValues($ref_multi_list->Recordset); // Load row values
		}
		$ref_multi->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ref_multi->RowAttrs = array_merge($ref_multi->RowAttrs, array('data-rowindex'=>$ref_multi_list->RowCnt, 'id'=>'r' . $ref_multi_list->RowCnt . '_ref_multi', 'data-rowtype'=>$ref_multi->RowType));

		// Render row
		$ref_multi_list->renderRow();

		// Render list options
		$ref_multi_list->renderListOptions();
?>
	<tr<?php echo $ref_multi->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ref_multi_list->ListOptions->render("body", "left", $ref_multi_list->RowCnt);
?>
	<?php if ($ref_multi->id->Visible) { // id ?>
		<td data-name="id"<?php echo $ref_multi->id->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_list->RowCnt ?>_ref_multi_id" class="ref_multi_id">
<span<?php echo $ref_multi->id->viewAttributes() ?>>
<?php echo $ref_multi->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_multi->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $ref_multi->company_id->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_list->RowCnt ?>_ref_multi_company_id" class="ref_multi_company_id">
<span<?php echo $ref_multi->company_id->viewAttributes() ?>>
<?php echo $ref_multi->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_multi->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $ref_multi->grp->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_list->RowCnt ?>_ref_multi_grp" class="ref_multi_grp">
<span<?php echo $ref_multi->grp->viewAttributes() ?>>
<?php echo $ref_multi->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_multi->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $ref_multi->s_grp->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_list->RowCnt ?>_ref_multi_s_grp" class="ref_multi_s_grp">
<span<?php echo $ref_multi->s_grp->viewAttributes() ?>>
<?php echo $ref_multi->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_multi->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $ref_multi->product_type->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_list->RowCnt ?>_ref_multi_product_type" class="ref_multi_product_type">
<span<?php echo $ref_multi->product_type->viewAttributes() ?>>
<?php echo $ref_multi->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref_multi->status->Visible) { // status ?>
		<td data-name="status"<?php echo $ref_multi->status->cellAttributes() ?>>
<span id="el<?php echo $ref_multi_list->RowCnt ?>_ref_multi_status" class="ref_multi_status">
<span<?php echo $ref_multi->status->viewAttributes() ?>>
<?php echo $ref_multi->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ref_multi_list->ListOptions->render("body", "right", $ref_multi_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$ref_multi->isGridAdd())
		$ref_multi_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$ref_multi->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ref_multi_list->Recordset)
	$ref_multi_list->Recordset->Close();
?>
<?php if (!$ref_multi->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ref_multi->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ref_multi_list->Pager)) $ref_multi_list->Pager = new PrevNextPager($ref_multi_list->StartRec, $ref_multi_list->DisplayRecs, $ref_multi_list->TotalRecs, $ref_multi_list->AutoHidePager) ?>
<?php if ($ref_multi_list->Pager->RecordCount > 0 && $ref_multi_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ref_multi_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ref_multi_list->pageUrl() ?>start=<?php echo $ref_multi_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ref_multi_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ref_multi_list->pageUrl() ?>start=<?php echo $ref_multi_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ref_multi_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ref_multi_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ref_multi_list->pageUrl() ?>start=<?php echo $ref_multi_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ref_multi_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ref_multi_list->pageUrl() ?>start=<?php echo $ref_multi_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ref_multi_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ref_multi_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ref_multi_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ref_multi_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ref_multi_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ref_multi_list->TotalRecs > 0 && (!$ref_multi_list->AutoHidePageSizeSelector || $ref_multi_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ref_multi">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ref_multi_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ref_multi_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ref_multi_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ref_multi_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ref_multi_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ref_multi->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ref_multi_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ref_multi_list->TotalRecs == 0 && !$ref_multi->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ref_multi_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ref_multi_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ref_multi->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$ref_multi->isExport()) { ?>
<script>
ew.scrollableTable("gmp_ref_multi", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ref_multi_list->terminate();
?>