<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_addopt = new ref_addopt();

// Run the page
$ref_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var frefaddopt = currentForm = new ew.Form("frefaddopt", "addopt");

// Validate form
frefaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ref_addopt->oid->Required) { ?>
			elm = this.getElements("x" + infix + "_oid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->oid->caption(), $ref->oid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_oid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->oid->errorMessage()) ?>");
		<?php if ($ref_addopt->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->company_id->caption(), $ref->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->grp->caption(), $ref->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->s_grp->caption(), $ref->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product->caption(), $ref->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product_type->caption(), $ref->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->packing_type->caption(), $ref->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->_barcode->caption(), $ref->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->product_code_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product_code_type->caption(), $ref->product_code_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product_code->caption(), $ref->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->gcode->Required) { ?>
			elm = this.getElements("x" + infix + "_gcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->gcode->caption(), $ref->gcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->code->caption(), $ref->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->product_id->Required) { ?>
			elm = this.getElements("x" + infix + "_product_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product_id->caption(), $ref->product_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->print_name->Required) { ?>
			elm = this.getElements("x" + infix + "_print_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->print_name->caption(), $ref->print_name->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_print_name");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->print_name->errorMessage()) ?>");
		<?php if ($ref_addopt->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->batch_no->caption(), $ref->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->set_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_set_ref[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->set_ref->caption(), $ref->set_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_00->Required) { ?>
			elm = this.getElements("x" + infix + "_v_00");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_00->caption(), $ref->v_00->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_01->Required) { ?>
			elm = this.getElements("x" + infix + "_v_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_01->caption(), $ref->v_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_02->Required) { ?>
			elm = this.getElements("x" + infix + "_v_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_02->caption(), $ref->v_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_03->Required) { ?>
			elm = this.getElements("x" + infix + "_v_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_03->caption(), $ref->v_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_04->Required) { ?>
			elm = this.getElements("x" + infix + "_v_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_04->caption(), $ref->v_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_05->Required) { ?>
			elm = this.getElements("x" + infix + "_v_05");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_05->caption(), $ref->v_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_06->Required) { ?>
			elm = this.getElements("x" + infix + "_v_06");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_06->caption(), $ref->v_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_07->Required) { ?>
			elm = this.getElements("x" + infix + "_v_07");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_07->caption(), $ref->v_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_08->Required) { ?>
			elm = this.getElements("x" + infix + "_v_08");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_08->caption(), $ref->v_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_09->Required) { ?>
			elm = this.getElements("x" + infix + "_v_09");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_09->caption(), $ref->v_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->v_10->Required) { ?>
			elm = this.getElements("x" + infix + "_v_10");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_10->caption(), $ref->v_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->cbm->caption(), $ref->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->sqm->caption(), $ref->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->shape->caption(), $ref->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->q_sku->Required) { ?>
			elm = this.getElements("x" + infix + "_q_sku");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->q_sku->caption(), $ref->q_sku->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_q_sku");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->q_sku->errorMessage()) ?>");
		<?php if ($ref_addopt->b_01->Required) { ?>
			elm = this.getElements("x" + infix + "_b_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_01->caption(), $ref->b_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_02->Required) { ?>
			elm = this.getElements("x" + infix + "_b_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_02->caption(), $ref->b_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_03->Required) { ?>
			elm = this.getElements("x" + infix + "_b_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_03->caption(), $ref->b_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_04->Required) { ?>
			elm = this.getElements("x" + infix + "_b_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_04->caption(), $ref->b_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_05->Required) { ?>
			elm = this.getElements("x" + infix + "_b_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_05->caption(), $ref->b_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_06->Required) { ?>
			elm = this.getElements("x" + infix + "_b_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_06->caption(), $ref->b_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_07->Required) { ?>
			elm = this.getElements("x" + infix + "_b_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_07->caption(), $ref->b_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_08->Required) { ?>
			elm = this.getElements("x" + infix + "_b_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_08->caption(), $ref->b_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_09->Required) { ?>
			elm = this.getElements("x" + infix + "_b_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_09->caption(), $ref->b_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_10->Required) { ?>
			elm = this.getElements("x" + infix + "_b_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_10->caption(), $ref->b_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_11->Required) { ?>
			elm = this.getElements("x" + infix + "_b_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_11->caption(), $ref->b_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_12->Required) { ?>
			elm = this.getElements("x" + infix + "_b_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_12->caption(), $ref->b_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_13->Required) { ?>
			elm = this.getElements("x" + infix + "_b_13");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_13->caption(), $ref->b_13->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_14->Required) { ?>
			elm = this.getElements("x" + infix + "_b_14");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_14->caption(), $ref->b_14->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->b_15->Required) { ?>
			elm = this.getElements("x" + infix + "_b_15");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_15->caption(), $ref->b_15->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_01->Required) { ?>
			elm = this.getElements("x" + infix + "_t_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_01->caption(), $ref->t_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_02->Required) { ?>
			elm = this.getElements("x" + infix + "_t_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_02->caption(), $ref->t_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_03->Required) { ?>
			elm = this.getElements("x" + infix + "_t_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_03->caption(), $ref->t_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_04->Required) { ?>
			elm = this.getElements("x" + infix + "_t_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_04->caption(), $ref->t_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_05->Required) { ?>
			elm = this.getElements("x" + infix + "_t_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_05->caption(), $ref->t_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_06->Required) { ?>
			elm = this.getElements("x" + infix + "_t_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_06->caption(), $ref->t_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_07->Required) { ?>
			elm = this.getElements("x" + infix + "_t_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_07->caption(), $ref->t_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_08->Required) { ?>
			elm = this.getElements("x" + infix + "_t_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_08->caption(), $ref->t_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_09->Required) { ?>
			elm = this.getElements("x" + infix + "_t_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_09->caption(), $ref->t_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_10->Required) { ?>
			elm = this.getElements("x" + infix + "_t_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_10->caption(), $ref->t_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_11->Required) { ?>
			elm = this.getElements("x" + infix + "_t_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_11->caption(), $ref->t_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_12->Required) { ?>
			elm = this.getElements("x" + infix + "_t_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_12->caption(), $ref->t_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_13->Required) { ?>
			elm = this.getElements("x" + infix + "_t_13");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_13->caption(), $ref->t_13->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_14->Required) { ?>
			elm = this.getElements("x" + infix + "_t_14");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_14->caption(), $ref->t_14->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->t_15->Required) { ?>
			elm = this.getElements("x" + infix + "_t_15");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_15->caption(), $ref->t_15->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->d_head_01->Required) { ?>
			elm = this.getElements("x" + infix + "_d_head_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->d_head_01->caption(), $ref->d_head_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->d_description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_d_description_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->d_description_01->caption(), $ref->d_description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->d_head_02->Required) { ?>
			elm = this.getElements("x" + infix + "_d_head_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->d_head_02->caption(), $ref->d_head_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->d_description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_d_description_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->d_description_02->caption(), $ref->d_description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->main_image->Required) { ?>
			felm = this.getElements("x" + infix + "_main_image");
			elm = this.getElements("fn_x" + infix + "_main_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->main_image->caption(), $ref->main_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->top_view->Required) { ?>
			felm = this.getElements("x" + infix + "_top_view");
			elm = this.getElements("fn_x" + infix + "_top_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->top_view->caption(), $ref->top_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->front_view->Required) { ?>
			felm = this.getElements("x" + infix + "_front_view");
			elm = this.getElements("fn_x" + infix + "_front_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->front_view->caption(), $ref->front_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->corner_view->Required) { ?>
			felm = this.getElements("x" + infix + "_corner_view");
			elm = this.getElements("fn_x" + infix + "_corner_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->corner_view->caption(), $ref->corner_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->back_view->Required) { ?>
			felm = this.getElements("x" + infix + "_back_view");
			elm = this.getElements("fn_x" + infix + "_back_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->back_view->caption(), $ref->back_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->color_options->Required) { ?>
			felm = this.getElements("x" + infix + "_color_options");
			elm = this.getElements("fn_x" + infix + "_color_options");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->color_options->caption(), $ref->color_options->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->other_options->Required) { ?>
			felm = this.getElements("x" + infix + "_other_options");
			elm = this.getElements("fn_x" + infix + "_other_options");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->other_options->caption(), $ref->other_options->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->group_image->Required) { ?>
			felm = this.getElements("x" + infix + "_group_image");
			elm = this.getElements("fn_x" + infix + "_group_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->group_image->caption(), $ref->group_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->video_url->Required) { ?>
			elm = this.getElements("x" + infix + "_video_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->video_url->caption(), $ref->video_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->image->caption(), $ref->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->last_price->Required) { ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->last_price->caption(), $ref->last_price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->last_price->errorMessage()) ?>");
		<?php if ($ref_addopt->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->currency->caption(), $ref->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->hsn->Required) { ?>
			elm = this.getElements("x" + infix + "_hsn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->hsn->caption(), $ref->hsn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->composition->Required) { ?>
			elm = this.getElements("x" + infix + "_composition");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->composition->caption(), $ref->composition->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->category->caption(), $ref->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->moq->Required) { ?>
			elm = this.getElements("x" + infix + "_moq");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->moq->caption(), $ref->moq->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_moq");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->moq->errorMessage()) ?>");
		<?php if ($ref_addopt->in->Required) { ?>
			elm = this.getElements("x" + infix + "_in");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->in->caption(), $ref->in->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_in");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->in->errorMessage()) ?>");
		<?php if ($ref_addopt->out->Required) { ?>
			elm = this.getElements("x" + infix + "_out");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->out->caption(), $ref->out->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_out");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->out->errorMessage()) ?>");
		<?php if ($ref_addopt->required->Required) { ?>
			elm = this.getElements("x" + infix + "_required");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->required->caption(), $ref->required->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_required");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->required->errorMessage()) ?>");
		<?php if ($ref_addopt->blocked->Required) { ?>
			elm = this.getElements("x" + infix + "_blocked");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->blocked->caption(), $ref->blocked->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_blocked");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->blocked->errorMessage()) ?>");
		<?php if ($ref_addopt->ordered->Required) { ?>
			elm = this.getElements("x" + infix + "_ordered");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->ordered->caption(), $ref->ordered->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ordered");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->ordered->errorMessage()) ?>");
		<?php if ($ref_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->status->caption(), $ref->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->publish->Required) { ?>
			elm = this.getElements("x" + infix + "_publish");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->publish->caption(), $ref->publish->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->keywords->Required) { ?>
			elm = this.getElements("x" + infix + "_keywords");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->keywords->caption(), $ref->keywords->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->operator->caption(), $ref->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->datetime->caption(), $ref->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->supplier->Required) { ?>
			elm = this.getElements("x" + infix + "_supplier");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->supplier->caption(), $ref->supplier->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->country->caption(), $ref->country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_addopt->minimum_stock->Required) { ?>
			elm = this.getElements("x" + infix + "_minimum_stock");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->minimum_stock->caption(), $ref->minimum_stock->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_minimum_stock");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->minimum_stock->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
frefaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frefaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frefaddopt.lists["x_company_id[]"] = <?php echo $ref_addopt->company_id->Lookup->toClientList() ?>;
frefaddopt.lists["x_company_id[]"].options = <?php echo JsonEncode($ref_addopt->company_id->lookupOptions()) ?>;
frefaddopt.lists["x_grp"] = <?php echo $ref_addopt->grp->Lookup->toClientList() ?>;
frefaddopt.lists["x_grp"].options = <?php echo JsonEncode($ref_addopt->grp->lookupOptions()) ?>;
frefaddopt.lists["x_s_grp"] = <?php echo $ref_addopt->s_grp->Lookup->toClientList() ?>;
frefaddopt.lists["x_s_grp"].options = <?php echo JsonEncode($ref_addopt->s_grp->lookupOptions()) ?>;
frefaddopt.lists["x_product"] = <?php echo $ref_addopt->product->Lookup->toClientList() ?>;
frefaddopt.lists["x_product"].options = <?php echo JsonEncode($ref_addopt->product->lookupOptions()) ?>;
frefaddopt.lists["x_product_type"] = <?php echo $ref_addopt->product_type->Lookup->toClientList() ?>;
frefaddopt.lists["x_product_type"].options = <?php echo JsonEncode($ref_addopt->product_type->lookupOptions()) ?>;
frefaddopt.lists["x_packing_type"] = <?php echo $ref_addopt->packing_type->Lookup->toClientList() ?>;
frefaddopt.lists["x_packing_type"].options = <?php echo JsonEncode($ref_addopt->packing_type->lookupOptions()) ?>;
frefaddopt.lists["x_product_code_type"] = <?php echo $ref_addopt->product_code_type->Lookup->toClientList() ?>;
frefaddopt.lists["x_product_code_type"].options = <?php echo JsonEncode($ref_addopt->product_code_type->options(FALSE, TRUE)) ?>;
frefaddopt.lists["x_set_ref[]"] = <?php echo $ref_addopt->set_ref->Lookup->toClientList() ?>;
frefaddopt.lists["x_set_ref[]"].options = <?php echo JsonEncode($ref_addopt->set_ref->lookupOptions()) ?>;
frefaddopt.lists["x_v_01"] = <?php echo $ref_addopt->v_01->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_01"].options = <?php echo JsonEncode($ref_addopt->v_01->lookupOptions()) ?>;
frefaddopt.lists["x_v_02"] = <?php echo $ref_addopt->v_02->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_02"].options = <?php echo JsonEncode($ref_addopt->v_02->lookupOptions()) ?>;
frefaddopt.lists["x_v_03"] = <?php echo $ref_addopt->v_03->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_03"].options = <?php echo JsonEncode($ref_addopt->v_03->lookupOptions()) ?>;
frefaddopt.lists["x_v_04"] = <?php echo $ref_addopt->v_04->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_04"].options = <?php echo JsonEncode($ref_addopt->v_04->lookupOptions()) ?>;
frefaddopt.lists["x_v_05"] = <?php echo $ref_addopt->v_05->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_05"].options = <?php echo JsonEncode($ref_addopt->v_05->lookupOptions()) ?>;
frefaddopt.lists["x_v_06"] = <?php echo $ref_addopt->v_06->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_06"].options = <?php echo JsonEncode($ref_addopt->v_06->lookupOptions()) ?>;
frefaddopt.lists["x_v_07"] = <?php echo $ref_addopt->v_07->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_07"].options = <?php echo JsonEncode($ref_addopt->v_07->lookupOptions()) ?>;
frefaddopt.lists["x_v_08"] = <?php echo $ref_addopt->v_08->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_08"].options = <?php echo JsonEncode($ref_addopt->v_08->lookupOptions()) ?>;
frefaddopt.lists["x_v_09"] = <?php echo $ref_addopt->v_09->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_09"].options = <?php echo JsonEncode($ref_addopt->v_09->lookupOptions()) ?>;
frefaddopt.lists["x_v_10"] = <?php echo $ref_addopt->v_10->Lookup->toClientList() ?>;
frefaddopt.lists["x_v_10"].options = <?php echo JsonEncode($ref_addopt->v_10->lookupOptions()) ?>;
frefaddopt.lists["x_shape[]"] = <?php echo $ref_addopt->shape->Lookup->toClientList() ?>;
frefaddopt.lists["x_shape[]"].options = <?php echo JsonEncode($ref_addopt->shape->lookupOptions()) ?>;
frefaddopt.lists["x_b_03[]"] = <?php echo $ref_addopt->b_03->Lookup->toClientList() ?>;
frefaddopt.lists["x_b_03[]"].options = <?php echo JsonEncode($ref_addopt->b_03->lookupOptions()) ?>;
frefaddopt.lists["x_b_04[]"] = <?php echo $ref_addopt->b_04->Lookup->toClientList() ?>;
frefaddopt.lists["x_b_04[]"].options = <?php echo JsonEncode($ref_addopt->b_04->lookupOptions()) ?>;
frefaddopt.lists["x_b_05[]"] = <?php echo $ref_addopt->b_05->Lookup->toClientList() ?>;
frefaddopt.lists["x_b_05[]"].options = <?php echo JsonEncode($ref_addopt->b_05->lookupOptions()) ?>;
frefaddopt.lists["x_b_06[]"] = <?php echo $ref_addopt->b_06->Lookup->toClientList() ?>;
frefaddopt.lists["x_b_06[]"].options = <?php echo JsonEncode($ref_addopt->b_06->lookupOptions()) ?>;
frefaddopt.lists["x_b_07[]"] = <?php echo $ref_addopt->b_07->Lookup->toClientList() ?>;
frefaddopt.lists["x_b_07[]"].options = <?php echo JsonEncode($ref_addopt->b_07->lookupOptions()) ?>;
frefaddopt.lists["x_b_08[]"] = <?php echo $ref_addopt->b_08->Lookup->toClientList() ?>;
frefaddopt.lists["x_b_08[]"].options = <?php echo JsonEncode($ref_addopt->b_08->lookupOptions()) ?>;
frefaddopt.lists["x_b_09[]"] = <?php echo $ref_addopt->b_09->Lookup->toClientList() ?>;
frefaddopt.lists["x_b_09[]"].options = <?php echo JsonEncode($ref_addopt->b_09->lookupOptions()) ?>;
frefaddopt.lists["x_b_10[]"] = <?php echo $ref_addopt->b_10->Lookup->toClientList() ?>;
frefaddopt.lists["x_b_10[]"].options = <?php echo JsonEncode($ref_addopt->b_10->lookupOptions()) ?>;
frefaddopt.lists["x_t_03[]"] = <?php echo $ref_addopt->t_03->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_03[]"].options = <?php echo JsonEncode($ref_addopt->t_03->lookupOptions()) ?>;
frefaddopt.lists["x_t_04[]"] = <?php echo $ref_addopt->t_04->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_04[]"].options = <?php echo JsonEncode($ref_addopt->t_04->lookupOptions()) ?>;
frefaddopt.lists["x_t_05[]"] = <?php echo $ref_addopt->t_05->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_05[]"].options = <?php echo JsonEncode($ref_addopt->t_05->lookupOptions()) ?>;
frefaddopt.lists["x_t_06[]"] = <?php echo $ref_addopt->t_06->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_06[]"].options = <?php echo JsonEncode($ref_addopt->t_06->lookupOptions()) ?>;
frefaddopt.lists["x_t_07[]"] = <?php echo $ref_addopt->t_07->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_07[]"].options = <?php echo JsonEncode($ref_addopt->t_07->lookupOptions()) ?>;
frefaddopt.lists["x_t_08[]"] = <?php echo $ref_addopt->t_08->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_08[]"].options = <?php echo JsonEncode($ref_addopt->t_08->lookupOptions()) ?>;
frefaddopt.lists["x_t_09[]"] = <?php echo $ref_addopt->t_09->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_09[]"].options = <?php echo JsonEncode($ref_addopt->t_09->lookupOptions()) ?>;
frefaddopt.lists["x_t_10[]"] = <?php echo $ref_addopt->t_10->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_10[]"].options = <?php echo JsonEncode($ref_addopt->t_10->lookupOptions()) ?>;
frefaddopt.lists["x_t_11"] = <?php echo $ref_addopt->t_11->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_11"].options = <?php echo JsonEncode($ref_addopt->t_11->lookupOptions()) ?>;
frefaddopt.autoSuggests["x_t_11"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frefaddopt.lists["x_t_12"] = <?php echo $ref_addopt->t_12->Lookup->toClientList() ?>;
frefaddopt.lists["x_t_12"].options = <?php echo JsonEncode($ref_addopt->t_12->lookupOptions()) ?>;
frefaddopt.autoSuggests["x_t_12"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frefaddopt.lists["x_currency"] = <?php echo $ref_addopt->currency->Lookup->toClientList() ?>;
frefaddopt.lists["x_currency"].options = <?php echo JsonEncode($ref_addopt->currency->lookupOptions()) ?>;
frefaddopt.lists["x_hsn"] = <?php echo $ref_addopt->hsn->Lookup->toClientList() ?>;
frefaddopt.lists["x_hsn"].options = <?php echo JsonEncode($ref_addopt->hsn->lookupOptions()) ?>;
frefaddopt.lists["x_composition"] = <?php echo $ref_addopt->composition->Lookup->toClientList() ?>;
frefaddopt.lists["x_composition"].options = <?php echo JsonEncode($ref_addopt->composition->lookupOptions()) ?>;
frefaddopt.lists["x_category"] = <?php echo $ref_addopt->category->Lookup->toClientList() ?>;
frefaddopt.lists["x_category"].options = <?php echo JsonEncode($ref_addopt->category->lookupOptions()) ?>;
frefaddopt.lists["x_status"] = <?php echo $ref_addopt->status->Lookup->toClientList() ?>;
frefaddopt.lists["x_status"].options = <?php echo JsonEncode($ref_addopt->status->options(FALSE, TRUE)) ?>;
frefaddopt.lists["x_publish"] = <?php echo $ref_addopt->publish->Lookup->toClientList() ?>;
frefaddopt.lists["x_publish"].options = <?php echo JsonEncode($ref_addopt->publish->options(FALSE, TRUE)) ?>;
frefaddopt.lists["x_operator"] = <?php echo $ref_addopt->operator->Lookup->toClientList() ?>;
frefaddopt.lists["x_operator"].options = <?php echo JsonEncode($ref_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_addopt->showPageHeader(); ?>
<?php
$ref_addopt->showMessage();
?>
<form name="frefaddopt" id="frefaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($ref_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $ref_addopt->TableVar ?>">
<?php if ($ref->oid->Visible) { // oid ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_oid"><?php echo $ref->oid->caption() ?><?php echo ($ref->oid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_oid" name="x_oid" id="x_oid" size="30" placeholder="<?php echo HtmlEncode($ref->oid->getPlaceHolder()) ?>" value="<?php echo $ref->oid->EditValue ?>"<?php echo $ref->oid->editAttributes() ?>>
<?php echo $ref->oid->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->company_id->Visible) { // company_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_company_id"><?php echo $ref->company_id->caption() ?><?php echo ($ref->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_company_id"><?php echo strval($ref->company_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($ref->company_id->ViewValue) : $ref->company_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($ref->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($ref->company_id->ReadOnly || $ref->company_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_company_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $ref->company_id->Lookup->getParamTag("p_x_company_id") ?>
<input type="hidden" data-table="ref" data-field="x_company_id" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $ref->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id[]" id="x_company_id[]" value="<?php echo $ref->company_id->CurrentValue ?>"<?php echo $ref->company_id->editAttributes() ?>>
<?php echo $ref->company_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $ref->grp->caption() ?><?php echo ($ref->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $ref->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_grp" data-value-separator="<?php echo $ref->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref->grp->editAttributes() ?>>
		<?php echo $ref->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $ref->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $ref->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->s_grp->Visible) { // s_grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_s_grp"><?php echo $ref->s_grp->caption() ?><?php echo ($ref->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $ref->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_s_grp" data-value-separator="<?php echo $ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref->s_grp->editAttributes() ?>>
		<?php echo $ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
<?php echo $ref->s_grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->product->Visible) { // product ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product"><?php echo $ref->product->caption() ?><?php echo ($ref->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product" data-value-separator="<?php echo $ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref->product->editAttributes() ?>>
		<?php echo $ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $ref->product->Lookup->getParamTag("p_x_product") ?>
<?php echo $ref->product->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->product_type->Visible) { // product_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product_type"><?php echo $ref->product_type->caption() ?><?php echo ($ref->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product_type" data-value-separator="<?php echo $ref->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $ref->product_type->editAttributes() ?>>
		<?php echo $ref->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $ref->product_type->Lookup->getParamTag("p_x_product_type") ?>
<?php echo $ref->product_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->packing_type->Visible) { // packing_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_packing_type"><?php echo $ref->packing_type->caption() ?><?php echo ($ref->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_packing_type" data-value-separator="<?php echo $ref->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $ref->packing_type->editAttributes() ?>>
		<?php echo $ref->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $ref->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
<?php echo $ref->packing_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->_barcode->Visible) { // barcode ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__barcode"><?php echo $ref->_barcode->caption() ?><?php echo ($ref->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->_barcode->getPlaceHolder()) ?>" value="<?php echo $ref->_barcode->EditValue ?>"<?php echo $ref->_barcode->editAttributes() ?>>
<?php echo $ref->_barcode->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->product_code_type->Visible) { // product_code_type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product_code_type"><?php echo $ref->product_code_type->caption() ?><?php echo ($ref->product_code_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product_code_type" data-value-separator="<?php echo $ref->product_code_type->displayValueSeparatorAttribute() ?>" id="x_product_code_type" name="x_product_code_type"<?php echo $ref->product_code_type->editAttributes() ?>>
		<?php echo $ref->product_code_type->selectOptionListHtml("x_product_code_type") ?>
	</select>
</div>
<?php echo $ref->product_code_type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->product_code->Visible) { // product_code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product_code"><?php echo $ref->product_code->caption() ?><?php echo ($ref->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="ref" data-field="x_product_code" name="x_product_code" id="x_product_code" cols="35" rows="1" placeholder="<?php echo HtmlEncode($ref->product_code->getPlaceHolder()) ?>"<?php echo $ref->product_code->editAttributes() ?>><?php echo $ref->product_code->EditValue ?></textarea>
<?php echo $ref->product_code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->gcode->Visible) { // gcode ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_gcode"><?php echo $ref->gcode->caption() ?><?php echo ($ref->gcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_gcode" name="x_gcode" id="x_gcode" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($ref->gcode->getPlaceHolder()) ?>" value="<?php echo $ref->gcode->EditValue ?>"<?php echo $ref->gcode->editAttributes() ?>>
<?php echo $ref->gcode->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $ref->code->caption() ?><?php echo ($ref->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($ref->code->getPlaceHolder()) ?>" value="<?php echo $ref->code->EditValue ?>"<?php echo $ref->code->editAttributes() ?>>
<?php echo $ref->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->product_id->Visible) { // product_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_product_id"><?php echo $ref->product_id->caption() ?><?php echo ($ref->product_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_product_id" name="x_product_id" id="x_product_id" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->product_id->getPlaceHolder()) ?>" value="<?php echo $ref->product_id->EditValue ?>"<?php echo $ref->product_id->editAttributes() ?>>
<?php echo $ref->product_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->print_name->Visible) { // print_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_print_name"><?php echo $ref->print_name->caption() ?><?php echo ($ref->print_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_print_name" name="x_print_name" id="x_print_name" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($ref->print_name->getPlaceHolder()) ?>" value="<?php echo $ref->print_name->EditValue ?>"<?php echo $ref->print_name->editAttributes() ?>>
<?php echo $ref->print_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->batch_no->Visible) { // batch_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_batch_no"><?php echo $ref->batch_no->caption() ?><?php echo ($ref->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($ref->batch_no->getPlaceHolder()) ?>" value="<?php echo $ref->batch_no->EditValue ?>"<?php echo $ref->batch_no->editAttributes() ?>>
<?php echo $ref->batch_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->set_ref->Visible) { // set_ref ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->set_ref->caption() ?><?php echo ($ref->set_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($ref->set_ref->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $ref->set_ref->ViewValue ?></button>
		<div id="dsl_x_set_ref" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $ref->set_ref->checkBoxListHtml(TRUE, "x_set_ref[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_set_ref" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_set_ref" data-value-separator="<?php echo $ref->set_ref->displayValueSeparatorAttribute() ?>" name="x_set_ref[]" id="x_set_ref[]" value="{value}"<?php echo $ref->set_ref->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$ref->set_ref->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $ref->set_ref->Lookup->getParamTag("p_x_set_ref") ?>
</div><!-- /.ew-dropdown-list ##-->
<?php echo $ref->set_ref->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_00->Visible) { // v_00 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_00"><?php echo $ref->v_00->caption() ?><?php echo ($ref->v_00->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_v_00" name="x_v_00" id="x_v_00" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->v_00->getPlaceHolder()) ?>" value="<?php echo $ref->v_00->EditValue ?>"<?php echo $ref->v_00->editAttributes() ?>>
<?php echo $ref->v_00->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_01->Visible) { // v_01 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_01"><?php echo $ref->v_01->caption() ?><?php echo ($ref->v_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_01" data-value-separator="<?php echo $ref->v_01->displayValueSeparatorAttribute() ?>" id="x_v_01" name="x_v_01"<?php echo $ref->v_01->editAttributes() ?>>
		<?php echo $ref->v_01->selectOptionListHtml("x_v_01") ?>
	</select>
</div>
<?php echo $ref->v_01->Lookup->getParamTag("p_x_v_01") ?>
<?php echo $ref->v_01->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_02->Visible) { // v_02 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_02"><?php echo $ref->v_02->caption() ?><?php echo ($ref->v_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_02" data-value-separator="<?php echo $ref->v_02->displayValueSeparatorAttribute() ?>" id="x_v_02" name="x_v_02"<?php echo $ref->v_02->editAttributes() ?>>
		<?php echo $ref->v_02->selectOptionListHtml("x_v_02") ?>
	</select>
</div>
<?php echo $ref->v_02->Lookup->getParamTag("p_x_v_02") ?>
<?php echo $ref->v_02->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_03->Visible) { // v_03 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_03"><?php echo $ref->v_03->caption() ?><?php echo ($ref->v_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_03" data-value-separator="<?php echo $ref->v_03->displayValueSeparatorAttribute() ?>" id="x_v_03" name="x_v_03"<?php echo $ref->v_03->editAttributes() ?>>
		<?php echo $ref->v_03->selectOptionListHtml("x_v_03") ?>
	</select>
</div>
<?php echo $ref->v_03->Lookup->getParamTag("p_x_v_03") ?>
<?php echo $ref->v_03->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_04->Visible) { // v_04 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_04"><?php echo $ref->v_04->caption() ?><?php echo ($ref->v_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_04" data-value-separator="<?php echo $ref->v_04->displayValueSeparatorAttribute() ?>" id="x_v_04" name="x_v_04"<?php echo $ref->v_04->editAttributes() ?>>
		<?php echo $ref->v_04->selectOptionListHtml("x_v_04") ?>
	</select>
</div>
<?php echo $ref->v_04->Lookup->getParamTag("p_x_v_04") ?>
<?php echo $ref->v_04->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_05->Visible) { // v_05 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_05"><?php echo $ref->v_05->caption() ?><?php echo ($ref->v_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_05" data-value-separator="<?php echo $ref->v_05->displayValueSeparatorAttribute() ?>" id="x_v_05" name="x_v_05"<?php echo $ref->v_05->editAttributes() ?>>
		<?php echo $ref->v_05->selectOptionListHtml("x_v_05") ?>
	</select>
</div>
<?php echo $ref->v_05->Lookup->getParamTag("p_x_v_05") ?>
<?php echo $ref->v_05->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_06->Visible) { // v_06 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_06"><?php echo $ref->v_06->caption() ?><?php echo ($ref->v_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_06" data-value-separator="<?php echo $ref->v_06->displayValueSeparatorAttribute() ?>" id="x_v_06" name="x_v_06"<?php echo $ref->v_06->editAttributes() ?>>
		<?php echo $ref->v_06->selectOptionListHtml("x_v_06") ?>
	</select>
</div>
<?php echo $ref->v_06->Lookup->getParamTag("p_x_v_06") ?>
<?php echo $ref->v_06->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_07->Visible) { // v_07 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_07"><?php echo $ref->v_07->caption() ?><?php echo ($ref->v_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_07" data-value-separator="<?php echo $ref->v_07->displayValueSeparatorAttribute() ?>" id="x_v_07" name="x_v_07"<?php echo $ref->v_07->editAttributes() ?>>
		<?php echo $ref->v_07->selectOptionListHtml("x_v_07") ?>
	</select>
</div>
<?php echo $ref->v_07->Lookup->getParamTag("p_x_v_07") ?>
<?php echo $ref->v_07->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_08->Visible) { // v_08 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_08"><?php echo $ref->v_08->caption() ?><?php echo ($ref->v_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_08" data-value-separator="<?php echo $ref->v_08->displayValueSeparatorAttribute() ?>" id="x_v_08" name="x_v_08"<?php echo $ref->v_08->editAttributes() ?>>
		<?php echo $ref->v_08->selectOptionListHtml("x_v_08") ?>
	</select>
</div>
<?php echo $ref->v_08->Lookup->getParamTag("p_x_v_08") ?>
<?php echo $ref->v_08->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_09->Visible) { // v_09 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_09"><?php echo $ref->v_09->caption() ?><?php echo ($ref->v_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_09" data-value-separator="<?php echo $ref->v_09->displayValueSeparatorAttribute() ?>" id="x_v_09" name="x_v_09"<?php echo $ref->v_09->editAttributes() ?>>
		<?php echo $ref->v_09->selectOptionListHtml("x_v_09") ?>
	</select>
</div>
<?php echo $ref->v_09->Lookup->getParamTag("p_x_v_09") ?>
<?php echo $ref->v_09->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->v_10->Visible) { // v_10 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_v_10"><?php echo $ref->v_10->caption() ?><?php echo ($ref->v_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_10" data-value-separator="<?php echo $ref->v_10->displayValueSeparatorAttribute() ?>" id="x_v_10" name="x_v_10"<?php echo $ref->v_10->editAttributes() ?>>
		<?php echo $ref->v_10->selectOptionListHtml("x_v_10") ?>
	</select>
</div>
<?php echo $ref->v_10->Lookup->getParamTag("p_x_v_10") ?>
<?php echo $ref->v_10->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->cbm->Visible) { // cbm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_cbm"><?php echo $ref->cbm->caption() ?><?php echo ($ref->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_cbm" name="x_cbm" id="x_cbm" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->cbm->getPlaceHolder()) ?>" value="<?php echo $ref->cbm->EditValue ?>"<?php echo $ref->cbm->editAttributes() ?>>
<?php echo $ref->cbm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->sqm->Visible) { // sqm ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_sqm"><?php echo $ref->sqm->caption() ?><?php echo ($ref->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->sqm->getPlaceHolder()) ?>" value="<?php echo $ref->sqm->EditValue ?>"<?php echo $ref->sqm->editAttributes() ?>>
<?php echo $ref->sqm->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->shape->Visible) { // shape ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->shape->caption() ?><?php echo ($ref->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_shape" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_shape" data-value-separator="<?php echo $ref->shape->displayValueSeparatorAttribute() ?>" name="x_shape[]" id="x_shape[]" value="{value}"<?php echo $ref->shape->editAttributes() ?>></div>
<div id="dsl_x_shape" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->shape->checkBoxListHtml(FALSE, "x_shape[]") ?>
</div></div>
<?php echo $ref->shape->Lookup->getParamTag("p_x_shape") ?>
<?php echo $ref->shape->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->q_sku->Visible) { // q_sku ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_q_sku"><?php echo $ref->q_sku->caption() ?><?php echo ($ref->q_sku->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_q_sku" name="x_q_sku" id="x_q_sku" size="30" placeholder="<?php echo HtmlEncode($ref->q_sku->getPlaceHolder()) ?>" value="<?php echo $ref->q_sku->EditValue ?>"<?php echo $ref->q_sku->editAttributes() ?>>
<?php echo $ref->q_sku->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_01->Visible) { // b_01 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_b_01"><?php echo $ref->b_01->caption() ?><?php echo ($ref->b_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_b_01" name="x_b_01" id="x_b_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_01->getPlaceHolder()) ?>" value="<?php echo $ref->b_01->EditValue ?>"<?php echo $ref->b_01->editAttributes() ?>>
<?php echo $ref->b_01->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_02->Visible) { // b_02 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_b_02"><?php echo $ref->b_02->caption() ?><?php echo ($ref->b_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_b_02" name="x_b_02" id="x_b_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_02->getPlaceHolder()) ?>" value="<?php echo $ref->b_02->EditValue ?>"<?php echo $ref->b_02->editAttributes() ?>>
<?php echo $ref->b_02->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_03->Visible) { // b_03 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->b_03->caption() ?><?php echo ($ref->b_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_b_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_03" data-value-separator="<?php echo $ref->b_03->displayValueSeparatorAttribute() ?>" name="x_b_03[]" id="x_b_03[]" value="{value}"<?php echo $ref->b_03->editAttributes() ?>></div>
<div id="dsl_x_b_03" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_03->checkBoxListHtml(FALSE, "x_b_03[]") ?>
</div></div>
<?php echo $ref->b_03->Lookup->getParamTag("p_x_b_03") ?>
<?php echo $ref->b_03->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_04->Visible) { // b_04 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->b_04->caption() ?><?php echo ($ref->b_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_b_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_04" data-value-separator="<?php echo $ref->b_04->displayValueSeparatorAttribute() ?>" name="x_b_04[]" id="x_b_04[]" value="{value}"<?php echo $ref->b_04->editAttributes() ?>></div>
<div id="dsl_x_b_04" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref->b_04->checkBoxListHtml(FALSE, "x_b_04[]") ?>
</div></div>
<?php echo $ref->b_04->Lookup->getParamTag("p_x_b_04") ?>
<?php echo $ref->b_04->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_05->Visible) { // b_05 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->b_05->caption() ?><?php echo ($ref->b_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_b_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_05" data-value-separator="<?php echo $ref->b_05->displayValueSeparatorAttribute() ?>" name="x_b_05[]" id="x_b_05[]" value="{value}"<?php echo $ref->b_05->editAttributes() ?>></div>
<div id="dsl_x_b_05" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_05->checkBoxListHtml(FALSE, "x_b_05[]") ?>
</div></div>
<?php echo $ref->b_05->Lookup->getParamTag("p_x_b_05") ?>
<?php echo $ref->b_05->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_06->Visible) { // b_06 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->b_06->caption() ?><?php echo ($ref->b_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_b_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_06" data-value-separator="<?php echo $ref->b_06->displayValueSeparatorAttribute() ?>" name="x_b_06[]" id="x_b_06[]" value="{value}"<?php echo $ref->b_06->editAttributes() ?>></div>
<div id="dsl_x_b_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_06->checkBoxListHtml(FALSE, "x_b_06[]") ?>
</div></div>
<?php echo $ref->b_06->Lookup->getParamTag("p_x_b_06") ?>
<?php echo $ref->b_06->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_07->Visible) { // b_07 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->b_07->caption() ?><?php echo ($ref->b_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_b_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_07" data-value-separator="<?php echo $ref->b_07->displayValueSeparatorAttribute() ?>" name="x_b_07[]" id="x_b_07[]" value="{value}"<?php echo $ref->b_07->editAttributes() ?>></div>
<div id="dsl_x_b_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_07->checkBoxListHtml(FALSE, "x_b_07[]") ?>
</div></div>
<?php echo $ref->b_07->Lookup->getParamTag("p_x_b_07") ?>
<?php echo $ref->b_07->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_08->Visible) { // b_08 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->b_08->caption() ?><?php echo ($ref->b_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_b_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_08" data-value-separator="<?php echo $ref->b_08->displayValueSeparatorAttribute() ?>" name="x_b_08[]" id="x_b_08[]" value="{value}"<?php echo $ref->b_08->editAttributes() ?>></div>
<div id="dsl_x_b_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_08->checkBoxListHtml(FALSE, "x_b_08[]") ?>
</div></div>
<?php echo $ref->b_08->Lookup->getParamTag("p_x_b_08") ?>
<?php echo $ref->b_08->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_09->Visible) { // b_09 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->b_09->caption() ?><?php echo ($ref->b_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_b_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_09" data-value-separator="<?php echo $ref->b_09->displayValueSeparatorAttribute() ?>" name="x_b_09[]" id="x_b_09[]" value="{value}"<?php echo $ref->b_09->editAttributes() ?>></div>
<div id="dsl_x_b_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_09->checkBoxListHtml(FALSE, "x_b_09[]") ?>
</div></div>
<?php echo $ref->b_09->Lookup->getParamTag("p_x_b_09") ?>
<?php echo $ref->b_09->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_10->Visible) { // b_10 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->b_10->caption() ?><?php echo ($ref->b_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_b_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_10" data-value-separator="<?php echo $ref->b_10->displayValueSeparatorAttribute() ?>" name="x_b_10[]" id="x_b_10[]" value="{value}"<?php echo $ref->b_10->editAttributes() ?>></div>
<div id="dsl_x_b_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_10->checkBoxListHtml(FALSE, "x_b_10[]") ?>
</div></div>
<?php echo $ref->b_10->Lookup->getParamTag("p_x_b_10") ?>
<?php echo $ref->b_10->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_11->Visible) { // b_11 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_b_11"><?php echo $ref->b_11->caption() ?><?php echo ($ref->b_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_b_11" name="x_b_11" id="x_b_11" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_11->getPlaceHolder()) ?>" value="<?php echo $ref->b_11->EditValue ?>"<?php echo $ref->b_11->editAttributes() ?>>
<?php echo $ref->b_11->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_12->Visible) { // b_12 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_b_12"><?php echo $ref->b_12->caption() ?><?php echo ($ref->b_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_b_12" name="x_b_12" id="x_b_12" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_12->getPlaceHolder()) ?>" value="<?php echo $ref->b_12->EditValue ?>"<?php echo $ref->b_12->editAttributes() ?>>
<?php echo $ref->b_12->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_13->Visible) { // b_13 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_b_13"><?php echo $ref->b_13->caption() ?><?php echo ($ref->b_13->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_b_13" name="x_b_13" id="x_b_13" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_13->getPlaceHolder()) ?>" value="<?php echo $ref->b_13->EditValue ?>"<?php echo $ref->b_13->editAttributes() ?>>
<?php echo $ref->b_13->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_14->Visible) { // b_14 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_b_14"><?php echo $ref->b_14->caption() ?><?php echo ($ref->b_14->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_b_14" name="x_b_14" id="x_b_14" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_14->getPlaceHolder()) ?>" value="<?php echo $ref->b_14->EditValue ?>"<?php echo $ref->b_14->editAttributes() ?>>
<?php echo $ref->b_14->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->b_15->Visible) { // b_15 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_b_15"><?php echo $ref->b_15->caption() ?><?php echo ($ref->b_15->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_b_15" name="x_b_15" id="x_b_15" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_15->getPlaceHolder()) ?>" value="<?php echo $ref->b_15->EditValue ?>"<?php echo $ref->b_15->editAttributes() ?>>
<?php echo $ref->b_15->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_01->Visible) { // t_01 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_t_01"><?php echo $ref->t_01->caption() ?><?php echo ($ref->t_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_t_01" name="x_t_01" id="x_t_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_01->getPlaceHolder()) ?>" value="<?php echo $ref->t_01->EditValue ?>"<?php echo $ref->t_01->editAttributes() ?>>
<?php echo $ref->t_01->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_02->Visible) { // t_02 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_t_02"><?php echo $ref->t_02->caption() ?><?php echo ($ref->t_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_t_02" name="x_t_02" id="x_t_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_02->getPlaceHolder()) ?>" value="<?php echo $ref->t_02->EditValue ?>"<?php echo $ref->t_02->editAttributes() ?>>
<?php echo $ref->t_02->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_03->Visible) { // t_03 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_03->caption() ?><?php echo ($ref->t_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_t_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_03" data-value-separator="<?php echo $ref->t_03->displayValueSeparatorAttribute() ?>" name="x_t_03[]" id="x_t_03[]" value="{value}"<?php echo $ref->t_03->editAttributes() ?>></div>
<div id="dsl_x_t_03" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_03->checkBoxListHtml(FALSE, "x_t_03[]") ?>
</div></div>
<?php echo $ref->t_03->Lookup->getParamTag("p_x_t_03") ?>
<?php echo $ref->t_03->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_04->Visible) { // t_04 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_04->caption() ?><?php echo ($ref->t_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_t_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_04" data-value-separator="<?php echo $ref->t_04->displayValueSeparatorAttribute() ?>" name="x_t_04[]" id="x_t_04[]" value="{value}"<?php echo $ref->t_04->editAttributes() ?>></div>
<div id="dsl_x_t_04" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_04->checkBoxListHtml(FALSE, "x_t_04[]") ?>
</div></div>
<?php echo $ref->t_04->Lookup->getParamTag("p_x_t_04") ?>
<?php echo $ref->t_04->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_05->Visible) { // t_05 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_05->caption() ?><?php echo ($ref->t_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_t_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_05" data-value-separator="<?php echo $ref->t_05->displayValueSeparatorAttribute() ?>" name="x_t_05[]" id="x_t_05[]" value="{value}"<?php echo $ref->t_05->editAttributes() ?>></div>
<div id="dsl_x_t_05" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_05->checkBoxListHtml(FALSE, "x_t_05[]") ?>
</div></div>
<?php echo $ref->t_05->Lookup->getParamTag("p_x_t_05") ?>
<?php echo $ref->t_05->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_06->Visible) { // t_06 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_06->caption() ?><?php echo ($ref->t_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_t_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_06" data-value-separator="<?php echo $ref->t_06->displayValueSeparatorAttribute() ?>" name="x_t_06[]" id="x_t_06[]" value="{value}"<?php echo $ref->t_06->editAttributes() ?>></div>
<div id="dsl_x_t_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_06->checkBoxListHtml(FALSE, "x_t_06[]") ?>
</div></div>
<?php echo $ref->t_06->Lookup->getParamTag("p_x_t_06") ?>
<?php echo $ref->t_06->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_07->Visible) { // t_07 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_07->caption() ?><?php echo ($ref->t_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_t_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_07" data-value-separator="<?php echo $ref->t_07->displayValueSeparatorAttribute() ?>" name="x_t_07[]" id="x_t_07[]" value="{value}"<?php echo $ref->t_07->editAttributes() ?>></div>
<div id="dsl_x_t_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_07->checkBoxListHtml(FALSE, "x_t_07[]") ?>
</div></div>
<?php echo $ref->t_07->Lookup->getParamTag("p_x_t_07") ?>
<?php echo $ref->t_07->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_08->Visible) { // t_08 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_08->caption() ?><?php echo ($ref->t_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_t_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_08" data-value-separator="<?php echo $ref->t_08->displayValueSeparatorAttribute() ?>" name="x_t_08[]" id="x_t_08[]" value="{value}"<?php echo $ref->t_08->editAttributes() ?>></div>
<div id="dsl_x_t_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_08->checkBoxListHtml(FALSE, "x_t_08[]") ?>
</div></div>
<?php echo $ref->t_08->Lookup->getParamTag("p_x_t_08") ?>
<?php echo $ref->t_08->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_09->Visible) { // t_09 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_09->caption() ?><?php echo ($ref->t_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_t_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_09" data-value-separator="<?php echo $ref->t_09->displayValueSeparatorAttribute() ?>" name="x_t_09[]" id="x_t_09[]" value="{value}"<?php echo $ref->t_09->editAttributes() ?>></div>
<div id="dsl_x_t_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_09->checkBoxListHtml(FALSE, "x_t_09[]") ?>
</div></div>
<?php echo $ref->t_09->Lookup->getParamTag("p_x_t_09") ?>
<?php echo $ref->t_09->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_10->Visible) { // t_10 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_10->caption() ?><?php echo ($ref->t_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_t_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_10" data-value-separator="<?php echo $ref->t_10->displayValueSeparatorAttribute() ?>" name="x_t_10[]" id="x_t_10[]" value="{value}"<?php echo $ref->t_10->editAttributes() ?>></div>
<div id="dsl_x_t_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_10->checkBoxListHtml(FALSE, "x_t_10[]") ?>
</div></div>
<?php echo $ref->t_10->Lookup->getParamTag("p_x_t_10") ?>
<?php echo $ref->t_10->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_11->Visible) { // t_11 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_11->caption() ?><?php echo ($ref->t_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$ref->t_11->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref->t_11->EditAttrs["onchange"] = "";
?>
<span id="as_x_t_11" class="text-nowrap" style="z-index: 8410">
	<input type="text" class="form-control" name="sv_x_t_11" id="sv_x_t_11" value="<?php echo RemoveHtml($ref->t_11->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_11->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref->t_11->getPlaceHolder()) ?>"<?php echo $ref->t_11->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref" data-field="x_t_11" data-value-separator="<?php echo $ref->t_11->displayValueSeparatorAttribute() ?>" name="x_t_11" id="x_t_11" value="<?php echo HtmlEncode($ref->t_11->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
frefaddopt.createAutoSuggest({"id":"x_t_11","forceSelect":false});
</script>
<?php echo $ref->t_11->Lookup->getParamTag("p_x_t_11") ?>
<?php echo $ref->t_11->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_12->Visible) { // t_12 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->t_12->caption() ?><?php echo ($ref->t_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php
$wrkonchange = "" . trim(@$ref->t_12->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref->t_12->EditAttrs["onchange"] = "";
?>
<span id="as_x_t_12" class="text-nowrap" style="z-index: 8400">
	<input type="text" class="form-control" name="sv_x_t_12" id="sv_x_t_12" value="<?php echo RemoveHtml($ref->t_12->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_12->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref->t_12->getPlaceHolder()) ?>"<?php echo $ref->t_12->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref" data-field="x_t_12" data-value-separator="<?php echo $ref->t_12->displayValueSeparatorAttribute() ?>" name="x_t_12" id="x_t_12" value="<?php echo HtmlEncode($ref->t_12->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
frefaddopt.createAutoSuggest({"id":"x_t_12","forceSelect":false});
</script>
<?php echo $ref->t_12->Lookup->getParamTag("p_x_t_12") ?>
<?php echo $ref->t_12->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_13->Visible) { // t_13 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_t_13"><?php echo $ref->t_13->caption() ?><?php echo ($ref->t_13->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_t_13" name="x_t_13" id="x_t_13" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_13->getPlaceHolder()) ?>" value="<?php echo $ref->t_13->EditValue ?>"<?php echo $ref->t_13->editAttributes() ?>>
<?php echo $ref->t_13->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_14->Visible) { // t_14 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_t_14"><?php echo $ref->t_14->caption() ?><?php echo ($ref->t_14->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_t_14" name="x_t_14" id="x_t_14" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_14->getPlaceHolder()) ?>" value="<?php echo $ref->t_14->EditValue ?>"<?php echo $ref->t_14->editAttributes() ?>>
<?php echo $ref->t_14->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->t_15->Visible) { // t_15 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_t_15"><?php echo $ref->t_15->caption() ?><?php echo ($ref->t_15->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_t_15" name="x_t_15" id="x_t_15" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_15->getPlaceHolder()) ?>" value="<?php echo $ref->t_15->EditValue ?>"<?php echo $ref->t_15->editAttributes() ?>>
<?php echo $ref->t_15->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->d_head_01->Visible) { // d_head_01 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_d_head_01"><?php echo $ref->d_head_01->caption() ?><?php echo ($ref->d_head_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_d_head_01" name="x_d_head_01" id="x_d_head_01" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->d_head_01->getPlaceHolder()) ?>" value="<?php echo $ref->d_head_01->EditValue ?>"<?php echo $ref->d_head_01->editAttributes() ?>>
<?php echo $ref->d_head_01->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->d_description_01->Visible) { // d_description_01 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_d_description_01"><?php echo $ref->d_description_01->caption() ?><?php echo ($ref->d_description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="ref" data-field="x_d_description_01" name="x_d_description_01" id="x_d_description_01" cols="35" rows="4" placeholder="<?php echo HtmlEncode($ref->d_description_01->getPlaceHolder()) ?>"<?php echo $ref->d_description_01->editAttributes() ?>><?php echo $ref->d_description_01->EditValue ?></textarea>
<?php echo $ref->d_description_01->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->d_head_02->Visible) { // d_head_02 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_d_head_02"><?php echo $ref->d_head_02->caption() ?><?php echo ($ref->d_head_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_d_head_02" name="x_d_head_02" id="x_d_head_02" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->d_head_02->getPlaceHolder()) ?>" value="<?php echo $ref->d_head_02->EditValue ?>"<?php echo $ref->d_head_02->editAttributes() ?>>
<?php echo $ref->d_head_02->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->d_description_02->Visible) { // d_description_02 ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_d_description_02"><?php echo $ref->d_description_02->caption() ?><?php echo ($ref->d_description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="ref" data-field="x_d_description_02" name="x_d_description_02" id="x_d_description_02" cols="35" rows="4" placeholder="<?php echo HtmlEncode($ref->d_description_02->getPlaceHolder()) ?>"<?php echo $ref->d_description_02->editAttributes() ?>><?php echo $ref->d_description_02->EditValue ?></textarea>
<?php echo $ref->d_description_02->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->main_image->Visible) { // main_image ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->main_image->caption() ?><?php echo ($ref->main_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_main_image">
<span title="<?php echo $ref->main_image->title() ? $ref->main_image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->main_image->ReadOnly || $ref->main_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_main_image" name="x_main_image" id="x_main_image"<?php echo $ref->main_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_main_image" id= "fn_x_main_image" value="<?php echo $ref->main_image->Upload->FileName ?>">
<input type="hidden" name="fa_x_main_image" id= "fa_x_main_image" value="0">
<input type="hidden" name="fs_x_main_image" id= "fs_x_main_image" value="255">
<input type="hidden" name="fx_x_main_image" id= "fx_x_main_image" value="<?php echo $ref->main_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_main_image" id= "fm_x_main_image" value="<?php echo $ref->main_image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_main_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->main_image->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->top_view->Visible) { // top_view ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->top_view->caption() ?><?php echo ($ref->top_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_top_view">
<span title="<?php echo $ref->top_view->title() ? $ref->top_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->top_view->ReadOnly || $ref->top_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_top_view" name="x_top_view" id="x_top_view" multiple="multiple"<?php echo $ref->top_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_top_view" id= "fn_x_top_view" value="<?php echo $ref->top_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_top_view" id= "fa_x_top_view" value="0">
<input type="hidden" name="fs_x_top_view" id= "fs_x_top_view" value="255">
<input type="hidden" name="fx_x_top_view" id= "fx_x_top_view" value="<?php echo $ref->top_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_top_view" id= "fm_x_top_view" value="<?php echo $ref->top_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_top_view" id= "fc_x_top_view" value="<?php echo $ref->top_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_top_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->top_view->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->front_view->Visible) { // front_view ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->front_view->caption() ?><?php echo ($ref->front_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_front_view">
<span title="<?php echo $ref->front_view->title() ? $ref->front_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->front_view->ReadOnly || $ref->front_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_front_view" name="x_front_view" id="x_front_view" multiple="multiple"<?php echo $ref->front_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_front_view" id= "fn_x_front_view" value="<?php echo $ref->front_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_front_view" id= "fa_x_front_view" value="0">
<input type="hidden" name="fs_x_front_view" id= "fs_x_front_view" value="255">
<input type="hidden" name="fx_x_front_view" id= "fx_x_front_view" value="<?php echo $ref->front_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_front_view" id= "fm_x_front_view" value="<?php echo $ref->front_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_front_view" id= "fc_x_front_view" value="<?php echo $ref->front_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_front_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->front_view->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->corner_view->Visible) { // corner_view ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->corner_view->caption() ?><?php echo ($ref->corner_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_corner_view">
<span title="<?php echo $ref->corner_view->title() ? $ref->corner_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->corner_view->ReadOnly || $ref->corner_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_corner_view" name="x_corner_view" id="x_corner_view" multiple="multiple"<?php echo $ref->corner_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_corner_view" id= "fn_x_corner_view" value="<?php echo $ref->corner_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_corner_view" id= "fa_x_corner_view" value="0">
<input type="hidden" name="fs_x_corner_view" id= "fs_x_corner_view" value="255">
<input type="hidden" name="fx_x_corner_view" id= "fx_x_corner_view" value="<?php echo $ref->corner_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_corner_view" id= "fm_x_corner_view" value="<?php echo $ref->corner_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_corner_view" id= "fc_x_corner_view" value="<?php echo $ref->corner_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_corner_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->corner_view->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->back_view->Visible) { // back_view ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->back_view->caption() ?><?php echo ($ref->back_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_back_view">
<span title="<?php echo $ref->back_view->title() ? $ref->back_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->back_view->ReadOnly || $ref->back_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_back_view" name="x_back_view" id="x_back_view" multiple="multiple"<?php echo $ref->back_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_back_view" id= "fn_x_back_view" value="<?php echo $ref->back_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_back_view" id= "fa_x_back_view" value="0">
<input type="hidden" name="fs_x_back_view" id= "fs_x_back_view" value="255">
<input type="hidden" name="fx_x_back_view" id= "fx_x_back_view" value="<?php echo $ref->back_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_back_view" id= "fm_x_back_view" value="<?php echo $ref->back_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_back_view" id= "fc_x_back_view" value="<?php echo $ref->back_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_back_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->back_view->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->color_options->Visible) { // color_options ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->color_options->caption() ?><?php echo ($ref->color_options->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_color_options">
<span title="<?php echo $ref->color_options->title() ? $ref->color_options->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->color_options->ReadOnly || $ref->color_options->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_color_options" name="x_color_options" id="x_color_options" multiple="multiple"<?php echo $ref->color_options->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_color_options" id= "fn_x_color_options" value="<?php echo $ref->color_options->Upload->FileName ?>">
<input type="hidden" name="fa_x_color_options" id= "fa_x_color_options" value="0">
<input type="hidden" name="fs_x_color_options" id= "fs_x_color_options" value="255">
<input type="hidden" name="fx_x_color_options" id= "fx_x_color_options" value="<?php echo $ref->color_options->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_color_options" id= "fm_x_color_options" value="<?php echo $ref->color_options->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_color_options" id= "fc_x_color_options" value="<?php echo $ref->color_options->UploadMaxFileCount ?>">
</div>
<table id="ft_x_color_options" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->color_options->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->other_options->Visible) { // other_options ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->other_options->caption() ?><?php echo ($ref->other_options->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_other_options">
<span title="<?php echo $ref->other_options->title() ? $ref->other_options->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->other_options->ReadOnly || $ref->other_options->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_other_options" name="x_other_options" id="x_other_options" multiple="multiple"<?php echo $ref->other_options->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_other_options" id= "fn_x_other_options" value="<?php echo $ref->other_options->Upload->FileName ?>">
<input type="hidden" name="fa_x_other_options" id= "fa_x_other_options" value="0">
<input type="hidden" name="fs_x_other_options" id= "fs_x_other_options" value="255">
<input type="hidden" name="fx_x_other_options" id= "fx_x_other_options" value="<?php echo $ref->other_options->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_other_options" id= "fm_x_other_options" value="<?php echo $ref->other_options->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_other_options" id= "fc_x_other_options" value="<?php echo $ref->other_options->UploadMaxFileCount ?>">
</div>
<table id="ft_x_other_options" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->other_options->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->group_image->Visible) { // group_image ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->group_image->caption() ?><?php echo ($ref->group_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_group_image">
<span title="<?php echo $ref->group_image->title() ? $ref->group_image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->group_image->ReadOnly || $ref->group_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_group_image" name="x_group_image" id="x_group_image"<?php echo $ref->group_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_group_image" id= "fn_x_group_image" value="<?php echo $ref->group_image->Upload->FileName ?>">
<input type="hidden" name="fa_x_group_image" id= "fa_x_group_image" value="0">
<input type="hidden" name="fs_x_group_image" id= "fs_x_group_image" value="196">
<input type="hidden" name="fx_x_group_image" id= "fx_x_group_image" value="<?php echo $ref->group_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_group_image" id= "fm_x_group_image" value="<?php echo $ref->group_image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_group_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->group_image->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->video_url->Visible) { // video_url ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_video_url"><?php echo $ref->video_url->caption() ?><?php echo ($ref->video_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_video_url" name="x_video_url" id="x_video_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($ref->video_url->getPlaceHolder()) ?>" value="<?php echo $ref->video_url->EditValue ?>"<?php echo $ref->video_url->editAttributes() ?>>
<?php echo $ref->video_url->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->image->Visible) { // image ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $ref->image->caption() ?><?php echo ($ref->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_image">
<span title="<?php echo $ref->image->title() ? $ref->image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->image->ReadOnly || $ref->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_image" name="x_image" id="x_image" multiple="multiple"<?php echo $ref->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $ref->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="255">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $ref->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $ref->image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_image" id= "fc_x_image" value="<?php echo $ref->image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $ref->image->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->last_price->Visible) { // last_price ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_last_price"><?php echo $ref->last_price->caption() ?><?php echo ($ref->last_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_last_price" name="x_last_price" id="x_last_price" size="30" placeholder="<?php echo HtmlEncode($ref->last_price->getPlaceHolder()) ?>" value="<?php echo $ref->last_price->EditValue ?>"<?php echo $ref->last_price->editAttributes() ?>>
<?php echo $ref->last_price->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->currency->Visible) { // currency ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_currency"><?php echo $ref->currency->caption() ?><?php echo ($ref->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_currency" data-value-separator="<?php echo $ref->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $ref->currency->editAttributes() ?>>
		<?php echo $ref->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $ref->currency->Lookup->getParamTag("p_x_currency") ?>
<?php echo $ref->currency->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->hsn->Visible) { // hsn ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_hsn"><?php echo $ref->hsn->caption() ?><?php echo ($ref->hsn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_hsn" data-value-separator="<?php echo $ref->hsn->displayValueSeparatorAttribute() ?>" id="x_hsn" name="x_hsn"<?php echo $ref->hsn->editAttributes() ?>>
		<?php echo $ref->hsn->selectOptionListHtml("x_hsn") ?>
	</select>
</div>
<?php echo $ref->hsn->Lookup->getParamTag("p_x_hsn") ?>
<?php echo $ref->hsn->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->composition->Visible) { // composition ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_composition"><?php echo $ref->composition->caption() ?><?php echo ($ref->composition->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_composition" data-value-separator="<?php echo $ref->composition->displayValueSeparatorAttribute() ?>" id="x_composition" name="x_composition"<?php echo $ref->composition->editAttributes() ?>>
		<?php echo $ref->composition->selectOptionListHtml("x_composition") ?>
	</select>
</div>
<?php echo $ref->composition->Lookup->getParamTag("p_x_composition") ?>
<?php echo $ref->composition->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->category->Visible) { // category ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_category"><?php echo $ref->category->caption() ?><?php echo ($ref->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_category" data-value-separator="<?php echo $ref->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $ref->category->editAttributes() ?>>
		<?php echo $ref->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $ref->category->Lookup->getParamTag("p_x_category") ?>
<?php echo $ref->category->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->moq->Visible) { // moq ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_moq"><?php echo $ref->moq->caption() ?><?php echo ($ref->moq->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_moq" name="x_moq" id="x_moq" size="30" placeholder="<?php echo HtmlEncode($ref->moq->getPlaceHolder()) ?>" value="<?php echo $ref->moq->EditValue ?>"<?php echo $ref->moq->editAttributes() ?>>
<?php echo $ref->moq->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->in->Visible) { // in ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_in"><?php echo $ref->in->caption() ?><?php echo ($ref->in->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_in" name="x_in" id="x_in" size="30" placeholder="<?php echo HtmlEncode($ref->in->getPlaceHolder()) ?>" value="<?php echo $ref->in->EditValue ?>"<?php echo $ref->in->editAttributes() ?>>
<?php echo $ref->in->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->out->Visible) { // out ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_out"><?php echo $ref->out->caption() ?><?php echo ($ref->out->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_out" name="x_out" id="x_out" size="30" placeholder="<?php echo HtmlEncode($ref->out->getPlaceHolder()) ?>" value="<?php echo $ref->out->EditValue ?>"<?php echo $ref->out->editAttributes() ?>>
<?php echo $ref->out->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->required->Visible) { // required ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_required"><?php echo $ref->required->caption() ?><?php echo ($ref->required->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_required" name="x_required" id="x_required" size="30" placeholder="<?php echo HtmlEncode($ref->required->getPlaceHolder()) ?>" value="<?php echo $ref->required->EditValue ?>"<?php echo $ref->required->editAttributes() ?>>
<?php echo $ref->required->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->blocked->Visible) { // blocked ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_blocked"><?php echo $ref->blocked->caption() ?><?php echo ($ref->blocked->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_blocked" name="x_blocked" id="x_blocked" size="30" placeholder="<?php echo HtmlEncode($ref->blocked->getPlaceHolder()) ?>" value="<?php echo $ref->blocked->EditValue ?>"<?php echo $ref->blocked->editAttributes() ?>>
<?php echo $ref->blocked->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->ordered->Visible) { // ordered ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_ordered"><?php echo $ref->ordered->caption() ?><?php echo ($ref->ordered->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_ordered" name="x_ordered" id="x_ordered" size="30" placeholder="<?php echo HtmlEncode($ref->ordered->getPlaceHolder()) ?>" value="<?php echo $ref->ordered->EditValue ?>"<?php echo $ref->ordered->editAttributes() ?>>
<?php echo $ref->ordered->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $ref->status->caption() ?><?php echo ($ref->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_status" data-value-separator="<?php echo $ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ref->status->editAttributes() ?>>
		<?php echo $ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $ref->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->publish->Visible) { // publish ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_publish"><?php echo $ref->publish->caption() ?><?php echo ($ref->publish->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_publish" data-value-separator="<?php echo $ref->publish->displayValueSeparatorAttribute() ?>" id="x_publish" name="x_publish"<?php echo $ref->publish->editAttributes() ?>>
		<?php echo $ref->publish->selectOptionListHtml("x_publish") ?>
	</select>
</div>
<?php echo $ref->publish->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->keywords->Visible) { // keywords ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_keywords"><?php echo $ref->keywords->caption() ?><?php echo ($ref->keywords->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="ref" data-field="x_keywords" name="x_keywords" id="x_keywords" cols="35" rows="3" placeholder="<?php echo HtmlEncode($ref->keywords->getPlaceHolder()) ?>"<?php echo $ref->keywords->editAttributes() ?>><?php echo $ref->keywords->EditValue ?></textarea>
<?php echo $ref->keywords->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->operator->Visible) { // operator ?>
	<input type="hidden" data-table="ref" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($ref->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($ref->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="ref" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($ref->datetime->CurrentValue) ?>">
	<?php if (!$ref->datetime->ReadOnly && !$ref->datetime->Disabled && !isset($ref->datetime->EditAttrs["readonly"]) && !isset($ref->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("frefaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($ref->supplier->Visible) { // supplier ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_supplier"><?php echo $ref->supplier->caption() ?><?php echo ($ref->supplier->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_supplier" name="x_supplier" id="x_supplier" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($ref->supplier->getPlaceHolder()) ?>" value="<?php echo $ref->supplier->EditValue ?>"<?php echo $ref->supplier->editAttributes() ?>>
<?php echo $ref->supplier->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->country->Visible) { // country ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_country"><?php echo $ref->country->caption() ?><?php echo ($ref->country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_country" name="x_country" id="x_country" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($ref->country->getPlaceHolder()) ?>" value="<?php echo $ref->country->EditValue ?>"<?php echo $ref->country->editAttributes() ?>>
<?php echo $ref->country->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($ref->minimum_stock->Visible) { // minimum_stock ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_minimum_stock"><?php echo $ref->minimum_stock->caption() ?><?php echo ($ref->minimum_stock->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="ref" data-field="x_minimum_stock" name="x_minimum_stock" id="x_minimum_stock" size="30" placeholder="<?php echo HtmlEncode($ref->minimum_stock->getPlaceHolder()) ?>" value="<?php echo $ref->minimum_stock->EditValue ?>"<?php echo $ref->minimum_stock->editAttributes() ?>>
<?php echo $ref->minimum_stock->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$ref_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$ref_addopt->terminate();
?>