<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_delete = new ref_delete();

// Run the page
$ref_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var frefdelete = currentForm = new ew.Form("frefdelete", "delete");

// Form_CustomValidate event
frefdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frefdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frefdelete.lists["x_grp"] = <?php echo $ref_delete->grp->Lookup->toClientList() ?>;
frefdelete.lists["x_grp"].options = <?php echo JsonEncode($ref_delete->grp->lookupOptions()) ?>;
frefdelete.lists["x_s_grp"] = <?php echo $ref_delete->s_grp->Lookup->toClientList() ?>;
frefdelete.lists["x_s_grp"].options = <?php echo JsonEncode($ref_delete->s_grp->lookupOptions()) ?>;
frefdelete.lists["x_product"] = <?php echo $ref_delete->product->Lookup->toClientList() ?>;
frefdelete.lists["x_product"].options = <?php echo JsonEncode($ref_delete->product->lookupOptions()) ?>;
frefdelete.lists["x_packing_type"] = <?php echo $ref_delete->packing_type->Lookup->toClientList() ?>;
frefdelete.lists["x_packing_type"].options = <?php echo JsonEncode($ref_delete->packing_type->lookupOptions()) ?>;
frefdelete.lists["x_product_code_type"] = <?php echo $ref_delete->product_code_type->Lookup->toClientList() ?>;
frefdelete.lists["x_product_code_type"].options = <?php echo JsonEncode($ref_delete->product_code_type->options(FALSE, TRUE)) ?>;
frefdelete.lists["x_composition"] = <?php echo $ref_delete->composition->Lookup->toClientList() ?>;
frefdelete.lists["x_composition"].options = <?php echo JsonEncode($ref_delete->composition->lookupOptions()) ?>;
frefdelete.lists["x_category"] = <?php echo $ref_delete->category->Lookup->toClientList() ?>;
frefdelete.lists["x_category"].options = <?php echo JsonEncode($ref_delete->category->lookupOptions()) ?>;
frefdelete.lists["x_status"] = <?php echo $ref_delete->status->Lookup->toClientList() ?>;
frefdelete.lists["x_status"].options = <?php echo JsonEncode($ref_delete->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_delete->showPageHeader(); ?>
<?php
$ref_delete->showMessage();
?>
<form name="frefdelete" id="frefdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($ref_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($ref->id->Visible) { // id ?>
		<th class="<?php echo $ref->id->headerCellClass() ?>"><span id="elh_ref_id" class="ref_id"><?php echo $ref->id->caption() ?></span></th>
<?php } ?>
<?php if ($ref->grp->Visible) { // grp ?>
		<th class="<?php echo $ref->grp->headerCellClass() ?>"><span id="elh_ref_grp" class="ref_grp"><?php echo $ref->grp->caption() ?></span></th>
<?php } ?>
<?php if ($ref->s_grp->Visible) { // s_grp ?>
		<th class="<?php echo $ref->s_grp->headerCellClass() ?>"><span id="elh_ref_s_grp" class="ref_s_grp"><?php echo $ref->s_grp->caption() ?></span></th>
<?php } ?>
<?php if ($ref->product->Visible) { // product ?>
		<th class="<?php echo $ref->product->headerCellClass() ?>"><span id="elh_ref_product" class="ref_product"><?php echo $ref->product->caption() ?></span></th>
<?php } ?>
<?php if ($ref->packing_type->Visible) { // packing_type ?>
		<th class="<?php echo $ref->packing_type->headerCellClass() ?>"><span id="elh_ref_packing_type" class="ref_packing_type"><?php echo $ref->packing_type->caption() ?></span></th>
<?php } ?>
<?php if ($ref->product_n->Visible) { // product_n ?>
		<th class="<?php echo $ref->product_n->headerCellClass() ?>"><span id="elh_ref_product_n" class="ref_product_n"><?php echo $ref->product_n->caption() ?></span></th>
<?php } ?>
<?php if ($ref->product_code_type->Visible) { // product_code_type ?>
		<th class="<?php echo $ref->product_code_type->headerCellClass() ?>"><span id="elh_ref_product_code_type" class="ref_product_code_type"><?php echo $ref->product_code_type->caption() ?></span></th>
<?php } ?>
<?php if ($ref->product_code->Visible) { // product_code ?>
		<th class="<?php echo $ref->product_code->headerCellClass() ?>"><span id="elh_ref_product_code" class="ref_product_code"><?php echo $ref->product_code->caption() ?></span></th>
<?php } ?>
<?php if ($ref->v_00->Visible) { // v_00 ?>
		<th class="<?php echo $ref->v_00->headerCellClass() ?>"><span id="elh_ref_v_00" class="ref_v_00"><?php echo $ref->v_00->caption() ?></span></th>
<?php } ?>
<?php if ($ref->q_sku->Visible) { // q_sku ?>
		<th class="<?php echo $ref->q_sku->headerCellClass() ?>"><span id="elh_ref_q_sku" class="ref_q_sku"><?php echo $ref->q_sku->caption() ?></span></th>
<?php } ?>
<?php if ($ref->group_image->Visible) { // group_image ?>
		<th class="<?php echo $ref->group_image->headerCellClass() ?>"><span id="elh_ref_group_image" class="ref_group_image"><?php echo $ref->group_image->caption() ?></span></th>
<?php } ?>
<?php if ($ref->composition->Visible) { // composition ?>
		<th class="<?php echo $ref->composition->headerCellClass() ?>"><span id="elh_ref_composition" class="ref_composition"><?php echo $ref->composition->caption() ?></span></th>
<?php } ?>
<?php if ($ref->category->Visible) { // category ?>
		<th class="<?php echo $ref->category->headerCellClass() ?>"><span id="elh_ref_category" class="ref_category"><?php echo $ref->category->caption() ?></span></th>
<?php } ?>
<?php if ($ref->status->Visible) { // status ?>
		<th class="<?php echo $ref->status->headerCellClass() ?>"><span id="elh_ref_status" class="ref_status"><?php echo $ref->status->caption() ?></span></th>
<?php } ?>
<?php if ($ref->keywords->Visible) { // keywords ?>
		<th class="<?php echo $ref->keywords->headerCellClass() ?>"><span id="elh_ref_keywords" class="ref_keywords"><?php echo $ref->keywords->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$ref_delete->RecCnt = 0;
$i = 0;
while (!$ref_delete->Recordset->EOF) {
	$ref_delete->RecCnt++;
	$ref_delete->RowCnt++;

	// Set row properties
	$ref->resetAttributes();
	$ref->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$ref_delete->loadRowValues($ref_delete->Recordset);

	// Render row
	$ref_delete->renderRow();
?>
	<tr<?php echo $ref->rowAttributes() ?>>
<?php if ($ref->id->Visible) { // id ?>
		<td<?php echo $ref->id->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_id" class="ref_id">
<span<?php echo $ref->id->viewAttributes() ?>>
<?php echo $ref->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->grp->Visible) { // grp ?>
		<td<?php echo $ref->grp->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_grp" class="ref_grp">
<span<?php echo $ref->grp->viewAttributes() ?>>
<?php echo $ref->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->s_grp->Visible) { // s_grp ?>
		<td<?php echo $ref->s_grp->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_s_grp" class="ref_s_grp">
<span<?php echo $ref->s_grp->viewAttributes() ?>>
<?php echo $ref->s_grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->product->Visible) { // product ?>
		<td<?php echo $ref->product->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_product" class="ref_product">
<span<?php echo $ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref->product->getViewValue())) && $ref->product->linkAttributes() <> "") { ?>
<a<?php echo $ref->product->linkAttributes() ?>><?php echo $ref->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($ref->packing_type->Visible) { // packing_type ?>
		<td<?php echo $ref->packing_type->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_packing_type" class="ref_packing_type">
<span<?php echo $ref->packing_type->viewAttributes() ?>>
<?php echo $ref->packing_type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->product_n->Visible) { // product_n ?>
		<td<?php echo $ref->product_n->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_product_n" class="ref_product_n">
<span<?php echo $ref->product_n->viewAttributes() ?>>
<?php echo $ref->product_n->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->product_code_type->Visible) { // product_code_type ?>
		<td<?php echo $ref->product_code_type->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_product_code_type" class="ref_product_code_type">
<span<?php echo $ref->product_code_type->viewAttributes() ?>>
<?php echo $ref->product_code_type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->product_code->Visible) { // product_code ?>
		<td<?php echo $ref->product_code->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_product_code" class="ref_product_code">
<span<?php echo $ref->product_code->viewAttributes() ?>>
<?php echo $ref->product_code->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->v_00->Visible) { // v_00 ?>
		<td<?php echo $ref->v_00->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_v_00" class="ref_v_00">
<span<?php echo $ref->v_00->viewAttributes() ?>>
<?php echo $ref->v_00->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->q_sku->Visible) { // q_sku ?>
		<td<?php echo $ref->q_sku->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_q_sku" class="ref_q_sku">
<span<?php echo $ref->q_sku->viewAttributes() ?>>
<?php echo $ref->q_sku->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->group_image->Visible) { // group_image ?>
		<td<?php echo $ref->group_image->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_group_image" class="ref_group_image">
<span<?php echo $ref->group_image->viewAttributes() ?>>
<?php echo GetFileViewTag($ref->group_image, $ref->group_image->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($ref->composition->Visible) { // composition ?>
		<td<?php echo $ref->composition->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_composition" class="ref_composition">
<span<?php echo $ref->composition->viewAttributes() ?>>
<?php echo $ref->composition->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->category->Visible) { // category ?>
		<td<?php echo $ref->category->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_category" class="ref_category">
<span<?php echo $ref->category->viewAttributes() ?>>
<?php echo $ref->category->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->status->Visible) { // status ?>
		<td<?php echo $ref->status->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_status" class="ref_status">
<span<?php echo $ref->status->viewAttributes() ?>>
<?php echo $ref->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($ref->keywords->Visible) { // keywords ?>
		<td<?php echo $ref->keywords->cellAttributes() ?>>
<span id="el<?php echo $ref_delete->RowCnt ?>_ref_keywords" class="ref_keywords">
<span<?php echo $ref->keywords->viewAttributes() ?>>
<?php echo $ref->keywords->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$ref_delete->Recordset->moveNext();
}
$ref_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ref_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$ref_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ref_delete->terminate();
?>