<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_edit = new ref_edit();

// Run the page
$ref_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var frefedit = currentForm = new ew.Form("frefedit", "edit");

// Validate form
frefedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ref_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->id->caption(), $ref->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->company_id->caption(), $ref->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->grp->caption(), $ref->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->s_grp->caption(), $ref->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product->caption(), $ref->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product_type->caption(), $ref->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->packing_type->caption(), $ref->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->product_n->Required) { ?>
			elm = this.getElements("x" + infix + "_product_n");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product_n->caption(), $ref->product_n->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->_barcode->caption(), $ref->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->product_code_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product_code_type->caption(), $ref->product_code_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->product_code->Required) { ?>
			elm = this.getElements("x" + infix + "_product_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->product_code->caption(), $ref->product_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->set_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_set_ref[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->set_ref->caption(), $ref->set_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_00->Required) { ?>
			elm = this.getElements("x" + infix + "_v_00");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_00->caption(), $ref->v_00->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_01->Required) { ?>
			elm = this.getElements("x" + infix + "_v_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_01->caption(), $ref->v_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_02->Required) { ?>
			elm = this.getElements("x" + infix + "_v_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_02->caption(), $ref->v_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_03->Required) { ?>
			elm = this.getElements("x" + infix + "_v_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_03->caption(), $ref->v_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_04->Required) { ?>
			elm = this.getElements("x" + infix + "_v_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_04->caption(), $ref->v_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_05->Required) { ?>
			elm = this.getElements("x" + infix + "_v_05");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_05->caption(), $ref->v_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_06->Required) { ?>
			elm = this.getElements("x" + infix + "_v_06");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_06->caption(), $ref->v_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_07->Required) { ?>
			elm = this.getElements("x" + infix + "_v_07");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_07->caption(), $ref->v_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_08->Required) { ?>
			elm = this.getElements("x" + infix + "_v_08");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_08->caption(), $ref->v_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_09->Required) { ?>
			elm = this.getElements("x" + infix + "_v_09");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_09->caption(), $ref->v_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->v_10->Required) { ?>
			elm = this.getElements("x" + infix + "_v_10");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->v_10->caption(), $ref->v_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->cbm->caption(), $ref->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->sqm->caption(), $ref->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->shape->caption(), $ref->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->q_sku->Required) { ?>
			elm = this.getElements("x" + infix + "_q_sku");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->q_sku->caption(), $ref->q_sku->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_q_sku");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->q_sku->errorMessage()) ?>");
		<?php if ($ref_edit->b_01->Required) { ?>
			elm = this.getElements("x" + infix + "_b_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_01->caption(), $ref->b_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_02->Required) { ?>
			elm = this.getElements("x" + infix + "_b_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_02->caption(), $ref->b_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_03->Required) { ?>
			elm = this.getElements("x" + infix + "_b_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_03->caption(), $ref->b_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_04->Required) { ?>
			elm = this.getElements("x" + infix + "_b_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_04->caption(), $ref->b_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_05->Required) { ?>
			elm = this.getElements("x" + infix + "_b_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_05->caption(), $ref->b_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_06->Required) { ?>
			elm = this.getElements("x" + infix + "_b_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_06->caption(), $ref->b_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_07->Required) { ?>
			elm = this.getElements("x" + infix + "_b_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_07->caption(), $ref->b_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_08->Required) { ?>
			elm = this.getElements("x" + infix + "_b_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_08->caption(), $ref->b_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_09->Required) { ?>
			elm = this.getElements("x" + infix + "_b_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_09->caption(), $ref->b_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_10->Required) { ?>
			elm = this.getElements("x" + infix + "_b_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_10->caption(), $ref->b_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_11->Required) { ?>
			elm = this.getElements("x" + infix + "_b_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_11->caption(), $ref->b_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_12->Required) { ?>
			elm = this.getElements("x" + infix + "_b_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_12->caption(), $ref->b_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_13->Required) { ?>
			elm = this.getElements("x" + infix + "_b_13");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_13->caption(), $ref->b_13->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_14->Required) { ?>
			elm = this.getElements("x" + infix + "_b_14");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_14->caption(), $ref->b_14->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->b_15->Required) { ?>
			elm = this.getElements("x" + infix + "_b_15");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->b_15->caption(), $ref->b_15->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_01->Required) { ?>
			elm = this.getElements("x" + infix + "_t_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_01->caption(), $ref->t_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_02->Required) { ?>
			elm = this.getElements("x" + infix + "_t_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_02->caption(), $ref->t_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_03->Required) { ?>
			elm = this.getElements("x" + infix + "_t_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_03->caption(), $ref->t_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_04->Required) { ?>
			elm = this.getElements("x" + infix + "_t_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_04->caption(), $ref->t_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_05->Required) { ?>
			elm = this.getElements("x" + infix + "_t_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_05->caption(), $ref->t_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_06->Required) { ?>
			elm = this.getElements("x" + infix + "_t_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_06->caption(), $ref->t_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_07->Required) { ?>
			elm = this.getElements("x" + infix + "_t_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_07->caption(), $ref->t_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_08->Required) { ?>
			elm = this.getElements("x" + infix + "_t_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_08->caption(), $ref->t_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_09->Required) { ?>
			elm = this.getElements("x" + infix + "_t_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_09->caption(), $ref->t_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_10->Required) { ?>
			elm = this.getElements("x" + infix + "_t_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_10->caption(), $ref->t_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_11->Required) { ?>
			elm = this.getElements("x" + infix + "_t_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_11->caption(), $ref->t_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_12->Required) { ?>
			elm = this.getElements("x" + infix + "_t_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_12->caption(), $ref->t_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_13->Required) { ?>
			elm = this.getElements("x" + infix + "_t_13");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_13->caption(), $ref->t_13->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_14->Required) { ?>
			elm = this.getElements("x" + infix + "_t_14");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_14->caption(), $ref->t_14->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->t_15->Required) { ?>
			elm = this.getElements("x" + infix + "_t_15");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->t_15->caption(), $ref->t_15->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->d_head_01->Required) { ?>
			elm = this.getElements("x" + infix + "_d_head_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->d_head_01->caption(), $ref->d_head_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->d_description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_d_description_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->d_description_01->caption(), $ref->d_description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->d_head_02->Required) { ?>
			elm = this.getElements("x" + infix + "_d_head_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->d_head_02->caption(), $ref->d_head_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->d_description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_d_description_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->d_description_02->caption(), $ref->d_description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->main_image->Required) { ?>
			felm = this.getElements("x" + infix + "_main_image");
			elm = this.getElements("fn_x" + infix + "_main_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->main_image->caption(), $ref->main_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->top_view->Required) { ?>
			felm = this.getElements("x" + infix + "_top_view");
			elm = this.getElements("fn_x" + infix + "_top_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->top_view->caption(), $ref->top_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->front_view->Required) { ?>
			felm = this.getElements("x" + infix + "_front_view");
			elm = this.getElements("fn_x" + infix + "_front_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->front_view->caption(), $ref->front_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->corner_view->Required) { ?>
			felm = this.getElements("x" + infix + "_corner_view");
			elm = this.getElements("fn_x" + infix + "_corner_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->corner_view->caption(), $ref->corner_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->back_view->Required) { ?>
			felm = this.getElements("x" + infix + "_back_view");
			elm = this.getElements("fn_x" + infix + "_back_view");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->back_view->caption(), $ref->back_view->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->color_options->Required) { ?>
			felm = this.getElements("x" + infix + "_color_options");
			elm = this.getElements("fn_x" + infix + "_color_options");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->color_options->caption(), $ref->color_options->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->other_options->Required) { ?>
			felm = this.getElements("x" + infix + "_other_options");
			elm = this.getElements("fn_x" + infix + "_other_options");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->other_options->caption(), $ref->other_options->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->group_image->Required) { ?>
			felm = this.getElements("x" + infix + "_group_image");
			elm = this.getElements("fn_x" + infix + "_group_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->group_image->caption(), $ref->group_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->video_url->Required) { ?>
			elm = this.getElements("x" + infix + "_video_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->video_url->caption(), $ref->video_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $ref->image->caption(), $ref->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->last_price->Required) { ?>
			elm = this.getElements("x" + infix + "_last_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->last_price->caption(), $ref->last_price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->currency->Required) { ?>
			elm = this.getElements("x" + infix + "_currency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->currency->caption(), $ref->currency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->hsn->Required) { ?>
			elm = this.getElements("x" + infix + "_hsn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->hsn->caption(), $ref->hsn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->composition->Required) { ?>
			elm = this.getElements("x" + infix + "_composition");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->composition->caption(), $ref->composition->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->category->caption(), $ref->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->moq->Required) { ?>
			elm = this.getElements("x" + infix + "_moq");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->moq->caption(), $ref->moq->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_moq");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ref->moq->errorMessage()) ?>");
		<?php if ($ref_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->status->caption(), $ref->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->publish->Required) { ?>
			elm = this.getElements("x" + infix + "_publish");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->publish->caption(), $ref->publish->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->keywords->Required) { ?>
			elm = this.getElements("x" + infix + "_keywords");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->keywords->caption(), $ref->keywords->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->operator->caption(), $ref->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ref_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ref->datetime->caption(), $ref->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
frefedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frefedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
frefedit.multiPage = new ew.MultiPage("frefedit");

// Dynamic selection lists
frefedit.lists["x_company_id[]"] = <?php echo $ref_edit->company_id->Lookup->toClientList() ?>;
frefedit.lists["x_company_id[]"].options = <?php echo JsonEncode($ref_edit->company_id->lookupOptions()) ?>;
frefedit.lists["x_grp"] = <?php echo $ref_edit->grp->Lookup->toClientList() ?>;
frefedit.lists["x_grp"].options = <?php echo JsonEncode($ref_edit->grp->lookupOptions()) ?>;
frefedit.lists["x_s_grp"] = <?php echo $ref_edit->s_grp->Lookup->toClientList() ?>;
frefedit.lists["x_s_grp"].options = <?php echo JsonEncode($ref_edit->s_grp->lookupOptions()) ?>;
frefedit.lists["x_product"] = <?php echo $ref_edit->product->Lookup->toClientList() ?>;
frefedit.lists["x_product"].options = <?php echo JsonEncode($ref_edit->product->lookupOptions()) ?>;
frefedit.lists["x_product_type"] = <?php echo $ref_edit->product_type->Lookup->toClientList() ?>;
frefedit.lists["x_product_type"].options = <?php echo JsonEncode($ref_edit->product_type->lookupOptions()) ?>;
frefedit.lists["x_packing_type"] = <?php echo $ref_edit->packing_type->Lookup->toClientList() ?>;
frefedit.lists["x_packing_type"].options = <?php echo JsonEncode($ref_edit->packing_type->lookupOptions()) ?>;
frefedit.lists["x_product_code_type"] = <?php echo $ref_edit->product_code_type->Lookup->toClientList() ?>;
frefedit.lists["x_product_code_type"].options = <?php echo JsonEncode($ref_edit->product_code_type->options(FALSE, TRUE)) ?>;
frefedit.lists["x_set_ref[]"] = <?php echo $ref_edit->set_ref->Lookup->toClientList() ?>;
frefedit.lists["x_set_ref[]"].options = <?php echo JsonEncode($ref_edit->set_ref->lookupOptions()) ?>;
frefedit.lists["x_v_01"] = <?php echo $ref_edit->v_01->Lookup->toClientList() ?>;
frefedit.lists["x_v_01"].options = <?php echo JsonEncode($ref_edit->v_01->lookupOptions()) ?>;
frefedit.lists["x_v_02"] = <?php echo $ref_edit->v_02->Lookup->toClientList() ?>;
frefedit.lists["x_v_02"].options = <?php echo JsonEncode($ref_edit->v_02->lookupOptions()) ?>;
frefedit.lists["x_v_03"] = <?php echo $ref_edit->v_03->Lookup->toClientList() ?>;
frefedit.lists["x_v_03"].options = <?php echo JsonEncode($ref_edit->v_03->lookupOptions()) ?>;
frefedit.lists["x_v_04"] = <?php echo $ref_edit->v_04->Lookup->toClientList() ?>;
frefedit.lists["x_v_04"].options = <?php echo JsonEncode($ref_edit->v_04->lookupOptions()) ?>;
frefedit.lists["x_v_05"] = <?php echo $ref_edit->v_05->Lookup->toClientList() ?>;
frefedit.lists["x_v_05"].options = <?php echo JsonEncode($ref_edit->v_05->lookupOptions()) ?>;
frefedit.lists["x_v_06"] = <?php echo $ref_edit->v_06->Lookup->toClientList() ?>;
frefedit.lists["x_v_06"].options = <?php echo JsonEncode($ref_edit->v_06->lookupOptions()) ?>;
frefedit.lists["x_v_07"] = <?php echo $ref_edit->v_07->Lookup->toClientList() ?>;
frefedit.lists["x_v_07"].options = <?php echo JsonEncode($ref_edit->v_07->lookupOptions()) ?>;
frefedit.lists["x_v_08"] = <?php echo $ref_edit->v_08->Lookup->toClientList() ?>;
frefedit.lists["x_v_08"].options = <?php echo JsonEncode($ref_edit->v_08->lookupOptions()) ?>;
frefedit.lists["x_v_09"] = <?php echo $ref_edit->v_09->Lookup->toClientList() ?>;
frefedit.lists["x_v_09"].options = <?php echo JsonEncode($ref_edit->v_09->lookupOptions()) ?>;
frefedit.lists["x_v_10"] = <?php echo $ref_edit->v_10->Lookup->toClientList() ?>;
frefedit.lists["x_v_10"].options = <?php echo JsonEncode($ref_edit->v_10->lookupOptions()) ?>;
frefedit.lists["x_shape[]"] = <?php echo $ref_edit->shape->Lookup->toClientList() ?>;
frefedit.lists["x_shape[]"].options = <?php echo JsonEncode($ref_edit->shape->lookupOptions()) ?>;
frefedit.lists["x_b_03[]"] = <?php echo $ref_edit->b_03->Lookup->toClientList() ?>;
frefedit.lists["x_b_03[]"].options = <?php echo JsonEncode($ref_edit->b_03->lookupOptions()) ?>;
frefedit.lists["x_b_04[]"] = <?php echo $ref_edit->b_04->Lookup->toClientList() ?>;
frefedit.lists["x_b_04[]"].options = <?php echo JsonEncode($ref_edit->b_04->lookupOptions()) ?>;
frefedit.lists["x_b_05[]"] = <?php echo $ref_edit->b_05->Lookup->toClientList() ?>;
frefedit.lists["x_b_05[]"].options = <?php echo JsonEncode($ref_edit->b_05->lookupOptions()) ?>;
frefedit.lists["x_b_06[]"] = <?php echo $ref_edit->b_06->Lookup->toClientList() ?>;
frefedit.lists["x_b_06[]"].options = <?php echo JsonEncode($ref_edit->b_06->lookupOptions()) ?>;
frefedit.lists["x_b_07[]"] = <?php echo $ref_edit->b_07->Lookup->toClientList() ?>;
frefedit.lists["x_b_07[]"].options = <?php echo JsonEncode($ref_edit->b_07->lookupOptions()) ?>;
frefedit.lists["x_b_08[]"] = <?php echo $ref_edit->b_08->Lookup->toClientList() ?>;
frefedit.lists["x_b_08[]"].options = <?php echo JsonEncode($ref_edit->b_08->lookupOptions()) ?>;
frefedit.lists["x_b_09[]"] = <?php echo $ref_edit->b_09->Lookup->toClientList() ?>;
frefedit.lists["x_b_09[]"].options = <?php echo JsonEncode($ref_edit->b_09->lookupOptions()) ?>;
frefedit.lists["x_b_10[]"] = <?php echo $ref_edit->b_10->Lookup->toClientList() ?>;
frefedit.lists["x_b_10[]"].options = <?php echo JsonEncode($ref_edit->b_10->lookupOptions()) ?>;
frefedit.lists["x_t_03[]"] = <?php echo $ref_edit->t_03->Lookup->toClientList() ?>;
frefedit.lists["x_t_03[]"].options = <?php echo JsonEncode($ref_edit->t_03->lookupOptions()) ?>;
frefedit.lists["x_t_04[]"] = <?php echo $ref_edit->t_04->Lookup->toClientList() ?>;
frefedit.lists["x_t_04[]"].options = <?php echo JsonEncode($ref_edit->t_04->lookupOptions()) ?>;
frefedit.lists["x_t_05[]"] = <?php echo $ref_edit->t_05->Lookup->toClientList() ?>;
frefedit.lists["x_t_05[]"].options = <?php echo JsonEncode($ref_edit->t_05->lookupOptions()) ?>;
frefedit.lists["x_t_06[]"] = <?php echo $ref_edit->t_06->Lookup->toClientList() ?>;
frefedit.lists["x_t_06[]"].options = <?php echo JsonEncode($ref_edit->t_06->lookupOptions()) ?>;
frefedit.lists["x_t_07[]"] = <?php echo $ref_edit->t_07->Lookup->toClientList() ?>;
frefedit.lists["x_t_07[]"].options = <?php echo JsonEncode($ref_edit->t_07->lookupOptions()) ?>;
frefedit.lists["x_t_08[]"] = <?php echo $ref_edit->t_08->Lookup->toClientList() ?>;
frefedit.lists["x_t_08[]"].options = <?php echo JsonEncode($ref_edit->t_08->lookupOptions()) ?>;
frefedit.lists["x_t_09[]"] = <?php echo $ref_edit->t_09->Lookup->toClientList() ?>;
frefedit.lists["x_t_09[]"].options = <?php echo JsonEncode($ref_edit->t_09->lookupOptions()) ?>;
frefedit.lists["x_t_10[]"] = <?php echo $ref_edit->t_10->Lookup->toClientList() ?>;
frefedit.lists["x_t_10[]"].options = <?php echo JsonEncode($ref_edit->t_10->lookupOptions()) ?>;
frefedit.lists["x_t_11"] = <?php echo $ref_edit->t_11->Lookup->toClientList() ?>;
frefedit.lists["x_t_11"].options = <?php echo JsonEncode($ref_edit->t_11->lookupOptions()) ?>;
frefedit.autoSuggests["x_t_11"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frefedit.lists["x_t_12"] = <?php echo $ref_edit->t_12->Lookup->toClientList() ?>;
frefedit.lists["x_t_12"].options = <?php echo JsonEncode($ref_edit->t_12->lookupOptions()) ?>;
frefedit.autoSuggests["x_t_12"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frefedit.lists["x_currency"] = <?php echo $ref_edit->currency->Lookup->toClientList() ?>;
frefedit.lists["x_currency"].options = <?php echo JsonEncode($ref_edit->currency->lookupOptions()) ?>;
frefedit.lists["x_hsn"] = <?php echo $ref_edit->hsn->Lookup->toClientList() ?>;
frefedit.lists["x_hsn"].options = <?php echo JsonEncode($ref_edit->hsn->lookupOptions()) ?>;
frefedit.lists["x_composition"] = <?php echo $ref_edit->composition->Lookup->toClientList() ?>;
frefedit.lists["x_composition"].options = <?php echo JsonEncode($ref_edit->composition->lookupOptions()) ?>;
frefedit.lists["x_category"] = <?php echo $ref_edit->category->Lookup->toClientList() ?>;
frefedit.lists["x_category"].options = <?php echo JsonEncode($ref_edit->category->lookupOptions()) ?>;
frefedit.lists["x_status"] = <?php echo $ref_edit->status->Lookup->toClientList() ?>;
frefedit.lists["x_status"].options = <?php echo JsonEncode($ref_edit->status->options(FALSE, TRUE)) ?>;
frefedit.lists["x_publish"] = <?php echo $ref_edit->publish->Lookup->toClientList() ?>;
frefedit.lists["x_publish"].options = <?php echo JsonEncode($ref_edit->publish->options(FALSE, TRUE)) ?>;
frefedit.lists["x_operator"] = <?php echo $ref_edit->operator->Lookup->toClientList() ?>;
frefedit.lists["x_operator"].options = <?php echo JsonEncode($ref_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_edit->showPageHeader(); ?>
<?php
$ref_edit->showMessage();
?>
<form name="frefedit" id="frefedit" class="<?php echo $ref_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$ref_edit->IsModal ?>">
<?php if ($ref_edit->MultiPages->Items[0]->Visible) { ?>
<div class="ew-edit-div"><!-- page0 -->
<?php if ($ref->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_ref_id" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->id->caption() ?><?php echo ($ref->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->id->cellAttributes() ?>>
<span id="el_ref_id">
<span<?php echo $ref->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="ref" data-field="x_id" data-page="0" name="x_id" id="x_id" value="<?php echo HtmlEncode($ref->id->CurrentValue) ?>">
<?php echo $ref->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_ref_company_id" for="x_company_id" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->company_id->caption() ?><?php echo ($ref->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->company_id->cellAttributes() ?>>
<span id="el_ref_company_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_company_id"><?php echo strval($ref->company_id->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($ref->company_id->ViewValue) : $ref->company_id->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($ref->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($ref->company_id->ReadOnly || $ref->company_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_company_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $ref->company_id->Lookup->getParamTag("p_x_company_id") ?>
<input type="hidden" data-table="ref" data-field="x_company_id" data-page="0" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $ref->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id[]" id="x_company_id[]" value="<?php echo $ref->company_id->CurrentValue ?>"<?php echo $ref->company_id->editAttributes() ?>>
</span>
<?php echo $ref->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_ref_grp" for="x_grp" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->grp->caption() ?><?php echo ($ref->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->grp->cellAttributes() ?>>
<span id="el_ref_grp">
<?php $ref->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_grp" data-page="0" data-value-separator="<?php echo $ref->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref->grp->editAttributes() ?>>
		<?php echo $ref->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $ref->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $ref->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_ref_s_grp" for="x_s_grp" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->s_grp->caption() ?><?php echo ($ref->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->s_grp->cellAttributes() ?>>
<span id="el_ref_s_grp">
<?php $ref->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_s_grp" data-page="0" data-value-separator="<?php echo $ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref->s_grp->editAttributes() ?>>
		<?php echo $ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $ref->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_ref_product" for="x_product" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->product->caption() ?><?php echo ($ref->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->product->cellAttributes() ?>>
<span id="el_ref_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product" data-page="0" data-value-separator="<?php echo $ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref->product->editAttributes() ?>>
		<?php echo $ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $ref->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $ref->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_ref_product_type" for="x_product_type" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->product_type->caption() ?><?php echo ($ref->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->product_type->cellAttributes() ?>>
<span id="el_ref_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product_type" data-page="0" data-value-separator="<?php echo $ref->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $ref->product_type->editAttributes() ?>>
		<?php echo $ref->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $ref->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
<?php echo $ref->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_ref_packing_type" for="x_packing_type" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->packing_type->caption() ?><?php echo ($ref->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->packing_type->cellAttributes() ?>>
<span id="el_ref_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_packing_type" data-page="0" data-value-separator="<?php echo $ref->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $ref->packing_type->editAttributes() ?>>
		<?php echo $ref->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $ref->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $ref->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->product_n->Visible) { // product_n ?>
	<div id="r_product_n" class="form-group row">
		<label id="elh_ref_product_n" for="x_product_n" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->product_n->caption() ?><?php echo ($ref->product_n->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->product_n->cellAttributes() ?>>
<span id="el_ref_product_n">
<input type="text" data-table="ref" data-field="x_product_n" data-page="0" name="x_product_n" id="x_product_n" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->product_n->getPlaceHolder()) ?>" value="<?php echo $ref->product_n->EditValue ?>"<?php echo $ref->product_n->editAttributes() ?>>
</span>
<?php echo $ref->product_n->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_ref__barcode" for="x__barcode" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->_barcode->caption() ?><?php echo ($ref->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->_barcode->cellAttributes() ?>>
<span id="el_ref__barcode">
<input type="text" data-table="ref" data-field="x__barcode" data-page="0" name="x__barcode" id="x__barcode" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->_barcode->getPlaceHolder()) ?>" value="<?php echo $ref->_barcode->EditValue ?>"<?php echo $ref->_barcode->editAttributes() ?>>
</span>
<?php echo $ref->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->product_code_type->Visible) { // product_code_type ?>
	<div id="r_product_code_type" class="form-group row">
		<label id="elh_ref_product_code_type" for="x_product_code_type" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->product_code_type->caption() ?><?php echo ($ref->product_code_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->product_code_type->cellAttributes() ?>>
<span id="el_ref_product_code_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product_code_type" data-page="0" data-value-separator="<?php echo $ref->product_code_type->displayValueSeparatorAttribute() ?>" id="x_product_code_type" name="x_product_code_type"<?php echo $ref->product_code_type->editAttributes() ?>>
		<?php echo $ref->product_code_type->selectOptionListHtml("x_product_code_type") ?>
	</select>
</div>
</span>
<?php echo $ref->product_code_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label id="elh_ref_product_code" for="x_product_code" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->product_code->caption() ?><?php echo ($ref->product_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->product_code->cellAttributes() ?>>
<span id="el_ref_product_code">
<textarea data-table="ref" data-field="x_product_code" data-page="0" name="x_product_code" id="x_product_code" cols="35" rows="1" placeholder="<?php echo HtmlEncode($ref->product_code->getPlaceHolder()) ?>"<?php echo $ref->product_code->editAttributes() ?>><?php echo $ref->product_code->EditValue ?></textarea>
</span>
<?php echo $ref->product_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="ref_edit"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $ref_edit->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_edit->MultiPages->isActive("1")) ?>" href="#tab_ref1"><?php echo $ref->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_edit->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $ref_edit->MultiPages->Parent ?>" id="tab_ref1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($ref->set_ref->Visible) { // set_ref ?>
	<div id="r_set_ref" class="form-group row">
		<label id="elh_ref_set_ref" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->set_ref->caption() ?><?php echo ($ref->set_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->set_ref->cellAttributes() ?>>
<span id="el_ref_set_ref">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($ref->set_ref->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $ref->set_ref->ViewValue ?></button>
		<div id="dsl_x_set_ref" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $ref->set_ref->checkBoxListHtml(TRUE, "x_set_ref[]", 1) ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_set_ref" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_set_ref" data-page="1" data-value-separator="<?php echo $ref->set_ref->displayValueSeparatorAttribute() ?>" name="x_set_ref[]" id="x_set_ref[]" value="{value}"<?php echo $ref->set_ref->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$ref->set_ref->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $ref->set_ref->Lookup->getParamTag("p_x_set_ref") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
<?php echo $ref->set_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_00->Visible) { // v_00 ?>
	<div id="r_v_00" class="form-group row">
		<label id="elh_ref_v_00" for="x_v_00" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_00->caption() ?><?php echo ($ref->v_00->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_00->cellAttributes() ?>>
<span id="el_ref_v_00">
<input type="text" data-table="ref" data-field="x_v_00" data-page="1" name="x_v_00" id="x_v_00" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->v_00->getPlaceHolder()) ?>" value="<?php echo $ref->v_00->EditValue ?>"<?php echo $ref->v_00->editAttributes() ?>>
</span>
<?php echo $ref->v_00->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_01->Visible) { // v_01 ?>
	<div id="r_v_01" class="form-group row">
		<label id="elh_ref_v_01" for="x_v_01" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_01->caption() ?><?php echo ($ref->v_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_01->cellAttributes() ?>>
<span id="el_ref_v_01">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_01" data-page="1" data-value-separator="<?php echo $ref->v_01->displayValueSeparatorAttribute() ?>" id="x_v_01" name="x_v_01"<?php echo $ref->v_01->editAttributes() ?>>
		<?php echo $ref->v_01->selectOptionListHtml("x_v_01") ?>
	</select>
</div>
<?php echo $ref->v_01->Lookup->getParamTag("p_x_v_01") ?>
</span>
<?php echo $ref->v_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_02->Visible) { // v_02 ?>
	<div id="r_v_02" class="form-group row">
		<label id="elh_ref_v_02" for="x_v_02" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_02->caption() ?><?php echo ($ref->v_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_02->cellAttributes() ?>>
<span id="el_ref_v_02">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_02" data-page="1" data-value-separator="<?php echo $ref->v_02->displayValueSeparatorAttribute() ?>" id="x_v_02" name="x_v_02"<?php echo $ref->v_02->editAttributes() ?>>
		<?php echo $ref->v_02->selectOptionListHtml("x_v_02") ?>
	</select>
</div>
<?php echo $ref->v_02->Lookup->getParamTag("p_x_v_02") ?>
</span>
<?php echo $ref->v_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_03->Visible) { // v_03 ?>
	<div id="r_v_03" class="form-group row">
		<label id="elh_ref_v_03" for="x_v_03" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_03->caption() ?><?php echo ($ref->v_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_03->cellAttributes() ?>>
<span id="el_ref_v_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_03" data-page="1" data-value-separator="<?php echo $ref->v_03->displayValueSeparatorAttribute() ?>" id="x_v_03" name="x_v_03"<?php echo $ref->v_03->editAttributes() ?>>
		<?php echo $ref->v_03->selectOptionListHtml("x_v_03") ?>
	</select>
</div>
<?php echo $ref->v_03->Lookup->getParamTag("p_x_v_03") ?>
</span>
<?php echo $ref->v_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_04->Visible) { // v_04 ?>
	<div id="r_v_04" class="form-group row">
		<label id="elh_ref_v_04" for="x_v_04" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_04->caption() ?><?php echo ($ref->v_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_04->cellAttributes() ?>>
<span id="el_ref_v_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_04" data-page="1" data-value-separator="<?php echo $ref->v_04->displayValueSeparatorAttribute() ?>" id="x_v_04" name="x_v_04"<?php echo $ref->v_04->editAttributes() ?>>
		<?php echo $ref->v_04->selectOptionListHtml("x_v_04") ?>
	</select>
</div>
<?php echo $ref->v_04->Lookup->getParamTag("p_x_v_04") ?>
</span>
<?php echo $ref->v_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_05->Visible) { // v_05 ?>
	<div id="r_v_05" class="form-group row">
		<label id="elh_ref_v_05" for="x_v_05" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_05->caption() ?><?php echo ($ref->v_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_05->cellAttributes() ?>>
<span id="el_ref_v_05">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_05" data-page="1" data-value-separator="<?php echo $ref->v_05->displayValueSeparatorAttribute() ?>" id="x_v_05" name="x_v_05"<?php echo $ref->v_05->editAttributes() ?>>
		<?php echo $ref->v_05->selectOptionListHtml("x_v_05") ?>
	</select>
</div>
<?php echo $ref->v_05->Lookup->getParamTag("p_x_v_05") ?>
</span>
<?php echo $ref->v_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_06->Visible) { // v_06 ?>
	<div id="r_v_06" class="form-group row">
		<label id="elh_ref_v_06" for="x_v_06" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_06->caption() ?><?php echo ($ref->v_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_06->cellAttributes() ?>>
<span id="el_ref_v_06">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_06" data-page="1" data-value-separator="<?php echo $ref->v_06->displayValueSeparatorAttribute() ?>" id="x_v_06" name="x_v_06"<?php echo $ref->v_06->editAttributes() ?>>
		<?php echo $ref->v_06->selectOptionListHtml("x_v_06") ?>
	</select>
</div>
<?php echo $ref->v_06->Lookup->getParamTag("p_x_v_06") ?>
</span>
<?php echo $ref->v_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_07->Visible) { // v_07 ?>
	<div id="r_v_07" class="form-group row">
		<label id="elh_ref_v_07" for="x_v_07" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_07->caption() ?><?php echo ($ref->v_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_07->cellAttributes() ?>>
<span id="el_ref_v_07">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_07" data-page="1" data-value-separator="<?php echo $ref->v_07->displayValueSeparatorAttribute() ?>" id="x_v_07" name="x_v_07"<?php echo $ref->v_07->editAttributes() ?>>
		<?php echo $ref->v_07->selectOptionListHtml("x_v_07") ?>
	</select>
</div>
<?php echo $ref->v_07->Lookup->getParamTag("p_x_v_07") ?>
</span>
<?php echo $ref->v_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_08->Visible) { // v_08 ?>
	<div id="r_v_08" class="form-group row">
		<label id="elh_ref_v_08" for="x_v_08" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_08->caption() ?><?php echo ($ref->v_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_08->cellAttributes() ?>>
<span id="el_ref_v_08">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_08" data-page="1" data-value-separator="<?php echo $ref->v_08->displayValueSeparatorAttribute() ?>" id="x_v_08" name="x_v_08"<?php echo $ref->v_08->editAttributes() ?>>
		<?php echo $ref->v_08->selectOptionListHtml("x_v_08") ?>
	</select>
</div>
<?php echo $ref->v_08->Lookup->getParamTag("p_x_v_08") ?>
</span>
<?php echo $ref->v_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_09->Visible) { // v_09 ?>
	<div id="r_v_09" class="form-group row">
		<label id="elh_ref_v_09" for="x_v_09" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_09->caption() ?><?php echo ($ref->v_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_09->cellAttributes() ?>>
<span id="el_ref_v_09">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_09" data-page="1" data-value-separator="<?php echo $ref->v_09->displayValueSeparatorAttribute() ?>" id="x_v_09" name="x_v_09"<?php echo $ref->v_09->editAttributes() ?>>
		<?php echo $ref->v_09->selectOptionListHtml("x_v_09") ?>
	</select>
</div>
<?php echo $ref->v_09->Lookup->getParamTag("p_x_v_09") ?>
</span>
<?php echo $ref->v_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->v_10->Visible) { // v_10 ?>
	<div id="r_v_10" class="form-group row">
		<label id="elh_ref_v_10" for="x_v_10" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->v_10->caption() ?><?php echo ($ref->v_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->v_10->cellAttributes() ?>>
<span id="el_ref_v_10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_10" data-page="1" data-value-separator="<?php echo $ref->v_10->displayValueSeparatorAttribute() ?>" id="x_v_10" name="x_v_10"<?php echo $ref->v_10->editAttributes() ?>>
		<?php echo $ref->v_10->selectOptionListHtml("x_v_10") ?>
	</select>
</div>
<?php echo $ref->v_10->Lookup->getParamTag("p_x_v_10") ?>
</span>
<?php echo $ref->v_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->q_sku->Visible) { // q_sku ?>
	<div id="r_q_sku" class="form-group row">
		<label id="elh_ref_q_sku" for="x_q_sku" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->q_sku->caption() ?><?php echo ($ref->q_sku->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->q_sku->cellAttributes() ?>>
<span id="el_ref_q_sku">
<input type="text" data-table="ref" data-field="x_q_sku" data-page="1" name="x_q_sku" id="x_q_sku" size="30" placeholder="<?php echo HtmlEncode($ref->q_sku->getPlaceHolder()) ?>" value="<?php echo $ref->q_sku->EditValue ?>"<?php echo $ref->q_sku->editAttributes() ?>>
</span>
<?php echo $ref->q_sku->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $ref_edit->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_edit->MultiPages->isActive("2")) ?>" href="#tab_ref2"><?php echo $ref->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_edit->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $ref_edit->MultiPages->Parent ?>" id="tab_ref2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($ref->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label id="elh_ref_cbm" for="x_cbm" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->cbm->caption() ?><?php echo ($ref->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->cbm->cellAttributes() ?>>
<span id="el_ref_cbm">
<input type="text" data-table="ref" data-field="x_cbm" data-page="2" name="x_cbm" id="x_cbm" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->cbm->getPlaceHolder()) ?>" value="<?php echo $ref->cbm->EditValue ?>"<?php echo $ref->cbm->editAttributes() ?>>
</span>
<?php echo $ref->cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_ref_sqm" for="x_sqm" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->sqm->caption() ?><?php echo ($ref->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->sqm->cellAttributes() ?>>
<span id="el_ref_sqm">
<input type="text" data-table="ref" data-field="x_sqm" data-page="2" name="x_sqm" id="x_sqm" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->sqm->getPlaceHolder()) ?>" value="<?php echo $ref->sqm->EditValue ?>"<?php echo $ref->sqm->editAttributes() ?>>
</span>
<?php echo $ref->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_ref_shape" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->shape->caption() ?><?php echo ($ref->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->shape->cellAttributes() ?>>
<span id="el_ref_shape">
<div id="tp_x_shape" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_shape" data-page="2" data-value-separator="<?php echo $ref->shape->displayValueSeparatorAttribute() ?>" name="x_shape[]" id="x_shape[]" value="{value}"<?php echo $ref->shape->editAttributes() ?>></div>
<div id="dsl_x_shape" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->shape->checkBoxListHtml(FALSE, "x_shape[]", 2) ?>
</div></div>
<?php echo $ref->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
<?php echo $ref->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_01->Visible) { // b_01 ?>
	<div id="r_b_01" class="form-group row">
		<label id="elh_ref_b_01" for="x_b_01" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_01->caption() ?><?php echo ($ref->b_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_01->cellAttributes() ?>>
<span id="el_ref_b_01">
<input type="text" data-table="ref" data-field="x_b_01" data-page="2" name="x_b_01" id="x_b_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_01->getPlaceHolder()) ?>" value="<?php echo $ref->b_01->EditValue ?>"<?php echo $ref->b_01->editAttributes() ?>>
</span>
<?php echo $ref->b_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_02->Visible) { // b_02 ?>
	<div id="r_b_02" class="form-group row">
		<label id="elh_ref_b_02" for="x_b_02" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_02->caption() ?><?php echo ($ref->b_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_02->cellAttributes() ?>>
<span id="el_ref_b_02">
<input type="text" data-table="ref" data-field="x_b_02" data-page="2" name="x_b_02" id="x_b_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_02->getPlaceHolder()) ?>" value="<?php echo $ref->b_02->EditValue ?>"<?php echo $ref->b_02->editAttributes() ?>>
</span>
<?php echo $ref->b_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_03->Visible) { // b_03 ?>
	<div id="r_b_03" class="form-group row">
		<label id="elh_ref_b_03" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_03->caption() ?><?php echo ($ref->b_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_03->cellAttributes() ?>>
<span id="el_ref_b_03">
<div id="tp_x_b_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_03" data-page="2" data-value-separator="<?php echo $ref->b_03->displayValueSeparatorAttribute() ?>" name="x_b_03[]" id="x_b_03[]" value="{value}"<?php echo $ref->b_03->editAttributes() ?>></div>
<div id="dsl_x_b_03" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_03->checkBoxListHtml(FALSE, "x_b_03[]", 2) ?>
</div></div>
<?php echo $ref->b_03->Lookup->getParamTag("p_x_b_03") ?>
</span>
<?php echo $ref->b_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_04->Visible) { // b_04 ?>
	<div id="r_b_04" class="form-group row">
		<label id="elh_ref_b_04" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_04->caption() ?><?php echo ($ref->b_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_04->cellAttributes() ?>>
<span id="el_ref_b_04">
<div id="tp_x_b_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_04" data-page="2" data-value-separator="<?php echo $ref->b_04->displayValueSeparatorAttribute() ?>" name="x_b_04[]" id="x_b_04[]" value="{value}"<?php echo $ref->b_04->editAttributes() ?>></div>
<div id="dsl_x_b_04" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref->b_04->checkBoxListHtml(FALSE, "x_b_04[]", 2) ?>
</div></div>
<?php echo $ref->b_04->Lookup->getParamTag("p_x_b_04") ?>
</span>
<?php echo $ref->b_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_05->Visible) { // b_05 ?>
	<div id="r_b_05" class="form-group row">
		<label id="elh_ref_b_05" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_05->caption() ?><?php echo ($ref->b_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_05->cellAttributes() ?>>
<span id="el_ref_b_05">
<div id="tp_x_b_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_05" data-page="2" data-value-separator="<?php echo $ref->b_05->displayValueSeparatorAttribute() ?>" name="x_b_05[]" id="x_b_05[]" value="{value}"<?php echo $ref->b_05->editAttributes() ?>></div>
<div id="dsl_x_b_05" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_05->checkBoxListHtml(FALSE, "x_b_05[]", 2) ?>
</div></div>
<?php echo $ref->b_05->Lookup->getParamTag("p_x_b_05") ?>
</span>
<?php echo $ref->b_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_06->Visible) { // b_06 ?>
	<div id="r_b_06" class="form-group row">
		<label id="elh_ref_b_06" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_06->caption() ?><?php echo ($ref->b_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_06->cellAttributes() ?>>
<span id="el_ref_b_06">
<div id="tp_x_b_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_06" data-page="2" data-value-separator="<?php echo $ref->b_06->displayValueSeparatorAttribute() ?>" name="x_b_06[]" id="x_b_06[]" value="{value}"<?php echo $ref->b_06->editAttributes() ?>></div>
<div id="dsl_x_b_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_06->checkBoxListHtml(FALSE, "x_b_06[]", 2) ?>
</div></div>
<?php echo $ref->b_06->Lookup->getParamTag("p_x_b_06") ?>
</span>
<?php echo $ref->b_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_07->Visible) { // b_07 ?>
	<div id="r_b_07" class="form-group row">
		<label id="elh_ref_b_07" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_07->caption() ?><?php echo ($ref->b_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_07->cellAttributes() ?>>
<span id="el_ref_b_07">
<div id="tp_x_b_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_07" data-page="2" data-value-separator="<?php echo $ref->b_07->displayValueSeparatorAttribute() ?>" name="x_b_07[]" id="x_b_07[]" value="{value}"<?php echo $ref->b_07->editAttributes() ?>></div>
<div id="dsl_x_b_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_07->checkBoxListHtml(FALSE, "x_b_07[]", 2) ?>
</div></div>
<?php echo $ref->b_07->Lookup->getParamTag("p_x_b_07") ?>
</span>
<?php echo $ref->b_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_08->Visible) { // b_08 ?>
	<div id="r_b_08" class="form-group row">
		<label id="elh_ref_b_08" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_08->caption() ?><?php echo ($ref->b_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_08->cellAttributes() ?>>
<span id="el_ref_b_08">
<div id="tp_x_b_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_08" data-page="2" data-value-separator="<?php echo $ref->b_08->displayValueSeparatorAttribute() ?>" name="x_b_08[]" id="x_b_08[]" value="{value}"<?php echo $ref->b_08->editAttributes() ?>></div>
<div id="dsl_x_b_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_08->checkBoxListHtml(FALSE, "x_b_08[]", 2) ?>
</div></div>
<?php echo $ref->b_08->Lookup->getParamTag("p_x_b_08") ?>
</span>
<?php echo $ref->b_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_09->Visible) { // b_09 ?>
	<div id="r_b_09" class="form-group row">
		<label id="elh_ref_b_09" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_09->caption() ?><?php echo ($ref->b_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_09->cellAttributes() ?>>
<span id="el_ref_b_09">
<div id="tp_x_b_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_09" data-page="2" data-value-separator="<?php echo $ref->b_09->displayValueSeparatorAttribute() ?>" name="x_b_09[]" id="x_b_09[]" value="{value}"<?php echo $ref->b_09->editAttributes() ?>></div>
<div id="dsl_x_b_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_09->checkBoxListHtml(FALSE, "x_b_09[]", 2) ?>
</div></div>
<?php echo $ref->b_09->Lookup->getParamTag("p_x_b_09") ?>
</span>
<?php echo $ref->b_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_10->Visible) { // b_10 ?>
	<div id="r_b_10" class="form-group row">
		<label id="elh_ref_b_10" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_10->caption() ?><?php echo ($ref->b_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_10->cellAttributes() ?>>
<span id="el_ref_b_10">
<div id="tp_x_b_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_10" data-page="2" data-value-separator="<?php echo $ref->b_10->displayValueSeparatorAttribute() ?>" name="x_b_10[]" id="x_b_10[]" value="{value}"<?php echo $ref->b_10->editAttributes() ?>></div>
<div id="dsl_x_b_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_10->checkBoxListHtml(FALSE, "x_b_10[]", 2) ?>
</div></div>
<?php echo $ref->b_10->Lookup->getParamTag("p_x_b_10") ?>
</span>
<?php echo $ref->b_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_11->Visible) { // b_11 ?>
	<div id="r_b_11" class="form-group row">
		<label id="elh_ref_b_11" for="x_b_11" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_11->caption() ?><?php echo ($ref->b_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_11->cellAttributes() ?>>
<span id="el_ref_b_11">
<input type="text" data-table="ref" data-field="x_b_11" data-page="2" name="x_b_11" id="x_b_11" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_11->getPlaceHolder()) ?>" value="<?php echo $ref->b_11->EditValue ?>"<?php echo $ref->b_11->editAttributes() ?>>
</span>
<?php echo $ref->b_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_12->Visible) { // b_12 ?>
	<div id="r_b_12" class="form-group row">
		<label id="elh_ref_b_12" for="x_b_12" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_12->caption() ?><?php echo ($ref->b_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_12->cellAttributes() ?>>
<span id="el_ref_b_12">
<input type="text" data-table="ref" data-field="x_b_12" data-page="2" name="x_b_12" id="x_b_12" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_12->getPlaceHolder()) ?>" value="<?php echo $ref->b_12->EditValue ?>"<?php echo $ref->b_12->editAttributes() ?>>
</span>
<?php echo $ref->b_12->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_13->Visible) { // b_13 ?>
	<div id="r_b_13" class="form-group row">
		<label id="elh_ref_b_13" for="x_b_13" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_13->caption() ?><?php echo ($ref->b_13->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_13->cellAttributes() ?>>
<span id="el_ref_b_13">
<input type="text" data-table="ref" data-field="x_b_13" data-page="2" name="x_b_13" id="x_b_13" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_13->getPlaceHolder()) ?>" value="<?php echo $ref->b_13->EditValue ?>"<?php echo $ref->b_13->editAttributes() ?>>
</span>
<?php echo $ref->b_13->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_14->Visible) { // b_14 ?>
	<div id="r_b_14" class="form-group row">
		<label id="elh_ref_b_14" for="x_b_14" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_14->caption() ?><?php echo ($ref->b_14->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_14->cellAttributes() ?>>
<span id="el_ref_b_14">
<input type="text" data-table="ref" data-field="x_b_14" data-page="2" name="x_b_14" id="x_b_14" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_14->getPlaceHolder()) ?>" value="<?php echo $ref->b_14->EditValue ?>"<?php echo $ref->b_14->editAttributes() ?>>
</span>
<?php echo $ref->b_14->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->b_15->Visible) { // b_15 ?>
	<div id="r_b_15" class="form-group row">
		<label id="elh_ref_b_15" for="x_b_15" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->b_15->caption() ?><?php echo ($ref->b_15->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->b_15->cellAttributes() ?>>
<span id="el_ref_b_15">
<input type="text" data-table="ref" data-field="x_b_15" data-page="2" name="x_b_15" id="x_b_15" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_15->getPlaceHolder()) ?>" value="<?php echo $ref->b_15->EditValue ?>"<?php echo $ref->b_15->editAttributes() ?>>
</span>
<?php echo $ref->b_15->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $ref_edit->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_edit->MultiPages->isActive("3")) ?>" href="#tab_ref3"><?php echo $ref->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_edit->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $ref_edit->MultiPages->Parent ?>" id="tab_ref3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($ref->t_01->Visible) { // t_01 ?>
	<div id="r_t_01" class="form-group row">
		<label id="elh_ref_t_01" for="x_t_01" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_01->caption() ?><?php echo ($ref->t_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_01->cellAttributes() ?>>
<span id="el_ref_t_01">
<input type="text" data-table="ref" data-field="x_t_01" data-page="3" name="x_t_01" id="x_t_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_01->getPlaceHolder()) ?>" value="<?php echo $ref->t_01->EditValue ?>"<?php echo $ref->t_01->editAttributes() ?>>
</span>
<?php echo $ref->t_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_02->Visible) { // t_02 ?>
	<div id="r_t_02" class="form-group row">
		<label id="elh_ref_t_02" for="x_t_02" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_02->caption() ?><?php echo ($ref->t_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_02->cellAttributes() ?>>
<span id="el_ref_t_02">
<input type="text" data-table="ref" data-field="x_t_02" data-page="3" name="x_t_02" id="x_t_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_02->getPlaceHolder()) ?>" value="<?php echo $ref->t_02->EditValue ?>"<?php echo $ref->t_02->editAttributes() ?>>
</span>
<?php echo $ref->t_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_03->Visible) { // t_03 ?>
	<div id="r_t_03" class="form-group row">
		<label id="elh_ref_t_03" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_03->caption() ?><?php echo ($ref->t_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_03->cellAttributes() ?>>
<span id="el_ref_t_03">
<div id="tp_x_t_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_03" data-page="3" data-value-separator="<?php echo $ref->t_03->displayValueSeparatorAttribute() ?>" name="x_t_03[]" id="x_t_03[]" value="{value}"<?php echo $ref->t_03->editAttributes() ?>></div>
<div id="dsl_x_t_03" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_03->checkBoxListHtml(FALSE, "x_t_03[]", 3) ?>
</div></div>
<?php echo $ref->t_03->Lookup->getParamTag("p_x_t_03") ?>
</span>
<?php echo $ref->t_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_04->Visible) { // t_04 ?>
	<div id="r_t_04" class="form-group row">
		<label id="elh_ref_t_04" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_04->caption() ?><?php echo ($ref->t_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_04->cellAttributes() ?>>
<span id="el_ref_t_04">
<div id="tp_x_t_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_04" data-page="3" data-value-separator="<?php echo $ref->t_04->displayValueSeparatorAttribute() ?>" name="x_t_04[]" id="x_t_04[]" value="{value}"<?php echo $ref->t_04->editAttributes() ?>></div>
<div id="dsl_x_t_04" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_04->checkBoxListHtml(FALSE, "x_t_04[]", 3) ?>
</div></div>
<?php echo $ref->t_04->Lookup->getParamTag("p_x_t_04") ?>
</span>
<?php echo $ref->t_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_05->Visible) { // t_05 ?>
	<div id="r_t_05" class="form-group row">
		<label id="elh_ref_t_05" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_05->caption() ?><?php echo ($ref->t_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_05->cellAttributes() ?>>
<span id="el_ref_t_05">
<div id="tp_x_t_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_05" data-page="3" data-value-separator="<?php echo $ref->t_05->displayValueSeparatorAttribute() ?>" name="x_t_05[]" id="x_t_05[]" value="{value}"<?php echo $ref->t_05->editAttributes() ?>></div>
<div id="dsl_x_t_05" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_05->checkBoxListHtml(FALSE, "x_t_05[]", 3) ?>
</div></div>
<?php echo $ref->t_05->Lookup->getParamTag("p_x_t_05") ?>
</span>
<?php echo $ref->t_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_06->Visible) { // t_06 ?>
	<div id="r_t_06" class="form-group row">
		<label id="elh_ref_t_06" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_06->caption() ?><?php echo ($ref->t_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_06->cellAttributes() ?>>
<span id="el_ref_t_06">
<div id="tp_x_t_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_06" data-page="3" data-value-separator="<?php echo $ref->t_06->displayValueSeparatorAttribute() ?>" name="x_t_06[]" id="x_t_06[]" value="{value}"<?php echo $ref->t_06->editAttributes() ?>></div>
<div id="dsl_x_t_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_06->checkBoxListHtml(FALSE, "x_t_06[]", 3) ?>
</div></div>
<?php echo $ref->t_06->Lookup->getParamTag("p_x_t_06") ?>
</span>
<?php echo $ref->t_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_07->Visible) { // t_07 ?>
	<div id="r_t_07" class="form-group row">
		<label id="elh_ref_t_07" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_07->caption() ?><?php echo ($ref->t_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_07->cellAttributes() ?>>
<span id="el_ref_t_07">
<div id="tp_x_t_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_07" data-page="3" data-value-separator="<?php echo $ref->t_07->displayValueSeparatorAttribute() ?>" name="x_t_07[]" id="x_t_07[]" value="{value}"<?php echo $ref->t_07->editAttributes() ?>></div>
<div id="dsl_x_t_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_07->checkBoxListHtml(FALSE, "x_t_07[]", 3) ?>
</div></div>
<?php echo $ref->t_07->Lookup->getParamTag("p_x_t_07") ?>
</span>
<?php echo $ref->t_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_08->Visible) { // t_08 ?>
	<div id="r_t_08" class="form-group row">
		<label id="elh_ref_t_08" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_08->caption() ?><?php echo ($ref->t_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_08->cellAttributes() ?>>
<span id="el_ref_t_08">
<div id="tp_x_t_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_08" data-page="3" data-value-separator="<?php echo $ref->t_08->displayValueSeparatorAttribute() ?>" name="x_t_08[]" id="x_t_08[]" value="{value}"<?php echo $ref->t_08->editAttributes() ?>></div>
<div id="dsl_x_t_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_08->checkBoxListHtml(FALSE, "x_t_08[]", 3) ?>
</div></div>
<?php echo $ref->t_08->Lookup->getParamTag("p_x_t_08") ?>
</span>
<?php echo $ref->t_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_09->Visible) { // t_09 ?>
	<div id="r_t_09" class="form-group row">
		<label id="elh_ref_t_09" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_09->caption() ?><?php echo ($ref->t_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_09->cellAttributes() ?>>
<span id="el_ref_t_09">
<div id="tp_x_t_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_09" data-page="3" data-value-separator="<?php echo $ref->t_09->displayValueSeparatorAttribute() ?>" name="x_t_09[]" id="x_t_09[]" value="{value}"<?php echo $ref->t_09->editAttributes() ?>></div>
<div id="dsl_x_t_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_09->checkBoxListHtml(FALSE, "x_t_09[]", 3) ?>
</div></div>
<?php echo $ref->t_09->Lookup->getParamTag("p_x_t_09") ?>
</span>
<?php echo $ref->t_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_10->Visible) { // t_10 ?>
	<div id="r_t_10" class="form-group row">
		<label id="elh_ref_t_10" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_10->caption() ?><?php echo ($ref->t_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_10->cellAttributes() ?>>
<span id="el_ref_t_10">
<div id="tp_x_t_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_10" data-page="3" data-value-separator="<?php echo $ref->t_10->displayValueSeparatorAttribute() ?>" name="x_t_10[]" id="x_t_10[]" value="{value}"<?php echo $ref->t_10->editAttributes() ?>></div>
<div id="dsl_x_t_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_10->checkBoxListHtml(FALSE, "x_t_10[]", 3) ?>
</div></div>
<?php echo $ref->t_10->Lookup->getParamTag("p_x_t_10") ?>
</span>
<?php echo $ref->t_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_11->Visible) { // t_11 ?>
	<div id="r_t_11" class="form-group row">
		<label id="elh_ref_t_11" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_11->caption() ?><?php echo ($ref->t_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_11->cellAttributes() ?>>
<span id="el_ref_t_11">
<?php
$wrkonchange = "" . trim(@$ref->t_11->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref->t_11->EditAttrs["onchange"] = "";
?>
<span id="as_x_t_11" class="text-nowrap" style="z-index: 8410">
	<input type="text" class="form-control" name="sv_x_t_11" id="sv_x_t_11" value="<?php echo RemoveHtml($ref->t_11->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_11->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref->t_11->getPlaceHolder()) ?>"<?php echo $ref->t_11->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref" data-field="x_t_11" data-page="3" data-value-separator="<?php echo $ref->t_11->displayValueSeparatorAttribute() ?>" name="x_t_11" id="x_t_11" value="<?php echo HtmlEncode($ref->t_11->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
frefedit.createAutoSuggest({"id":"x_t_11","forceSelect":false});
</script>
<?php echo $ref->t_11->Lookup->getParamTag("p_x_t_11") ?>
</span>
<?php echo $ref->t_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_12->Visible) { // t_12 ?>
	<div id="r_t_12" class="form-group row">
		<label id="elh_ref_t_12" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_12->caption() ?><?php echo ($ref->t_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_12->cellAttributes() ?>>
<span id="el_ref_t_12">
<?php
$wrkonchange = "" . trim(@$ref->t_12->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref->t_12->EditAttrs["onchange"] = "";
?>
<span id="as_x_t_12" class="text-nowrap" style="z-index: 8400">
	<input type="text" class="form-control" name="sv_x_t_12" id="sv_x_t_12" value="<?php echo RemoveHtml($ref->t_12->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_12->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref->t_12->getPlaceHolder()) ?>"<?php echo $ref->t_12->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref" data-field="x_t_12" data-page="3" data-value-separator="<?php echo $ref->t_12->displayValueSeparatorAttribute() ?>" name="x_t_12" id="x_t_12" value="<?php echo HtmlEncode($ref->t_12->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
frefedit.createAutoSuggest({"id":"x_t_12","forceSelect":false});
</script>
<?php echo $ref->t_12->Lookup->getParamTag("p_x_t_12") ?>
</span>
<?php echo $ref->t_12->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_13->Visible) { // t_13 ?>
	<div id="r_t_13" class="form-group row">
		<label id="elh_ref_t_13" for="x_t_13" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_13->caption() ?><?php echo ($ref->t_13->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_13->cellAttributes() ?>>
<span id="el_ref_t_13">
<input type="text" data-table="ref" data-field="x_t_13" data-page="3" name="x_t_13" id="x_t_13" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_13->getPlaceHolder()) ?>" value="<?php echo $ref->t_13->EditValue ?>"<?php echo $ref->t_13->editAttributes() ?>>
</span>
<?php echo $ref->t_13->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_14->Visible) { // t_14 ?>
	<div id="r_t_14" class="form-group row">
		<label id="elh_ref_t_14" for="x_t_14" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_14->caption() ?><?php echo ($ref->t_14->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_14->cellAttributes() ?>>
<span id="el_ref_t_14">
<input type="text" data-table="ref" data-field="x_t_14" data-page="3" name="x_t_14" id="x_t_14" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_14->getPlaceHolder()) ?>" value="<?php echo $ref->t_14->EditValue ?>"<?php echo $ref->t_14->editAttributes() ?>>
</span>
<?php echo $ref->t_14->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->t_15->Visible) { // t_15 ?>
	<div id="r_t_15" class="form-group row">
		<label id="elh_ref_t_15" for="x_t_15" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->t_15->caption() ?><?php echo ($ref->t_15->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->t_15->cellAttributes() ?>>
<span id="el_ref_t_15">
<input type="text" data-table="ref" data-field="x_t_15" data-page="3" name="x_t_15" id="x_t_15" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_15->getPlaceHolder()) ?>" value="<?php echo $ref->t_15->EditValue ?>"<?php echo $ref->t_15->editAttributes() ?>>
</span>
<?php echo $ref->t_15->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $ref_edit->MultiPages->pageStyle("4") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_edit->MultiPages->isActive("4")) ?>" href="#tab_ref4"><?php echo $ref->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_edit->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $ref_edit->MultiPages->Parent ?>" id="tab_ref4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($ref->d_head_01->Visible) { // d_head_01 ?>
	<div id="r_d_head_01" class="form-group row">
		<label id="elh_ref_d_head_01" for="x_d_head_01" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->d_head_01->caption() ?><?php echo ($ref->d_head_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->d_head_01->cellAttributes() ?>>
<span id="el_ref_d_head_01">
<input type="text" data-table="ref" data-field="x_d_head_01" data-page="4" name="x_d_head_01" id="x_d_head_01" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->d_head_01->getPlaceHolder()) ?>" value="<?php echo $ref->d_head_01->EditValue ?>"<?php echo $ref->d_head_01->editAttributes() ?>>
</span>
<?php echo $ref->d_head_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->d_description_01->Visible) { // d_description_01 ?>
	<div id="r_d_description_01" class="form-group row">
		<label id="elh_ref_d_description_01" for="x_d_description_01" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->d_description_01->caption() ?><?php echo ($ref->d_description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->d_description_01->cellAttributes() ?>>
<span id="el_ref_d_description_01">
<textarea data-table="ref" data-field="x_d_description_01" data-page="4" name="x_d_description_01" id="x_d_description_01" cols="35" rows="4" placeholder="<?php echo HtmlEncode($ref->d_description_01->getPlaceHolder()) ?>"<?php echo $ref->d_description_01->editAttributes() ?>><?php echo $ref->d_description_01->EditValue ?></textarea>
</span>
<?php echo $ref->d_description_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->d_head_02->Visible) { // d_head_02 ?>
	<div id="r_d_head_02" class="form-group row">
		<label id="elh_ref_d_head_02" for="x_d_head_02" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->d_head_02->caption() ?><?php echo ($ref->d_head_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->d_head_02->cellAttributes() ?>>
<span id="el_ref_d_head_02">
<input type="text" data-table="ref" data-field="x_d_head_02" data-page="4" name="x_d_head_02" id="x_d_head_02" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->d_head_02->getPlaceHolder()) ?>" value="<?php echo $ref->d_head_02->EditValue ?>"<?php echo $ref->d_head_02->editAttributes() ?>>
</span>
<?php echo $ref->d_head_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->d_description_02->Visible) { // d_description_02 ?>
	<div id="r_d_description_02" class="form-group row">
		<label id="elh_ref_d_description_02" for="x_d_description_02" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->d_description_02->caption() ?><?php echo ($ref->d_description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->d_description_02->cellAttributes() ?>>
<span id="el_ref_d_description_02">
<textarea data-table="ref" data-field="x_d_description_02" data-page="4" name="x_d_description_02" id="x_d_description_02" cols="35" rows="4" placeholder="<?php echo HtmlEncode($ref->d_description_02->getPlaceHolder()) ?>"<?php echo $ref->d_description_02->editAttributes() ?>><?php echo $ref->d_description_02->EditValue ?></textarea>
</span>
<?php echo $ref->d_description_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $ref_edit->MultiPages->pageStyle("5") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_edit->MultiPages->isActive("5")) ?>" href="#tab_ref5"><?php echo $ref->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_edit->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $ref_edit->MultiPages->Parent ?>" id="tab_ref5"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($ref->main_image->Visible) { // main_image ?>
	<div id="r_main_image" class="form-group row">
		<label id="elh_ref_main_image" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->main_image->caption() ?><?php echo ($ref->main_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->main_image->cellAttributes() ?>>
<span id="el_ref_main_image">
<div id="fd_x_main_image">
<span title="<?php echo $ref->main_image->title() ? $ref->main_image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->main_image->ReadOnly || $ref->main_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_main_image" data-page="5" name="x_main_image" id="x_main_image"<?php echo $ref->main_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_main_image" id= "fn_x_main_image" value="<?php echo $ref->main_image->Upload->FileName ?>">
<?php if (Post("fa_x_main_image") == "0") { ?>
<input type="hidden" name="fa_x_main_image" id= "fa_x_main_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_main_image" id= "fa_x_main_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_main_image" id= "fs_x_main_image" value="255">
<input type="hidden" name="fx_x_main_image" id= "fx_x_main_image" value="<?php echo $ref->main_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_main_image" id= "fm_x_main_image" value="<?php echo $ref->main_image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_main_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->main_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->top_view->Visible) { // top_view ?>
	<div id="r_top_view" class="form-group row">
		<label id="elh_ref_top_view" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->top_view->caption() ?><?php echo ($ref->top_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->top_view->cellAttributes() ?>>
<span id="el_ref_top_view">
<div id="fd_x_top_view">
<span title="<?php echo $ref->top_view->title() ? $ref->top_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->top_view->ReadOnly || $ref->top_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_top_view" data-page="5" name="x_top_view" id="x_top_view" multiple="multiple"<?php echo $ref->top_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_top_view" id= "fn_x_top_view" value="<?php echo $ref->top_view->Upload->FileName ?>">
<?php if (Post("fa_x_top_view") == "0") { ?>
<input type="hidden" name="fa_x_top_view" id= "fa_x_top_view" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_top_view" id= "fa_x_top_view" value="1">
<?php } ?>
<input type="hidden" name="fs_x_top_view" id= "fs_x_top_view" value="255">
<input type="hidden" name="fx_x_top_view" id= "fx_x_top_view" value="<?php echo $ref->top_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_top_view" id= "fm_x_top_view" value="<?php echo $ref->top_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_top_view" id= "fc_x_top_view" value="<?php echo $ref->top_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_top_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->top_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->front_view->Visible) { // front_view ?>
	<div id="r_front_view" class="form-group row">
		<label id="elh_ref_front_view" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->front_view->caption() ?><?php echo ($ref->front_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->front_view->cellAttributes() ?>>
<span id="el_ref_front_view">
<div id="fd_x_front_view">
<span title="<?php echo $ref->front_view->title() ? $ref->front_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->front_view->ReadOnly || $ref->front_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_front_view" data-page="5" name="x_front_view" id="x_front_view" multiple="multiple"<?php echo $ref->front_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_front_view" id= "fn_x_front_view" value="<?php echo $ref->front_view->Upload->FileName ?>">
<?php if (Post("fa_x_front_view") == "0") { ?>
<input type="hidden" name="fa_x_front_view" id= "fa_x_front_view" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_front_view" id= "fa_x_front_view" value="1">
<?php } ?>
<input type="hidden" name="fs_x_front_view" id= "fs_x_front_view" value="255">
<input type="hidden" name="fx_x_front_view" id= "fx_x_front_view" value="<?php echo $ref->front_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_front_view" id= "fm_x_front_view" value="<?php echo $ref->front_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_front_view" id= "fc_x_front_view" value="<?php echo $ref->front_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_front_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->front_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->corner_view->Visible) { // corner_view ?>
	<div id="r_corner_view" class="form-group row">
		<label id="elh_ref_corner_view" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->corner_view->caption() ?><?php echo ($ref->corner_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->corner_view->cellAttributes() ?>>
<span id="el_ref_corner_view">
<div id="fd_x_corner_view">
<span title="<?php echo $ref->corner_view->title() ? $ref->corner_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->corner_view->ReadOnly || $ref->corner_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_corner_view" data-page="5" name="x_corner_view" id="x_corner_view" multiple="multiple"<?php echo $ref->corner_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_corner_view" id= "fn_x_corner_view" value="<?php echo $ref->corner_view->Upload->FileName ?>">
<?php if (Post("fa_x_corner_view") == "0") { ?>
<input type="hidden" name="fa_x_corner_view" id= "fa_x_corner_view" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_corner_view" id= "fa_x_corner_view" value="1">
<?php } ?>
<input type="hidden" name="fs_x_corner_view" id= "fs_x_corner_view" value="255">
<input type="hidden" name="fx_x_corner_view" id= "fx_x_corner_view" value="<?php echo $ref->corner_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_corner_view" id= "fm_x_corner_view" value="<?php echo $ref->corner_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_corner_view" id= "fc_x_corner_view" value="<?php echo $ref->corner_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_corner_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->corner_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->back_view->Visible) { // back_view ?>
	<div id="r_back_view" class="form-group row">
		<label id="elh_ref_back_view" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->back_view->caption() ?><?php echo ($ref->back_view->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->back_view->cellAttributes() ?>>
<span id="el_ref_back_view">
<div id="fd_x_back_view">
<span title="<?php echo $ref->back_view->title() ? $ref->back_view->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->back_view->ReadOnly || $ref->back_view->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_back_view" data-page="5" name="x_back_view" id="x_back_view" multiple="multiple"<?php echo $ref->back_view->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_back_view" id= "fn_x_back_view" value="<?php echo $ref->back_view->Upload->FileName ?>">
<?php if (Post("fa_x_back_view") == "0") { ?>
<input type="hidden" name="fa_x_back_view" id= "fa_x_back_view" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_back_view" id= "fa_x_back_view" value="1">
<?php } ?>
<input type="hidden" name="fs_x_back_view" id= "fs_x_back_view" value="255">
<input type="hidden" name="fx_x_back_view" id= "fx_x_back_view" value="<?php echo $ref->back_view->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_back_view" id= "fm_x_back_view" value="<?php echo $ref->back_view->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_back_view" id= "fc_x_back_view" value="<?php echo $ref->back_view->UploadMaxFileCount ?>">
</div>
<table id="ft_x_back_view" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->back_view->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->color_options->Visible) { // color_options ?>
	<div id="r_color_options" class="form-group row">
		<label id="elh_ref_color_options" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->color_options->caption() ?><?php echo ($ref->color_options->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->color_options->cellAttributes() ?>>
<span id="el_ref_color_options">
<div id="fd_x_color_options">
<span title="<?php echo $ref->color_options->title() ? $ref->color_options->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->color_options->ReadOnly || $ref->color_options->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_color_options" data-page="5" name="x_color_options" id="x_color_options" multiple="multiple"<?php echo $ref->color_options->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_color_options" id= "fn_x_color_options" value="<?php echo $ref->color_options->Upload->FileName ?>">
<?php if (Post("fa_x_color_options") == "0") { ?>
<input type="hidden" name="fa_x_color_options" id= "fa_x_color_options" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_color_options" id= "fa_x_color_options" value="1">
<?php } ?>
<input type="hidden" name="fs_x_color_options" id= "fs_x_color_options" value="255">
<input type="hidden" name="fx_x_color_options" id= "fx_x_color_options" value="<?php echo $ref->color_options->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_color_options" id= "fm_x_color_options" value="<?php echo $ref->color_options->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_color_options" id= "fc_x_color_options" value="<?php echo $ref->color_options->UploadMaxFileCount ?>">
</div>
<table id="ft_x_color_options" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->color_options->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->other_options->Visible) { // other_options ?>
	<div id="r_other_options" class="form-group row">
		<label id="elh_ref_other_options" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->other_options->caption() ?><?php echo ($ref->other_options->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->other_options->cellAttributes() ?>>
<span id="el_ref_other_options">
<div id="fd_x_other_options">
<span title="<?php echo $ref->other_options->title() ? $ref->other_options->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->other_options->ReadOnly || $ref->other_options->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_other_options" data-page="5" name="x_other_options" id="x_other_options" multiple="multiple"<?php echo $ref->other_options->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_other_options" id= "fn_x_other_options" value="<?php echo $ref->other_options->Upload->FileName ?>">
<?php if (Post("fa_x_other_options") == "0") { ?>
<input type="hidden" name="fa_x_other_options" id= "fa_x_other_options" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_other_options" id= "fa_x_other_options" value="1">
<?php } ?>
<input type="hidden" name="fs_x_other_options" id= "fs_x_other_options" value="255">
<input type="hidden" name="fx_x_other_options" id= "fx_x_other_options" value="<?php echo $ref->other_options->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_other_options" id= "fm_x_other_options" value="<?php echo $ref->other_options->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_other_options" id= "fc_x_other_options" value="<?php echo $ref->other_options->UploadMaxFileCount ?>">
</div>
<table id="ft_x_other_options" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->other_options->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->group_image->Visible) { // group_image ?>
	<div id="r_group_image" class="form-group row">
		<label id="elh_ref_group_image" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->group_image->caption() ?><?php echo ($ref->group_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->group_image->cellAttributes() ?>>
<span id="el_ref_group_image">
<div id="fd_x_group_image">
<span title="<?php echo $ref->group_image->title() ? $ref->group_image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->group_image->ReadOnly || $ref->group_image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_group_image" data-page="5" name="x_group_image" id="x_group_image"<?php echo $ref->group_image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_group_image" id= "fn_x_group_image" value="<?php echo $ref->group_image->Upload->FileName ?>">
<?php if (Post("fa_x_group_image") == "0") { ?>
<input type="hidden" name="fa_x_group_image" id= "fa_x_group_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_group_image" id= "fa_x_group_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_group_image" id= "fs_x_group_image" value="196">
<input type="hidden" name="fx_x_group_image" id= "fx_x_group_image" value="<?php echo $ref->group_image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_group_image" id= "fm_x_group_image" value="<?php echo $ref->group_image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_group_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->group_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->video_url->Visible) { // video_url ?>
	<div id="r_video_url" class="form-group row">
		<label id="elh_ref_video_url" for="x_video_url" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->video_url->caption() ?><?php echo ($ref->video_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->video_url->cellAttributes() ?>>
<span id="el_ref_video_url">
<input type="text" data-table="ref" data-field="x_video_url" data-page="5" name="x_video_url" id="x_video_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($ref->video_url->getPlaceHolder()) ?>" value="<?php echo $ref->video_url->EditValue ?>"<?php echo $ref->video_url->editAttributes() ?>>
</span>
<?php echo $ref->video_url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_ref_image" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->image->caption() ?><?php echo ($ref->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->image->cellAttributes() ?>>
<span id="el_ref_image">
<div id="fd_x_image">
<span title="<?php echo $ref->image->title() ? $ref->image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($ref->image->ReadOnly || $ref->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="ref" data-field="x_image" data-page="5" name="x_image" id="x_image" multiple="multiple"<?php echo $ref->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $ref->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="255">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $ref->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $ref->image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_image" id= "fc_x_image" value="<?php echo $ref->image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $ref->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $ref_edit->MultiPages->pageStyle("6") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_edit->MultiPages->isActive("6")) ?>" href="#tab_ref6"><?php echo $ref->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_edit->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $ref_edit->MultiPages->Parent ?>" id="tab_ref6"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($ref->last_price->Visible) { // last_price ?>
	<div id="r_last_price" class="form-group row">
		<label id="elh_ref_last_price" for="x_last_price" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->last_price->caption() ?><?php echo ($ref->last_price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->last_price->cellAttributes() ?>>
<span id="el_ref_last_price">
<span<?php echo $ref->last_price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ref->last_price->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="ref" data-field="x_last_price" data-page="6" name="x_last_price" id="x_last_price" value="<?php echo HtmlEncode($ref->last_price->CurrentValue) ?>">
<?php echo $ref->last_price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label id="elh_ref_currency" for="x_currency" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->currency->caption() ?><?php echo ($ref->currency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->currency->cellAttributes() ?>>
<span id="el_ref_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_currency" data-page="6" data-value-separator="<?php echo $ref->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $ref->currency->editAttributes() ?>>
		<?php echo $ref->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $ref->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
<?php echo $ref->currency->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->hsn->Visible) { // hsn ?>
	<div id="r_hsn" class="form-group row">
		<label id="elh_ref_hsn" for="x_hsn" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->hsn->caption() ?><?php echo ($ref->hsn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->hsn->cellAttributes() ?>>
<span id="el_ref_hsn">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_hsn" data-page="6" data-value-separator="<?php echo $ref->hsn->displayValueSeparatorAttribute() ?>" id="x_hsn" name="x_hsn"<?php echo $ref->hsn->editAttributes() ?>>
		<?php echo $ref->hsn->selectOptionListHtml("x_hsn") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "tax_category") && !$ref->hsn->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_hsn" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $ref->hsn->caption() ?>" data-title="<?php echo $ref->hsn->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_hsn',url:'tax_categoryaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $ref->hsn->Lookup->getParamTag("p_x_hsn") ?>
</span>
<?php echo $ref->hsn->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->composition->Visible) { // composition ?>
	<div id="r_composition" class="form-group row">
		<label id="elh_ref_composition" for="x_composition" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->composition->caption() ?><?php echo ($ref->composition->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->composition->cellAttributes() ?>>
<span id="el_ref_composition">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_composition" data-page="6" data-value-separator="<?php echo $ref->composition->displayValueSeparatorAttribute() ?>" id="x_composition" name="x_composition"<?php echo $ref->composition->editAttributes() ?>>
		<?php echo $ref->composition->selectOptionListHtml("x_composition") ?>
	</select>
</div>
<?php echo $ref->composition->Lookup->getParamTag("p_x_composition") ?>
</span>
<?php echo $ref->composition->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_ref_category" for="x_category" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->category->caption() ?><?php echo ($ref->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->category->cellAttributes() ?>>
<span id="el_ref_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_category" data-page="6" data-value-separator="<?php echo $ref->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $ref->category->editAttributes() ?>>
		<?php echo $ref->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $ref->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $ref->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->moq->Visible) { // moq ?>
	<div id="r_moq" class="form-group row">
		<label id="elh_ref_moq" for="x_moq" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->moq->caption() ?><?php echo ($ref->moq->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->moq->cellAttributes() ?>>
<span id="el_ref_moq">
<input type="text" data-table="ref" data-field="x_moq" data-page="6" name="x_moq" id="x_moq" size="30" placeholder="<?php echo HtmlEncode($ref->moq->getPlaceHolder()) ?>" value="<?php echo $ref->moq->EditValue ?>"<?php echo $ref->moq->editAttributes() ?>>
</span>
<?php echo $ref->moq->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_ref_status" for="x_status" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->status->caption() ?><?php echo ($ref->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->status->cellAttributes() ?>>
<span id="el_ref_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_status" data-page="6" data-value-separator="<?php echo $ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ref->status->editAttributes() ?>>
		<?php echo $ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $ref->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->publish->Visible) { // publish ?>
	<div id="r_publish" class="form-group row">
		<label id="elh_ref_publish" for="x_publish" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->publish->caption() ?><?php echo ($ref->publish->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->publish->cellAttributes() ?>>
<span id="el_ref_publish">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_publish" data-page="6" data-value-separator="<?php echo $ref->publish->displayValueSeparatorAttribute() ?>" id="x_publish" name="x_publish"<?php echo $ref->publish->editAttributes() ?>>
		<?php echo $ref->publish->selectOptionListHtml("x_publish") ?>
	</select>
</div>
</span>
<?php echo $ref->publish->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ref->keywords->Visible) { // keywords ?>
	<div id="r_keywords" class="form-group row">
		<label id="elh_ref_keywords" for="x_keywords" class="<?php echo $ref_edit->LeftColumnClass ?>"><?php echo $ref->keywords->caption() ?><?php echo ($ref->keywords->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ref_edit->RightColumnClass ?>"><div<?php echo $ref->keywords->cellAttributes() ?>>
<span id="el_ref_keywords">
<textarea data-table="ref" data-field="x_keywords" data-page="6" name="x_keywords" id="x_keywords" cols="35" rows="3" placeholder="<?php echo HtmlEncode($ref->keywords->getPlaceHolder()) ?>"<?php echo $ref->keywords->editAttributes() ?>><?php echo $ref->keywords->EditValue ?></textarea>
</span>
<?php echo $ref->keywords->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php
	if (in_array("multiple_price", explode(",", $ref->getCurrentDetailTable())) && $multiple_price->DetailEdit) {
?>
<?php if ($ref->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("multiple_price", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "multiple_pricegrid.php" ?>
<?php } ?>
<?php
	if (in_array("partner_product_ref", explode(",", $ref->getCurrentDetailTable())) && $partner_product_ref->DetailEdit) {
?>
<?php if ($ref->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("partner_product_ref", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "partner_product_refgrid.php" ?>
<?php } ?>
<?php if (!$ref_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ref_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ref_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ref_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");
// Write your table-specific startup script here
// document.write("page loaded");

		var SGrp = $("#x_s_grp").val();
		var product_type = $("#x_product_type").val();
		if (product_type == 8)
		{
		$("#r_set_ref").show();
		$("#r_v_00").hide();		
		$("#r_v_01").hide();
		$("#r_v_02").hide();
		$("#r_v_03").hide();
		$("#r_v_04").hide();
		$("#r_v_05").hide();
		$("#r_v_06").hide();
		$("#r_v_07").hide();
		$("#r_v_08").hide();
		$("#r_v_09").hide();
		$("#r_v_10").hide();
		} else {
		$("#r_set_ref").hide();
		}
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
			 		if (data.cbm == '--NA--') {
					$("#r_cbm").hide(); } else {
					$("#r_cbm").show();						
					$("#elh_ref_cbm").html(data.cbm);}
					if (data.sqm == '--NA--') {
					$("#r_sqm").hide(); } else {
					$("#r_sqm").show()					
					$("#elh_ref_sqm").html(data.sqm);}
					if (data.shape == '--NA--') {
					$("#r_shape").hide(); } else {
					$("#r_shape").show()					
					$("#elh_ref_shape").html(data.shape);}
					if (data.v_00 == '--NA--') {
					$("#r_v_00").hide(); } else {
					$("#r_v_00").show();					
					$("#elh_ref_v_00").html(data.v_00);}
					if (data.v_01 == '--NA--') {
					$("#sv_x_v_01").val('');
					$("#r_v_01").hide(); } else {
					$("#r_v_01").show();					
					$("#elh_ref_v_01").html(data.v_01);}
					if (data.v_02 == '--NA--') {
					$("#sv_x_v_02").val('');
					$("#r_v_02").hide(); } else {
					$("#r_v_02").show()					
					$("#elh_ref_v_02").html(data.v_02);}
					if (data.v_03 == '--NA--') {
					$("#sv_x_v_03").val('');
					$("#r_v_03").hide(); } else {
					$("#r_v_03").show()					
					$("#elh_ref_v_03").html(data.v_03);}
					if (data.v_04 == '--NA--') {
					$("#sv_x_v_04").val('');
					$("#r_v_04").hide(); } else {
					$("#r_v_04").show()		
					$("#elh_ref_v_04").html(data.v_04);}
					if (data.v_05 == '--NA--') {
					$("#sv_x_v_05").val('');
					$("#r_v_05").hide(); } else {
					$("#r_v_05").show();					
					$("#elh_ref_v_05").html(data.v_05);}
					if (data.v_06 == '--NA--') {
					$("#sv_x_v_06").val('');
					$("#r_v_06").hide(); } else {
					$("#r_v_06").show()		
					$("#elh_ref_v_06").html(data.v_06);}
					if (data.v_07 == '--NA--') {
					$("#sv_x_v_07").val('');
					$("#r_v_07").hide(); } else {						
					$("#r_v_07").show();
					$("#elh_ref_v_07").html(data.v_07);}
					if (data.v_08 == '--NA--') {
					$("#sv_x_v_08").val('');
					$("#r_v_08").hide(); } else {						
					$("#r_v_08").show();
					$("#elh_ref_v_08").html(data.v_08);}
					if (data.v_09 == '--NA--') {
					$("#sv_x_v_09").val('');
					$("#r_v_09").hide(); } else {						
					$("#r_v_09").show();
					$("#elh_ref_v_09").html(data.v_09);}
					if (data.v_10 == '--NA--') {
					$("#sv_x_v_10").val('');
					$("#r_v_10").hide(); } else {						
					$("#r_v_10").show();
					$("#elh_ref_v_10").html(data.v_10);}
					if (data.b_01_head == '--NA--') {
					$("#r_b_01").hide(); } else {
					$("#r_b_01").show();
					$("#elh_ref_b_01").html(data.b_01_head);}
					if (data.b_02_head == '--NA--') {
					$("#r_b_02").hide(); } else {
					$("#r_b_02").show();
					$("#elh_ref_b_02").html(data.b_02_head);}
					if (data.b_03_head == '--NA--') {
					$("#r_b_03").hide(); } else {
					$("#r_b_03").show();
					$("#elh_ref_b_03").html(data.b_03_head);}
					if (data.b_04_head == '--NA--') {
					$("#r_b_04").hide(); } else {
					$("#r_b_04").show();
					$("#elh_ref_b_04").html(data.b_04_head);}
					if (data.b_05_head == '--NA--') {
					$("#r_b_05").hide(); } else {
					$("#r_b_05").show();
					$("#elh_ref_b_05").html(data.b_05_head);}
					if (data.b_06_head == '--NA--') {
					$("#r_b_06").hide(); } else {
					$("#r_b_06").show();
					$("#elh_ref_b_06").html(data.b_06_head);}
					if (data.b_07_head == '--NA--') {
					$("#r_b_07").hide(); } else {
					$("#r_b_07").show();
					$("#elh_ref_b_07").html(data.b_07_head);}
					if (data.b_08_head == '--NA--') {
					$("#r_b_08").hide(); } else {
					$("#r_b_08").show();
					$("#elh_ref_b_08").html(data.b_08_head);}
					if (data.b_09_head == '--NA--') {
					$("#r_b_09").hide(); } else {
					$("#r_b_09").show();
					$("#elh_ref_b_09").html(data.b_09_head);}
					if (data.b_10_head == '--NA--') {
					$("#r_b_10").hide(); } else {
					$("#r_b_10").show();
					$("#elh_ref_b_10").html(data.b_10_head);}
					if (data.b_11_head == '--NA--') {
					$("#r_b_11").hide(); } else {
					$("#r_b_11").show();
					$("#elh_ref_b_11").html(data.b_11_head);}
					if (data.b_12_head == '--NA--') {
					$("#r_b_12").hide(); } else {
					$("#r_b_12").show();
					$("#elh_ref_b_12").html(data.b_12_head);}
					if (data.b_13_head == '--NA--') {
					$("#r_b_13").hide(); } else {
					$("#r_b_13").show();
					$("#elh_ref_b_13").html(data.b_13_head);}
					if (data.b_14_head == '--NA--') {
					$("#r_b_14").hide(); } else {
					$("#r_b_14").show();	
					$("#elh_ref_b_14").html(data.b_14_head);}
					if (data.b_15_head == '--NA--') {
					$("#r_b_15").hide(); } else {
					$("#r_b_15").show();
					$("#elh_ref_b_15").html(data.b_15_head);}
					if (data.q_sku == '--NA--') {
					$("#r_q_sku").hide(); } else {
					$("#r_q_sku").show();
					$("#elh_ref_q_sku").html(data.q_sku);}
					if (data.t_01_head == '--NA--') {
					$("#r_t_01").hide(); } else {
					$("#r_t_01").show();
					$("#elh_ref_t_01").html(data.t_01_head);}
					if (data.t_02_head == '--NA--') {
					$("#r_t_02").hide(); } else {
					$("#r_t_02").show();
					$("#elh_ref_t_02").html(data.t_02_head);}
					if (data.t_03_head == '--NA--') {
					$("#r_t_03").hide(); } else {
					$("#r_t_03").show();
					$("#elh_ref_t_03").html(data.t_03_head);}
					if (data.t_04_head == '--NA--') {
					$("#r_t_04").hide(); } else {
					$("#r_t_04").show();
					$("#elh_ref_t_04").html(data.t_04_head);}
					if (data.t_05_head == '--NA--') {
					$("#r_t_05").hide(); } else {
					$("#r_t_05").show();
					$("#elh_ref_t_05").html(data.t_05_head);}
					if (data.t_06_head == '--NA--') {
					$("#r_t_06").hide(); } else {
					$("#r_t_06").show();
					$("#elh_ref_t_06").html(data.t_06_head);}
					if (data.t_07_head == '--NA--') {
					$("#r_t_07").hide(); } else {
					$("#r_t_07").show();
					$("#elh_ref_t_07").html(data.t_07_head);}
					if (data.t_08_head == '--NA--') {
					$("#r_t_08").hide(); } else {
					$("#r_t_08").show();
					$("#elh_ref_t_08").html(data.t_08_head);}
					if (data.t_09_head == '--NA--') {
					$("#r_t_09").hide(); } else {
					$("#r_t_09").show();
					$("#elh_ref_t_09").html(data.t_09_head);}
					if (data.t_10_head == '--NA--') {
					$("#r_t_10").hide(); } else {
					$("#r_t_10").show();
					$("#elh_ref_t_10").html(data.t_10_head);}
					if (data.t_11_head == '--NA--') {
					$("#r_t_11").hide(); } else {
					$("#r_t_11").show();
					$("#elh_ref_t_11").html(data.t_11_head);}
					if (data.t_12_head == '--NA--') {
					$("#r_t_12").hide(); } else {
					$("#r_t_12").show();
					$("#elh_ref_t_12").html(data.t_12_head);}
					if (data.t_13_head == '--NA--') {
					$("#r_t_13").hide(); } else {
					$("#r_t_13").show();
					$("#elh_ref_t_13").html(data.t_13_head);}
					if (data.t_14_head == '--NA--') {
					$("#r_t_14").hide(); } else {
					$("#r_t_14").show();
					$("#elh_ref_t_14").html(data.t_14_head);}
					if (data.t_15_head == '--NA--') {
					$("#r_t_15").hide(); } else {
					$("#r_t_15").show();
					$("#elh_ref_t_15").html(data.t_15_head);}
					if (data.calculation_method == 1) {
					var lastprice = 'Current Price / SQM';
					} else if (data.calculation_method == 2) {
					var lastprice = 'Current Price / SKU';
					}
					$("#elh_ref_last_price").html(lastprice);
		});
		}
			var	type = $("#x_product_code_type").val();
			if ((type == 0))
			{
				$("#x_product_code").attr('readonly','readonly')
			}
			else
			{
				$("#x_product_code").removeAttr('readonly')
			}
			var	product_type = $("#x_product_type").val();			
			if ((product_type == 8))
			{
				$("#r_set_ref").show();
			}
			else
			{
				$("#x_set_ref").val('');	
				$("#r_set_ref").hide();
			}
</script>
<?php include_once "footer.php" ?>
<?php
$ref_edit->terminate();
?>