<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_list = new ref_list();

// Run the page
$ref_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ref->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var freflist = currentForm = new ew.Form("freflist", "list");
freflist.formKeyCountName = '<?php echo $ref_list->FormKeyCountName ?>';

// Form_CustomValidate event
freflist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freflist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freflist.lists["x_grp"] = <?php echo $ref_list->grp->Lookup->toClientList() ?>;
freflist.lists["x_grp"].options = <?php echo JsonEncode($ref_list->grp->lookupOptions()) ?>;
freflist.lists["x_s_grp"] = <?php echo $ref_list->s_grp->Lookup->toClientList() ?>;
freflist.lists["x_s_grp"].options = <?php echo JsonEncode($ref_list->s_grp->lookupOptions()) ?>;
freflist.lists["x_product"] = <?php echo $ref_list->product->Lookup->toClientList() ?>;
freflist.lists["x_product"].options = <?php echo JsonEncode($ref_list->product->lookupOptions()) ?>;
freflist.lists["x_packing_type"] = <?php echo $ref_list->packing_type->Lookup->toClientList() ?>;
freflist.lists["x_packing_type"].options = <?php echo JsonEncode($ref_list->packing_type->lookupOptions()) ?>;
freflist.lists["x_product_code_type"] = <?php echo $ref_list->product_code_type->Lookup->toClientList() ?>;
freflist.lists["x_product_code_type"].options = <?php echo JsonEncode($ref_list->product_code_type->options(FALSE, TRUE)) ?>;
freflist.lists["x_composition"] = <?php echo $ref_list->composition->Lookup->toClientList() ?>;
freflist.lists["x_composition"].options = <?php echo JsonEncode($ref_list->composition->lookupOptions()) ?>;
freflist.lists["x_category"] = <?php echo $ref_list->category->Lookup->toClientList() ?>;
freflist.lists["x_category"].options = <?php echo JsonEncode($ref_list->category->lookupOptions()) ?>;
freflist.lists["x_status"] = <?php echo $ref_list->status->Lookup->toClientList() ?>;
freflist.lists["x_status"].options = <?php echo JsonEncode($ref_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var freflistsrch = currentSearchForm = new ew.Form("freflistsrch");

// Validate function for search
freflistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
freflistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freflistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freflistsrch.lists["x_grp"] = <?php echo $ref_list->grp->Lookup->toClientList() ?>;
freflistsrch.lists["x_grp"].options = <?php echo JsonEncode($ref_list->grp->lookupOptions()) ?>;
freflistsrch.lists["x_s_grp"] = <?php echo $ref_list->s_grp->Lookup->toClientList() ?>;
freflistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($ref_list->s_grp->lookupOptions()) ?>;
freflistsrch.lists["x_product"] = <?php echo $ref_list->product->Lookup->toClientList() ?>;
freflistsrch.lists["x_product"].options = <?php echo JsonEncode($ref_list->product->lookupOptions()) ?>;
freflistsrch.lists["x_status"] = <?php echo $ref_list->status->Lookup->toClientList() ?>;
freflistsrch.lists["x_status"].options = <?php echo JsonEncode($ref_list->status->options(FALSE, TRUE)) ?>;

// Filters
freflistsrch.filterList = <?php echo $ref_list->getFilterList() ?>;

// Init search panel as collapsed
freflistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ref_list->TotalRecs > 0 && $ref_list->ExportOptions->visible()) { ?>
<?php $ref_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ref_list->ImportOptions->visible()) { ?>
<?php $ref_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ref_list->SearchOptions->visible()) { ?>
<?php $ref_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ref_list->FilterOptions->visible()) { ?>
<?php $ref_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ref_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ref->isExport() && !$ref->CurrentAction) { ?>
<form name="freflistsrch" id="freflistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($ref_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="freflistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ref">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$ref_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$ref->RowType = ROWTYPE_SEARCH;

// Render row
$ref->resetAttributes();
$ref_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($ref->id->Visible) { // id ?>
	<div id="xsc_id" class="ew-cell form-group">
		<label for="x_id" class="ew-search-caption ew-label"><?php echo $ref->id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="ref" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($ref->id->getPlaceHolder()) ?>" value="<?php echo $ref->id->EditValue ?>"<?php echo $ref->id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($ref->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $ref->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $ref->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_grp" data-value-separator="<?php echo $ref->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref->grp->editAttributes() ?>>
		<?php echo $ref->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $ref->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($ref->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $ref->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<?php $ref->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_s_grp" data-value-separator="<?php echo $ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref->s_grp->editAttributes() ?>>
		<?php echo $ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($ref->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $ref->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product" data-value-separator="<?php echo $ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref->product->editAttributes() ?>>
		<?php echo $ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $ref->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($ref->product_n->Visible) { // product_n ?>
	<div id="xsc_product_n" class="ew-cell form-group">
		<label for="x_product_n" class="ew-search-caption ew-label"><?php echo $ref->product_n->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_n" id="z_product_n" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="ref" data-field="x_product_n" name="x_product_n" id="x_product_n" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->product_n->getPlaceHolder()) ?>" value="<?php echo $ref->product_n->EditValue ?>"<?php echo $ref->product_n->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($ref->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $ref->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="ref" data-field="x_product_code" name="x_product_code" id="x_product_code" maxlength="96" placeholder="<?php echo HtmlEncode($ref->product_code->getPlaceHolder()) ?>" value="<?php echo $ref->product_code->EditValue ?>"<?php echo $ref->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($ref->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $ref->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_status" data-value-separator="<?php echo $ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ref->status->editAttributes() ?>>
		<?php echo $ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($ref_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($ref_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ref_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ref_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ref_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ref_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ref_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $ref_list->showPageHeader(); ?>
<?php
$ref_list->showMessage();
?>
<?php if ($ref_list->TotalRecs > 0 || $ref->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ref_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ref">
<?php if (!$ref->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$ref->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ref_list->Pager)) $ref_list->Pager = new PrevNextPager($ref_list->StartRec, $ref_list->DisplayRecs, $ref_list->TotalRecs, $ref_list->AutoHidePager) ?>
<?php if ($ref_list->Pager->RecordCount > 0 && $ref_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ref_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ref_list->pageUrl() ?>start=<?php echo $ref_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ref_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ref_list->pageUrl() ?>start=<?php echo $ref_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ref_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ref_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ref_list->pageUrl() ?>start=<?php echo $ref_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ref_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ref_list->pageUrl() ?>start=<?php echo $ref_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ref_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ref_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ref_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ref_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ref_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ref_list->TotalRecs > 0 && (!$ref_list->AutoHidePageSizeSelector || $ref_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ref">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ref_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ref_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ref_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ref_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ref_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ref->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ref_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="freflist" id="freflist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref">
<div id="gmp_ref" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($ref_list->TotalRecs > 0 || $ref->isGridEdit()) { ?>
<table id="tbl_reflist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ref_list->RowType = ROWTYPE_HEADER;

// Render list options
$ref_list->renderListOptions();

// Render list options (header, left)
$ref_list->ListOptions->render("header", "left");
?>
<?php if ($ref->id->Visible) { // id ?>
	<?php if ($ref->sortUrl($ref->id) == "") { ?>
		<th data-name="id" class="<?php echo $ref->id->headerCellClass() ?>"><div id="elh_ref_id" class="ref_id"><div class="ew-table-header-caption"><?php echo $ref->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $ref->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->id) ?>',2);"><div id="elh_ref_id" class="ref_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->grp->Visible) { // grp ?>
	<?php if ($ref->sortUrl($ref->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $ref->grp->headerCellClass() ?>"><div id="elh_ref_grp" class="ref_grp"><div class="ew-table-header-caption"><?php echo $ref->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $ref->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->grp) ?>',2);"><div id="elh_ref_grp" class="ref_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->s_grp->Visible) { // s_grp ?>
	<?php if ($ref->sortUrl($ref->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $ref->s_grp->headerCellClass() ?>"><div id="elh_ref_s_grp" class="ref_s_grp"><div class="ew-table-header-caption"><?php echo $ref->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $ref->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->s_grp) ?>',2);"><div id="elh_ref_s_grp" class="ref_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->product->Visible) { // product ?>
	<?php if ($ref->sortUrl($ref->product) == "") { ?>
		<th data-name="product" class="<?php echo $ref->product->headerCellClass() ?>"><div id="elh_ref_product" class="ref_product"><div class="ew-table-header-caption"><?php echo $ref->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $ref->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->product) ?>',2);"><div id="elh_ref_product" class="ref_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->packing_type->Visible) { // packing_type ?>
	<?php if ($ref->sortUrl($ref->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $ref->packing_type->headerCellClass() ?>"><div id="elh_ref_packing_type" class="ref_packing_type"><div class="ew-table-header-caption"><?php echo $ref->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $ref->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->packing_type) ?>',2);"><div id="elh_ref_packing_type" class="ref_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->product_n->Visible) { // product_n ?>
	<?php if ($ref->sortUrl($ref->product_n) == "") { ?>
		<th data-name="product_n" class="<?php echo $ref->product_n->headerCellClass() ?>"><div id="elh_ref_product_n" class="ref_product_n"><div class="ew-table-header-caption"><?php echo $ref->product_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_n" class="<?php echo $ref->product_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->product_n) ?>',2);"><div id="elh_ref_product_n" class="ref_product_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->product_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref->product_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->product_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->product_code_type->Visible) { // product_code_type ?>
	<?php if ($ref->sortUrl($ref->product_code_type) == "") { ?>
		<th data-name="product_code_type" class="<?php echo $ref->product_code_type->headerCellClass() ?>"><div id="elh_ref_product_code_type" class="ref_product_code_type"><div class="ew-table-header-caption"><?php echo $ref->product_code_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code_type" class="<?php echo $ref->product_code_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->product_code_type) ?>',2);"><div id="elh_ref_product_code_type" class="ref_product_code_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->product_code_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->product_code_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->product_code_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->product_code->Visible) { // product_code ?>
	<?php if ($ref->sortUrl($ref->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $ref->product_code->headerCellClass() ?>"><div id="elh_ref_product_code" class="ref_product_code"><div class="ew-table-header-caption"><?php echo $ref->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $ref->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->product_code) ?>',2);"><div id="elh_ref_product_code" class="ref_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->v_00->Visible) { // v_00 ?>
	<?php if ($ref->sortUrl($ref->v_00) == "") { ?>
		<th data-name="v_00" class="<?php echo $ref->v_00->headerCellClass() ?>"><div id="elh_ref_v_00" class="ref_v_00"><div class="ew-table-header-caption"><?php echo $ref->v_00->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_00" class="<?php echo $ref->v_00->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->v_00) ?>',2);"><div id="elh_ref_v_00" class="ref_v_00">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->v_00->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref->v_00->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->v_00->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->q_sku->Visible) { // q_sku ?>
	<?php if ($ref->sortUrl($ref->q_sku) == "") { ?>
		<th data-name="q_sku" class="<?php echo $ref->q_sku->headerCellClass() ?>"><div id="elh_ref_q_sku" class="ref_q_sku"><div class="ew-table-header-caption"><?php echo $ref->q_sku->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="q_sku" class="<?php echo $ref->q_sku->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->q_sku) ?>',2);"><div id="elh_ref_q_sku" class="ref_q_sku">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->q_sku->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->q_sku->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->q_sku->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->group_image->Visible) { // group_image ?>
	<?php if ($ref->sortUrl($ref->group_image) == "") { ?>
		<th data-name="group_image" class="<?php echo $ref->group_image->headerCellClass() ?>"><div id="elh_ref_group_image" class="ref_group_image"><div class="ew-table-header-caption"><?php echo $ref->group_image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="group_image" class="<?php echo $ref->group_image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->group_image) ?>',2);"><div id="elh_ref_group_image" class="ref_group_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->group_image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref->group_image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->group_image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->composition->Visible) { // composition ?>
	<?php if ($ref->sortUrl($ref->composition) == "") { ?>
		<th data-name="composition" class="<?php echo $ref->composition->headerCellClass() ?>"><div id="elh_ref_composition" class="ref_composition"><div class="ew-table-header-caption"><?php echo $ref->composition->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="composition" class="<?php echo $ref->composition->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->composition) ?>',2);"><div id="elh_ref_composition" class="ref_composition">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->composition->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->composition->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->composition->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->category->Visible) { // category ?>
	<?php if ($ref->sortUrl($ref->category) == "") { ?>
		<th data-name="category" class="<?php echo $ref->category->headerCellClass() ?>"><div id="elh_ref_category" class="ref_category"><div class="ew-table-header-caption"><?php echo $ref->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $ref->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->category) ?>',2);"><div id="elh_ref_category" class="ref_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->status->Visible) { // status ?>
	<?php if ($ref->sortUrl($ref->status) == "") { ?>
		<th data-name="status" class="<?php echo $ref->status->headerCellClass() ?>"><div id="elh_ref_status" class="ref_status"><div class="ew-table-header-caption"><?php echo $ref->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $ref->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->status) ?>',2);"><div id="elh_ref_status" class="ref_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($ref->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ref->keywords->Visible) { // keywords ?>
	<?php if ($ref->sortUrl($ref->keywords) == "") { ?>
		<th data-name="keywords" class="<?php echo $ref->keywords->headerCellClass() ?>"><div id="elh_ref_keywords" class="ref_keywords"><div class="ew-table-header-caption"><?php echo $ref->keywords->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="keywords" class="<?php echo $ref->keywords->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ref->SortUrl($ref->keywords) ?>',2);"><div id="elh_ref_keywords" class="ref_keywords">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ref->keywords->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ref->keywords->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ref->keywords->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ref_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ref->ExportAll && $ref->isExport()) {
	$ref_list->StopRec = $ref_list->TotalRecs;
} else {

	// Set the last record to display
	if ($ref_list->TotalRecs > $ref_list->StartRec + $ref_list->DisplayRecs - 1)
		$ref_list->StopRec = $ref_list->StartRec + $ref_list->DisplayRecs - 1;
	else
		$ref_list->StopRec = $ref_list->TotalRecs;
}
$ref_list->RecCnt = $ref_list->StartRec - 1;
if ($ref_list->Recordset && !$ref_list->Recordset->EOF) {
	$ref_list->Recordset->moveFirst();
	$selectLimit = $ref_list->UseSelectLimit;
	if (!$selectLimit && $ref_list->StartRec > 1)
		$ref_list->Recordset->move($ref_list->StartRec - 1);
} elseif (!$ref->AllowAddDeleteRow && $ref_list->StopRec == 0) {
	$ref_list->StopRec = $ref->GridAddRowCount;
}

// Initialize aggregate
$ref->RowType = ROWTYPE_AGGREGATEINIT;
$ref->resetAttributes();
$ref_list->renderRow();
while ($ref_list->RecCnt < $ref_list->StopRec) {
	$ref_list->RecCnt++;
	if ($ref_list->RecCnt >= $ref_list->StartRec) {
		$ref_list->RowCnt++;

		// Set up key count
		$ref_list->KeyCount = $ref_list->RowIndex;

		// Init row class and style
		$ref->resetAttributes();
		$ref->CssClass = "";
		if ($ref->isGridAdd()) {
		} else {
			$ref_list->loadRowValues($ref_list->Recordset); // Load row values
		}
		$ref->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ref->RowAttrs = array_merge($ref->RowAttrs, array('data-rowindex'=>$ref_list->RowCnt, 'id'=>'r' . $ref_list->RowCnt . '_ref', 'data-rowtype'=>$ref->RowType));

		// Render row
		$ref_list->renderRow();

		// Render list options
		$ref_list->renderListOptions();
?>
	<tr<?php echo $ref->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ref_list->ListOptions->render("body", "left", $ref_list->RowCnt);
?>
	<?php if ($ref->id->Visible) { // id ?>
		<td data-name="id"<?php echo $ref->id->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_id" class="ref_id">
<span<?php echo $ref->id->viewAttributes() ?>>
<?php echo $ref->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $ref->grp->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_grp" class="ref_grp">
<span<?php echo $ref->grp->viewAttributes() ?>>
<?php echo $ref->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $ref->s_grp->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_s_grp" class="ref_s_grp">
<span<?php echo $ref->s_grp->viewAttributes() ?>>
<?php echo $ref->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->product->Visible) { // product ?>
		<td data-name="product"<?php echo $ref->product->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_product" class="ref_product">
<span<?php echo $ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref->product->getViewValue())) && $ref->product->linkAttributes() <> "") { ?>
<a<?php echo $ref->product->linkAttributes() ?>><?php echo $ref->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $ref->packing_type->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_packing_type" class="ref_packing_type">
<span<?php echo $ref->packing_type->viewAttributes() ?>>
<?php echo $ref->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->product_n->Visible) { // product_n ?>
		<td data-name="product_n"<?php echo $ref->product_n->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_product_n" class="ref_product_n">
<span<?php echo $ref->product_n->viewAttributes() ?>>
<?php echo $ref->product_n->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->product_code_type->Visible) { // product_code_type ?>
		<td data-name="product_code_type"<?php echo $ref->product_code_type->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_product_code_type" class="ref_product_code_type">
<span<?php echo $ref->product_code_type->viewAttributes() ?>>
<?php echo $ref->product_code_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $ref->product_code->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_product_code" class="ref_product_code">
<span<?php echo $ref->product_code->viewAttributes() ?>>
<?php echo $ref->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->v_00->Visible) { // v_00 ?>
		<td data-name="v_00"<?php echo $ref->v_00->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_v_00" class="ref_v_00">
<span<?php echo $ref->v_00->viewAttributes() ?>>
<?php echo $ref->v_00->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->q_sku->Visible) { // q_sku ?>
		<td data-name="q_sku"<?php echo $ref->q_sku->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_q_sku" class="ref_q_sku">
<span<?php echo $ref->q_sku->viewAttributes() ?>>
<?php echo $ref->q_sku->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->group_image->Visible) { // group_image ?>
		<td data-name="group_image"<?php echo $ref->group_image->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_group_image" class="ref_group_image">
<span<?php echo $ref->group_image->viewAttributes() ?>>
<?php echo GetFileViewTag($ref->group_image, $ref->group_image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->composition->Visible) { // composition ?>
		<td data-name="composition"<?php echo $ref->composition->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_composition" class="ref_composition">
<span<?php echo $ref->composition->viewAttributes() ?>>
<?php echo $ref->composition->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->category->Visible) { // category ?>
		<td data-name="category"<?php echo $ref->category->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_category" class="ref_category">
<span<?php echo $ref->category->viewAttributes() ?>>
<?php echo $ref->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->status->Visible) { // status ?>
		<td data-name="status"<?php echo $ref->status->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_status" class="ref_status">
<span<?php echo $ref->status->viewAttributes() ?>>
<?php echo $ref->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ref->keywords->Visible) { // keywords ?>
		<td data-name="keywords"<?php echo $ref->keywords->cellAttributes() ?>>
<span id="el<?php echo $ref_list->RowCnt ?>_ref_keywords" class="ref_keywords">
<span<?php echo $ref->keywords->viewAttributes() ?>>
<?php echo $ref->keywords->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ref_list->ListOptions->render("body", "right", $ref_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$ref->isGridAdd())
		$ref_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$ref->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ref_list->Recordset)
	$ref_list->Recordset->Close();
?>
<?php if (!$ref->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ref->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ref_list->Pager)) $ref_list->Pager = new PrevNextPager($ref_list->StartRec, $ref_list->DisplayRecs, $ref_list->TotalRecs, $ref_list->AutoHidePager) ?>
<?php if ($ref_list->Pager->RecordCount > 0 && $ref_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ref_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ref_list->pageUrl() ?>start=<?php echo $ref_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ref_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ref_list->pageUrl() ?>start=<?php echo $ref_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ref_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ref_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ref_list->pageUrl() ?>start=<?php echo $ref_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ref_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ref_list->pageUrl() ?>start=<?php echo $ref_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ref_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ref_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ref_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ref_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ref_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ref_list->TotalRecs > 0 && (!$ref_list->AutoHidePageSizeSelector || $ref_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ref">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ref_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ref_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ref_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ref_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ref_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ref->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ref_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ref_list->TotalRecs == 0 && !$ref->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ref_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ref_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ref->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$ref->isExport()) { ?>
<script>
ew.scrollableTable("gmp_ref", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ref_list->terminate();
?>