<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_search = new ref_search();

// Run the page
$ref_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($ref_search->IsModal) { ?>
var frefsearch = currentAdvancedSearchForm = new ew.Form("frefsearch", "search");
<?php } else { ?>
var frefsearch = currentForm = new ew.Form("frefsearch", "search");
<?php } ?>

// Form_CustomValidate event
frefsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frefsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
frefsearch.multiPage = new ew.MultiPage("frefsearch");

// Dynamic selection lists
frefsearch.lists["x_company_id[]"] = <?php echo $ref_search->company_id->Lookup->toClientList() ?>;
frefsearch.lists["x_company_id[]"].options = <?php echo JsonEncode($ref_search->company_id->lookupOptions()) ?>;
frefsearch.lists["x_grp"] = <?php echo $ref_search->grp->Lookup->toClientList() ?>;
frefsearch.lists["x_grp"].options = <?php echo JsonEncode($ref_search->grp->lookupOptions()) ?>;
frefsearch.lists["x_s_grp"] = <?php echo $ref_search->s_grp->Lookup->toClientList() ?>;
frefsearch.lists["x_s_grp"].options = <?php echo JsonEncode($ref_search->s_grp->lookupOptions()) ?>;
frefsearch.lists["x_product"] = <?php echo $ref_search->product->Lookup->toClientList() ?>;
frefsearch.lists["x_product"].options = <?php echo JsonEncode($ref_search->product->lookupOptions()) ?>;
frefsearch.lists["x_product_type"] = <?php echo $ref_search->product_type->Lookup->toClientList() ?>;
frefsearch.lists["x_product_type"].options = <?php echo JsonEncode($ref_search->product_type->lookupOptions()) ?>;
frefsearch.lists["x_packing_type"] = <?php echo $ref_search->packing_type->Lookup->toClientList() ?>;
frefsearch.lists["x_packing_type"].options = <?php echo JsonEncode($ref_search->packing_type->lookupOptions()) ?>;
frefsearch.lists["x_product_code_type"] = <?php echo $ref_search->product_code_type->Lookup->toClientList() ?>;
frefsearch.lists["x_product_code_type"].options = <?php echo JsonEncode($ref_search->product_code_type->options(FALSE, TRUE)) ?>;
frefsearch.lists["x_v_01"] = <?php echo $ref_search->v_01->Lookup->toClientList() ?>;
frefsearch.lists["x_v_01"].options = <?php echo JsonEncode($ref_search->v_01->lookupOptions()) ?>;
frefsearch.lists["x_v_02"] = <?php echo $ref_search->v_02->Lookup->toClientList() ?>;
frefsearch.lists["x_v_02"].options = <?php echo JsonEncode($ref_search->v_02->lookupOptions()) ?>;
frefsearch.lists["x_v_03"] = <?php echo $ref_search->v_03->Lookup->toClientList() ?>;
frefsearch.lists["x_v_03"].options = <?php echo JsonEncode($ref_search->v_03->lookupOptions()) ?>;
frefsearch.lists["x_v_04"] = <?php echo $ref_search->v_04->Lookup->toClientList() ?>;
frefsearch.lists["x_v_04"].options = <?php echo JsonEncode($ref_search->v_04->lookupOptions()) ?>;
frefsearch.lists["x_v_05"] = <?php echo $ref_search->v_05->Lookup->toClientList() ?>;
frefsearch.lists["x_v_05"].options = <?php echo JsonEncode($ref_search->v_05->lookupOptions()) ?>;
frefsearch.lists["x_v_06"] = <?php echo $ref_search->v_06->Lookup->toClientList() ?>;
frefsearch.lists["x_v_06"].options = <?php echo JsonEncode($ref_search->v_06->lookupOptions()) ?>;
frefsearch.lists["x_v_07"] = <?php echo $ref_search->v_07->Lookup->toClientList() ?>;
frefsearch.lists["x_v_07"].options = <?php echo JsonEncode($ref_search->v_07->lookupOptions()) ?>;
frefsearch.lists["x_v_08"] = <?php echo $ref_search->v_08->Lookup->toClientList() ?>;
frefsearch.lists["x_v_08"].options = <?php echo JsonEncode($ref_search->v_08->lookupOptions()) ?>;
frefsearch.lists["x_v_09"] = <?php echo $ref_search->v_09->Lookup->toClientList() ?>;
frefsearch.lists["x_v_09"].options = <?php echo JsonEncode($ref_search->v_09->lookupOptions()) ?>;
frefsearch.lists["x_v_10"] = <?php echo $ref_search->v_10->Lookup->toClientList() ?>;
frefsearch.lists["x_v_10"].options = <?php echo JsonEncode($ref_search->v_10->lookupOptions()) ?>;
frefsearch.lists["x_b_03[]"] = <?php echo $ref_search->b_03->Lookup->toClientList() ?>;
frefsearch.lists["x_b_03[]"].options = <?php echo JsonEncode($ref_search->b_03->lookupOptions()) ?>;
frefsearch.lists["x_b_04[]"] = <?php echo $ref_search->b_04->Lookup->toClientList() ?>;
frefsearch.lists["x_b_04[]"].options = <?php echo JsonEncode($ref_search->b_04->lookupOptions()) ?>;
frefsearch.lists["x_b_05[]"] = <?php echo $ref_search->b_05->Lookup->toClientList() ?>;
frefsearch.lists["x_b_05[]"].options = <?php echo JsonEncode($ref_search->b_05->lookupOptions()) ?>;
frefsearch.lists["x_b_06[]"] = <?php echo $ref_search->b_06->Lookup->toClientList() ?>;
frefsearch.lists["x_b_06[]"].options = <?php echo JsonEncode($ref_search->b_06->lookupOptions()) ?>;
frefsearch.lists["x_b_07[]"] = <?php echo $ref_search->b_07->Lookup->toClientList() ?>;
frefsearch.lists["x_b_07[]"].options = <?php echo JsonEncode($ref_search->b_07->lookupOptions()) ?>;
frefsearch.lists["x_b_08[]"] = <?php echo $ref_search->b_08->Lookup->toClientList() ?>;
frefsearch.lists["x_b_08[]"].options = <?php echo JsonEncode($ref_search->b_08->lookupOptions()) ?>;
frefsearch.lists["x_b_09[]"] = <?php echo $ref_search->b_09->Lookup->toClientList() ?>;
frefsearch.lists["x_b_09[]"].options = <?php echo JsonEncode($ref_search->b_09->lookupOptions()) ?>;
frefsearch.lists["x_b_10[]"] = <?php echo $ref_search->b_10->Lookup->toClientList() ?>;
frefsearch.lists["x_b_10[]"].options = <?php echo JsonEncode($ref_search->b_10->lookupOptions()) ?>;
frefsearch.lists["x_t_03[]"] = <?php echo $ref_search->t_03->Lookup->toClientList() ?>;
frefsearch.lists["x_t_03[]"].options = <?php echo JsonEncode($ref_search->t_03->lookupOptions()) ?>;
frefsearch.lists["x_t_04[]"] = <?php echo $ref_search->t_04->Lookup->toClientList() ?>;
frefsearch.lists["x_t_04[]"].options = <?php echo JsonEncode($ref_search->t_04->lookupOptions()) ?>;
frefsearch.lists["x_t_05[]"] = <?php echo $ref_search->t_05->Lookup->toClientList() ?>;
frefsearch.lists["x_t_05[]"].options = <?php echo JsonEncode($ref_search->t_05->lookupOptions()) ?>;
frefsearch.lists["x_t_06[]"] = <?php echo $ref_search->t_06->Lookup->toClientList() ?>;
frefsearch.lists["x_t_06[]"].options = <?php echo JsonEncode($ref_search->t_06->lookupOptions()) ?>;
frefsearch.lists["x_t_07[]"] = <?php echo $ref_search->t_07->Lookup->toClientList() ?>;
frefsearch.lists["x_t_07[]"].options = <?php echo JsonEncode($ref_search->t_07->lookupOptions()) ?>;
frefsearch.lists["x_t_08[]"] = <?php echo $ref_search->t_08->Lookup->toClientList() ?>;
frefsearch.lists["x_t_08[]"].options = <?php echo JsonEncode($ref_search->t_08->lookupOptions()) ?>;
frefsearch.lists["x_t_09[]"] = <?php echo $ref_search->t_09->Lookup->toClientList() ?>;
frefsearch.lists["x_t_09[]"].options = <?php echo JsonEncode($ref_search->t_09->lookupOptions()) ?>;
frefsearch.lists["x_t_10[]"] = <?php echo $ref_search->t_10->Lookup->toClientList() ?>;
frefsearch.lists["x_t_10[]"].options = <?php echo JsonEncode($ref_search->t_10->lookupOptions()) ?>;
frefsearch.lists["x_t_11"] = <?php echo $ref_search->t_11->Lookup->toClientList() ?>;
frefsearch.lists["x_t_11"].options = <?php echo JsonEncode($ref_search->t_11->lookupOptions()) ?>;
frefsearch.autoSuggests["x_t_11"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frefsearch.lists["x_t_12"] = <?php echo $ref_search->t_12->Lookup->toClientList() ?>;
frefsearch.lists["x_t_12"].options = <?php echo JsonEncode($ref_search->t_12->lookupOptions()) ?>;
frefsearch.autoSuggests["x_t_12"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frefsearch.lists["x_currency"] = <?php echo $ref_search->currency->Lookup->toClientList() ?>;
frefsearch.lists["x_currency"].options = <?php echo JsonEncode($ref_search->currency->lookupOptions()) ?>;
frefsearch.lists["x_hsn"] = <?php echo $ref_search->hsn->Lookup->toClientList() ?>;
frefsearch.lists["x_hsn"].options = <?php echo JsonEncode($ref_search->hsn->lookupOptions()) ?>;
frefsearch.lists["x_composition"] = <?php echo $ref_search->composition->Lookup->toClientList() ?>;
frefsearch.lists["x_composition"].options = <?php echo JsonEncode($ref_search->composition->lookupOptions()) ?>;
frefsearch.lists["x_category"] = <?php echo $ref_search->category->Lookup->toClientList() ?>;
frefsearch.lists["x_category"].options = <?php echo JsonEncode($ref_search->category->lookupOptions()) ?>;
frefsearch.lists["x_status"] = <?php echo $ref_search->status->Lookup->toClientList() ?>;
frefsearch.lists["x_status"].options = <?php echo JsonEncode($ref_search->status->options(FALSE, TRUE)) ?>;
frefsearch.lists["x_operator"] = <?php echo $ref_search->operator->Lookup->toClientList() ?>;
frefsearch.lists["x_operator"].options = <?php echo JsonEncode($ref_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

frefsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_q_sku");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref->q_sku->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_last_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref->last_price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_moq");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ref->moq->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ref_search->showPageHeader(); ?>
<?php
$ref_search->showMessage();
?>
<form name="frefsearch" id="frefsearch" class="<?php echo $ref_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$ref_search->IsModal ?>">
<?php if ($ref_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($ref->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_id"><?php echo $ref->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->id->cellAttributes() ?>>
			<span id="el_ref_id">
<input type="text" data-table="ref" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($ref->id->getPlaceHolder()) ?>" value="<?php echo $ref->id->EditValue ?>"<?php echo $ref->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_company_id"><?php echo $ref->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->company_id->cellAttributes() ?>>
			<span id="el_ref_company_id">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_company_id"><?php echo strval($ref->company_id->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($ref->company_id->AdvancedSearch->ViewValue) : $ref->company_id->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($ref->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($ref->company_id->ReadOnly || $ref->company_id->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_company_id[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $ref->company_id->Lookup->getParamTag("p_x_company_id") ?>
<input type="hidden" data-table="ref" data-field="x_company_id" data-page="0" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $ref->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id[]" id="x_company_id[]" value="<?php echo $ref->company_id->AdvancedSearch->SearchValue ?>"<?php echo $ref->company_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_grp"><?php echo $ref->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->grp->cellAttributes() ?>>
			<span id="el_ref_grp">
<?php $ref->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_grp" data-page="0" data-value-separator="<?php echo $ref->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $ref->grp->editAttributes() ?>>
		<?php echo $ref->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $ref->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_s_grp"><?php echo $ref->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->s_grp->cellAttributes() ?>>
			<span id="el_ref_s_grp">
<?php $ref->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$ref->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_s_grp" data-page="0" data-value-separator="<?php echo $ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $ref->s_grp->editAttributes() ?>>
		<?php echo $ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_product"><?php echo $ref->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->product->cellAttributes() ?>>
			<span id="el_ref_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product" data-page="0" data-value-separator="<?php echo $ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $ref->product->editAttributes() ?>>
		<?php echo $ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $ref->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_product_type"><?php echo $ref->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_type" id="z_product_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->product_type->cellAttributes() ?>>
			<span id="el_ref_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product_type" data-page="0" data-value-separator="<?php echo $ref->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $ref->product_type->editAttributes() ?>>
		<?php echo $ref->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $ref->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_packing_type"><?php echo $ref->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->packing_type->cellAttributes() ?>>
			<span id="el_ref_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_packing_type" data-page="0" data-value-separator="<?php echo $ref->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $ref->packing_type->editAttributes() ?>>
		<?php echo $ref->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $ref->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->product_n->Visible) { // product_n ?>
	<div id="r_product_n" class="form-group row">
		<label for="x_product_n" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_product_n"><?php echo $ref->product_n->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_n" id="z_product_n" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->product_n->cellAttributes() ?>>
			<span id="el_ref_product_n">
<input type="text" data-table="ref" data-field="x_product_n" data-page="0" name="x_product_n" id="x_product_n" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->product_n->getPlaceHolder()) ?>" value="<?php echo $ref->product_n->EditValue ?>"<?php echo $ref->product_n->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->product_code_type->Visible) { // product_code_type ?>
	<div id="r_product_code_type" class="form-group row">
		<label for="x_product_code_type" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_product_code_type"><?php echo $ref->product_code_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_code_type" id="z_product_code_type" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->product_code_type->cellAttributes() ?>>
			<span id="el_ref_product_code_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_product_code_type" data-page="0" data-value-separator="<?php echo $ref->product_code_type->displayValueSeparatorAttribute() ?>" id="x_product_code_type" name="x_product_code_type"<?php echo $ref->product_code_type->editAttributes() ?>>
		<?php echo $ref->product_code_type->selectOptionListHtml("x_product_code_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_product_code"><?php echo $ref->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->product_code->cellAttributes() ?>>
			<span id="el_ref_product_code">
<input type="text" data-table="ref" data-field="x_product_code" data-page="0" name="x_product_code" id="x_product_code" maxlength="96" placeholder="<?php echo HtmlEncode($ref->product_code->getPlaceHolder()) ?>" value="<?php echo $ref->product_code->EditValue ?>"<?php echo $ref->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="ref_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $ref_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_search->MultiPages->isActive("1")) ?>" href="#tab_ref1"><?php echo $ref->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $ref_search->MultiPages->Parent ?>" id="tab_ref1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($ref->v_00->Visible) { // v_00 ?>
	<div id="r_v_00" class="form-group row">
		<label for="x_v_00" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_00"><?php echo $ref->v_00->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_00" id="z_v_00" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_00->cellAttributes() ?>>
			<span id="el_ref_v_00">
<input type="text" data-table="ref" data-field="x_v_00" data-page="1" name="x_v_00" id="x_v_00" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->v_00->getPlaceHolder()) ?>" value="<?php echo $ref->v_00->EditValue ?>"<?php echo $ref->v_00->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_01->Visible) { // v_01 ?>
	<div id="r_v_01" class="form-group row">
		<label for="x_v_01" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_01"><?php echo $ref->v_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_01" id="z_v_01" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_01->cellAttributes() ?>>
			<span id="el_ref_v_01">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_01" data-page="1" data-value-separator="<?php echo $ref->v_01->displayValueSeparatorAttribute() ?>" id="x_v_01" name="x_v_01"<?php echo $ref->v_01->editAttributes() ?>>
		<?php echo $ref->v_01->selectOptionListHtml("x_v_01") ?>
	</select>
</div>
<?php echo $ref->v_01->Lookup->getParamTag("p_x_v_01") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_02->Visible) { // v_02 ?>
	<div id="r_v_02" class="form-group row">
		<label for="x_v_02" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_02"><?php echo $ref->v_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_02" id="z_v_02" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_02->cellAttributes() ?>>
			<span id="el_ref_v_02">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_02" data-page="1" data-value-separator="<?php echo $ref->v_02->displayValueSeparatorAttribute() ?>" id="x_v_02" name="x_v_02"<?php echo $ref->v_02->editAttributes() ?>>
		<?php echo $ref->v_02->selectOptionListHtml("x_v_02") ?>
	</select>
</div>
<?php echo $ref->v_02->Lookup->getParamTag("p_x_v_02") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_03->Visible) { // v_03 ?>
	<div id="r_v_03" class="form-group row">
		<label for="x_v_03" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_03"><?php echo $ref->v_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_03" id="z_v_03" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_03->cellAttributes() ?>>
			<span id="el_ref_v_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_03" data-page="1" data-value-separator="<?php echo $ref->v_03->displayValueSeparatorAttribute() ?>" id="x_v_03" name="x_v_03"<?php echo $ref->v_03->editAttributes() ?>>
		<?php echo $ref->v_03->selectOptionListHtml("x_v_03") ?>
	</select>
</div>
<?php echo $ref->v_03->Lookup->getParamTag("p_x_v_03") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_04->Visible) { // v_04 ?>
	<div id="r_v_04" class="form-group row">
		<label for="x_v_04" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_04"><?php echo $ref->v_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_04" id="z_v_04" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_04->cellAttributes() ?>>
			<span id="el_ref_v_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_04" data-page="1" data-value-separator="<?php echo $ref->v_04->displayValueSeparatorAttribute() ?>" id="x_v_04" name="x_v_04"<?php echo $ref->v_04->editAttributes() ?>>
		<?php echo $ref->v_04->selectOptionListHtml("x_v_04") ?>
	</select>
</div>
<?php echo $ref->v_04->Lookup->getParamTag("p_x_v_04") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_05->Visible) { // v_05 ?>
	<div id="r_v_05" class="form-group row">
		<label for="x_v_05" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_05"><?php echo $ref->v_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_05" id="z_v_05" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_05->cellAttributes() ?>>
			<span id="el_ref_v_05">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_05" data-page="1" data-value-separator="<?php echo $ref->v_05->displayValueSeparatorAttribute() ?>" id="x_v_05" name="x_v_05"<?php echo $ref->v_05->editAttributes() ?>>
		<?php echo $ref->v_05->selectOptionListHtml("x_v_05") ?>
	</select>
</div>
<?php echo $ref->v_05->Lookup->getParamTag("p_x_v_05") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_06->Visible) { // v_06 ?>
	<div id="r_v_06" class="form-group row">
		<label for="x_v_06" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_06"><?php echo $ref->v_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_06" id="z_v_06" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_06->cellAttributes() ?>>
			<span id="el_ref_v_06">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_06" data-page="1" data-value-separator="<?php echo $ref->v_06->displayValueSeparatorAttribute() ?>" id="x_v_06" name="x_v_06"<?php echo $ref->v_06->editAttributes() ?>>
		<?php echo $ref->v_06->selectOptionListHtml("x_v_06") ?>
	</select>
</div>
<?php echo $ref->v_06->Lookup->getParamTag("p_x_v_06") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_07->Visible) { // v_07 ?>
	<div id="r_v_07" class="form-group row">
		<label for="x_v_07" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_07"><?php echo $ref->v_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_07" id="z_v_07" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_07->cellAttributes() ?>>
			<span id="el_ref_v_07">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_07" data-page="1" data-value-separator="<?php echo $ref->v_07->displayValueSeparatorAttribute() ?>" id="x_v_07" name="x_v_07"<?php echo $ref->v_07->editAttributes() ?>>
		<?php echo $ref->v_07->selectOptionListHtml("x_v_07") ?>
	</select>
</div>
<?php echo $ref->v_07->Lookup->getParamTag("p_x_v_07") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_08->Visible) { // v_08 ?>
	<div id="r_v_08" class="form-group row">
		<label for="x_v_08" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_08"><?php echo $ref->v_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_08" id="z_v_08" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_08->cellAttributes() ?>>
			<span id="el_ref_v_08">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_08" data-page="1" data-value-separator="<?php echo $ref->v_08->displayValueSeparatorAttribute() ?>" id="x_v_08" name="x_v_08"<?php echo $ref->v_08->editAttributes() ?>>
		<?php echo $ref->v_08->selectOptionListHtml("x_v_08") ?>
	</select>
</div>
<?php echo $ref->v_08->Lookup->getParamTag("p_x_v_08") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_09->Visible) { // v_09 ?>
	<div id="r_v_09" class="form-group row">
		<label for="x_v_09" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_09"><?php echo $ref->v_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_09" id="z_v_09" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_09->cellAttributes() ?>>
			<span id="el_ref_v_09">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_09" data-page="1" data-value-separator="<?php echo $ref->v_09->displayValueSeparatorAttribute() ?>" id="x_v_09" name="x_v_09"<?php echo $ref->v_09->editAttributes() ?>>
		<?php echo $ref->v_09->selectOptionListHtml("x_v_09") ?>
	</select>
</div>
<?php echo $ref->v_09->Lookup->getParamTag("p_x_v_09") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->v_10->Visible) { // v_10 ?>
	<div id="r_v_10" class="form-group row">
		<label for="x_v_10" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_v_10"><?php echo $ref->v_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_v_10" id="z_v_10" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->v_10->cellAttributes() ?>>
			<span id="el_ref_v_10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_v_10" data-page="1" data-value-separator="<?php echo $ref->v_10->displayValueSeparatorAttribute() ?>" id="x_v_10" name="x_v_10"<?php echo $ref->v_10->editAttributes() ?>>
		<?php echo $ref->v_10->selectOptionListHtml("x_v_10") ?>
	</select>
</div>
<?php echo $ref->v_10->Lookup->getParamTag("p_x_v_10") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->q_sku->Visible) { // q_sku ?>
	<div id="r_q_sku" class="form-group row">
		<label for="x_q_sku" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_q_sku"><?php echo $ref->q_sku->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_q_sku" id="z_q_sku" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->q_sku->cellAttributes() ?>>
			<span id="el_ref_q_sku">
<input type="text" data-table="ref" data-field="x_q_sku" data-page="1" name="x_q_sku" id="x_q_sku" size="30" placeholder="<?php echo HtmlEncode($ref->q_sku->getPlaceHolder()) ?>" value="<?php echo $ref->q_sku->EditValue ?>"<?php echo $ref->q_sku->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $ref_search->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_search->MultiPages->isActive("2")) ?>" href="#tab_ref2"><?php echo $ref->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_search->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $ref_search->MultiPages->Parent ?>" id="tab_ref2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($ref->b_01->Visible) { // b_01 ?>
	<div id="r_b_01" class="form-group row">
		<label for="x_b_01" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_01"><?php echo $ref->b_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_01" id="z_b_01" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_01->cellAttributes() ?>>
			<span id="el_ref_b_01">
<input type="text" data-table="ref" data-field="x_b_01" data-page="2" name="x_b_01" id="x_b_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_01->getPlaceHolder()) ?>" value="<?php echo $ref->b_01->EditValue ?>"<?php echo $ref->b_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_02->Visible) { // b_02 ?>
	<div id="r_b_02" class="form-group row">
		<label for="x_b_02" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_02"><?php echo $ref->b_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_02" id="z_b_02" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_02->cellAttributes() ?>>
			<span id="el_ref_b_02">
<input type="text" data-table="ref" data-field="x_b_02" data-page="2" name="x_b_02" id="x_b_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_02->getPlaceHolder()) ?>" value="<?php echo $ref->b_02->EditValue ?>"<?php echo $ref->b_02->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_03->Visible) { // b_03 ?>
	<div id="r_b_03" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_03"><?php echo $ref->b_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_03" id="z_b_03" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_03->cellAttributes() ?>>
			<span id="el_ref_b_03">
<div id="tp_x_b_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_03" data-page="2" data-value-separator="<?php echo $ref->b_03->displayValueSeparatorAttribute() ?>" name="x_b_03[]" id="x_b_03[]" value="{value}"<?php echo $ref->b_03->editAttributes() ?>></div>
<div id="dsl_x_b_03" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_03->checkBoxListHtml(FALSE, "x_b_03[]", 2) ?>
</div></div>
<?php echo $ref->b_03->Lookup->getParamTag("p_x_b_03") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_04->Visible) { // b_04 ?>
	<div id="r_b_04" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_04"><?php echo $ref->b_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_04" id="z_b_04" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_04->cellAttributes() ?>>
			<span id="el_ref_b_04">
<div id="tp_x_b_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_04" data-page="2" data-value-separator="<?php echo $ref->b_04->displayValueSeparatorAttribute() ?>" name="x_b_04[]" id="x_b_04[]" value="{value}"<?php echo $ref->b_04->editAttributes() ?>></div>
<div id="dsl_x_b_04" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $ref->b_04->checkBoxListHtml(FALSE, "x_b_04[]", 2) ?>
</div></div>
<?php echo $ref->b_04->Lookup->getParamTag("p_x_b_04") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_05->Visible) { // b_05 ?>
	<div id="r_b_05" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_05"><?php echo $ref->b_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_05" id="z_b_05" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_05->cellAttributes() ?>>
			<span id="el_ref_b_05">
<div id="tp_x_b_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_05" data-page="2" data-value-separator="<?php echo $ref->b_05->displayValueSeparatorAttribute() ?>" name="x_b_05[]" id="x_b_05[]" value="{value}"<?php echo $ref->b_05->editAttributes() ?>></div>
<div id="dsl_x_b_05" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_05->checkBoxListHtml(FALSE, "x_b_05[]", 2) ?>
</div></div>
<?php echo $ref->b_05->Lookup->getParamTag("p_x_b_05") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_06->Visible) { // b_06 ?>
	<div id="r_b_06" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_06"><?php echo $ref->b_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_06" id="z_b_06" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_06->cellAttributes() ?>>
			<span id="el_ref_b_06">
<div id="tp_x_b_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_06" data-page="2" data-value-separator="<?php echo $ref->b_06->displayValueSeparatorAttribute() ?>" name="x_b_06[]" id="x_b_06[]" value="{value}"<?php echo $ref->b_06->editAttributes() ?>></div>
<div id="dsl_x_b_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_06->checkBoxListHtml(FALSE, "x_b_06[]", 2) ?>
</div></div>
<?php echo $ref->b_06->Lookup->getParamTag("p_x_b_06") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_07->Visible) { // b_07 ?>
	<div id="r_b_07" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_07"><?php echo $ref->b_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_07" id="z_b_07" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_07->cellAttributes() ?>>
			<span id="el_ref_b_07">
<div id="tp_x_b_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_07" data-page="2" data-value-separator="<?php echo $ref->b_07->displayValueSeparatorAttribute() ?>" name="x_b_07[]" id="x_b_07[]" value="{value}"<?php echo $ref->b_07->editAttributes() ?>></div>
<div id="dsl_x_b_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_07->checkBoxListHtml(FALSE, "x_b_07[]", 2) ?>
</div></div>
<?php echo $ref->b_07->Lookup->getParamTag("p_x_b_07") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_08->Visible) { // b_08 ?>
	<div id="r_b_08" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_08"><?php echo $ref->b_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_08" id="z_b_08" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_08->cellAttributes() ?>>
			<span id="el_ref_b_08">
<div id="tp_x_b_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_08" data-page="2" data-value-separator="<?php echo $ref->b_08->displayValueSeparatorAttribute() ?>" name="x_b_08[]" id="x_b_08[]" value="{value}"<?php echo $ref->b_08->editAttributes() ?>></div>
<div id="dsl_x_b_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_08->checkBoxListHtml(FALSE, "x_b_08[]", 2) ?>
</div></div>
<?php echo $ref->b_08->Lookup->getParamTag("p_x_b_08") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_09->Visible) { // b_09 ?>
	<div id="r_b_09" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_09"><?php echo $ref->b_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_09" id="z_b_09" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_09->cellAttributes() ?>>
			<span id="el_ref_b_09">
<div id="tp_x_b_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_09" data-page="2" data-value-separator="<?php echo $ref->b_09->displayValueSeparatorAttribute() ?>" name="x_b_09[]" id="x_b_09[]" value="{value}"<?php echo $ref->b_09->editAttributes() ?>></div>
<div id="dsl_x_b_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_09->checkBoxListHtml(FALSE, "x_b_09[]", 2) ?>
</div></div>
<?php echo $ref->b_09->Lookup->getParamTag("p_x_b_09") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_10->Visible) { // b_10 ?>
	<div id="r_b_10" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_10"><?php echo $ref->b_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_10" id="z_b_10" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_10->cellAttributes() ?>>
			<span id="el_ref_b_10">
<div id="tp_x_b_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_10" data-page="2" data-value-separator="<?php echo $ref->b_10->displayValueSeparatorAttribute() ?>" name="x_b_10[]" id="x_b_10[]" value="{value}"<?php echo $ref->b_10->editAttributes() ?>></div>
<div id="dsl_x_b_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->b_10->checkBoxListHtml(FALSE, "x_b_10[]", 2) ?>
</div></div>
<?php echo $ref->b_10->Lookup->getParamTag("p_x_b_10") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_11->Visible) { // b_11 ?>
	<div id="r_b_11" class="form-group row">
		<label for="x_b_11" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_11"><?php echo $ref->b_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_11" id="z_b_11" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_11->cellAttributes() ?>>
			<span id="el_ref_b_11">
<input type="text" data-table="ref" data-field="x_b_11" data-page="2" name="x_b_11" id="x_b_11" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_11->getPlaceHolder()) ?>" value="<?php echo $ref->b_11->EditValue ?>"<?php echo $ref->b_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_12->Visible) { // b_12 ?>
	<div id="r_b_12" class="form-group row">
		<label for="x_b_12" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_12"><?php echo $ref->b_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_12" id="z_b_12" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_12->cellAttributes() ?>>
			<span id="el_ref_b_12">
<input type="text" data-table="ref" data-field="x_b_12" data-page="2" name="x_b_12" id="x_b_12" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_12->getPlaceHolder()) ?>" value="<?php echo $ref->b_12->EditValue ?>"<?php echo $ref->b_12->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_13->Visible) { // b_13 ?>
	<div id="r_b_13" class="form-group row">
		<label for="x_b_13" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_13"><?php echo $ref->b_13->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_13" id="z_b_13" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_13->cellAttributes() ?>>
			<span id="el_ref_b_13">
<input type="text" data-table="ref" data-field="x_b_13" data-page="2" name="x_b_13" id="x_b_13" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_13->getPlaceHolder()) ?>" value="<?php echo $ref->b_13->EditValue ?>"<?php echo $ref->b_13->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_14->Visible) { // b_14 ?>
	<div id="r_b_14" class="form-group row">
		<label for="x_b_14" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_14"><?php echo $ref->b_14->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_14" id="z_b_14" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_14->cellAttributes() ?>>
			<span id="el_ref_b_14">
<input type="text" data-table="ref" data-field="x_b_14" data-page="2" name="x_b_14" id="x_b_14" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_14->getPlaceHolder()) ?>" value="<?php echo $ref->b_14->EditValue ?>"<?php echo $ref->b_14->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->b_15->Visible) { // b_15 ?>
	<div id="r_b_15" class="form-group row">
		<label for="x_b_15" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_b_15"><?php echo $ref->b_15->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_15" id="z_b_15" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->b_15->cellAttributes() ?>>
			<span id="el_ref_b_15">
<input type="text" data-table="ref" data-field="x_b_15" data-page="2" name="x_b_15" id="x_b_15" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->b_15->getPlaceHolder()) ?>" value="<?php echo $ref->b_15->EditValue ?>"<?php echo $ref->b_15->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $ref_search->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_search->MultiPages->isActive("3")) ?>" href="#tab_ref3"><?php echo $ref->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_search->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $ref_search->MultiPages->Parent ?>" id="tab_ref3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($ref->t_01->Visible) { // t_01 ?>
	<div id="r_t_01" class="form-group row">
		<label for="x_t_01" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_01"><?php echo $ref->t_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_01" id="z_t_01" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_01->cellAttributes() ?>>
			<span id="el_ref_t_01">
<input type="text" data-table="ref" data-field="x_t_01" data-page="3" name="x_t_01" id="x_t_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_01->getPlaceHolder()) ?>" value="<?php echo $ref->t_01->EditValue ?>"<?php echo $ref->t_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_02->Visible) { // t_02 ?>
	<div id="r_t_02" class="form-group row">
		<label for="x_t_02" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_02"><?php echo $ref->t_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_02" id="z_t_02" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_02->cellAttributes() ?>>
			<span id="el_ref_t_02">
<input type="text" data-table="ref" data-field="x_t_02" data-page="3" name="x_t_02" id="x_t_02" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_02->getPlaceHolder()) ?>" value="<?php echo $ref->t_02->EditValue ?>"<?php echo $ref->t_02->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_03->Visible) { // t_03 ?>
	<div id="r_t_03" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_03"><?php echo $ref->t_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_03" id="z_t_03" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_03->cellAttributes() ?>>
			<span id="el_ref_t_03">
<div id="tp_x_t_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_03" data-page="3" data-value-separator="<?php echo $ref->t_03->displayValueSeparatorAttribute() ?>" name="x_t_03[]" id="x_t_03[]" value="{value}"<?php echo $ref->t_03->editAttributes() ?>></div>
<div id="dsl_x_t_03" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_03->checkBoxListHtml(FALSE, "x_t_03[]", 3) ?>
</div></div>
<?php echo $ref->t_03->Lookup->getParamTag("p_x_t_03") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_04->Visible) { // t_04 ?>
	<div id="r_t_04" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_04"><?php echo $ref->t_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_04" id="z_t_04" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_04->cellAttributes() ?>>
			<span id="el_ref_t_04">
<div id="tp_x_t_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_04" data-page="3" data-value-separator="<?php echo $ref->t_04->displayValueSeparatorAttribute() ?>" name="x_t_04[]" id="x_t_04[]" value="{value}"<?php echo $ref->t_04->editAttributes() ?>></div>
<div id="dsl_x_t_04" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_04->checkBoxListHtml(FALSE, "x_t_04[]", 3) ?>
</div></div>
<?php echo $ref->t_04->Lookup->getParamTag("p_x_t_04") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_05->Visible) { // t_05 ?>
	<div id="r_t_05" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_05"><?php echo $ref->t_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_05" id="z_t_05" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_05->cellAttributes() ?>>
			<span id="el_ref_t_05">
<div id="tp_x_t_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_05" data-page="3" data-value-separator="<?php echo $ref->t_05->displayValueSeparatorAttribute() ?>" name="x_t_05[]" id="x_t_05[]" value="{value}"<?php echo $ref->t_05->editAttributes() ?>></div>
<div id="dsl_x_t_05" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_05->checkBoxListHtml(FALSE, "x_t_05[]", 3) ?>
</div></div>
<?php echo $ref->t_05->Lookup->getParamTag("p_x_t_05") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_06->Visible) { // t_06 ?>
	<div id="r_t_06" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_06"><?php echo $ref->t_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_06" id="z_t_06" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_06->cellAttributes() ?>>
			<span id="el_ref_t_06">
<div id="tp_x_t_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_06" data-page="3" data-value-separator="<?php echo $ref->t_06->displayValueSeparatorAttribute() ?>" name="x_t_06[]" id="x_t_06[]" value="{value}"<?php echo $ref->t_06->editAttributes() ?>></div>
<div id="dsl_x_t_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_06->checkBoxListHtml(FALSE, "x_t_06[]", 3) ?>
</div></div>
<?php echo $ref->t_06->Lookup->getParamTag("p_x_t_06") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_07->Visible) { // t_07 ?>
	<div id="r_t_07" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_07"><?php echo $ref->t_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_07" id="z_t_07" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_07->cellAttributes() ?>>
			<span id="el_ref_t_07">
<div id="tp_x_t_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_07" data-page="3" data-value-separator="<?php echo $ref->t_07->displayValueSeparatorAttribute() ?>" name="x_t_07[]" id="x_t_07[]" value="{value}"<?php echo $ref->t_07->editAttributes() ?>></div>
<div id="dsl_x_t_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_07->checkBoxListHtml(FALSE, "x_t_07[]", 3) ?>
</div></div>
<?php echo $ref->t_07->Lookup->getParamTag("p_x_t_07") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_08->Visible) { // t_08 ?>
	<div id="r_t_08" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_08"><?php echo $ref->t_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_08" id="z_t_08" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_08->cellAttributes() ?>>
			<span id="el_ref_t_08">
<div id="tp_x_t_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_08" data-page="3" data-value-separator="<?php echo $ref->t_08->displayValueSeparatorAttribute() ?>" name="x_t_08[]" id="x_t_08[]" value="{value}"<?php echo $ref->t_08->editAttributes() ?>></div>
<div id="dsl_x_t_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_08->checkBoxListHtml(FALSE, "x_t_08[]", 3) ?>
</div></div>
<?php echo $ref->t_08->Lookup->getParamTag("p_x_t_08") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_09->Visible) { // t_09 ?>
	<div id="r_t_09" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_09"><?php echo $ref->t_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_09" id="z_t_09" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_09->cellAttributes() ?>>
			<span id="el_ref_t_09">
<div id="tp_x_t_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_09" data-page="3" data-value-separator="<?php echo $ref->t_09->displayValueSeparatorAttribute() ?>" name="x_t_09[]" id="x_t_09[]" value="{value}"<?php echo $ref->t_09->editAttributes() ?>></div>
<div id="dsl_x_t_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_09->checkBoxListHtml(FALSE, "x_t_09[]", 3) ?>
</div></div>
<?php echo $ref->t_09->Lookup->getParamTag("p_x_t_09") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_10->Visible) { // t_10 ?>
	<div id="r_t_10" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_10"><?php echo $ref->t_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_10" id="z_t_10" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_10->cellAttributes() ?>>
			<span id="el_ref_t_10">
<div id="tp_x_t_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_10" data-page="3" data-value-separator="<?php echo $ref->t_10->displayValueSeparatorAttribute() ?>" name="x_t_10[]" id="x_t_10[]" value="{value}"<?php echo $ref->t_10->editAttributes() ?>></div>
<div id="dsl_x_t_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $ref->t_10->checkBoxListHtml(FALSE, "x_t_10[]", 3) ?>
</div></div>
<?php echo $ref->t_10->Lookup->getParamTag("p_x_t_10") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_11->Visible) { // t_11 ?>
	<div id="r_t_11" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_11"><?php echo $ref->t_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_11" id="z_t_11" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_11->cellAttributes() ?>>
			<span id="el_ref_t_11">
<?php
$wrkonchange = "" . trim(@$ref->t_11->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref->t_11->EditAttrs["onchange"] = "";
?>
<span id="as_x_t_11" class="text-nowrap" style="z-index: 8410">
	<input type="text" class="form-control" name="sv_x_t_11" id="sv_x_t_11" value="<?php echo RemoveHtml($ref->t_11->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_11->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref->t_11->getPlaceHolder()) ?>"<?php echo $ref->t_11->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref" data-field="x_t_11" data-page="3" data-value-separator="<?php echo $ref->t_11->displayValueSeparatorAttribute() ?>" name="x_t_11" id="x_t_11" value="<?php echo HtmlEncode($ref->t_11->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
frefsearch.createAutoSuggest({"id":"x_t_11","forceSelect":false});
</script>
<?php echo $ref->t_11->Lookup->getParamTag("p_x_t_11") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_12->Visible) { // t_12 ?>
	<div id="r_t_12" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_12"><?php echo $ref->t_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_12" id="z_t_12" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_12->cellAttributes() ?>>
			<span id="el_ref_t_12">
<?php
$wrkonchange = "" . trim(@$ref->t_12->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$ref->t_12->EditAttrs["onchange"] = "";
?>
<span id="as_x_t_12" class="text-nowrap" style="z-index: 8400">
	<input type="text" class="form-control" name="sv_x_t_12" id="sv_x_t_12" value="<?php echo RemoveHtml($ref->t_12->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_12->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($ref->t_12->getPlaceHolder()) ?>"<?php echo $ref->t_12->editAttributes() ?>>
</span>
<input type="hidden" data-table="ref" data-field="x_t_12" data-page="3" data-value-separator="<?php echo $ref->t_12->displayValueSeparatorAttribute() ?>" name="x_t_12" id="x_t_12" value="<?php echo HtmlEncode($ref->t_12->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
frefsearch.createAutoSuggest({"id":"x_t_12","forceSelect":false});
</script>
<?php echo $ref->t_12->Lookup->getParamTag("p_x_t_12") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_13->Visible) { // t_13 ?>
	<div id="r_t_13" class="form-group row">
		<label for="x_t_13" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_13"><?php echo $ref->t_13->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_13" id="z_t_13" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_13->cellAttributes() ?>>
			<span id="el_ref_t_13">
<input type="text" data-table="ref" data-field="x_t_13" data-page="3" name="x_t_13" id="x_t_13" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_13->getPlaceHolder()) ?>" value="<?php echo $ref->t_13->EditValue ?>"<?php echo $ref->t_13->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_14->Visible) { // t_14 ?>
	<div id="r_t_14" class="form-group row">
		<label for="x_t_14" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_14"><?php echo $ref->t_14->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_14" id="z_t_14" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_14->cellAttributes() ?>>
			<span id="el_ref_t_14">
<input type="text" data-table="ref" data-field="x_t_14" data-page="3" name="x_t_14" id="x_t_14" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_14->getPlaceHolder()) ?>" value="<?php echo $ref->t_14->EditValue ?>"<?php echo $ref->t_14->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->t_15->Visible) { // t_15 ?>
	<div id="r_t_15" class="form-group row">
		<label for="x_t_15" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_t_15"><?php echo $ref->t_15->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_15" id="z_t_15" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->t_15->cellAttributes() ?>>
			<span id="el_ref_t_15">
<input type="text" data-table="ref" data-field="x_t_15" data-page="3" name="x_t_15" id="x_t_15" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ref->t_15->getPlaceHolder()) ?>" value="<?php echo $ref->t_15->EditValue ?>"<?php echo $ref->t_15->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $ref_search->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_search->MultiPages->isActive("4")) ?>" href="#tab_ref4"><?php echo $ref->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_search->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $ref_search->MultiPages->Parent ?>" id="tab_ref4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($ref->d_head_01->Visible) { // d_head_01 ?>
	<div id="r_d_head_01" class="form-group row">
		<label for="x_d_head_01" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_d_head_01"><?php echo $ref->d_head_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_head_01" id="z_d_head_01" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->d_head_01->cellAttributes() ?>>
			<span id="el_ref_d_head_01">
<input type="text" data-table="ref" data-field="x_d_head_01" data-page="4" name="x_d_head_01" id="x_d_head_01" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->d_head_01->getPlaceHolder()) ?>" value="<?php echo $ref->d_head_01->EditValue ?>"<?php echo $ref->d_head_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->d_description_01->Visible) { // d_description_01 ?>
	<div id="r_d_description_01" class="form-group row">
		<label for="x_d_description_01" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_d_description_01"><?php echo $ref->d_description_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_description_01" id="z_d_description_01" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->d_description_01->cellAttributes() ?>>
			<span id="el_ref_d_description_01">
<input type="text" data-table="ref" data-field="x_d_description_01" data-page="4" name="x_d_description_01" id="x_d_description_01" size="35" placeholder="<?php echo HtmlEncode($ref->d_description_01->getPlaceHolder()) ?>" value="<?php echo $ref->d_description_01->EditValue ?>"<?php echo $ref->d_description_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->d_head_02->Visible) { // d_head_02 ?>
	<div id="r_d_head_02" class="form-group row">
		<label for="x_d_head_02" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_d_head_02"><?php echo $ref->d_head_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_head_02" id="z_d_head_02" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->d_head_02->cellAttributes() ?>>
			<span id="el_ref_d_head_02">
<input type="text" data-table="ref" data-field="x_d_head_02" data-page="4" name="x_d_head_02" id="x_d_head_02" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->d_head_02->getPlaceHolder()) ?>" value="<?php echo $ref->d_head_02->EditValue ?>"<?php echo $ref->d_head_02->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->d_description_02->Visible) { // d_description_02 ?>
	<div id="r_d_description_02" class="form-group row">
		<label for="x_d_description_02" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_d_description_02"><?php echo $ref->d_description_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_description_02" id="z_d_description_02" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->d_description_02->cellAttributes() ?>>
			<span id="el_ref_d_description_02">
<input type="text" data-table="ref" data-field="x_d_description_02" data-page="4" name="x_d_description_02" id="x_d_description_02" size="35" placeholder="<?php echo HtmlEncode($ref->d_description_02->getPlaceHolder()) ?>" value="<?php echo $ref->d_description_02->EditValue ?>"<?php echo $ref->d_description_02->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $ref_search->MultiPages->pageStyle("5") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_search->MultiPages->isActive("5")) ?>" href="#tab_ref5"><?php echo $ref->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_search->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $ref_search->MultiPages->Parent ?>" id="tab_ref5"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($ref->main_image->Visible) { // main_image ?>
	<div id="r_main_image" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_main_image"><?php echo $ref->main_image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_main_image" id="z_main_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->main_image->cellAttributes() ?>>
			<span id="el_ref_main_image">
<input type="text" data-table="ref" data-field="x_main_image" data-page="5" name="x_main_image" id="x_main_image" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->main_image->getPlaceHolder()) ?>" value="<?php echo $ref->main_image->EditValue ?>"<?php echo $ref->main_image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->top_view->Visible) { // top_view ?>
	<div id="r_top_view" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_top_view"><?php echo $ref->top_view->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_top_view" id="z_top_view" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->top_view->cellAttributes() ?>>
			<span id="el_ref_top_view">
<input type="text" data-table="ref" data-field="x_top_view" data-page="5" name="x_top_view" id="x_top_view" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->top_view->getPlaceHolder()) ?>" value="<?php echo $ref->top_view->EditValue ?>"<?php echo $ref->top_view->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->front_view->Visible) { // front_view ?>
	<div id="r_front_view" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_front_view"><?php echo $ref->front_view->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_front_view" id="z_front_view" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->front_view->cellAttributes() ?>>
			<span id="el_ref_front_view">
<input type="text" data-table="ref" data-field="x_front_view" data-page="5" name="x_front_view" id="x_front_view" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->front_view->getPlaceHolder()) ?>" value="<?php echo $ref->front_view->EditValue ?>"<?php echo $ref->front_view->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->corner_view->Visible) { // corner_view ?>
	<div id="r_corner_view" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_corner_view"><?php echo $ref->corner_view->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_corner_view" id="z_corner_view" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->corner_view->cellAttributes() ?>>
			<span id="el_ref_corner_view">
<input type="text" data-table="ref" data-field="x_corner_view" data-page="5" name="x_corner_view" id="x_corner_view" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->corner_view->getPlaceHolder()) ?>" value="<?php echo $ref->corner_view->EditValue ?>"<?php echo $ref->corner_view->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->back_view->Visible) { // back_view ?>
	<div id="r_back_view" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_back_view"><?php echo $ref->back_view->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_back_view" id="z_back_view" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->back_view->cellAttributes() ?>>
			<span id="el_ref_back_view">
<input type="text" data-table="ref" data-field="x_back_view" data-page="5" name="x_back_view" id="x_back_view" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->back_view->getPlaceHolder()) ?>" value="<?php echo $ref->back_view->EditValue ?>"<?php echo $ref->back_view->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->color_options->Visible) { // color_options ?>
	<div id="r_color_options" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_color_options"><?php echo $ref->color_options->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_color_options" id="z_color_options" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->color_options->cellAttributes() ?>>
			<span id="el_ref_color_options">
<input type="text" data-table="ref" data-field="x_color_options" data-page="5" name="x_color_options" id="x_color_options" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->color_options->getPlaceHolder()) ?>" value="<?php echo $ref->color_options->EditValue ?>"<?php echo $ref->color_options->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->other_options->Visible) { // other_options ?>
	<div id="r_other_options" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_other_options"><?php echo $ref->other_options->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other_options" id="z_other_options" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->other_options->cellAttributes() ?>>
			<span id="el_ref_other_options">
<input type="text" data-table="ref" data-field="x_other_options" data-page="5" name="x_other_options" id="x_other_options" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->other_options->getPlaceHolder()) ?>" value="<?php echo $ref->other_options->EditValue ?>"<?php echo $ref->other_options->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->group_image->Visible) { // group_image ?>
	<div id="r_group_image" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_group_image"><?php echo $ref->group_image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_group_image" id="z_group_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->group_image->cellAttributes() ?>>
			<span id="el_ref_group_image">
<input type="text" data-table="ref" data-field="x_group_image" data-page="5" name="x_group_image" id="x_group_image" size="30" maxlength="196" placeholder="<?php echo HtmlEncode($ref->group_image->getPlaceHolder()) ?>" value="<?php echo $ref->group_image->EditValue ?>"<?php echo $ref->group_image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->video_url->Visible) { // video_url ?>
	<div id="r_video_url" class="form-group row">
		<label for="x_video_url" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_video_url"><?php echo $ref->video_url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_video_url" id="z_video_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->video_url->cellAttributes() ?>>
			<span id="el_ref_video_url">
<input type="text" data-table="ref" data-field="x_video_url" data-page="5" name="x_video_url" id="x_video_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($ref->video_url->getPlaceHolder()) ?>" value="<?php echo $ref->video_url->EditValue ?>"<?php echo $ref->video_url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_image"><?php echo $ref->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->image->cellAttributes() ?>>
			<span id="el_ref_image">
<input type="text" data-table="ref" data-field="x_image" data-page="5" name="x_image" id="x_image" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ref->image->getPlaceHolder()) ?>" value="<?php echo $ref->image->EditValue ?>"<?php echo $ref->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $ref_search->MultiPages->pageStyle("6") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_search->MultiPages->isActive("6")) ?>" href="#tab_ref6"><?php echo $ref->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_search->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $ref_search->MultiPages->Parent ?>" id="tab_ref6"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($ref->last_price->Visible) { // last_price ?>
	<div id="r_last_price" class="form-group row">
		<label for="x_last_price" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_last_price"><?php echo $ref->last_price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_last_price" id="z_last_price" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->last_price->cellAttributes() ?>>
			<span id="el_ref_last_price">
<input type="text" data-table="ref" data-field="x_last_price" data-page="6" name="x_last_price" id="x_last_price" size="30" placeholder="<?php echo HtmlEncode($ref->last_price->getPlaceHolder()) ?>" value="<?php echo $ref->last_price->EditValue ?>"<?php echo $ref->last_price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->currency->Visible) { // currency ?>
	<div id="r_currency" class="form-group row">
		<label for="x_currency" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_currency"><?php echo $ref->currency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency" id="z_currency" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->currency->cellAttributes() ?>>
			<span id="el_ref_currency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_currency" data-page="6" data-value-separator="<?php echo $ref->currency->displayValueSeparatorAttribute() ?>" id="x_currency" name="x_currency"<?php echo $ref->currency->editAttributes() ?>>
		<?php echo $ref->currency->selectOptionListHtml("x_currency") ?>
	</select>
</div>
<?php echo $ref->currency->Lookup->getParamTag("p_x_currency") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->hsn->Visible) { // hsn ?>
	<div id="r_hsn" class="form-group row">
		<label for="x_hsn" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_hsn"><?php echo $ref->hsn->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_hsn" id="z_hsn" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->hsn->cellAttributes() ?>>
			<span id="el_ref_hsn">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_hsn" data-page="6" data-value-separator="<?php echo $ref->hsn->displayValueSeparatorAttribute() ?>" id="x_hsn" name="x_hsn"<?php echo $ref->hsn->editAttributes() ?>>
		<?php echo $ref->hsn->selectOptionListHtml("x_hsn") ?>
	</select>
</div>
<?php echo $ref->hsn->Lookup->getParamTag("p_x_hsn") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->composition->Visible) { // composition ?>
	<div id="r_composition" class="form-group row">
		<label for="x_composition" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_composition"><?php echo $ref->composition->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_composition" id="z_composition" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->composition->cellAttributes() ?>>
			<span id="el_ref_composition">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_composition" data-page="6" data-value-separator="<?php echo $ref->composition->displayValueSeparatorAttribute() ?>" id="x_composition" name="x_composition"<?php echo $ref->composition->editAttributes() ?>>
		<?php echo $ref->composition->selectOptionListHtml("x_composition") ?>
	</select>
</div>
<?php echo $ref->composition->Lookup->getParamTag("p_x_composition") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_category"><?php echo $ref->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->category->cellAttributes() ?>>
			<span id="el_ref_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_category" data-page="6" data-value-separator="<?php echo $ref->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $ref->category->editAttributes() ?>>
		<?php echo $ref->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $ref->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->moq->Visible) { // moq ?>
	<div id="r_moq" class="form-group row">
		<label for="x_moq" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_moq"><?php echo $ref->moq->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_moq" id="z_moq" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->moq->cellAttributes() ?>>
			<span id="el_ref_moq">
<input type="text" data-table="ref" data-field="x_moq" data-page="6" name="x_moq" id="x_moq" size="30" placeholder="<?php echo HtmlEncode($ref->moq->getPlaceHolder()) ?>" value="<?php echo $ref->moq->EditValue ?>"<?php echo $ref->moq->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_status"><?php echo $ref->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->status->cellAttributes() ?>>
			<span id="el_ref_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_status" data-page="6" data-value-separator="<?php echo $ref->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ref->status->editAttributes() ?>>
		<?php echo $ref->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->keywords->Visible) { // keywords ?>
	<div id="r_keywords" class="form-group row">
		<label for="x_keywords" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_keywords"><?php echo $ref->keywords->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_keywords" id="z_keywords" value="LIKE"></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->keywords->cellAttributes() ?>>
			<span id="el_ref_keywords">
<input type="text" data-table="ref" data-field="x_keywords" data-page="6" name="x_keywords" id="x_keywords" maxlength="250" placeholder="<?php echo HtmlEncode($ref->keywords->getPlaceHolder()) ?>" value="<?php echo $ref->keywords->EditValue ?>"<?php echo $ref->keywords->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_operator"><?php echo $ref->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->operator->cellAttributes() ?>>
			<span id="el_ref_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ref" data-field="x_operator" data-page="6" data-value-separator="<?php echo $ref->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $ref->operator->editAttributes() ?>>
		<?php echo $ref->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $ref->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ref->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $ref_search->LeftColumnClass ?>"><span id="elh_ref_datetime"><?php echo $ref->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $ref_search->RightColumnClass ?>"><div<?php echo $ref->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($ref->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($ref->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($ref->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($ref->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($ref->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($ref->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($ref->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_ref_datetime">
<input type="text" data-table="ref" data-field="x_datetime" data-page="6" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($ref->datetime->getPlaceHolder()) ?>" value="<?php echo $ref->datetime->EditValue ?>"<?php echo $ref->datetime->editAttributes() ?>>
<?php if (!$ref->datetime->ReadOnly && !$ref->datetime->Disabled && !isset($ref->datetime->EditAttrs["readonly"]) && !isset($ref->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frefsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_ref_datetime" class="btw1_datetime d-none">
<input type="text" data-table="ref" data-field="x_datetime" data-page="6" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($ref->datetime->getPlaceHolder()) ?>" value="<?php echo $ref->datetime->EditValue2 ?>"<?php echo $ref->datetime->editAttributes() ?>>
<?php if (!$ref->datetime->ReadOnly && !$ref->datetime->Disabled && !isset($ref->datetime->EditAttrs["readonly"]) && !isset($ref->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frefsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$ref_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ref_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ref_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ref_search->terminate();
?>