<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ref_view = new ref_view();

// Run the page
$ref_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ref_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ref->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var frefview = currentForm = new ew.Form("frefview", "view");

// Form_CustomValidate event
frefview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frefview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
frefview.multiPage = new ew.MultiPage("frefview");

// Dynamic selection lists
frefview.lists["x_company_id[]"] = <?php echo $ref_view->company_id->Lookup->toClientList() ?>;
frefview.lists["x_company_id[]"].options = <?php echo JsonEncode($ref_view->company_id->lookupOptions()) ?>;
frefview.lists["x_grp"] = <?php echo $ref_view->grp->Lookup->toClientList() ?>;
frefview.lists["x_grp"].options = <?php echo JsonEncode($ref_view->grp->lookupOptions()) ?>;
frefview.lists["x_s_grp"] = <?php echo $ref_view->s_grp->Lookup->toClientList() ?>;
frefview.lists["x_s_grp"].options = <?php echo JsonEncode($ref_view->s_grp->lookupOptions()) ?>;
frefview.lists["x_product"] = <?php echo $ref_view->product->Lookup->toClientList() ?>;
frefview.lists["x_product"].options = <?php echo JsonEncode($ref_view->product->lookupOptions()) ?>;
frefview.lists["x_product_type"] = <?php echo $ref_view->product_type->Lookup->toClientList() ?>;
frefview.lists["x_product_type"].options = <?php echo JsonEncode($ref_view->product_type->lookupOptions()) ?>;
frefview.lists["x_packing_type"] = <?php echo $ref_view->packing_type->Lookup->toClientList() ?>;
frefview.lists["x_packing_type"].options = <?php echo JsonEncode($ref_view->packing_type->lookupOptions()) ?>;
frefview.lists["x_product_code_type"] = <?php echo $ref_view->product_code_type->Lookup->toClientList() ?>;
frefview.lists["x_product_code_type"].options = <?php echo JsonEncode($ref_view->product_code_type->options(FALSE, TRUE)) ?>;
frefview.lists["x_set_ref[]"] = <?php echo $ref_view->set_ref->Lookup->toClientList() ?>;
frefview.lists["x_set_ref[]"].options = <?php echo JsonEncode($ref_view->set_ref->lookupOptions()) ?>;
frefview.lists["x_v_01"] = <?php echo $ref_view->v_01->Lookup->toClientList() ?>;
frefview.lists["x_v_01"].options = <?php echo JsonEncode($ref_view->v_01->lookupOptions()) ?>;
frefview.lists["x_v_02"] = <?php echo $ref_view->v_02->Lookup->toClientList() ?>;
frefview.lists["x_v_02"].options = <?php echo JsonEncode($ref_view->v_02->lookupOptions()) ?>;
frefview.lists["x_v_03"] = <?php echo $ref_view->v_03->Lookup->toClientList() ?>;
frefview.lists["x_v_03"].options = <?php echo JsonEncode($ref_view->v_03->lookupOptions()) ?>;
frefview.lists["x_v_04"] = <?php echo $ref_view->v_04->Lookup->toClientList() ?>;
frefview.lists["x_v_04"].options = <?php echo JsonEncode($ref_view->v_04->lookupOptions()) ?>;
frefview.lists["x_v_05"] = <?php echo $ref_view->v_05->Lookup->toClientList() ?>;
frefview.lists["x_v_05"].options = <?php echo JsonEncode($ref_view->v_05->lookupOptions()) ?>;
frefview.lists["x_v_06"] = <?php echo $ref_view->v_06->Lookup->toClientList() ?>;
frefview.lists["x_v_06"].options = <?php echo JsonEncode($ref_view->v_06->lookupOptions()) ?>;
frefview.lists["x_v_07"] = <?php echo $ref_view->v_07->Lookup->toClientList() ?>;
frefview.lists["x_v_07"].options = <?php echo JsonEncode($ref_view->v_07->lookupOptions()) ?>;
frefview.lists["x_v_08"] = <?php echo $ref_view->v_08->Lookup->toClientList() ?>;
frefview.lists["x_v_08"].options = <?php echo JsonEncode($ref_view->v_08->lookupOptions()) ?>;
frefview.lists["x_v_09"] = <?php echo $ref_view->v_09->Lookup->toClientList() ?>;
frefview.lists["x_v_09"].options = <?php echo JsonEncode($ref_view->v_09->lookupOptions()) ?>;
frefview.lists["x_v_10"] = <?php echo $ref_view->v_10->Lookup->toClientList() ?>;
frefview.lists["x_v_10"].options = <?php echo JsonEncode($ref_view->v_10->lookupOptions()) ?>;
frefview.lists["x_shape[]"] = <?php echo $ref_view->shape->Lookup->toClientList() ?>;
frefview.lists["x_shape[]"].options = <?php echo JsonEncode($ref_view->shape->lookupOptions()) ?>;
frefview.lists["x_b_03[]"] = <?php echo $ref_view->b_03->Lookup->toClientList() ?>;
frefview.lists["x_b_03[]"].options = <?php echo JsonEncode($ref_view->b_03->lookupOptions()) ?>;
frefview.lists["x_b_04[]"] = <?php echo $ref_view->b_04->Lookup->toClientList() ?>;
frefview.lists["x_b_04[]"].options = <?php echo JsonEncode($ref_view->b_04->lookupOptions()) ?>;
frefview.lists["x_b_05[]"] = <?php echo $ref_view->b_05->Lookup->toClientList() ?>;
frefview.lists["x_b_05[]"].options = <?php echo JsonEncode($ref_view->b_05->lookupOptions()) ?>;
frefview.lists["x_b_06[]"] = <?php echo $ref_view->b_06->Lookup->toClientList() ?>;
frefview.lists["x_b_06[]"].options = <?php echo JsonEncode($ref_view->b_06->lookupOptions()) ?>;
frefview.lists["x_b_07[]"] = <?php echo $ref_view->b_07->Lookup->toClientList() ?>;
frefview.lists["x_b_07[]"].options = <?php echo JsonEncode($ref_view->b_07->lookupOptions()) ?>;
frefview.lists["x_b_08[]"] = <?php echo $ref_view->b_08->Lookup->toClientList() ?>;
frefview.lists["x_b_08[]"].options = <?php echo JsonEncode($ref_view->b_08->lookupOptions()) ?>;
frefview.lists["x_b_09[]"] = <?php echo $ref_view->b_09->Lookup->toClientList() ?>;
frefview.lists["x_b_09[]"].options = <?php echo JsonEncode($ref_view->b_09->lookupOptions()) ?>;
frefview.lists["x_b_10[]"] = <?php echo $ref_view->b_10->Lookup->toClientList() ?>;
frefview.lists["x_b_10[]"].options = <?php echo JsonEncode($ref_view->b_10->lookupOptions()) ?>;
frefview.lists["x_t_03[]"] = <?php echo $ref_view->t_03->Lookup->toClientList() ?>;
frefview.lists["x_t_03[]"].options = <?php echo JsonEncode($ref_view->t_03->lookupOptions()) ?>;
frefview.lists["x_t_04[]"] = <?php echo $ref_view->t_04->Lookup->toClientList() ?>;
frefview.lists["x_t_04[]"].options = <?php echo JsonEncode($ref_view->t_04->lookupOptions()) ?>;
frefview.lists["x_t_05[]"] = <?php echo $ref_view->t_05->Lookup->toClientList() ?>;
frefview.lists["x_t_05[]"].options = <?php echo JsonEncode($ref_view->t_05->lookupOptions()) ?>;
frefview.lists["x_t_06[]"] = <?php echo $ref_view->t_06->Lookup->toClientList() ?>;
frefview.lists["x_t_06[]"].options = <?php echo JsonEncode($ref_view->t_06->lookupOptions()) ?>;
frefview.lists["x_t_07[]"] = <?php echo $ref_view->t_07->Lookup->toClientList() ?>;
frefview.lists["x_t_07[]"].options = <?php echo JsonEncode($ref_view->t_07->lookupOptions()) ?>;
frefview.lists["x_t_08[]"] = <?php echo $ref_view->t_08->Lookup->toClientList() ?>;
frefview.lists["x_t_08[]"].options = <?php echo JsonEncode($ref_view->t_08->lookupOptions()) ?>;
frefview.lists["x_t_09[]"] = <?php echo $ref_view->t_09->Lookup->toClientList() ?>;
frefview.lists["x_t_09[]"].options = <?php echo JsonEncode($ref_view->t_09->lookupOptions()) ?>;
frefview.lists["x_t_10[]"] = <?php echo $ref_view->t_10->Lookup->toClientList() ?>;
frefview.lists["x_t_10[]"].options = <?php echo JsonEncode($ref_view->t_10->lookupOptions()) ?>;
frefview.lists["x_t_11"] = <?php echo $ref_view->t_11->Lookup->toClientList() ?>;
frefview.lists["x_t_11"].options = <?php echo JsonEncode($ref_view->t_11->lookupOptions()) ?>;
frefview.autoSuggests["x_t_11"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frefview.lists["x_t_12"] = <?php echo $ref_view->t_12->Lookup->toClientList() ?>;
frefview.lists["x_t_12"].options = <?php echo JsonEncode($ref_view->t_12->lookupOptions()) ?>;
frefview.autoSuggests["x_t_12"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frefview.lists["x_currency"] = <?php echo $ref_view->currency->Lookup->toClientList() ?>;
frefview.lists["x_currency"].options = <?php echo JsonEncode($ref_view->currency->lookupOptions()) ?>;
frefview.lists["x_hsn"] = <?php echo $ref_view->hsn->Lookup->toClientList() ?>;
frefview.lists["x_hsn"].options = <?php echo JsonEncode($ref_view->hsn->lookupOptions()) ?>;
frefview.lists["x_composition"] = <?php echo $ref_view->composition->Lookup->toClientList() ?>;
frefview.lists["x_composition"].options = <?php echo JsonEncode($ref_view->composition->lookupOptions()) ?>;
frefview.lists["x_category"] = <?php echo $ref_view->category->Lookup->toClientList() ?>;
frefview.lists["x_category"].options = <?php echo JsonEncode($ref_view->category->lookupOptions()) ?>;
frefview.lists["x_status"] = <?php echo $ref_view->status->Lookup->toClientList() ?>;
frefview.lists["x_status"].options = <?php echo JsonEncode($ref_view->status->options(FALSE, TRUE)) ?>;
frefview.lists["x_publish"] = <?php echo $ref_view->publish->Lookup->toClientList() ?>;
frefview.lists["x_publish"].options = <?php echo JsonEncode($ref_view->publish->options(FALSE, TRUE)) ?>;
frefview.lists["x_operator"] = <?php echo $ref_view->operator->Lookup->toClientList() ?>;
frefview.lists["x_operator"].options = <?php echo JsonEncode($ref_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ref_view->ExportOptions->render("body") ?>
<?php $ref_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ref_view->showPageHeader(); ?>
<?php
$ref_view->showMessage();
?>
<form name="frefview" id="frefview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ref_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ref_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ref">
<input type="hidden" name="modal" value="<?php echo (int)$ref_view->IsModal ?>">
<?php if ($ref_view->MultiPages->Items[0]->Visible) { ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_id"><?php echo $ref->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ref->id->cellAttributes() ?>>
<span id="el_ref_id" data-page="0">
<span<?php echo $ref->id->viewAttributes() ?>>
<?php echo $ref->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_company_id"><?php echo $ref->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $ref->company_id->cellAttributes() ?>>
<span id="el_ref_company_id" data-page="0">
<span<?php echo $ref->company_id->viewAttributes() ?>>
<?php echo $ref->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_grp"><?php echo $ref->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $ref->grp->cellAttributes() ?>>
<span id="el_ref_grp" data-page="0">
<span<?php echo $ref->grp->viewAttributes() ?>>
<?php echo $ref->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_s_grp"><?php echo $ref->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $ref->s_grp->cellAttributes() ?>>
<span id="el_ref_s_grp" data-page="0">
<span<?php echo $ref->s_grp->viewAttributes() ?>>
<?php echo $ref->s_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_product"><?php echo $ref->product->caption() ?></span></td>
		<td data-name="product"<?php echo $ref->product->cellAttributes() ?>>
<span id="el_ref_product" data-page="0">
<span<?php echo $ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($ref->product->getViewValue())) && $ref->product->linkAttributes() <> "") { ?>
<a<?php echo $ref->product->linkAttributes() ?>><?php echo $ref->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ref->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->product_type->Visible) { // product_type ?>
	<tr id="r_product_type">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_product_type"><?php echo $ref->product_type->caption() ?></span></td>
		<td data-name="product_type"<?php echo $ref->product_type->cellAttributes() ?>>
<span id="el_ref_product_type" data-page="0">
<span<?php echo $ref->product_type->viewAttributes() ?>>
<?php echo $ref->product_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_packing_type"><?php echo $ref->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $ref->packing_type->cellAttributes() ?>>
<span id="el_ref_packing_type" data-page="0">
<span<?php echo $ref->packing_type->viewAttributes() ?>>
<?php echo $ref->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->product_n->Visible) { // product_n ?>
	<tr id="r_product_n">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_product_n"><?php echo $ref->product_n->caption() ?></span></td>
		<td data-name="product_n"<?php echo $ref->product_n->cellAttributes() ?>>
<span id="el_ref_product_n" data-page="0">
<span<?php echo $ref->product_n->viewAttributes() ?>>
<?php echo $ref->product_n->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref__barcode"><?php echo $ref->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $ref->_barcode->cellAttributes() ?>>
<span id="el_ref__barcode" data-page="0">
<span<?php echo $ref->_barcode->viewAttributes() ?>>
<?php echo $ref->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->product_code_type->Visible) { // product_code_type ?>
	<tr id="r_product_code_type">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_product_code_type"><?php echo $ref->product_code_type->caption() ?></span></td>
		<td data-name="product_code_type"<?php echo $ref->product_code_type->cellAttributes() ?>>
<span id="el_ref_product_code_type" data-page="0">
<span<?php echo $ref->product_code_type->viewAttributes() ?>>
<?php echo $ref->product_code_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_product_code"><?php echo $ref->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $ref->product_code->cellAttributes() ?>>
<span id="el_ref_product_code" data-page="0">
<span<?php echo $ref->product_code->viewAttributes() ?>>
<?php echo $ref->product_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
<div class="ew-multi-page">
<div class="accordion ew-accordion" id="ref_view"><!-- multi-page accordion -->
<?php } ?>
<?php if (!$ref->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $ref_view->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_view->MultiPages->isActive("1")) ?>" href="#tab_ref1"><?php echo $ref->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_view->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $ref_view->MultiPages->Parent ?>" id="tab_ref1">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref->set_ref->Visible) { // set_ref ?>
	<tr id="r_set_ref">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_set_ref"><?php echo $ref->set_ref->caption() ?></span></td>
		<td data-name="set_ref"<?php echo $ref->set_ref->cellAttributes() ?>>
<span id="el_ref_set_ref" data-page="1">
<span<?php echo $ref->set_ref->viewAttributes() ?>>
<?php echo $ref->set_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_00->Visible) { // v_00 ?>
	<tr id="r_v_00">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_00"><?php echo $ref->v_00->caption() ?></span></td>
		<td data-name="v_00"<?php echo $ref->v_00->cellAttributes() ?>>
<span id="el_ref_v_00" data-page="1">
<span<?php echo $ref->v_00->viewAttributes() ?>>
<?php echo $ref->v_00->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_01->Visible) { // v_01 ?>
	<tr id="r_v_01">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_01"><?php echo $ref->v_01->caption() ?></span></td>
		<td data-name="v_01"<?php echo $ref->v_01->cellAttributes() ?>>
<span id="el_ref_v_01" data-page="1">
<span<?php echo $ref->v_01->viewAttributes() ?>>
<?php echo $ref->v_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_02->Visible) { // v_02 ?>
	<tr id="r_v_02">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_02"><?php echo $ref->v_02->caption() ?></span></td>
		<td data-name="v_02"<?php echo $ref->v_02->cellAttributes() ?>>
<span id="el_ref_v_02" data-page="1">
<span<?php echo $ref->v_02->viewAttributes() ?>>
<?php echo $ref->v_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_03->Visible) { // v_03 ?>
	<tr id="r_v_03">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_03"><?php echo $ref->v_03->caption() ?></span></td>
		<td data-name="v_03"<?php echo $ref->v_03->cellAttributes() ?>>
<span id="el_ref_v_03" data-page="1">
<span<?php echo $ref->v_03->viewAttributes() ?>>
<?php echo $ref->v_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_04->Visible) { // v_04 ?>
	<tr id="r_v_04">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_04"><?php echo $ref->v_04->caption() ?></span></td>
		<td data-name="v_04"<?php echo $ref->v_04->cellAttributes() ?>>
<span id="el_ref_v_04" data-page="1">
<span<?php echo $ref->v_04->viewAttributes() ?>>
<?php echo $ref->v_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_05->Visible) { // v_05 ?>
	<tr id="r_v_05">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_05"><?php echo $ref->v_05->caption() ?></span></td>
		<td data-name="v_05"<?php echo $ref->v_05->cellAttributes() ?>>
<span id="el_ref_v_05" data-page="1">
<span<?php echo $ref->v_05->viewAttributes() ?>>
<?php echo $ref->v_05->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_06->Visible) { // v_06 ?>
	<tr id="r_v_06">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_06"><?php echo $ref->v_06->caption() ?></span></td>
		<td data-name="v_06"<?php echo $ref->v_06->cellAttributes() ?>>
<span id="el_ref_v_06" data-page="1">
<span<?php echo $ref->v_06->viewAttributes() ?>>
<?php echo $ref->v_06->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_07->Visible) { // v_07 ?>
	<tr id="r_v_07">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_07"><?php echo $ref->v_07->caption() ?></span></td>
		<td data-name="v_07"<?php echo $ref->v_07->cellAttributes() ?>>
<span id="el_ref_v_07" data-page="1">
<span<?php echo $ref->v_07->viewAttributes() ?>>
<?php echo $ref->v_07->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_08->Visible) { // v_08 ?>
	<tr id="r_v_08">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_08"><?php echo $ref->v_08->caption() ?></span></td>
		<td data-name="v_08"<?php echo $ref->v_08->cellAttributes() ?>>
<span id="el_ref_v_08" data-page="1">
<span<?php echo $ref->v_08->viewAttributes() ?>>
<?php echo $ref->v_08->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_09->Visible) { // v_09 ?>
	<tr id="r_v_09">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_09"><?php echo $ref->v_09->caption() ?></span></td>
		<td data-name="v_09"<?php echo $ref->v_09->cellAttributes() ?>>
<span id="el_ref_v_09" data-page="1">
<span<?php echo $ref->v_09->viewAttributes() ?>>
<?php echo $ref->v_09->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->v_10->Visible) { // v_10 ?>
	<tr id="r_v_10">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_v_10"><?php echo $ref->v_10->caption() ?></span></td>
		<td data-name="v_10"<?php echo $ref->v_10->cellAttributes() ?>>
<span id="el_ref_v_10" data-page="1">
<span<?php echo $ref->v_10->viewAttributes() ?>>
<?php echo $ref->v_10->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->q_sku->Visible) { // q_sku ?>
	<tr id="r_q_sku">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_q_sku"><?php echo $ref->q_sku->caption() ?></span></td>
		<td data-name="q_sku"<?php echo $ref->q_sku->cellAttributes() ?>>
<span id="el_ref_q_sku" data-page="1">
<span<?php echo $ref->q_sku->viewAttributes() ?>>
<?php echo $ref->q_sku->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$ref->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $ref_view->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_view->MultiPages->isActive("2")) ?>" href="#tab_ref2"><?php echo $ref->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_view->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $ref_view->MultiPages->Parent ?>" id="tab_ref2">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref->cbm->Visible) { // cbm ?>
	<tr id="r_cbm">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_cbm"><?php echo $ref->cbm->caption() ?></span></td>
		<td data-name="cbm"<?php echo $ref->cbm->cellAttributes() ?>>
<span id="el_ref_cbm" data-page="2">
<span<?php echo $ref->cbm->viewAttributes() ?>>
<?php echo $ref->cbm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_sqm"><?php echo $ref->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $ref->sqm->cellAttributes() ?>>
<span id="el_ref_sqm" data-page="2">
<span<?php echo $ref->sqm->viewAttributes() ?>>
<?php echo $ref->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->shape->Visible) { // shape ?>
	<tr id="r_shape">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_shape"><?php echo $ref->shape->caption() ?></span></td>
		<td data-name="shape"<?php echo $ref->shape->cellAttributes() ?>>
<span id="el_ref_shape" data-page="2">
<span<?php echo $ref->shape->viewAttributes() ?>>
<?php echo $ref->shape->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_01->Visible) { // b_01 ?>
	<tr id="r_b_01">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_01"><?php echo $ref->b_01->caption() ?></span></td>
		<td data-name="b_01"<?php echo $ref->b_01->cellAttributes() ?>>
<span id="el_ref_b_01" data-page="2">
<span<?php echo $ref->b_01->viewAttributes() ?>>
<?php echo $ref->b_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_02->Visible) { // b_02 ?>
	<tr id="r_b_02">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_02"><?php echo $ref->b_02->caption() ?></span></td>
		<td data-name="b_02"<?php echo $ref->b_02->cellAttributes() ?>>
<span id="el_ref_b_02" data-page="2">
<span<?php echo $ref->b_02->viewAttributes() ?>>
<?php echo $ref->b_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_03->Visible) { // b_03 ?>
	<tr id="r_b_03">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_03"><?php echo $ref->b_03->caption() ?></span></td>
		<td data-name="b_03"<?php echo $ref->b_03->cellAttributes() ?>>
<span id="el_ref_b_03" data-page="2">
<span<?php echo $ref->b_03->viewAttributes() ?>>
<?php echo $ref->b_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_04->Visible) { // b_04 ?>
	<tr id="r_b_04">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_04"><?php echo $ref->b_04->caption() ?></span></td>
		<td data-name="b_04"<?php echo $ref->b_04->cellAttributes() ?>>
<span id="el_ref_b_04" data-page="2">
<span<?php echo $ref->b_04->viewAttributes() ?>>
<?php echo $ref->b_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_05->Visible) { // b_05 ?>
	<tr id="r_b_05">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_05"><?php echo $ref->b_05->caption() ?></span></td>
		<td data-name="b_05"<?php echo $ref->b_05->cellAttributes() ?>>
<span id="el_ref_b_05" data-page="2">
<span<?php echo $ref->b_05->viewAttributes() ?>>
<?php echo $ref->b_05->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_06->Visible) { // b_06 ?>
	<tr id="r_b_06">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_06"><?php echo $ref->b_06->caption() ?></span></td>
		<td data-name="b_06"<?php echo $ref->b_06->cellAttributes() ?>>
<span id="el_ref_b_06" data-page="2">
<span<?php echo $ref->b_06->viewAttributes() ?>>
<?php echo $ref->b_06->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_07->Visible) { // b_07 ?>
	<tr id="r_b_07">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_07"><?php echo $ref->b_07->caption() ?></span></td>
		<td data-name="b_07"<?php echo $ref->b_07->cellAttributes() ?>>
<span id="el_ref_b_07" data-page="2">
<span<?php echo $ref->b_07->viewAttributes() ?>>
<?php echo $ref->b_07->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_08->Visible) { // b_08 ?>
	<tr id="r_b_08">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_08"><?php echo $ref->b_08->caption() ?></span></td>
		<td data-name="b_08"<?php echo $ref->b_08->cellAttributes() ?>>
<span id="el_ref_b_08" data-page="2">
<span<?php echo $ref->b_08->viewAttributes() ?>>
<?php echo $ref->b_08->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_09->Visible) { // b_09 ?>
	<tr id="r_b_09">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_09"><?php echo $ref->b_09->caption() ?></span></td>
		<td data-name="b_09"<?php echo $ref->b_09->cellAttributes() ?>>
<span id="el_ref_b_09" data-page="2">
<span<?php echo $ref->b_09->viewAttributes() ?>>
<?php echo $ref->b_09->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_10->Visible) { // b_10 ?>
	<tr id="r_b_10">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_10"><?php echo $ref->b_10->caption() ?></span></td>
		<td data-name="b_10"<?php echo $ref->b_10->cellAttributes() ?>>
<span id="el_ref_b_10" data-page="2">
<span<?php echo $ref->b_10->viewAttributes() ?>>
<?php echo $ref->b_10->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_11->Visible) { // b_11 ?>
	<tr id="r_b_11">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_11"><?php echo $ref->b_11->caption() ?></span></td>
		<td data-name="b_11"<?php echo $ref->b_11->cellAttributes() ?>>
<span id="el_ref_b_11" data-page="2">
<span<?php echo $ref->b_11->viewAttributes() ?>>
<?php echo $ref->b_11->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_12->Visible) { // b_12 ?>
	<tr id="r_b_12">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_12"><?php echo $ref->b_12->caption() ?></span></td>
		<td data-name="b_12"<?php echo $ref->b_12->cellAttributes() ?>>
<span id="el_ref_b_12" data-page="2">
<span<?php echo $ref->b_12->viewAttributes() ?>>
<?php echo $ref->b_12->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_13->Visible) { // b_13 ?>
	<tr id="r_b_13">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_13"><?php echo $ref->b_13->caption() ?></span></td>
		<td data-name="b_13"<?php echo $ref->b_13->cellAttributes() ?>>
<span id="el_ref_b_13" data-page="2">
<span<?php echo $ref->b_13->viewAttributes() ?>>
<?php echo $ref->b_13->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_14->Visible) { // b_14 ?>
	<tr id="r_b_14">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_14"><?php echo $ref->b_14->caption() ?></span></td>
		<td data-name="b_14"<?php echo $ref->b_14->cellAttributes() ?>>
<span id="el_ref_b_14" data-page="2">
<span<?php echo $ref->b_14->viewAttributes() ?>>
<?php echo $ref->b_14->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->b_15->Visible) { // b_15 ?>
	<tr id="r_b_15">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_b_15"><?php echo $ref->b_15->caption() ?></span></td>
		<td data-name="b_15"<?php echo $ref->b_15->cellAttributes() ?>>
<span id="el_ref_b_15" data-page="2">
<span<?php echo $ref->b_15->viewAttributes() ?>>
<?php echo $ref->b_15->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$ref->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $ref_view->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_view->MultiPages->isActive("3")) ?>" href="#tab_ref3"><?php echo $ref->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_view->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $ref_view->MultiPages->Parent ?>" id="tab_ref3">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref->t_01->Visible) { // t_01 ?>
	<tr id="r_t_01">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_01"><?php echo $ref->t_01->caption() ?></span></td>
		<td data-name="t_01"<?php echo $ref->t_01->cellAttributes() ?>>
<span id="el_ref_t_01" data-page="3">
<span<?php echo $ref->t_01->viewAttributes() ?>>
<?php echo $ref->t_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_02->Visible) { // t_02 ?>
	<tr id="r_t_02">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_02"><?php echo $ref->t_02->caption() ?></span></td>
		<td data-name="t_02"<?php echo $ref->t_02->cellAttributes() ?>>
<span id="el_ref_t_02" data-page="3">
<span<?php echo $ref->t_02->viewAttributes() ?>>
<?php echo $ref->t_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_03->Visible) { // t_03 ?>
	<tr id="r_t_03">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_03"><?php echo $ref->t_03->caption() ?></span></td>
		<td data-name="t_03"<?php echo $ref->t_03->cellAttributes() ?>>
<span id="el_ref_t_03" data-page="3">
<span<?php echo $ref->t_03->viewAttributes() ?>>
<?php echo $ref->t_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_04->Visible) { // t_04 ?>
	<tr id="r_t_04">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_04"><?php echo $ref->t_04->caption() ?></span></td>
		<td data-name="t_04"<?php echo $ref->t_04->cellAttributes() ?>>
<span id="el_ref_t_04" data-page="3">
<span<?php echo $ref->t_04->viewAttributes() ?>>
<?php echo $ref->t_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_05->Visible) { // t_05 ?>
	<tr id="r_t_05">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_05"><?php echo $ref->t_05->caption() ?></span></td>
		<td data-name="t_05"<?php echo $ref->t_05->cellAttributes() ?>>
<span id="el_ref_t_05" data-page="3">
<span<?php echo $ref->t_05->viewAttributes() ?>>
<?php echo $ref->t_05->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_06->Visible) { // t_06 ?>
	<tr id="r_t_06">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_06"><?php echo $ref->t_06->caption() ?></span></td>
		<td data-name="t_06"<?php echo $ref->t_06->cellAttributes() ?>>
<span id="el_ref_t_06" data-page="3">
<span<?php echo $ref->t_06->viewAttributes() ?>>
<?php echo $ref->t_06->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_07->Visible) { // t_07 ?>
	<tr id="r_t_07">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_07"><?php echo $ref->t_07->caption() ?></span></td>
		<td data-name="t_07"<?php echo $ref->t_07->cellAttributes() ?>>
<span id="el_ref_t_07" data-page="3">
<span<?php echo $ref->t_07->viewAttributes() ?>>
<?php echo $ref->t_07->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_08->Visible) { // t_08 ?>
	<tr id="r_t_08">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_08"><?php echo $ref->t_08->caption() ?></span></td>
		<td data-name="t_08"<?php echo $ref->t_08->cellAttributes() ?>>
<span id="el_ref_t_08" data-page="3">
<span<?php echo $ref->t_08->viewAttributes() ?>>
<?php echo $ref->t_08->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_09->Visible) { // t_09 ?>
	<tr id="r_t_09">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_09"><?php echo $ref->t_09->caption() ?></span></td>
		<td data-name="t_09"<?php echo $ref->t_09->cellAttributes() ?>>
<span id="el_ref_t_09" data-page="3">
<span<?php echo $ref->t_09->viewAttributes() ?>>
<?php echo $ref->t_09->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_10->Visible) { // t_10 ?>
	<tr id="r_t_10">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_10"><?php echo $ref->t_10->caption() ?></span></td>
		<td data-name="t_10"<?php echo $ref->t_10->cellAttributes() ?>>
<span id="el_ref_t_10" data-page="3">
<span<?php echo $ref->t_10->viewAttributes() ?>>
<?php echo $ref->t_10->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_11->Visible) { // t_11 ?>
	<tr id="r_t_11">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_11"><?php echo $ref->t_11->caption() ?></span></td>
		<td data-name="t_11"<?php echo $ref->t_11->cellAttributes() ?>>
<span id="el_ref_t_11" data-page="3">
<span<?php echo $ref->t_11->viewAttributes() ?>>
<?php echo $ref->t_11->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_12->Visible) { // t_12 ?>
	<tr id="r_t_12">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_12"><?php echo $ref->t_12->caption() ?></span></td>
		<td data-name="t_12"<?php echo $ref->t_12->cellAttributes() ?>>
<span id="el_ref_t_12" data-page="3">
<span<?php echo $ref->t_12->viewAttributes() ?>>
<?php echo $ref->t_12->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_13->Visible) { // t_13 ?>
	<tr id="r_t_13">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_13"><?php echo $ref->t_13->caption() ?></span></td>
		<td data-name="t_13"<?php echo $ref->t_13->cellAttributes() ?>>
<span id="el_ref_t_13" data-page="3">
<span<?php echo $ref->t_13->viewAttributes() ?>>
<?php echo $ref->t_13->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_14->Visible) { // t_14 ?>
	<tr id="r_t_14">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_14"><?php echo $ref->t_14->caption() ?></span></td>
		<td data-name="t_14"<?php echo $ref->t_14->cellAttributes() ?>>
<span id="el_ref_t_14" data-page="3">
<span<?php echo $ref->t_14->viewAttributes() ?>>
<?php echo $ref->t_14->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->t_15->Visible) { // t_15 ?>
	<tr id="r_t_15">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_t_15"><?php echo $ref->t_15->caption() ?></span></td>
		<td data-name="t_15"<?php echo $ref->t_15->cellAttributes() ?>>
<span id="el_ref_t_15" data-page="3">
<span<?php echo $ref->t_15->viewAttributes() ?>>
<?php echo $ref->t_15->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$ref->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $ref_view->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_view->MultiPages->isActive("4")) ?>" href="#tab_ref4"><?php echo $ref->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_view->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $ref_view->MultiPages->Parent ?>" id="tab_ref4">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref->d_head_01->Visible) { // d_head_01 ?>
	<tr id="r_d_head_01">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_d_head_01"><?php echo $ref->d_head_01->caption() ?></span></td>
		<td data-name="d_head_01"<?php echo $ref->d_head_01->cellAttributes() ?>>
<span id="el_ref_d_head_01" data-page="4">
<span<?php echo $ref->d_head_01->viewAttributes() ?>>
<?php echo $ref->d_head_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->d_description_01->Visible) { // d_description_01 ?>
	<tr id="r_d_description_01">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_d_description_01"><?php echo $ref->d_description_01->caption() ?></span></td>
		<td data-name="d_description_01"<?php echo $ref->d_description_01->cellAttributes() ?>>
<span id="el_ref_d_description_01" data-page="4">
<span<?php echo $ref->d_description_01->viewAttributes() ?>>
<?php echo $ref->d_description_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->d_head_02->Visible) { // d_head_02 ?>
	<tr id="r_d_head_02">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_d_head_02"><?php echo $ref->d_head_02->caption() ?></span></td>
		<td data-name="d_head_02"<?php echo $ref->d_head_02->cellAttributes() ?>>
<span id="el_ref_d_head_02" data-page="4">
<span<?php echo $ref->d_head_02->viewAttributes() ?>>
<?php echo $ref->d_head_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->d_description_02->Visible) { // d_description_02 ?>
	<tr id="r_d_description_02">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_d_description_02"><?php echo $ref->d_description_02->caption() ?></span></td>
		<td data-name="d_description_02"<?php echo $ref->d_description_02->cellAttributes() ?>>
<span id="el_ref_d_description_02" data-page="4">
<span<?php echo $ref->d_description_02->viewAttributes() ?>>
<?php echo $ref->d_description_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$ref->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $ref_view->MultiPages->pageStyle("5") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_view->MultiPages->isActive("5")) ?>" href="#tab_ref5"><?php echo $ref->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_view->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $ref_view->MultiPages->Parent ?>" id="tab_ref5">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref->main_image->Visible) { // main_image ?>
	<tr id="r_main_image">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_main_image"><?php echo $ref->main_image->caption() ?></span></td>
		<td data-name="main_image"<?php echo $ref->main_image->cellAttributes() ?>>
<span id="el_ref_main_image" data-page="5">
<span>
<?php echo GetFileViewTag($ref->main_image, $ref->main_image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->top_view->Visible) { // top_view ?>
	<tr id="r_top_view">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_top_view"><?php echo $ref->top_view->caption() ?></span></td>
		<td data-name="top_view"<?php echo $ref->top_view->cellAttributes() ?>>
<span id="el_ref_top_view" data-page="5">
<span>
<?php echo GetFileViewTag($ref->top_view, $ref->top_view->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->front_view->Visible) { // front_view ?>
	<tr id="r_front_view">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_front_view"><?php echo $ref->front_view->caption() ?></span></td>
		<td data-name="front_view"<?php echo $ref->front_view->cellAttributes() ?>>
<span id="el_ref_front_view" data-page="5">
<span>
<?php echo GetFileViewTag($ref->front_view, $ref->front_view->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->corner_view->Visible) { // corner_view ?>
	<tr id="r_corner_view">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_corner_view"><?php echo $ref->corner_view->caption() ?></span></td>
		<td data-name="corner_view"<?php echo $ref->corner_view->cellAttributes() ?>>
<span id="el_ref_corner_view" data-page="5">
<span>
<?php echo GetFileViewTag($ref->corner_view, $ref->corner_view->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->back_view->Visible) { // back_view ?>
	<tr id="r_back_view">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_back_view"><?php echo $ref->back_view->caption() ?></span></td>
		<td data-name="back_view"<?php echo $ref->back_view->cellAttributes() ?>>
<span id="el_ref_back_view" data-page="5">
<span>
<?php echo GetFileViewTag($ref->back_view, $ref->back_view->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->color_options->Visible) { // color_options ?>
	<tr id="r_color_options">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_color_options"><?php echo $ref->color_options->caption() ?></span></td>
		<td data-name="color_options"<?php echo $ref->color_options->cellAttributes() ?>>
<span id="el_ref_color_options" data-page="5">
<span>
<?php echo GetFileViewTag($ref->color_options, $ref->color_options->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->other_options->Visible) { // other_options ?>
	<tr id="r_other_options">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_other_options"><?php echo $ref->other_options->caption() ?></span></td>
		<td data-name="other_options"<?php echo $ref->other_options->cellAttributes() ?>>
<span id="el_ref_other_options" data-page="5">
<span>
<?php echo GetFileViewTag($ref->other_options, $ref->other_options->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->group_image->Visible) { // group_image ?>
	<tr id="r_group_image">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_group_image"><?php echo $ref->group_image->caption() ?></span></td>
		<td data-name="group_image"<?php echo $ref->group_image->cellAttributes() ?>>
<span id="el_ref_group_image" data-page="5">
<span<?php echo $ref->group_image->viewAttributes() ?>>
<?php echo GetFileViewTag($ref->group_image, $ref->group_image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->video_url->Visible) { // video_url ?>
	<tr id="r_video_url">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_video_url"><?php echo $ref->video_url->caption() ?></span></td>
		<td data-name="video_url"<?php echo $ref->video_url->cellAttributes() ?>>
<span id="el_ref_video_url" data-page="5">
<span<?php echo $ref->video_url->viewAttributes() ?>>
<?php echo $ref->video_url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_image"><?php echo $ref->image->caption() ?></span></td>
		<td data-name="image"<?php echo $ref->image->cellAttributes() ?>>
<span id="el_ref_image" data-page="5">
<span>
<?php echo GetFileViewTag($ref->image, $ref->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$ref->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $ref_view->MultiPages->pageStyle("6") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($ref_view->MultiPages->isActive("6")) ?>" href="#tab_ref6"><?php echo $ref->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $ref_view->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $ref_view->MultiPages->Parent ?>" id="tab_ref6">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($ref->last_price->Visible) { // last_price ?>
	<tr id="r_last_price">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_last_price"><?php echo $ref->last_price->caption() ?></span></td>
		<td data-name="last_price"<?php echo $ref->last_price->cellAttributes() ?>>
<span id="el_ref_last_price" data-page="6">
<span<?php echo $ref->last_price->viewAttributes() ?>>
<?php echo $ref->last_price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->currency->Visible) { // currency ?>
	<tr id="r_currency">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_currency"><?php echo $ref->currency->caption() ?></span></td>
		<td data-name="currency"<?php echo $ref->currency->cellAttributes() ?>>
<span id="el_ref_currency" data-page="6">
<span<?php echo $ref->currency->viewAttributes() ?>>
<?php echo $ref->currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->hsn->Visible) { // hsn ?>
	<tr id="r_hsn">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_hsn"><?php echo $ref->hsn->caption() ?></span></td>
		<td data-name="hsn"<?php echo $ref->hsn->cellAttributes() ?>>
<span id="el_ref_hsn" data-page="6">
<span<?php echo $ref->hsn->viewAttributes() ?>>
<?php echo $ref->hsn->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->composition->Visible) { // composition ?>
	<tr id="r_composition">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_composition"><?php echo $ref->composition->caption() ?></span></td>
		<td data-name="composition"<?php echo $ref->composition->cellAttributes() ?>>
<span id="el_ref_composition" data-page="6">
<span<?php echo $ref->composition->viewAttributes() ?>>
<?php echo $ref->composition->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_category"><?php echo $ref->category->caption() ?></span></td>
		<td data-name="category"<?php echo $ref->category->cellAttributes() ?>>
<span id="el_ref_category" data-page="6">
<span<?php echo $ref->category->viewAttributes() ?>>
<?php echo $ref->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->moq->Visible) { // moq ?>
	<tr id="r_moq">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_moq"><?php echo $ref->moq->caption() ?></span></td>
		<td data-name="moq"<?php echo $ref->moq->cellAttributes() ?>>
<span id="el_ref_moq" data-page="6">
<span<?php echo $ref->moq->viewAttributes() ?>>
<?php echo $ref->moq->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_status"><?php echo $ref->status->caption() ?></span></td>
		<td data-name="status"<?php echo $ref->status->cellAttributes() ?>>
<span id="el_ref_status" data-page="6">
<span<?php echo $ref->status->viewAttributes() ?>>
<?php echo $ref->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->publish->Visible) { // publish ?>
	<tr id="r_publish">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_publish"><?php echo $ref->publish->caption() ?></span></td>
		<td data-name="publish"<?php echo $ref->publish->cellAttributes() ?>>
<span id="el_ref_publish" data-page="6">
<span<?php echo $ref->publish->viewAttributes() ?>>
<?php echo $ref->publish->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->keywords->Visible) { // keywords ?>
	<tr id="r_keywords">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_keywords"><?php echo $ref->keywords->caption() ?></span></td>
		<td data-name="keywords"<?php echo $ref->keywords->cellAttributes() ?>>
<span id="el_ref_keywords" data-page="6">
<span<?php echo $ref->keywords->viewAttributes() ?>>
<?php echo $ref->keywords->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_operator"><?php echo $ref->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $ref->operator->cellAttributes() ?>>
<span id="el_ref_operator" data-page="6">
<span<?php echo $ref->operator->viewAttributes() ?>>
<?php echo $ref->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ref->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $ref_view->TableLeftColumnClass ?>"><span id="elh_ref_datetime"><?php echo $ref->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $ref->datetime->cellAttributes() ?>>
<span id="el_ref_datetime" data-page="6">
<span<?php echo $ref->datetime->viewAttributes() ?>>
<?php echo $ref->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$ref->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$ref->isExport()) { ?>
</div>
</div>
<?php } ?>
<?php
	if (in_array("multiple_price", explode(",", $ref->getCurrentDetailTable())) && $multiple_price->DetailView) {
?>
<?php if ($ref->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("multiple_price", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "multiple_pricegrid.php" ?>
<?php } ?>
<?php
	if (in_array("partner_product_ref", explode(",", $ref->getCurrentDetailTable())) && $partner_product_ref->DetailView) {
?>
<?php if ($ref->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("partner_product_ref", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "partner_product_refgrid.php" ?>
<?php } ?>
</form>
<?php
$ref_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ref->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");
// Write your table-specific startup script here
// document.write("page loaded");

		var SGrp = $("#x_s_grp").val();
		var product_type = $("#x_product_type").val();
		if (product_type == 8)
		{
		$("#r_set_ref").show();
		$("#r_v_00").hide();		
		$("#r_v_01").hide();
		$("#r_v_02").hide();
		$("#r_v_03").hide();
		$("#r_v_04").hide();
		$("#r_v_05").hide();
		$("#r_v_06").hide();
		$("#r_v_07").hide();
		$("#r_v_08").hide();
		$("#r_v_09").hide();
		$("#r_v_10").hide();
		} else {
		$("#r_set_ref").hide();
		}
		if (SGrp.length > 0)
		{
		$.getJSON("apcajax.php?getHead="+SGrp,function(data){
			 		if (data.cbm == '--NA--') {
					$("#r_cbm").hide(); } else {
					$("#r_cbm").show();						
					$("#elh_ref_cbm").html(data.cbm);}
					if (data.sqm == '--NA--') {
					$("#r_sqm").hide(); } else {
					$("#r_sqm").show()					
					$("#elh_ref_sqm").html(data.sqm);}
					if (data.shape == '--NA--') {
					$("#r_shape").hide(); } else {
					$("#r_shape").show()					
					$("#elh_ref_shape").html(data.shape);}
					if (data.v_00 == '--NA--') {
					$("#r_v_00").hide(); } else {
					$("#r_v_00").show();					
					$("#elh_ref_v_00").html(data.v_00);}
					if (data.v_01 == '--NA--') {
					$("#sv_x_v_01").val('');
					$("#r_v_01").hide(); } else {
					$("#r_v_01").show();					
					$("#elh_ref_v_01").html(data.v_01);}
					if (data.v_02 == '--NA--') {
					$("#sv_x_v_02").val('');
					$("#r_v_02").hide(); } else {
					$("#r_v_02").show()					
					$("#elh_ref_v_02").html(data.v_02);}
					if (data.v_03 == '--NA--') {
					$("#sv_x_v_03").val('');
					$("#r_v_03").hide(); } else {
					$("#r_v_03").show()					
					$("#elh_ref_v_03").html(data.v_03);}
					if (data.v_04 == '--NA--') {
					$("#sv_x_v_04").val('');
					$("#r_v_04").hide(); } else {
					$("#r_v_04").show()		
					$("#elh_ref_v_04").html(data.v_04);}
					if (data.v_05 == '--NA--') {
					$("#sv_x_v_05").val('');
					$("#r_v_05").hide(); } else {
					$("#r_v_05").show();					
					$("#elh_ref_v_05").html(data.v_05);}
					if (data.v_06 == '--NA--') {
					$("#sv_x_v_06").val('');
					$("#r_v_06").hide(); } else {
					$("#r_v_06").show()		
					$("#elh_ref_v_06").html(data.v_06);}
					if (data.v_07 == '--NA--') {
					$("#sv_x_v_07").val('');
					$("#r_v_07").hide(); } else {						
					$("#r_v_07").show();
					$("#elh_ref_v_07").html(data.v_07);}
					if (data.v_08 == '--NA--') {
					$("#sv_x_v_08").val('');
					$("#r_v_08").hide(); } else {						
					$("#r_v_08").show();
					$("#elh_ref_v_08").html(data.v_08);}
					if (data.v_09 == '--NA--') {
					$("#sv_x_v_09").val('');
					$("#r_v_09").hide(); } else {						
					$("#r_v_09").show();
					$("#elh_ref_v_09").html(data.v_09);}
					if (data.v_10 == '--NA--') {
					$("#sv_x_v_10").val('');
					$("#r_v_10").hide(); } else {						
					$("#r_v_10").show();
					$("#elh_ref_v_10").html(data.v_10);}
					if (data.b_01_head == '--NA--') {
					$("#r_b_01").hide(); } else {
					$("#r_b_01").show();
					$("#elh_ref_b_01").html(data.b_01_head);}
					if (data.b_02_head == '--NA--') {
					$("#r_b_02").hide(); } else {
					$("#r_b_02").show();
					$("#elh_ref_b_02").html(data.b_02_head);}
					if (data.b_03_head == '--NA--') {
					$("#r_b_03").hide(); } else {
					$("#r_b_03").show();
					$("#elh_ref_b_03").html(data.b_03_head);}
					if (data.b_04_head == '--NA--') {
					$("#r_b_04").hide(); } else {
					$("#r_b_04").show();
					$("#elh_ref_b_04").html(data.b_04_head);}
					if (data.b_05_head == '--NA--') {
					$("#r_b_05").hide(); } else {
					$("#r_b_05").show();
					$("#elh_ref_b_05").html(data.b_05_head);}
					if (data.b_06_head == '--NA--') {
					$("#r_b_06").hide(); } else {
					$("#r_b_06").show();
					$("#elh_ref_b_06").html(data.b_06_head);}
					if (data.b_07_head == '--NA--') {
					$("#r_b_07").hide(); } else {
					$("#r_b_07").show();
					$("#elh_ref_b_07").html(data.b_07_head);}
					if (data.b_08_head == '--NA--') {
					$("#r_b_08").hide(); } else {
					$("#r_b_08").show();
					$("#elh_ref_b_08").html(data.b_08_head);}
					if (data.b_09_head == '--NA--') {
					$("#r_b_09").hide(); } else {
					$("#r_b_09").show();
					$("#elh_ref_b_09").html(data.b_09_head);}
					if (data.b_10_head == '--NA--') {
					$("#r_b_10").hide(); } else {
					$("#r_b_10").show();
					$("#elh_ref_b_10").html(data.b_10_head);}
					if (data.b_11_head == '--NA--') {
					$("#r_b_11").hide(); } else {
					$("#r_b_11").show();
					$("#elh_ref_b_11").html(data.b_11_head);}
					if (data.b_12_head == '--NA--') {
					$("#r_b_12").hide(); } else {
					$("#r_b_12").show();
					$("#elh_ref_b_12").html(data.b_12_head);}
					if (data.b_13_head == '--NA--') {
					$("#r_b_13").hide(); } else {
					$("#r_b_13").show();
					$("#elh_ref_b_13").html(data.b_13_head);}
					if (data.b_14_head == '--NA--') {
					$("#r_b_14").hide(); } else {
					$("#r_b_14").show();	
					$("#elh_ref_b_14").html(data.b_14_head);}
					if (data.b_15_head == '--NA--') {
					$("#r_b_15").hide(); } else {
					$("#r_b_15").show();
					$("#elh_ref_b_15").html(data.b_15_head);}
					if (data.q_sku == '--NA--') {
					$("#r_q_sku").hide(); } else {
					$("#r_q_sku").show();
					$("#elh_ref_q_sku").html(data.q_sku);}
					if (data.t_01_head == '--NA--') {
					$("#r_t_01").hide(); } else {
					$("#r_t_01").show();
					$("#elh_ref_t_01").html(data.t_01_head);}
					if (data.t_02_head == '--NA--') {
					$("#r_t_02").hide(); } else {
					$("#r_t_02").show();
					$("#elh_ref_t_02").html(data.t_02_head);}
					if (data.t_03_head == '--NA--') {
					$("#r_t_03").hide(); } else {
					$("#r_t_03").show();
					$("#elh_ref_t_03").html(data.t_03_head);}
					if (data.t_04_head == '--NA--') {
					$("#r_t_04").hide(); } else {
					$("#r_t_04").show();
					$("#elh_ref_t_04").html(data.t_04_head);}
					if (data.t_05_head == '--NA--') {
					$("#r_t_05").hide(); } else {
					$("#r_t_05").show();
					$("#elh_ref_t_05").html(data.t_05_head);}
					if (data.t_06_head == '--NA--') {
					$("#r_t_06").hide(); } else {
					$("#r_t_06").show();
					$("#elh_ref_t_06").html(data.t_06_head);}
					if (data.t_07_head == '--NA--') {
					$("#r_t_07").hide(); } else {
					$("#r_t_07").show();
					$("#elh_ref_t_07").html(data.t_07_head);}
					if (data.t_08_head == '--NA--') {
					$("#r_t_08").hide(); } else {
					$("#r_t_08").show();
					$("#elh_ref_t_08").html(data.t_08_head);}
					if (data.t_09_head == '--NA--') {
					$("#r_t_09").hide(); } else {
					$("#r_t_09").show();
					$("#elh_ref_t_09").html(data.t_09_head);}
					if (data.t_10_head == '--NA--') {
					$("#r_t_10").hide(); } else {
					$("#r_t_10").show();
					$("#elh_ref_t_10").html(data.t_10_head);}
					if (data.t_11_head == '--NA--') {
					$("#r_t_11").hide(); } else {
					$("#r_t_11").show();
					$("#elh_ref_t_11").html(data.t_11_head);}
					if (data.t_12_head == '--NA--') {
					$("#r_t_12").hide(); } else {
					$("#r_t_12").show();
					$("#elh_ref_t_12").html(data.t_12_head);}
					if (data.t_13_head == '--NA--') {
					$("#r_t_13").hide(); } else {
					$("#r_t_13").show();
					$("#elh_ref_t_13").html(data.t_13_head);}
					if (data.t_14_head == '--NA--') {
					$("#r_t_14").hide(); } else {
					$("#r_t_14").show();
					$("#elh_ref_t_14").html(data.t_14_head);}
					if (data.t_15_head == '--NA--') {
					$("#r_t_15").hide(); } else {
					$("#r_t_15").show();
					$("#elh_ref_t_15").html(data.t_15_head);}
					if (data.calculation_method == 1) {
					var lastprice = 'Current Price / SQM';
					} else if (data.calculation_method == 2) {
					var lastprice = 'Current Price / SKU';
					}
					$("#elh_ref_last_price").html(lastprice);
		});
		}
</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ref_view->terminate();
?>