<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$register = new register();

// Run the page
$register->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$register->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "register";
var fregister = currentForm = new ew.Form("fregister", "register");

// Validate form
fregister.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($register->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->mobile->caption(), $admin->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($register->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->formal_name->caption(), $admin->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($register->password->Required) { ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, ew.language.phrase("EnterPassword"));
		<?php } ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && $(elm).hasClass("ew-password-strength") && !$(elm).data("validated"))
				return this.onError(elm, ew.language.phrase("PasswordTooSimple"));
			if (fobj.c_password.value != fobj.x_password.value)
				return this.onError(fobj.c_password, ew.language.phrase("MismatchPassword"));
		<?php if ($register->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, ew.language.phrase("EnterUserName"));
		<?php } ?>
		<?php if ($register->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->address->caption(), $admin->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($register->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->_email->caption(), $admin->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin->_email->errorMessage()) ?>");
		<?php if ($register->reg_ip->Required) { ?>
			elm = this.getElements("x" + infix + "_reg_ip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->reg_ip->caption(), $admin->reg_ip->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
		if (fobj.captcha && !ew.hasValue(fobj.captcha))
			return this.onError(fobj.captcha, ew.language.phrase("EnterValidateCode"));
	return true;
}

// Form_CustomValidate event
fregister.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fregister.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $register->showPageHeader(); ?>
<?php
$register->showMessage();
?>
<form name="fregister" id="fregister" class="<?php echo $register->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($register->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $register->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="admin">
<input type="hidden" name="action" id="action" value="insert">
<!-- Fields to prevent google autofill -->
<input type="hidden" type="text" name="<?php echo Encrypt(Random()) ?>">
<input type="hidden" type="password" name="<?php echo Encrypt(Random()) ?>">
<?php if ($admin->isConfirm()) { // Confirm page ?>
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } ?>
<div class="ew-register-div"><!-- page* -->
<?php if ($admin->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_admin_mobile" for="x_mobile" class="<?php echo $register->LeftColumnClass ?>"><?php echo $admin->mobile->caption() ?><?php echo ($admin->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $admin->mobile->cellAttributes() ?>>
<?php if (!$admin->isConfirm()) { ?>
<span id="el_admin_mobile">
<input type="text" data-table="admin" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" placeholder="<?php echo HtmlEncode($admin->mobile->getPlaceHolder()) ?>" value="<?php echo $admin->mobile->EditValue ?>"<?php echo $admin->mobile->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_admin_mobile">
<span<?php echo $admin->mobile->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($admin->mobile->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="admin" data-field="x_mobile" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($admin->mobile->FormValue) ?>">
<?php } ?>
<?php echo $admin->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label id="elh_admin_formal_name" for="x_formal_name" class="<?php echo $register->LeftColumnClass ?>"><?php echo $admin->formal_name->caption() ?><?php echo ($admin->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $admin->formal_name->cellAttributes() ?>>
<?php if (!$admin->isConfirm()) { ?>
<span id="el_admin_formal_name">
<input type="text" data-table="admin" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin->formal_name->getPlaceHolder()) ?>" value="<?php echo $admin->formal_name->EditValue ?>"<?php echo $admin->formal_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_admin_formal_name">
<span<?php echo $admin->formal_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($admin->formal_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="admin" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" value="<?php echo HtmlEncode($admin->formal_name->FormValue) ?>">
<?php } ?>
<?php echo $admin->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->password->Visible) { // password ?>
	<div id="r_password" class="form-group row">
		<label id="elh_admin_password" for="x_password" class="<?php echo $register->LeftColumnClass ?>"><?php echo $admin->password->caption() ?><?php echo ($admin->password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $admin->password->cellAttributes() ?>>
<?php if (!$admin->isConfirm()) { ?>
<span id="el_admin_password">
<div class="input-group" id="ig_password">
<input type="password" data-password-strength="pst_password" data-password-generated="pgt_password" data-table="admin" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($admin->password->getPlaceHolder()) ?>"<?php echo $admin->password->editAttributes() ?>>
<div class="input-group-append">
	<button type="button" class="btn btn-default ew-password-generator" title="<?php echo HtmlTitle($Language->phrase("GeneratePassword")) ?>" data-password-field="x_password" data-password-confirm="c_password" data-password-strength="pst_password" data-password-generated="pgt_password"><?php echo $Language->phrase("GeneratePassword") ?></button>
</div>
</div>
<small class="form-text d-none" id="pgt_password"></small>
<div class="progress ew-password-strength-bar form-text mt-1 d-none" id="pst_password">
	<div class="progress-bar" role="progressbar"></div>
</div>
</span>
<?php } else { ?>
<span id="el_admin_password">
<span<?php echo $admin->password->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($admin->password->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="admin" data-field="x_password" name="x_password" id="x_password" value="<?php echo HtmlEncode($admin->password->FormValue) ?>">
<?php } ?>
<?php echo $admin->password->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->password->Visible) { // password ?>
	<div id="r_c_password" class="form-group row">
		<label id="elh_c_admin_password" for="c_password" class="<?php echo $register->LeftColumnClass ?>"><?php echo $Language->phrase("Confirm") ?> <?php echo $admin->password->caption() ?><?php echo ($admin->password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $admin->password->cellAttributes() ?>>
<?php if (!$admin->isConfirm()) { ?>
<span id="el_c_admin_password">
<input type="password" data-field="c_password" name="c_password" id="c_password" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($admin->password->getPlaceHolder()) ?>"<?php echo $admin->password->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_c_admin_password">
<span<?php echo $admin->password->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($admin->password->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="admin" data-field="c_password" name="c_password" id="c_password" value="<?php echo HtmlEncode($admin->password->FormValue) ?>">
<?php } ?>
</div></div>
	</div>
<?php } ?>
<?php if ($admin->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label id="elh_admin_user_name" for="x_user_name" class="<?php echo $register->LeftColumnClass ?>"><?php echo $admin->user_name->caption() ?><?php echo ($admin->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $admin->user_name->cellAttributes() ?>>
<?php if (!$admin->isConfirm()) { ?>
<span id="el_admin_user_name">
<input type="text" data-table="admin" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin->user_name->getPlaceHolder()) ?>" value="<?php echo $admin->user_name->EditValue ?>"<?php echo $admin->user_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_admin_user_name">
<span<?php echo $admin->user_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($admin->user_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="admin" data-field="x_user_name" name="x_user_name" id="x_user_name" value="<?php echo HtmlEncode($admin->user_name->FormValue) ?>">
<?php } ?>
<?php echo $admin->user_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_admin_address" for="x_address" class="<?php echo $register->LeftColumnClass ?>"><?php echo $admin->address->caption() ?><?php echo ($admin->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $admin->address->cellAttributes() ?>>
<?php if (!$admin->isConfirm()) { ?>
<span id="el_admin_address">
<textarea data-table="admin" data-field="x_address" name="x_address" id="x_address" cols="30" rows="3" placeholder="<?php echo HtmlEncode($admin->address->getPlaceHolder()) ?>"<?php echo $admin->address->editAttributes() ?>><?php echo $admin->address->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el_admin_address">
<span<?php echo $admin->address->viewAttributes() ?>>
<?php echo $admin->address->ViewValue ?></span>
</span>
<input type="hidden" data-table="admin" data-field="x_address" name="x_address" id="x_address" value="<?php echo HtmlEncode($admin->address->FormValue) ?>">
<?php } ?>
<?php echo $admin->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_admin__email" for="x__email" class="<?php echo $register->LeftColumnClass ?>"><?php echo $admin->_email->caption() ?><?php echo ($admin->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $register->RightColumnClass ?>"><div<?php echo $admin->_email->cellAttributes() ?>>
<?php if (!$admin->isConfirm()) { ?>
<span id="el_admin__email">
<input type="text" data-table="admin" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin->_email->getPlaceHolder()) ?>" value="<?php echo $admin->_email->EditValue ?>"<?php echo $admin->_email->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_admin__email">
<span<?php echo $admin->_email->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($admin->_email->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="admin" data-field="x__email" name="x__email" id="x__email" value="<?php echo HtmlEncode($admin->_email->FormValue) ?>">
<?php } ?>
<?php echo $admin->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$admin->isConfirm()) { ?>
<!-- captcha html (begin) -->
<div class="form-group row ew-captcha">
	<div class="col-sm-10 offset-sm-2">
	<p><img src="ewcaptcha.php" alt="" class="ew-captcha-image"></p>
	<input type="text" name="captcha" id="captcha" class="form-control ew-control" size="30" placeholder="<?php echo $Language->Phrase("EnterValidateCode") ?>">
	</div>
</div>
<?php } else { ?>
<input type="hidden" name="captcha" id="captcha" value="<?php echo $register->Captcha ?>">
<?php } ?>
<!-- captcha html (end) -->
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $register->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$admin->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("RegisterBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
</form>
<?php
$register->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$register->terminate();
?>