<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$rental_cart_list = new rental_cart_list();

// Run the page
$rental_cart_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$rental_cart_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$rental_cart->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var frental_cartlist = currentForm = new ew.Form("frental_cartlist", "list");
frental_cartlist.formKeyCountName = '<?php echo $rental_cart_list->FormKeyCountName ?>';

// Form_CustomValidate event
frental_cartlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frental_cartlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frental_cartlist.lists["x_company_id"] = <?php echo $rental_cart_list->company_id->Lookup->toClientList() ?>;
frental_cartlist.lists["x_company_id"].options = <?php echo JsonEncode($rental_cart_list->company_id->lookupOptions()) ?>;
frental_cartlist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_cartlist.lists["x_s_grp"] = <?php echo $rental_cart_list->s_grp->Lookup->toClientList() ?>;
frental_cartlist.lists["x_s_grp"].options = <?php echo JsonEncode($rental_cart_list->s_grp->lookupOptions()) ?>;
frental_cartlist.lists["x_product"] = <?php echo $rental_cart_list->product->Lookup->toClientList() ?>;
frental_cartlist.lists["x_product"].options = <?php echo JsonEncode($rental_cart_list->product->lookupOptions()) ?>;
frental_cartlist.lists["x_rid"] = <?php echo $rental_cart_list->rid->Lookup->toClientList() ?>;
frental_cartlist.lists["x_rid"].options = <?php echo JsonEncode($rental_cart_list->rid->lookupOptions()) ?>;
frental_cartlist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_cartlist.lists["x_packing_type"] = <?php echo $rental_cart_list->packing_type->Lookup->toClientList() ?>;
frental_cartlist.lists["x_packing_type"].options = <?php echo JsonEncode($rental_cart_list->packing_type->lookupOptions()) ?>;

// Form object for search
var frental_cartlistsrch = currentSearchForm = new ew.Form("frental_cartlistsrch");

// Filters
frental_cartlistsrch.filterList = <?php echo $rental_cart_list->getFilterList() ?>;

// Init search panel as collapsed
frental_cartlistsrch.initSearchPanel = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$rental_cart->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($rental_cart_list->TotalRecs > 0 && $rental_cart_list->ExportOptions->visible()) { ?>
<?php $rental_cart_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($rental_cart_list->ImportOptions->visible()) { ?>
<?php $rental_cart_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($rental_cart_list->SearchOptions->visible()) { ?>
<?php $rental_cart_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($rental_cart_list->FilterOptions->visible()) { ?>
<?php $rental_cart_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$rental_cart_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$rental_cart->isExport() && !$rental_cart->CurrentAction) { ?>
<form name="frental_cartlistsrch" id="frental_cartlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($rental_cart_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="frental_cartlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="rental_cart">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($rental_cart_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($rental_cart_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $rental_cart_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($rental_cart_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($rental_cart_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($rental_cart_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($rental_cart_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $rental_cart_list->showPageHeader(); ?>
<?php
$rental_cart_list->showMessage();
?>
<?php if ($rental_cart_list->TotalRecs > 0 || $rental_cart->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($rental_cart_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> rental_cart">
<?php if (!$rental_cart->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$rental_cart->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($rental_cart_list->Pager)) $rental_cart_list->Pager = new PrevNextPager($rental_cart_list->StartRec, $rental_cart_list->DisplayRecs, $rental_cart_list->TotalRecs, $rental_cart_list->AutoHidePager) ?>
<?php if ($rental_cart_list->Pager->RecordCount > 0 && $rental_cart_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($rental_cart_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $rental_cart_list->pageUrl() ?>start=<?php echo $rental_cart_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($rental_cart_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $rental_cart_list->pageUrl() ?>start=<?php echo $rental_cart_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $rental_cart_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($rental_cart_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $rental_cart_list->pageUrl() ?>start=<?php echo $rental_cart_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($rental_cart_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $rental_cart_list->pageUrl() ?>start=<?php echo $rental_cart_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $rental_cart_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($rental_cart_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $rental_cart_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $rental_cart_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $rental_cart_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($rental_cart_list->TotalRecs > 0 && (!$rental_cart_list->AutoHidePageSizeSelector || $rental_cart_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="rental_cart">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($rental_cart_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($rental_cart_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($rental_cart_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($rental_cart_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($rental_cart_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($rental_cart->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $rental_cart_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="frental_cartlist" id="frental_cartlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($rental_cart_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $rental_cart_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="rental_cart">
<div id="gmp_rental_cart" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($rental_cart_list->TotalRecs > 0 || $rental_cart->isGridEdit()) { ?>
<table id="tbl_rental_cartlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$rental_cart_list->RowType = ROWTYPE_HEADER;

// Render list options
$rental_cart_list->renderListOptions();

// Render list options (header, left)
$rental_cart_list->ListOptions->render("header", "left");
?>
<?php if ($rental_cart->id->Visible) { // id ?>
	<?php if ($rental_cart->sortUrl($rental_cart->id) == "") { ?>
		<th data-name="id" class="<?php echo $rental_cart->id->headerCellClass() ?>"><div id="elh_rental_cart_id" class="rental_cart_id"><div class="ew-table-header-caption"><?php echo $rental_cart->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $rental_cart->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->id) ?>',2);"><div id="elh_rental_cart_id" class="rental_cart_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->company_id->Visible) { // company_id ?>
	<?php if ($rental_cart->sortUrl($rental_cart->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $rental_cart->company_id->headerCellClass() ?>"><div id="elh_rental_cart_company_id" class="rental_cart_company_id"><div class="ew-table-header-caption"><?php echo $rental_cart->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $rental_cart->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->company_id) ?>',2);"><div id="elh_rental_cart_company_id" class="rental_cart_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->company_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->s_grp->Visible) { // s_grp ?>
	<?php if ($rental_cart->sortUrl($rental_cart->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $rental_cart->s_grp->headerCellClass() ?>"><div id="elh_rental_cart_s_grp" class="rental_cart_s_grp"><div class="ew-table-header-caption"><?php echo $rental_cart->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $rental_cart->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->s_grp) ?>',2);"><div id="elh_rental_cart_s_grp" class="rental_cart_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->product->Visible) { // product ?>
	<?php if ($rental_cart->sortUrl($rental_cart->product) == "") { ?>
		<th data-name="product" class="<?php echo $rental_cart->product->headerCellClass() ?>"><div id="elh_rental_cart_product" class="rental_cart_product"><div class="ew-table-header-caption"><?php echo $rental_cart->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $rental_cart->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->product) ?>',2);"><div id="elh_rental_cart_product" class="rental_cart_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->rid->Visible) { // rid ?>
	<?php if ($rental_cart->sortUrl($rental_cart->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $rental_cart->rid->headerCellClass() ?>"><div id="elh_rental_cart_rid" class="rental_cart_rid"><div class="ew-table-header-caption"><?php echo $rental_cart->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $rental_cart->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->rid) ?>',2);"><div id="elh_rental_cart_rid" class="rental_cart_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->packing_type->Visible) { // packing_type ?>
	<?php if ($rental_cart->sortUrl($rental_cart->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $rental_cart->packing_type->headerCellClass() ?>"><div id="elh_rental_cart_packing_type" class="rental_cart_packing_type"><div class="ew-table-header-caption"><?php echo $rental_cart->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $rental_cart->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->packing_type) ?>',2);"><div id="elh_rental_cart_packing_type" class="rental_cart_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->qty->Visible) { // qty ?>
	<?php if ($rental_cart->sortUrl($rental_cart->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $rental_cart->qty->headerCellClass() ?>"><div id="elh_rental_cart_qty" class="rental_cart_qty"><div class="ew-table-header-caption"><?php echo $rental_cart->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $rental_cart->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->qty) ?>',2);"><div id="elh_rental_cart_qty" class="rental_cart_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->receiving_remarks->Visible) { // receiving_remarks ?>
	<?php if ($rental_cart->sortUrl($rental_cart->receiving_remarks) == "") { ?>
		<th data-name="receiving_remarks" class="<?php echo $rental_cart->receiving_remarks->headerCellClass() ?>"><div id="elh_rental_cart_receiving_remarks" class="rental_cart_receiving_remarks"><div class="ew-table-header-caption"><?php echo $rental_cart->receiving_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiving_remarks" class="<?php echo $rental_cart->receiving_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->receiving_remarks) ?>',2);"><div id="elh_rental_cart_receiving_remarks" class="rental_cart_receiving_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->receiving_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->receiving_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->receiving_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->price->Visible) { // price ?>
	<?php if ($rental_cart->sortUrl($rental_cart->price) == "") { ?>
		<th data-name="price" class="<?php echo $rental_cart->price->headerCellClass() ?>"><div id="elh_rental_cart_price" class="rental_cart_price"><div class="ew-table-header-caption"><?php echo $rental_cart->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $rental_cart->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->price) ?>',2);"><div id="elh_rental_cart_price" class="rental_cart_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->amount->Visible) { // amount ?>
	<?php if ($rental_cart->sortUrl($rental_cart->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $rental_cart->amount->headerCellClass() ?>"><div id="elh_rental_cart_amount" class="rental_cart_amount"><div class="ew-table-header-caption"><?php echo $rental_cart->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $rental_cart->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->amount) ?>',2);"><div id="elh_rental_cart_amount" class="rental_cart_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->operator->Visible) { // operator ?>
	<?php if ($rental_cart->sortUrl($rental_cart->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $rental_cart->operator->headerCellClass() ?>"><div id="elh_rental_cart_operator" class="rental_cart_operator"><div class="ew-table-header-caption"><?php echo $rental_cart->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $rental_cart->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->operator) ?>',2);"><div id="elh_rental_cart_operator" class="rental_cart_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->datetime->Visible) { // datetime ?>
	<?php if ($rental_cart->sortUrl($rental_cart->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $rental_cart->datetime->headerCellClass() ?>"><div id="elh_rental_cart_datetime" class="rental_cart_datetime"><div class="ew-table-header-caption"><?php echo $rental_cart->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $rental_cart->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->datetime) ?>',2);"><div id="elh_rental_cart_datetime" class="rental_cart_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->d_operator->Visible) { // d_operator ?>
	<?php if ($rental_cart->sortUrl($rental_cart->d_operator) == "") { ?>
		<th data-name="d_operator" class="<?php echo $rental_cart->d_operator->headerCellClass() ?>"><div id="elh_rental_cart_d_operator" class="rental_cart_d_operator"><div class="ew-table-header-caption"><?php echo $rental_cart->d_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_operator" class="<?php echo $rental_cart->d_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->d_operator) ?>',2);"><div id="elh_rental_cart_d_operator" class="rental_cart_d_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->d_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->d_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->d_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_cart->d_datetime->Visible) { // d_datetime ?>
	<?php if ($rental_cart->sortUrl($rental_cart->d_datetime) == "") { ?>
		<th data-name="d_datetime" class="<?php echo $rental_cart->d_datetime->headerCellClass() ?>"><div id="elh_rental_cart_d_datetime" class="rental_cart_d_datetime"><div class="ew-table-header-caption"><?php echo $rental_cart->d_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_datetime" class="<?php echo $rental_cart->d_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_cart->SortUrl($rental_cart->d_datetime) ?>',2);"><div id="elh_rental_cart_d_datetime" class="rental_cart_d_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_cart->d_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_cart->d_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_cart->d_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$rental_cart_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($rental_cart->ExportAll && $rental_cart->isExport()) {
	$rental_cart_list->StopRec = $rental_cart_list->TotalRecs;
} else {

	// Set the last record to display
	if ($rental_cart_list->TotalRecs > $rental_cart_list->StartRec + $rental_cart_list->DisplayRecs - 1)
		$rental_cart_list->StopRec = $rental_cart_list->StartRec + $rental_cart_list->DisplayRecs - 1;
	else
		$rental_cart_list->StopRec = $rental_cart_list->TotalRecs;
}
$rental_cart_list->RecCnt = $rental_cart_list->StartRec - 1;
if ($rental_cart_list->Recordset && !$rental_cart_list->Recordset->EOF) {
	$rental_cart_list->Recordset->moveFirst();
	$selectLimit = $rental_cart_list->UseSelectLimit;
	if (!$selectLimit && $rental_cart_list->StartRec > 1)
		$rental_cart_list->Recordset->move($rental_cart_list->StartRec - 1);
} elseif (!$rental_cart->AllowAddDeleteRow && $rental_cart_list->StopRec == 0) {
	$rental_cart_list->StopRec = $rental_cart->GridAddRowCount;
}

// Initialize aggregate
$rental_cart->RowType = ROWTYPE_AGGREGATEINIT;
$rental_cart->resetAttributes();
$rental_cart_list->renderRow();
while ($rental_cart_list->RecCnt < $rental_cart_list->StopRec) {
	$rental_cart_list->RecCnt++;
	if ($rental_cart_list->RecCnt >= $rental_cart_list->StartRec) {
		$rental_cart_list->RowCnt++;

		// Set up key count
		$rental_cart_list->KeyCount = $rental_cart_list->RowIndex;

		// Init row class and style
		$rental_cart->resetAttributes();
		$rental_cart->CssClass = "";
		if ($rental_cart->isGridAdd()) {
		} else {
			$rental_cart_list->loadRowValues($rental_cart_list->Recordset); // Load row values
		}
		$rental_cart->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$rental_cart->RowAttrs = array_merge($rental_cart->RowAttrs, array('data-rowindex'=>$rental_cart_list->RowCnt, 'id'=>'r' . $rental_cart_list->RowCnt . '_rental_cart', 'data-rowtype'=>$rental_cart->RowType));

		// Render row
		$rental_cart_list->renderRow();

		// Render list options
		$rental_cart_list->renderListOptions();
?>
	<tr<?php echo $rental_cart->rowAttributes() ?>>
<?php

// Render list options (body, left)
$rental_cart_list->ListOptions->render("body", "left", $rental_cart_list->RowCnt);
?>
	<?php if ($rental_cart->id->Visible) { // id ?>
		<td data-name="id"<?php echo $rental_cart->id->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_id" class="rental_cart_id">
<span<?php echo $rental_cart->id->viewAttributes() ?>>
<?php echo $rental_cart->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $rental_cart->company_id->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_company_id" class="rental_cart_company_id">
<span<?php echo $rental_cart->company_id->viewAttributes() ?>>
<?php echo $rental_cart->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $rental_cart->s_grp->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_s_grp" class="rental_cart_s_grp">
<span<?php echo $rental_cart->s_grp->viewAttributes() ?>>
<?php echo $rental_cart->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->product->Visible) { // product ?>
		<td data-name="product"<?php echo $rental_cart->product->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_product" class="rental_cart_product">
<span<?php echo $rental_cart->product->viewAttributes() ?>>
<?php echo $rental_cart->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $rental_cart->rid->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_rid" class="rental_cart_rid">
<span<?php echo $rental_cart->rid->viewAttributes() ?>>
<?php echo $rental_cart->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $rental_cart->packing_type->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_packing_type" class="rental_cart_packing_type">
<span<?php echo $rental_cart->packing_type->viewAttributes() ?>>
<?php echo $rental_cart->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $rental_cart->qty->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_qty" class="rental_cart_qty">
<span<?php echo $rental_cart->qty->viewAttributes() ?>>
<?php echo $rental_cart->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->receiving_remarks->Visible) { // receiving_remarks ?>
		<td data-name="receiving_remarks"<?php echo $rental_cart->receiving_remarks->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_receiving_remarks" class="rental_cart_receiving_remarks">
<span<?php echo $rental_cart->receiving_remarks->viewAttributes() ?>>
<?php echo $rental_cart->receiving_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->price->Visible) { // price ?>
		<td data-name="price"<?php echo $rental_cart->price->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_price" class="rental_cart_price">
<span<?php echo $rental_cart->price->viewAttributes() ?>>
<?php echo $rental_cart->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $rental_cart->amount->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_amount" class="rental_cart_amount">
<span<?php echo $rental_cart->amount->viewAttributes() ?>>
<?php echo $rental_cart->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $rental_cart->operator->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_operator" class="rental_cart_operator">
<span<?php echo $rental_cart->operator->viewAttributes() ?>>
<?php echo $rental_cart->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $rental_cart->datetime->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_datetime" class="rental_cart_datetime">
<span<?php echo $rental_cart->datetime->viewAttributes() ?>>
<?php echo $rental_cart->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->d_operator->Visible) { // d_operator ?>
		<td data-name="d_operator"<?php echo $rental_cart->d_operator->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_d_operator" class="rental_cart_d_operator">
<span<?php echo $rental_cart->d_operator->viewAttributes() ?>>
<?php echo $rental_cart->d_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_cart->d_datetime->Visible) { // d_datetime ?>
		<td data-name="d_datetime"<?php echo $rental_cart->d_datetime->cellAttributes() ?>>
<span id="el<?php echo $rental_cart_list->RowCnt ?>_rental_cart_d_datetime" class="rental_cart_d_datetime">
<span<?php echo $rental_cart->d_datetime->viewAttributes() ?>>
<?php echo $rental_cart->d_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$rental_cart_list->ListOptions->render("body", "right", $rental_cart_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$rental_cart->isGridAdd())
		$rental_cart_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$rental_cart->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($rental_cart_list->Recordset)
	$rental_cart_list->Recordset->Close();
?>
<?php if (!$rental_cart->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$rental_cart->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($rental_cart_list->Pager)) $rental_cart_list->Pager = new PrevNextPager($rental_cart_list->StartRec, $rental_cart_list->DisplayRecs, $rental_cart_list->TotalRecs, $rental_cart_list->AutoHidePager) ?>
<?php if ($rental_cart_list->Pager->RecordCount > 0 && $rental_cart_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($rental_cart_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $rental_cart_list->pageUrl() ?>start=<?php echo $rental_cart_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($rental_cart_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $rental_cart_list->pageUrl() ?>start=<?php echo $rental_cart_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $rental_cart_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($rental_cart_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $rental_cart_list->pageUrl() ?>start=<?php echo $rental_cart_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($rental_cart_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $rental_cart_list->pageUrl() ?>start=<?php echo $rental_cart_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $rental_cart_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($rental_cart_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $rental_cart_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $rental_cart_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $rental_cart_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($rental_cart_list->TotalRecs > 0 && (!$rental_cart_list->AutoHidePageSizeSelector || $rental_cart_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="rental_cart">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($rental_cart_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($rental_cart_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($rental_cart_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($rental_cart_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($rental_cart_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($rental_cart->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $rental_cart_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($rental_cart_list->TotalRecs == 0 && !$rental_cart->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $rental_cart_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$rental_cart_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$rental_cart->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$rental_cart_list->terminate();
?>