<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$rental_cart_search = new rental_cart_search();

// Run the page
$rental_cart_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$rental_cart_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($rental_cart_search->IsModal) { ?>
var frental_cartsearch = currentAdvancedSearchForm = new ew.Form("frental_cartsearch", "search");
<?php } else { ?>
var frental_cartsearch = currentForm = new ew.Form("frental_cartsearch", "search");
<?php } ?>

// Form_CustomValidate event
frental_cartsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frental_cartsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frental_cartsearch.lists["x_company_id"] = <?php echo $rental_cart_search->company_id->Lookup->toClientList() ?>;
frental_cartsearch.lists["x_company_id"].options = <?php echo JsonEncode($rental_cart_search->company_id->lookupOptions()) ?>;
frental_cartsearch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_cartsearch.lists["x_s_grp"] = <?php echo $rental_cart_search->s_grp->Lookup->toClientList() ?>;
frental_cartsearch.lists["x_s_grp"].options = <?php echo JsonEncode($rental_cart_search->s_grp->lookupOptions()) ?>;
frental_cartsearch.lists["x_rid_tmp"] = <?php echo $rental_cart_search->rid_tmp->Lookup->toClientList() ?>;
frental_cartsearch.lists["x_rid_tmp"].options = <?php echo JsonEncode($rental_cart_search->rid_tmp->lookupOptions()) ?>;
frental_cartsearch.autoSuggests["x_rid_tmp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_cartsearch.lists["x_rid"] = <?php echo $rental_cart_search->rid->Lookup->toClientList() ?>;
frental_cartsearch.lists["x_rid"].options = <?php echo JsonEncode($rental_cart_search->rid->lookupOptions()) ?>;
frental_cartsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_cartsearch.lists["x_packing_type"] = <?php echo $rental_cart_search->packing_type->Lookup->toClientList() ?>;
frental_cartsearch.lists["x_packing_type"].options = <?php echo JsonEncode($rental_cart_search->packing_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

frental_cartsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity_sub");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->quantity_sub->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->d_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_cart->d_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $rental_cart_search->showPageHeader(); ?>
<?php
$rental_cart_search->showMessage();
?>
<form name="frental_cartsearch" id="frental_cartsearch" class="<?php echo $rental_cart_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($rental_cart_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $rental_cart_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="rental_cart">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$rental_cart_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($rental_cart->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_id"><?php echo $rental_cart->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->id->cellAttributes() ?>>
			<span id="el_rental_cart_id">
<input type="text" data-table="rental_cart" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($rental_cart->id->getPlaceHolder()) ?>" value="<?php echo $rental_cart->id->EditValue ?>"<?php echo $rental_cart->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_company_id"><?php echo $rental_cart->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->company_id->cellAttributes() ?>>
			<span id="el_rental_cart_company_id">
<?php
$wrkonchange = "" . trim(@$rental_cart->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$rental_cart->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($rental_cart->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($rental_cart->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($rental_cart->company_id->getPlaceHolder()) ?>"<?php echo $rental_cart->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($rental_cart->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($rental_cart->company_id->ReadOnly || $rental_cart->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="rental_cart" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $rental_cart->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($rental_cart->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
frental_cartsearch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $rental_cart->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_s_grp"><?php echo $rental_cart->s_grp->caption() ?></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->s_grp->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_s_grp" id="z_s_grp" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($rental_cart->s_grp->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_rental_cart_s_grp">
<?php $rental_cart->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$rental_cart->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_cart" data-field="x_s_grp" data-value-separator="<?php echo $rental_cart->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $rental_cart->s_grp->editAttributes() ?>>
		<?php echo $rental_cart->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $rental_cart->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
			<span class="ew-search-cond btw1_s_grp d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_rental_cart_s_grp" class="btw1_s_grp d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_cart" data-field="x_s_grp" data-value-separator="<?php echo $rental_cart->s_grp->displayValueSeparatorAttribute() ?>" id="y_s_grp" name="y_s_grp"<?php echo $rental_cart->s_grp->editAttributes() ?>>
		<?php echo $rental_cart->s_grp->selectOptionListHtml("y_s_grp") ?>
	</select>
</div>
<?php echo $rental_cart->s_grp->Lookup->getParamTag("p_y_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->rid_tmp->Visible) { // rid_tmp ?>
	<div id="r_rid_tmp" class="form-group row">
		<label class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_rid_tmp"><?php echo $rental_cart->rid_tmp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid_tmp" id="z_rid_tmp" value="LIKE"></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->rid_tmp->cellAttributes() ?>>
			<span id="el_rental_cart_rid_tmp">
<?php
$wrkonchange = "" . trim(@$rental_cart->rid_tmp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$rental_cart->rid_tmp->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid_tmp" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid_tmp" id="sv_x_rid_tmp" value="<?php echo RemoveHtml($rental_cart->rid_tmp->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($rental_cart->rid_tmp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($rental_cart->rid_tmp->getPlaceHolder()) ?>"<?php echo $rental_cart->rid_tmp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($rental_cart->rid_tmp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid_tmp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($rental_cart->rid_tmp->ReadOnly || $rental_cart->rid_tmp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="rental_cart" data-field="x_rid_tmp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $rental_cart->rid_tmp->displayValueSeparatorAttribute() ?>" name="x_rid_tmp" id="x_rid_tmp" value="<?php echo HtmlEncode($rental_cart->rid_tmp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
frental_cartsearch.createAutoSuggest({"id":"x_rid_tmp","forceSelect":true});
</script>
<?php echo $rental_cart->rid_tmp->Lookup->getParamTag("p_x_rid_tmp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_rid"><?php echo $rental_cart->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->rid->cellAttributes() ?>>
			<span id="el_rental_cart_rid">
<?php
$wrkonchange = "" . trim(@$rental_cart->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$rental_cart->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($rental_cart->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($rental_cart->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($rental_cart->rid->getPlaceHolder()) ?>"<?php echo $rental_cart->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="rental_cart" data-field="x_rid" data-value-separator="<?php echo $rental_cart->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($rental_cart->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
frental_cartsearch.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $rental_cart->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_packing_type"><?php echo $rental_cart->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->packing_type->cellAttributes() ?>>
			<span id="el_rental_cart_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_cart" data-field="x_packing_type" data-value-separator="<?php echo $rental_cart->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $rental_cart->packing_type->editAttributes() ?>>
		<?php echo $rental_cart->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $rental_cart->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->quantity_sub->Visible) { // quantity_sub ?>
	<div id="r_quantity_sub" class="form-group row">
		<label for="x_quantity_sub" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_quantity_sub"><?php echo $rental_cart->quantity_sub->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_sub" id="z_quantity_sub" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->quantity_sub->cellAttributes() ?>>
			<span id="el_rental_cart_quantity_sub">
<input type="text" data-table="rental_cart" data-field="x_quantity_sub" name="x_quantity_sub" id="x_quantity_sub" size="30" placeholder="<?php echo HtmlEncode($rental_cart->quantity_sub->getPlaceHolder()) ?>" value="<?php echo $rental_cart->quantity_sub->EditValue ?>"<?php echo $rental_cart->quantity_sub->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_qty"><?php echo $rental_cart->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->qty->cellAttributes() ?>>
			<span id="el_rental_cart_qty">
<input type="text" data-table="rental_cart" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($rental_cart->qty->getPlaceHolder()) ?>" value="<?php echo $rental_cart->qty->EditValue ?>"<?php echo $rental_cart->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_remarks"><?php echo $rental_cart->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->remarks->cellAttributes() ?>>
			<span id="el_rental_cart_remarks">
<input type="text" data-table="rental_cart" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($rental_cart->remarks->getPlaceHolder()) ?>" value="<?php echo $rental_cart->remarks->EditValue ?>"<?php echo $rental_cart->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->receiving_remarks->Visible) { // receiving_remarks ?>
	<div id="r_receiving_remarks" class="form-group row">
		<label for="x_receiving_remarks" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_receiving_remarks"><?php echo $rental_cart->receiving_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_receiving_remarks" id="z_receiving_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->receiving_remarks->cellAttributes() ?>>
			<span id="el_rental_cart_receiving_remarks">
<input type="text" data-table="rental_cart" data-field="x_receiving_remarks" name="x_receiving_remarks" id="x_receiving_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($rental_cart->receiving_remarks->getPlaceHolder()) ?>" value="<?php echo $rental_cart->receiving_remarks->EditValue ?>"<?php echo $rental_cart->receiving_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_price"><?php echo $rental_cart->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->price->cellAttributes() ?>>
			<span id="el_rental_cart_price">
<input type="text" data-table="rental_cart" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($rental_cart->price->getPlaceHolder()) ?>" value="<?php echo $rental_cart->price->EditValue ?>"<?php echo $rental_cart->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_amount"><?php echo $rental_cart->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->amount->cellAttributes() ?>>
			<span id="el_rental_cart_amount">
<input type="text" data-table="rental_cart" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($rental_cart->amount->getPlaceHolder()) ?>" value="<?php echo $rental_cart->amount->EditValue ?>"<?php echo $rental_cart->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_operator"><?php echo $rental_cart->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->operator->cellAttributes() ?>>
			<span id="el_rental_cart_operator">
<input type="text" data-table="rental_cart" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($rental_cart->operator->getPlaceHolder()) ?>" value="<?php echo $rental_cart->operator->EditValue ?>"<?php echo $rental_cart->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_datetime"><?php echo $rental_cart->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->datetime->cellAttributes() ?>>
			<span id="el_rental_cart_datetime">
<input type="text" data-table="rental_cart" data-field="x_datetime" name="x_datetime" id="x_datetime" size="30" placeholder="<?php echo HtmlEncode($rental_cart->datetime->getPlaceHolder()) ?>" value="<?php echo $rental_cart->datetime->EditValue ?>"<?php echo $rental_cart->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->d_operator->Visible) { // d_operator ?>
	<div id="r_d_operator" class="form-group row">
		<label for="x_d_operator" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_d_operator"><?php echo $rental_cart->d_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_operator" id="z_d_operator" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->d_operator->cellAttributes() ?>>
			<span id="el_rental_cart_d_operator">
<input type="text" data-table="rental_cart" data-field="x_d_operator" name="x_d_operator" id="x_d_operator" size="30" placeholder="<?php echo HtmlEncode($rental_cart->d_operator->getPlaceHolder()) ?>" value="<?php echo $rental_cart->d_operator->EditValue ?>"<?php echo $rental_cart->d_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_cart->d_datetime->Visible) { // d_datetime ?>
	<div id="r_d_datetime" class="form-group row">
		<label for="x_d_datetime" class="<?php echo $rental_cart_search->LeftColumnClass ?>"><span id="elh_rental_cart_d_datetime"><?php echo $rental_cart->d_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_datetime" id="z_d_datetime" value="="></span>
		</label>
		<div class="<?php echo $rental_cart_search->RightColumnClass ?>"><div<?php echo $rental_cart->d_datetime->cellAttributes() ?>>
			<span id="el_rental_cart_d_datetime">
<input type="text" data-table="rental_cart" data-field="x_d_datetime" name="x_d_datetime" id="x_d_datetime" placeholder="<?php echo HtmlEncode($rental_cart->d_datetime->getPlaceHolder()) ?>" value="<?php echo $rental_cart->d_datetime->EditValue ?>"<?php echo $rental_cart->d_datetime->editAttributes() ?>>
<?php if (!$rental_cart->d_datetime->ReadOnly && !$rental_cart->d_datetime->Disabled && !isset($rental_cart->d_datetime->EditAttrs["readonly"]) && !isset($rental_cart->d_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frental_cartsearch", "x_d_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$rental_cart_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $rental_cart_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$rental_cart_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$rental_cart_search->terminate();
?>