<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$rental_po_edit = new rental_po_edit();

// Run the page
$rental_po_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$rental_po_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var frental_poedit = currentForm = new ew.Form("frental_poedit", "edit");

// Validate form
frental_poedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($rental_po_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->id->caption(), $rental_po->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->programme_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_programme_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->programme_datetime->caption(), $rental_po->programme_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_programme_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($rental_po->programme_datetime->errorMessage()) ?>");
		<?php if ($rental_po_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->location->caption(), $rental_po->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->item->caption(), $rental_po->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->company_id->caption(), $rental_po->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($rental_po->company_id->errorMessage()) ?>");
		<?php if ($rental_po_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->amount->caption(), $rental_po->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->type->caption(), $rental_po->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->buyer_instruction->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_instruction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->buyer_instruction->caption(), $rental_po->buyer_instruction->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->remarks->caption(), $rental_po->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->eastimated_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_eastimated_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->eastimated_amount->caption(), $rental_po->eastimated_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->gst->Required) { ?>
			elm = this.getElements("x" + infix + "_gst");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->gst->caption(), $rental_po->gst->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $rental_po->uploads->caption(), $rental_po->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->reports_to->caption(), $rental_po->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_description_01[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_01->caption(), $rental_po->description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_description_02[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_02->caption(), $rental_po->description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_03->Required) { ?>
			elm = this.getElements("x" + infix + "_description_03[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_03->caption(), $rental_po->description_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_04->Required) { ?>
			elm = this.getElements("x" + infix + "_description_04[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_04->caption(), $rental_po->description_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_05->Required) { ?>
			elm = this.getElements("x" + infix + "_description_05[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_05->caption(), $rental_po->description_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_06->Required) { ?>
			elm = this.getElements("x" + infix + "_description_06[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_06->caption(), $rental_po->description_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_07->Required) { ?>
			elm = this.getElements("x" + infix + "_description_07[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_07->caption(), $rental_po->description_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_08->Required) { ?>
			elm = this.getElements("x" + infix + "_description_08[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_08->caption(), $rental_po->description_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_09->Required) { ?>
			elm = this.getElements("x" + infix + "_description_09[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_09->caption(), $rental_po->description_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->description_10->Required) { ?>
			elm = this.getElements("x" + infix + "_description_10[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->description_10->caption(), $rental_po->description_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->operator->caption(), $rental_po->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->datetime->caption(), $rental_po->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->booking_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_booking_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->booking_ref->caption(), $rental_po->booking_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->contact_person->Required) { ?>
			elm = this.getElements("x" + infix + "_contact_person");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->contact_person->caption(), $rental_po->contact_person->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($rental_po_edit->programme_end_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_programme_end_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $rental_po->programme_end_datetime->caption(), $rental_po->programme_end_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_programme_end_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($rental_po->programme_end_datetime->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
frental_poedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frental_poedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
frental_poedit.multiPage = new ew.MultiPage("frental_poedit");

// Dynamic selection lists
frental_poedit.lists["x_company_id"] = <?php echo $rental_po_edit->company_id->Lookup->toClientList() ?>;
frental_poedit.lists["x_company_id"].options = <?php echo JsonEncode($rental_po_edit->company_id->lookupOptions()) ?>;
frental_poedit.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_poedit.lists["x_type"] = <?php echo $rental_po_edit->type->Lookup->toClientList() ?>;
frental_poedit.lists["x_type"].options = <?php echo JsonEncode($rental_po_edit->type->options(FALSE, TRUE)) ?>;
frental_poedit.lists["x_gst"] = <?php echo $rental_po_edit->gst->Lookup->toClientList() ?>;
frental_poedit.lists["x_gst"].options = <?php echo JsonEncode($rental_po_edit->gst->lookupOptions()) ?>;
frental_poedit.lists["x_reports_to"] = <?php echo $rental_po_edit->reports_to->Lookup->toClientList() ?>;
frental_poedit.lists["x_reports_to"].options = <?php echo JsonEncode($rental_po_edit->reports_to->lookupOptions()) ?>;
frental_poedit.lists["x_description_01[]"] = <?php echo $rental_po_edit->description_01->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_01[]"].options = <?php echo JsonEncode($rental_po_edit->description_01->lookupOptions()) ?>;
frental_poedit.lists["x_description_02[]"] = <?php echo $rental_po_edit->description_02->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_02[]"].options = <?php echo JsonEncode($rental_po_edit->description_02->lookupOptions()) ?>;
frental_poedit.lists["x_description_03[]"] = <?php echo $rental_po_edit->description_03->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_03[]"].options = <?php echo JsonEncode($rental_po_edit->description_03->lookupOptions()) ?>;
frental_poedit.lists["x_description_04[]"] = <?php echo $rental_po_edit->description_04->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_04[]"].options = <?php echo JsonEncode($rental_po_edit->description_04->lookupOptions()) ?>;
frental_poedit.lists["x_description_05[]"] = <?php echo $rental_po_edit->description_05->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_05[]"].options = <?php echo JsonEncode($rental_po_edit->description_05->lookupOptions()) ?>;
frental_poedit.lists["x_description_06[]"] = <?php echo $rental_po_edit->description_06->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_06[]"].options = <?php echo JsonEncode($rental_po_edit->description_06->lookupOptions()) ?>;
frental_poedit.lists["x_description_07[]"] = <?php echo $rental_po_edit->description_07->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_07[]"].options = <?php echo JsonEncode($rental_po_edit->description_07->lookupOptions()) ?>;
frental_poedit.lists["x_description_08[]"] = <?php echo $rental_po_edit->description_08->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_08[]"].options = <?php echo JsonEncode($rental_po_edit->description_08->lookupOptions()) ?>;
frental_poedit.lists["x_description_09[]"] = <?php echo $rental_po_edit->description_09->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_09[]"].options = <?php echo JsonEncode($rental_po_edit->description_09->lookupOptions()) ?>;
frental_poedit.lists["x_description_10[]"] = <?php echo $rental_po_edit->description_10->Lookup->toClientList() ?>;
frental_poedit.lists["x_description_10[]"].options = <?php echo JsonEncode($rental_po_edit->description_10->lookupOptions()) ?>;
frental_poedit.lists["x_operator"] = <?php echo $rental_po_edit->operator->Lookup->toClientList() ?>;
frental_poedit.lists["x_operator"].options = <?php echo JsonEncode($rental_po_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $rental_po_edit->showPageHeader(); ?>
<?php
$rental_po_edit->showMessage();
?>
<form name="frental_poedit" id="frental_poedit" class="<?php echo $rental_po_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($rental_po_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $rental_po_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="rental_po">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$rental_po_edit->IsModal ?>">
<?php if ($rental_po_edit->MultiPages->Items[0]->Visible) { ?>
<div class="ew-edit-div"><!-- page0 -->
<?php if ($rental_po->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_rental_po_id" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->id->caption() ?><?php echo ($rental_po->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->id->cellAttributes() ?>>
<span id="el_rental_po_id">
<span<?php echo $rental_po->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($rental_po->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="rental_po" data-field="x_id" data-page="0" name="x_id" id="x_id" value="<?php echo HtmlEncode($rental_po->id->CurrentValue) ?>">
<?php echo $rental_po->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->programme_datetime->Visible) { // programme_datetime ?>
	<div id="r_programme_datetime" class="form-group row">
		<label id="elh_rental_po_programme_datetime" for="x_programme_datetime" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->programme_datetime->caption() ?><?php echo ($rental_po->programme_datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->programme_datetime->cellAttributes() ?>>
<span id="el_rental_po_programme_datetime">
<input type="text" data-table="rental_po" data-field="x_programme_datetime" data-page="0" name="x_programme_datetime" id="x_programme_datetime" placeholder="<?php echo HtmlEncode($rental_po->programme_datetime->getPlaceHolder()) ?>" value="<?php echo $rental_po->programme_datetime->EditValue ?>"<?php echo $rental_po->programme_datetime->editAttributes() ?>>
<?php if (!$rental_po->programme_datetime->ReadOnly && !$rental_po->programme_datetime->Disabled && !isset($rental_po->programme_datetime->EditAttrs["readonly"]) && !isset($rental_po->programme_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frental_poedit", "x_programme_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $rental_po->programme_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_rental_po_location" for="x_location" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->location->caption() ?><?php echo ($rental_po->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->location->cellAttributes() ?>>
<span id="el_rental_po_location">
<textarea data-table="rental_po" data-field="x_location" data-page="0" name="x_location" id="x_location" cols="35" rows="4" placeholder="<?php echo HtmlEncode($rental_po->location->getPlaceHolder()) ?>"<?php echo $rental_po->location->editAttributes() ?>><?php echo $rental_po->location->EditValue ?></textarea>
</span>
<?php echo $rental_po->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_rental_po_item" for="x_item" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->item->caption() ?><?php echo ($rental_po->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->item->cellAttributes() ?>>
<span id="el_rental_po_item">
<input type="text" data-table="rental_po" data-field="x_item" data-page="0" name="x_item" id="x_item" size="30" placeholder="<?php echo HtmlEncode($rental_po->item->getPlaceHolder()) ?>" value="<?php echo $rental_po->item->EditValue ?>"<?php echo $rental_po->item->editAttributes() ?>>
</span>
<?php echo $rental_po->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_rental_po_company_id" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->company_id->caption() ?><?php echo ($rental_po->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->company_id->cellAttributes() ?>>
<span id="el_rental_po_company_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$rental_po->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$rental_po->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($rental_po->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($rental_po->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($rental_po->company_id->getPlaceHolder()) ?>"<?php echo $rental_po->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($rental_po->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($rental_po->company_id->ReadOnly || $rental_po->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$rental_po->company_id->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_company_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $rental_po->company_id->caption() ?>" data-title="<?php echo $rental_po->company_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_company_id',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="rental_po" data-field="x_company_id" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $rental_po->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($rental_po->company_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
frental_poedit.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $rental_po->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $rental_po->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_rental_po_amount" for="x_amount" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->amount->caption() ?><?php echo ($rental_po->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->amount->cellAttributes() ?>>
<span id="el_rental_po_amount">
<input type="text" data-table="rental_po" data-field="x_amount" data-page="0" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($rental_po->amount->getPlaceHolder()) ?>" value="<?php echo $rental_po->amount->EditValue ?>"<?php echo $rental_po->amount->editAttributes() ?>>
</span>
<?php echo $rental_po->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_rental_po_type" for="x_type" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->type->caption() ?><?php echo ($rental_po->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->type->cellAttributes() ?>>
<span id="el_rental_po_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_po" data-field="x_type" data-page="0" data-value-separator="<?php echo $rental_po->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $rental_po->type->editAttributes() ?>>
		<?php echo $rental_po->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $rental_po->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="rental_po_edit"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $rental_po_edit->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($rental_po_edit->MultiPages->isActive("1")) ?>" href="#tab_rental_po1"><?php echo $rental_po->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $rental_po_edit->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $rental_po_edit->MultiPages->Parent ?>" id="tab_rental_po1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($rental_po->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label id="elh_rental_po_description_01" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_01->caption() ?><?php echo ($rental_po->description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_01->cellAttributes() ?>>
<span id="el_rental_po_description_01">
<div id="tp_x_description_01" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_01" data-page="1" data-value-separator="<?php echo $rental_po->description_01->displayValueSeparatorAttribute() ?>" name="x_description_01[]" id="x_description_01[]" value="{value}"<?php echo $rental_po->description_01->editAttributes() ?>></div>
<div id="dsl_x_description_01" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_01->checkBoxListHtml(FALSE, "x_description_01[]", 1) ?>
</div></div>
<?php echo $rental_po->description_01->Lookup->getParamTag("p_x_description_01") ?>
</span>
<?php echo $rental_po->description_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label id="elh_rental_po_description_02" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_02->caption() ?><?php echo ($rental_po->description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_02->cellAttributes() ?>>
<span id="el_rental_po_description_02">
<div id="tp_x_description_02" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_02" data-page="1" data-value-separator="<?php echo $rental_po->description_02->displayValueSeparatorAttribute() ?>" name="x_description_02[]" id="x_description_02[]" value="{value}"<?php echo $rental_po->description_02->editAttributes() ?>></div>
<div id="dsl_x_description_02" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_02->checkBoxListHtml(FALSE, "x_description_02[]", 1) ?>
</div></div>
<?php echo $rental_po->description_02->Lookup->getParamTag("p_x_description_02") ?>
</span>
<?php echo $rental_po->description_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label id="elh_rental_po_description_03" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_03->caption() ?><?php echo ($rental_po->description_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_03->cellAttributes() ?>>
<span id="el_rental_po_description_03">
<div id="tp_x_description_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_03" data-page="1" data-value-separator="<?php echo $rental_po->description_03->displayValueSeparatorAttribute() ?>" name="x_description_03[]" id="x_description_03[]" value="{value}"<?php echo $rental_po->description_03->editAttributes() ?>></div>
<div id="dsl_x_description_03" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_03->checkBoxListHtml(FALSE, "x_description_03[]", 1) ?>
</div></div>
<?php echo $rental_po->description_03->Lookup->getParamTag("p_x_description_03") ?>
</span>
<?php echo $rental_po->description_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label id="elh_rental_po_description_04" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_04->caption() ?><?php echo ($rental_po->description_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_04->cellAttributes() ?>>
<span id="el_rental_po_description_04">
<div id="tp_x_description_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_04" data-page="1" data-value-separator="<?php echo $rental_po->description_04->displayValueSeparatorAttribute() ?>" name="x_description_04[]" id="x_description_04[]" value="{value}"<?php echo $rental_po->description_04->editAttributes() ?>></div>
<div id="dsl_x_description_04" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_04->checkBoxListHtml(FALSE, "x_description_04[]", 1) ?>
</div></div>
<?php echo $rental_po->description_04->Lookup->getParamTag("p_x_description_04") ?>
</span>
<?php echo $rental_po->description_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label id="elh_rental_po_description_05" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_05->caption() ?><?php echo ($rental_po->description_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_05->cellAttributes() ?>>
<span id="el_rental_po_description_05">
<div id="tp_x_description_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_05" data-page="1" data-value-separator="<?php echo $rental_po->description_05->displayValueSeparatorAttribute() ?>" name="x_description_05[]" id="x_description_05[]" value="{value}"<?php echo $rental_po->description_05->editAttributes() ?>></div>
<div id="dsl_x_description_05" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_05->checkBoxListHtml(FALSE, "x_description_05[]", 1) ?>
</div></div>
<?php echo $rental_po->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
<?php echo $rental_po->description_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label id="elh_rental_po_description_06" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_06->caption() ?><?php echo ($rental_po->description_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_06->cellAttributes() ?>>
<span id="el_rental_po_description_06">
<div id="tp_x_description_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_06" data-page="1" data-value-separator="<?php echo $rental_po->description_06->displayValueSeparatorAttribute() ?>" name="x_description_06[]" id="x_description_06[]" value="{value}"<?php echo $rental_po->description_06->editAttributes() ?>></div>
<div id="dsl_x_description_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_06->checkBoxListHtml(FALSE, "x_description_06[]", 1) ?>
</div></div>
<?php echo $rental_po->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
<?php echo $rental_po->description_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label id="elh_rental_po_description_07" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_07->caption() ?><?php echo ($rental_po->description_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_07->cellAttributes() ?>>
<span id="el_rental_po_description_07">
<div id="tp_x_description_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_07" data-page="1" data-value-separator="<?php echo $rental_po->description_07->displayValueSeparatorAttribute() ?>" name="x_description_07[]" id="x_description_07[]" value="{value}"<?php echo $rental_po->description_07->editAttributes() ?>></div>
<div id="dsl_x_description_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_07->checkBoxListHtml(FALSE, "x_description_07[]", 1) ?>
</div></div>
<?php echo $rental_po->description_07->Lookup->getParamTag("p_x_description_07") ?>
</span>
<?php echo $rental_po->description_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label id="elh_rental_po_description_08" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_08->caption() ?><?php echo ($rental_po->description_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_08->cellAttributes() ?>>
<span id="el_rental_po_description_08">
<div id="tp_x_description_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_08" data-page="1" data-value-separator="<?php echo $rental_po->description_08->displayValueSeparatorAttribute() ?>" name="x_description_08[]" id="x_description_08[]" value="{value}"<?php echo $rental_po->description_08->editAttributes() ?>></div>
<div id="dsl_x_description_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_08->checkBoxListHtml(FALSE, "x_description_08[]", 1) ?>
</div></div>
<?php echo $rental_po->description_08->Lookup->getParamTag("p_x_description_08") ?>
</span>
<?php echo $rental_po->description_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label id="elh_rental_po_description_09" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_09->caption() ?><?php echo ($rental_po->description_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_09->cellAttributes() ?>>
<span id="el_rental_po_description_09">
<div id="tp_x_description_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_09" data-page="1" data-value-separator="<?php echo $rental_po->description_09->displayValueSeparatorAttribute() ?>" name="x_description_09[]" id="x_description_09[]" value="{value}"<?php echo $rental_po->description_09->editAttributes() ?>></div>
<div id="dsl_x_description_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_09->checkBoxListHtml(FALSE, "x_description_09[]", 1) ?>
</div></div>
<?php echo $rental_po->description_09->Lookup->getParamTag("p_x_description_09") ?>
</span>
<?php echo $rental_po->description_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label id="elh_rental_po_description_10" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->description_10->caption() ?><?php echo ($rental_po->description_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->description_10->cellAttributes() ?>>
<span id="el_rental_po_description_10">
<div id="tp_x_description_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_10" data-page="1" data-value-separator="<?php echo $rental_po->description_10->displayValueSeparatorAttribute() ?>" name="x_description_10[]" id="x_description_10[]" value="{value}"<?php echo $rental_po->description_10->editAttributes() ?>></div>
<div id="dsl_x_description_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_10->checkBoxListHtml(FALSE, "x_description_10[]", 1) ?>
</div></div>
<?php echo $rental_po->description_10->Lookup->getParamTag("p_x_description_10") ?>
</span>
<?php echo $rental_po->description_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->booking_ref->Visible) { // booking_ref ?>
	<div id="r_booking_ref" class="form-group row">
		<label id="elh_rental_po_booking_ref" for="x_booking_ref" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->booking_ref->caption() ?><?php echo ($rental_po->booking_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->booking_ref->cellAttributes() ?>>
<span id="el_rental_po_booking_ref">
<input type="text" data-table="rental_po" data-field="x_booking_ref" data-page="1" name="x_booking_ref" id="x_booking_ref" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($rental_po->booking_ref->getPlaceHolder()) ?>" value="<?php echo $rental_po->booking_ref->EditValue ?>"<?php echo $rental_po->booking_ref->editAttributes() ?>>
</span>
<?php echo $rental_po->booking_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->contact_person->Visible) { // contact_person ?>
	<div id="r_contact_person" class="form-group row">
		<label id="elh_rental_po_contact_person" for="x_contact_person" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->contact_person->caption() ?><?php echo ($rental_po->contact_person->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->contact_person->cellAttributes() ?>>
<span id="el_rental_po_contact_person">
<input type="text" data-table="rental_po" data-field="x_contact_person" data-page="1" name="x_contact_person" id="x_contact_person" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($rental_po->contact_person->getPlaceHolder()) ?>" value="<?php echo $rental_po->contact_person->EditValue ?>"<?php echo $rental_po->contact_person->editAttributes() ?>>
</span>
<?php echo $rental_po->contact_person->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->programme_end_datetime->Visible) { // programme_end_datetime ?>
	<div id="r_programme_end_datetime" class="form-group row">
		<label id="elh_rental_po_programme_end_datetime" for="x_programme_end_datetime" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->programme_end_datetime->caption() ?><?php echo ($rental_po->programme_end_datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->programme_end_datetime->cellAttributes() ?>>
<span id="el_rental_po_programme_end_datetime">
<input type="text" data-table="rental_po" data-field="x_programme_end_datetime" data-page="1" name="x_programme_end_datetime" id="x_programme_end_datetime" placeholder="<?php echo HtmlEncode($rental_po->programme_end_datetime->getPlaceHolder()) ?>" value="<?php echo $rental_po->programme_end_datetime->EditValue ?>"<?php echo $rental_po->programme_end_datetime->editAttributes() ?>>
<?php if (!$rental_po->programme_end_datetime->ReadOnly && !$rental_po->programme_end_datetime->Disabled && !isset($rental_po->programme_end_datetime->EditAttrs["readonly"]) && !isset($rental_po->programme_end_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frental_poedit", "x_programme_end_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $rental_po->programme_end_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $rental_po_edit->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($rental_po_edit->MultiPages->isActive("2")) ?>" href="#tab_rental_po2"><?php echo $rental_po->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $rental_po_edit->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $rental_po_edit->MultiPages->Parent ?>" id="tab_rental_po2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($rental_po->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label id="elh_rental_po_buyer_instruction" for="x_buyer_instruction" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->buyer_instruction->caption() ?><?php echo ($rental_po->buyer_instruction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->buyer_instruction->cellAttributes() ?>>
<span id="el_rental_po_buyer_instruction">
<textarea data-table="rental_po" data-field="x_buyer_instruction" data-page="2" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?php echo HtmlEncode($rental_po->buyer_instruction->getPlaceHolder()) ?>"<?php echo $rental_po->buyer_instruction->editAttributes() ?>><?php echo $rental_po->buyer_instruction->EditValue ?></textarea>
</span>
<?php echo $rental_po->buyer_instruction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_rental_po_remarks" for="x_remarks" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->remarks->caption() ?><?php echo ($rental_po->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->remarks->cellAttributes() ?>>
<span id="el_rental_po_remarks">
<textarea data-table="rental_po" data-field="x_remarks" data-page="2" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($rental_po->remarks->getPlaceHolder()) ?>"<?php echo $rental_po->remarks->editAttributes() ?>><?php echo $rental_po->remarks->EditValue ?></textarea>
</span>
<?php echo $rental_po->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->eastimated_amount->Visible) { // eastimated_amount ?>
	<div id="r_eastimated_amount" class="form-group row">
		<label id="elh_rental_po_eastimated_amount" for="x_eastimated_amount" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->eastimated_amount->caption() ?><?php echo ($rental_po->eastimated_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->eastimated_amount->cellAttributes() ?>>
<span id="el_rental_po_eastimated_amount">
<input type="text" data-table="rental_po" data-field="x_eastimated_amount" data-page="2" name="x_eastimated_amount" id="x_eastimated_amount" size="30" maxlength="196" placeholder="<?php echo HtmlEncode($rental_po->eastimated_amount->getPlaceHolder()) ?>" value="<?php echo $rental_po->eastimated_amount->EditValue ?>"<?php echo $rental_po->eastimated_amount->editAttributes() ?>>
</span>
<?php echo $rental_po->eastimated_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label id="elh_rental_po_gst" for="x_gst" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->gst->caption() ?><?php echo ($rental_po->gst->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->gst->cellAttributes() ?>>
<span id="el_rental_po_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_po" data-field="x_gst" data-page="2" data-value-separator="<?php echo $rental_po->gst->displayValueSeparatorAttribute() ?>" id="x_gst" name="x_gst"<?php echo $rental_po->gst->editAttributes() ?>>
		<?php echo $rental_po->gst->selectOptionListHtml("x_gst") ?>
	</select>
</div>
<?php echo $rental_po->gst->Lookup->getParamTag("p_x_gst") ?>
</span>
<?php echo $rental_po->gst->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_rental_po_uploads" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->uploads->caption() ?><?php echo ($rental_po->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->uploads->cellAttributes() ?>>
<span id="el_rental_po_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $rental_po->uploads->title() ? $rental_po->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($rental_po->uploads->ReadOnly || $rental_po->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="rental_po" data-field="x_uploads" data-page="2" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $rental_po->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $rental_po->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="500">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $rental_po->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $rental_po->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $rental_po->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $rental_po->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($rental_po->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_rental_po_reports_to" for="x_reports_to" class="<?php echo $rental_po_edit->LeftColumnClass ?>"><?php echo $rental_po->reports_to->caption() ?><?php echo ($rental_po->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $rental_po_edit->RightColumnClass ?>"><div<?php echo $rental_po->reports_to->cellAttributes() ?>>
<span id="el_rental_po_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_po" data-field="x_reports_to" data-page="2" data-value-separator="<?php echo $rental_po->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $rental_po->reports_to->editAttributes() ?>>
		<?php echo $rental_po->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $rental_po->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php echo $rental_po->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$rental_po_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $rental_po_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $rental_po_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$rental_po_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$rental_po_edit->terminate();
?>