<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$rental_po_list = new rental_po_list();

// Run the page
$rental_po_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$rental_po_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$rental_po->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var frental_polist = currentForm = new ew.Form("frental_polist", "list");
frental_polist.formKeyCountName = '<?php echo $rental_po_list->FormKeyCountName ?>';

// Form_CustomValidate event
frental_polist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frental_polist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frental_polist.lists["x_company_id"] = <?php echo $rental_po_list->company_id->Lookup->toClientList() ?>;
frental_polist.lists["x_company_id"].options = <?php echo JsonEncode($rental_po_list->company_id->lookupOptions()) ?>;
frental_polist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_polist.lists["x_type"] = <?php echo $rental_po_list->type->Lookup->toClientList() ?>;
frental_polist.lists["x_type"].options = <?php echo JsonEncode($rental_po_list->type->options(FALSE, TRUE)) ?>;
frental_polist.lists["x_gst"] = <?php echo $rental_po_list->gst->Lookup->toClientList() ?>;
frental_polist.lists["x_gst"].options = <?php echo JsonEncode($rental_po_list->gst->lookupOptions()) ?>;
frental_polist.lists["x_reports_to"] = <?php echo $rental_po_list->reports_to->Lookup->toClientList() ?>;
frental_polist.lists["x_reports_to"].options = <?php echo JsonEncode($rental_po_list->reports_to->lookupOptions()) ?>;
frental_polist.lists["x_operator"] = <?php echo $rental_po_list->operator->Lookup->toClientList() ?>;
frental_polist.lists["x_operator"].options = <?php echo JsonEncode($rental_po_list->operator->lookupOptions()) ?>;

// Form object for search
var frental_polistsrch = currentSearchForm = new ew.Form("frental_polistsrch");

// Validate function for search
frental_polistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_po->company_id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
frental_polistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frental_polistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frental_polistsrch.lists["x_company_id"] = <?php echo $rental_po_list->company_id->Lookup->toClientList() ?>;
frental_polistsrch.lists["x_company_id"].options = <?php echo JsonEncode($rental_po_list->company_id->lookupOptions()) ?>;
frental_polistsrch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_polistsrch.lists["x_type"] = <?php echo $rental_po_list->type->Lookup->toClientList() ?>;
frental_polistsrch.lists["x_type"].options = <?php echo JsonEncode($rental_po_list->type->options(FALSE, TRUE)) ?>;

// Filters
frental_polistsrch.filterList = <?php echo $rental_po_list->getFilterList() ?>;

// Init search panel as collapsed
frental_polistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$rental_po->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($rental_po_list->TotalRecs > 0 && $rental_po_list->ExportOptions->visible()) { ?>
<?php $rental_po_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($rental_po_list->ImportOptions->visible()) { ?>
<?php $rental_po_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($rental_po_list->SearchOptions->visible()) { ?>
<?php $rental_po_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($rental_po_list->FilterOptions->visible()) { ?>
<?php $rental_po_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$rental_po_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$rental_po->isExport() && !$rental_po->CurrentAction) { ?>
<form name="frental_polistsrch" id="frental_polistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($rental_po_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="frental_polistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="rental_po">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$rental_po_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$rental_po->RowType = ROWTYPE_SEARCH;

// Render row
$rental_po->resetAttributes();
$rental_po_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($rental_po->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $rental_po->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$rental_po->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$rental_po->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($rental_po->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($rental_po->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($rental_po->company_id->getPlaceHolder()) ?>"<?php echo $rental_po->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($rental_po->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($rental_po->company_id->ReadOnly || $rental_po->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="rental_po" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $rental_po->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($rental_po->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
frental_polistsrch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $rental_po->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($rental_po->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $rental_po->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_po" data-field="x_type" data-value-separator="<?php echo $rental_po->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $rental_po->type->editAttributes() ?>>
		<?php echo $rental_po->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($rental_po_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($rental_po_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $rental_po_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($rental_po_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($rental_po_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($rental_po_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($rental_po_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $rental_po_list->showPageHeader(); ?>
<?php
$rental_po_list->showMessage();
?>
<?php if ($rental_po_list->TotalRecs > 0 || $rental_po->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($rental_po_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> rental_po">
<?php if (!$rental_po->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$rental_po->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($rental_po_list->Pager)) $rental_po_list->Pager = new PrevNextPager($rental_po_list->StartRec, $rental_po_list->DisplayRecs, $rental_po_list->TotalRecs, $rental_po_list->AutoHidePager) ?>
<?php if ($rental_po_list->Pager->RecordCount > 0 && $rental_po_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($rental_po_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $rental_po_list->pageUrl() ?>start=<?php echo $rental_po_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($rental_po_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $rental_po_list->pageUrl() ?>start=<?php echo $rental_po_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $rental_po_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($rental_po_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $rental_po_list->pageUrl() ?>start=<?php echo $rental_po_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($rental_po_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $rental_po_list->pageUrl() ?>start=<?php echo $rental_po_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $rental_po_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($rental_po_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $rental_po_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $rental_po_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $rental_po_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($rental_po_list->TotalRecs > 0 && (!$rental_po_list->AutoHidePageSizeSelector || $rental_po_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="rental_po">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($rental_po_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($rental_po_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($rental_po_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($rental_po_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($rental_po_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($rental_po->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $rental_po_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="frental_polist" id="frental_polist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($rental_po_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $rental_po_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="rental_po">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_rental_po" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($rental_po_list->TotalRecs > 0 || $rental_po->isGridEdit()) { ?>
<table id="tbl_rental_polist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$rental_po_list->RowType = ROWTYPE_HEADER;

// Render list options
$rental_po_list->renderListOptions();

// Render list options (header, left)
$rental_po_list->ListOptions->render("header", "left");
?>
<?php if ($rental_po->id->Visible) { // id ?>
	<?php if ($rental_po->sortUrl($rental_po->id) == "") { ?>
		<th data-name="id" class="<?php echo $rental_po->id->headerCellClass() ?>"><div id="elh_rental_po_id" class="rental_po_id"><div class="ew-table-header-caption"><?php echo $rental_po->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $rental_po->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->id) ?>',2);"><div id="elh_rental_po_id" class="rental_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_po->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->programme_datetime->Visible) { // programme_datetime ?>
	<?php if ($rental_po->sortUrl($rental_po->programme_datetime) == "") { ?>
		<th data-name="programme_datetime" class="<?php echo $rental_po->programme_datetime->headerCellClass() ?>"><div id="elh_rental_po_programme_datetime" class="rental_po_programme_datetime"><div class="ew-table-header-caption"><?php echo $rental_po->programme_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="programme_datetime" class="<?php echo $rental_po->programme_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->programme_datetime) ?>',2);"><div id="elh_rental_po_programme_datetime" class="rental_po_programme_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->programme_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_po->programme_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->programme_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->location->Visible) { // location ?>
	<?php if ($rental_po->sortUrl($rental_po->location) == "") { ?>
		<th data-name="location" class="<?php echo $rental_po->location->headerCellClass() ?>"><div id="elh_rental_po_location" class="rental_po_location"><div class="ew-table-header-caption"><?php echo $rental_po->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $rental_po->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->location) ?>',2);"><div id="elh_rental_po_location" class="rental_po_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->location->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_po->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->item->Visible) { // item ?>
	<?php if ($rental_po->sortUrl($rental_po->item) == "") { ?>
		<th data-name="item" class="<?php echo $rental_po->item->headerCellClass() ?>"><div id="elh_rental_po_item" class="rental_po_item"><div class="ew-table-header-caption"><?php echo $rental_po->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $rental_po->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->item) ?>',2);"><div id="elh_rental_po_item" class="rental_po_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_po->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->company_id->Visible) { // company_id ?>
	<?php if ($rental_po->sortUrl($rental_po->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $rental_po->company_id->headerCellClass() ?>"><div id="elh_rental_po_company_id" class="rental_po_company_id"><div class="ew-table-header-caption"><?php echo $rental_po->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $rental_po->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->company_id) ?>',2);"><div id="elh_rental_po_company_id" class="rental_po_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->company_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_po->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->amount->Visible) { // amount ?>
	<?php if ($rental_po->sortUrl($rental_po->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $rental_po->amount->headerCellClass() ?>"><div id="elh_rental_po_amount" class="rental_po_amount"><div class="ew-table-header-caption"><?php echo $rental_po->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $rental_po->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->amount) ?>',2);"><div id="elh_rental_po_amount" class="rental_po_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_po->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->type->Visible) { // type ?>
	<?php if ($rental_po->sortUrl($rental_po->type) == "") { ?>
		<th data-name="type" class="<?php echo $rental_po->type->headerCellClass() ?>"><div id="elh_rental_po_type" class="rental_po_type"><div class="ew-table-header-caption"><?php echo $rental_po->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $rental_po->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->type) ?>',2);"><div id="elh_rental_po_type" class="rental_po_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_po->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->gst->Visible) { // gst ?>
	<?php if ($rental_po->sortUrl($rental_po->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $rental_po->gst->headerCellClass() ?>"><div id="elh_rental_po_gst" class="rental_po_gst"><div class="ew-table-header-caption"><?php echo $rental_po->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $rental_po->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->gst) ?>',2);"><div id="elh_rental_po_gst" class="rental_po_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->gst->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_po->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->reports_to->Visible) { // reports_to ?>
	<?php if ($rental_po->sortUrl($rental_po->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $rental_po->reports_to->headerCellClass() ?>"><div id="elh_rental_po_reports_to" class="rental_po_reports_to"><div class="ew-table-header-caption"><?php echo $rental_po->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $rental_po->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->reports_to) ?>',2);"><div id="elh_rental_po_reports_to" class="rental_po_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_po->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->operator->Visible) { // operator ?>
	<?php if ($rental_po->sortUrl($rental_po->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $rental_po->operator->headerCellClass() ?>"><div id="elh_rental_po_operator" class="rental_po_operator"><div class="ew-table-header-caption"><?php echo $rental_po->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $rental_po->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->operator) ?>',2);"><div id="elh_rental_po_operator" class="rental_po_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_po->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->datetime->Visible) { // datetime ?>
	<?php if ($rental_po->sortUrl($rental_po->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $rental_po->datetime->headerCellClass() ?>"><div id="elh_rental_po_datetime" class="rental_po_datetime"><div class="ew-table-header-caption"><?php echo $rental_po->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $rental_po->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->datetime) ?>',2);"><div id="elh_rental_po_datetime" class="rental_po_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_po->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->booking_ref->Visible) { // booking_ref ?>
	<?php if ($rental_po->sortUrl($rental_po->booking_ref) == "") { ?>
		<th data-name="booking_ref" class="<?php echo $rental_po->booking_ref->headerCellClass() ?>"><div id="elh_rental_po_booking_ref" class="rental_po_booking_ref"><div class="ew-table-header-caption"><?php echo $rental_po->booking_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="booking_ref" class="<?php echo $rental_po->booking_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->booking_ref) ?>',2);"><div id="elh_rental_po_booking_ref" class="rental_po_booking_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->booking_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_po->booking_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->booking_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->contact_person->Visible) { // contact_person ?>
	<?php if ($rental_po->sortUrl($rental_po->contact_person) == "") { ?>
		<th data-name="contact_person" class="<?php echo $rental_po->contact_person->headerCellClass() ?>"><div id="elh_rental_po_contact_person" class="rental_po_contact_person"><div class="ew-table-header-caption"><?php echo $rental_po->contact_person->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="contact_person" class="<?php echo $rental_po->contact_person->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->contact_person) ?>',2);"><div id="elh_rental_po_contact_person" class="rental_po_contact_person">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->contact_person->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($rental_po->contact_person->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->contact_person->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($rental_po->programme_end_datetime->Visible) { // programme_end_datetime ?>
	<?php if ($rental_po->sortUrl($rental_po->programme_end_datetime) == "") { ?>
		<th data-name="programme_end_datetime" class="<?php echo $rental_po->programme_end_datetime->headerCellClass() ?>"><div id="elh_rental_po_programme_end_datetime" class="rental_po_programme_end_datetime"><div class="ew-table-header-caption"><?php echo $rental_po->programme_end_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="programme_end_datetime" class="<?php echo $rental_po->programme_end_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $rental_po->SortUrl($rental_po->programme_end_datetime) ?>',2);"><div id="elh_rental_po_programme_end_datetime" class="rental_po_programme_end_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $rental_po->programme_end_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($rental_po->programme_end_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($rental_po->programme_end_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$rental_po_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($rental_po->ExportAll && $rental_po->isExport()) {
	$rental_po_list->StopRec = $rental_po_list->TotalRecs;
} else {

	// Set the last record to display
	if ($rental_po_list->TotalRecs > $rental_po_list->StartRec + $rental_po_list->DisplayRecs - 1)
		$rental_po_list->StopRec = $rental_po_list->StartRec + $rental_po_list->DisplayRecs - 1;
	else
		$rental_po_list->StopRec = $rental_po_list->TotalRecs;
}
$rental_po_list->RecCnt = $rental_po_list->StartRec - 1;
if ($rental_po_list->Recordset && !$rental_po_list->Recordset->EOF) {
	$rental_po_list->Recordset->moveFirst();
	$selectLimit = $rental_po_list->UseSelectLimit;
	if (!$selectLimit && $rental_po_list->StartRec > 1)
		$rental_po_list->Recordset->move($rental_po_list->StartRec - 1);
} elseif (!$rental_po->AllowAddDeleteRow && $rental_po_list->StopRec == 0) {
	$rental_po_list->StopRec = $rental_po->GridAddRowCount;
}

// Initialize aggregate
$rental_po->RowType = ROWTYPE_AGGREGATEINIT;
$rental_po->resetAttributes();
$rental_po_list->renderRow();
while ($rental_po_list->RecCnt < $rental_po_list->StopRec) {
	$rental_po_list->RecCnt++;
	if ($rental_po_list->RecCnt >= $rental_po_list->StartRec) {
		$rental_po_list->RowCnt++;

		// Set up key count
		$rental_po_list->KeyCount = $rental_po_list->RowIndex;

		// Init row class and style
		$rental_po->resetAttributes();
		$rental_po->CssClass = "";
		if ($rental_po->isGridAdd()) {
		} else {
			$rental_po_list->loadRowValues($rental_po_list->Recordset); // Load row values
		}
		$rental_po->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$rental_po->RowAttrs = array_merge($rental_po->RowAttrs, array('data-rowindex'=>$rental_po_list->RowCnt, 'id'=>'r' . $rental_po_list->RowCnt . '_rental_po', 'data-rowtype'=>$rental_po->RowType));

		// Render row
		$rental_po_list->renderRow();

		// Render list options
		$rental_po_list->renderListOptions();
?>
	<tr<?php echo $rental_po->rowAttributes() ?>>
<?php

// Render list options (body, left)
$rental_po_list->ListOptions->render("body", "left", $rental_po_list->RowCnt);
?>
	<?php if ($rental_po->id->Visible) { // id ?>
		<td data-name="id"<?php echo $rental_po->id->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_id" class="rental_po_id">
<span<?php echo $rental_po->id->viewAttributes() ?>>
<?php echo $rental_po->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->programme_datetime->Visible) { // programme_datetime ?>
		<td data-name="programme_datetime"<?php echo $rental_po->programme_datetime->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_programme_datetime" class="rental_po_programme_datetime">
<span<?php echo $rental_po->programme_datetime->viewAttributes() ?>>
<?php echo $rental_po->programme_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->location->Visible) { // location ?>
		<td data-name="location"<?php echo $rental_po->location->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_location" class="rental_po_location">
<span<?php echo $rental_po->location->viewAttributes() ?>>
<?php echo $rental_po->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->item->Visible) { // item ?>
		<td data-name="item"<?php echo $rental_po->item->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_item" class="rental_po_item">
<span<?php echo $rental_po->item->viewAttributes() ?>>
<?php echo $rental_po->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $rental_po->company_id->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_company_id" class="rental_po_company_id">
<span<?php echo $rental_po->company_id->viewAttributes() ?>>
<?php echo $rental_po->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $rental_po->amount->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_amount" class="rental_po_amount">
<span<?php echo $rental_po->amount->viewAttributes() ?>>
<?php echo $rental_po->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->type->Visible) { // type ?>
		<td data-name="type"<?php echo $rental_po->type->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_type" class="rental_po_type">
<span<?php echo $rental_po->type->viewAttributes() ?>>
<?php echo $rental_po->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $rental_po->gst->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_gst" class="rental_po_gst">
<span<?php echo $rental_po->gst->viewAttributes() ?>>
<?php echo $rental_po->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $rental_po->reports_to->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_reports_to" class="rental_po_reports_to">
<span<?php echo $rental_po->reports_to->viewAttributes() ?>>
<?php echo $rental_po->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $rental_po->operator->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_operator" class="rental_po_operator">
<span<?php echo $rental_po->operator->viewAttributes() ?>>
<?php echo $rental_po->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $rental_po->datetime->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_datetime" class="rental_po_datetime">
<span<?php echo $rental_po->datetime->viewAttributes() ?>>
<?php echo $rental_po->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->booking_ref->Visible) { // booking_ref ?>
		<td data-name="booking_ref"<?php echo $rental_po->booking_ref->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_booking_ref" class="rental_po_booking_ref">
<span<?php echo $rental_po->booking_ref->viewAttributes() ?>>
<?php echo $rental_po->booking_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->contact_person->Visible) { // contact_person ?>
		<td data-name="contact_person"<?php echo $rental_po->contact_person->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_contact_person" class="rental_po_contact_person">
<span<?php echo $rental_po->contact_person->viewAttributes() ?>>
<?php echo $rental_po->contact_person->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($rental_po->programme_end_datetime->Visible) { // programme_end_datetime ?>
		<td data-name="programme_end_datetime"<?php echo $rental_po->programme_end_datetime->cellAttributes() ?>>
<span id="el<?php echo $rental_po_list->RowCnt ?>_rental_po_programme_end_datetime" class="rental_po_programme_end_datetime">
<span<?php echo $rental_po->programme_end_datetime->viewAttributes() ?>>
<?php echo $rental_po->programme_end_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$rental_po_list->ListOptions->render("body", "right", $rental_po_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$rental_po->isGridAdd())
		$rental_po_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$rental_po->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($rental_po_list->Recordset)
	$rental_po_list->Recordset->Close();
?>
<?php if (!$rental_po->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$rental_po->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($rental_po_list->Pager)) $rental_po_list->Pager = new PrevNextPager($rental_po_list->StartRec, $rental_po_list->DisplayRecs, $rental_po_list->TotalRecs, $rental_po_list->AutoHidePager) ?>
<?php if ($rental_po_list->Pager->RecordCount > 0 && $rental_po_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($rental_po_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $rental_po_list->pageUrl() ?>start=<?php echo $rental_po_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($rental_po_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $rental_po_list->pageUrl() ?>start=<?php echo $rental_po_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $rental_po_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($rental_po_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $rental_po_list->pageUrl() ?>start=<?php echo $rental_po_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($rental_po_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $rental_po_list->pageUrl() ?>start=<?php echo $rental_po_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $rental_po_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($rental_po_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $rental_po_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $rental_po_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $rental_po_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($rental_po_list->TotalRecs > 0 && (!$rental_po_list->AutoHidePageSizeSelector || $rental_po_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="rental_po">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($rental_po_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($rental_po_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($rental_po_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($rental_po_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($rental_po_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($rental_po->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $rental_po_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($rental_po_list->TotalRecs == 0 && !$rental_po->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $rental_po_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$rental_po_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$rental_po->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$rental_po_list->terminate();
?>