<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$rental_po_search = new rental_po_search();

// Run the page
$rental_po_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$rental_po_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($rental_po_search->IsModal) { ?>
var frental_posearch = currentAdvancedSearchForm = new ew.Form("frental_posearch", "search");
<?php } else { ?>
var frental_posearch = currentForm = new ew.Form("frental_posearch", "search");
<?php } ?>

// Form_CustomValidate event
frental_posearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frental_posearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
frental_posearch.multiPage = new ew.MultiPage("frental_posearch");

// Dynamic selection lists
frental_posearch.lists["x_company_id"] = <?php echo $rental_po_search->company_id->Lookup->toClientList() ?>;
frental_posearch.lists["x_company_id"].options = <?php echo JsonEncode($rental_po_search->company_id->lookupOptions()) ?>;
frental_posearch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frental_posearch.lists["x_type"] = <?php echo $rental_po_search->type->Lookup->toClientList() ?>;
frental_posearch.lists["x_type"].options = <?php echo JsonEncode($rental_po_search->type->options(FALSE, TRUE)) ?>;
frental_posearch.lists["x_gst"] = <?php echo $rental_po_search->gst->Lookup->toClientList() ?>;
frental_posearch.lists["x_gst"].options = <?php echo JsonEncode($rental_po_search->gst->lookupOptions()) ?>;
frental_posearch.lists["x_reports_to"] = <?php echo $rental_po_search->reports_to->Lookup->toClientList() ?>;
frental_posearch.lists["x_reports_to"].options = <?php echo JsonEncode($rental_po_search->reports_to->lookupOptions()) ?>;
frental_posearch.lists["x_description_01[]"] = <?php echo $rental_po_search->description_01->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_01[]"].options = <?php echo JsonEncode($rental_po_search->description_01->lookupOptions()) ?>;
frental_posearch.lists["x_description_02[]"] = <?php echo $rental_po_search->description_02->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_02[]"].options = <?php echo JsonEncode($rental_po_search->description_02->lookupOptions()) ?>;
frental_posearch.lists["x_description_03[]"] = <?php echo $rental_po_search->description_03->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_03[]"].options = <?php echo JsonEncode($rental_po_search->description_03->lookupOptions()) ?>;
frental_posearch.lists["x_description_04[]"] = <?php echo $rental_po_search->description_04->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_04[]"].options = <?php echo JsonEncode($rental_po_search->description_04->lookupOptions()) ?>;
frental_posearch.lists["x_description_05[]"] = <?php echo $rental_po_search->description_05->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_05[]"].options = <?php echo JsonEncode($rental_po_search->description_05->lookupOptions()) ?>;
frental_posearch.lists["x_description_06[]"] = <?php echo $rental_po_search->description_06->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_06[]"].options = <?php echo JsonEncode($rental_po_search->description_06->lookupOptions()) ?>;
frental_posearch.lists["x_description_07[]"] = <?php echo $rental_po_search->description_07->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_07[]"].options = <?php echo JsonEncode($rental_po_search->description_07->lookupOptions()) ?>;
frental_posearch.lists["x_description_08[]"] = <?php echo $rental_po_search->description_08->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_08[]"].options = <?php echo JsonEncode($rental_po_search->description_08->lookupOptions()) ?>;
frental_posearch.lists["x_description_09[]"] = <?php echo $rental_po_search->description_09->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_09[]"].options = <?php echo JsonEncode($rental_po_search->description_09->lookupOptions()) ?>;
frental_posearch.lists["x_description_10[]"] = <?php echo $rental_po_search->description_10->Lookup->toClientList() ?>;
frental_posearch.lists["x_description_10[]"].options = <?php echo JsonEncode($rental_po_search->description_10->lookupOptions()) ?>;

// Form object for search
// Validate function for search

frental_posearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_po->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_programme_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_po->programme_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_po->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_programme_end_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($rental_po->programme_end_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $rental_po_search->showPageHeader(); ?>
<?php
$rental_po_search->showMessage();
?>
<form name="frental_posearch" id="frental_posearch" class="<?php echo $rental_po_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($rental_po_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $rental_po_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="rental_po">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$rental_po_search->IsModal ?>">
<?php if ($rental_po_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($rental_po->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_id"><?php echo $rental_po->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->id->cellAttributes() ?>>
			<span id="el_rental_po_id">
<input type="text" data-table="rental_po" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($rental_po->id->getPlaceHolder()) ?>" value="<?php echo $rental_po->id->EditValue ?>"<?php echo $rental_po->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->programme_datetime->Visible) { // programme_datetime ?>
	<div id="r_programme_datetime" class="form-group row">
		<label for="x_programme_datetime" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_programme_datetime"><?php echo $rental_po->programme_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_programme_datetime" id="z_programme_datetime" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->programme_datetime->cellAttributes() ?>>
			<span id="el_rental_po_programme_datetime">
<input type="text" data-table="rental_po" data-field="x_programme_datetime" data-page="0" name="x_programme_datetime" id="x_programme_datetime" placeholder="<?php echo HtmlEncode($rental_po->programme_datetime->getPlaceHolder()) ?>" value="<?php echo $rental_po->programme_datetime->EditValue ?>"<?php echo $rental_po->programme_datetime->editAttributes() ?>>
<?php if (!$rental_po->programme_datetime->ReadOnly && !$rental_po->programme_datetime->Disabled && !isset($rental_po->programme_datetime->EditAttrs["readonly"]) && !isset($rental_po->programme_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frental_posearch", "x_programme_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_location"><?php echo $rental_po->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_location" id="z_location" value="LIKE"></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->location->cellAttributes() ?>>
			<span id="el_rental_po_location">
<input type="text" data-table="rental_po" data-field="x_location" data-page="0" name="x_location" id="x_location" size="35" placeholder="<?php echo HtmlEncode($rental_po->location->getPlaceHolder()) ?>" value="<?php echo $rental_po->location->EditValue ?>"<?php echo $rental_po->location->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_company_id"><?php echo $rental_po->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->company_id->cellAttributes() ?>>
			<span id="el_rental_po_company_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$rental_po->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$rental_po->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($rental_po->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($rental_po->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($rental_po->company_id->getPlaceHolder()) ?>"<?php echo $rental_po->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($rental_po->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($rental_po->company_id->ReadOnly || $rental_po->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="rental_po" data-field="x_company_id" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $rental_po->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($rental_po->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
frental_posearch.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $rental_po->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_amount"><?php echo $rental_po->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->amount->cellAttributes() ?>>
			<span id="el_rental_po_amount">
<input type="text" data-table="rental_po" data-field="x_amount" data-page="0" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($rental_po->amount->getPlaceHolder()) ?>" value="<?php echo $rental_po->amount->EditValue ?>"<?php echo $rental_po->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_type"><?php echo $rental_po->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->type->cellAttributes() ?>>
			<span id="el_rental_po_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_po" data-field="x_type" data-page="0" data-value-separator="<?php echo $rental_po->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $rental_po->type->editAttributes() ?>>
		<?php echo $rental_po->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="rental_po_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $rental_po_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($rental_po_search->MultiPages->isActive("1")) ?>" href="#tab_rental_po1"><?php echo $rental_po->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $rental_po_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $rental_po_search->MultiPages->Parent ?>" id="tab_rental_po1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($rental_po->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_01"><?php echo $rental_po->description_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_01" id="z_description_01" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_01->cellAttributes() ?>>
			<span id="el_rental_po_description_01">
<div id="tp_x_description_01" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_01" data-page="1" data-value-separator="<?php echo $rental_po->description_01->displayValueSeparatorAttribute() ?>" name="x_description_01[]" id="x_description_01[]" value="{value}"<?php echo $rental_po->description_01->editAttributes() ?>></div>
<div id="dsl_x_description_01" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_01->checkBoxListHtml(FALSE, "x_description_01[]", 1) ?>
</div></div>
<?php echo $rental_po->description_01->Lookup->getParamTag("p_x_description_01") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_02"><?php echo $rental_po->description_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_02" id="z_description_02" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_02->cellAttributes() ?>>
			<span id="el_rental_po_description_02">
<div id="tp_x_description_02" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_02" data-page="1" data-value-separator="<?php echo $rental_po->description_02->displayValueSeparatorAttribute() ?>" name="x_description_02[]" id="x_description_02[]" value="{value}"<?php echo $rental_po->description_02->editAttributes() ?>></div>
<div id="dsl_x_description_02" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_02->checkBoxListHtml(FALSE, "x_description_02[]", 1) ?>
</div></div>
<?php echo $rental_po->description_02->Lookup->getParamTag("p_x_description_02") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_03"><?php echo $rental_po->description_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_03" id="z_description_03" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_03->cellAttributes() ?>>
			<span id="el_rental_po_description_03">
<div id="tp_x_description_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_03" data-page="1" data-value-separator="<?php echo $rental_po->description_03->displayValueSeparatorAttribute() ?>" name="x_description_03[]" id="x_description_03[]" value="{value}"<?php echo $rental_po->description_03->editAttributes() ?>></div>
<div id="dsl_x_description_03" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_03->checkBoxListHtml(FALSE, "x_description_03[]", 1) ?>
</div></div>
<?php echo $rental_po->description_03->Lookup->getParamTag("p_x_description_03") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_04"><?php echo $rental_po->description_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_04" id="z_description_04" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_04->cellAttributes() ?>>
			<span id="el_rental_po_description_04">
<div id="tp_x_description_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_04" data-page="1" data-value-separator="<?php echo $rental_po->description_04->displayValueSeparatorAttribute() ?>" name="x_description_04[]" id="x_description_04[]" value="{value}"<?php echo $rental_po->description_04->editAttributes() ?>></div>
<div id="dsl_x_description_04" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_04->checkBoxListHtml(FALSE, "x_description_04[]", 1) ?>
</div></div>
<?php echo $rental_po->description_04->Lookup->getParamTag("p_x_description_04") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_05"><?php echo $rental_po->description_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_05" id="z_description_05" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_05->cellAttributes() ?>>
			<span id="el_rental_po_description_05">
<div id="tp_x_description_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_05" data-page="1" data-value-separator="<?php echo $rental_po->description_05->displayValueSeparatorAttribute() ?>" name="x_description_05[]" id="x_description_05[]" value="{value}"<?php echo $rental_po->description_05->editAttributes() ?>></div>
<div id="dsl_x_description_05" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_05->checkBoxListHtml(FALSE, "x_description_05[]", 1) ?>
</div></div>
<?php echo $rental_po->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_06"><?php echo $rental_po->description_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_06" id="z_description_06" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_06->cellAttributes() ?>>
			<span id="el_rental_po_description_06">
<div id="tp_x_description_06" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_06" data-page="1" data-value-separator="<?php echo $rental_po->description_06->displayValueSeparatorAttribute() ?>" name="x_description_06[]" id="x_description_06[]" value="{value}"<?php echo $rental_po->description_06->editAttributes() ?>></div>
<div id="dsl_x_description_06" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_06->checkBoxListHtml(FALSE, "x_description_06[]", 1) ?>
</div></div>
<?php echo $rental_po->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_07"><?php echo $rental_po->description_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_07" id="z_description_07" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_07->cellAttributes() ?>>
			<span id="el_rental_po_description_07">
<div id="tp_x_description_07" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_07" data-page="1" data-value-separator="<?php echo $rental_po->description_07->displayValueSeparatorAttribute() ?>" name="x_description_07[]" id="x_description_07[]" value="{value}"<?php echo $rental_po->description_07->editAttributes() ?>></div>
<div id="dsl_x_description_07" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_07->checkBoxListHtml(FALSE, "x_description_07[]", 1) ?>
</div></div>
<?php echo $rental_po->description_07->Lookup->getParamTag("p_x_description_07") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_08"><?php echo $rental_po->description_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_08" id="z_description_08" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_08->cellAttributes() ?>>
			<span id="el_rental_po_description_08">
<div id="tp_x_description_08" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_08" data-page="1" data-value-separator="<?php echo $rental_po->description_08->displayValueSeparatorAttribute() ?>" name="x_description_08[]" id="x_description_08[]" value="{value}"<?php echo $rental_po->description_08->editAttributes() ?>></div>
<div id="dsl_x_description_08" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_08->checkBoxListHtml(FALSE, "x_description_08[]", 1) ?>
</div></div>
<?php echo $rental_po->description_08->Lookup->getParamTag("p_x_description_08") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_09"><?php echo $rental_po->description_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_09" id="z_description_09" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_09->cellAttributes() ?>>
			<span id="el_rental_po_description_09">
<div id="tp_x_description_09" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_09" data-page="1" data-value-separator="<?php echo $rental_po->description_09->displayValueSeparatorAttribute() ?>" name="x_description_09[]" id="x_description_09[]" value="{value}"<?php echo $rental_po->description_09->editAttributes() ?>></div>
<div id="dsl_x_description_09" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_09->checkBoxListHtml(FALSE, "x_description_09[]", 1) ?>
</div></div>
<?php echo $rental_po->description_09->Lookup->getParamTag("p_x_description_09") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_description_10"><?php echo $rental_po->description_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_10" id="z_description_10" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->description_10->cellAttributes() ?>>
			<span id="el_rental_po_description_10">
<div id="tp_x_description_10" class="ew-template"><input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_10" data-page="1" data-value-separator="<?php echo $rental_po->description_10->displayValueSeparatorAttribute() ?>" name="x_description_10[]" id="x_description_10[]" value="{value}"<?php echo $rental_po->description_10->editAttributes() ?>></div>
<div id="dsl_x_description_10" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $rental_po->description_10->checkBoxListHtml(FALSE, "x_description_10[]", 1) ?>
</div></div>
<?php echo $rental_po->description_10->Lookup->getParamTag("p_x_description_10") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->booking_ref->Visible) { // booking_ref ?>
	<div id="r_booking_ref" class="form-group row">
		<label for="x_booking_ref" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_booking_ref"><?php echo $rental_po->booking_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_booking_ref" id="z_booking_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->booking_ref->cellAttributes() ?>>
			<span id="el_rental_po_booking_ref">
<input type="text" data-table="rental_po" data-field="x_booking_ref" data-page="1" name="x_booking_ref" id="x_booking_ref" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($rental_po->booking_ref->getPlaceHolder()) ?>" value="<?php echo $rental_po->booking_ref->EditValue ?>"<?php echo $rental_po->booking_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->contact_person->Visible) { // contact_person ?>
	<div id="r_contact_person" class="form-group row">
		<label for="x_contact_person" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_contact_person"><?php echo $rental_po->contact_person->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_contact_person" id="z_contact_person" value="LIKE"></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->contact_person->cellAttributes() ?>>
			<span id="el_rental_po_contact_person">
<input type="text" data-table="rental_po" data-field="x_contact_person" data-page="1" name="x_contact_person" id="x_contact_person" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($rental_po->contact_person->getPlaceHolder()) ?>" value="<?php echo $rental_po->contact_person->EditValue ?>"<?php echo $rental_po->contact_person->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->programme_end_datetime->Visible) { // programme_end_datetime ?>
	<div id="r_programme_end_datetime" class="form-group row">
		<label for="x_programme_end_datetime" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_programme_end_datetime"><?php echo $rental_po->programme_end_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_programme_end_datetime" id="z_programme_end_datetime" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->programme_end_datetime->cellAttributes() ?>>
			<span id="el_rental_po_programme_end_datetime">
<input type="text" data-table="rental_po" data-field="x_programme_end_datetime" data-page="1" name="x_programme_end_datetime" id="x_programme_end_datetime" placeholder="<?php echo HtmlEncode($rental_po->programme_end_datetime->getPlaceHolder()) ?>" value="<?php echo $rental_po->programme_end_datetime->EditValue ?>"<?php echo $rental_po->programme_end_datetime->editAttributes() ?>>
<?php if (!$rental_po->programme_end_datetime->ReadOnly && !$rental_po->programme_end_datetime->Disabled && !isset($rental_po->programme_end_datetime->EditAttrs["readonly"]) && !isset($rental_po->programme_end_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frental_posearch", "x_programme_end_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $rental_po_search->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($rental_po_search->MultiPages->isActive("2")) ?>" href="#tab_rental_po2"><?php echo $rental_po->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $rental_po_search->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $rental_po_search->MultiPages->Parent ?>" id="tab_rental_po2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($rental_po->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label for="x_buyer_instruction" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_buyer_instruction"><?php echo $rental_po->buyer_instruction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE"></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->buyer_instruction->cellAttributes() ?>>
			<span id="el_rental_po_buyer_instruction">
<input type="text" data-table="rental_po" data-field="x_buyer_instruction" data-page="2" name="x_buyer_instruction" id="x_buyer_instruction" size="30" placeholder="<?php echo HtmlEncode($rental_po->buyer_instruction->getPlaceHolder()) ?>" value="<?php echo $rental_po->buyer_instruction->EditValue ?>"<?php echo $rental_po->buyer_instruction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_remarks"><?php echo $rental_po->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->remarks->cellAttributes() ?>>
			<span id="el_rental_po_remarks">
<input type="text" data-table="rental_po" data-field="x_remarks" data-page="2" name="x_remarks" id="x_remarks" size="30" placeholder="<?php echo HtmlEncode($rental_po->remarks->getPlaceHolder()) ?>" value="<?php echo $rental_po->remarks->EditValue ?>"<?php echo $rental_po->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label for="x_gst" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_gst"><?php echo $rental_po->gst->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gst" id="z_gst" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->gst->cellAttributes() ?>>
			<span id="el_rental_po_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_po" data-field="x_gst" data-page="2" data-value-separator="<?php echo $rental_po->gst->displayValueSeparatorAttribute() ?>" id="x_gst" name="x_gst"<?php echo $rental_po->gst->editAttributes() ?>>
		<?php echo $rental_po->gst->selectOptionListHtml("x_gst") ?>
	</select>
</div>
<?php echo $rental_po->gst->Lookup->getParamTag("p_x_gst") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($rental_po->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $rental_po_search->LeftColumnClass ?>"><span id="elh_rental_po_reports_to"><?php echo $rental_po->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $rental_po_search->RightColumnClass ?>"><div<?php echo $rental_po->reports_to->cellAttributes() ?>>
			<span id="el_rental_po_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="rental_po" data-field="x_reports_to" data-page="2" data-value-separator="<?php echo $rental_po->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $rental_po->reports_to->editAttributes() ?>>
		<?php echo $rental_po->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $rental_po->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$rental_po_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $rental_po_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$rental_po_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$rental_po_search->terminate();
?>