<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$request_archive_list = new request_archive_list();

// Run the page
$request_archive_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$request_archive_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$request_archive->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var frequest_archivelist = currentForm = new ew.Form("frequest_archivelist", "list");
frequest_archivelist.formKeyCountName = '<?php echo $request_archive_list->FormKeyCountName ?>';

// Form_CustomValidate event
frequest_archivelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequest_archivelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequest_archivelist.lists["x_type"] = <?php echo $request_archive_list->type->Lookup->toClientList() ?>;
frequest_archivelist.lists["x_type"].options = <?php echo JsonEncode($request_archive_list->type->options(FALSE, TRUE)) ?>;

// Form object for search
var frequest_archivelistsrch = currentSearchForm = new ew.Form("frequest_archivelistsrch");

// Filters
frequest_archivelistsrch.filterList = <?php echo $request_archive_list->getFilterList() ?>;

// Init search panel as collapsed
frequest_archivelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$request_archive->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($request_archive_list->TotalRecs > 0 && $request_archive_list->ExportOptions->visible()) { ?>
<?php $request_archive_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($request_archive_list->ImportOptions->visible()) { ?>
<?php $request_archive_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($request_archive_list->SearchOptions->visible()) { ?>
<?php $request_archive_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($request_archive_list->FilterOptions->visible()) { ?>
<?php $request_archive_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$request_archive_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$request_archive->isExport() && !$request_archive->CurrentAction) { ?>
<form name="frequest_archivelistsrch" id="frequest_archivelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($request_archive_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="frequest_archivelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="request_archive">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($request_archive_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($request_archive_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $request_archive_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($request_archive_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($request_archive_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($request_archive_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($request_archive_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $request_archive_list->showPageHeader(); ?>
<?php
$request_archive_list->showMessage();
?>
<?php if ($request_archive_list->TotalRecs > 0 || $request_archive->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($request_archive_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> request_archive">
<?php if (!$request_archive->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$request_archive->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($request_archive_list->Pager)) $request_archive_list->Pager = new PrevNextPager($request_archive_list->StartRec, $request_archive_list->DisplayRecs, $request_archive_list->TotalRecs, $request_archive_list->AutoHidePager) ?>
<?php if ($request_archive_list->Pager->RecordCount > 0 && $request_archive_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($request_archive_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $request_archive_list->pageUrl() ?>start=<?php echo $request_archive_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($request_archive_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $request_archive_list->pageUrl() ?>start=<?php echo $request_archive_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $request_archive_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($request_archive_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $request_archive_list->pageUrl() ?>start=<?php echo $request_archive_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($request_archive_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $request_archive_list->pageUrl() ?>start=<?php echo $request_archive_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $request_archive_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($request_archive_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $request_archive_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $request_archive_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $request_archive_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($request_archive_list->TotalRecs > 0 && (!$request_archive_list->AutoHidePageSizeSelector || $request_archive_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="request_archive">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($request_archive_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($request_archive_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($request_archive_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($request_archive_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($request_archive_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($request_archive->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $request_archive_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="frequest_archivelist" id="frequest_archivelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($request_archive_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $request_archive_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="request_archive">
<div id="gmp_request_archive" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($request_archive_list->TotalRecs > 0 || $request_archive->isGridEdit()) { ?>
<table id="tbl_request_archivelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$request_archive_list->RowType = ROWTYPE_HEADER;

// Render list options
$request_archive_list->renderListOptions();

// Render list options (header, left)
$request_archive_list->ListOptions->render("header", "left");
?>
<?php if ($request_archive->message->Visible) { // message ?>
	<?php if ($request_archive->sortUrl($request_archive->message) == "") { ?>
		<th data-name="message" class="<?php echo $request_archive->message->headerCellClass() ?>"><div id="elh_request_archive_message" class="request_archive_message"><div class="ew-table-header-caption"><?php echo $request_archive->message->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="message" class="<?php echo $request_archive->message->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_archive->SortUrl($request_archive->message) ?>',2);"><div id="elh_request_archive_message" class="request_archive_message">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_archive->message->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($request_archive->message->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_archive->message->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_archive->uploads->Visible) { // uploads ?>
	<?php if ($request_archive->sortUrl($request_archive->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $request_archive->uploads->headerCellClass() ?>"><div id="elh_request_archive_uploads" class="request_archive_uploads"><div class="ew-table-header-caption"><?php echo $request_archive->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $request_archive->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_archive->SortUrl($request_archive->uploads) ?>',2);"><div id="elh_request_archive_uploads" class="request_archive_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_archive->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($request_archive->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_archive->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_archive->lead_info->Visible) { // lead_info ?>
	<?php if ($request_archive->sortUrl($request_archive->lead_info) == "") { ?>
		<th data-name="lead_info" class="<?php echo $request_archive->lead_info->headerCellClass() ?>"><div id="elh_request_archive_lead_info" class="request_archive_lead_info"><div class="ew-table-header-caption"><?php echo $request_archive->lead_info->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lead_info" class="<?php echo $request_archive->lead_info->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_archive->SortUrl($request_archive->lead_info) ?>',2);"><div id="elh_request_archive_lead_info" class="request_archive_lead_info">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_archive->lead_info->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($request_archive->lead_info->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_archive->lead_info->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_archive->type->Visible) { // type ?>
	<?php if ($request_archive->sortUrl($request_archive->type) == "") { ?>
		<th data-name="type" class="<?php echo $request_archive->type->headerCellClass() ?>"><div id="elh_request_archive_type" class="request_archive_type"><div class="ew-table-header-caption"><?php echo $request_archive->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $request_archive->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_archive->SortUrl($request_archive->type) ?>',2);"><div id="elh_request_archive_type" class="request_archive_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_archive->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_archive->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_archive->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$request_archive_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($request_archive->ExportAll && $request_archive->isExport()) {
	$request_archive_list->StopRec = $request_archive_list->TotalRecs;
} else {

	// Set the last record to display
	if ($request_archive_list->TotalRecs > $request_archive_list->StartRec + $request_archive_list->DisplayRecs - 1)
		$request_archive_list->StopRec = $request_archive_list->StartRec + $request_archive_list->DisplayRecs - 1;
	else
		$request_archive_list->StopRec = $request_archive_list->TotalRecs;
}
$request_archive_list->RecCnt = $request_archive_list->StartRec - 1;
if ($request_archive_list->Recordset && !$request_archive_list->Recordset->EOF) {
	$request_archive_list->Recordset->moveFirst();
	$selectLimit = $request_archive_list->UseSelectLimit;
	if (!$selectLimit && $request_archive_list->StartRec > 1)
		$request_archive_list->Recordset->move($request_archive_list->StartRec - 1);
} elseif (!$request_archive->AllowAddDeleteRow && $request_archive_list->StopRec == 0) {
	$request_archive_list->StopRec = $request_archive->GridAddRowCount;
}

// Initialize aggregate
$request_archive->RowType = ROWTYPE_AGGREGATEINIT;
$request_archive->resetAttributes();
$request_archive_list->renderRow();
while ($request_archive_list->RecCnt < $request_archive_list->StopRec) {
	$request_archive_list->RecCnt++;
	if ($request_archive_list->RecCnt >= $request_archive_list->StartRec) {
		$request_archive_list->RowCnt++;

		// Set up key count
		$request_archive_list->KeyCount = $request_archive_list->RowIndex;

		// Init row class and style
		$request_archive->resetAttributes();
		$request_archive->CssClass = "";
		if ($request_archive->isGridAdd()) {
		} else {
			$request_archive_list->loadRowValues($request_archive_list->Recordset); // Load row values
		}
		$request_archive->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$request_archive->RowAttrs = array_merge($request_archive->RowAttrs, array('data-rowindex'=>$request_archive_list->RowCnt, 'id'=>'r' . $request_archive_list->RowCnt . '_request_archive', 'data-rowtype'=>$request_archive->RowType));

		// Render row
		$request_archive_list->renderRow();

		// Render list options
		$request_archive_list->renderListOptions();
?>
	<tr<?php echo $request_archive->rowAttributes() ?>>
<?php

// Render list options (body, left)
$request_archive_list->ListOptions->render("body", "left", $request_archive_list->RowCnt);
?>
	<?php if ($request_archive->message->Visible) { // message ?>
		<td data-name="message"<?php echo $request_archive->message->cellAttributes() ?>>
<span id="el<?php echo $request_archive_list->RowCnt ?>_request_archive_message" class="request_archive_message">
<span<?php echo $request_archive->message->viewAttributes() ?>>
<?php echo $request_archive->message->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_archive->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $request_archive->uploads->cellAttributes() ?>>
<span id="el<?php echo $request_archive_list->RowCnt ?>_request_archive_uploads" class="request_archive_uploads">
<span>
<?php echo GetFileViewTag($request_archive->uploads, $request_archive->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($request_archive->lead_info->Visible) { // lead_info ?>
		<td data-name="lead_info"<?php echo $request_archive->lead_info->cellAttributes() ?>>
<span id="el<?php echo $request_archive_list->RowCnt ?>_request_archive_lead_info" class="request_archive_lead_info">
<span<?php echo $request_archive->lead_info->viewAttributes() ?>>
<?php echo $request_archive->lead_info->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_archive->type->Visible) { // type ?>
		<td data-name="type"<?php echo $request_archive->type->cellAttributes() ?>>
<span id="el<?php echo $request_archive_list->RowCnt ?>_request_archive_type" class="request_archive_type">
<span<?php echo $request_archive->type->viewAttributes() ?>>
<?php echo $request_archive->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$request_archive_list->ListOptions->render("body", "right", $request_archive_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$request_archive->isGridAdd())
		$request_archive_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$request_archive->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($request_archive_list->Recordset)
	$request_archive_list->Recordset->Close();
?>
<?php if (!$request_archive->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$request_archive->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($request_archive_list->Pager)) $request_archive_list->Pager = new PrevNextPager($request_archive_list->StartRec, $request_archive_list->DisplayRecs, $request_archive_list->TotalRecs, $request_archive_list->AutoHidePager) ?>
<?php if ($request_archive_list->Pager->RecordCount > 0 && $request_archive_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($request_archive_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $request_archive_list->pageUrl() ?>start=<?php echo $request_archive_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($request_archive_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $request_archive_list->pageUrl() ?>start=<?php echo $request_archive_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $request_archive_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($request_archive_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $request_archive_list->pageUrl() ?>start=<?php echo $request_archive_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($request_archive_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $request_archive_list->pageUrl() ?>start=<?php echo $request_archive_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $request_archive_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($request_archive_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $request_archive_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $request_archive_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $request_archive_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($request_archive_list->TotalRecs > 0 && (!$request_archive_list->AutoHidePageSizeSelector || $request_archive_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="request_archive">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($request_archive_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($request_archive_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($request_archive_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($request_archive_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($request_archive_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($request_archive->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $request_archive_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($request_archive_list->TotalRecs == 0 && !$request_archive->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $request_archive_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$request_archive_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$request_archive->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$request_archive->isExport()) { ?>
<script>
ew.scrollableTable("gmp_request_archive", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$request_archive_list->terminate();
?>