<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$request_archive_search = new request_archive_search();

// Run the page
$request_archive_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$request_archive_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($request_archive_search->IsModal) { ?>
var frequest_archivesearch = currentAdvancedSearchForm = new ew.Form("frequest_archivesearch", "search");
<?php } else { ?>
var frequest_archivesearch = currentForm = new ew.Form("frequest_archivesearch", "search");
<?php } ?>

// Form_CustomValidate event
frequest_archivesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequest_archivesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequest_archivesearch.lists["x_lead_status"] = <?php echo $request_archive_search->lead_status->Lookup->toClientList() ?>;
frequest_archivesearch.lists["x_lead_status"].options = <?php echo JsonEncode($request_archive_search->lead_status->lookupOptions()) ?>;
frequest_archivesearch.lists["x_lead_type"] = <?php echo $request_archive_search->lead_type->Lookup->toClientList() ?>;
frequest_archivesearch.lists["x_lead_type"].options = <?php echo JsonEncode($request_archive_search->lead_type->lookupOptions()) ?>;
frequest_archivesearch.lists["x_type"] = <?php echo $request_archive_search->type->Lookup->toClientList() ?>;
frequest_archivesearch.lists["x_type"].options = <?php echo JsonEncode($request_archive_search->type->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

frequest_archivesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($request_archive->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_reference");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($request_archive->reference->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($request_archive->status->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($request_archive->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $request_archive_search->showPageHeader(); ?>
<?php
$request_archive_search->showMessage();
?>
<form name="frequest_archivesearch" id="frequest_archivesearch" class="<?php echo $request_archive_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($request_archive_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $request_archive_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="request_archive">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$request_archive_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($request_archive->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_id"><?php echo $request_archive->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->id->cellAttributes() ?>>
			<span id="el_request_archive_id">
<input type="text" data-table="request_archive" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($request_archive->id->getPlaceHolder()) ?>" value="<?php echo $request_archive->id->EditValue ?>"<?php echo $request_archive->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label for="x_r_from" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_r_from"><?php echo $request_archive->r_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_r_from" id="z_r_from" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->r_from->cellAttributes() ?>>
			<span id="el_request_archive_r_from">
<input type="text" data-table="request_archive" data-field="x_r_from" name="x_r_from" id="x_r_from" size="35" placeholder="<?php echo HtmlEncode($request_archive->r_from->getPlaceHolder()) ?>" value="<?php echo $request_archive->r_from->EditValue ?>"<?php echo $request_archive->r_from->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->r_to->Visible) { // r_to ?>
	<div id="r_r_to" class="form-group row">
		<label for="x_r_to" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_r_to"><?php echo $request_archive->r_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_r_to" id="z_r_to" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->r_to->cellAttributes() ?>>
			<span id="el_request_archive_r_to">
<input type="text" data-table="request_archive" data-field="x_r_to" name="x_r_to" id="x_r_to" size="35" placeholder="<?php echo HtmlEncode($request_archive->r_to->getPlaceHolder()) ?>" value="<?php echo $request_archive->r_to->EditValue ?>"<?php echo $request_archive->r_to->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_reference"><?php echo $request_archive->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reference" id="z_reference" value="="></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->reference->cellAttributes() ?>>
			<span id="el_request_archive_reference">
<input type="text" data-table="request_archive" data-field="x_reference" name="x_reference" id="x_reference" size="30" placeholder="<?php echo HtmlEncode($request_archive->reference->getPlaceHolder()) ?>" value="<?php echo $request_archive->reference->EditValue ?>"<?php echo $request_archive->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->message->Visible) { // message ?>
	<div id="r_message" class="form-group row">
		<label for="x_message" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_message"><?php echo $request_archive->message->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_message" id="z_message" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->message->cellAttributes() ?>>
			<span id="el_request_archive_message">
<input type="text" data-table="request_archive" data-field="x_message" name="x_message" id="x_message" size="35" placeholder="<?php echo HtmlEncode($request_archive->message->getPlaceHolder()) ?>" value="<?php echo $request_archive->message->EditValue ?>"<?php echo $request_archive->message->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_uploads"><?php echo $request_archive->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->uploads->cellAttributes() ?>>
			<span id="el_request_archive_uploads">
<input type="text" data-table="request_archive" data-field="x_uploads" name="x_uploads" id="x_uploads" placeholder="<?php echo HtmlEncode($request_archive->uploads->getPlaceHolder()) ?>" value="<?php echo $request_archive->uploads->EditValue ?>"<?php echo $request_archive->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->lead_info->Visible) { // lead_info ?>
	<div id="r_lead_info" class="form-group row">
		<label for="x_lead_info" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_lead_info"><?php echo $request_archive->lead_info->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lead_info" id="z_lead_info" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->lead_info->cellAttributes() ?>>
			<span id="el_request_archive_lead_info">
<input type="text" data-table="request_archive" data-field="x_lead_info" name="x_lead_info" id="x_lead_info" size="30" maxlength="236" placeholder="<?php echo HtmlEncode($request_archive->lead_info->getPlaceHolder()) ?>" value="<?php echo $request_archive->lead_info->EditValue ?>"<?php echo $request_archive->lead_info->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_status"><?php echo $request_archive->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->status->cellAttributes() ?>>
			<span id="el_request_archive_status">
<input type="text" data-table="request_archive" data-field="x_status" name="x_status" id="x_status" size="30" placeholder="<?php echo HtmlEncode($request_archive->status->getPlaceHolder()) ?>" value="<?php echo $request_archive->status->EditValue ?>"<?php echo $request_archive->status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->Subject->Visible) { // Subject ?>
	<div id="r_Subject" class="form-group row">
		<label for="x_Subject" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_Subject"><?php echo $request_archive->Subject->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Subject" id="z_Subject" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->Subject->cellAttributes() ?>>
			<span id="el_request_archive_Subject">
<input type="text" data-table="request_archive" data-field="x_Subject" name="x_Subject" id="x_Subject" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($request_archive->Subject->getPlaceHolder()) ?>" value="<?php echo $request_archive->Subject->EditValue ?>"<?php echo $request_archive->Subject->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_datetime"><?php echo $request_archive->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->datetime->cellAttributes() ?>>
			<span id="el_request_archive_datetime">
<input type="text" data-table="request_archive" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($request_archive->datetime->getPlaceHolder()) ?>" value="<?php echo $request_archive->datetime->EditValue ?>"<?php echo $request_archive->datetime->editAttributes() ?>>
<?php if (!$request_archive->datetime->ReadOnly && !$request_archive->datetime->Disabled && !isset($request_archive->datetime->EditAttrs["readonly"]) && !isset($request_archive->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frequest_archivesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->QueryGenerator->Visible) { // QueryGenerator ?>
	<div id="r_QueryGenerator" class="form-group row">
		<label for="x_QueryGenerator" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_QueryGenerator"><?php echo $request_archive->QueryGenerator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_QueryGenerator" id="z_QueryGenerator" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->QueryGenerator->cellAttributes() ?>>
			<span id="el_request_archive_QueryGenerator">
<input type="text" data-table="request_archive" data-field="x_QueryGenerator" name="x_QueryGenerator" id="x_QueryGenerator" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($request_archive->QueryGenerator->getPlaceHolder()) ?>" value="<?php echo $request_archive->QueryGenerator->EditValue ?>"<?php echo $request_archive->QueryGenerator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->forward_url->Visible) { // forward_url ?>
	<div id="r_forward_url" class="form-group row">
		<label for="x_forward_url" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_forward_url"><?php echo $request_archive->forward_url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_forward_url" id="z_forward_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->forward_url->cellAttributes() ?>>
			<span id="el_request_archive_forward_url">
<input type="text" data-table="request_archive" data-field="x_forward_url" name="x_forward_url" id="x_forward_url" size="35" maxlength="128" placeholder="<?php echo HtmlEncode($request_archive->forward_url->getPlaceHolder()) ?>" value="<?php echo $request_archive->forward_url->EditValue ?>"<?php echo $request_archive->forward_url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->lead_by->Visible) { // lead_by ?>
	<div id="r_lead_by" class="form-group row">
		<label for="x_lead_by" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_lead_by"><?php echo $request_archive->lead_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lead_by" id="z_lead_by" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->lead_by->cellAttributes() ?>>
			<span id="el_request_archive_lead_by">
<input type="text" data-table="request_archive" data-field="x_lead_by" name="x_lead_by" id="x_lead_by" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($request_archive->lead_by->getPlaceHolder()) ?>" value="<?php echo $request_archive->lead_by->EditValue ?>"<?php echo $request_archive->lead_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->lead_status->Visible) { // lead_status ?>
	<div id="r_lead_status" class="form-group row">
		<label class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_lead_status"><?php echo $request_archive->lead_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lead_status" id="z_lead_status" value="="></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->lead_status->cellAttributes() ?>>
			<span id="el_request_archive_lead_status">
<div id="tp_x_lead_status" class="ew-template"><input type="radio" class="form-check-input" data-table="request_archive" data-field="x_lead_status" data-value-separator="<?php echo $request_archive->lead_status->displayValueSeparatorAttribute() ?>" name="x_lead_status" id="x_lead_status" value="{value}"<?php echo $request_archive->lead_status->editAttributes() ?>></div>
<div id="dsl_x_lead_status" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $request_archive->lead_status->radioButtonListHtml(FALSE, "x_lead_status") ?>
</div></div>
<?php echo $request_archive->lead_status->Lookup->getParamTag("p_x_lead_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->lead_type->Visible) { // lead_type ?>
	<div id="r_lead_type" class="form-group row">
		<label class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_lead_type"><?php echo $request_archive->lead_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lead_type" id="z_lead_type" value="="></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->lead_type->cellAttributes() ?>>
			<span id="el_request_archive_lead_type">
<div id="tp_x_lead_type" class="ew-template"><input type="radio" class="form-check-input" data-table="request_archive" data-field="x_lead_type" data-value-separator="<?php echo $request_archive->lead_type->displayValueSeparatorAttribute() ?>" name="x_lead_type" id="x_lead_type" value="{value}"<?php echo $request_archive->lead_type->editAttributes() ?>></div>
<div id="dsl_x_lead_type" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $request_archive->lead_type->radioButtonListHtml(FALSE, "x_lead_type") ?>
</div></div>
<?php echo $request_archive->lead_type->Lookup->getParamTag("p_x_lead_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_archive->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $request_archive_search->LeftColumnClass ?>"><span id="elh_request_archive_type"><?php echo $request_archive->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $request_archive_search->RightColumnClass ?>"><div<?php echo $request_archive->type->cellAttributes() ?>>
			<span id="el_request_archive_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="request_archive" data-field="x_type" data-value-separator="<?php echo $request_archive->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $request_archive->type->editAttributes() ?>>
		<?php echo $request_archive->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$request_archive_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $request_archive_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$request_archive_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$request_archive_search->terminate();
?>