<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$request_group_list = new request_group_list();

// Run the page
$request_group_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$request_group_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$request_group->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var frequest_grouplist = currentForm = new ew.Form("frequest_grouplist", "list");
frequest_grouplist.formKeyCountName = '<?php echo $request_group_list->FormKeyCountName ?>';

// Form_CustomValidate event
frequest_grouplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequest_grouplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequest_grouplist.lists["x_type"] = <?php echo $request_group_list->type->Lookup->toClientList() ?>;
frequest_grouplist.lists["x_type"].options = <?php echo JsonEncode($request_group_list->type->options(FALSE, TRUE)) ?>;

// Form object for search
var frequest_grouplistsrch = currentSearchForm = new ew.Form("frequest_grouplistsrch");

// Filters
frequest_grouplistsrch.filterList = <?php echo $request_group_list->getFilterList() ?>;

// Init search panel as collapsed
frequest_grouplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
function request_search()
{
	var ID = $("#x_short_description").val();
	$.getJSON('apcajax.php?request_search_url='+ID,function(data){
		if (ID > 0)
		{
  			location.href='request_grouplist.php?'+data;
  			document.cookie = "id="+ID;
  		}
  		else
  		{
  			location.href='request_grouplist.php?cmd=reset';
  		}
  	});
  }
</script>
<?php } ?>
<?php if (!$request_group->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($request_group_list->TotalRecs > 0 && $request_group_list->ExportOptions->visible()) { ?>
<?php $request_group_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($request_group_list->ImportOptions->visible()) { ?>
<?php $request_group_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($request_group_list->SearchOptions->visible()) { ?>
<?php $request_group_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($request_group_list->FilterOptions->visible()) { ?>
<?php $request_group_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$request_group_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$request_group->isExport() && !$request_group->CurrentAction) { ?>
<form name="frequest_grouplistsrch" id="frequest_grouplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($request_group_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="frequest_grouplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="request_group">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($request_group_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($request_group_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $request_group_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($request_group_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($request_group_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($request_group_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($request_group_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $request_group_list->showPageHeader(); ?>
<?php
$request_group_list->showMessage();
?>
<?php if ($request_group_list->TotalRecs > 0 || $request_group->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($request_group_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> request_group">
<?php if (!$request_group->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$request_group->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($request_group_list->Pager)) $request_group_list->Pager = new PrevNextPager($request_group_list->StartRec, $request_group_list->DisplayRecs, $request_group_list->TotalRecs, $request_group_list->AutoHidePager) ?>
<?php if ($request_group_list->Pager->RecordCount > 0 && $request_group_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($request_group_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $request_group_list->pageUrl() ?>start=<?php echo $request_group_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($request_group_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $request_group_list->pageUrl() ?>start=<?php echo $request_group_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $request_group_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($request_group_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $request_group_list->pageUrl() ?>start=<?php echo $request_group_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($request_group_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $request_group_list->pageUrl() ?>start=<?php echo $request_group_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $request_group_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($request_group_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $request_group_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $request_group_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $request_group_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($request_group_list->TotalRecs > 0 && (!$request_group_list->AutoHidePageSizeSelector || $request_group_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="request_group">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($request_group_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($request_group_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($request_group_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($request_group_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($request_group_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($request_group->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $request_group_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="frequest_grouplist" id="frequest_grouplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($request_group_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $request_group_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="request_group">
<div id="gmp_request_group" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($request_group_list->TotalRecs > 0 || $request_group->isGridEdit()) { ?>
<table id="tbl_request_grouplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$request_group_list->RowType = ROWTYPE_HEADER;

// Render list options
$request_group_list->renderListOptions();

// Render list options (header, left)
$request_group_list->ListOptions->render("header", "left");
?>
<?php if ($request_group->reference->Visible) { // reference ?>
	<?php if ($request_group->sortUrl($request_group->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $request_group->reference->headerCellClass() ?>"><div id="elh_request_group_reference" class="request_group_reference"><div class="ew-table-header-caption"><?php echo $request_group->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $request_group->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_group->SortUrl($request_group->reference) ?>',2);"><div id="elh_request_group_reference" class="request_group_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_group->reference->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_group->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_group->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_group->message->Visible) { // message ?>
	<?php if ($request_group->sortUrl($request_group->message) == "") { ?>
		<th data-name="message" class="<?php echo $request_group->message->headerCellClass() ?>"><div id="elh_request_group_message" class="request_group_message"><div class="ew-table-header-caption"><?php echo $request_group->message->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="message" class="<?php echo $request_group->message->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_group->SortUrl($request_group->message) ?>',2);"><div id="elh_request_group_message" class="request_group_message">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_group->message->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($request_group->message->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_group->message->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_group->uploads->Visible) { // uploads ?>
	<?php if ($request_group->sortUrl($request_group->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $request_group->uploads->headerCellClass() ?>"><div id="elh_request_group_uploads" class="request_group_uploads"><div class="ew-table-header-caption"><?php echo $request_group->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $request_group->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_group->SortUrl($request_group->uploads) ?>',2);"><div id="elh_request_group_uploads" class="request_group_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_group->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($request_group->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_group->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_group->lead_info->Visible) { // lead_info ?>
	<?php if ($request_group->sortUrl($request_group->lead_info) == "") { ?>
		<th data-name="lead_info" class="<?php echo $request_group->lead_info->headerCellClass() ?>"><div id="elh_request_group_lead_info" class="request_group_lead_info"><div class="ew-table-header-caption"><?php echo $request_group->lead_info->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lead_info" class="<?php echo $request_group->lead_info->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_group->SortUrl($request_group->lead_info) ?>',2);"><div id="elh_request_group_lead_info" class="request_group_lead_info">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_group->lead_info->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($request_group->lead_info->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_group->lead_info->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_group->alert->Visible) { // alert ?>
	<?php if ($request_group->sortUrl($request_group->alert) == "") { ?>
		<th data-name="alert" class="<?php echo $request_group->alert->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_request_group_alert" class="request_group_alert"><div class="ew-table-header-caption"><?php echo $request_group->alert->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="alert" class="<?php echo $request_group->alert->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_group->SortUrl($request_group->alert) ?>',2);"><div id="elh_request_group_alert" class="request_group_alert">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_group->alert->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_group->alert->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_group->alert->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_group->type->Visible) { // type ?>
	<?php if ($request_group->sortUrl($request_group->type) == "") { ?>
		<th data-name="type" class="<?php echo $request_group->type->headerCellClass() ?>"><div id="elh_request_group_type" class="request_group_type"><div class="ew-table-header-caption"><?php echo $request_group->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $request_group->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_group->SortUrl($request_group->type) ?>',2);"><div id="elh_request_group_type" class="request_group_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_group->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_group->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_group->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$request_group_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($request_group->ExportAll && $request_group->isExport()) {
	$request_group_list->StopRec = $request_group_list->TotalRecs;
} else {

	// Set the last record to display
	if ($request_group_list->TotalRecs > $request_group_list->StartRec + $request_group_list->DisplayRecs - 1)
		$request_group_list->StopRec = $request_group_list->StartRec + $request_group_list->DisplayRecs - 1;
	else
		$request_group_list->StopRec = $request_group_list->TotalRecs;
}
$request_group_list->RecCnt = $request_group_list->StartRec - 1;
if ($request_group_list->Recordset && !$request_group_list->Recordset->EOF) {
	$request_group_list->Recordset->moveFirst();
	$selectLimit = $request_group_list->UseSelectLimit;
	if (!$selectLimit && $request_group_list->StartRec > 1)
		$request_group_list->Recordset->move($request_group_list->StartRec - 1);
} elseif (!$request_group->AllowAddDeleteRow && $request_group_list->StopRec == 0) {
	$request_group_list->StopRec = $request_group->GridAddRowCount;
}

// Initialize aggregate
$request_group->RowType = ROWTYPE_AGGREGATEINIT;
$request_group->resetAttributes();
$request_group_list->renderRow();
while ($request_group_list->RecCnt < $request_group_list->StopRec) {
	$request_group_list->RecCnt++;
	if ($request_group_list->RecCnt >= $request_group_list->StartRec) {
		$request_group_list->RowCnt++;

		// Set up key count
		$request_group_list->KeyCount = $request_group_list->RowIndex;

		// Init row class and style
		$request_group->resetAttributes();
		$request_group->CssClass = "";
		if ($request_group->isGridAdd()) {
		} else {
			$request_group_list->loadRowValues($request_group_list->Recordset); // Load row values
		}
		$request_group->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$request_group->RowAttrs = array_merge($request_group->RowAttrs, array('data-rowindex'=>$request_group_list->RowCnt, 'id'=>'r' . $request_group_list->RowCnt . '_request_group', 'data-rowtype'=>$request_group->RowType));

		// Render row
		$request_group_list->renderRow();

		// Render list options
		$request_group_list->renderListOptions();
?>
	<tr<?php echo $request_group->rowAttributes() ?>>
<?php

// Render list options (body, left)
$request_group_list->ListOptions->render("body", "left", $request_group_list->RowCnt);
?>
	<?php if ($request_group->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $request_group->reference->cellAttributes() ?>>
<span id="el<?php echo $request_group_list->RowCnt ?>_request_group_reference" class="request_group_reference">
<span<?php echo $request_group->reference->viewAttributes() ?>>
<?php echo $request_group->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_group->message->Visible) { // message ?>
		<td data-name="message"<?php echo $request_group->message->cellAttributes() ?>>
<span id="el<?php echo $request_group_list->RowCnt ?>_request_group_message" class="request_group_message">
<span<?php echo $request_group->message->viewAttributes() ?>>
<?php echo $request_group->message->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_group->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $request_group->uploads->cellAttributes() ?>>
<span id="el<?php echo $request_group_list->RowCnt ?>_request_group_uploads" class="request_group_uploads">
<span>
<?php echo GetFileViewTag($request_group->uploads, $request_group->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($request_group->lead_info->Visible) { // lead_info ?>
		<td data-name="lead_info"<?php echo $request_group->lead_info->cellAttributes() ?>>
<span id="el<?php echo $request_group_list->RowCnt ?>_request_group_lead_info" class="request_group_lead_info">
<span<?php echo $request_group->lead_info->viewAttributes() ?>>
<?php echo $request_group->lead_info->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_group->alert->Visible) { // alert ?>
		<td data-name="alert"<?php echo $request_group->alert->cellAttributes() ?>>
<span id="el<?php echo $request_group_list->RowCnt ?>_request_group_alert" class="request_group_alert">
<span<?php echo $request_group->alert->viewAttributes() ?>>
<?php echo $request_group->alert->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_group->type->Visible) { // type ?>
		<td data-name="type"<?php echo $request_group->type->cellAttributes() ?>>
<span id="el<?php echo $request_group_list->RowCnt ?>_request_group_type" class="request_group_type">
<span<?php echo $request_group->type->viewAttributes() ?>>
<?php echo $request_group->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$request_group_list->ListOptions->render("body", "right", $request_group_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$request_group->isGridAdd())
		$request_group_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$request_group->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($request_group_list->Recordset)
	$request_group_list->Recordset->Close();
?>
<?php if (!$request_group->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$request_group->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($request_group_list->Pager)) $request_group_list->Pager = new PrevNextPager($request_group_list->StartRec, $request_group_list->DisplayRecs, $request_group_list->TotalRecs, $request_group_list->AutoHidePager) ?>
<?php if ($request_group_list->Pager->RecordCount > 0 && $request_group_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($request_group_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $request_group_list->pageUrl() ?>start=<?php echo $request_group_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($request_group_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $request_group_list->pageUrl() ?>start=<?php echo $request_group_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $request_group_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($request_group_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $request_group_list->pageUrl() ?>start=<?php echo $request_group_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($request_group_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $request_group_list->pageUrl() ?>start=<?php echo $request_group_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $request_group_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($request_group_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $request_group_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $request_group_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $request_group_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($request_group_list->TotalRecs > 0 && (!$request_group_list->AutoHidePageSizeSelector || $request_group_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="request_group">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($request_group_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($request_group_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($request_group_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($request_group_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($request_group_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($request_group->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $request_group_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($request_group_list->TotalRecs == 0 && !$request_group->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $request_group_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$request_group_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$request_group->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$request_group->isExport()) { ?>
<script>
ew.scrollableTable("gmp_request_group", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$request_group_list->terminate();
?>