<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$request_group_search = new request_group_search();

// Run the page
$request_group_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$request_group_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($request_group_search->IsModal) { ?>
var frequest_groupsearch = currentAdvancedSearchForm = new ew.Form("frequest_groupsearch", "search");
<?php } else { ?>
var frequest_groupsearch = currentForm = new ew.Form("frequest_groupsearch", "search");
<?php } ?>

// Form_CustomValidate event
frequest_groupsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequest_groupsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequest_groupsearch.lists["x_type"] = <?php echo $request_group_search->type->Lookup->toClientList() ?>;
frequest_groupsearch.lists["x_type"].options = <?php echo JsonEncode($request_group_search->type->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

frequest_groupsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_reference");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($request_group->reference->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_alert");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($request_group->alert->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $request_group_search->showPageHeader(); ?>
<?php
$request_group_search->showMessage();
?>
<form name="frequest_groupsearch" id="frequest_groupsearch" class="<?php echo $request_group_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($request_group_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $request_group_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="request_group">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$request_group_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($request_group->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $request_group_search->LeftColumnClass ?>"><span id="elh_request_group_reference"><?php echo $request_group->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reference" id="z_reference" value="="></span>
		</label>
		<div class="<?php echo $request_group_search->RightColumnClass ?>"><div<?php echo $request_group->reference->cellAttributes() ?>>
			<span id="el_request_group_reference">
<input type="text" data-table="request_group" data-field="x_reference" name="x_reference" id="x_reference" size="30" placeholder="<?php echo HtmlEncode($request_group->reference->getPlaceHolder()) ?>" value="<?php echo $request_group->reference->EditValue ?>"<?php echo $request_group->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_group->message->Visible) { // message ?>
	<div id="r_message" class="form-group row">
		<label for="x_message" class="<?php echo $request_group_search->LeftColumnClass ?>"><span id="elh_request_group_message"><?php echo $request_group->message->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_message" id="z_message" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_group_search->RightColumnClass ?>"><div<?php echo $request_group->message->cellAttributes() ?>>
			<span id="el_request_group_message">
<input type="text" data-table="request_group" data-field="x_message" name="x_message" id="x_message" size="35" placeholder="<?php echo HtmlEncode($request_group->message->getPlaceHolder()) ?>" value="<?php echo $request_group->message->EditValue ?>"<?php echo $request_group->message->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_group->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $request_group_search->LeftColumnClass ?>"><span id="elh_request_group_uploads"><?php echo $request_group->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_group_search->RightColumnClass ?>"><div<?php echo $request_group->uploads->cellAttributes() ?>>
			<span id="el_request_group_uploads">
<input type="text" data-table="request_group" data-field="x_uploads" name="x_uploads" id="x_uploads" placeholder="<?php echo HtmlEncode($request_group->uploads->getPlaceHolder()) ?>" value="<?php echo $request_group->uploads->EditValue ?>"<?php echo $request_group->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_group->lead_info->Visible) { // lead_info ?>
	<div id="r_lead_info" class="form-group row">
		<label for="x_lead_info" class="<?php echo $request_group_search->LeftColumnClass ?>"><span id="elh_request_group_lead_info"><?php echo $request_group->lead_info->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lead_info" id="z_lead_info" value="LIKE"></span>
		</label>
		<div class="<?php echo $request_group_search->RightColumnClass ?>"><div<?php echo $request_group->lead_info->cellAttributes() ?>>
			<span id="el_request_group_lead_info">
<input type="text" data-table="request_group" data-field="x_lead_info" name="x_lead_info" id="x_lead_info" size="30" maxlength="236" placeholder="<?php echo HtmlEncode($request_group->lead_info->getPlaceHolder()) ?>" value="<?php echo $request_group->lead_info->EditValue ?>"<?php echo $request_group->lead_info->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_group->alert->Visible) { // alert ?>
	<div id="r_alert" class="form-group row">
		<label for="x_alert" class="<?php echo $request_group_search->LeftColumnClass ?>"><span id="elh_request_group_alert"><?php echo $request_group->alert->caption() ?></span>
		</label>
		<div class="<?php echo $request_group_search->RightColumnClass ?>"><div<?php echo $request_group->alert->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_alert" id="z_alert" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($request_group->alert->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_request_group_alert">
<input type="text" data-table="request_group" data-field="x_alert" name="x_alert" id="x_alert" placeholder="<?php echo HtmlEncode($request_group->alert->getPlaceHolder()) ?>" value="<?php echo $request_group->alert->EditValue ?>"<?php echo $request_group->alert->editAttributes() ?>>
<?php if (!$request_group->alert->ReadOnly && !$request_group->alert->Disabled && !isset($request_group->alert->EditAttrs["readonly"]) && !isset($request_group->alert->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frequest_groupsearch", "x_alert", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_alert d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_request_group_alert" class="btw1_alert d-none">
<input type="text" data-table="request_group" data-field="x_alert" name="y_alert" id="y_alert" placeholder="<?php echo HtmlEncode($request_group->alert->getPlaceHolder()) ?>" value="<?php echo $request_group->alert->EditValue2 ?>"<?php echo $request_group->alert->editAttributes() ?>>
<?php if (!$request_group->alert->ReadOnly && !$request_group->alert->Disabled && !isset($request_group->alert->EditAttrs["readonly"]) && !isset($request_group->alert->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("frequest_groupsearch", "y_alert", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($request_group->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $request_group_search->LeftColumnClass ?>"><span id="elh_request_group_type"><?php echo $request_group->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $request_group_search->RightColumnClass ?>"><div<?php echo $request_group->type->cellAttributes() ?>>
			<span id="el_request_group_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="request_group" data-field="x_type" data-value-separator="<?php echo $request_group->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $request_group->type->editAttributes() ?>>
		<?php echo $request_group->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$request_group_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $request_group_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$request_group_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$request_group_search->terminate();
?>