<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$request_type_add = new request_type_add();

// Run the page
$request_type_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$request_type_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var frequest_typeadd = currentForm = new ew.Form("frequest_typeadd", "add");

// Validate form
frequest_typeadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($request_type_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $request_type->item->caption(), $request_type->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($request_type_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $request_type->grp->caption(), $request_type->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($request_type_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $request_type->status->caption(), $request_type->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($request_type_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $request_type->operator->caption(), $request_type->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($request_type_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $request_type->datetime->caption(), $request_type->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
frequest_typeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequest_typeadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequest_typeadd.lists["x_grp"] = <?php echo $request_type_add->grp->Lookup->toClientList() ?>;
frequest_typeadd.lists["x_grp"].options = <?php echo JsonEncode($request_type_add->grp->lookupOptions()) ?>;
frequest_typeadd.lists["x_status"] = <?php echo $request_type_add->status->Lookup->toClientList() ?>;
frequest_typeadd.lists["x_status"].options = <?php echo JsonEncode($request_type_add->status->options(FALSE, TRUE)) ?>;
frequest_typeadd.lists["x_operator"] = <?php echo $request_type_add->operator->Lookup->toClientList() ?>;
frequest_typeadd.lists["x_operator"].options = <?php echo JsonEncode($request_type_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $request_type_add->showPageHeader(); ?>
<?php
$request_type_add->showMessage();
?>
<form name="frequest_typeadd" id="frequest_typeadd" class="<?php echo $request_type_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($request_type_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $request_type_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="request_type">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$request_type_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($request_type->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_request_type_item" for="x_item" class="<?php echo $request_type_add->LeftColumnClass ?>"><?php echo $request_type->item->caption() ?><?php echo ($request_type->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $request_type_add->RightColumnClass ?>"><div<?php echo $request_type->item->cellAttributes() ?>>
<span id="el_request_type_item">
<input type="text" data-table="request_type" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($request_type->item->getPlaceHolder()) ?>" value="<?php echo $request_type->item->EditValue ?>"<?php echo $request_type->item->editAttributes() ?>>
</span>
<?php echo $request_type->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($request_type->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_request_type_grp" for="x_grp" class="<?php echo $request_type_add->LeftColumnClass ?>"><?php echo $request_type->grp->caption() ?><?php echo ($request_type->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $request_type_add->RightColumnClass ?>"><div<?php echo $request_type->grp->cellAttributes() ?>>
<span id="el_request_type_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="request_type" data-field="x_grp" data-value-separator="<?php echo $request_type->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $request_type->grp->editAttributes() ?>>
		<?php echo $request_type->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $request_type->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $request_type->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($request_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_request_type_status" for="x_status" class="<?php echo $request_type_add->LeftColumnClass ?>"><?php echo $request_type->status->caption() ?><?php echo ($request_type->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $request_type_add->RightColumnClass ?>"><div<?php echo $request_type->status->cellAttributes() ?>>
<span id="el_request_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="request_type" data-field="x_status" data-value-separator="<?php echo $request_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $request_type->status->editAttributes() ?>>
		<?php echo $request_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $request_type->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$request_type_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $request_type_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $request_type_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$request_type_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$request_type_add->terminate();
?>