<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$request_type_list = new request_type_list();

// Run the page
$request_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$request_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$request_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var frequest_typelist = currentForm = new ew.Form("frequest_typelist", "list");
frequest_typelist.formKeyCountName = '<?php echo $request_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
frequest_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequest_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequest_typelist.lists["x_grp"] = <?php echo $request_type_list->grp->Lookup->toClientList() ?>;
frequest_typelist.lists["x_grp"].options = <?php echo JsonEncode($request_type_list->grp->lookupOptions()) ?>;
frequest_typelist.lists["x_status"] = <?php echo $request_type_list->status->Lookup->toClientList() ?>;
frequest_typelist.lists["x_status"].options = <?php echo JsonEncode($request_type_list->status->options(FALSE, TRUE)) ?>;
frequest_typelist.lists["x_operator"] = <?php echo $request_type_list->operator->Lookup->toClientList() ?>;
frequest_typelist.lists["x_operator"].options = <?php echo JsonEncode($request_type_list->operator->lookupOptions()) ?>;

// Form object for search
var frequest_typelistsrch = currentSearchForm = new ew.Form("frequest_typelistsrch");

// Filters
frequest_typelistsrch.filterList = <?php echo $request_type_list->getFilterList() ?>;

// Init search panel as collapsed
frequest_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$request_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($request_type_list->TotalRecs > 0 && $request_type_list->ExportOptions->visible()) { ?>
<?php $request_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($request_type_list->ImportOptions->visible()) { ?>
<?php $request_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($request_type_list->SearchOptions->visible()) { ?>
<?php $request_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($request_type_list->FilterOptions->visible()) { ?>
<?php $request_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$request_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$request_type->isExport() && !$request_type->CurrentAction) { ?>
<form name="frequest_typelistsrch" id="frequest_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($request_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="frequest_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="request_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($request_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($request_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $request_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($request_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($request_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($request_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($request_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $request_type_list->showPageHeader(); ?>
<?php
$request_type_list->showMessage();
?>
<?php if ($request_type_list->TotalRecs > 0 || $request_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($request_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> request_type">
<?php if (!$request_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$request_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($request_type_list->Pager)) $request_type_list->Pager = new PrevNextPager($request_type_list->StartRec, $request_type_list->DisplayRecs, $request_type_list->TotalRecs, $request_type_list->AutoHidePager) ?>
<?php if ($request_type_list->Pager->RecordCount > 0 && $request_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($request_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $request_type_list->pageUrl() ?>start=<?php echo $request_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($request_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $request_type_list->pageUrl() ?>start=<?php echo $request_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $request_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($request_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $request_type_list->pageUrl() ?>start=<?php echo $request_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($request_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $request_type_list->pageUrl() ?>start=<?php echo $request_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $request_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($request_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $request_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $request_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $request_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($request_type_list->TotalRecs > 0 && (!$request_type_list->AutoHidePageSizeSelector || $request_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="request_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($request_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($request_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($request_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($request_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($request_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($request_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $request_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="frequest_typelist" id="frequest_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($request_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $request_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="request_type">
<div id="gmp_request_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($request_type_list->TotalRecs > 0 || $request_type->isGridEdit()) { ?>
<table id="tbl_request_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$request_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$request_type_list->renderListOptions();

// Render list options (header, left)
$request_type_list->ListOptions->render("header", "left");
?>
<?php if ($request_type->id->Visible) { // id ?>
	<?php if ($request_type->sortUrl($request_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $request_type->id->headerCellClass() ?>"><div id="elh_request_type_id" class="request_type_id"><div class="ew-table-header-caption"><?php echo $request_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $request_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_type->SortUrl($request_type->id) ?>',2);"><div id="elh_request_type_id" class="request_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_type->item->Visible) { // item ?>
	<?php if ($request_type->sortUrl($request_type->item) == "") { ?>
		<th data-name="item" class="<?php echo $request_type->item->headerCellClass() ?>"><div id="elh_request_type_item" class="request_type_item"><div class="ew-table-header-caption"><?php echo $request_type->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $request_type->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_type->SortUrl($request_type->item) ?>',2);"><div id="elh_request_type_item" class="request_type_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_type->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($request_type->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_type->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_type->grp->Visible) { // grp ?>
	<?php if ($request_type->sortUrl($request_type->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $request_type->grp->headerCellClass() ?>"><div id="elh_request_type_grp" class="request_type_grp"><div class="ew-table-header-caption"><?php echo $request_type->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $request_type->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_type->SortUrl($request_type->grp) ?>',2);"><div id="elh_request_type_grp" class="request_type_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_type->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_type->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_type->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_type->status->Visible) { // status ?>
	<?php if ($request_type->sortUrl($request_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $request_type->status->headerCellClass() ?>"><div id="elh_request_type_status" class="request_type_status"><div class="ew-table-header-caption"><?php echo $request_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $request_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_type->SortUrl($request_type->status) ?>',2);"><div id="elh_request_type_status" class="request_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_type->operator->Visible) { // operator ?>
	<?php if ($request_type->sortUrl($request_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $request_type->operator->headerCellClass() ?>"><div id="elh_request_type_operator" class="request_type_operator"><div class="ew-table-header-caption"><?php echo $request_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $request_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_type->SortUrl($request_type->operator) ?>',2);"><div id="elh_request_type_operator" class="request_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($request_type->datetime->Visible) { // datetime ?>
	<?php if ($request_type->sortUrl($request_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $request_type->datetime->headerCellClass() ?>"><div id="elh_request_type_datetime" class="request_type_datetime"><div class="ew-table-header-caption"><?php echo $request_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $request_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $request_type->SortUrl($request_type->datetime) ?>',2);"><div id="elh_request_type_datetime" class="request_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $request_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($request_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($request_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$request_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($request_type->ExportAll && $request_type->isExport()) {
	$request_type_list->StopRec = $request_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($request_type_list->TotalRecs > $request_type_list->StartRec + $request_type_list->DisplayRecs - 1)
		$request_type_list->StopRec = $request_type_list->StartRec + $request_type_list->DisplayRecs - 1;
	else
		$request_type_list->StopRec = $request_type_list->TotalRecs;
}
$request_type_list->RecCnt = $request_type_list->StartRec - 1;
if ($request_type_list->Recordset && !$request_type_list->Recordset->EOF) {
	$request_type_list->Recordset->moveFirst();
	$selectLimit = $request_type_list->UseSelectLimit;
	if (!$selectLimit && $request_type_list->StartRec > 1)
		$request_type_list->Recordset->move($request_type_list->StartRec - 1);
} elseif (!$request_type->AllowAddDeleteRow && $request_type_list->StopRec == 0) {
	$request_type_list->StopRec = $request_type->GridAddRowCount;
}

// Initialize aggregate
$request_type->RowType = ROWTYPE_AGGREGATEINIT;
$request_type->resetAttributes();
$request_type_list->renderRow();
while ($request_type_list->RecCnt < $request_type_list->StopRec) {
	$request_type_list->RecCnt++;
	if ($request_type_list->RecCnt >= $request_type_list->StartRec) {
		$request_type_list->RowCnt++;

		// Set up key count
		$request_type_list->KeyCount = $request_type_list->RowIndex;

		// Init row class and style
		$request_type->resetAttributes();
		$request_type->CssClass = "";
		if ($request_type->isGridAdd()) {
		} else {
			$request_type_list->loadRowValues($request_type_list->Recordset); // Load row values
		}
		$request_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$request_type->RowAttrs = array_merge($request_type->RowAttrs, array('data-rowindex'=>$request_type_list->RowCnt, 'id'=>'r' . $request_type_list->RowCnt . '_request_type', 'data-rowtype'=>$request_type->RowType));

		// Render row
		$request_type_list->renderRow();

		// Render list options
		$request_type_list->renderListOptions();
?>
	<tr<?php echo $request_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$request_type_list->ListOptions->render("body", "left", $request_type_list->RowCnt);
?>
	<?php if ($request_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $request_type->id->cellAttributes() ?>>
<span id="el<?php echo $request_type_list->RowCnt ?>_request_type_id" class="request_type_id">
<span<?php echo $request_type->id->viewAttributes() ?>>
<?php echo $request_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_type->item->Visible) { // item ?>
		<td data-name="item"<?php echo $request_type->item->cellAttributes() ?>>
<span id="el<?php echo $request_type_list->RowCnt ?>_request_type_item" class="request_type_item">
<span<?php echo $request_type->item->viewAttributes() ?>>
<?php echo $request_type->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_type->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $request_type->grp->cellAttributes() ?>>
<span id="el<?php echo $request_type_list->RowCnt ?>_request_type_grp" class="request_type_grp">
<span<?php echo $request_type->grp->viewAttributes() ?>>
<?php echo $request_type->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $request_type->status->cellAttributes() ?>>
<span id="el<?php echo $request_type_list->RowCnt ?>_request_type_status" class="request_type_status">
<span<?php echo $request_type->status->viewAttributes() ?>>
<?php echo $request_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $request_type->operator->cellAttributes() ?>>
<span id="el<?php echo $request_type_list->RowCnt ?>_request_type_operator" class="request_type_operator">
<span<?php echo $request_type->operator->viewAttributes() ?>>
<?php echo $request_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($request_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $request_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $request_type_list->RowCnt ?>_request_type_datetime" class="request_type_datetime">
<span<?php echo $request_type->datetime->viewAttributes() ?>>
<?php echo $request_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$request_type_list->ListOptions->render("body", "right", $request_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$request_type->isGridAdd())
		$request_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$request_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($request_type_list->Recordset)
	$request_type_list->Recordset->Close();
?>
<?php if (!$request_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$request_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($request_type_list->Pager)) $request_type_list->Pager = new PrevNextPager($request_type_list->StartRec, $request_type_list->DisplayRecs, $request_type_list->TotalRecs, $request_type_list->AutoHidePager) ?>
<?php if ($request_type_list->Pager->RecordCount > 0 && $request_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($request_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $request_type_list->pageUrl() ?>start=<?php echo $request_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($request_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $request_type_list->pageUrl() ?>start=<?php echo $request_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $request_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($request_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $request_type_list->pageUrl() ?>start=<?php echo $request_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($request_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $request_type_list->pageUrl() ?>start=<?php echo $request_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $request_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($request_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $request_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $request_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $request_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($request_type_list->TotalRecs > 0 && (!$request_type_list->AutoHidePageSizeSelector || $request_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="request_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($request_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($request_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($request_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($request_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($request_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($request_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $request_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($request_type_list->TotalRecs == 0 && !$request_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $request_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$request_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$request_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$request_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_request_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$request_type_list->terminate();
?>