<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$required_material_compiled_live_list = new required_material_compiled_live_list();

// Run the page
$required_material_compiled_live_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$required_material_compiled_live_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$required_material_compiled_live->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var frequired_material_compiled_livelist = currentForm = new ew.Form("frequired_material_compiled_livelist", "list");
frequired_material_compiled_livelist.formKeyCountName = '<?php echo $required_material_compiled_live_list->FormKeyCountName ?>';

// Form_CustomValidate event
frequired_material_compiled_livelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequired_material_compiled_livelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequired_material_compiled_livelist.lists["x_week"] = <?php echo $required_material_compiled_live_list->week->Lookup->toClientList() ?>;
frequired_material_compiled_livelist.lists["x_week"].options = <?php echo JsonEncode($required_material_compiled_live_list->week->lookupOptions()) ?>;
frequired_material_compiled_livelist.lists["x_weaving_works"] = <?php echo $required_material_compiled_live_list->weaving_works->Lookup->toClientList() ?>;
frequired_material_compiled_livelist.lists["x_weaving_works"].options = <?php echo JsonEncode($required_material_compiled_live_list->weaving_works->lookupOptions()) ?>;
frequired_material_compiled_livelist.lists["x_buyer_id"] = <?php echo $required_material_compiled_live_list->buyer_id->Lookup->toClientList() ?>;
frequired_material_compiled_livelist.lists["x_buyer_id"].options = <?php echo JsonEncode($required_material_compiled_live_list->buyer_id->lookupOptions()) ?>;
frequired_material_compiled_livelist.lists["x_req_material_rid"] = <?php echo $required_material_compiled_live_list->req_material_rid->Lookup->toClientList() ?>;
frequired_material_compiled_livelist.lists["x_req_material_rid"].options = <?php echo JsonEncode($required_material_compiled_live_list->req_material_rid->lookupOptions()) ?>;
frequired_material_compiled_livelist.lists["x_req_material_packing"] = <?php echo $required_material_compiled_live_list->req_material_packing->Lookup->toClientList() ?>;
frequired_material_compiled_livelist.lists["x_req_material_packing"].options = <?php echo JsonEncode($required_material_compiled_live_list->req_material_packing->lookupOptions()) ?>;
frequired_material_compiled_livelist.lists["x_unit"] = <?php echo $required_material_compiled_live_list->unit->Lookup->toClientList() ?>;
frequired_material_compiled_livelist.lists["x_unit"].options = <?php echo JsonEncode($required_material_compiled_live_list->unit->lookupOptions()) ?>;
frequired_material_compiled_livelist.lists["x_pp_id"] = <?php echo $required_material_compiled_live_list->pp_id->Lookup->toClientList() ?>;
frequired_material_compiled_livelist.lists["x_pp_id"].options = <?php echo JsonEncode($required_material_compiled_live_list->pp_id->lookupOptions()) ?>;
frequired_material_compiled_livelist.autoSuggests["x_pp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
frequired_material_compiled_livelist.lists["x_req_material_grp"] = <?php echo $required_material_compiled_live_list->req_material_grp->Lookup->toClientList() ?>;
frequired_material_compiled_livelist.lists["x_req_material_grp"].options = <?php echo JsonEncode($required_material_compiled_live_list->req_material_grp->lookupOptions()) ?>;

// Form object for search
var frequired_material_compiled_livelistsrch = currentSearchForm = new ew.Form("frequired_material_compiled_livelistsrch");

// Validate function for search
frequired_material_compiled_livelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($required_material_compiled_live->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
frequired_material_compiled_livelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequired_material_compiled_livelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequired_material_compiled_livelistsrch.lists["x_week"] = <?php echo $required_material_compiled_live_list->week->Lookup->toClientList() ?>;
frequired_material_compiled_livelistsrch.lists["x_week"].options = <?php echo JsonEncode($required_material_compiled_live_list->week->lookupOptions()) ?>;
frequired_material_compiled_livelistsrch.lists["x_weaving_works"] = <?php echo $required_material_compiled_live_list->weaving_works->Lookup->toClientList() ?>;
frequired_material_compiled_livelistsrch.lists["x_weaving_works"].options = <?php echo JsonEncode($required_material_compiled_live_list->weaving_works->lookupOptions()) ?>;
frequired_material_compiled_livelistsrch.lists["x_buyer_id"] = <?php echo $required_material_compiled_live_list->buyer_id->Lookup->toClientList() ?>;
frequired_material_compiled_livelistsrch.lists["x_buyer_id"].options = <?php echo JsonEncode($required_material_compiled_live_list->buyer_id->lookupOptions()) ?>;
frequired_material_compiled_livelistsrch.lists["x_req_material_rid"] = <?php echo $required_material_compiled_live_list->req_material_rid->Lookup->toClientList() ?>;
frequired_material_compiled_livelistsrch.lists["x_req_material_rid"].options = <?php echo JsonEncode($required_material_compiled_live_list->req_material_rid->lookupOptions()) ?>;
frequired_material_compiled_livelistsrch.lists["x_req_material_packing"] = <?php echo $required_material_compiled_live_list->req_material_packing->Lookup->toClientList() ?>;
frequired_material_compiled_livelistsrch.lists["x_req_material_packing"].options = <?php echo JsonEncode($required_material_compiled_live_list->req_material_packing->lookupOptions()) ?>;
frequired_material_compiled_livelistsrch.lists["x_req_material_grp"] = <?php echo $required_material_compiled_live_list->req_material_grp->Lookup->toClientList() ?>;
frequired_material_compiled_livelistsrch.lists["x_req_material_grp"].options = <?php echo JsonEncode($required_material_compiled_live_list->req_material_grp->lookupOptions()) ?>;

// Filters
frequired_material_compiled_livelistsrch.filterList = <?php echo $required_material_compiled_live_list->getFilterList() ?>;

// Init search panel as collapsed
frequired_material_compiled_livelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$required_material_compiled_live->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($required_material_compiled_live_list->TotalRecs > 0 && $required_material_compiled_live_list->ExportOptions->visible()) { ?>
<?php $required_material_compiled_live_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($required_material_compiled_live_list->ImportOptions->visible()) { ?>
<?php $required_material_compiled_live_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($required_material_compiled_live_list->SearchOptions->visible()) { ?>
<?php $required_material_compiled_live_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($required_material_compiled_live_list->FilterOptions->visible()) { ?>
<?php $required_material_compiled_live_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$required_material_compiled_live_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$required_material_compiled_live->isExport() && !$required_material_compiled_live->CurrentAction) { ?>
<form name="frequired_material_compiled_livelistsrch" id="frequired_material_compiled_livelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($required_material_compiled_live_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="frequired_material_compiled_livelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="required_material_compiled_live">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$required_material_compiled_live_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$required_material_compiled_live->RowType = ROWTYPE_SEARCH;

// Render row
$required_material_compiled_live->resetAttributes();
$required_material_compiled_live_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($required_material_compiled_live->week->Visible) { // week ?>
	<div id="xsc_week" class="ew-cell form-group">
		<label for="x_week" class="ew-search-caption ew-label"><?php echo $required_material_compiled_live->week->caption() ?></label>
		<span class="ew-search-operator"><select name="z_week" id="z_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($required_material_compiled_live->week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled_live" data-field="x_week" data-value-separator="<?php echo $required_material_compiled_live->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $required_material_compiled_live->week->editAttributes() ?>>
		<?php echo $required_material_compiled_live->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $required_material_compiled_live->week->Lookup->getParamTag("p_x_week") ?>
</span>
		<span class="ew-search-cond btw1_week style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_week style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled_live" data-field="x_week" data-value-separator="<?php echo $required_material_compiled_live->week->displayValueSeparatorAttribute() ?>" id="y_week" name="y_week"<?php echo $required_material_compiled_live->week->editAttributes() ?>>
		<?php echo $required_material_compiled_live->week->selectOptionListHtml("y_week") ?>
	</select>
</div>
<?php echo $required_material_compiled_live->week->Lookup->getParamTag("p_y_week") ?>
</span>
	</div>
<?php } ?>
<?php if ($required_material_compiled_live->weaving_works->Visible) { // weaving_works ?>
	<div id="xsc_weaving_works" class="ew-cell form-group">
		<label for="x_weaving_works" class="ew-search-caption ew-label"><?php echo $required_material_compiled_live->weaving_works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled_live" data-field="x_weaving_works" data-value-separator="<?php echo $required_material_compiled_live->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $required_material_compiled_live->weaving_works->editAttributes() ?>>
		<?php echo $required_material_compiled_live->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $required_material_compiled_live->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
	</div>
<?php } ?>
<?php if ($required_material_compiled_live->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $required_material_compiled_live->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($required_material_compiled_live->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="required_material_compiled_live" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($required_material_compiled_live->po->getPlaceHolder()) ?>" value="<?php echo $required_material_compiled_live->po->EditValue ?>"<?php echo $required_material_compiled_live->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="required_material_compiled_live" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($required_material_compiled_live->po->getPlaceHolder()) ?>" value="<?php echo $required_material_compiled_live->po->EditValue2 ?>"<?php echo $required_material_compiled_live->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($required_material_compiled_live->buyer_id->Visible) { // buyer_id ?>
	<div id="xsc_buyer_id" class="ew-cell form-group">
		<label for="x_buyer_id" class="ew-search-caption ew-label"><?php echo $required_material_compiled_live->buyer_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled_live" data-field="x_buyer_id" data-value-separator="<?php echo $required_material_compiled_live->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $required_material_compiled_live->buyer_id->editAttributes() ?>>
		<?php echo $required_material_compiled_live->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $required_material_compiled_live->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($required_material_compiled_live->req_material_rid->Visible) { // req_material_rid ?>
	<div id="xsc_req_material_rid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $required_material_compiled_live->req_material_rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="required_material_compiled_live" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" size="30" placeholder="<?php echo HtmlEncode($required_material_compiled_live->req_material_rid->getPlaceHolder()) ?>" value="<?php echo $required_material_compiled_live->req_material_rid->EditValue ?>"<?php echo $required_material_compiled_live->req_material_rid->editAttributes() ?>>
<?php echo $required_material_compiled_live->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
	</div>
<?php } ?>
<?php if ($required_material_compiled_live->req_material_packing->Visible) { // req_material_packing ?>
	<div id="xsc_req_material_packing" class="ew-cell form-group">
		<label for="x_req_material_packing" class="ew-search-caption ew-label"><?php echo $required_material_compiled_live->req_material_packing->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled_live" data-field="x_req_material_packing" data-value-separator="<?php echo $required_material_compiled_live->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $required_material_compiled_live->req_material_packing->editAttributes() ?>>
		<?php echo $required_material_compiled_live->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $required_material_compiled_live->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($required_material_compiled_live->req_material_grp->Visible) { // req_material_grp ?>
	<div id="xsc_req_material_grp" class="ew-cell form-group">
		<label for="x_req_material_grp" class="ew-search-caption ew-label"><?php echo $required_material_compiled_live->req_material_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_grp" id="z_req_material_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled_live" data-field="x_req_material_grp" data-value-separator="<?php echo $required_material_compiled_live->req_material_grp->displayValueSeparatorAttribute() ?>" id="x_req_material_grp" name="x_req_material_grp"<?php echo $required_material_compiled_live->req_material_grp->editAttributes() ?>>
		<?php echo $required_material_compiled_live->req_material_grp->selectOptionListHtml("x_req_material_grp") ?>
	</select>
</div>
<?php echo $required_material_compiled_live->req_material_grp->Lookup->getParamTag("p_x_req_material_grp") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($required_material_compiled_live_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($required_material_compiled_live_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $required_material_compiled_live_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($required_material_compiled_live_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($required_material_compiled_live_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($required_material_compiled_live_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($required_material_compiled_live_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $required_material_compiled_live_list->showPageHeader(); ?>
<?php
$required_material_compiled_live_list->showMessage();
?>
<?php if ($required_material_compiled_live_list->TotalRecs > 0 || $required_material_compiled_live->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($required_material_compiled_live_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> required_material_compiled_live">
<?php if (!$required_material_compiled_live->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$required_material_compiled_live->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($required_material_compiled_live_list->Pager)) $required_material_compiled_live_list->Pager = new PrevNextPager($required_material_compiled_live_list->StartRec, $required_material_compiled_live_list->DisplayRecs, $required_material_compiled_live_list->TotalRecs, $required_material_compiled_live_list->AutoHidePager) ?>
<?php if ($required_material_compiled_live_list->Pager->RecordCount > 0 && $required_material_compiled_live_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($required_material_compiled_live_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $required_material_compiled_live_list->pageUrl() ?>start=<?php echo $required_material_compiled_live_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($required_material_compiled_live_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $required_material_compiled_live_list->pageUrl() ?>start=<?php echo $required_material_compiled_live_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $required_material_compiled_live_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($required_material_compiled_live_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $required_material_compiled_live_list->pageUrl() ?>start=<?php echo $required_material_compiled_live_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($required_material_compiled_live_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $required_material_compiled_live_list->pageUrl() ?>start=<?php echo $required_material_compiled_live_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $required_material_compiled_live_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($required_material_compiled_live_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $required_material_compiled_live_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $required_material_compiled_live_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $required_material_compiled_live_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($required_material_compiled_live_list->TotalRecs > 0 && (!$required_material_compiled_live_list->AutoHidePageSizeSelector || $required_material_compiled_live_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="required_material_compiled_live">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($required_material_compiled_live_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($required_material_compiled_live_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($required_material_compiled_live_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($required_material_compiled_live_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($required_material_compiled_live_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($required_material_compiled_live->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $required_material_compiled_live_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="frequired_material_compiled_livelist" id="frequired_material_compiled_livelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($required_material_compiled_live_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $required_material_compiled_live_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="required_material_compiled_live">
<div id="gmp_required_material_compiled_live" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($required_material_compiled_live_list->TotalRecs > 0 || $required_material_compiled_live->isGridEdit()) { ?>
<table id="tbl_required_material_compiled_livelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$required_material_compiled_live_list->RowType = ROWTYPE_HEADER;

// Render list options
$required_material_compiled_live_list->renderListOptions();

// Render list options (header, left)
$required_material_compiled_live_list->ListOptions->render("header", "left");
?>
<?php if ($required_material_compiled_live->week->Visible) { // week ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->week) == "") { ?>
		<th data-name="week" class="<?php echo $required_material_compiled_live->week->headerCellClass() ?>"><div id="elh_required_material_compiled_live_week" class="required_material_compiled_live_week"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $required_material_compiled_live->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->week) ?>',2);"><div id="elh_required_material_compiled_live_week" class="required_material_compiled_live_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->weaving_works->Visible) { // weaving_works ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $required_material_compiled_live->weaving_works->headerCellClass() ?>"><div id="elh_required_material_compiled_live_weaving_works" class="required_material_compiled_live_weaving_works"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $required_material_compiled_live->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->weaving_works) ?>',2);"><div id="elh_required_material_compiled_live_weaving_works" class="required_material_compiled_live_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->po->Visible) { // po ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->po) == "") { ?>
		<th data-name="po" class="<?php echo $required_material_compiled_live->po->headerCellClass() ?>"><div id="elh_required_material_compiled_live_po" class="required_material_compiled_live_po"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $required_material_compiled_live->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->po) ?>',2);"><div id="elh_required_material_compiled_live_po" class="required_material_compiled_live_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->buyer_id->Visible) { // buyer_id ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $required_material_compiled_live->buyer_id->headerCellClass() ?>"><div id="elh_required_material_compiled_live_buyer_id" class="required_material_compiled_live_buyer_id"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $required_material_compiled_live->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->buyer_id) ?>',2);"><div id="elh_required_material_compiled_live_buyer_id" class="required_material_compiled_live_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $required_material_compiled_live->req_material_rid->headerCellClass() ?>"><div id="elh_required_material_compiled_live_req_material_rid" class="required_material_compiled_live_req_material_rid"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $required_material_compiled_live->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->req_material_rid) ?>',2);"><div id="elh_required_material_compiled_live_req_material_rid" class="required_material_compiled_live_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->req_material_packing) == "") { ?>
		<th data-name="req_material_packing" class="<?php echo $required_material_compiled_live->req_material_packing->headerCellClass() ?>"><div id="elh_required_material_compiled_live_req_material_packing" class="required_material_compiled_live_req_material_packing"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_packing" class="<?php echo $required_material_compiled_live->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->req_material_packing) ?>',2);"><div id="elh_required_material_compiled_live_req_material_packing" class="required_material_compiled_live_req_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->req_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->req_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $required_material_compiled_live->req_material_qty->headerCellClass() ?>"><div id="elh_required_material_compiled_live_req_material_qty" class="required_material_compiled_live_req_material_qty"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $required_material_compiled_live->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->req_material_qty) ?>',2);"><div id="elh_required_material_compiled_live_req_material_qty" class="required_material_compiled_live_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->stock->Visible) { // stock ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->stock) == "") { ?>
		<th data-name="stock" class="<?php echo $required_material_compiled_live->stock->headerCellClass() ?>"><div id="elh_required_material_compiled_live_stock" class="required_material_compiled_live_stock"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock" class="<?php echo $required_material_compiled_live->stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->stock) ?>',2);"><div id="elh_required_material_compiled_live_stock" class="required_material_compiled_live_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->unit->Visible) { // unit ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $required_material_compiled_live->unit->headerCellClass() ?>"><div id="elh_required_material_compiled_live_unit" class="required_material_compiled_live_unit"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $required_material_compiled_live->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->unit) ?>',2);"><div id="elh_required_material_compiled_live_unit" class="required_material_compiled_live_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->batch_no->Visible) { // batch_no ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $required_material_compiled_live->batch_no->headerCellClass() ?>"><div id="elh_required_material_compiled_live_batch_no" class="required_material_compiled_live_batch_no"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $required_material_compiled_live->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->batch_no) ?>',2);"><div id="elh_required_material_compiled_live_batch_no" class="required_material_compiled_live_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->batch_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->req_batch_no->Visible) { // req_batch_no ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->req_batch_no) == "") { ?>
		<th data-name="req_batch_no" class="<?php echo $required_material_compiled_live->req_batch_no->headerCellClass() ?>"><div id="elh_required_material_compiled_live_req_batch_no" class="required_material_compiled_live_req_batch_no"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_batch_no" class="<?php echo $required_material_compiled_live->req_batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->req_batch_no) ?>',2);"><div id="elh_required_material_compiled_live_req_batch_no" class="required_material_compiled_live_req_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_batch_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->req_batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->req_batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->pp_id->Visible) { // pp_id ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->pp_id) == "") { ?>
		<th data-name="pp_id" class="<?php echo $required_material_compiled_live->pp_id->headerCellClass() ?>"><div id="elh_required_material_compiled_live_pp_id" class="required_material_compiled_live_pp_id"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->pp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_id" class="<?php echo $required_material_compiled_live->pp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->pp_id) ?>',2);"><div id="elh_required_material_compiled_live_pp_id" class="required_material_compiled_live_pp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->pp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->pp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->pp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->level->Visible) { // level ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->level) == "") { ?>
		<th data-name="level" class="<?php echo $required_material_compiled_live->level->headerCellClass() ?>"><div id="elh_required_material_compiled_live_level" class="required_material_compiled_live_level"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="level" class="<?php echo $required_material_compiled_live->level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->level) ?>',2);"><div id="elh_required_material_compiled_live_level" class="required_material_compiled_live_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled_live->req_material_grp->Visible) { // req_material_grp ?>
	<?php if ($required_material_compiled_live->sortUrl($required_material_compiled_live->req_material_grp) == "") { ?>
		<th data-name="req_material_grp" class="<?php echo $required_material_compiled_live->req_material_grp->headerCellClass() ?>"><div id="elh_required_material_compiled_live_req_material_grp" class="required_material_compiled_live_req_material_grp"><div class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_material_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_grp" class="<?php echo $required_material_compiled_live->req_material_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled_live->SortUrl($required_material_compiled_live->req_material_grp) ?>',2);"><div id="elh_required_material_compiled_live_req_material_grp" class="required_material_compiled_live_req_material_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled_live->req_material_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled_live->req_material_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled_live->req_material_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$required_material_compiled_live_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($required_material_compiled_live->ExportAll && $required_material_compiled_live->isExport()) {
	$required_material_compiled_live_list->StopRec = $required_material_compiled_live_list->TotalRecs;
} else {

	// Set the last record to display
	if ($required_material_compiled_live_list->TotalRecs > $required_material_compiled_live_list->StartRec + $required_material_compiled_live_list->DisplayRecs - 1)
		$required_material_compiled_live_list->StopRec = $required_material_compiled_live_list->StartRec + $required_material_compiled_live_list->DisplayRecs - 1;
	else
		$required_material_compiled_live_list->StopRec = $required_material_compiled_live_list->TotalRecs;
}
$required_material_compiled_live_list->RecCnt = $required_material_compiled_live_list->StartRec - 1;
if ($required_material_compiled_live_list->Recordset && !$required_material_compiled_live_list->Recordset->EOF) {
	$required_material_compiled_live_list->Recordset->moveFirst();
	$selectLimit = $required_material_compiled_live_list->UseSelectLimit;
	if (!$selectLimit && $required_material_compiled_live_list->StartRec > 1)
		$required_material_compiled_live_list->Recordset->move($required_material_compiled_live_list->StartRec - 1);
} elseif (!$required_material_compiled_live->AllowAddDeleteRow && $required_material_compiled_live_list->StopRec == 0) {
	$required_material_compiled_live_list->StopRec = $required_material_compiled_live->GridAddRowCount;
}

// Initialize aggregate
$required_material_compiled_live->RowType = ROWTYPE_AGGREGATEINIT;
$required_material_compiled_live->resetAttributes();
$required_material_compiled_live_list->renderRow();
while ($required_material_compiled_live_list->RecCnt < $required_material_compiled_live_list->StopRec) {
	$required_material_compiled_live_list->RecCnt++;
	if ($required_material_compiled_live_list->RecCnt >= $required_material_compiled_live_list->StartRec) {
		$required_material_compiled_live_list->RowCnt++;

		// Set up key count
		$required_material_compiled_live_list->KeyCount = $required_material_compiled_live_list->RowIndex;

		// Init row class and style
		$required_material_compiled_live->resetAttributes();
		$required_material_compiled_live->CssClass = "";
		if ($required_material_compiled_live->isGridAdd()) {
		} else {
			$required_material_compiled_live_list->loadRowValues($required_material_compiled_live_list->Recordset); // Load row values
		}
		$required_material_compiled_live->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$required_material_compiled_live->RowAttrs = array_merge($required_material_compiled_live->RowAttrs, array('data-rowindex'=>$required_material_compiled_live_list->RowCnt, 'id'=>'r' . $required_material_compiled_live_list->RowCnt . '_required_material_compiled_live', 'data-rowtype'=>$required_material_compiled_live->RowType));

		// Render row
		$required_material_compiled_live_list->renderRow();

		// Render list options
		$required_material_compiled_live_list->renderListOptions();
?>
	<tr<?php echo $required_material_compiled_live->rowAttributes() ?>>
<?php

// Render list options (body, left)
$required_material_compiled_live_list->ListOptions->render("body", "left", $required_material_compiled_live_list->RowCnt);
?>
	<?php if ($required_material_compiled_live->week->Visible) { // week ?>
		<td data-name="week"<?php echo $required_material_compiled_live->week->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_week" class="required_material_compiled_live_week">
<span<?php echo $required_material_compiled_live->week->viewAttributes() ?>>
<?php echo $required_material_compiled_live->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $required_material_compiled_live->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_weaving_works" class="required_material_compiled_live_weaving_works">
<span<?php echo $required_material_compiled_live->weaving_works->viewAttributes() ?>>
<?php echo $required_material_compiled_live->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->po->Visible) { // po ?>
		<td data-name="po"<?php echo $required_material_compiled_live->po->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_po" class="required_material_compiled_live_po">
<span<?php echo $required_material_compiled_live->po->viewAttributes() ?>>
<?php if ((!EmptyString($required_material_compiled_live->po->getViewValue())) && $required_material_compiled_live->po->linkAttributes() <> "") { ?>
<a<?php echo $required_material_compiled_live->po->linkAttributes() ?>><?php echo $required_material_compiled_live->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $required_material_compiled_live->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $required_material_compiled_live->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_buyer_id" class="required_material_compiled_live_buyer_id">
<span<?php echo $required_material_compiled_live->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($required_material_compiled_live->buyer_id->getViewValue())) && $required_material_compiled_live->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $required_material_compiled_live->buyer_id->linkAttributes() ?>><?php echo $required_material_compiled_live->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $required_material_compiled_live->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $required_material_compiled_live->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_req_material_rid" class="required_material_compiled_live_req_material_rid">
<span<?php echo $required_material_compiled_live->req_material_rid->viewAttributes() ?>>
<?php if ((!EmptyString($required_material_compiled_live->req_material_rid->getViewValue())) && $required_material_compiled_live->req_material_rid->linkAttributes() <> "") { ?>
<a<?php echo $required_material_compiled_live->req_material_rid->linkAttributes() ?>><?php echo $required_material_compiled_live->req_material_rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $required_material_compiled_live->req_material_rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing"<?php echo $required_material_compiled_live->req_material_packing->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_req_material_packing" class="required_material_compiled_live_req_material_packing">
<span<?php echo $required_material_compiled_live->req_material_packing->viewAttributes() ?>>
<?php echo $required_material_compiled_live->req_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $required_material_compiled_live->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_req_material_qty" class="required_material_compiled_live_req_material_qty">
<span<?php echo $required_material_compiled_live->req_material_qty->viewAttributes() ?>>
<?php echo $required_material_compiled_live->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->stock->Visible) { // stock ?>
		<td data-name="stock"<?php echo $required_material_compiled_live->stock->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_stock" class="required_material_compiled_live_stock">
<span<?php echo $required_material_compiled_live->stock->viewAttributes() ?>>
<?php echo $required_material_compiled_live->stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $required_material_compiled_live->unit->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_unit" class="required_material_compiled_live_unit">
<span<?php echo $required_material_compiled_live->unit->viewAttributes() ?>>
<?php if ((!EmptyString($required_material_compiled_live->unit->getViewValue())) && $required_material_compiled_live->unit->linkAttributes() <> "") { ?>
<a<?php echo $required_material_compiled_live->unit->linkAttributes() ?>><?php echo $required_material_compiled_live->unit->getViewValue() ?></a>
<?php } else { ?>
<?php echo $required_material_compiled_live->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $required_material_compiled_live->batch_no->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_batch_no" class="required_material_compiled_live_batch_no">
<span<?php echo $required_material_compiled_live->batch_no->viewAttributes() ?>>
<?php echo $required_material_compiled_live->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_batch_no->Visible) { // req_batch_no ?>
		<td data-name="req_batch_no"<?php echo $required_material_compiled_live->req_batch_no->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_req_batch_no" class="required_material_compiled_live_req_batch_no">
<span<?php echo $required_material_compiled_live->req_batch_no->viewAttributes() ?>>
<?php echo $required_material_compiled_live->req_batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->pp_id->Visible) { // pp_id ?>
		<td data-name="pp_id"<?php echo $required_material_compiled_live->pp_id->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_pp_id" class="required_material_compiled_live_pp_id">
<span<?php echo $required_material_compiled_live->pp_id->viewAttributes() ?>>
<?php echo $required_material_compiled_live->pp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->level->Visible) { // level ?>
		<td data-name="level"<?php echo $required_material_compiled_live->level->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_level" class="required_material_compiled_live_level">
<span<?php echo $required_material_compiled_live->level->viewAttributes() ?>>
<?php echo $required_material_compiled_live->level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_material_grp->Visible) { // req_material_grp ?>
		<td data-name="req_material_grp"<?php echo $required_material_compiled_live->req_material_grp->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_live_list->RowCnt ?>_required_material_compiled_live_req_material_grp" class="required_material_compiled_live_req_material_grp">
<span<?php echo $required_material_compiled_live->req_material_grp->viewAttributes() ?>>
<?php echo $required_material_compiled_live->req_material_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$required_material_compiled_live_list->ListOptions->render("body", "right", $required_material_compiled_live_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$required_material_compiled_live->isGridAdd())
		$required_material_compiled_live_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$required_material_compiled_live->RowType = ROWTYPE_AGGREGATE;
$required_material_compiled_live->resetAttributes();
$required_material_compiled_live_list->renderRow();
?>
<?php if ($required_material_compiled_live_list->TotalRecs > 0 && !$required_material_compiled_live->isGridAdd() && !$required_material_compiled_live->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$required_material_compiled_live_list->renderListOptions();

// Render list options (footer, left)
$required_material_compiled_live_list->ListOptions->render("footer", "left");
?>
	<?php if ($required_material_compiled_live->week->Visible) { // week ?>
		<td data-name="week" class="<?php echo $required_material_compiled_live->week->footerCellClass() ?>"><span id="elf_required_material_compiled_live_week" class="required_material_compiled_live_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works" class="<?php echo $required_material_compiled_live->weaving_works->footerCellClass() ?>"><span id="elf_required_material_compiled_live_weaving_works" class="required_material_compiled_live_weaving_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $required_material_compiled_live->po->footerCellClass() ?>"><span id="elf_required_material_compiled_live_po" class="required_material_compiled_live_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $required_material_compiled_live->buyer_id->footerCellClass() ?>"><span id="elf_required_material_compiled_live_buyer_id" class="required_material_compiled_live_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid" class="<?php echo $required_material_compiled_live->req_material_rid->footerCellClass() ?>"><span id="elf_required_material_compiled_live_req_material_rid" class="required_material_compiled_live_req_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing" class="<?php echo $required_material_compiled_live->req_material_packing->footerCellClass() ?>"><span id="elf_required_material_compiled_live_req_material_packing" class="required_material_compiled_live_req_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty" class="<?php echo $required_material_compiled_live->req_material_qty->footerCellClass() ?>"><span id="elf_required_material_compiled_live_req_material_qty" class="required_material_compiled_live_req_material_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $required_material_compiled_live->req_material_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->stock->Visible) { // stock ?>
		<td data-name="stock" class="<?php echo $required_material_compiled_live->stock->footerCellClass() ?>"><span id="elf_required_material_compiled_live_stock" class="required_material_compiled_live_stock">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->unit->Visible) { // unit ?>
		<td data-name="unit" class="<?php echo $required_material_compiled_live->unit->footerCellClass() ?>"><span id="elf_required_material_compiled_live_unit" class="required_material_compiled_live_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $required_material_compiled_live->batch_no->footerCellClass() ?>"><span id="elf_required_material_compiled_live_batch_no" class="required_material_compiled_live_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_batch_no->Visible) { // req_batch_no ?>
		<td data-name="req_batch_no" class="<?php echo $required_material_compiled_live->req_batch_no->footerCellClass() ?>"><span id="elf_required_material_compiled_live_req_batch_no" class="required_material_compiled_live_req_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->pp_id->Visible) { // pp_id ?>
		<td data-name="pp_id" class="<?php echo $required_material_compiled_live->pp_id->footerCellClass() ?>"><span id="elf_required_material_compiled_live_pp_id" class="required_material_compiled_live_pp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->level->Visible) { // level ?>
		<td data-name="level" class="<?php echo $required_material_compiled_live->level->footerCellClass() ?>"><span id="elf_required_material_compiled_live_level" class="required_material_compiled_live_level">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled_live->req_material_grp->Visible) { // req_material_grp ?>
		<td data-name="req_material_grp" class="<?php echo $required_material_compiled_live->req_material_grp->footerCellClass() ?>"><span id="elf_required_material_compiled_live_req_material_grp" class="required_material_compiled_live_req_material_grp">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$required_material_compiled_live_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$required_material_compiled_live->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($required_material_compiled_live_list->Recordset)
	$required_material_compiled_live_list->Recordset->Close();
?>
<?php if (!$required_material_compiled_live->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$required_material_compiled_live->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($required_material_compiled_live_list->Pager)) $required_material_compiled_live_list->Pager = new PrevNextPager($required_material_compiled_live_list->StartRec, $required_material_compiled_live_list->DisplayRecs, $required_material_compiled_live_list->TotalRecs, $required_material_compiled_live_list->AutoHidePager) ?>
<?php if ($required_material_compiled_live_list->Pager->RecordCount > 0 && $required_material_compiled_live_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($required_material_compiled_live_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $required_material_compiled_live_list->pageUrl() ?>start=<?php echo $required_material_compiled_live_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($required_material_compiled_live_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $required_material_compiled_live_list->pageUrl() ?>start=<?php echo $required_material_compiled_live_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $required_material_compiled_live_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($required_material_compiled_live_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $required_material_compiled_live_list->pageUrl() ?>start=<?php echo $required_material_compiled_live_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($required_material_compiled_live_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $required_material_compiled_live_list->pageUrl() ?>start=<?php echo $required_material_compiled_live_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $required_material_compiled_live_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($required_material_compiled_live_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $required_material_compiled_live_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $required_material_compiled_live_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $required_material_compiled_live_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($required_material_compiled_live_list->TotalRecs > 0 && (!$required_material_compiled_live_list->AutoHidePageSizeSelector || $required_material_compiled_live_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="required_material_compiled_live">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($required_material_compiled_live_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($required_material_compiled_live_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($required_material_compiled_live_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($required_material_compiled_live_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($required_material_compiled_live_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($required_material_compiled_live->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $required_material_compiled_live_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($required_material_compiled_live_list->TotalRecs == 0 && !$required_material_compiled_live->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $required_material_compiled_live_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$required_material_compiled_live_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$required_material_compiled_live->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$required_material_compiled_live->isExport()) { ?>
<script>
ew.scrollableTable("gmp_required_material_compiled_live", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$required_material_compiled_live_list->terminate();
?>