<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$required_material_compiled_list = new required_material_compiled_list();

// Run the page
$required_material_compiled_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$required_material_compiled_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$required_material_compiled->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var frequired_material_compiledlist = currentForm = new ew.Form("frequired_material_compiledlist", "list");
frequired_material_compiledlist.formKeyCountName = '<?php echo $required_material_compiled_list->FormKeyCountName ?>';

// Form_CustomValidate event
frequired_material_compiledlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequired_material_compiledlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequired_material_compiledlist.lists["x_week"] = <?php echo $required_material_compiled_list->week->Lookup->toClientList() ?>;
frequired_material_compiledlist.lists["x_week"].options = <?php echo JsonEncode($required_material_compiled_list->week->lookupOptions()) ?>;
frequired_material_compiledlist.lists["x_buyer_id"] = <?php echo $required_material_compiled_list->buyer_id->Lookup->toClientList() ?>;
frequired_material_compiledlist.lists["x_buyer_id"].options = <?php echo JsonEncode($required_material_compiled_list->buyer_id->lookupOptions()) ?>;
frequired_material_compiledlist.lists["x_req_material_rid"] = <?php echo $required_material_compiled_list->req_material_rid->Lookup->toClientList() ?>;
frequired_material_compiledlist.lists["x_req_material_rid"].options = <?php echo JsonEncode($required_material_compiled_list->req_material_rid->lookupOptions()) ?>;
frequired_material_compiledlist.lists["x_req_material_packing"] = <?php echo $required_material_compiled_list->req_material_packing->Lookup->toClientList() ?>;
frequired_material_compiledlist.lists["x_req_material_packing"].options = <?php echo JsonEncode($required_material_compiled_list->req_material_packing->lookupOptions()) ?>;
frequired_material_compiledlist.lists["x_unit"] = <?php echo $required_material_compiled_list->unit->Lookup->toClientList() ?>;
frequired_material_compiledlist.lists["x_unit"].options = <?php echo JsonEncode($required_material_compiled_list->unit->lookupOptions()) ?>;
frequired_material_compiledlist.lists["x_company_id"] = <?php echo $required_material_compiled_list->company_id->Lookup->toClientList() ?>;
frequired_material_compiledlist.lists["x_company_id"].options = <?php echo JsonEncode($required_material_compiled_list->company_id->lookupOptions()) ?>;

// Form object for search
var frequired_material_compiledlistsrch = currentSearchForm = new ew.Form("frequired_material_compiledlistsrch");

// Validate function for search
frequired_material_compiledlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($required_material_compiled->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
frequired_material_compiledlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
frequired_material_compiledlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
frequired_material_compiledlistsrch.lists["x_week"] = <?php echo $required_material_compiled_list->week->Lookup->toClientList() ?>;
frequired_material_compiledlistsrch.lists["x_week"].options = <?php echo JsonEncode($required_material_compiled_list->week->lookupOptions()) ?>;
frequired_material_compiledlistsrch.lists["x_buyer_id"] = <?php echo $required_material_compiled_list->buyer_id->Lookup->toClientList() ?>;
frequired_material_compiledlistsrch.lists["x_buyer_id"].options = <?php echo JsonEncode($required_material_compiled_list->buyer_id->lookupOptions()) ?>;
frequired_material_compiledlistsrch.lists["x_req_material_rid"] = <?php echo $required_material_compiled_list->req_material_rid->Lookup->toClientList() ?>;
frequired_material_compiledlistsrch.lists["x_req_material_rid"].options = <?php echo JsonEncode($required_material_compiled_list->req_material_rid->lookupOptions()) ?>;
frequired_material_compiledlistsrch.lists["x_req_material_packing"] = <?php echo $required_material_compiled_list->req_material_packing->Lookup->toClientList() ?>;
frequired_material_compiledlistsrch.lists["x_req_material_packing"].options = <?php echo JsonEncode($required_material_compiled_list->req_material_packing->lookupOptions()) ?>;

// Filters
frequired_material_compiledlistsrch.filterList = <?php echo $required_material_compiled_list->getFilterList() ?>;

// Init search panel as collapsed
frequired_material_compiledlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$required_material_compiled->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($required_material_compiled_list->TotalRecs > 0 && $required_material_compiled_list->ExportOptions->visible()) { ?>
<?php $required_material_compiled_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($required_material_compiled_list->ImportOptions->visible()) { ?>
<?php $required_material_compiled_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($required_material_compiled_list->SearchOptions->visible()) { ?>
<?php $required_material_compiled_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($required_material_compiled_list->FilterOptions->visible()) { ?>
<?php $required_material_compiled_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$required_material_compiled_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$required_material_compiled->isExport() && !$required_material_compiled->CurrentAction) { ?>
<form name="frequired_material_compiledlistsrch" id="frequired_material_compiledlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($required_material_compiled_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="frequired_material_compiledlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="required_material_compiled">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$required_material_compiled_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$required_material_compiled->RowType = ROWTYPE_SEARCH;

// Render row
$required_material_compiled->resetAttributes();
$required_material_compiled_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($required_material_compiled->week->Visible) { // week ?>
	<div id="xsc_week" class="ew-cell form-group">
		<label for="x_week" class="ew-search-caption ew-label"><?php echo $required_material_compiled->week->caption() ?></label>
		<span class="ew-search-operator"><select name="z_week" id="z_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($required_material_compiled->week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled" data-field="x_week" data-value-separator="<?php echo $required_material_compiled->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $required_material_compiled->week->editAttributes() ?>>
		<?php echo $required_material_compiled->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $required_material_compiled->week->Lookup->getParamTag("p_x_week") ?>
</span>
		<span class="ew-search-cond btw1_week style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_week style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled" data-field="x_week" data-value-separator="<?php echo $required_material_compiled->week->displayValueSeparatorAttribute() ?>" id="y_week" name="y_week"<?php echo $required_material_compiled->week->editAttributes() ?>>
		<?php echo $required_material_compiled->week->selectOptionListHtml("y_week") ?>
	</select>
</div>
<?php echo $required_material_compiled->week->Lookup->getParamTag("p_y_week") ?>
</span>
	</div>
<?php } ?>
<?php if ($required_material_compiled->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $required_material_compiled->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($required_material_compiled->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="required_material_compiled" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($required_material_compiled->po->getPlaceHolder()) ?>" value="<?php echo $required_material_compiled->po->EditValue ?>"<?php echo $required_material_compiled->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="required_material_compiled" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($required_material_compiled->po->getPlaceHolder()) ?>" value="<?php echo $required_material_compiled->po->EditValue2 ?>"<?php echo $required_material_compiled->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($required_material_compiled->buyer_id->Visible) { // buyer_id ?>
	<div id="xsc_buyer_id" class="ew-cell form-group">
		<label for="x_buyer_id" class="ew-search-caption ew-label"><?php echo $required_material_compiled->buyer_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled" data-field="x_buyer_id" data-value-separator="<?php echo $required_material_compiled->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $required_material_compiled->buyer_id->editAttributes() ?>>
		<?php echo $required_material_compiled->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $required_material_compiled->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($required_material_compiled->req_material_rid->Visible) { // req_material_rid ?>
	<div id="xsc_req_material_rid" class="ew-cell form-group">
		<label for="x_req_material_rid" class="ew-search-caption ew-label"><?php echo $required_material_compiled->req_material_rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="required_material_compiled" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" size="30" placeholder="<?php echo HtmlEncode($required_material_compiled->req_material_rid->getPlaceHolder()) ?>" value="<?php echo $required_material_compiled->req_material_rid->EditValue ?>"<?php echo $required_material_compiled->req_material_rid->editAttributes() ?>>
<?php echo $required_material_compiled->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
	</div>
<?php } ?>
<?php if ($required_material_compiled->req_material_packing->Visible) { // req_material_packing ?>
	<div id="xsc_req_material_packing" class="ew-cell form-group">
		<label for="x_req_material_packing" class="ew-search-caption ew-label"><?php echo $required_material_compiled->req_material_packing->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="required_material_compiled" data-field="x_req_material_packing" data-value-separator="<?php echo $required_material_compiled->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $required_material_compiled->req_material_packing->editAttributes() ?>>
		<?php echo $required_material_compiled->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $required_material_compiled->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($required_material_compiled_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($required_material_compiled_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $required_material_compiled_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($required_material_compiled_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($required_material_compiled_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($required_material_compiled_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($required_material_compiled_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $required_material_compiled_list->showPageHeader(); ?>
<?php
$required_material_compiled_list->showMessage();
?>
<?php if ($required_material_compiled_list->TotalRecs > 0 || $required_material_compiled->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($required_material_compiled_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> required_material_compiled">
<?php if (!$required_material_compiled->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$required_material_compiled->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($required_material_compiled_list->Pager)) $required_material_compiled_list->Pager = new PrevNextPager($required_material_compiled_list->StartRec, $required_material_compiled_list->DisplayRecs, $required_material_compiled_list->TotalRecs, $required_material_compiled_list->AutoHidePager) ?>
<?php if ($required_material_compiled_list->Pager->RecordCount > 0 && $required_material_compiled_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($required_material_compiled_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $required_material_compiled_list->pageUrl() ?>start=<?php echo $required_material_compiled_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($required_material_compiled_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $required_material_compiled_list->pageUrl() ?>start=<?php echo $required_material_compiled_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $required_material_compiled_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($required_material_compiled_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $required_material_compiled_list->pageUrl() ?>start=<?php echo $required_material_compiled_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($required_material_compiled_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $required_material_compiled_list->pageUrl() ?>start=<?php echo $required_material_compiled_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $required_material_compiled_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($required_material_compiled_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $required_material_compiled_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $required_material_compiled_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $required_material_compiled_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($required_material_compiled_list->TotalRecs > 0 && (!$required_material_compiled_list->AutoHidePageSizeSelector || $required_material_compiled_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="required_material_compiled">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($required_material_compiled_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($required_material_compiled_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($required_material_compiled_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($required_material_compiled_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($required_material_compiled_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($required_material_compiled->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $required_material_compiled_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="frequired_material_compiledlist" id="frequired_material_compiledlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($required_material_compiled_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $required_material_compiled_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="required_material_compiled">
<div id="gmp_required_material_compiled" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($required_material_compiled_list->TotalRecs > 0 || $required_material_compiled->isGridEdit()) { ?>
<table id="tbl_required_material_compiledlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$required_material_compiled_list->RowType = ROWTYPE_HEADER;

// Render list options
$required_material_compiled_list->renderListOptions();

// Render list options (header, left)
$required_material_compiled_list->ListOptions->render("header", "left");
?>
<?php if ($required_material_compiled->week->Visible) { // week ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->week) == "") { ?>
		<th data-name="week" class="<?php echo $required_material_compiled->week->headerCellClass() ?>"><div id="elh_required_material_compiled_week" class="required_material_compiled_week"><div class="ew-table-header-caption"><?php echo $required_material_compiled->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $required_material_compiled->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->week) ?>',2);"><div id="elh_required_material_compiled_week" class="required_material_compiled_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled->po->Visible) { // po ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->po) == "") { ?>
		<th data-name="po" class="<?php echo $required_material_compiled->po->headerCellClass() ?>"><div id="elh_required_material_compiled_po" class="required_material_compiled_po"><div class="ew-table-header-caption"><?php echo $required_material_compiled->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $required_material_compiled->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->po) ?>',2);"><div id="elh_required_material_compiled_po" class="required_material_compiled_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled->buyer_id->Visible) { // buyer_id ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $required_material_compiled->buyer_id->headerCellClass() ?>"><div id="elh_required_material_compiled_buyer_id" class="required_material_compiled_buyer_id"><div class="ew-table-header-caption"><?php echo $required_material_compiled->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $required_material_compiled->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->buyer_id) ?>',2);"><div id="elh_required_material_compiled_buyer_id" class="required_material_compiled_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $required_material_compiled->req_material_rid->headerCellClass() ?>"><div id="elh_required_material_compiled_req_material_rid" class="required_material_compiled_req_material_rid"><div class="ew-table-header-caption"><?php echo $required_material_compiled->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $required_material_compiled->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->req_material_rid) ?>',2);"><div id="elh_required_material_compiled_req_material_rid" class="required_material_compiled_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->req_material_packing) == "") { ?>
		<th data-name="req_material_packing" class="<?php echo $required_material_compiled->req_material_packing->headerCellClass() ?>"><div id="elh_required_material_compiled_req_material_packing" class="required_material_compiled_req_material_packing"><div class="ew-table-header-caption"><?php echo $required_material_compiled->req_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_packing" class="<?php echo $required_material_compiled->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->req_material_packing) ?>',2);"><div id="elh_required_material_compiled_req_material_packing" class="required_material_compiled_req_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->req_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->req_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $required_material_compiled->req_material_qty->headerCellClass() ?>"><div id="elh_required_material_compiled_req_material_qty" class="required_material_compiled_req_material_qty"><div class="ew-table-header-caption"><?php echo $required_material_compiled->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $required_material_compiled->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->req_material_qty) ?>',2);"><div id="elh_required_material_compiled_req_material_qty" class="required_material_compiled_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->req_material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled->stock->Visible) { // stock ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->stock) == "") { ?>
		<th data-name="stock" class="<?php echo $required_material_compiled->stock->headerCellClass() ?>"><div id="elh_required_material_compiled_stock" class="required_material_compiled_stock"><div class="ew-table-header-caption"><?php echo $required_material_compiled->stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock" class="<?php echo $required_material_compiled->stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->stock) ?>',2);"><div id="elh_required_material_compiled_stock" class="required_material_compiled_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled->unit->Visible) { // unit ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $required_material_compiled->unit->headerCellClass() ?>"><div id="elh_required_material_compiled_unit" class="required_material_compiled_unit"><div class="ew-table-header-caption"><?php echo $required_material_compiled->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $required_material_compiled->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->unit) ?>',2);"><div id="elh_required_material_compiled_unit" class="required_material_compiled_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($required_material_compiled->company_id->Visible) { // company_id ?>
	<?php if ($required_material_compiled->sortUrl($required_material_compiled->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $required_material_compiled->company_id->headerCellClass() ?>"><div id="elh_required_material_compiled_company_id" class="required_material_compiled_company_id"><div class="ew-table-header-caption"><?php echo $required_material_compiled->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $required_material_compiled->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $required_material_compiled->SortUrl($required_material_compiled->company_id) ?>',2);"><div id="elh_required_material_compiled_company_id" class="required_material_compiled_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $required_material_compiled->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($required_material_compiled->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($required_material_compiled->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$required_material_compiled_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($required_material_compiled->ExportAll && $required_material_compiled->isExport()) {
	$required_material_compiled_list->StopRec = $required_material_compiled_list->TotalRecs;
} else {

	// Set the last record to display
	if ($required_material_compiled_list->TotalRecs > $required_material_compiled_list->StartRec + $required_material_compiled_list->DisplayRecs - 1)
		$required_material_compiled_list->StopRec = $required_material_compiled_list->StartRec + $required_material_compiled_list->DisplayRecs - 1;
	else
		$required_material_compiled_list->StopRec = $required_material_compiled_list->TotalRecs;
}
$required_material_compiled_list->RecCnt = $required_material_compiled_list->StartRec - 1;
if ($required_material_compiled_list->Recordset && !$required_material_compiled_list->Recordset->EOF) {
	$required_material_compiled_list->Recordset->moveFirst();
	$selectLimit = $required_material_compiled_list->UseSelectLimit;
	if (!$selectLimit && $required_material_compiled_list->StartRec > 1)
		$required_material_compiled_list->Recordset->move($required_material_compiled_list->StartRec - 1);
} elseif (!$required_material_compiled->AllowAddDeleteRow && $required_material_compiled_list->StopRec == 0) {
	$required_material_compiled_list->StopRec = $required_material_compiled->GridAddRowCount;
}

// Initialize aggregate
$required_material_compiled->RowType = ROWTYPE_AGGREGATEINIT;
$required_material_compiled->resetAttributes();
$required_material_compiled_list->renderRow();
while ($required_material_compiled_list->RecCnt < $required_material_compiled_list->StopRec) {
	$required_material_compiled_list->RecCnt++;
	if ($required_material_compiled_list->RecCnt >= $required_material_compiled_list->StartRec) {
		$required_material_compiled_list->RowCnt++;

		// Set up key count
		$required_material_compiled_list->KeyCount = $required_material_compiled_list->RowIndex;

		// Init row class and style
		$required_material_compiled->resetAttributes();
		$required_material_compiled->CssClass = "";
		if ($required_material_compiled->isGridAdd()) {
		} else {
			$required_material_compiled_list->loadRowValues($required_material_compiled_list->Recordset); // Load row values
		}
		$required_material_compiled->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$required_material_compiled->RowAttrs = array_merge($required_material_compiled->RowAttrs, array('data-rowindex'=>$required_material_compiled_list->RowCnt, 'id'=>'r' . $required_material_compiled_list->RowCnt . '_required_material_compiled', 'data-rowtype'=>$required_material_compiled->RowType));

		// Render row
		$required_material_compiled_list->renderRow();

		// Render list options
		$required_material_compiled_list->renderListOptions();
?>
	<tr<?php echo $required_material_compiled->rowAttributes() ?>>
<?php

// Render list options (body, left)
$required_material_compiled_list->ListOptions->render("body", "left", $required_material_compiled_list->RowCnt);
?>
	<?php if ($required_material_compiled->week->Visible) { // week ?>
		<td data-name="week"<?php echo $required_material_compiled->week->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_week" class="required_material_compiled_week">
<span<?php echo $required_material_compiled->week->viewAttributes() ?>>
<?php echo $required_material_compiled->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled->po->Visible) { // po ?>
		<td data-name="po"<?php echo $required_material_compiled->po->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_po" class="required_material_compiled_po">
<span<?php echo $required_material_compiled->po->viewAttributes() ?>>
<?php if ((!EmptyString($required_material_compiled->po->getViewValue())) && $required_material_compiled->po->linkAttributes() <> "") { ?>
<a<?php echo $required_material_compiled->po->linkAttributes() ?>><?php echo $required_material_compiled->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $required_material_compiled->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $required_material_compiled->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_buyer_id" class="required_material_compiled_buyer_id">
<span<?php echo $required_material_compiled->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($required_material_compiled->buyer_id->getViewValue())) && $required_material_compiled->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $required_material_compiled->buyer_id->linkAttributes() ?>><?php echo $required_material_compiled->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $required_material_compiled->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $required_material_compiled->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_req_material_rid" class="required_material_compiled_req_material_rid">
<span<?php echo $required_material_compiled->req_material_rid->viewAttributes() ?>>
<?php if ((!EmptyString($required_material_compiled->req_material_rid->getViewValue())) && $required_material_compiled->req_material_rid->linkAttributes() <> "") { ?>
<a<?php echo $required_material_compiled->req_material_rid->linkAttributes() ?>><?php echo $required_material_compiled->req_material_rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $required_material_compiled->req_material_rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing"<?php echo $required_material_compiled->req_material_packing->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_req_material_packing" class="required_material_compiled_req_material_packing">
<span<?php echo $required_material_compiled->req_material_packing->viewAttributes() ?>>
<?php echo $required_material_compiled->req_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $required_material_compiled->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_req_material_qty" class="required_material_compiled_req_material_qty">
<span<?php echo $required_material_compiled->req_material_qty->viewAttributes() ?>>
<?php echo $required_material_compiled->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled->stock->Visible) { // stock ?>
		<td data-name="stock"<?php echo $required_material_compiled->stock->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_stock" class="required_material_compiled_stock">
<span<?php echo $required_material_compiled->stock->viewAttributes() ?>>
<?php echo $required_material_compiled->stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $required_material_compiled->unit->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_unit" class="required_material_compiled_unit">
<span<?php echo $required_material_compiled->unit->viewAttributes() ?>>
<?php if ((!EmptyString($required_material_compiled->unit->getViewValue())) && $required_material_compiled->unit->linkAttributes() <> "") { ?>
<a<?php echo $required_material_compiled->unit->linkAttributes() ?>><?php echo $required_material_compiled->unit->getViewValue() ?></a>
<?php } else { ?>
<?php echo $required_material_compiled->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($required_material_compiled->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $required_material_compiled->company_id->cellAttributes() ?>>
<span id="el<?php echo $required_material_compiled_list->RowCnt ?>_required_material_compiled_company_id" class="required_material_compiled_company_id">
<span<?php echo $required_material_compiled->company_id->viewAttributes() ?>>
<?php echo $required_material_compiled->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$required_material_compiled_list->ListOptions->render("body", "right", $required_material_compiled_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$required_material_compiled->isGridAdd())
		$required_material_compiled_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$required_material_compiled->RowType = ROWTYPE_AGGREGATE;
$required_material_compiled->resetAttributes();
$required_material_compiled_list->renderRow();
?>
<?php if ($required_material_compiled_list->TotalRecs > 0 && !$required_material_compiled->isGridAdd() && !$required_material_compiled->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$required_material_compiled_list->renderListOptions();

// Render list options (footer, left)
$required_material_compiled_list->ListOptions->render("footer", "left");
?>
	<?php if ($required_material_compiled->week->Visible) { // week ?>
		<td data-name="week" class="<?php echo $required_material_compiled->week->footerCellClass() ?>"><span id="elf_required_material_compiled_week" class="required_material_compiled_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $required_material_compiled->po->footerCellClass() ?>"><span id="elf_required_material_compiled_po" class="required_material_compiled_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $required_material_compiled->buyer_id->footerCellClass() ?>"><span id="elf_required_material_compiled_buyer_id" class="required_material_compiled_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid" class="<?php echo $required_material_compiled->req_material_rid->footerCellClass() ?>"><span id="elf_required_material_compiled_req_material_rid" class="required_material_compiled_req_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing" class="<?php echo $required_material_compiled->req_material_packing->footerCellClass() ?>"><span id="elf_required_material_compiled_req_material_packing" class="required_material_compiled_req_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty" class="<?php echo $required_material_compiled->req_material_qty->footerCellClass() ?>"><span id="elf_required_material_compiled_req_material_qty" class="required_material_compiled_req_material_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $required_material_compiled->req_material_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled->stock->Visible) { // stock ?>
		<td data-name="stock" class="<?php echo $required_material_compiled->stock->footerCellClass() ?>"><span id="elf_required_material_compiled_stock" class="required_material_compiled_stock">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled->unit->Visible) { // unit ?>
		<td data-name="unit" class="<?php echo $required_material_compiled->unit->footerCellClass() ?>"><span id="elf_required_material_compiled_unit" class="required_material_compiled_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($required_material_compiled->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $required_material_compiled->company_id->footerCellClass() ?>"><span id="elf_required_material_compiled_company_id" class="required_material_compiled_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$required_material_compiled_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$required_material_compiled->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($required_material_compiled_list->Recordset)
	$required_material_compiled_list->Recordset->Close();
?>
<?php if (!$required_material_compiled->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$required_material_compiled->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($required_material_compiled_list->Pager)) $required_material_compiled_list->Pager = new PrevNextPager($required_material_compiled_list->StartRec, $required_material_compiled_list->DisplayRecs, $required_material_compiled_list->TotalRecs, $required_material_compiled_list->AutoHidePager) ?>
<?php if ($required_material_compiled_list->Pager->RecordCount > 0 && $required_material_compiled_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($required_material_compiled_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $required_material_compiled_list->pageUrl() ?>start=<?php echo $required_material_compiled_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($required_material_compiled_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $required_material_compiled_list->pageUrl() ?>start=<?php echo $required_material_compiled_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $required_material_compiled_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($required_material_compiled_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $required_material_compiled_list->pageUrl() ?>start=<?php echo $required_material_compiled_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($required_material_compiled_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $required_material_compiled_list->pageUrl() ?>start=<?php echo $required_material_compiled_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $required_material_compiled_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($required_material_compiled_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $required_material_compiled_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $required_material_compiled_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $required_material_compiled_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($required_material_compiled_list->TotalRecs > 0 && (!$required_material_compiled_list->AutoHidePageSizeSelector || $required_material_compiled_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="required_material_compiled">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($required_material_compiled_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($required_material_compiled_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($required_material_compiled_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($required_material_compiled_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($required_material_compiled_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($required_material_compiled->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $required_material_compiled_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($required_material_compiled_list->TotalRecs == 0 && !$required_material_compiled->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $required_material_compiled_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$required_material_compiled_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$required_material_compiled->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$required_material_compiled->isExport()) { ?>
<script>
ew.scrollableTable("gmp_required_material_compiled", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$required_material_compiled_list->terminate();
?>