<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$s_eval_scheme_list = new s_eval_scheme_list();

// Run the page
$s_eval_scheme_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$s_eval_scheme_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$s_eval_scheme->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fs_eval_schemelist = currentForm = new ew.Form("fs_eval_schemelist", "list");
fs_eval_schemelist.formKeyCountName = '<?php echo $s_eval_scheme_list->FormKeyCountName ?>';

// Form_CustomValidate event
fs_eval_schemelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fs_eval_schemelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fs_eval_schemelist.lists["x_sec"] = <?php echo $s_eval_scheme_list->sec->Lookup->toClientList() ?>;
fs_eval_schemelist.lists["x_sec"].options = <?php echo JsonEncode($s_eval_scheme_list->sec->options(FALSE, TRUE)) ?>;

// Form object for search
var fs_eval_schemelistsrch = currentSearchForm = new ew.Form("fs_eval_schemelistsrch");

// Filters
fs_eval_schemelistsrch.filterList = <?php echo $s_eval_scheme_list->getFilterList() ?>;

// Init search panel as collapsed
fs_eval_schemelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$s_eval_scheme->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($s_eval_scheme_list->TotalRecs > 0 && $s_eval_scheme_list->ExportOptions->visible()) { ?>
<?php $s_eval_scheme_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($s_eval_scheme_list->ImportOptions->visible()) { ?>
<?php $s_eval_scheme_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($s_eval_scheme_list->SearchOptions->visible()) { ?>
<?php $s_eval_scheme_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($s_eval_scheme_list->FilterOptions->visible()) { ?>
<?php $s_eval_scheme_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$s_eval_scheme_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$s_eval_scheme->isExport() && !$s_eval_scheme->CurrentAction) { ?>
<form name="fs_eval_schemelistsrch" id="fs_eval_schemelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($s_eval_scheme_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fs_eval_schemelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="s_eval_scheme">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($s_eval_scheme_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($s_eval_scheme_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $s_eval_scheme_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($s_eval_scheme_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($s_eval_scheme_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($s_eval_scheme_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($s_eval_scheme_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $s_eval_scheme_list->showPageHeader(); ?>
<?php
$s_eval_scheme_list->showMessage();
?>
<?php if ($s_eval_scheme_list->TotalRecs > 0 || $s_eval_scheme->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($s_eval_scheme_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> s_eval_scheme">
<?php if (!$s_eval_scheme->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$s_eval_scheme->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($s_eval_scheme_list->Pager)) $s_eval_scheme_list->Pager = new PrevNextPager($s_eval_scheme_list->StartRec, $s_eval_scheme_list->DisplayRecs, $s_eval_scheme_list->TotalRecs, $s_eval_scheme_list->AutoHidePager) ?>
<?php if ($s_eval_scheme_list->Pager->RecordCount > 0 && $s_eval_scheme_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($s_eval_scheme_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $s_eval_scheme_list->pageUrl() ?>start=<?php echo $s_eval_scheme_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($s_eval_scheme_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $s_eval_scheme_list->pageUrl() ?>start=<?php echo $s_eval_scheme_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $s_eval_scheme_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($s_eval_scheme_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $s_eval_scheme_list->pageUrl() ?>start=<?php echo $s_eval_scheme_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($s_eval_scheme_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $s_eval_scheme_list->pageUrl() ?>start=<?php echo $s_eval_scheme_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $s_eval_scheme_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($s_eval_scheme_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $s_eval_scheme_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $s_eval_scheme_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $s_eval_scheme_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($s_eval_scheme_list->TotalRecs > 0 && (!$s_eval_scheme_list->AutoHidePageSizeSelector || $s_eval_scheme_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="s_eval_scheme">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($s_eval_scheme_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($s_eval_scheme_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($s_eval_scheme_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($s_eval_scheme_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($s_eval_scheme_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($s_eval_scheme->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $s_eval_scheme_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fs_eval_schemelist" id="fs_eval_schemelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($s_eval_scheme_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $s_eval_scheme_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="s_eval_scheme">
<div id="gmp_s_eval_scheme" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($s_eval_scheme_list->TotalRecs > 0 || $s_eval_scheme->isGridEdit()) { ?>
<table id="tbl_s_eval_schemelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$s_eval_scheme_list->RowType = ROWTYPE_HEADER;

// Render list options
$s_eval_scheme_list->renderListOptions();

// Render list options (header, left)
$s_eval_scheme_list->ListOptions->render("header", "left");
?>
<?php if ($s_eval_scheme->id->Visible) { // id ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->id) == "") { ?>
		<th data-name="id" class="<?php echo $s_eval_scheme->id->headerCellClass() ?>"><div id="elh_s_eval_scheme_id" class="s_eval_scheme_id"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $s_eval_scheme->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->id) ?>',2);"><div id="elh_s_eval_scheme_id" class="s_eval_scheme_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->description->Visible) { // description ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->description) == "") { ?>
		<th data-name="description" class="<?php echo $s_eval_scheme->description->headerCellClass() ?>"><div id="elh_s_eval_scheme_description" class="s_eval_scheme_description"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $s_eval_scheme->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->description) ?>',2);"><div id="elh_s_eval_scheme_description" class="s_eval_scheme_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->test_id->Visible) { // test_id ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->test_id) == "") { ?>
		<th data-name="test_id" class="<?php echo $s_eval_scheme->test_id->headerCellClass() ?>"><div id="elh_s_eval_scheme_test_id" class="s_eval_scheme_test_id"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->test_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="test_id" class="<?php echo $s_eval_scheme->test_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->test_id) ?>',2);"><div id="elh_s_eval_scheme_test_id" class="s_eval_scheme_test_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->test_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->test_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->test_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->sec->Visible) { // sec ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->sec) == "") { ?>
		<th data-name="sec" class="<?php echo $s_eval_scheme->sec->headerCellClass() ?>"><div id="elh_s_eval_scheme_sec" class="s_eval_scheme_sec"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->sec->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sec" class="<?php echo $s_eval_scheme->sec->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->sec) ?>',2);"><div id="elh_s_eval_scheme_sec" class="s_eval_scheme_sec">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->sec->caption() ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->sec->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->sec->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->no_start_end->Visible) { // no_start_end ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->no_start_end) == "") { ?>
		<th data-name="no_start_end" class="<?php echo $s_eval_scheme->no_start_end->headerCellClass() ?>"><div id="elh_s_eval_scheme_no_start_end" class="s_eval_scheme_no_start_end"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->no_start_end->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_start_end" class="<?php echo $s_eval_scheme->no_start_end->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->no_start_end) ?>',2);"><div id="elh_s_eval_scheme_no_start_end" class="s_eval_scheme_no_start_end">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->no_start_end->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->no_start_end->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->no_start_end->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->to_attempt->Visible) { // to_attempt ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->to_attempt) == "") { ?>
		<th data-name="to_attempt" class="<?php echo $s_eval_scheme->to_attempt->headerCellClass() ?>"><div id="elh_s_eval_scheme_to_attempt" class="s_eval_scheme_to_attempt"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->to_attempt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_attempt" class="<?php echo $s_eval_scheme->to_attempt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->to_attempt) ?>',2);"><div id="elh_s_eval_scheme_to_attempt" class="s_eval_scheme_to_attempt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->to_attempt->caption() ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->to_attempt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->to_attempt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->marks->Visible) { // marks ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->marks) == "") { ?>
		<th data-name="marks" class="<?php echo $s_eval_scheme->marks->headerCellClass() ?>"><div id="elh_s_eval_scheme_marks" class="s_eval_scheme_marks"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->marks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="marks" class="<?php echo $s_eval_scheme->marks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->marks) ?>',2);"><div id="elh_s_eval_scheme_marks" class="s_eval_scheme_marks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->marks->caption() ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->marks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->marks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->n_marks->Visible) { // n_marks ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->n_marks) == "") { ?>
		<th data-name="n_marks" class="<?php echo $s_eval_scheme->n_marks->headerCellClass() ?>"><div id="elh_s_eval_scheme_n_marks" class="s_eval_scheme_n_marks"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->n_marks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="n_marks" class="<?php echo $s_eval_scheme->n_marks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->n_marks) ?>',2);"><div id="elh_s_eval_scheme_n_marks" class="s_eval_scheme_n_marks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->n_marks->caption() ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->n_marks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->n_marks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->t_marks->Visible) { // t_marks ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->t_marks) == "") { ?>
		<th data-name="t_marks" class="<?php echo $s_eval_scheme->t_marks->headerCellClass() ?>"><div id="elh_s_eval_scheme_t_marks" class="s_eval_scheme_t_marks"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->t_marks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_marks" class="<?php echo $s_eval_scheme->t_marks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->t_marks) ?>',2);"><div id="elh_s_eval_scheme_t_marks" class="s_eval_scheme_t_marks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->t_marks->caption() ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->t_marks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->t_marks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->operator->Visible) { // operator ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $s_eval_scheme->operator->headerCellClass() ?>"><div id="elh_s_eval_scheme_operator" class="s_eval_scheme_operator"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $s_eval_scheme->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->operator) ?>',2);"><div id="elh_s_eval_scheme_operator" class="s_eval_scheme_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($s_eval_scheme->datetime->Visible) { // datetime ?>
	<?php if ($s_eval_scheme->sortUrl($s_eval_scheme->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $s_eval_scheme->datetime->headerCellClass() ?>"><div id="elh_s_eval_scheme_datetime" class="s_eval_scheme_datetime"><div class="ew-table-header-caption"><?php echo $s_eval_scheme->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $s_eval_scheme->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $s_eval_scheme->SortUrl($s_eval_scheme->datetime) ?>',2);"><div id="elh_s_eval_scheme_datetime" class="s_eval_scheme_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $s_eval_scheme->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($s_eval_scheme->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($s_eval_scheme->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$s_eval_scheme_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($s_eval_scheme->ExportAll && $s_eval_scheme->isExport()) {
	$s_eval_scheme_list->StopRec = $s_eval_scheme_list->TotalRecs;
} else {

	// Set the last record to display
	if ($s_eval_scheme_list->TotalRecs > $s_eval_scheme_list->StartRec + $s_eval_scheme_list->DisplayRecs - 1)
		$s_eval_scheme_list->StopRec = $s_eval_scheme_list->StartRec + $s_eval_scheme_list->DisplayRecs - 1;
	else
		$s_eval_scheme_list->StopRec = $s_eval_scheme_list->TotalRecs;
}
$s_eval_scheme_list->RecCnt = $s_eval_scheme_list->StartRec - 1;
if ($s_eval_scheme_list->Recordset && !$s_eval_scheme_list->Recordset->EOF) {
	$s_eval_scheme_list->Recordset->moveFirst();
	$selectLimit = $s_eval_scheme_list->UseSelectLimit;
	if (!$selectLimit && $s_eval_scheme_list->StartRec > 1)
		$s_eval_scheme_list->Recordset->move($s_eval_scheme_list->StartRec - 1);
} elseif (!$s_eval_scheme->AllowAddDeleteRow && $s_eval_scheme_list->StopRec == 0) {
	$s_eval_scheme_list->StopRec = $s_eval_scheme->GridAddRowCount;
}

// Initialize aggregate
$s_eval_scheme->RowType = ROWTYPE_AGGREGATEINIT;
$s_eval_scheme->resetAttributes();
$s_eval_scheme_list->renderRow();
while ($s_eval_scheme_list->RecCnt < $s_eval_scheme_list->StopRec) {
	$s_eval_scheme_list->RecCnt++;
	if ($s_eval_scheme_list->RecCnt >= $s_eval_scheme_list->StartRec) {
		$s_eval_scheme_list->RowCnt++;

		// Set up key count
		$s_eval_scheme_list->KeyCount = $s_eval_scheme_list->RowIndex;

		// Init row class and style
		$s_eval_scheme->resetAttributes();
		$s_eval_scheme->CssClass = "";
		if ($s_eval_scheme->isGridAdd()) {
		} else {
			$s_eval_scheme_list->loadRowValues($s_eval_scheme_list->Recordset); // Load row values
		}
		$s_eval_scheme->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$s_eval_scheme->RowAttrs = array_merge($s_eval_scheme->RowAttrs, array('data-rowindex'=>$s_eval_scheme_list->RowCnt, 'id'=>'r' . $s_eval_scheme_list->RowCnt . '_s_eval_scheme', 'data-rowtype'=>$s_eval_scheme->RowType));

		// Render row
		$s_eval_scheme_list->renderRow();

		// Render list options
		$s_eval_scheme_list->renderListOptions();
?>
	<tr<?php echo $s_eval_scheme->rowAttributes() ?>>
<?php

// Render list options (body, left)
$s_eval_scheme_list->ListOptions->render("body", "left", $s_eval_scheme_list->RowCnt);
?>
	<?php if ($s_eval_scheme->id->Visible) { // id ?>
		<td data-name="id"<?php echo $s_eval_scheme->id->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_id" class="s_eval_scheme_id">
<span<?php echo $s_eval_scheme->id->viewAttributes() ?>>
<?php echo $s_eval_scheme->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->description->Visible) { // description ?>
		<td data-name="description"<?php echo $s_eval_scheme->description->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_description" class="s_eval_scheme_description">
<span<?php echo $s_eval_scheme->description->viewAttributes() ?>>
<?php echo $s_eval_scheme->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->test_id->Visible) { // test_id ?>
		<td data-name="test_id"<?php echo $s_eval_scheme->test_id->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_test_id" class="s_eval_scheme_test_id">
<span<?php echo $s_eval_scheme->test_id->viewAttributes() ?>>
<?php echo $s_eval_scheme->test_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->sec->Visible) { // sec ?>
		<td data-name="sec"<?php echo $s_eval_scheme->sec->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_sec" class="s_eval_scheme_sec">
<span<?php echo $s_eval_scheme->sec->viewAttributes() ?>>
<?php echo $s_eval_scheme->sec->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->no_start_end->Visible) { // no_start_end ?>
		<td data-name="no_start_end"<?php echo $s_eval_scheme->no_start_end->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_no_start_end" class="s_eval_scheme_no_start_end">
<span<?php echo $s_eval_scheme->no_start_end->viewAttributes() ?>>
<?php echo $s_eval_scheme->no_start_end->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->to_attempt->Visible) { // to_attempt ?>
		<td data-name="to_attempt"<?php echo $s_eval_scheme->to_attempt->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_to_attempt" class="s_eval_scheme_to_attempt">
<span<?php echo $s_eval_scheme->to_attempt->viewAttributes() ?>>
<?php echo $s_eval_scheme->to_attempt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->marks->Visible) { // marks ?>
		<td data-name="marks"<?php echo $s_eval_scheme->marks->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_marks" class="s_eval_scheme_marks">
<span<?php echo $s_eval_scheme->marks->viewAttributes() ?>>
<?php echo $s_eval_scheme->marks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->n_marks->Visible) { // n_marks ?>
		<td data-name="n_marks"<?php echo $s_eval_scheme->n_marks->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_n_marks" class="s_eval_scheme_n_marks">
<span<?php echo $s_eval_scheme->n_marks->viewAttributes() ?>>
<?php echo $s_eval_scheme->n_marks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->t_marks->Visible) { // t_marks ?>
		<td data-name="t_marks"<?php echo $s_eval_scheme->t_marks->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_t_marks" class="s_eval_scheme_t_marks">
<span<?php echo $s_eval_scheme->t_marks->viewAttributes() ?>>
<?php echo $s_eval_scheme->t_marks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $s_eval_scheme->operator->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_operator" class="s_eval_scheme_operator">
<span<?php echo $s_eval_scheme->operator->viewAttributes() ?>>
<?php echo $s_eval_scheme->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($s_eval_scheme->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $s_eval_scheme->datetime->cellAttributes() ?>>
<span id="el<?php echo $s_eval_scheme_list->RowCnt ?>_s_eval_scheme_datetime" class="s_eval_scheme_datetime">
<span<?php echo $s_eval_scheme->datetime->viewAttributes() ?>>
<?php echo $s_eval_scheme->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$s_eval_scheme_list->ListOptions->render("body", "right", $s_eval_scheme_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$s_eval_scheme->isGridAdd())
		$s_eval_scheme_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$s_eval_scheme->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($s_eval_scheme_list->Recordset)
	$s_eval_scheme_list->Recordset->Close();
?>
<?php if (!$s_eval_scheme->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$s_eval_scheme->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($s_eval_scheme_list->Pager)) $s_eval_scheme_list->Pager = new PrevNextPager($s_eval_scheme_list->StartRec, $s_eval_scheme_list->DisplayRecs, $s_eval_scheme_list->TotalRecs, $s_eval_scheme_list->AutoHidePager) ?>
<?php if ($s_eval_scheme_list->Pager->RecordCount > 0 && $s_eval_scheme_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($s_eval_scheme_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $s_eval_scheme_list->pageUrl() ?>start=<?php echo $s_eval_scheme_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($s_eval_scheme_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $s_eval_scheme_list->pageUrl() ?>start=<?php echo $s_eval_scheme_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $s_eval_scheme_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($s_eval_scheme_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $s_eval_scheme_list->pageUrl() ?>start=<?php echo $s_eval_scheme_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($s_eval_scheme_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $s_eval_scheme_list->pageUrl() ?>start=<?php echo $s_eval_scheme_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $s_eval_scheme_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($s_eval_scheme_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $s_eval_scheme_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $s_eval_scheme_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $s_eval_scheme_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($s_eval_scheme_list->TotalRecs > 0 && (!$s_eval_scheme_list->AutoHidePageSizeSelector || $s_eval_scheme_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="s_eval_scheme">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($s_eval_scheme_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($s_eval_scheme_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($s_eval_scheme_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($s_eval_scheme_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($s_eval_scheme_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($s_eval_scheme->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $s_eval_scheme_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($s_eval_scheme_list->TotalRecs == 0 && !$s_eval_scheme->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $s_eval_scheme_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$s_eval_scheme_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$s_eval_scheme->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$s_eval_scheme->isExport()) { ?>
<script>
ew.scrollableTable("gmp_s_eval_scheme", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$s_eval_scheme_list->terminate();
?>