<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_expenses_delete = new salary_expenses_delete();

// Run the page
$salary_expenses_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_expenses_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fsalary_expensesdelete = currentForm = new ew.Form("fsalary_expensesdelete", "delete");

// Form_CustomValidate event
fsalary_expensesdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_expensesdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_expensesdelete.lists["x_employee_id"] = <?php echo $salary_expenses_delete->employee_id->Lookup->toClientList() ?>;
fsalary_expensesdelete.lists["x_employee_id"].options = <?php echo JsonEncode($salary_expenses_delete->employee_id->lookupOptions()) ?>;
fsalary_expensesdelete.lists["x_expense_type"] = <?php echo $salary_expenses_delete->expense_type->Lookup->toClientList() ?>;
fsalary_expensesdelete.lists["x_expense_type"].options = <?php echo JsonEncode($salary_expenses_delete->expense_type->lookupOptions()) ?>;
fsalary_expensesdelete.lists["x_expense_sub_type"] = <?php echo $salary_expenses_delete->expense_sub_type->Lookup->toClientList() ?>;
fsalary_expensesdelete.lists["x_expense_sub_type"].options = <?php echo JsonEncode($salary_expenses_delete->expense_sub_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $salary_expenses_delete->showPageHeader(); ?>
<?php
$salary_expenses_delete->showMessage();
?>
<form name="fsalary_expensesdelete" id="fsalary_expensesdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_expenses_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_expenses_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_expenses">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($salary_expenses_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($salary_expenses->id->Visible) { // id ?>
		<th class="<?php echo $salary_expenses->id->headerCellClass() ?>"><span id="elh_salary_expenses_id" class="salary_expenses_id"><?php echo $salary_expenses->id->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->employee_id->Visible) { // employee_id ?>
		<th class="<?php echo $salary_expenses->employee_id->headerCellClass() ?>"><span id="elh_salary_expenses_employee_id" class="salary_expenses_employee_id"><?php echo $salary_expenses->employee_id->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->expense_type->Visible) { // expense_type ?>
		<th class="<?php echo $salary_expenses->expense_type->headerCellClass() ?>"><span id="elh_salary_expenses_expense_type" class="salary_expenses_expense_type"><?php echo $salary_expenses->expense_type->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->expense_sub_type->Visible) { // expense_sub_type ?>
		<th class="<?php echo $salary_expenses->expense_sub_type->headerCellClass() ?>"><span id="elh_salary_expenses_expense_sub_type" class="salary_expenses_expense_sub_type"><?php echo $salary_expenses->expense_sub_type->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->basic_salary->Visible) { // basic_salary ?>
		<th class="<?php echo $salary_expenses->basic_salary->headerCellClass() ?>"><span id="elh_salary_expenses_basic_salary" class="salary_expenses_basic_salary"><?php echo $salary_expenses->basic_salary->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->ded_add->Visible) { // ded_add ?>
		<th class="<?php echo $salary_expenses->ded_add->headerCellClass() ?>"><span id="elh_salary_expenses_ded_add" class="salary_expenses_ded_add"><?php echo $salary_expenses->ded_add->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->final_amount->Visible) { // final_amount ?>
		<th class="<?php echo $salary_expenses->final_amount->headerCellClass() ?>"><span id="elh_salary_expenses_final_amount" class="salary_expenses_final_amount"><?php echo $salary_expenses->final_amount->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->dated->Visible) { // dated ?>
		<th class="<?php echo $salary_expenses->dated->headerCellClass() ?>"><span id="elh_salary_expenses_dated" class="salary_expenses_dated"><?php echo $salary_expenses->dated->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->remarks->Visible) { // remarks ?>
		<th class="<?php echo $salary_expenses->remarks->headerCellClass() ?>"><span id="elh_salary_expenses_remarks" class="salary_expenses_remarks"><?php echo $salary_expenses->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->uploads->Visible) { // uploads ?>
		<th class="<?php echo $salary_expenses->uploads->headerCellClass() ?>"><span id="elh_salary_expenses_uploads" class="salary_expenses_uploads"><?php echo $salary_expenses->uploads->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->operator->Visible) { // operator ?>
		<th class="<?php echo $salary_expenses->operator->headerCellClass() ?>"><span id="elh_salary_expenses_operator" class="salary_expenses_operator"><?php echo $salary_expenses->operator->caption() ?></span></th>
<?php } ?>
<?php if ($salary_expenses->datetime->Visible) { // datetime ?>
		<th class="<?php echo $salary_expenses->datetime->headerCellClass() ?>"><span id="elh_salary_expenses_datetime" class="salary_expenses_datetime"><?php echo $salary_expenses->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$salary_expenses_delete->RecCnt = 0;
$i = 0;
while (!$salary_expenses_delete->Recordset->EOF) {
	$salary_expenses_delete->RecCnt++;
	$salary_expenses_delete->RowCnt++;

	// Set row properties
	$salary_expenses->resetAttributes();
	$salary_expenses->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$salary_expenses_delete->loadRowValues($salary_expenses_delete->Recordset);

	// Render row
	$salary_expenses_delete->renderRow();
?>
	<tr<?php echo $salary_expenses->rowAttributes() ?>>
<?php if ($salary_expenses->id->Visible) { // id ?>
		<td<?php echo $salary_expenses->id->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_id" class="salary_expenses_id">
<span<?php echo $salary_expenses->id->viewAttributes() ?>>
<?php echo $salary_expenses->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->employee_id->Visible) { // employee_id ?>
		<td<?php echo $salary_expenses->employee_id->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_employee_id" class="salary_expenses_employee_id">
<span<?php echo $salary_expenses->employee_id->viewAttributes() ?>>
<?php echo $salary_expenses->employee_id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->expense_type->Visible) { // expense_type ?>
		<td<?php echo $salary_expenses->expense_type->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_expense_type" class="salary_expenses_expense_type">
<span<?php echo $salary_expenses->expense_type->viewAttributes() ?>>
<?php echo $salary_expenses->expense_type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->expense_sub_type->Visible) { // expense_sub_type ?>
		<td<?php echo $salary_expenses->expense_sub_type->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_expense_sub_type" class="salary_expenses_expense_sub_type">
<span>
<?php echo GetImageViewTag($salary_expenses->expense_sub_type, $salary_expenses->expense_sub_type->getViewValue()) ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->basic_salary->Visible) { // basic_salary ?>
		<td<?php echo $salary_expenses->basic_salary->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_basic_salary" class="salary_expenses_basic_salary">
<span<?php echo $salary_expenses->basic_salary->viewAttributes() ?>>
<?php echo $salary_expenses->basic_salary->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->ded_add->Visible) { // ded_add ?>
		<td<?php echo $salary_expenses->ded_add->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_ded_add" class="salary_expenses_ded_add">
<span<?php echo $salary_expenses->ded_add->viewAttributes() ?>>
<?php echo $salary_expenses->ded_add->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->final_amount->Visible) { // final_amount ?>
		<td<?php echo $salary_expenses->final_amount->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_final_amount" class="salary_expenses_final_amount">
<span<?php echo $salary_expenses->final_amount->viewAttributes() ?>>
<?php echo $salary_expenses->final_amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->dated->Visible) { // dated ?>
		<td<?php echo $salary_expenses->dated->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_dated" class="salary_expenses_dated">
<span<?php echo $salary_expenses->dated->viewAttributes() ?>>
<?php echo $salary_expenses->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->remarks->Visible) { // remarks ?>
		<td<?php echo $salary_expenses->remarks->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_remarks" class="salary_expenses_remarks">
<span<?php echo $salary_expenses->remarks->viewAttributes() ?>>
<?php echo $salary_expenses->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->uploads->Visible) { // uploads ?>
		<td<?php echo $salary_expenses->uploads->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_uploads" class="salary_expenses_uploads">
<span>
<?php echo GetFileViewTag($salary_expenses->uploads, $salary_expenses->uploads->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->operator->Visible) { // operator ?>
		<td<?php echo $salary_expenses->operator->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_operator" class="salary_expenses_operator">
<span<?php echo $salary_expenses->operator->viewAttributes() ?>>
<?php echo $salary_expenses->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($salary_expenses->datetime->Visible) { // datetime ?>
		<td<?php echo $salary_expenses->datetime->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_delete->RowCnt ?>_salary_expenses_datetime" class="salary_expenses_datetime">
<span<?php echo $salary_expenses->datetime->viewAttributes() ?>>
<?php echo $salary_expenses->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$salary_expenses_delete->Recordset->moveNext();
}
$salary_expenses_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $salary_expenses_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$salary_expenses_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$salary_expenses_delete->terminate();
?>