<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_expenses_edit = new salary_expenses_edit();

// Run the page
$salary_expenses_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_expenses_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsalary_expensesedit = currentForm = new ew.Form("fsalary_expensesedit", "edit");

// Validate form
fsalary_expensesedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($salary_expenses_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->id->caption(), $salary_expenses->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_expenses_edit->employee_id->Required) { ?>
			elm = this.getElements("x" + infix + "_employee_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->employee_id->caption(), $salary_expenses->employee_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_expenses_edit->expense_type->Required) { ?>
			elm = this.getElements("x" + infix + "_expense_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->expense_type->caption(), $salary_expenses->expense_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_expenses_edit->expense_sub_type->Required) { ?>
			elm = this.getElements("x" + infix + "_expense_sub_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->expense_sub_type->caption(), $salary_expenses->expense_sub_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_expenses_edit->basic_salary->Required) { ?>
			elm = this.getElements("x" + infix + "_basic_salary");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->basic_salary->caption(), $salary_expenses->basic_salary->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_basic_salary");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($salary_expenses->basic_salary->errorMessage()) ?>");
		<?php if ($salary_expenses_edit->ded_add->Required) { ?>
			elm = this.getElements("x" + infix + "_ded_add");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->ded_add->caption(), $salary_expenses->ded_add->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ded_add");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($salary_expenses->ded_add->errorMessage()) ?>");
		<?php if ($salary_expenses_edit->final_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_final_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->final_amount->caption(), $salary_expenses->final_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_final_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($salary_expenses->final_amount->errorMessage()) ?>");
		<?php if ($salary_expenses_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->dated->caption(), $salary_expenses->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($salary_expenses->dated->errorMessage()) ?>");
		<?php if ($salary_expenses_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->remarks->caption(), $salary_expenses->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_expenses_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->uploads->caption(), $salary_expenses->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_expenses_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->operator->caption(), $salary_expenses->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_expenses_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_expenses->datetime->caption(), $salary_expenses->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsalary_expensesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_expensesedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_expensesedit.lists["x_employee_id"] = <?php echo $salary_expenses_edit->employee_id->Lookup->toClientList() ?>;
fsalary_expensesedit.lists["x_employee_id"].options = <?php echo JsonEncode($salary_expenses_edit->employee_id->lookupOptions()) ?>;
fsalary_expensesedit.lists["x_expense_type"] = <?php echo $salary_expenses_edit->expense_type->Lookup->toClientList() ?>;
fsalary_expensesedit.lists["x_expense_type"].options = <?php echo JsonEncode($salary_expenses_edit->expense_type->lookupOptions()) ?>;
fsalary_expensesedit.lists["x_expense_sub_type"] = <?php echo $salary_expenses_edit->expense_sub_type->Lookup->toClientList() ?>;
fsalary_expensesedit.lists["x_expense_sub_type"].options = <?php echo JsonEncode($salary_expenses_edit->expense_sub_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $salary_expenses_edit->showPageHeader(); ?>
<?php
$salary_expenses_edit->showMessage();
?>
<form name="fsalary_expensesedit" id="fsalary_expensesedit" class="<?php echo $salary_expenses_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_expenses_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_expenses_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_expenses">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$salary_expenses_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($salary_expenses->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_salary_expenses_id" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->id->caption() ?><?php echo ($salary_expenses->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->id->cellAttributes() ?>>
<span id="el_salary_expenses_id">
<span<?php echo $salary_expenses->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($salary_expenses->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="salary_expenses" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($salary_expenses->id->CurrentValue) ?>">
<?php echo $salary_expenses->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label id="elh_salary_expenses_employee_id" for="x_employee_id" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->employee_id->caption() ?><?php echo ($salary_expenses->employee_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->employee_id->cellAttributes() ?>>
<span id="el_salary_expenses_employee_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="salary_expenses" data-field="x_employee_id" data-value-separator="<?php echo $salary_expenses->employee_id->displayValueSeparatorAttribute() ?>" id="x_employee_id" name="x_employee_id"<?php echo $salary_expenses->employee_id->editAttributes() ?>>
		<?php echo $salary_expenses->employee_id->selectOptionListHtml("x_employee_id") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "production_employee") && !$salary_expenses->employee_id->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_employee_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $salary_expenses->employee_id->caption() ?>" data-title="<?php echo $salary_expenses->employee_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_employee_id',url:'production_employeeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $salary_expenses->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
<?php echo $salary_expenses->employee_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->expense_type->Visible) { // expense_type ?>
	<div id="r_expense_type" class="form-group row">
		<label id="elh_salary_expenses_expense_type" for="x_expense_type" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->expense_type->caption() ?><?php echo ($salary_expenses->expense_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->expense_type->cellAttributes() ?>>
<span id="el_salary_expenses_expense_type">
<?php $salary_expenses->expense_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$salary_expenses->expense_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="salary_expenses" data-field="x_expense_type" data-value-separator="<?php echo $salary_expenses->expense_type->displayValueSeparatorAttribute() ?>" id="x_expense_type" name="x_expense_type"<?php echo $salary_expenses->expense_type->editAttributes() ?>>
		<?php echo $salary_expenses->expense_type->selectOptionListHtml("x_expense_type") ?>
	</select>
</div>
<?php echo $salary_expenses->expense_type->Lookup->getParamTag("p_x_expense_type") ?>
</span>
<?php echo $salary_expenses->expense_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->expense_sub_type->Visible) { // expense_sub_type ?>
	<div id="r_expense_sub_type" class="form-group row">
		<label id="elh_salary_expenses_expense_sub_type" for="x_expense_sub_type" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->expense_sub_type->caption() ?><?php echo ($salary_expenses->expense_sub_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->expense_sub_type->cellAttributes() ?>>
<span id="el_salary_expenses_expense_sub_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="salary_expenses" data-field="x_expense_sub_type" data-value-separator="<?php echo $salary_expenses->expense_sub_type->displayValueSeparatorAttribute() ?>" id="x_expense_sub_type" name="x_expense_sub_type"<?php echo $salary_expenses->expense_sub_type->editAttributes() ?>>
		<?php echo $salary_expenses->expense_sub_type->selectOptionListHtml("x_expense_sub_type") ?>
	</select>
</div>
<?php echo $salary_expenses->expense_sub_type->Lookup->getParamTag("p_x_expense_sub_type") ?>
</span>
<?php echo $salary_expenses->expense_sub_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->basic_salary->Visible) { // basic_salary ?>
	<div id="r_basic_salary" class="form-group row">
		<label id="elh_salary_expenses_basic_salary" for="x_basic_salary" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->basic_salary->caption() ?><?php echo ($salary_expenses->basic_salary->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->basic_salary->cellAttributes() ?>>
<span id="el_salary_expenses_basic_salary">
<input type="text" data-table="salary_expenses" data-field="x_basic_salary" name="x_basic_salary" id="x_basic_salary" size="30" placeholder="<?php echo HtmlEncode($salary_expenses->basic_salary->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->basic_salary->EditValue ?>"<?php echo $salary_expenses->basic_salary->editAttributes() ?>>
</span>
<?php echo $salary_expenses->basic_salary->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->ded_add->Visible) { // ded_add ?>
	<div id="r_ded_add" class="form-group row">
		<label id="elh_salary_expenses_ded_add" for="x_ded_add" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->ded_add->caption() ?><?php echo ($salary_expenses->ded_add->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->ded_add->cellAttributes() ?>>
<span id="el_salary_expenses_ded_add">
<input type="text" data-table="salary_expenses" data-field="x_ded_add" name="x_ded_add" id="x_ded_add" size="30" placeholder="<?php echo HtmlEncode($salary_expenses->ded_add->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->ded_add->EditValue ?>"<?php echo $salary_expenses->ded_add->editAttributes() ?>>
</span>
<?php echo $salary_expenses->ded_add->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->final_amount->Visible) { // final_amount ?>
	<div id="r_final_amount" class="form-group row">
		<label id="elh_salary_expenses_final_amount" for="x_final_amount" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->final_amount->caption() ?><?php echo ($salary_expenses->final_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->final_amount->cellAttributes() ?>>
<span id="el_salary_expenses_final_amount">
<input type="text" data-table="salary_expenses" data-field="x_final_amount" name="x_final_amount" id="x_final_amount" size="30" placeholder="<?php echo HtmlEncode($salary_expenses->final_amount->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->final_amount->EditValue ?>"<?php echo $salary_expenses->final_amount->editAttributes() ?>>
</span>
<?php echo $salary_expenses->final_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_salary_expenses_dated" for="x_dated" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->dated->caption() ?><?php echo ($salary_expenses->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->dated->cellAttributes() ?>>
<span id="el_salary_expenses_dated">
<input type="text" data-table="salary_expenses" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($salary_expenses->dated->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->dated->EditValue ?>"<?php echo $salary_expenses->dated->editAttributes() ?>>
<?php if (!$salary_expenses->dated->ReadOnly && !$salary_expenses->dated->Disabled && !isset($salary_expenses->dated->EditAttrs["readonly"]) && !isset($salary_expenses->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsalary_expensesedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $salary_expenses->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_salary_expenses_remarks" for="x_remarks" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->remarks->caption() ?><?php echo ($salary_expenses->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->remarks->cellAttributes() ?>>
<span id="el_salary_expenses_remarks">
<textarea data-table="salary_expenses" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="2" placeholder="<?php echo HtmlEncode($salary_expenses->remarks->getPlaceHolder()) ?>"<?php echo $salary_expenses->remarks->editAttributes() ?>><?php echo $salary_expenses->remarks->EditValue ?></textarea>
</span>
<?php echo $salary_expenses->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_salary_expenses_uploads" class="<?php echo $salary_expenses_edit->LeftColumnClass ?>"><?php echo $salary_expenses->uploads->caption() ?><?php echo ($salary_expenses->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_expenses_edit->RightColumnClass ?>"><div<?php echo $salary_expenses->uploads->cellAttributes() ?>>
<span id="el_salary_expenses_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $salary_expenses->uploads->title() ? $salary_expenses->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($salary_expenses->uploads->ReadOnly || $salary_expenses->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="salary_expenses" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $salary_expenses->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $salary_expenses->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $salary_expenses->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $salary_expenses->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $salary_expenses->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$salary_expenses_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $salary_expenses_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $salary_expenses_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$salary_expenses_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$salary_expenses_edit->terminate();
?>