<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_expenses_list = new salary_expenses_list();

// Run the page
$salary_expenses_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_expenses_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$salary_expenses->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsalary_expenseslist = currentForm = new ew.Form("fsalary_expenseslist", "list");
fsalary_expenseslist.formKeyCountName = '<?php echo $salary_expenses_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsalary_expenseslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_expenseslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_expenseslist.lists["x_employee_id"] = <?php echo $salary_expenses_list->employee_id->Lookup->toClientList() ?>;
fsalary_expenseslist.lists["x_employee_id"].options = <?php echo JsonEncode($salary_expenses_list->employee_id->lookupOptions()) ?>;
fsalary_expenseslist.lists["x_expense_type"] = <?php echo $salary_expenses_list->expense_type->Lookup->toClientList() ?>;
fsalary_expenseslist.lists["x_expense_type"].options = <?php echo JsonEncode($salary_expenses_list->expense_type->lookupOptions()) ?>;
fsalary_expenseslist.lists["x_expense_sub_type"] = <?php echo $salary_expenses_list->expense_sub_type->Lookup->toClientList() ?>;
fsalary_expenseslist.lists["x_expense_sub_type"].options = <?php echo JsonEncode($salary_expenses_list->expense_sub_type->lookupOptions()) ?>;

// Form object for search
var fsalary_expenseslistsrch = currentSearchForm = new ew.Form("fsalary_expenseslistsrch");

// Filters
fsalary_expenseslistsrch.filterList = <?php echo $salary_expenses_list->getFilterList() ?>;

// Init search panel as collapsed
fsalary_expenseslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$salary_expenses->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($salary_expenses_list->TotalRecs > 0 && $salary_expenses_list->ExportOptions->visible()) { ?>
<?php $salary_expenses_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($salary_expenses_list->ImportOptions->visible()) { ?>
<?php $salary_expenses_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($salary_expenses_list->SearchOptions->visible()) { ?>
<?php $salary_expenses_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($salary_expenses_list->FilterOptions->visible()) { ?>
<?php $salary_expenses_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$salary_expenses_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$salary_expenses->isExport() && !$salary_expenses->CurrentAction) { ?>
<form name="fsalary_expenseslistsrch" id="fsalary_expenseslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($salary_expenses_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsalary_expenseslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="salary_expenses">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($salary_expenses_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($salary_expenses_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $salary_expenses_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($salary_expenses_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($salary_expenses_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($salary_expenses_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($salary_expenses_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $salary_expenses_list->showPageHeader(); ?>
<?php
$salary_expenses_list->showMessage();
?>
<?php if ($salary_expenses_list->TotalRecs > 0 || $salary_expenses->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($salary_expenses_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> salary_expenses">
<?php if (!$salary_expenses->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$salary_expenses->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($salary_expenses_list->Pager)) $salary_expenses_list->Pager = new PrevNextPager($salary_expenses_list->StartRec, $salary_expenses_list->DisplayRecs, $salary_expenses_list->TotalRecs, $salary_expenses_list->AutoHidePager) ?>
<?php if ($salary_expenses_list->Pager->RecordCount > 0 && $salary_expenses_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($salary_expenses_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $salary_expenses_list->pageUrl() ?>start=<?php echo $salary_expenses_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($salary_expenses_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $salary_expenses_list->pageUrl() ?>start=<?php echo $salary_expenses_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $salary_expenses_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($salary_expenses_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $salary_expenses_list->pageUrl() ?>start=<?php echo $salary_expenses_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($salary_expenses_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $salary_expenses_list->pageUrl() ?>start=<?php echo $salary_expenses_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $salary_expenses_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($salary_expenses_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $salary_expenses_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $salary_expenses_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $salary_expenses_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($salary_expenses_list->TotalRecs > 0 && (!$salary_expenses_list->AutoHidePageSizeSelector || $salary_expenses_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="salary_expenses">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($salary_expenses_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($salary_expenses_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($salary_expenses_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($salary_expenses_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($salary_expenses_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($salary_expenses->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $salary_expenses_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsalary_expenseslist" id="fsalary_expenseslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_expenses_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_expenses_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_expenses">
<div id="gmp_salary_expenses" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($salary_expenses_list->TotalRecs > 0 || $salary_expenses->isGridEdit()) { ?>
<table id="tbl_salary_expenseslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$salary_expenses_list->RowType = ROWTYPE_HEADER;

// Render list options
$salary_expenses_list->renderListOptions();

// Render list options (header, left)
$salary_expenses_list->ListOptions->render("header", "left");
?>
<?php if ($salary_expenses->id->Visible) { // id ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->id) == "") { ?>
		<th data-name="id" class="<?php echo $salary_expenses->id->headerCellClass() ?>"><div id="elh_salary_expenses_id" class="salary_expenses_id"><div class="ew-table-header-caption"><?php echo $salary_expenses->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $salary_expenses->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->id) ?>',2);"><div id="elh_salary_expenses_id" class="salary_expenses_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->employee_id->Visible) { // employee_id ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $salary_expenses->employee_id->headerCellClass() ?>"><div id="elh_salary_expenses_employee_id" class="salary_expenses_employee_id"><div class="ew-table-header-caption"><?php echo $salary_expenses->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $salary_expenses->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->employee_id) ?>',2);"><div id="elh_salary_expenses_employee_id" class="salary_expenses_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->expense_type->Visible) { // expense_type ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->expense_type) == "") { ?>
		<th data-name="expense_type" class="<?php echo $salary_expenses->expense_type->headerCellClass() ?>"><div id="elh_salary_expenses_expense_type" class="salary_expenses_expense_type"><div class="ew-table-header-caption"><?php echo $salary_expenses->expense_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="expense_type" class="<?php echo $salary_expenses->expense_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->expense_type) ?>',2);"><div id="elh_salary_expenses_expense_type" class="salary_expenses_expense_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->expense_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->expense_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->expense_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->expense_sub_type->Visible) { // expense_sub_type ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->expense_sub_type) == "") { ?>
		<th data-name="expense_sub_type" class="<?php echo $salary_expenses->expense_sub_type->headerCellClass() ?>"><div id="elh_salary_expenses_expense_sub_type" class="salary_expenses_expense_sub_type"><div class="ew-table-header-caption"><?php echo $salary_expenses->expense_sub_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="expense_sub_type" class="<?php echo $salary_expenses->expense_sub_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->expense_sub_type) ?>',2);"><div id="elh_salary_expenses_expense_sub_type" class="salary_expenses_expense_sub_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->expense_sub_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->expense_sub_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->expense_sub_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->basic_salary->Visible) { // basic_salary ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->basic_salary) == "") { ?>
		<th data-name="basic_salary" class="<?php echo $salary_expenses->basic_salary->headerCellClass() ?>"><div id="elh_salary_expenses_basic_salary" class="salary_expenses_basic_salary"><div class="ew-table-header-caption"><?php echo $salary_expenses->basic_salary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="basic_salary" class="<?php echo $salary_expenses->basic_salary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->basic_salary) ?>',2);"><div id="elh_salary_expenses_basic_salary" class="salary_expenses_basic_salary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->basic_salary->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->basic_salary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->basic_salary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->ded_add->Visible) { // ded_add ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->ded_add) == "") { ?>
		<th data-name="ded_add" class="<?php echo $salary_expenses->ded_add->headerCellClass() ?>"><div id="elh_salary_expenses_ded_add" class="salary_expenses_ded_add"><div class="ew-table-header-caption"><?php echo $salary_expenses->ded_add->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ded_add" class="<?php echo $salary_expenses->ded_add->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->ded_add) ?>',2);"><div id="elh_salary_expenses_ded_add" class="salary_expenses_ded_add">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->ded_add->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->ded_add->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->ded_add->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->final_amount->Visible) { // final_amount ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->final_amount) == "") { ?>
		<th data-name="final_amount" class="<?php echo $salary_expenses->final_amount->headerCellClass() ?>"><div id="elh_salary_expenses_final_amount" class="salary_expenses_final_amount"><div class="ew-table-header-caption"><?php echo $salary_expenses->final_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="final_amount" class="<?php echo $salary_expenses->final_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->final_amount) ?>',2);"><div id="elh_salary_expenses_final_amount" class="salary_expenses_final_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->final_amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->final_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->final_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->dated->Visible) { // dated ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $salary_expenses->dated->headerCellClass() ?>"><div id="elh_salary_expenses_dated" class="salary_expenses_dated"><div class="ew-table-header-caption"><?php echo $salary_expenses->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $salary_expenses->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->dated) ?>',2);"><div id="elh_salary_expenses_dated" class="salary_expenses_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->remarks->Visible) { // remarks ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $salary_expenses->remarks->headerCellClass() ?>"><div id="elh_salary_expenses_remarks" class="salary_expenses_remarks"><div class="ew-table-header-caption"><?php echo $salary_expenses->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $salary_expenses->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->remarks) ?>',2);"><div id="elh_salary_expenses_remarks" class="salary_expenses_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->uploads->Visible) { // uploads ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $salary_expenses->uploads->headerCellClass() ?>"><div id="elh_salary_expenses_uploads" class="salary_expenses_uploads"><div class="ew-table-header-caption"><?php echo $salary_expenses->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $salary_expenses->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->uploads) ?>',2);"><div id="elh_salary_expenses_uploads" class="salary_expenses_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->operator->Visible) { // operator ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $salary_expenses->operator->headerCellClass() ?>"><div id="elh_salary_expenses_operator" class="salary_expenses_operator"><div class="ew-table-header-caption"><?php echo $salary_expenses->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $salary_expenses->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->operator) ?>',2);"><div id="elh_salary_expenses_operator" class="salary_expenses_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_expenses->datetime->Visible) { // datetime ?>
	<?php if ($salary_expenses->sortUrl($salary_expenses->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $salary_expenses->datetime->headerCellClass() ?>"><div id="elh_salary_expenses_datetime" class="salary_expenses_datetime"><div class="ew-table-header-caption"><?php echo $salary_expenses->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $salary_expenses->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_expenses->SortUrl($salary_expenses->datetime) ?>',2);"><div id="elh_salary_expenses_datetime" class="salary_expenses_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_expenses->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_expenses->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_expenses->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$salary_expenses_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($salary_expenses->ExportAll && $salary_expenses->isExport()) {
	$salary_expenses_list->StopRec = $salary_expenses_list->TotalRecs;
} else {

	// Set the last record to display
	if ($salary_expenses_list->TotalRecs > $salary_expenses_list->StartRec + $salary_expenses_list->DisplayRecs - 1)
		$salary_expenses_list->StopRec = $salary_expenses_list->StartRec + $salary_expenses_list->DisplayRecs - 1;
	else
		$salary_expenses_list->StopRec = $salary_expenses_list->TotalRecs;
}
$salary_expenses_list->RecCnt = $salary_expenses_list->StartRec - 1;
if ($salary_expenses_list->Recordset && !$salary_expenses_list->Recordset->EOF) {
	$salary_expenses_list->Recordset->moveFirst();
	$selectLimit = $salary_expenses_list->UseSelectLimit;
	if (!$selectLimit && $salary_expenses_list->StartRec > 1)
		$salary_expenses_list->Recordset->move($salary_expenses_list->StartRec - 1);
} elseif (!$salary_expenses->AllowAddDeleteRow && $salary_expenses_list->StopRec == 0) {
	$salary_expenses_list->StopRec = $salary_expenses->GridAddRowCount;
}

// Initialize aggregate
$salary_expenses->RowType = ROWTYPE_AGGREGATEINIT;
$salary_expenses->resetAttributes();
$salary_expenses_list->renderRow();
while ($salary_expenses_list->RecCnt < $salary_expenses_list->StopRec) {
	$salary_expenses_list->RecCnt++;
	if ($salary_expenses_list->RecCnt >= $salary_expenses_list->StartRec) {
		$salary_expenses_list->RowCnt++;

		// Set up key count
		$salary_expenses_list->KeyCount = $salary_expenses_list->RowIndex;

		// Init row class and style
		$salary_expenses->resetAttributes();
		$salary_expenses->CssClass = "";
		if ($salary_expenses->isGridAdd()) {
		} else {
			$salary_expenses_list->loadRowValues($salary_expenses_list->Recordset); // Load row values
		}
		$salary_expenses->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$salary_expenses->RowAttrs = array_merge($salary_expenses->RowAttrs, array('data-rowindex'=>$salary_expenses_list->RowCnt, 'id'=>'r' . $salary_expenses_list->RowCnt . '_salary_expenses', 'data-rowtype'=>$salary_expenses->RowType));

		// Render row
		$salary_expenses_list->renderRow();

		// Render list options
		$salary_expenses_list->renderListOptions();
?>
	<tr<?php echo $salary_expenses->rowAttributes() ?>>
<?php

// Render list options (body, left)
$salary_expenses_list->ListOptions->render("body", "left", $salary_expenses_list->RowCnt);
?>
	<?php if ($salary_expenses->id->Visible) { // id ?>
		<td data-name="id"<?php echo $salary_expenses->id->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_id" class="salary_expenses_id">
<span<?php echo $salary_expenses->id->viewAttributes() ?>>
<?php echo $salary_expenses->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $salary_expenses->employee_id->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_employee_id" class="salary_expenses_employee_id">
<span<?php echo $salary_expenses->employee_id->viewAttributes() ?>>
<?php echo $salary_expenses->employee_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->expense_type->Visible) { // expense_type ?>
		<td data-name="expense_type"<?php echo $salary_expenses->expense_type->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_expense_type" class="salary_expenses_expense_type">
<span<?php echo $salary_expenses->expense_type->viewAttributes() ?>>
<?php echo $salary_expenses->expense_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->expense_sub_type->Visible) { // expense_sub_type ?>
		<td data-name="expense_sub_type"<?php echo $salary_expenses->expense_sub_type->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_expense_sub_type" class="salary_expenses_expense_sub_type">
<span>
<?php echo GetImageViewTag($salary_expenses->expense_sub_type, $salary_expenses->expense_sub_type->getViewValue()) ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->basic_salary->Visible) { // basic_salary ?>
		<td data-name="basic_salary"<?php echo $salary_expenses->basic_salary->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_basic_salary" class="salary_expenses_basic_salary">
<span<?php echo $salary_expenses->basic_salary->viewAttributes() ?>>
<?php echo $salary_expenses->basic_salary->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->ded_add->Visible) { // ded_add ?>
		<td data-name="ded_add"<?php echo $salary_expenses->ded_add->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_ded_add" class="salary_expenses_ded_add">
<span<?php echo $salary_expenses->ded_add->viewAttributes() ?>>
<?php echo $salary_expenses->ded_add->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->final_amount->Visible) { // final_amount ?>
		<td data-name="final_amount"<?php echo $salary_expenses->final_amount->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_final_amount" class="salary_expenses_final_amount">
<span<?php echo $salary_expenses->final_amount->viewAttributes() ?>>
<?php echo $salary_expenses->final_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $salary_expenses->dated->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_dated" class="salary_expenses_dated">
<span<?php echo $salary_expenses->dated->viewAttributes() ?>>
<?php echo $salary_expenses->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $salary_expenses->remarks->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_remarks" class="salary_expenses_remarks">
<span<?php echo $salary_expenses->remarks->viewAttributes() ?>>
<?php echo $salary_expenses->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $salary_expenses->uploads->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_uploads" class="salary_expenses_uploads">
<span>
<?php echo GetFileViewTag($salary_expenses->uploads, $salary_expenses->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $salary_expenses->operator->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_operator" class="salary_expenses_operator">
<span<?php echo $salary_expenses->operator->viewAttributes() ?>>
<?php echo $salary_expenses->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_expenses->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $salary_expenses->datetime->cellAttributes() ?>>
<span id="el<?php echo $salary_expenses_list->RowCnt ?>_salary_expenses_datetime" class="salary_expenses_datetime">
<span<?php echo $salary_expenses->datetime->viewAttributes() ?>>
<?php echo $salary_expenses->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$salary_expenses_list->ListOptions->render("body", "right", $salary_expenses_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$salary_expenses->isGridAdd())
		$salary_expenses_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$salary_expenses->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($salary_expenses_list->Recordset)
	$salary_expenses_list->Recordset->Close();
?>
<?php if (!$salary_expenses->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$salary_expenses->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($salary_expenses_list->Pager)) $salary_expenses_list->Pager = new PrevNextPager($salary_expenses_list->StartRec, $salary_expenses_list->DisplayRecs, $salary_expenses_list->TotalRecs, $salary_expenses_list->AutoHidePager) ?>
<?php if ($salary_expenses_list->Pager->RecordCount > 0 && $salary_expenses_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($salary_expenses_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $salary_expenses_list->pageUrl() ?>start=<?php echo $salary_expenses_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($salary_expenses_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $salary_expenses_list->pageUrl() ?>start=<?php echo $salary_expenses_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $salary_expenses_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($salary_expenses_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $salary_expenses_list->pageUrl() ?>start=<?php echo $salary_expenses_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($salary_expenses_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $salary_expenses_list->pageUrl() ?>start=<?php echo $salary_expenses_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $salary_expenses_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($salary_expenses_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $salary_expenses_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $salary_expenses_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $salary_expenses_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($salary_expenses_list->TotalRecs > 0 && (!$salary_expenses_list->AutoHidePageSizeSelector || $salary_expenses_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="salary_expenses">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($salary_expenses_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($salary_expenses_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($salary_expenses_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($salary_expenses_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($salary_expenses_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($salary_expenses->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $salary_expenses_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($salary_expenses_list->TotalRecs == 0 && !$salary_expenses->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $salary_expenses_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$salary_expenses_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$salary_expenses->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$salary_expenses->isExport()) { ?>
<script>
ew.scrollableTable("gmp_salary_expenses", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$salary_expenses_list->terminate();
?>