<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_expenses_search = new salary_expenses_search();

// Run the page
$salary_expenses_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_expenses_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($salary_expenses_search->IsModal) { ?>
var fsalary_expensessearch = currentAdvancedSearchForm = new ew.Form("fsalary_expensessearch", "search");
<?php } else { ?>
var fsalary_expensessearch = currentForm = new ew.Form("fsalary_expensessearch", "search");
<?php } ?>

// Form_CustomValidate event
fsalary_expensessearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_expensessearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_expensessearch.lists["x_employee_id"] = <?php echo $salary_expenses_search->employee_id->Lookup->toClientList() ?>;
fsalary_expensessearch.lists["x_employee_id"].options = <?php echo JsonEncode($salary_expenses_search->employee_id->lookupOptions()) ?>;
fsalary_expensessearch.lists["x_expense_type"] = <?php echo $salary_expenses_search->expense_type->Lookup->toClientList() ?>;
fsalary_expensessearch.lists["x_expense_type"].options = <?php echo JsonEncode($salary_expenses_search->expense_type->lookupOptions()) ?>;
fsalary_expensessearch.lists["x_expense_sub_type"] = <?php echo $salary_expenses_search->expense_sub_type->Lookup->toClientList() ?>;
fsalary_expensessearch.lists["x_expense_sub_type"].options = <?php echo JsonEncode($salary_expenses_search->expense_sub_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fsalary_expensessearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_expenses->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_basic_salary");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_expenses->basic_salary->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ded_add");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_expenses->ded_add->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_final_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_expenses->final_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_expenses->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_expenses->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_expenses->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $salary_expenses_search->showPageHeader(); ?>
<?php
$salary_expenses_search->showMessage();
?>
<form name="fsalary_expensessearch" id="fsalary_expensessearch" class="<?php echo $salary_expenses_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_expenses_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_expenses_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_expenses">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$salary_expenses_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($salary_expenses->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_id"><?php echo $salary_expenses->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->id->cellAttributes() ?>>
			<span id="el_salary_expenses_id">
<input type="text" data-table="salary_expenses" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($salary_expenses->id->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->id->EditValue ?>"<?php echo $salary_expenses->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->employee_id->Visible) { // employee_id ?>
	<div id="r_employee_id" class="form-group row">
		<label for="x_employee_id" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_employee_id"><?php echo $salary_expenses->employee_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_employee_id" id="z_employee_id" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->employee_id->cellAttributes() ?>>
			<span id="el_salary_expenses_employee_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="salary_expenses" data-field="x_employee_id" data-value-separator="<?php echo $salary_expenses->employee_id->displayValueSeparatorAttribute() ?>" id="x_employee_id" name="x_employee_id"<?php echo $salary_expenses->employee_id->editAttributes() ?>>
		<?php echo $salary_expenses->employee_id->selectOptionListHtml("x_employee_id") ?>
	</select>
</div>
<?php echo $salary_expenses->employee_id->Lookup->getParamTag("p_x_employee_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->expense_type->Visible) { // expense_type ?>
	<div id="r_expense_type" class="form-group row">
		<label for="x_expense_type" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_expense_type"><?php echo $salary_expenses->expense_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_expense_type" id="z_expense_type" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->expense_type->cellAttributes() ?>>
			<span id="el_salary_expenses_expense_type">
<?php $salary_expenses->expense_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$salary_expenses->expense_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="salary_expenses" data-field="x_expense_type" data-value-separator="<?php echo $salary_expenses->expense_type->displayValueSeparatorAttribute() ?>" id="x_expense_type" name="x_expense_type"<?php echo $salary_expenses->expense_type->editAttributes() ?>>
		<?php echo $salary_expenses->expense_type->selectOptionListHtml("x_expense_type") ?>
	</select>
</div>
<?php echo $salary_expenses->expense_type->Lookup->getParamTag("p_x_expense_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->expense_sub_type->Visible) { // expense_sub_type ?>
	<div id="r_expense_sub_type" class="form-group row">
		<label for="x_expense_sub_type" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_expense_sub_type"><?php echo $salary_expenses->expense_sub_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_expense_sub_type" id="z_expense_sub_type" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->expense_sub_type->cellAttributes() ?>>
			<span id="el_salary_expenses_expense_sub_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="salary_expenses" data-field="x_expense_sub_type" data-value-separator="<?php echo $salary_expenses->expense_sub_type->displayValueSeparatorAttribute() ?>" id="x_expense_sub_type" name="x_expense_sub_type"<?php echo $salary_expenses->expense_sub_type->editAttributes() ?>>
		<?php echo $salary_expenses->expense_sub_type->selectOptionListHtml("x_expense_sub_type") ?>
	</select>
</div>
<?php echo $salary_expenses->expense_sub_type->Lookup->getParamTag("p_x_expense_sub_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->basic_salary->Visible) { // basic_salary ?>
	<div id="r_basic_salary" class="form-group row">
		<label for="x_basic_salary" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_basic_salary"><?php echo $salary_expenses->basic_salary->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_basic_salary" id="z_basic_salary" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->basic_salary->cellAttributes() ?>>
			<span id="el_salary_expenses_basic_salary">
<input type="text" data-table="salary_expenses" data-field="x_basic_salary" name="x_basic_salary" id="x_basic_salary" size="30" placeholder="<?php echo HtmlEncode($salary_expenses->basic_salary->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->basic_salary->EditValue ?>"<?php echo $salary_expenses->basic_salary->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->ded_add->Visible) { // ded_add ?>
	<div id="r_ded_add" class="form-group row">
		<label for="x_ded_add" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_ded_add"><?php echo $salary_expenses->ded_add->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ded_add" id="z_ded_add" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->ded_add->cellAttributes() ?>>
			<span id="el_salary_expenses_ded_add">
<input type="text" data-table="salary_expenses" data-field="x_ded_add" name="x_ded_add" id="x_ded_add" size="30" placeholder="<?php echo HtmlEncode($salary_expenses->ded_add->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->ded_add->EditValue ?>"<?php echo $salary_expenses->ded_add->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->final_amount->Visible) { // final_amount ?>
	<div id="r_final_amount" class="form-group row">
		<label for="x_final_amount" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_final_amount"><?php echo $salary_expenses->final_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_final_amount" id="z_final_amount" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->final_amount->cellAttributes() ?>>
			<span id="el_salary_expenses_final_amount">
<input type="text" data-table="salary_expenses" data-field="x_final_amount" name="x_final_amount" id="x_final_amount" size="30" placeholder="<?php echo HtmlEncode($salary_expenses->final_amount->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->final_amount->EditValue ?>"<?php echo $salary_expenses->final_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_dated"><?php echo $salary_expenses->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->dated->cellAttributes() ?>>
			<span id="el_salary_expenses_dated">
<input type="text" data-table="salary_expenses" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($salary_expenses->dated->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->dated->EditValue ?>"<?php echo $salary_expenses->dated->editAttributes() ?>>
<?php if (!$salary_expenses->dated->ReadOnly && !$salary_expenses->dated->Disabled && !isset($salary_expenses->dated->EditAttrs["readonly"]) && !isset($salary_expenses->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsalary_expensessearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_remarks"><?php echo $salary_expenses->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->remarks->cellAttributes() ?>>
			<span id="el_salary_expenses_remarks">
<input type="text" data-table="salary_expenses" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="255" placeholder="<?php echo HtmlEncode($salary_expenses->remarks->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->remarks->EditValue ?>"<?php echo $salary_expenses->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_uploads"><?php echo $salary_expenses->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->uploads->cellAttributes() ?>>
			<span id="el_salary_expenses_uploads">
<input type="text" data-table="salary_expenses" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($salary_expenses->uploads->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->uploads->EditValue ?>"<?php echo $salary_expenses->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_operator"><?php echo $salary_expenses->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->operator->cellAttributes() ?>>
			<span id="el_salary_expenses_operator">
<input type="text" data-table="salary_expenses" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($salary_expenses->operator->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->operator->EditValue ?>"<?php echo $salary_expenses->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_expenses->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $salary_expenses_search->LeftColumnClass ?>"><span id="elh_salary_expenses_datetime"><?php echo $salary_expenses->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $salary_expenses_search->RightColumnClass ?>"><div<?php echo $salary_expenses->datetime->cellAttributes() ?>>
			<span id="el_salary_expenses_datetime">
<input type="text" data-table="salary_expenses" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($salary_expenses->datetime->getPlaceHolder()) ?>" value="<?php echo $salary_expenses->datetime->EditValue ?>"<?php echo $salary_expenses->datetime->editAttributes() ?>>
<?php if (!$salary_expenses->datetime->ReadOnly && !$salary_expenses->datetime->Disabled && !isset($salary_expenses->datetime->EditAttrs["readonly"]) && !isset($salary_expenses->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsalary_expensessearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$salary_expenses_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $salary_expenses_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$salary_expenses_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$salary_expenses_search->terminate();
?>