<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_expenses_view = new salary_expenses_view();

// Run the page
$salary_expenses_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_expenses_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$salary_expenses->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsalary_expensesview = currentForm = new ew.Form("fsalary_expensesview", "view");

// Form_CustomValidate event
fsalary_expensesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_expensesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_expensesview.lists["x_employee_id"] = <?php echo $salary_expenses_view->employee_id->Lookup->toClientList() ?>;
fsalary_expensesview.lists["x_employee_id"].options = <?php echo JsonEncode($salary_expenses_view->employee_id->lookupOptions()) ?>;
fsalary_expensesview.lists["x_expense_type"] = <?php echo $salary_expenses_view->expense_type->Lookup->toClientList() ?>;
fsalary_expensesview.lists["x_expense_type"].options = <?php echo JsonEncode($salary_expenses_view->expense_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$salary_expenses->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $salary_expenses_view->ExportOptions->render("body") ?>
<?php $salary_expenses_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $salary_expenses_view->showPageHeader(); ?>
<?php
$salary_expenses_view->showMessage();
?>
<form name="fsalary_expensesview" id="fsalary_expensesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_expenses_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_expenses_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_expenses">
<input type="hidden" name="modal" value="<?php echo (int)$salary_expenses_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($salary_expenses->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_id"><?php echo $salary_expenses->id->caption() ?></span></td>
		<td data-name="id"<?php echo $salary_expenses->id->cellAttributes() ?>>
<span id="el_salary_expenses_id">
<span<?php echo $salary_expenses->id->viewAttributes() ?>>
<?php echo $salary_expenses->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->employee_id->Visible) { // employee_id ?>
	<tr id="r_employee_id">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_employee_id"><?php echo $salary_expenses->employee_id->caption() ?></span></td>
		<td data-name="employee_id"<?php echo $salary_expenses->employee_id->cellAttributes() ?>>
<span id="el_salary_expenses_employee_id">
<span<?php echo $salary_expenses->employee_id->viewAttributes() ?>>
<?php echo $salary_expenses->employee_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->expense_type->Visible) { // expense_type ?>
	<tr id="r_expense_type">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_expense_type"><?php echo $salary_expenses->expense_type->caption() ?></span></td>
		<td data-name="expense_type"<?php echo $salary_expenses->expense_type->cellAttributes() ?>>
<span id="el_salary_expenses_expense_type">
<span<?php echo $salary_expenses->expense_type->viewAttributes() ?>>
<?php echo $salary_expenses->expense_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->basic_salary->Visible) { // basic_salary ?>
	<tr id="r_basic_salary">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_basic_salary"><?php echo $salary_expenses->basic_salary->caption() ?></span></td>
		<td data-name="basic_salary"<?php echo $salary_expenses->basic_salary->cellAttributes() ?>>
<span id="el_salary_expenses_basic_salary">
<span<?php echo $salary_expenses->basic_salary->viewAttributes() ?>>
<?php echo $salary_expenses->basic_salary->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->ded_add->Visible) { // ded_add ?>
	<tr id="r_ded_add">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_ded_add"><?php echo $salary_expenses->ded_add->caption() ?></span></td>
		<td data-name="ded_add"<?php echo $salary_expenses->ded_add->cellAttributes() ?>>
<span id="el_salary_expenses_ded_add">
<span<?php echo $salary_expenses->ded_add->viewAttributes() ?>>
<?php echo $salary_expenses->ded_add->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->final_amount->Visible) { // final_amount ?>
	<tr id="r_final_amount">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_final_amount"><?php echo $salary_expenses->final_amount->caption() ?></span></td>
		<td data-name="final_amount"<?php echo $salary_expenses->final_amount->cellAttributes() ?>>
<span id="el_salary_expenses_final_amount">
<span<?php echo $salary_expenses->final_amount->viewAttributes() ?>>
<?php echo $salary_expenses->final_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_dated"><?php echo $salary_expenses->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $salary_expenses->dated->cellAttributes() ?>>
<span id="el_salary_expenses_dated">
<span<?php echo $salary_expenses->dated->viewAttributes() ?>>
<?php echo $salary_expenses->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_remarks"><?php echo $salary_expenses->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $salary_expenses->remarks->cellAttributes() ?>>
<span id="el_salary_expenses_remarks">
<span<?php echo $salary_expenses->remarks->viewAttributes() ?>>
<?php echo $salary_expenses->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_uploads"><?php echo $salary_expenses->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $salary_expenses->uploads->cellAttributes() ?>>
<span id="el_salary_expenses_uploads">
<span>
<?php echo GetFileViewTag($salary_expenses->uploads, $salary_expenses->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_operator"><?php echo $salary_expenses->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $salary_expenses->operator->cellAttributes() ?>>
<span id="el_salary_expenses_operator">
<span<?php echo $salary_expenses->operator->viewAttributes() ?>>
<?php echo $salary_expenses->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_expenses->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $salary_expenses_view->TableLeftColumnClass ?>"><span id="elh_salary_expenses_datetime"><?php echo $salary_expenses->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $salary_expenses->datetime->cellAttributes() ?>>
<span id="el_salary_expenses_datetime">
<span<?php echo $salary_expenses->datetime->viewAttributes() ?>>
<?php echo $salary_expenses->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$salary_expenses_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$salary_expenses->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$salary_expenses_view->terminate();
?>