<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_payment_edit = new salary_payment_edit();

// Run the page
$salary_payment_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_payment_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsalary_paymentedit = currentForm = new ew.Form("fsalary_paymentedit", "edit");

// Validate form
fsalary_paymentedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($salary_payment_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_payment->id->caption(), $salary_payment->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($salary_payment->id->errorMessage()) ?>");
		<?php if ($salary_payment_edit->r_from->Required) { ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_payment->r_from->caption(), $salary_payment->r_from->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_r_from");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($salary_payment->r_from->errorMessage()) ?>");
		<?php if ($salary_payment_edit->r_to->Required) { ?>
			elm = this.getElements("x" + infix + "_r_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_payment->r_to->caption(), $salary_payment->r_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_payment_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_payment->amount->caption(), $salary_payment->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($salary_payment->amount->errorMessage()) ?>");
		<?php if ($salary_payment_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_payment->dated->caption(), $salary_payment->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($salary_payment->dated->errorMessage()) ?>");
		<?php if ($salary_payment_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_payment->remarks->caption(), $salary_payment->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_payment_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $salary_payment->uploads->caption(), $salary_payment->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_payment_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_payment->operator->caption(), $salary_payment->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($salary_payment_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $salary_payment->datetime->caption(), $salary_payment->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsalary_paymentedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_paymentedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_paymentedit.lists["x_r_from"] = <?php echo $salary_payment_edit->r_from->Lookup->toClientList() ?>;
fsalary_paymentedit.lists["x_r_from"].options = <?php echo JsonEncode($salary_payment_edit->r_from->lookupOptions()) ?>;
fsalary_paymentedit.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsalary_paymentedit.lists["x_r_to"] = <?php echo $salary_payment_edit->r_to->Lookup->toClientList() ?>;
fsalary_paymentedit.lists["x_r_to"].options = <?php echo JsonEncode($salary_payment_edit->r_to->lookupOptions()) ?>;
fsalary_paymentedit.autoSuggests["x_r_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsalary_paymentedit.lists["x_operator"] = <?php echo $salary_payment_edit->operator->Lookup->toClientList() ?>;
fsalary_paymentedit.lists["x_operator"].options = <?php echo JsonEncode($salary_payment_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $salary_payment_edit->showPageHeader(); ?>
<?php
$salary_payment_edit->showMessage();
?>
<form name="fsalary_paymentedit" id="fsalary_paymentedit" class="<?php echo $salary_payment_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_payment_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_payment_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_payment">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$salary_payment_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($salary_payment->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_salary_payment_id" for="x_id" class="<?php echo $salary_payment_edit->LeftColumnClass ?>"><?php echo $salary_payment->id->caption() ?><?php echo ($salary_payment->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_payment_edit->RightColumnClass ?>"><div<?php echo $salary_payment->id->cellAttributes() ?>>
<span id="el_salary_payment_id">
<span<?php echo $salary_payment->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($salary_payment->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="salary_payment" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($salary_payment->id->CurrentValue) ?>">
<?php echo $salary_payment->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label id="elh_salary_payment_r_from" class="<?php echo $salary_payment_edit->LeftColumnClass ?>"><?php echo $salary_payment->r_from->caption() ?><?php echo ($salary_payment->r_from->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_payment_edit->RightColumnClass ?>"><div<?php echo $salary_payment->r_from->cellAttributes() ?>>
<span id="el_salary_payment_r_from">
<?php
$wrkonchange = "" . trim(@$salary_payment->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$salary_payment->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($salary_payment->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($salary_payment->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($salary_payment->r_from->getPlaceHolder()) ?>"<?php echo $salary_payment->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($salary_payment->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($salary_payment->r_from->ReadOnly || $salary_payment->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="salary_payment" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $salary_payment->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($salary_payment->r_from->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fsalary_paymentedit.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $salary_payment->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
<?php echo $salary_payment->r_from->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->r_to->Visible) { // r_to ?>
	<div id="r_r_to" class="form-group row">
		<label id="elh_salary_payment_r_to" class="<?php echo $salary_payment_edit->LeftColumnClass ?>"><?php echo $salary_payment->r_to->caption() ?><?php echo ($salary_payment->r_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_payment_edit->RightColumnClass ?>"><div<?php echo $salary_payment->r_to->cellAttributes() ?>>
<span id="el_salary_payment_r_to">
<?php
$wrkonchange = "" . trim(@$salary_payment->r_to->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$salary_payment->r_to->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_to" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_to" id="sv_x_r_to" value="<?php echo RemoveHtml($salary_payment->r_to->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($salary_payment->r_to->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($salary_payment->r_to->getPlaceHolder()) ?>"<?php echo $salary_payment->r_to->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($salary_payment->r_to->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_to',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($salary_payment->r_to->ReadOnly || $salary_payment->r_to->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="salary_payment" data-field="x_r_to" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $salary_payment->r_to->displayValueSeparatorAttribute() ?>" name="x_r_to" id="x_r_to" value="<?php echo HtmlEncode($salary_payment->r_to->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fsalary_paymentedit.createAutoSuggest({"id":"x_r_to","forceSelect":true});
</script>
<?php echo $salary_payment->r_to->Lookup->getParamTag("p_x_r_to") ?>
</span>
<?php echo $salary_payment->r_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_salary_payment_amount" for="x_amount" class="<?php echo $salary_payment_edit->LeftColumnClass ?>"><?php echo $salary_payment->amount->caption() ?><?php echo ($salary_payment->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_payment_edit->RightColumnClass ?>"><div<?php echo $salary_payment->amount->cellAttributes() ?>>
<span id="el_salary_payment_amount">
<input type="text" data-table="salary_payment" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($salary_payment->amount->getPlaceHolder()) ?>" value="<?php echo $salary_payment->amount->EditValue ?>"<?php echo $salary_payment->amount->editAttributes() ?>>
</span>
<?php echo $salary_payment->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_salary_payment_dated" for="x_dated" class="<?php echo $salary_payment_edit->LeftColumnClass ?>"><?php echo $salary_payment->dated->caption() ?><?php echo ($salary_payment->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_payment_edit->RightColumnClass ?>"><div<?php echo $salary_payment->dated->cellAttributes() ?>>
<span id="el_salary_payment_dated">
<input type="text" data-table="salary_payment" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($salary_payment->dated->getPlaceHolder()) ?>" value="<?php echo $salary_payment->dated->EditValue ?>"<?php echo $salary_payment->dated->editAttributes() ?>>
<?php if (!$salary_payment->dated->ReadOnly && !$salary_payment->dated->Disabled && !isset($salary_payment->dated->EditAttrs["readonly"]) && !isset($salary_payment->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsalary_paymentedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $salary_payment->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_salary_payment_remarks" for="x_remarks" class="<?php echo $salary_payment_edit->LeftColumnClass ?>"><?php echo $salary_payment->remarks->caption() ?><?php echo ($salary_payment->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_payment_edit->RightColumnClass ?>"><div<?php echo $salary_payment->remarks->cellAttributes() ?>>
<span id="el_salary_payment_remarks">
<input type="text" data-table="salary_payment" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($salary_payment->remarks->getPlaceHolder()) ?>" value="<?php echo $salary_payment->remarks->EditValue ?>"<?php echo $salary_payment->remarks->editAttributes() ?>>
</span>
<?php echo $salary_payment->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_salary_payment_uploads" class="<?php echo $salary_payment_edit->LeftColumnClass ?>"><?php echo $salary_payment->uploads->caption() ?><?php echo ($salary_payment->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $salary_payment_edit->RightColumnClass ?>"><div<?php echo $salary_payment->uploads->cellAttributes() ?>>
<span id="el_salary_payment_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $salary_payment->uploads->title() ? $salary_payment->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($salary_payment->uploads->ReadOnly || $salary_payment->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="salary_payment" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $salary_payment->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $salary_payment->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $salary_payment->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $salary_payment->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $salary_payment->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $salary_payment->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$salary_payment_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $salary_payment_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $salary_payment_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$salary_payment_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$salary_payment_edit->terminate();
?>