<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_payment_list = new salary_payment_list();

// Run the page
$salary_payment_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_payment_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$salary_payment->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsalary_paymentlist = currentForm = new ew.Form("fsalary_paymentlist", "list");
fsalary_paymentlist.formKeyCountName = '<?php echo $salary_payment_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsalary_paymentlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_paymentlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_paymentlist.lists["x_r_from"] = <?php echo $salary_payment_list->r_from->Lookup->toClientList() ?>;
fsalary_paymentlist.lists["x_r_from"].options = <?php echo JsonEncode($salary_payment_list->r_from->lookupOptions()) ?>;
fsalary_paymentlist.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsalary_paymentlist.lists["x_r_to"] = <?php echo $salary_payment_list->r_to->Lookup->toClientList() ?>;
fsalary_paymentlist.lists["x_r_to"].options = <?php echo JsonEncode($salary_payment_list->r_to->lookupOptions()) ?>;
fsalary_paymentlist.autoSuggests["x_r_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsalary_paymentlist.lists["x_operator"] = <?php echo $salary_payment_list->operator->Lookup->toClientList() ?>;
fsalary_paymentlist.lists["x_operator"].options = <?php echo JsonEncode($salary_payment_list->operator->lookupOptions()) ?>;

// Form object for search
var fsalary_paymentlistsrch = currentSearchForm = new ew.Form("fsalary_paymentlistsrch");

// Filters
fsalary_paymentlistsrch.filterList = <?php echo $salary_payment_list->getFilterList() ?>;

// Init search panel as collapsed
fsalary_paymentlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$salary_payment->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($salary_payment_list->TotalRecs > 0 && $salary_payment_list->ExportOptions->visible()) { ?>
<?php $salary_payment_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($salary_payment_list->ImportOptions->visible()) { ?>
<?php $salary_payment_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($salary_payment_list->SearchOptions->visible()) { ?>
<?php $salary_payment_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($salary_payment_list->FilterOptions->visible()) { ?>
<?php $salary_payment_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$salary_payment_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$salary_payment->isExport() && !$salary_payment->CurrentAction) { ?>
<form name="fsalary_paymentlistsrch" id="fsalary_paymentlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($salary_payment_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsalary_paymentlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="salary_payment">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($salary_payment_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($salary_payment_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $salary_payment_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($salary_payment_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($salary_payment_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($salary_payment_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($salary_payment_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $salary_payment_list->showPageHeader(); ?>
<?php
$salary_payment_list->showMessage();
?>
<?php if ($salary_payment_list->TotalRecs > 0 || $salary_payment->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($salary_payment_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> salary_payment">
<?php if (!$salary_payment->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$salary_payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($salary_payment_list->Pager)) $salary_payment_list->Pager = new PrevNextPager($salary_payment_list->StartRec, $salary_payment_list->DisplayRecs, $salary_payment_list->TotalRecs, $salary_payment_list->AutoHidePager) ?>
<?php if ($salary_payment_list->Pager->RecordCount > 0 && $salary_payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($salary_payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $salary_payment_list->pageUrl() ?>start=<?php echo $salary_payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($salary_payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $salary_payment_list->pageUrl() ?>start=<?php echo $salary_payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $salary_payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($salary_payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $salary_payment_list->pageUrl() ?>start=<?php echo $salary_payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($salary_payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $salary_payment_list->pageUrl() ?>start=<?php echo $salary_payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $salary_payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($salary_payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $salary_payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $salary_payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $salary_payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($salary_payment_list->TotalRecs > 0 && (!$salary_payment_list->AutoHidePageSizeSelector || $salary_payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="salary_payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($salary_payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($salary_payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($salary_payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($salary_payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($salary_payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($salary_payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $salary_payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsalary_paymentlist" id="fsalary_paymentlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_payment_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_payment_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_payment">
<div id="gmp_salary_payment" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($salary_payment_list->TotalRecs > 0 || $salary_payment->isGridEdit()) { ?>
<table id="tbl_salary_paymentlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$salary_payment_list->RowType = ROWTYPE_HEADER;

// Render list options
$salary_payment_list->renderListOptions();

// Render list options (header, left)
$salary_payment_list->ListOptions->render("header", "left");
?>
<?php if ($salary_payment->id->Visible) { // id ?>
	<?php if ($salary_payment->sortUrl($salary_payment->id) == "") { ?>
		<th data-name="id" class="<?php echo $salary_payment->id->headerCellClass() ?>"><div id="elh_salary_payment_id" class="salary_payment_id"><div class="ew-table-header-caption"><?php echo $salary_payment->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $salary_payment->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->id) ?>',2);"><div id="elh_salary_payment_id" class="salary_payment_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_payment->r_from->Visible) { // r_from ?>
	<?php if ($salary_payment->sortUrl($salary_payment->r_from) == "") { ?>
		<th data-name="r_from" class="<?php echo $salary_payment->r_from->headerCellClass() ?>"><div id="elh_salary_payment_r_from" class="salary_payment_r_from"><div class="ew-table-header-caption"><?php echo $salary_payment->r_from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_from" class="<?php echo $salary_payment->r_from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->r_from) ?>',2);"><div id="elh_salary_payment_r_from" class="salary_payment_r_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->r_from->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->r_from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->r_from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_payment->r_to->Visible) { // r_to ?>
	<?php if ($salary_payment->sortUrl($salary_payment->r_to) == "") { ?>
		<th data-name="r_to" class="<?php echo $salary_payment->r_to->headerCellClass() ?>"><div id="elh_salary_payment_r_to" class="salary_payment_r_to"><div class="ew-table-header-caption"><?php echo $salary_payment->r_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_to" class="<?php echo $salary_payment->r_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->r_to) ?>',2);"><div id="elh_salary_payment_r_to" class="salary_payment_r_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->r_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->r_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->r_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_payment->amount->Visible) { // amount ?>
	<?php if ($salary_payment->sortUrl($salary_payment->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $salary_payment->amount->headerCellClass() ?>"><div id="elh_salary_payment_amount" class="salary_payment_amount"><div class="ew-table-header-caption"><?php echo $salary_payment->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $salary_payment->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->amount) ?>',2);"><div id="elh_salary_payment_amount" class="salary_payment_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_payment->dated->Visible) { // dated ?>
	<?php if ($salary_payment->sortUrl($salary_payment->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $salary_payment->dated->headerCellClass() ?>"><div id="elh_salary_payment_dated" class="salary_payment_dated"><div class="ew-table-header-caption"><?php echo $salary_payment->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $salary_payment->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->dated) ?>',2);"><div id="elh_salary_payment_dated" class="salary_payment_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_payment->remarks->Visible) { // remarks ?>
	<?php if ($salary_payment->sortUrl($salary_payment->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $salary_payment->remarks->headerCellClass() ?>"><div id="elh_salary_payment_remarks" class="salary_payment_remarks"><div class="ew-table-header-caption"><?php echo $salary_payment->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $salary_payment->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->remarks) ?>',2);"><div id="elh_salary_payment_remarks" class="salary_payment_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_payment->uploads->Visible) { // uploads ?>
	<?php if ($salary_payment->sortUrl($salary_payment->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $salary_payment->uploads->headerCellClass() ?>"><div id="elh_salary_payment_uploads" class="salary_payment_uploads"><div class="ew-table-header-caption"><?php echo $salary_payment->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $salary_payment->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->uploads) ?>',2);"><div id="elh_salary_payment_uploads" class="salary_payment_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_payment->operator->Visible) { // operator ?>
	<?php if ($salary_payment->sortUrl($salary_payment->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $salary_payment->operator->headerCellClass() ?>"><div id="elh_salary_payment_operator" class="salary_payment_operator"><div class="ew-table-header-caption"><?php echo $salary_payment->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $salary_payment->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->operator) ?>',2);"><div id="elh_salary_payment_operator" class="salary_payment_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($salary_payment->datetime->Visible) { // datetime ?>
	<?php if ($salary_payment->sortUrl($salary_payment->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $salary_payment->datetime->headerCellClass() ?>"><div id="elh_salary_payment_datetime" class="salary_payment_datetime"><div class="ew-table-header-caption"><?php echo $salary_payment->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $salary_payment->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $salary_payment->SortUrl($salary_payment->datetime) ?>',2);"><div id="elh_salary_payment_datetime" class="salary_payment_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $salary_payment->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($salary_payment->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($salary_payment->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$salary_payment_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($salary_payment->ExportAll && $salary_payment->isExport()) {
	$salary_payment_list->StopRec = $salary_payment_list->TotalRecs;
} else {

	// Set the last record to display
	if ($salary_payment_list->TotalRecs > $salary_payment_list->StartRec + $salary_payment_list->DisplayRecs - 1)
		$salary_payment_list->StopRec = $salary_payment_list->StartRec + $salary_payment_list->DisplayRecs - 1;
	else
		$salary_payment_list->StopRec = $salary_payment_list->TotalRecs;
}
$salary_payment_list->RecCnt = $salary_payment_list->StartRec - 1;
if ($salary_payment_list->Recordset && !$salary_payment_list->Recordset->EOF) {
	$salary_payment_list->Recordset->moveFirst();
	$selectLimit = $salary_payment_list->UseSelectLimit;
	if (!$selectLimit && $salary_payment_list->StartRec > 1)
		$salary_payment_list->Recordset->move($salary_payment_list->StartRec - 1);
} elseif (!$salary_payment->AllowAddDeleteRow && $salary_payment_list->StopRec == 0) {
	$salary_payment_list->StopRec = $salary_payment->GridAddRowCount;
}

// Initialize aggregate
$salary_payment->RowType = ROWTYPE_AGGREGATEINIT;
$salary_payment->resetAttributes();
$salary_payment_list->renderRow();
while ($salary_payment_list->RecCnt < $salary_payment_list->StopRec) {
	$salary_payment_list->RecCnt++;
	if ($salary_payment_list->RecCnt >= $salary_payment_list->StartRec) {
		$salary_payment_list->RowCnt++;

		// Set up key count
		$salary_payment_list->KeyCount = $salary_payment_list->RowIndex;

		// Init row class and style
		$salary_payment->resetAttributes();
		$salary_payment->CssClass = "";
		if ($salary_payment->isGridAdd()) {
		} else {
			$salary_payment_list->loadRowValues($salary_payment_list->Recordset); // Load row values
		}
		$salary_payment->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$salary_payment->RowAttrs = array_merge($salary_payment->RowAttrs, array('data-rowindex'=>$salary_payment_list->RowCnt, 'id'=>'r' . $salary_payment_list->RowCnt . '_salary_payment', 'data-rowtype'=>$salary_payment->RowType));

		// Render row
		$salary_payment_list->renderRow();

		// Render list options
		$salary_payment_list->renderListOptions();
?>
	<tr<?php echo $salary_payment->rowAttributes() ?>>
<?php

// Render list options (body, left)
$salary_payment_list->ListOptions->render("body", "left", $salary_payment_list->RowCnt);
?>
	<?php if ($salary_payment->id->Visible) { // id ?>
		<td data-name="id"<?php echo $salary_payment->id->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_id" class="salary_payment_id">
<span<?php echo $salary_payment->id->viewAttributes() ?>>
<?php echo $salary_payment->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_payment->r_from->Visible) { // r_from ?>
		<td data-name="r_from"<?php echo $salary_payment->r_from->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_r_from" class="salary_payment_r_from">
<span<?php echo $salary_payment->r_from->viewAttributes() ?>>
<?php echo $salary_payment->r_from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_payment->r_to->Visible) { // r_to ?>
		<td data-name="r_to"<?php echo $salary_payment->r_to->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_r_to" class="salary_payment_r_to">
<span<?php echo $salary_payment->r_to->viewAttributes() ?>>
<?php echo $salary_payment->r_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_payment->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $salary_payment->amount->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_amount" class="salary_payment_amount">
<span<?php echo $salary_payment->amount->viewAttributes() ?>>
<?php echo $salary_payment->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_payment->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $salary_payment->dated->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_dated" class="salary_payment_dated">
<span<?php echo $salary_payment->dated->viewAttributes() ?>>
<?php echo $salary_payment->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_payment->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $salary_payment->remarks->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_remarks" class="salary_payment_remarks">
<span<?php echo $salary_payment->remarks->viewAttributes() ?>>
<?php echo $salary_payment->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_payment->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $salary_payment->uploads->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_uploads" class="salary_payment_uploads">
<span>
<?php echo GetFileViewTag($salary_payment->uploads, $salary_payment->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_payment->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $salary_payment->operator->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_operator" class="salary_payment_operator">
<span<?php echo $salary_payment->operator->viewAttributes() ?>>
<?php echo $salary_payment->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($salary_payment->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $salary_payment->datetime->cellAttributes() ?>>
<span id="el<?php echo $salary_payment_list->RowCnt ?>_salary_payment_datetime" class="salary_payment_datetime">
<span<?php echo $salary_payment->datetime->viewAttributes() ?>>
<?php echo $salary_payment->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$salary_payment_list->ListOptions->render("body", "right", $salary_payment_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$salary_payment->isGridAdd())
		$salary_payment_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$salary_payment->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($salary_payment_list->Recordset)
	$salary_payment_list->Recordset->Close();
?>
<?php if (!$salary_payment->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$salary_payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($salary_payment_list->Pager)) $salary_payment_list->Pager = new PrevNextPager($salary_payment_list->StartRec, $salary_payment_list->DisplayRecs, $salary_payment_list->TotalRecs, $salary_payment_list->AutoHidePager) ?>
<?php if ($salary_payment_list->Pager->RecordCount > 0 && $salary_payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($salary_payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $salary_payment_list->pageUrl() ?>start=<?php echo $salary_payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($salary_payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $salary_payment_list->pageUrl() ?>start=<?php echo $salary_payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $salary_payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($salary_payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $salary_payment_list->pageUrl() ?>start=<?php echo $salary_payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($salary_payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $salary_payment_list->pageUrl() ?>start=<?php echo $salary_payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $salary_payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($salary_payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $salary_payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $salary_payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $salary_payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($salary_payment_list->TotalRecs > 0 && (!$salary_payment_list->AutoHidePageSizeSelector || $salary_payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="salary_payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($salary_payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($salary_payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($salary_payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($salary_payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($salary_payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($salary_payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $salary_payment_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($salary_payment_list->TotalRecs == 0 && !$salary_payment->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $salary_payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$salary_payment_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$salary_payment->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$salary_payment->isExport()) { ?>
<script>
ew.scrollableTable("gmp_salary_payment", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$salary_payment_list->terminate();
?>