<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_payment_search = new salary_payment_search();

// Run the page
$salary_payment_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_payment_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($salary_payment_search->IsModal) { ?>
var fsalary_paymentsearch = currentAdvancedSearchForm = new ew.Form("fsalary_paymentsearch", "search");
<?php } else { ?>
var fsalary_paymentsearch = currentForm = new ew.Form("fsalary_paymentsearch", "search");
<?php } ?>

// Form_CustomValidate event
fsalary_paymentsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_paymentsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_paymentsearch.lists["x_r_from"] = <?php echo $salary_payment_search->r_from->Lookup->toClientList() ?>;
fsalary_paymentsearch.lists["x_r_from"].options = <?php echo JsonEncode($salary_payment_search->r_from->lookupOptions()) ?>;
fsalary_paymentsearch.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsalary_paymentsearch.lists["x_operator"] = <?php echo $salary_payment_search->operator->Lookup->toClientList() ?>;
fsalary_paymentsearch.lists["x_operator"].options = <?php echo JsonEncode($salary_payment_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fsalary_paymentsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_payment->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_from");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_payment->r_from->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_payment->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_payment->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($salary_payment->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $salary_payment_search->showPageHeader(); ?>
<?php
$salary_payment_search->showMessage();
?>
<form name="fsalary_paymentsearch" id="fsalary_paymentsearch" class="<?php echo $salary_payment_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_payment_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_payment_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_payment">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$salary_payment_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($salary_payment->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $salary_payment_search->LeftColumnClass ?>"><span id="elh_salary_payment_id"><?php echo $salary_payment->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $salary_payment_search->RightColumnClass ?>"><div<?php echo $salary_payment->id->cellAttributes() ?>>
			<span id="el_salary_payment_id">
<input type="text" data-table="salary_payment" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($salary_payment->id->getPlaceHolder()) ?>" value="<?php echo $salary_payment->id->EditValue ?>"<?php echo $salary_payment->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->r_from->Visible) { // r_from ?>
	<div id="r_r_from" class="form-group row">
		<label class="<?php echo $salary_payment_search->LeftColumnClass ?>"><span id="elh_salary_payment_r_from"><?php echo $salary_payment->r_from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_from" id="z_r_from" value="="></span>
		</label>
		<div class="<?php echo $salary_payment_search->RightColumnClass ?>"><div<?php echo $salary_payment->r_from->cellAttributes() ?>>
			<span id="el_salary_payment_r_from">
<?php
$wrkonchange = "" . trim(@$salary_payment->r_from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$salary_payment->r_from->EditAttrs["onchange"] = "";
?>
<span id="as_x_r_from" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_r_from" id="sv_x_r_from" value="<?php echo RemoveHtml($salary_payment->r_from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($salary_payment->r_from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($salary_payment->r_from->getPlaceHolder()) ?>"<?php echo $salary_payment->r_from->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($salary_payment->r_from->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_r_from',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($salary_payment->r_from->ReadOnly || $salary_payment->r_from->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="salary_payment" data-field="x_r_from" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $salary_payment->r_from->displayValueSeparatorAttribute() ?>" name="x_r_from" id="x_r_from" value="<?php echo HtmlEncode($salary_payment->r_from->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fsalary_paymentsearch.createAutoSuggest({"id":"x_r_from","forceSelect":true});
</script>
<?php echo $salary_payment->r_from->Lookup->getParamTag("p_x_r_from") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $salary_payment_search->LeftColumnClass ?>"><span id="elh_salary_payment_amount"><?php echo $salary_payment->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $salary_payment_search->RightColumnClass ?>"><div<?php echo $salary_payment->amount->cellAttributes() ?>>
			<span id="el_salary_payment_amount">
<input type="text" data-table="salary_payment" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($salary_payment->amount->getPlaceHolder()) ?>" value="<?php echo $salary_payment->amount->EditValue ?>"<?php echo $salary_payment->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $salary_payment_search->LeftColumnClass ?>"><span id="elh_salary_payment_dated"><?php echo $salary_payment->dated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dated" id="z_dated" value="="></span>
		</label>
		<div class="<?php echo $salary_payment_search->RightColumnClass ?>"><div<?php echo $salary_payment->dated->cellAttributes() ?>>
			<span id="el_salary_payment_dated">
<input type="text" data-table="salary_payment" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($salary_payment->dated->getPlaceHolder()) ?>" value="<?php echo $salary_payment->dated->EditValue ?>"<?php echo $salary_payment->dated->editAttributes() ?>>
<?php if (!$salary_payment->dated->ReadOnly && !$salary_payment->dated->Disabled && !isset($salary_payment->dated->EditAttrs["readonly"]) && !isset($salary_payment->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsalary_paymentsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $salary_payment_search->LeftColumnClass ?>"><span id="elh_salary_payment_remarks"><?php echo $salary_payment->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $salary_payment_search->RightColumnClass ?>"><div<?php echo $salary_payment->remarks->cellAttributes() ?>>
			<span id="el_salary_payment_remarks">
<input type="text" data-table="salary_payment" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($salary_payment->remarks->getPlaceHolder()) ?>" value="<?php echo $salary_payment->remarks->EditValue ?>"<?php echo $salary_payment->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $salary_payment_search->LeftColumnClass ?>"><span id="elh_salary_payment_uploads"><?php echo $salary_payment->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $salary_payment_search->RightColumnClass ?>"><div<?php echo $salary_payment->uploads->cellAttributes() ?>>
			<span id="el_salary_payment_uploads">
<input type="text" data-table="salary_payment" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($salary_payment->uploads->getPlaceHolder()) ?>" value="<?php echo $salary_payment->uploads->EditValue ?>"<?php echo $salary_payment->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $salary_payment_search->LeftColumnClass ?>"><span id="elh_salary_payment_operator"><?php echo $salary_payment->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $salary_payment_search->RightColumnClass ?>"><div<?php echo $salary_payment->operator->cellAttributes() ?>>
			<span id="el_salary_payment_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="salary_payment" data-field="x_operator" data-value-separator="<?php echo $salary_payment->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $salary_payment->operator->editAttributes() ?>>
		<?php echo $salary_payment->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $salary_payment->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($salary_payment->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $salary_payment_search->LeftColumnClass ?>"><span id="elh_salary_payment_datetime"><?php echo $salary_payment->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $salary_payment_search->RightColumnClass ?>"><div<?php echo $salary_payment->datetime->cellAttributes() ?>>
			<span id="el_salary_payment_datetime">
<input type="text" data-table="salary_payment" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($salary_payment->datetime->getPlaceHolder()) ?>" value="<?php echo $salary_payment->datetime->EditValue ?>"<?php echo $salary_payment->datetime->editAttributes() ?>>
<?php if (!$salary_payment->datetime->ReadOnly && !$salary_payment->datetime->Disabled && !isset($salary_payment->datetime->EditAttrs["readonly"]) && !isset($salary_payment->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fsalary_paymentsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$salary_payment_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $salary_payment_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$salary_payment_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$salary_payment_search->terminate();
?>