<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$salary_payment_view = new salary_payment_view();

// Run the page
$salary_payment_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$salary_payment_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$salary_payment->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fsalary_paymentview = currentForm = new ew.Form("fsalary_paymentview", "view");

// Form_CustomValidate event
fsalary_paymentview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsalary_paymentview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsalary_paymentview.lists["x_r_from"] = <?php echo $salary_payment_view->r_from->Lookup->toClientList() ?>;
fsalary_paymentview.lists["x_r_from"].options = <?php echo JsonEncode($salary_payment_view->r_from->lookupOptions()) ?>;
fsalary_paymentview.autoSuggests["x_r_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsalary_paymentview.lists["x_r_to"] = <?php echo $salary_payment_view->r_to->Lookup->toClientList() ?>;
fsalary_paymentview.lists["x_r_to"].options = <?php echo JsonEncode($salary_payment_view->r_to->lookupOptions()) ?>;
fsalary_paymentview.autoSuggests["x_r_to"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fsalary_paymentview.lists["x_operator"] = <?php echo $salary_payment_view->operator->Lookup->toClientList() ?>;
fsalary_paymentview.lists["x_operator"].options = <?php echo JsonEncode($salary_payment_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$salary_payment->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $salary_payment_view->ExportOptions->render("body") ?>
<?php $salary_payment_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $salary_payment_view->showPageHeader(); ?>
<?php
$salary_payment_view->showMessage();
?>
<form name="fsalary_paymentview" id="fsalary_paymentview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($salary_payment_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $salary_payment_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="salary_payment">
<input type="hidden" name="modal" value="<?php echo (int)$salary_payment_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($salary_payment->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_id"><?php echo $salary_payment->id->caption() ?></span></td>
		<td data-name="id"<?php echo $salary_payment->id->cellAttributes() ?>>
<span id="el_salary_payment_id">
<span<?php echo $salary_payment->id->viewAttributes() ?>>
<?php echo $salary_payment->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_payment->r_from->Visible) { // r_from ?>
	<tr id="r_r_from">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_r_from"><?php echo $salary_payment->r_from->caption() ?></span></td>
		<td data-name="r_from"<?php echo $salary_payment->r_from->cellAttributes() ?>>
<span id="el_salary_payment_r_from">
<span<?php echo $salary_payment->r_from->viewAttributes() ?>>
<?php echo $salary_payment->r_from->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_payment->r_to->Visible) { // r_to ?>
	<tr id="r_r_to">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_r_to"><?php echo $salary_payment->r_to->caption() ?></span></td>
		<td data-name="r_to"<?php echo $salary_payment->r_to->cellAttributes() ?>>
<span id="el_salary_payment_r_to">
<span<?php echo $salary_payment->r_to->viewAttributes() ?>>
<?php echo $salary_payment->r_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_payment->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_amount"><?php echo $salary_payment->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $salary_payment->amount->cellAttributes() ?>>
<span id="el_salary_payment_amount">
<span<?php echo $salary_payment->amount->viewAttributes() ?>>
<?php echo $salary_payment->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_payment->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_dated"><?php echo $salary_payment->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $salary_payment->dated->cellAttributes() ?>>
<span id="el_salary_payment_dated">
<span<?php echo $salary_payment->dated->viewAttributes() ?>>
<?php echo $salary_payment->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_payment->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_remarks"><?php echo $salary_payment->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $salary_payment->remarks->cellAttributes() ?>>
<span id="el_salary_payment_remarks">
<span<?php echo $salary_payment->remarks->viewAttributes() ?>>
<?php echo $salary_payment->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_payment->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_uploads"><?php echo $salary_payment->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $salary_payment->uploads->cellAttributes() ?>>
<span id="el_salary_payment_uploads">
<span>
<?php echo GetFileViewTag($salary_payment->uploads, $salary_payment->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_payment->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_operator"><?php echo $salary_payment->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $salary_payment->operator->cellAttributes() ?>>
<span id="el_salary_payment_operator">
<span<?php echo $salary_payment->operator->viewAttributes() ?>>
<?php echo $salary_payment->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($salary_payment->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $salary_payment_view->TableLeftColumnClass ?>"><span id="elh_salary_payment_datetime"><?php echo $salary_payment->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $salary_payment->datetime->cellAttributes() ?>>
<span id="el_salary_payment_datetime">
<span<?php echo $salary_payment->datetime->viewAttributes() ?>>
<?php echo $salary_payment->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$salary_payment_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$salary_payment->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$salary_payment_view->terminate();
?>