<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($sales_ref_grid))
	$sales_ref_grid = new sales_ref_grid();

// Run the page
$sales_ref_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sales_ref_grid->Page_Render();
?>
<?php if (!$sales_ref->isExport()) { ?>
<script>

// Form object
var fsales_refgrid = new ew.Form("fsales_refgrid", "grid");
fsales_refgrid.formKeyCountName = '<?php echo $sales_ref_grid->FormKeyCountName ?>';

// Validate form
fsales_refgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($sales_ref_grid->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->grp->caption(), $sales_ref->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sales_ref_grid->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->s_grp->caption(), $sales_ref->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sales_ref_grid->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->product->caption(), $sales_ref->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sales_ref_grid->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->rid->caption(), $sales_ref->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sales_ref_grid->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->packets->caption(), $sales_ref->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sales_ref->packets->errorMessage()) ?>");
		<?php if ($sales_ref_grid->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->quantity->caption(), $sales_ref->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sales_ref->quantity->errorMessage()) ?>");
		<?php if ($sales_ref_grid->_40->Required) { ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->_40->caption(), $sales_ref->_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sales_ref->_40->errorMessage()) ?>");
		<?php if ($sales_ref_grid->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->amount->caption(), $sales_ref->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($sales_ref->amount->errorMessage()) ?>");
		<?php if ($sales_ref_grid->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sales_ref->godown->caption(), $sales_ref->godown->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fsales_refgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "grp", false)) return false;
	if (ew.valueChanged(fobj, infix, "s_grp", false)) return false;
	if (ew.valueChanged(fobj, infix, "product", false)) return false;
	if (ew.valueChanged(fobj, infix, "rid", false)) return false;
	if (ew.valueChanged(fobj, infix, "packets", false)) return false;
	if (ew.valueChanged(fobj, infix, "quantity", false)) return false;
	if (ew.valueChanged(fobj, infix, "_40", false)) return false;
	if (ew.valueChanged(fobj, infix, "amount", false)) return false;
	if (ew.valueChanged(fobj, infix, "godown", false)) return false;
	return true;
}

// Form_CustomValidate event
fsales_refgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsales_refgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsales_refgrid.lists["x_grp"] = <?php echo $sales_ref_grid->grp->Lookup->toClientList() ?>;
fsales_refgrid.lists["x_grp"].options = <?php echo JsonEncode($sales_ref_grid->grp->lookupOptions()) ?>;
fsales_refgrid.lists["x_s_grp"] = <?php echo $sales_ref_grid->s_grp->Lookup->toClientList() ?>;
fsales_refgrid.lists["x_s_grp"].options = <?php echo JsonEncode($sales_ref_grid->s_grp->lookupOptions()) ?>;
fsales_refgrid.lists["x_product"] = <?php echo $sales_ref_grid->product->Lookup->toClientList() ?>;
fsales_refgrid.lists["x_product"].options = <?php echo JsonEncode($sales_ref_grid->product->lookupOptions()) ?>;
fsales_refgrid.lists["x_rid"] = <?php echo $sales_ref_grid->rid->Lookup->toClientList() ?>;
fsales_refgrid.lists["x_rid"].options = <?php echo JsonEncode($sales_ref_grid->rid->lookupOptions()) ?>;
fsales_refgrid.lists["x_godown"] = <?php echo $sales_ref_grid->godown->Lookup->toClientList() ?>;
fsales_refgrid.lists["x_godown"].options = <?php echo JsonEncode($sales_ref_grid->godown->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$sales_ref_grid->renderOtherOptions();
?>
<?php $sales_ref_grid->showPageHeader(); ?>
<?php
$sales_ref_grid->showMessage();
?>
<?php if ($sales_ref_grid->TotalRecs > 0 || $sales_ref->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sales_ref_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sales_ref">
<?php if ($sales_ref_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $sales_ref_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fsales_refgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_sales_ref" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_sales_refgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sales_ref_grid->RowType = ROWTYPE_HEADER;

// Render list options
$sales_ref_grid->renderListOptions();

// Render list options (header, left)
$sales_ref_grid->ListOptions->render("header", "left");
?>
<?php if ($sales_ref->grp->Visible) { // grp ?>
	<?php if ($sales_ref->sortUrl($sales_ref->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $sales_ref->grp->headerCellClass() ?>"><div id="elh_sales_ref_grp" class="sales_ref_grp"><div class="ew-table-header-caption"><?php echo $sales_ref->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $sales_ref->grp->headerCellClass() ?>"><div><div id="elh_sales_ref_grp" class="sales_ref_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
	<?php if ($sales_ref->sortUrl($sales_ref->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $sales_ref->s_grp->headerCellClass() ?>"><div id="elh_sales_ref_s_grp" class="sales_ref_s_grp"><div class="ew-table-header-caption"><?php echo $sales_ref->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $sales_ref->s_grp->headerCellClass() ?>"><div><div id="elh_sales_ref_s_grp" class="sales_ref_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->product->Visible) { // product ?>
	<?php if ($sales_ref->sortUrl($sales_ref->product) == "") { ?>
		<th data-name="product" class="<?php echo $sales_ref->product->headerCellClass() ?>"><div id="elh_sales_ref_product" class="sales_ref_product"><div class="ew-table-header-caption"><?php echo $sales_ref->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $sales_ref->product->headerCellClass() ?>"><div><div id="elh_sales_ref_product" class="sales_ref_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->rid->Visible) { // rid ?>
	<?php if ($sales_ref->sortUrl($sales_ref->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $sales_ref->rid->headerCellClass() ?>"><div id="elh_sales_ref_rid" class="sales_ref_rid"><div class="ew-table-header-caption"><?php echo $sales_ref->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $sales_ref->rid->headerCellClass() ?>"><div><div id="elh_sales_ref_rid" class="sales_ref_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->packets->Visible) { // packets ?>
	<?php if ($sales_ref->sortUrl($sales_ref->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $sales_ref->packets->headerCellClass() ?>"><div id="elh_sales_ref_packets" class="sales_ref_packets"><div class="ew-table-header-caption"><?php echo $sales_ref->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $sales_ref->packets->headerCellClass() ?>"><div><div id="elh_sales_ref_packets" class="sales_ref_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->quantity->Visible) { // quantity ?>
	<?php if ($sales_ref->sortUrl($sales_ref->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $sales_ref->quantity->headerCellClass() ?>"><div id="elh_sales_ref_quantity" class="sales_ref_quantity"><div class="ew-table-header-caption"><?php echo $sales_ref->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $sales_ref->quantity->headerCellClass() ?>"><div><div id="elh_sales_ref_quantity" class="sales_ref_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->_40->Visible) { // @ ?>
	<?php if ($sales_ref->sortUrl($sales_ref->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $sales_ref->_40->headerCellClass() ?>"><div id="elh_sales_ref__40" class="sales_ref__40"><div class="ew-table-header-caption"><?php echo $sales_ref->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $sales_ref->_40->headerCellClass() ?>"><div><div id="elh_sales_ref__40" class="sales_ref__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->amount->Visible) { // amount ?>
	<?php if ($sales_ref->sortUrl($sales_ref->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $sales_ref->amount->headerCellClass() ?>"><div id="elh_sales_ref_amount" class="sales_ref_amount"><div class="ew-table-header-caption"><?php echo $sales_ref->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $sales_ref->amount->headerCellClass() ?>"><div><div id="elh_sales_ref_amount" class="sales_ref_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->godown->Visible) { // godown ?>
	<?php if ($sales_ref->sortUrl($sales_ref->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $sales_ref->godown->headerCellClass() ?>"><div id="elh_sales_ref_godown" class="sales_ref_godown"><div class="ew-table-header-caption"><?php echo $sales_ref->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $sales_ref->godown->headerCellClass() ?>"><div><div id="elh_sales_ref_godown" class="sales_ref_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sales_ref_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$sales_ref_grid->StartRec = 1;
$sales_ref_grid->StopRec = $sales_ref_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $sales_ref_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($sales_ref_grid->FormKeyCountName) && ($sales_ref->isGridAdd() || $sales_ref->isGridEdit() || $sales_ref->isConfirm())) {
		$sales_ref_grid->KeyCount = $CurrentForm->getValue($sales_ref_grid->FormKeyCountName);
		$sales_ref_grid->StopRec = $sales_ref_grid->StartRec + $sales_ref_grid->KeyCount - 1;
	}
}
$sales_ref_grid->RecCnt = $sales_ref_grid->StartRec - 1;
if ($sales_ref_grid->Recordset && !$sales_ref_grid->Recordset->EOF) {
	$sales_ref_grid->Recordset->moveFirst();
	$selectLimit = $sales_ref_grid->UseSelectLimit;
	if (!$selectLimit && $sales_ref_grid->StartRec > 1)
		$sales_ref_grid->Recordset->move($sales_ref_grid->StartRec - 1);
} elseif (!$sales_ref->AllowAddDeleteRow && $sales_ref_grid->StopRec == 0) {
	$sales_ref_grid->StopRec = $sales_ref->GridAddRowCount;
}

// Initialize aggregate
$sales_ref->RowType = ROWTYPE_AGGREGATEINIT;
$sales_ref->resetAttributes();
$sales_ref_grid->renderRow();
if ($sales_ref->isGridAdd())
	$sales_ref_grid->RowIndex = 0;
if ($sales_ref->isGridEdit())
	$sales_ref_grid->RowIndex = 0;
while ($sales_ref_grid->RecCnt < $sales_ref_grid->StopRec) {
	$sales_ref_grid->RecCnt++;
	if ($sales_ref_grid->RecCnt >= $sales_ref_grid->StartRec) {
		$sales_ref_grid->RowCnt++;
		if ($sales_ref->isGridAdd() || $sales_ref->isGridEdit() || $sales_ref->isConfirm()) {
			$sales_ref_grid->RowIndex++;
			$CurrentForm->Index = $sales_ref_grid->RowIndex;
			if ($CurrentForm->hasValue($sales_ref_grid->FormActionName) && $sales_ref_grid->EventCancelled)
				$sales_ref_grid->RowAction = strval($CurrentForm->getValue($sales_ref_grid->FormActionName));
			elseif ($sales_ref->isGridAdd())
				$sales_ref_grid->RowAction = "insert";
			else
				$sales_ref_grid->RowAction = "";
		}

		// Set up key count
		$sales_ref_grid->KeyCount = $sales_ref_grid->RowIndex;

		// Init row class and style
		$sales_ref->resetAttributes();
		$sales_ref->CssClass = "";
		if ($sales_ref->isGridAdd()) {
			if ($sales_ref->CurrentMode == "copy") {
				$sales_ref_grid->loadRowValues($sales_ref_grid->Recordset); // Load row values
				$sales_ref_grid->setRecordKey($sales_ref_grid->RowOldKey, $sales_ref_grid->Recordset); // Set old record key
			} else {
				$sales_ref_grid->loadRowValues(); // Load default values
				$sales_ref_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$sales_ref_grid->loadRowValues($sales_ref_grid->Recordset); // Load row values
		}
		$sales_ref->RowType = ROWTYPE_VIEW; // Render view
		if ($sales_ref->isGridAdd()) // Grid add
			$sales_ref->RowType = ROWTYPE_ADD; // Render add
		if ($sales_ref->isGridAdd() && $sales_ref->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$sales_ref_grid->restoreCurrentRowFormValues($sales_ref_grid->RowIndex); // Restore form values
		if ($sales_ref->isGridEdit()) { // Grid edit
			if ($sales_ref->EventCancelled)
				$sales_ref_grid->restoreCurrentRowFormValues($sales_ref_grid->RowIndex); // Restore form values
			if ($sales_ref_grid->RowAction == "insert")
				$sales_ref->RowType = ROWTYPE_ADD; // Render add
			else
				$sales_ref->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($sales_ref->isGridEdit() && ($sales_ref->RowType == ROWTYPE_EDIT || $sales_ref->RowType == ROWTYPE_ADD) && $sales_ref->EventCancelled) // Update failed
			$sales_ref_grid->restoreCurrentRowFormValues($sales_ref_grid->RowIndex); // Restore form values
		if ($sales_ref->RowType == ROWTYPE_EDIT) // Edit row
			$sales_ref_grid->EditRowCnt++;
		if ($sales_ref->isConfirm()) // Confirm row
			$sales_ref_grid->restoreCurrentRowFormValues($sales_ref_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$sales_ref->RowAttrs = array_merge($sales_ref->RowAttrs, array('data-rowindex'=>$sales_ref_grid->RowCnt, 'id'=>'r' . $sales_ref_grid->RowCnt . '_sales_ref', 'data-rowtype'=>$sales_ref->RowType));

		// Render row
		$sales_ref_grid->renderRow();

		// Render list options
		$sales_ref_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($sales_ref_grid->RowAction <> "delete" && $sales_ref_grid->RowAction <> "insertdelete" && !($sales_ref_grid->RowAction == "insert" && $sales_ref->isConfirm() && $sales_ref_grid->emptyRow())) {
?>
	<tr<?php echo $sales_ref->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sales_ref_grid->ListOptions->render("body", "left", $sales_ref_grid->RowCnt);
?>
	<?php if ($sales_ref->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $sales_ref->grp->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_grp" class="form-group sales_ref_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_grp" data-value-separator="<?php echo $sales_ref->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_grp"<?php echo $sales_ref->grp->editAttributes() ?>>
		<?php echo $sales_ref->grp->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_grp") ?>
	</select>
</div>
<?php echo $sales_ref->grp->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_grp") ?>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_grp" name="o<?php echo $sales_ref_grid->RowIndex ?>_grp" id="o<?php echo $sales_ref_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($sales_ref->grp->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_grp" class="form-group sales_ref_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_grp" data-value-separator="<?php echo $sales_ref->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_grp"<?php echo $sales_ref->grp->editAttributes() ?>>
		<?php echo $sales_ref->grp->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_grp") ?>
	</select>
</div>
<?php echo $sales_ref->grp->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_grp") ?>
</span>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_grp" class="sales_ref_grp">
<span<?php echo $sales_ref->grp->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->grp->getViewValue())) && $sales_ref->grp->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->grp->linkAttributes() ?>><?php echo $sales_ref->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_grp" id="x<?php echo $sales_ref_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($sales_ref->grp->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_grp" name="o<?php echo $sales_ref_grid->RowIndex ?>_grp" id="o<?php echo $sales_ref_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($sales_ref->grp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x_grp" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_grp" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($sales_ref->grp->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_grp" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_grp" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($sales_ref->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $sales_ref->s_grp->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_s_grp" class="form-group sales_ref_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_s_grp" data-value-separator="<?php echo $sales_ref->s_grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp"<?php echo $sales_ref->s_grp->editAttributes() ?>>
		<?php echo $sales_ref->s_grp->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_s_grp") ?>
	</select>
</div>
<?php echo $sales_ref->s_grp->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_s_grp") ?>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_s_grp" name="o<?php echo $sales_ref_grid->RowIndex ?>_s_grp" id="o<?php echo $sales_ref_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($sales_ref->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_s_grp" class="form-group sales_ref_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_s_grp" data-value-separator="<?php echo $sales_ref->s_grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp"<?php echo $sales_ref->s_grp->editAttributes() ?>>
		<?php echo $sales_ref->s_grp->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_s_grp") ?>
	</select>
</div>
<?php echo $sales_ref->s_grp->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_s_grp") ?>
</span>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_s_grp" class="sales_ref_s_grp">
<span<?php echo $sales_ref->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->s_grp->getViewValue())) && $sales_ref->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->s_grp->linkAttributes() ?>><?php echo $sales_ref->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x_s_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" id="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($sales_ref->s_grp->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_s_grp" name="o<?php echo $sales_ref_grid->RowIndex ?>_s_grp" id="o<?php echo $sales_ref_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($sales_ref->s_grp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x_s_grp" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($sales_ref->s_grp->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_s_grp" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_s_grp" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($sales_ref->s_grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sales_ref->product->Visible) { // product ?>
		<td data-name="product"<?php echo $sales_ref->product->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_product" class="form-group sales_ref_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_product" data-value-separator="<?php echo $sales_ref->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_product" name="x<?php echo $sales_ref_grid->RowIndex ?>_product"<?php echo $sales_ref->product->editAttributes() ?>>
		<?php echo $sales_ref->product->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $sales_ref->product->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_product") ?>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_product" name="o<?php echo $sales_ref_grid->RowIndex ?>_product" id="o<?php echo $sales_ref_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sales_ref->product->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_product" class="form-group sales_ref_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_product" data-value-separator="<?php echo $sales_ref->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_product" name="x<?php echo $sales_ref_grid->RowIndex ?>_product"<?php echo $sales_ref->product->editAttributes() ?>>
		<?php echo $sales_ref->product->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $sales_ref->product->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_product") ?>
</span>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_product" class="sales_ref_product">
<span<?php echo $sales_ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->product->getViewValue())) && $sales_ref->product->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->product->linkAttributes() ?>><?php echo $sales_ref->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x_product" name="x<?php echo $sales_ref_grid->RowIndex ?>_product" id="x<?php echo $sales_ref_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sales_ref->product->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_product" name="o<?php echo $sales_ref_grid->RowIndex ?>_product" id="o<?php echo $sales_ref_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sales_ref->product->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x_product" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_product" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sales_ref->product->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_product" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_product" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sales_ref->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sales_ref->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $sales_ref->rid->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($sales_ref->rid->getSessionValue() <> "") { ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_rid" class="form-group sales_ref_rid">
<span<?php echo $sales_ref->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $sales_ref_grid->RowIndex ?>_rid" name="x<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_rid" class="form-group sales_ref_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_rid" data-value-separator="<?php echo $sales_ref->rid->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_rid" name="x<?php echo $sales_ref_grid->RowIndex ?>_rid"<?php echo $sales_ref->rid->editAttributes() ?>>
		<?php echo $sales_ref->rid->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_rid") ?>
	</select>
</div>
<?php echo $sales_ref->rid->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_rid") ?>
</span>
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_rid" name="o<?php echo $sales_ref_grid->RowIndex ?>_rid" id="o<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($sales_ref->rid->getSessionValue() <> "") { ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_rid" class="form-group sales_ref_rid">
<span<?php echo $sales_ref->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $sales_ref_grid->RowIndex ?>_rid" name="x<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_rid" class="form-group sales_ref_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_rid" data-value-separator="<?php echo $sales_ref->rid->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_rid" name="x<?php echo $sales_ref_grid->RowIndex ?>_rid"<?php echo $sales_ref->rid->editAttributes() ?>>
		<?php echo $sales_ref->rid->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_rid") ?>
	</select>
</div>
<?php echo $sales_ref->rid->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_rid") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_rid" class="sales_ref_rid">
<span<?php echo $sales_ref->rid->viewAttributes() ?>>
<?php echo $sales_ref->rid->getViewValue() ?></span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x_rid" name="x<?php echo $sales_ref_grid->RowIndex ?>_rid" id="x<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_rid" name="o<?php echo $sales_ref_grid->RowIndex ?>_rid" id="o<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x_rid" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_rid" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_rid" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_rid" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sales_ref->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $sales_ref->packets->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_packets" class="form-group sales_ref_packets">
<input type="text" data-table="sales_ref" data-field="x_packets" name="x<?php echo $sales_ref_grid->RowIndex ?>_packets" id="x<?php echo $sales_ref_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($sales_ref->packets->getPlaceHolder()) ?>" value="<?php echo $sales_ref->packets->EditValue ?>"<?php echo $sales_ref->packets->editAttributes() ?>>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_packets" name="o<?php echo $sales_ref_grid->RowIndex ?>_packets" id="o<?php echo $sales_ref_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sales_ref->packets->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_packets" class="form-group sales_ref_packets">
<input type="text" data-table="sales_ref" data-field="x_packets" name="x<?php echo $sales_ref_grid->RowIndex ?>_packets" id="x<?php echo $sales_ref_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($sales_ref->packets->getPlaceHolder()) ?>" value="<?php echo $sales_ref->packets->EditValue ?>"<?php echo $sales_ref->packets->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_packets" class="sales_ref_packets">
<span<?php echo $sales_ref->packets->viewAttributes() ?>>
<?php echo $sales_ref->packets->getViewValue() ?></span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x_packets" name="x<?php echo $sales_ref_grid->RowIndex ?>_packets" id="x<?php echo $sales_ref_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sales_ref->packets->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_packets" name="o<?php echo $sales_ref_grid->RowIndex ?>_packets" id="o<?php echo $sales_ref_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sales_ref->packets->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x_packets" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_packets" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sales_ref->packets->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_packets" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_packets" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sales_ref->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sales_ref->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $sales_ref->quantity->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_quantity" class="form-group sales_ref_quantity">
<input type="text" data-table="sales_ref" data-field="x_quantity" name="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($sales_ref->quantity->getPlaceHolder()) ?>" value="<?php echo $sales_ref->quantity->EditValue ?>"<?php echo $sales_ref->quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_quantity" name="o<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="o<?php echo $sales_ref_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($sales_ref->quantity->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_quantity" class="form-group sales_ref_quantity">
<input type="text" data-table="sales_ref" data-field="x_quantity" name="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($sales_ref->quantity->getPlaceHolder()) ?>" value="<?php echo $sales_ref->quantity->EditValue ?>"<?php echo $sales_ref->quantity->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_quantity" class="sales_ref_quantity">
<span<?php echo $sales_ref->quantity->viewAttributes() ?>>
<?php echo $sales_ref->quantity->getViewValue() ?></span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x_quantity" name="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($sales_ref->quantity->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_quantity" name="o<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="o<?php echo $sales_ref_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($sales_ref->quantity->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x_quantity" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($sales_ref->quantity->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_quantity" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($sales_ref->quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sales_ref->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $sales_ref->_40->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref__40" class="form-group sales_ref__40">
<input type="text" data-table="sales_ref" data-field="x__40" name="x<?php echo $sales_ref_grid->RowIndex ?>__40" id="x<?php echo $sales_ref_grid->RowIndex ?>__40" size="30" placeholder="<?php echo HtmlEncode($sales_ref->_40->getPlaceHolder()) ?>" value="<?php echo $sales_ref->_40->EditValue ?>"<?php echo $sales_ref->_40->editAttributes() ?>>
</span>
<input type="hidden" data-table="sales_ref" data-field="x__40" name="o<?php echo $sales_ref_grid->RowIndex ?>__40" id="o<?php echo $sales_ref_grid->RowIndex ?>__40" value="<?php echo HtmlEncode($sales_ref->_40->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref__40" class="form-group sales_ref__40">
<input type="text" data-table="sales_ref" data-field="x__40" name="x<?php echo $sales_ref_grid->RowIndex ?>__40" id="x<?php echo $sales_ref_grid->RowIndex ?>__40" size="30" placeholder="<?php echo HtmlEncode($sales_ref->_40->getPlaceHolder()) ?>" value="<?php echo $sales_ref->_40->EditValue ?>"<?php echo $sales_ref->_40->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref__40" class="sales_ref__40">
<span<?php echo $sales_ref->_40->viewAttributes() ?>>
<?php echo $sales_ref->_40->getViewValue() ?></span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x__40" name="x<?php echo $sales_ref_grid->RowIndex ?>__40" id="x<?php echo $sales_ref_grid->RowIndex ?>__40" value="<?php echo HtmlEncode($sales_ref->_40->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x__40" name="o<?php echo $sales_ref_grid->RowIndex ?>__40" id="o<?php echo $sales_ref_grid->RowIndex ?>__40" value="<?php echo HtmlEncode($sales_ref->_40->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x__40" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>__40" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>__40" value="<?php echo HtmlEncode($sales_ref->_40->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x__40" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>__40" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>__40" value="<?php echo HtmlEncode($sales_ref->_40->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sales_ref->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $sales_ref->amount->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_amount" class="form-group sales_ref_amount">
<input type="text" data-table="sales_ref" data-field="x_amount" name="x<?php echo $sales_ref_grid->RowIndex ?>_amount" id="x<?php echo $sales_ref_grid->RowIndex ?>_amount" size="30" placeholder="<?php echo HtmlEncode($sales_ref->amount->getPlaceHolder()) ?>" value="<?php echo $sales_ref->amount->EditValue ?>"<?php echo $sales_ref->amount->editAttributes() ?>>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_amount" name="o<?php echo $sales_ref_grid->RowIndex ?>_amount" id="o<?php echo $sales_ref_grid->RowIndex ?>_amount" value="<?php echo HtmlEncode($sales_ref->amount->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_amount" class="form-group sales_ref_amount">
<input type="text" data-table="sales_ref" data-field="x_amount" name="x<?php echo $sales_ref_grid->RowIndex ?>_amount" id="x<?php echo $sales_ref_grid->RowIndex ?>_amount" size="30" placeholder="<?php echo HtmlEncode($sales_ref->amount->getPlaceHolder()) ?>" value="<?php echo $sales_ref->amount->EditValue ?>"<?php echo $sales_ref->amount->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_amount" class="sales_ref_amount">
<span<?php echo $sales_ref->amount->viewAttributes() ?>>
<?php echo $sales_ref->amount->getViewValue() ?></span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x_amount" name="x<?php echo $sales_ref_grid->RowIndex ?>_amount" id="x<?php echo $sales_ref_grid->RowIndex ?>_amount" value="<?php echo HtmlEncode($sales_ref->amount->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_amount" name="o<?php echo $sales_ref_grid->RowIndex ?>_amount" id="o<?php echo $sales_ref_grid->RowIndex ?>_amount" value="<?php echo HtmlEncode($sales_ref->amount->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x_amount" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_amount" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_amount" value="<?php echo HtmlEncode($sales_ref->amount->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_amount" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_amount" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_amount" value="<?php echo HtmlEncode($sales_ref->amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($sales_ref->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $sales_ref->godown->cellAttributes() ?>>
<?php if ($sales_ref->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_godown" class="form-group sales_ref_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_godown" data-value-separator="<?php echo $sales_ref->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_godown" name="x<?php echo $sales_ref_grid->RowIndex ?>_godown"<?php echo $sales_ref->godown->editAttributes() ?>>
		<?php echo $sales_ref->godown->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_godown") ?>
	</select>
</div>
<?php echo $sales_ref->godown->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_godown") ?>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_godown" name="o<?php echo $sales_ref_grid->RowIndex ?>_godown" id="o<?php echo $sales_ref_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sales_ref->godown->OldValue) ?>">
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_godown" class="form-group sales_ref_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_godown" data-value-separator="<?php echo $sales_ref->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_godown" name="x<?php echo $sales_ref_grid->RowIndex ?>_godown"<?php echo $sales_ref->godown->editAttributes() ?>>
		<?php echo $sales_ref->godown->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_godown") ?>
	</select>
</div>
<?php echo $sales_ref->godown->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_godown") ?>
</span>
<?php } ?>
<?php if ($sales_ref->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $sales_ref_grid->RowCnt ?>_sales_ref_godown" class="sales_ref_godown">
<span<?php echo $sales_ref->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->godown->getViewValue())) && $sales_ref->godown->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->godown->linkAttributes() ?>><?php echo $sales_ref->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$sales_ref->isConfirm()) { ?>
<input type="hidden" data-table="sales_ref" data-field="x_godown" name="x<?php echo $sales_ref_grid->RowIndex ?>_godown" id="x<?php echo $sales_ref_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sales_ref->godown->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_godown" name="o<?php echo $sales_ref_grid->RowIndex ?>_godown" id="o<?php echo $sales_ref_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sales_ref->godown->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="sales_ref" data-field="x_godown" name="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_godown" id="fsales_refgrid$x<?php echo $sales_ref_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sales_ref->godown->FormValue) ?>">
<input type="hidden" data-table="sales_ref" data-field="x_godown" name="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_godown" id="fsales_refgrid$o<?php echo $sales_ref_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sales_ref->godown->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sales_ref_grid->ListOptions->render("body", "right", $sales_ref_grid->RowCnt);
?>
	</tr>
<?php if ($sales_ref->RowType == ROWTYPE_ADD || $sales_ref->RowType == ROWTYPE_EDIT) { ?>
<script>
fsales_refgrid.updateLists(<?php echo $sales_ref_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$sales_ref->isGridAdd() || $sales_ref->CurrentMode == "copy")
		if (!$sales_ref_grid->Recordset->EOF)
			$sales_ref_grid->Recordset->moveNext();
}
?>
<?php
	if ($sales_ref->CurrentMode == "add" || $sales_ref->CurrentMode == "copy" || $sales_ref->CurrentMode == "edit") {
		$sales_ref_grid->RowIndex = '$rowindex$';
		$sales_ref_grid->loadRowValues();

		// Set row properties
		$sales_ref->resetAttributes();
		$sales_ref->RowAttrs = array_merge($sales_ref->RowAttrs, array('data-rowindex'=>$sales_ref_grid->RowIndex, 'id'=>'r0_sales_ref', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($sales_ref->RowAttrs["class"], "ew-template");
		$sales_ref->RowType = ROWTYPE_ADD;

		// Render row
		$sales_ref_grid->renderRow();

		// Render list options
		$sales_ref_grid->renderListOptions();
		$sales_ref_grid->StartRowCnt = 0;
?>
	<tr<?php echo $sales_ref->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sales_ref_grid->ListOptions->render("body", "left", $sales_ref_grid->RowIndex);
?>
	<?php if ($sales_ref->grp->Visible) { // grp ?>
		<td data-name="grp">
<?php if (!$sales_ref->isConfirm()) { ?>
<span id="el$rowindex$_sales_ref_grp" class="form-group sales_ref_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_grp" data-value-separator="<?php echo $sales_ref->grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_grp"<?php echo $sales_ref->grp->editAttributes() ?>>
		<?php echo $sales_ref->grp->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_grp") ?>
	</select>
</div>
<?php echo $sales_ref->grp->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_grp") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sales_ref_grp" class="form-group sales_ref_grp">
<span<?php echo $sales_ref->grp->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->grp->ViewValue)) && $sales_ref->grp->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->grp->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->grp->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_grp" id="x<?php echo $sales_ref_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($sales_ref->grp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_grp" name="o<?php echo $sales_ref_grid->RowIndex ?>_grp" id="o<?php echo $sales_ref_grid->RowIndex ?>_grp" value="<?php echo HtmlEncode($sales_ref->grp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp">
<?php if (!$sales_ref->isConfirm()) { ?>
<span id="el$rowindex$_sales_ref_s_grp" class="form-group sales_ref_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_s_grp" data-value-separator="<?php echo $sales_ref->s_grp->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp"<?php echo $sales_ref->s_grp->editAttributes() ?>>
		<?php echo $sales_ref->s_grp->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_s_grp") ?>
	</select>
</div>
<?php echo $sales_ref->s_grp->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_s_grp") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sales_ref_s_grp" class="form-group sales_ref_s_grp">
<span<?php echo $sales_ref->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->s_grp->ViewValue)) && $sales_ref->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->s_grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->s_grp->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->s_grp->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_s_grp" name="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" id="x<?php echo $sales_ref_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($sales_ref->s_grp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_s_grp" name="o<?php echo $sales_ref_grid->RowIndex ?>_s_grp" id="o<?php echo $sales_ref_grid->RowIndex ?>_s_grp" value="<?php echo HtmlEncode($sales_ref->s_grp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sales_ref->product->Visible) { // product ?>
		<td data-name="product">
<?php if (!$sales_ref->isConfirm()) { ?>
<span id="el$rowindex$_sales_ref_product" class="form-group sales_ref_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_product" data-value-separator="<?php echo $sales_ref->product->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_product" name="x<?php echo $sales_ref_grid->RowIndex ?>_product"<?php echo $sales_ref->product->editAttributes() ?>>
		<?php echo $sales_ref->product->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_product") ?>
	</select>
</div>
<?php echo $sales_ref->product->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_product") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sales_ref_product" class="form-group sales_ref_product">
<span<?php echo $sales_ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->product->ViewValue)) && $sales_ref->product->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->product->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->product->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->product->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_product" name="x<?php echo $sales_ref_grid->RowIndex ?>_product" id="x<?php echo $sales_ref_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sales_ref->product->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_product" name="o<?php echo $sales_ref_grid->RowIndex ?>_product" id="o<?php echo $sales_ref_grid->RowIndex ?>_product" value="<?php echo HtmlEncode($sales_ref->product->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sales_ref->rid->Visible) { // rid ?>
		<td data-name="rid">
<?php if (!$sales_ref->isConfirm()) { ?>
<?php if ($sales_ref->rid->getSessionValue() <> "") { ?>
<span id="el$rowindex$_sales_ref_rid" class="form-group sales_ref_rid">
<span<?php echo $sales_ref->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $sales_ref_grid->RowIndex ?>_rid" name="x<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_sales_ref_rid" class="form-group sales_ref_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_rid" data-value-separator="<?php echo $sales_ref->rid->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_rid" name="x<?php echo $sales_ref_grid->RowIndex ?>_rid"<?php echo $sales_ref->rid->editAttributes() ?>>
		<?php echo $sales_ref->rid->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_rid") ?>
	</select>
</div>
<?php echo $sales_ref->rid->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_rid") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_sales_ref_rid" class="form-group sales_ref_rid">
<span<?php echo $sales_ref->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->rid->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_rid" name="x<?php echo $sales_ref_grid->RowIndex ?>_rid" id="x<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_rid" name="o<?php echo $sales_ref_grid->RowIndex ?>_rid" id="o<?php echo $sales_ref_grid->RowIndex ?>_rid" value="<?php echo HtmlEncode($sales_ref->rid->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sales_ref->packets->Visible) { // packets ?>
		<td data-name="packets">
<?php if (!$sales_ref->isConfirm()) { ?>
<span id="el$rowindex$_sales_ref_packets" class="form-group sales_ref_packets">
<input type="text" data-table="sales_ref" data-field="x_packets" name="x<?php echo $sales_ref_grid->RowIndex ?>_packets" id="x<?php echo $sales_ref_grid->RowIndex ?>_packets" size="30" placeholder="<?php echo HtmlEncode($sales_ref->packets->getPlaceHolder()) ?>" value="<?php echo $sales_ref->packets->EditValue ?>"<?php echo $sales_ref->packets->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_sales_ref_packets" class="form-group sales_ref_packets">
<span<?php echo $sales_ref->packets->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->packets->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_packets" name="x<?php echo $sales_ref_grid->RowIndex ?>_packets" id="x<?php echo $sales_ref_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sales_ref->packets->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_packets" name="o<?php echo $sales_ref_grid->RowIndex ?>_packets" id="o<?php echo $sales_ref_grid->RowIndex ?>_packets" value="<?php echo HtmlEncode($sales_ref->packets->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sales_ref->quantity->Visible) { // quantity ?>
		<td data-name="quantity">
<?php if (!$sales_ref->isConfirm()) { ?>
<span id="el$rowindex$_sales_ref_quantity" class="form-group sales_ref_quantity">
<input type="text" data-table="sales_ref" data-field="x_quantity" name="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" size="30" placeholder="<?php echo HtmlEncode($sales_ref->quantity->getPlaceHolder()) ?>" value="<?php echo $sales_ref->quantity->EditValue ?>"<?php echo $sales_ref->quantity->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_sales_ref_quantity" class="form-group sales_ref_quantity">
<span<?php echo $sales_ref->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->quantity->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_quantity" name="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="x<?php echo $sales_ref_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($sales_ref->quantity->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_quantity" name="o<?php echo $sales_ref_grid->RowIndex ?>_quantity" id="o<?php echo $sales_ref_grid->RowIndex ?>_quantity" value="<?php echo HtmlEncode($sales_ref->quantity->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sales_ref->_40->Visible) { // @ ?>
		<td data-name="_40">
<?php if (!$sales_ref->isConfirm()) { ?>
<span id="el$rowindex$_sales_ref__40" class="form-group sales_ref__40">
<input type="text" data-table="sales_ref" data-field="x__40" name="x<?php echo $sales_ref_grid->RowIndex ?>__40" id="x<?php echo $sales_ref_grid->RowIndex ?>__40" size="30" placeholder="<?php echo HtmlEncode($sales_ref->_40->getPlaceHolder()) ?>" value="<?php echo $sales_ref->_40->EditValue ?>"<?php echo $sales_ref->_40->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_sales_ref__40" class="form-group sales_ref__40">
<span<?php echo $sales_ref->_40->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->_40->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x__40" name="x<?php echo $sales_ref_grid->RowIndex ?>__40" id="x<?php echo $sales_ref_grid->RowIndex ?>__40" value="<?php echo HtmlEncode($sales_ref->_40->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x__40" name="o<?php echo $sales_ref_grid->RowIndex ?>__40" id="o<?php echo $sales_ref_grid->RowIndex ?>__40" value="<?php echo HtmlEncode($sales_ref->_40->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sales_ref->amount->Visible) { // amount ?>
		<td data-name="amount">
<?php if (!$sales_ref->isConfirm()) { ?>
<span id="el$rowindex$_sales_ref_amount" class="form-group sales_ref_amount">
<input type="text" data-table="sales_ref" data-field="x_amount" name="x<?php echo $sales_ref_grid->RowIndex ?>_amount" id="x<?php echo $sales_ref_grid->RowIndex ?>_amount" size="30" placeholder="<?php echo HtmlEncode($sales_ref->amount->getPlaceHolder()) ?>" value="<?php echo $sales_ref->amount->EditValue ?>"<?php echo $sales_ref->amount->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_sales_ref_amount" class="form-group sales_ref_amount">
<span<?php echo $sales_ref->amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->amount->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_amount" name="x<?php echo $sales_ref_grid->RowIndex ?>_amount" id="x<?php echo $sales_ref_grid->RowIndex ?>_amount" value="<?php echo HtmlEncode($sales_ref->amount->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_amount" name="o<?php echo $sales_ref_grid->RowIndex ?>_amount" id="o<?php echo $sales_ref_grid->RowIndex ?>_amount" value="<?php echo HtmlEncode($sales_ref->amount->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($sales_ref->godown->Visible) { // godown ?>
		<td data-name="godown">
<?php if (!$sales_ref->isConfirm()) { ?>
<span id="el$rowindex$_sales_ref_godown" class="form-group sales_ref_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_godown" data-value-separator="<?php echo $sales_ref->godown->displayValueSeparatorAttribute() ?>" id="x<?php echo $sales_ref_grid->RowIndex ?>_godown" name="x<?php echo $sales_ref_grid->RowIndex ?>_godown"<?php echo $sales_ref->godown->editAttributes() ?>>
		<?php echo $sales_ref->godown->selectOptionListHtml("x<?php echo $sales_ref_grid->RowIndex ?>_godown") ?>
	</select>
</div>
<?php echo $sales_ref->godown->Lookup->getParamTag("p_x" . $sales_ref_grid->RowIndex . "_godown") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_sales_ref_godown" class="form-group sales_ref_godown">
<span<?php echo $sales_ref->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->godown->ViewValue)) && $sales_ref->godown->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->godown->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->godown->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($sales_ref->godown->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="sales_ref" data-field="x_godown" name="x<?php echo $sales_ref_grid->RowIndex ?>_godown" id="x<?php echo $sales_ref_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sales_ref->godown->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="sales_ref" data-field="x_godown" name="o<?php echo $sales_ref_grid->RowIndex ?>_godown" id="o<?php echo $sales_ref_grid->RowIndex ?>_godown" value="<?php echo HtmlEncode($sales_ref->godown->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sales_ref_grid->ListOptions->render("body", "right", $sales_ref_grid->RowIndex);
?>
<script>
fsales_refgrid.updateLists(<?php echo $sales_ref_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($sales_ref->CurrentMode == "add" || $sales_ref->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $sales_ref_grid->FormKeyCountName ?>" id="<?php echo $sales_ref_grid->FormKeyCountName ?>" value="<?php echo $sales_ref_grid->KeyCount ?>">
<?php echo $sales_ref_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($sales_ref->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $sales_ref_grid->FormKeyCountName ?>" id="<?php echo $sales_ref_grid->FormKeyCountName ?>" value="<?php echo $sales_ref_grid->KeyCount ?>">
<?php echo $sales_ref_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($sales_ref->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fsales_refgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($sales_ref_grid->Recordset)
	$sales_ref_grid->Recordset->Close();
?>
</div>
<?php if ($sales_ref_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $sales_ref_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sales_ref_grid->TotalRecs == 0 && !$sales_ref->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sales_ref_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sales_ref_grid->terminate();
?>
<?php if (!$sales_ref->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sales_ref", "100%", "500px");
</script>
<?php } ?>