<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sales_ref_list = new sales_ref_list();

// Run the page
$sales_ref_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sales_ref_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$sales_ref->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fsales_reflist = currentForm = new ew.Form("fsales_reflist", "list");
fsales_reflist.formKeyCountName = '<?php echo $sales_ref_list->FormKeyCountName ?>';

// Form_CustomValidate event
fsales_reflist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsales_reflist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsales_reflist.lists["x_grp"] = <?php echo $sales_ref_list->grp->Lookup->toClientList() ?>;
fsales_reflist.lists["x_grp"].options = <?php echo JsonEncode($sales_ref_list->grp->lookupOptions()) ?>;
fsales_reflist.lists["x_s_grp"] = <?php echo $sales_ref_list->s_grp->Lookup->toClientList() ?>;
fsales_reflist.lists["x_s_grp"].options = <?php echo JsonEncode($sales_ref_list->s_grp->lookupOptions()) ?>;
fsales_reflist.lists["x_product"] = <?php echo $sales_ref_list->product->Lookup->toClientList() ?>;
fsales_reflist.lists["x_product"].options = <?php echo JsonEncode($sales_ref_list->product->lookupOptions()) ?>;
fsales_reflist.lists["x_rid"] = <?php echo $sales_ref_list->rid->Lookup->toClientList() ?>;
fsales_reflist.lists["x_rid"].options = <?php echo JsonEncode($sales_ref_list->rid->lookupOptions()) ?>;
fsales_reflist.lists["x_godown"] = <?php echo $sales_ref_list->godown->Lookup->toClientList() ?>;
fsales_reflist.lists["x_godown"].options = <?php echo JsonEncode($sales_ref_list->godown->lookupOptions()) ?>;

// Form object for search
var fsales_reflistsrch = currentSearchForm = new ew.Form("fsales_reflistsrch");

// Validate function for search
fsales_reflistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fsales_reflistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsales_reflistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsales_reflistsrch.lists["x_s_grp"] = <?php echo $sales_ref_list->s_grp->Lookup->toClientList() ?>;
fsales_reflistsrch.lists["x_s_grp"].options = <?php echo JsonEncode($sales_ref_list->s_grp->lookupOptions()) ?>;
fsales_reflistsrch.lists["x_product"] = <?php echo $sales_ref_list->product->Lookup->toClientList() ?>;
fsales_reflistsrch.lists["x_product"].options = <?php echo JsonEncode($sales_ref_list->product->lookupOptions()) ?>;
fsales_reflistsrch.lists["x_rid"] = <?php echo $sales_ref_list->rid->Lookup->toClientList() ?>;
fsales_reflistsrch.lists["x_rid"].options = <?php echo JsonEncode($sales_ref_list->rid->lookupOptions()) ?>;

// Filters
fsales_reflistsrch.filterList = <?php echo $sales_ref_list->getFilterList() ?>;

// Init search panel as collapsed
fsales_reflistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$sales_ref->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($sales_ref_list->TotalRecs > 0 && $sales_ref_list->ExportOptions->visible()) { ?>
<?php $sales_ref_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($sales_ref_list->ImportOptions->visible()) { ?>
<?php $sales_ref_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($sales_ref_list->SearchOptions->visible()) { ?>
<?php $sales_ref_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($sales_ref_list->FilterOptions->visible()) { ?>
<?php $sales_ref_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$sales_ref->isExport() || EXPORT_MASTER_RECORD && $sales_ref->isExport("print")) { ?>
<?php
if ($sales_ref_list->DbMasterFilter <> "" && $sales_ref->getCurrentMasterTable() == "margin_list") {
	if ($sales_ref_list->MasterRecordExists) {
		include_once "margin_listmaster.php";
	}
}
?>
<?php } ?>
<?php
$sales_ref_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$sales_ref->isExport() && !$sales_ref->CurrentAction) { ?>
<form name="fsales_reflistsrch" id="fsales_reflistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($sales_ref_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fsales_reflistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="sales_ref">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$sales_ref_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$sales_ref->RowType = ROWTYPE_SEARCH;

// Render row
$sales_ref->resetAttributes();
$sales_ref_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label for="x_s_grp" class="ew-search-caption ew-label"><?php echo $sales_ref->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_s_grp" data-value-separator="<?php echo $sales_ref->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $sales_ref->s_grp->editAttributes() ?>>
		<?php echo $sales_ref->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $sales_ref->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($sales_ref->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $sales_ref->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_product" data-value-separator="<?php echo $sales_ref->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $sales_ref->product->editAttributes() ?>>
		<?php echo $sales_ref->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $sales_ref->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($sales_ref->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $sales_ref->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="sales_ref" data-field="x_rid" data-value-separator="<?php echo $sales_ref->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $sales_ref->rid->editAttributes() ?>>
		<?php echo $sales_ref->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $sales_ref->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($sales_ref_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($sales_ref_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $sales_ref_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($sales_ref_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($sales_ref_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($sales_ref_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($sales_ref_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $sales_ref_list->showPageHeader(); ?>
<?php
$sales_ref_list->showMessage();
?>
<?php if ($sales_ref_list->TotalRecs > 0 || $sales_ref->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($sales_ref_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> sales_ref">
<?php if (!$sales_ref->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$sales_ref->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sales_ref_list->Pager)) $sales_ref_list->Pager = new PrevNextPager($sales_ref_list->StartRec, $sales_ref_list->DisplayRecs, $sales_ref_list->TotalRecs, $sales_ref_list->AutoHidePager) ?>
<?php if ($sales_ref_list->Pager->RecordCount > 0 && $sales_ref_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sales_ref_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sales_ref_list->pageUrl() ?>start=<?php echo $sales_ref_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sales_ref_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sales_ref_list->pageUrl() ?>start=<?php echo $sales_ref_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sales_ref_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sales_ref_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sales_ref_list->pageUrl() ?>start=<?php echo $sales_ref_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sales_ref_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sales_ref_list->pageUrl() ?>start=<?php echo $sales_ref_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sales_ref_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sales_ref_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sales_ref_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sales_ref_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sales_ref_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sales_ref_list->TotalRecs > 0 && (!$sales_ref_list->AutoHidePageSizeSelector || $sales_ref_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sales_ref">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sales_ref_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sales_ref_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sales_ref_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sales_ref_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sales_ref_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sales_ref->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sales_ref_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fsales_reflist" id="fsales_reflist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sales_ref_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sales_ref_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sales_ref">
<?php if ($sales_ref->getCurrentMasterTable() == "margin_list" && $sales_ref->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="margin_list">
<input type="hidden" name="fk_rid" value="<?php echo $sales_ref->rid->getSessionValue() ?>">
<?php } ?>
<div id="gmp_sales_ref" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($sales_ref_list->TotalRecs > 0 || $sales_ref->isGridEdit()) { ?>
<table id="tbl_sales_reflist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$sales_ref_list->RowType = ROWTYPE_HEADER;

// Render list options
$sales_ref_list->renderListOptions();

// Render list options (header, left)
$sales_ref_list->ListOptions->render("header", "left");
?>
<?php if ($sales_ref->grp->Visible) { // grp ?>
	<?php if ($sales_ref->sortUrl($sales_ref->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $sales_ref->grp->headerCellClass() ?>"><div id="elh_sales_ref_grp" class="sales_ref_grp"><div class="ew-table-header-caption"><?php echo $sales_ref->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $sales_ref->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->grp) ?>',2);"><div id="elh_sales_ref_grp" class="sales_ref_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
	<?php if ($sales_ref->sortUrl($sales_ref->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $sales_ref->s_grp->headerCellClass() ?>"><div id="elh_sales_ref_s_grp" class="sales_ref_s_grp"><div class="ew-table-header-caption"><?php echo $sales_ref->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $sales_ref->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->s_grp) ?>',2);"><div id="elh_sales_ref_s_grp" class="sales_ref_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->product->Visible) { // product ?>
	<?php if ($sales_ref->sortUrl($sales_ref->product) == "") { ?>
		<th data-name="product" class="<?php echo $sales_ref->product->headerCellClass() ?>"><div id="elh_sales_ref_product" class="sales_ref_product"><div class="ew-table-header-caption"><?php echo $sales_ref->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $sales_ref->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->product) ?>',2);"><div id="elh_sales_ref_product" class="sales_ref_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->rid->Visible) { // rid ?>
	<?php if ($sales_ref->sortUrl($sales_ref->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $sales_ref->rid->headerCellClass() ?>"><div id="elh_sales_ref_rid" class="sales_ref_rid"><div class="ew-table-header-caption"><?php echo $sales_ref->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $sales_ref->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->rid) ?>',2);"><div id="elh_sales_ref_rid" class="sales_ref_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->packets->Visible) { // packets ?>
	<?php if ($sales_ref->sortUrl($sales_ref->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $sales_ref->packets->headerCellClass() ?>"><div id="elh_sales_ref_packets" class="sales_ref_packets"><div class="ew-table-header-caption"><?php echo $sales_ref->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $sales_ref->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->packets) ?>',2);"><div id="elh_sales_ref_packets" class="sales_ref_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->packets->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->quantity->Visible) { // quantity ?>
	<?php if ($sales_ref->sortUrl($sales_ref->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $sales_ref->quantity->headerCellClass() ?>"><div id="elh_sales_ref_quantity" class="sales_ref_quantity"><div class="ew-table-header-caption"><?php echo $sales_ref->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $sales_ref->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->quantity) ?>',2);"><div id="elh_sales_ref_quantity" class="sales_ref_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->_40->Visible) { // @ ?>
	<?php if ($sales_ref->sortUrl($sales_ref->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $sales_ref->_40->headerCellClass() ?>"><div id="elh_sales_ref__40" class="sales_ref__40"><div class="ew-table-header-caption"><?php echo $sales_ref->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $sales_ref->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->_40) ?>',2);"><div id="elh_sales_ref__40" class="sales_ref__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->_40->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->amount->Visible) { // amount ?>
	<?php if ($sales_ref->sortUrl($sales_ref->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $sales_ref->amount->headerCellClass() ?>"><div id="elh_sales_ref_amount" class="sales_ref_amount"><div class="ew-table-header-caption"><?php echo $sales_ref->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $sales_ref->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->amount) ?>',2);"><div id="elh_sales_ref_amount" class="sales_ref_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($sales_ref->godown->Visible) { // godown ?>
	<?php if ($sales_ref->sortUrl($sales_ref->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $sales_ref->godown->headerCellClass() ?>"><div id="elh_sales_ref_godown" class="sales_ref_godown"><div class="ew-table-header-caption"><?php echo $sales_ref->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $sales_ref->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $sales_ref->SortUrl($sales_ref->godown) ?>',2);"><div id="elh_sales_ref_godown" class="sales_ref_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $sales_ref->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($sales_ref->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($sales_ref->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$sales_ref_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($sales_ref->ExportAll && $sales_ref->isExport()) {
	$sales_ref_list->StopRec = $sales_ref_list->TotalRecs;
} else {

	// Set the last record to display
	if ($sales_ref_list->TotalRecs > $sales_ref_list->StartRec + $sales_ref_list->DisplayRecs - 1)
		$sales_ref_list->StopRec = $sales_ref_list->StartRec + $sales_ref_list->DisplayRecs - 1;
	else
		$sales_ref_list->StopRec = $sales_ref_list->TotalRecs;
}
$sales_ref_list->RecCnt = $sales_ref_list->StartRec - 1;
if ($sales_ref_list->Recordset && !$sales_ref_list->Recordset->EOF) {
	$sales_ref_list->Recordset->moveFirst();
	$selectLimit = $sales_ref_list->UseSelectLimit;
	if (!$selectLimit && $sales_ref_list->StartRec > 1)
		$sales_ref_list->Recordset->move($sales_ref_list->StartRec - 1);
} elseif (!$sales_ref->AllowAddDeleteRow && $sales_ref_list->StopRec == 0) {
	$sales_ref_list->StopRec = $sales_ref->GridAddRowCount;
}

// Initialize aggregate
$sales_ref->RowType = ROWTYPE_AGGREGATEINIT;
$sales_ref->resetAttributes();
$sales_ref_list->renderRow();
while ($sales_ref_list->RecCnt < $sales_ref_list->StopRec) {
	$sales_ref_list->RecCnt++;
	if ($sales_ref_list->RecCnt >= $sales_ref_list->StartRec) {
		$sales_ref_list->RowCnt++;

		// Set up key count
		$sales_ref_list->KeyCount = $sales_ref_list->RowIndex;

		// Init row class and style
		$sales_ref->resetAttributes();
		$sales_ref->CssClass = "";
		if ($sales_ref->isGridAdd()) {
		} else {
			$sales_ref_list->loadRowValues($sales_ref_list->Recordset); // Load row values
		}
		$sales_ref->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$sales_ref->RowAttrs = array_merge($sales_ref->RowAttrs, array('data-rowindex'=>$sales_ref_list->RowCnt, 'id'=>'r' . $sales_ref_list->RowCnt . '_sales_ref', 'data-rowtype'=>$sales_ref->RowType));

		// Render row
		$sales_ref_list->renderRow();

		// Render list options
		$sales_ref_list->renderListOptions();
?>
	<tr<?php echo $sales_ref->rowAttributes() ?>>
<?php

// Render list options (body, left)
$sales_ref_list->ListOptions->render("body", "left", $sales_ref_list->RowCnt);
?>
	<?php if ($sales_ref->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $sales_ref->grp->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref_grp" class="sales_ref_grp">
<span<?php echo $sales_ref->grp->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->grp->getViewValue())) && $sales_ref->grp->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->grp->linkAttributes() ?>><?php echo $sales_ref->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sales_ref->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $sales_ref->s_grp->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref_s_grp" class="sales_ref_s_grp">
<span<?php echo $sales_ref->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->s_grp->getViewValue())) && $sales_ref->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->s_grp->linkAttributes() ?>><?php echo $sales_ref->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sales_ref->product->Visible) { // product ?>
		<td data-name="product"<?php echo $sales_ref->product->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref_product" class="sales_ref_product">
<span<?php echo $sales_ref->product->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->product->getViewValue())) && $sales_ref->product->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->product->linkAttributes() ?>><?php echo $sales_ref->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($sales_ref->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $sales_ref->rid->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref_rid" class="sales_ref_rid">
<span<?php echo $sales_ref->rid->viewAttributes() ?>>
<?php echo $sales_ref->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sales_ref->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $sales_ref->packets->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref_packets" class="sales_ref_packets">
<span<?php echo $sales_ref->packets->viewAttributes() ?>>
<?php echo $sales_ref->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sales_ref->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $sales_ref->quantity->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref_quantity" class="sales_ref_quantity">
<span<?php echo $sales_ref->quantity->viewAttributes() ?>>
<?php echo $sales_ref->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sales_ref->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $sales_ref->_40->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref__40" class="sales_ref__40">
<span<?php echo $sales_ref->_40->viewAttributes() ?>>
<?php echo $sales_ref->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sales_ref->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $sales_ref->amount->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref_amount" class="sales_ref_amount">
<span<?php echo $sales_ref->amount->viewAttributes() ?>>
<?php echo $sales_ref->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($sales_ref->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $sales_ref->godown->cellAttributes() ?>>
<span id="el<?php echo $sales_ref_list->RowCnt ?>_sales_ref_godown" class="sales_ref_godown">
<span<?php echo $sales_ref->godown->viewAttributes() ?>>
<?php if ((!EmptyString($sales_ref->godown->getViewValue())) && $sales_ref->godown->linkAttributes() <> "") { ?>
<a<?php echo $sales_ref->godown->linkAttributes() ?>><?php echo $sales_ref->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $sales_ref->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$sales_ref_list->ListOptions->render("body", "right", $sales_ref_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$sales_ref->isGridAdd())
		$sales_ref_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$sales_ref->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($sales_ref_list->Recordset)
	$sales_ref_list->Recordset->Close();
?>
<?php if (!$sales_ref->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$sales_ref->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sales_ref_list->Pager)) $sales_ref_list->Pager = new PrevNextPager($sales_ref_list->StartRec, $sales_ref_list->DisplayRecs, $sales_ref_list->TotalRecs, $sales_ref_list->AutoHidePager) ?>
<?php if ($sales_ref_list->Pager->RecordCount > 0 && $sales_ref_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sales_ref_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sales_ref_list->pageUrl() ?>start=<?php echo $sales_ref_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sales_ref_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sales_ref_list->pageUrl() ?>start=<?php echo $sales_ref_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sales_ref_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sales_ref_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sales_ref_list->pageUrl() ?>start=<?php echo $sales_ref_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sales_ref_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sales_ref_list->pageUrl() ?>start=<?php echo $sales_ref_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sales_ref_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($sales_ref_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $sales_ref_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $sales_ref_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $sales_ref_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($sales_ref_list->TotalRecs > 0 && (!$sales_ref_list->AutoHidePageSizeSelector || $sales_ref_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="sales_ref">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($sales_ref_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($sales_ref_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($sales_ref_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($sales_ref_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($sales_ref_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($sales_ref->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $sales_ref_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($sales_ref_list->TotalRecs == 0 && !$sales_ref->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $sales_ref_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$sales_ref_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$sales_ref->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$sales_ref->isExport()) { ?>
<script>
ew.scrollableTable("gmp_sales_ref", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$sales_ref_list->terminate();
?>